/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.mapper.DataConverter;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.ToNativeContext;

public final class HANDLE {
    public static final long INVALID_HANDLE_VALUE = -1L;
    private final Pointer pointer;
    public static final DataConverter<HANDLE, Pointer> Converter = new DataConverter<HANDLE, Pointer>(){

        @Override
        public final Pointer toNative(HANDLE value, ToNativeContext context) {
            if (value != null) {
                return value.pointer;
            }
            return null;
        }

        @Override
        public final HANDLE fromNative(Pointer nativeValue, FromNativeContext context) {
            if (nativeValue != null) {
                return new HANDLE(nativeValue);
            }
            return null;
        }

        @Override
        public final Class<Pointer> nativeType() {
            return Pointer.class;
        }
    };

    public HANDLE(Pointer pointer) {
        this.pointer = pointer;
    }

    public final Pointer toPointer() {
        return this.pointer;
    }

    public final boolean isValid() {
        return this.pointer.address() != (0xFFFFFFFFFFFFFFFFL & Runtime.getSystemRuntime().addressMask());
    }

    public static HANDLE valueOf(Pointer value) {
        return new HANDLE(value);
    }

    public static HANDLE valueOf(long value) {
        return new HANDLE(Runtime.getSystemRuntime().getMemoryManager().newPointer(value));
    }
}

