/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.common.EngineException;
import net.grinder.util.StreamCopier;

final class ProcessWorker
implements Worker {
    private final AgentIdentityImplementation.WorkerIdentityImplementation m_workerIdentity;
    private final Process m_process;
    private final Redirector m_stdoutRedirector;
    private final Redirector m_stderrRedirector;

    public ProcessWorker(AgentIdentityImplementation.WorkerIdentityImplementation workerIdentity, String[] commandArray, OutputStream outputStream, OutputStream errorStream) throws EngineException {
        this.m_workerIdentity = workerIdentity;
        try {
            this.m_process = Runtime.getRuntime().exec(commandArray);
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new EngineException("Could not start process", e);
        }
        this.m_stdoutRedirector = new Redirector(this.m_process.getInputStream(), outputStream);
        this.m_stderrRedirector = new Redirector(this.m_process.getErrorStream(), errorStream);
    }

    public WorkerIdentity getIdentity() {
        return this.m_workerIdentity;
    }

    public OutputStream getCommunicationStream() {
        return this.m_process.getOutputStream();
    }

    public int waitFor() {
        try {
            this.m_process.waitFor();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        finally {
            this.m_stdoutRedirector.stop();
            this.m_stderrRedirector.stop();
        }
        try {
            return this.m_process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void destroy() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        this.m_process.destroy();
    }

    private class Redirector {
        private final Thread m_thread;

        public Redirector(InputStream inputStream, OutputStream outputStream) {
            this.m_thread = new Thread(new StreamCopier(4096, false).getRunnable(inputStream, outputStream), "Stream redirector for process " + ProcessWorker.this.m_process);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }

        public void stop() {
            this.m_thread.interrupt();
            while (this.m_thread.isAlive()) {
                try {
                    this.m_thread.join();
                }
                catch (InterruptedException e) {
                    throw new UncheckedInterruptedException(e);
                }
            }
        }
    }
}

