/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import net.grinder.communication.BlockingSender;
import net.grinder.communication.ClientReceiver;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Connector;
import net.grinder.communication.Message;
import net.grinder.communication.MessageRequiringResponse;
import net.grinder.communication.NoResponseMessage;
import net.grinder.communication.SocketWrapper;
import net.grinder.communication.StreamReceiver;
import net.grinder.communication.StreamSender;

public final class ClientSender
extends StreamSender
implements BlockingSender {
    private final SocketWrapper m_socketWrapper;

    public static ClientSender connect(Connector connector) throws CommunicationException {
        return new ClientSender(new SocketWrapper(connector.connect()));
    }

    public static ClientSender connect(ClientReceiver clientReceiver) throws CommunicationException {
        return new ClientSender(clientReceiver.getSocketWrapper());
    }

    private ClientSender(SocketWrapper socketWrapper) throws CommunicationException {
        super(socketWrapper.getOutputStream());
        this.m_socketWrapper = socketWrapper;
    }

    public void shutdown() {
        this.m_socketWrapper.close();
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message blockingSend(Message message) throws CommunicationException {
        Message result;
        MessageRequiringResponse messageRequiringResponse = new MessageRequiringResponse(message);
        SocketWrapper socketWrapper = this.m_socketWrapper;
        synchronized (socketWrapper) {
            this.send(messageRequiringResponse);
            StreamReceiver receiver = new StreamReceiver(this.m_socketWrapper.getInputStream());
            result = receiver.waitForMessage();
        }
        if (result == null) {
            throw new CommunicationException("Shut down");
        }
        if (result instanceof NoResponseMessage) {
            throw new BlockingSender.NoResponseException("Server did not respond");
        }
        return result;
    }
}

