/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.MacOSFileStat;
import jnr.posix.MacOSPasswd;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.Times;

final class MacOSPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public final Object fromNative(Object arg, FromNativeContext ctx) {
            if (arg != null) {
                return new MacOSPasswd((Pointer)arg);
            }
            return null;
        }
    };

    MacOSPOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        super(libraryName, libcProvider, handler);
    }

    public final FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    public final int lchmod(String filename, int mode) {
        try {
            return this.libc().lchmod(filename, mode);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.handler.unimplementedError("lchmod");
            return -1;
        }
    }

    public final int lchown(String filename, int user, int group) {
        try {
            return super.lchown(filename, user, group);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.handler.unimplementedError("lchown");
            return -1;
        }
    }

    public final long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    public final Times times() {
        return NativeTimes.times(this);
    }
}

