/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class History {
    private List history = new ArrayList();
    private PrintWriter output = null;
    private int maxSize = 500;
    private int currentIndex = 0;

    public final void setHistoryFile(File historyFile) throws IOException {
        History history;
        Closeable closeable;
        if (historyFile.isFile()) {
            closeable = new FileInputStream(historyFile);
            history = this;
            history.load(new InputStreamReader((InputStream)closeable));
        }
        closeable = new PrintWriter((Writer)new FileWriter(historyFile), true);
        history = this;
        this.output = closeable;
        this.flushBuffer();
    }

    private void load(Reader reader) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = breader.readLine()) != null) {
            lines.add(line);
        }
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            this.addToHistory((String)i.next());
        }
    }

    public final void addToHistory(String buffer) {
        if (this.history.size() != 0 && buffer.equals(this.history.get(this.history.size() - 1))) {
            return;
        }
        this.history.add(buffer);
        while (true) {
            History history = this;
            if (this.history.size() <= history.maxSize) break;
            this.history.remove(0);
        }
        this.currentIndex = this.history.size();
        History history = this;
        if (history.output != null) {
            history = this;
            history.output.println(buffer);
            history = this;
            history.output.flush();
        }
    }

    private void flushBuffer() throws IOException {
        History history = this;
        if (history.output != null) {
            Iterator i = this.history.iterator();
            while (i.hasNext()) {
                history = this;
                history.output.println((String)i.next());
            }
            history = this;
            history.output.flush();
        }
    }

    public final boolean moveToLastEntry() {
        int lastEntry = this.history.size() - 1;
        if (lastEntry >= 0 && lastEntry != this.currentIndex) {
            this.currentIndex = this.history.size() - 1;
            return true;
        }
        return false;
    }

    public final void moveToEnd() {
        this.currentIndex = this.history.size();
    }

    public final String current() {
        if (this.currentIndex >= this.history.size()) {
            return "";
        }
        return (String)this.history.get(this.currentIndex);
    }

    public final boolean previous() {
        if (this.currentIndex <= 0) {
            return false;
        }
        --this.currentIndex;
        return true;
    }

    public final boolean next() {
        if (this.currentIndex >= this.history.size()) {
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    public final String toString() {
        return this.history.toString();
    }

    public final boolean moveToFirstEntry() {
        if (this.history.size() > 0 && this.currentIndex != 0) {
            this.currentIndex = 0;
            return true;
        }
        return false;
    }

    public final int searchBackwards(String searchTerm, int startIndex) {
        for (int i = startIndex - 1; i >= 0; --i) {
            History history = this;
            if (i >= history.history.size() || this.getHistory(i).indexOf(searchTerm) == -1) continue;
            return i;
        }
        return -1;
    }

    public final int searchBackwards(String s) {
        History history = this;
        return this.searchBackwards(s, history.currentIndex);
    }

    public final String getHistory(int index) {
        return (String)this.history.get(index);
    }

    public final void setCurrentIndex(int index) {
        if (index >= 0 && index < this.history.size()) {
            this.currentIndex = index;
        }
    }
}

