/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Serialiser {
    private final byte[] m_byteBuffer = new byte[8];

    public final void writeUnsignedLong(DataOutput output, long l) throws IOException {
        if (l < 0L) {
            throw new IOException("Negative argument");
        }
        if (l < 128L) {
            output.writeByte((byte)l);
        } else {
            output.writeLong(-l);
        }
    }

    public final long readUnsignedLong(DataInput input) throws IOException {
        this.m_byteBuffer[0] = input.readByte();
        if (this.m_byteBuffer[0] >= 0) {
            return this.m_byteBuffer[0];
        }
        input.readFully(this.m_byteBuffer, 1, 7);
        return -((long)(this.m_byteBuffer[0] & 0xFF) << 56 | (long)(this.m_byteBuffer[1] & 0xFF) << 48 | (long)(this.m_byteBuffer[2] & 0xFF) << 40 | (long)(this.m_byteBuffer[3] & 0xFF) << 32 | (long)(this.m_byteBuffer[4] & 0xFF) << 24 | (long)(this.m_byteBuffer[5] & 0xFF) << 16 | (long)(this.m_byteBuffer[6] & 0xFF) << 8 | (long)(this.m_byteBuffer[7] & 0xFF) << 0);
    }

    public final void writeLong(DataOutput output, long l) throws IOException {
        boolean startedToWrite = false;
        for (byte i = (byte)(this.m_byteBuffer.length - 1); i >= 0; i = (byte)(i - 1)) {
            byte b = (byte)(l >>> i * 8 & 0xFFL);
            if (startedToWrite) {
                output.writeByte(b);
                continue;
            }
            if ((b & 0xFF) == 0) continue;
            if ((b & 0xF0) != 0) {
                output.writeByte(i + 1 << 4);
                output.writeByte(b);
            } else {
                output.writeByte(b | i << 4);
            }
            startedToWrite = true;
        }
        if (!startedToWrite) {
            output.writeByte(0);
        }
    }

    public final long readLong(DataInput input) throws IOException {
        byte b = input.readByte();
        long length = (b & 0xF0) >>> 4;
        long result = b & 0xF;
        while (length-- > 0L) {
            result = result << 8 | (long)input.readUnsignedByte();
        }
        return result;
    }

    public final void writeDouble(DataOutput output, double l) throws IOException {
        output.writeDouble(l);
    }

    public final double readDouble(DataInput input) throws IOException {
        return input.readDouble();
    }
}

