/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http.tcpproxyfilter;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.common.GrinderBuild;
import net.grinder.common.Logger;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecording;
import net.grinder.plugin.http.tcpproxyfilter.HTTPRecordingResultProcessor;
import net.grinder.plugin.http.tcpproxyfilter.IntGenerator;
import net.grinder.plugin.http.tcpproxyfilter.RegularExpressions;
import net.grinder.plugin.http.xml.BaseURIType;
import net.grinder.plugin.http.xml.CommonHeadersType;
import net.grinder.plugin.http.xml.HTTPRecordingType;
import net.grinder.plugin.http.xml.HeaderType;
import net.grinder.plugin.http.xml.HeadersType;
import net.grinder.plugin.http.xml.HttpRecordingDocument;
import net.grinder.plugin.http.xml.PageType;
import net.grinder.plugin.http.xml.ParsedURIPartType;
import net.grinder.plugin.http.xml.RelativeURIType;
import net.grinder.plugin.http.xml.RequestType;
import net.grinder.plugin.http.xml.ResponseType;
import net.grinder.plugin.http.xml.TokenReferenceType;
import net.grinder.plugin.http.xml.TokenType;
import net.grinder.tools.tcpproxy.ConnectionDetails;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.util.URIParser;
import org.apache.xmlbeans.XmlObject;
import org.picocontainer.Disposable;

public class HTTPRecordingImplementation
implements HTTPRecording,
Disposable {
    private static final Set COMMON_HEADERS = new HashSet<String>(Arrays.asList("Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Cache-Control", "Referer", "User-Agent"));
    private final HttpRecordingDocument m_recordingDocument = HttpRecordingDocument.Factory.newInstance();
    private final Logger m_logger;
    private final HTTPRecordingResultProcessor m_resultProcessor;
    private final RegularExpressions m_regularExpressions;
    private final URIParser m_uriParser;
    private final IntGenerator m_bodyFileIDGenerator = new IntGenerator();
    private final BaseURLMap m_baseURLMap = new BaseURLMap();
    private final CommonHeadersMap m_commonHeadersMap = new CommonHeadersMap();
    private final RequestList m_requestList = new RequestList();
    private final TokenMap m_tokenMap = new TokenMap();
    private long m_lastResponseTime = 0L;

    public HTTPRecordingImplementation(HTTPRecordingResultProcessor resultProcessor, Logger logger, RegularExpressions regularExpressions, URIParser uriParser) {
        this.m_resultProcessor = resultProcessor;
        this.m_logger = logger;
        this.m_regularExpressions = regularExpressions;
        this.m_uriParser = uriParser;
        HTTPRecordingType.Metadata httpRecording = this.m_recordingDocument.addNewHttpRecording().addNewMetadata();
        httpRecording.setVersion("The Grinder " + GrinderBuild.getVersionString());
        httpRecording.setTime(Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestType addRequest(ConnectionDetails connectionDetails, String method, String relativeURI) {
        String element;
        String unescapedURI;
        RequestType request = this.m_requestList.add();
        request.setTime(Calendar.getInstance());
        HTTPRecordingImplementation hTTPRecordingImplementation = this;
        synchronized (hTTPRecordingImplementation) {
            long time;
            if (this.m_lastResponseTime > 0L && (time = System.currentTimeMillis() - this.m_lastResponseTime) > 10L) {
                request.setSleepTime(time);
            }
            this.m_lastResponseTime = 0L;
        }
        request.addNewHeaders();
        request.setMethod(RequestType.Method.Enum.forString((String)method));
        try {
            unescapedURI = URI.unescape(relativeURI, null);
        }
        catch (ParseException e) {
            unescapedURI = relativeURI;
        }
        Matcher lastPathElementMatcher = this.m_regularExpressions.getLastPathElementPathPattern().matcher(unescapedURI);
        String description = lastPathElementMatcher.find() ? ((element = lastPathElementMatcher.group(1)).trim().length() != 0 ? method + " " + element : method + " /") : method + " " + relativeURI;
        request.setDescription(description);
        RelativeURIType uri = request.addNewUri();
        uri.setUnparsed(unescapedURI);
        uri.setExtends(this.m_baseURLMap.getBaseURL(connectionDetails.isSecure() ? BaseURIType.Scheme.HTTPS : BaseURIType.Scheme.HTTP, connectionDetails.getRemoteEndPoint()).getUriId());
        final ParsedURIPartType parsedPath = uri.addNewPath();
        final ParsedURIPartType parsedQueryString = uri.addNewQueryString();
        final String[] fragment = new String[1];
        this.m_uriParser.parse(relativeURI, new URIParser.AbstractParseListener(){

            public boolean path(String path) {
                parsedPath.addText(path);
                return true;
            }

            public boolean pathParameterNameValue(String name, String value) {
                HTTPRecordingImplementation.this.setTokenReference(name, value, parsedPath.addNewTokenReference());
                return true;
            }

            public boolean queryString(String queryString) {
                parsedQueryString.addText(queryString);
                return true;
            }

            public boolean queryStringNameValue(String name, String value) {
                HTTPRecordingImplementation.this.setTokenReference(name, value, parsedQueryString.addNewTokenReference());
                return true;
            }

            public boolean fragment(String theFragment) {
                fragment[0] = theFragment;
                return true;
            }
        });
        if (parsedQueryString.getTokenReferenceArray().length == 0 && parsedQueryString.getTextArray().length == 0) {
            uri.unsetQueryString();
        }
        if (fragment[0] != null) {
            uri.setFragment(fragment[0]);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markLastResponseTime() {
        HTTPRecordingImplementation hTTPRecordingImplementation = this;
        synchronized (hTTPRecordingImplementation) {
            this.m_lastResponseTime = System.currentTimeMillis();
        }
    }

    public void setTokenReference(String name, String value, TokenReferenceType tokenReference) {
        this.m_tokenMap.add(name, value, tokenReference);
    }

    public String getLastValueForToken(String name) {
        return this.m_tokenMap.getLastValue(name);
    }

    public boolean tokenReferenceExists(String name, String source) {
        return this.m_tokenMap.exists(name, source);
    }

    public File createBodyDataFileName() {
        return new File("http-data-" + this.m_bodyFileIDGenerator.next() + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HttpRecordingDocument result;
        HttpRecordingDocument httpRecordingDocument = this.m_recordingDocument;
        synchronized (httpRecordingDocument) {
            result = (HttpRecordingDocument)this.m_recordingDocument.copy();
        }
        this.m_requestList.record(result.getHttpRecording());
        CommonHeadersType[] commonHeaders = result.getHttpRecording().getCommonHeadersArray();
        HashMap<String, String> defaultHeaders = new HashMap<String, String>();
        HashSet<String> notDefaultHeaders = new HashSet<String>();
        for (int i = 0; i < commonHeaders.length; ++i) {
            HeaderType[] headers = commonHeaders[i].getHeaderArray();
            for (int j = 0; j < headers.length; ++j) {
                String existing;
                String name = headers[j].getName();
                String value = headers[j].getValue();
                if (notDefaultHeaders.contains(name) || ((existing = defaultHeaders.put(name, value)) == null || value.equals(existing)) && (existing != null || i <= 0)) continue;
                defaultHeaders.remove(name);
                notDefaultHeaders.add(name);
            }
        }
        if (defaultHeaders.size() > 0) {
            CommonHeadersType[] newCommonHeaders = new CommonHeadersType[commonHeaders.length + 1];
            System.arraycopy(commonHeaders, 0, newCommonHeaders, 1, commonHeaders.length);
            String defaultHeadersID = "defaultHeaders";
            newCommonHeaders[0] = CommonHeadersType.Factory.newInstance();
            newCommonHeaders[0].setHeadersId("defaultHeaders");
            Iterator iterator = defaultHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                HeaderType header = newCommonHeaders[0].addNewHeader();
                header.setName((String)entry.getKey());
                header.setValue((String)entry.getValue());
            }
            for (int i = 0; i < commonHeaders.length; ++i) {
                HeaderType[] headers = commonHeaders[i].getHeaderArray();
                for (int j = headers.length - 1; j >= 0; --j) {
                    if (!defaultHeaders.containsKey(headers[j].getName())) continue;
                    commonHeaders[i].removeHeader(j);
                }
                commonHeaders[i].setExtends("defaultHeaders");
            }
            result.getHttpRecording().setCommonHeadersArray(newCommonHeaders);
        }
        try {
            this.m_resultProcessor.process(result);
        }
        catch (IOException e) {
            this.m_logger.error(e.getMessage());
            e.printStackTrace(this.m_logger.getErrorLogWriter());
        }
    }

    private static final class TokenLastValuePair {
        private final TokenType m_token;
        private final Set m_sources = new HashSet();
        private String m_lastValue;

        public TokenLastValuePair(TokenType token) {
            this.m_token = token;
        }

        public TokenType getToken() {
            return this.m_token;
        }

        public void setLastValue(String lastValue) {
            this.m_lastValue = lastValue;
        }

        public String getLastValue() {
            return this.m_lastValue;
        }

        public void addSource(String source) {
            this.m_sources.add(source);
        }

        public boolean hasAReferenceWithSource(String source) {
            return this.m_sources.contains(source);
        }
    }

    private final class TokenMap {
        private final Map m_map = new HashMap();
        private final Map m_uniqueTokenIDs = new HashMap();

        private TokenMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String name, String value, TokenReferenceType tokenReference) {
            TokenLastValuePair tokenValuePair;
            Map map = this.m_map;
            synchronized (map) {
                TokenLastValuePair existing = (TokenLastValuePair)this.m_map.get(name);
                if (existing == null) {
                    TokenType newToken;
                    HttpRecordingDocument httpRecordingDocument = HTTPRecordingImplementation.this.m_recordingDocument;
                    synchronized (httpRecordingDocument) {
                        newToken = HTTPRecordingImplementation.this.m_recordingDocument.getHttpRecording().addNewToken();
                    }
                    StringBuffer tokenID = new StringBuffer();
                    tokenID.append("token_");
                    for (int i = 0; i < name.length(); ++i) {
                        char c = name.charAt(i);
                        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') && c != '_') continue;
                        tokenID.append(c);
                    }
                    String partToken = tokenID.toString();
                    Integer existingValue = (Integer)this.m_uniqueTokenIDs.get(partToken);
                    if (existingValue != null) {
                        tokenID.append(existingValue);
                        this.m_uniqueTokenIDs.put(partToken, new Integer(existingValue + 1));
                    } else {
                        this.m_uniqueTokenIDs.put(partToken, new Integer(2));
                    }
                    newToken.setTokenId(tokenID.toString());
                    newToken.setName(name);
                    tokenValuePair = new TokenLastValuePair(newToken);
                    this.m_map.put(name, tokenValuePair);
                } else {
                    tokenValuePair = existing;
                }
            }
            tokenReference.setTokenId(tokenValuePair.getToken().getTokenId());
            if (!value.equals(tokenValuePair.getLastValue())) {
                tokenReference.setNewValue(value);
                tokenValuePair.setLastValue(value);
            }
            tokenValuePair.addSource(tokenReference.getSource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLastValue(String name) {
            TokenLastValuePair existing;
            Map map = this.m_map;
            synchronized (map) {
                existing = (TokenLastValuePair)this.m_map.get(name);
            }
            return existing != null ? existing.getLastValue() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean exists(String name, String source) {
            TokenLastValuePair existing;
            Map map = this.m_map;
            synchronized (map) {
                existing = (TokenLastValuePair)this.m_map.get(name);
            }
            return existing != null && existing.hasAReferenceWithSource(source);
        }
    }

    private final class RequestList {
        private final List m_requests = new ArrayList();
        private final Pattern m_resourcePathPattern = Pattern.compile(".*(?:\\.css|\\.gif|\\.ico|\\.jpe?g|\\.js|\\.png)(?:\\?.*)?$", 2);

        private RequestList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestType add() {
            RequestType request = RequestType.Factory.newInstance();
            List list = this.m_requests;
            synchronized (list) {
                this.m_requests.add(request);
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(HTTPRecordingType httpRecording) {
            List list = this.m_requests;
            synchronized (list) {
                Iterator iterator = this.m_requests.iterator();
                String lastBaseURI = null;
                boolean lastResponseWasRedirect = false;
                PageType currentPage = null;
                while (iterator.hasNext()) {
                    RequestType request = (RequestType)iterator.next();
                    ResponseType response = request.getResponse();
                    if (response == null) continue;
                    HTTPRecordingImplementation.this.m_commonHeadersMap.extractCommonHeaders(httpRecording, request);
                    HttpRecordingDocument httpRecordingDocument = HTTPRecordingImplementation.this.m_recordingDocument;
                    synchronized (httpRecordingDocument) {
                        if (!request.getUri().getExtends().equals(lastBaseURI) || request.isSetBody() || !this.m_resourcePathPattern.matcher(request.getUri().getUnparsed()).matches() && !lastResponseWasRedirect || currentPage == null) {
                            currentPage = httpRecording.addNewPage();
                        }
                        lastBaseURI = request.getUri().getExtends();
                        switch (response.getStatusCode()) {
                            case 301: 
                            case 302: 
                            case 307: {
                                lastResponseWasRedirect = true;
                                request.setAnnotation("Expecting " + response.getStatusCode() + " '" + response.getReasonPhrase() + "'");
                                break;
                            }
                            default: {
                                lastResponseWasRedirect = false;
                            }
                        }
                        currentPage.addNewRequest().set((XmlObject)request);
                    }
                }
            }
        }
    }

    private static final class CommonHeadersMap {
        private final Map m_map = new HashMap();
        private final IntGenerator m_idGenerator = new IntGenerator();

        private CommonHeadersMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extractCommonHeaders(HTTPRecordingType httpRecording, RequestType request) {
            CommonHeadersType commonHeaders = CommonHeadersType.Factory.newInstance();
            HeadersType newRequestHeaders = HeadersType.Factory.newInstance();
            XmlObject[] children = request.getHeaders().selectPath("./*");
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof HeaderType) {
                    HeaderType header = (HeaderType)children[i];
                    if (COMMON_HEADERS.contains(header.getName())) {
                        commonHeaders.addNewHeader().set((XmlObject)header);
                        continue;
                    }
                    newRequestHeaders.addNewHeader().set((XmlObject)header);
                    continue;
                }
                newRequestHeaders.addNewAuthorization().set(children[i]);
            }
            String key = Arrays.asList(commonHeaders.getHeaderArray()).toString();
            Map map = this.m_map;
            synchronized (map) {
                CommonHeadersType existing = (CommonHeadersType)this.m_map.get(key);
                if (existing != null) {
                    newRequestHeaders.setExtends(existing.getHeadersId());
                } else {
                    commonHeaders.setHeadersId("headers" + this.m_idGenerator.next());
                    httpRecording.addNewCommonHeaders().set((XmlObject)commonHeaders);
                    this.m_map.put(key, commonHeaders);
                    newRequestHeaders.setExtends(commonHeaders.getHeadersId());
                }
            }
            request.setHeaders(newRequestHeaders);
        }
    }

    private final class BaseURLMap {
        private final Map m_map = new HashMap();
        private final IntGenerator m_idGenerator = new IntGenerator();

        private BaseURLMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BaseURIType getBaseURL(BaseURIType.Scheme.Enum scheme, EndPoint endPoint) {
            String key = scheme.toString() + "://" + endPoint;
            Map map = this.m_map;
            synchronized (map) {
                BaseURIType result;
                BaseURIType existing = (BaseURIType)this.m_map.get(key);
                if (existing != null) {
                    return existing;
                }
                HttpRecordingDocument httpRecordingDocument = HTTPRecordingImplementation.this.m_recordingDocument;
                synchronized (httpRecordingDocument) {
                    result = HTTPRecordingImplementation.this.m_recordingDocument.getHttpRecording().addNewBaseUri();
                }
                result.setUriId("url" + this.m_idGenerator.next());
                result.setScheme(scheme);
                result.setHost(endPoint.getHost());
                result.setPort(endPoint.getPort());
                this.m_map.put(key, result);
                return result;
            }
        }
    }
}

