/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.grinder.common.Logger;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.engine.common.EngineException;
import net.grinder.messages.agent.CacheHighWaterMark;
import net.grinder.messages.agent.ClearCacheMessage;
import net.grinder.messages.agent.DistributeFileMessage;
import net.grinder.messages.agent.DistributionCacheCheckpointMessage;
import net.grinder.util.Directory;
import net.grinder.util.FileContents;
import net.grinder.util.StreamCopier;

final class FileStore {
    private final Logger m_logger;
    private final File m_readmeFile;
    private final Directory m_incomingDirectory;
    private final Directory m_currentDirectory;
    private boolean m_incremental;
    private volatile CacheHighWaterMark m_cacheHighWaterMark = new OutOfDateCacheHighWaterMark();

    public FileStore(File directory, Logger logger) throws FileStoreException {
        File rootDirectory = directory.getAbsoluteFile();
        this.m_logger = logger;
        if (rootDirectory.exists()) {
            if (!rootDirectory.isDirectory()) {
                throw new FileStoreException("Could not write to directory '" + rootDirectory + "' as file with that name already exists");
            }
            if (!rootDirectory.canWrite()) {
                throw new FileStoreException("Could not write to directory '" + rootDirectory + "'");
            }
        }
        this.m_readmeFile = new File(rootDirectory, "README.txt");
        try {
            this.m_incomingDirectory = new Directory(new File(rootDirectory, "incoming"));
            this.m_currentDirectory = new Directory(new File(rootDirectory, "current"));
        }
        catch (Directory.DirectoryException e) {
            throw new FileStoreException(e.getMessage(), e);
        }
        this.m_incremental = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory getDirectory() throws FileStoreException {
        try {
            Directory directory = this.m_incomingDirectory;
            synchronized (directory) {
                if (this.m_incomingDirectory.getFile().exists()) {
                    this.m_incomingDirectory.copyTo(this.m_currentDirectory, this.m_incremental);
                }
                this.m_incremental = true;
            }
            return this.m_currentDirectory;
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new FileStoreException("Could not create file store directory", e);
        }
    }

    public CacheHighWaterMark getCacheHighWaterMark() {
        return this.m_cacheHighWaterMark;
    }

    public void registerMessageHandlers(MessageDispatchRegistry messageDispatcher) {
        messageDispatcher.set(ClearCacheMessage.class, new MessageDispatchRegistry.AbstractHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void send(Message message) throws CommunicationException {
                FileStore.this.m_logger.output("Clearing file store");
                try {
                    Directory directory = FileStore.this.m_incomingDirectory;
                    synchronized (directory) {
                        FileStore.this.m_incomingDirectory.deleteContents();
                        FileStore.this.m_incremental = false;
                    }
                }
                catch (Directory.DirectoryException e) {
                    FileStore.this.m_logger.error(e.getMessage());
                    throw new CommunicationException(e.getMessage(), e);
                }
            }
        });
        messageDispatcher.set(DistributeFileMessage.class, new MessageDispatchRegistry.AbstractHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void send(Message message) throws CommunicationException {
                try {
                    Directory directory = FileStore.this.m_incomingDirectory;
                    synchronized (directory) {
                        FileStore.this.m_incomingDirectory.create();
                        FileStore.this.createReadmeFile();
                        FileContents fileContents = ((DistributeFileMessage)message).getFileContents();
                        FileStore.this.m_logger.output("Updating file store: " + fileContents);
                        fileContents.create(FileStore.this.m_incomingDirectory);
                    }
                }
                catch (FileContents.FileContentsException e) {
                    FileStore.this.m_logger.error(e.getMessage());
                    throw new CommunicationException(e.getMessage(), e);
                }
                catch (Directory.DirectoryException e) {
                    FileStore.this.m_logger.error(e.getMessage());
                    throw new CommunicationException(e.getMessage(), e);
                }
            }
        });
        messageDispatcher.set(DistributionCacheCheckpointMessage.class, new MessageDispatchRegistry.AbstractHandler(){

            public void send(Message message) throws CommunicationException {
                FileStore.this.m_cacheHighWaterMark = ((DistributionCacheCheckpointMessage)message).getCacheHighWaterMark();
            }
        });
    }

    private void createReadmeFile() throws CommunicationException {
        if (!this.m_readmeFile.exists()) {
            try {
                new StreamCopier(4096, true).copy(this.getClass().getResourceAsStream("resources/FileStoreReadme.txt"), new FileOutputStream(this.m_readmeFile));
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                this.m_logger.error(e.getMessage());
                throw new CommunicationException(e.getMessage(), e);
            }
        }
    }

    private static final class OutOfDateCacheHighWaterMark
    implements CacheHighWaterMark {
        private OutOfDateCacheHighWaterMark() {
        }

        public long getTime() {
            return -1L;
        }

        public boolean isForSameCache(CacheHighWaterMark other) {
            return false;
        }
    }

    public static final class FileStoreException
    extends EngineException {
        FileStoreException(String message) {
            super(message);
        }

        FileStoreException(String message, Throwable e) {
            super(message, e);
        }
    }
}

