/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import net.grinder.communication.AbstractSender;
import net.grinder.communication.Address;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.ResourcePool;
import net.grinder.util.thread.Executor;
import net.grinder.util.thread.InterruptibleRunnable;

abstract class AbstractFanOutSender
extends AbstractSender {
    private final Executor m_executor;
    private final ResourcePool m_resourcePool;

    protected AbstractFanOutSender(Executor executor, ResourcePool resourcePool) {
        this.m_executor = executor;
        this.m_resourcePool = resourcePool;
    }

    protected final void writeMessage(Message message) throws CommunicationException {
        this.writeAddressedMessage(new SendToEveryoneAddress(), message);
    }

    protected final void writeAddressedMessage(Address address, Message message) throws CommunicationException {
        try {
            Iterator iterator = this.m_resourcePool.reserveAll().iterator();
            while (iterator.hasNext()) {
                ResourcePool.Reservation reservation = (ResourcePool.Reservation)iterator.next();
                ResourcePool.Resource resource = reservation.getResource();
                if (!address.includes(this.getAddress(resource))) {
                    reservation.free();
                    continue;
                }
                this.m_executor.execute(new WriteMessageToStream(message, this.resourceToOutputStream(resource), reservation));
            }
        }
        catch (Executor.ShutdownException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract OutputStream resourceToOutputStream(ResourcePool.Resource var1) throws CommunicationException;

    protected abstract Address getAddress(ResourcePool.Resource var1);

    protected final ResourcePool getResourcePool() {
        return this.m_resourcePool;
    }

    public void shutdown() {
        super.shutdown();
        this.m_executor.gracefulShutdown();
    }

    private static final class WriteMessageToStream
    implements InterruptibleRunnable {
        private final Message m_message;
        private final OutputStream m_outputStream;
        private final ResourcePool.Reservation m_reservation;

        public WriteMessageToStream(Message message, OutputStream outputStream, ResourcePool.Reservation reservation) {
            this.m_message = message;
            this.m_outputStream = outputStream;
            this.m_reservation = reservation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptibleRun() {
            try {
                AbstractSender.writeMessageToStream(this.m_message, this.m_outputStream);
            }
            catch (IOException e) {
                this.m_reservation.close();
            }
            finally {
                this.m_reservation.free();
            }
        }
    }

    private static final class SendToEveryoneAddress
    implements Address {
        private SendToEveryoneAddress() {
        }

        public boolean includes(Address address) {
            return true;
        }
    }
}

