/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NName
extends NNode {
    public final String id;

    public NName(String id) {
        this(id, 0, 1);
    }

    public NName(String id, int start, int end) {
        super(start, end);
        if (id == null) {
            throw new IllegalArgumentException("'id' param cannot be null");
        }
        this.id = id;
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NBinding b = s.lookup(this.id);
        if (b == null) {
            Scope scope = s;
            NName nName = this;
            Scope scope2 = scope.getScopeSymtab();
            NBinding nBinding = scope2.put(nName.id, nName, new NUnknownType(), NBinding.Kind.SCOPE);
            NType nType = nBinding.getType();
            nName.setType(NUnknownType.follow(nType));
            nName.getTable().setPath(scope2.extendPath(nName.id));
            b = nBinding;
        }
        Indexer.idx.putLocation(this, b);
        return this.setType(b.followType());
    }

    @Override
    public final boolean isCall() {
        NNode gramps;
        if (this.parent != null && this.parent.isCall() && this == ((NCall)this.parent).func) {
            return true;
        }
        return this.parent instanceof NAttribute && this == ((NAttribute)this.parent).attr && (gramps = this.parent.parent) instanceof NCall && this.parent == ((NCall)gramps).func;
    }

    public final String toString() {
        return "<Name:" + this.start() + ":" + this.id + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        v.visit(this);
    }
}

