/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.ObjectParameterInfo;
import com.kenai.jffi.ObjectParameterStrategy;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BaseMethodGenerator;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.LocalVariable;
import jnr.ffi.provider.jffi.LocalVariableAllocator;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.PointerParameterStrategy;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.python.objectweb.asm.Label;

abstract class AbstractFastNumericMethodGenerator
extends BaseMethodGenerator {
    private final BufferMethodGenerator bufgen;
    private static Set<Class> pointerTypes = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Pointer.class, CharSequence.class, ByteBuffer.class, ShortBuffer.class, IntBuffer.class, LongBuffer.class, FloatBuffer.class, DoubleBuffer.class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class)));

    public AbstractFastNumericMethodGenerator(BufferMethodGenerator bufgen) {
        this.bufgen = bufgen;
    }

    private void emitNumericParameter(SkinnyMethodAdapter mv, Class javaType, NativeType nativeType) {
        Class nativeIntType = this.getInvokerType();
        if (Float.class == javaType || Float.TYPE == javaType) {
            if (!javaType.isPrimitive()) {
                AsmUtil.unboxNumber(mv, javaType, Float.TYPE);
            }
            mv.invokestatic(Float.class, "floatToRawIntBits", Integer.TYPE, Float.TYPE);
            NumberUtil.widen(mv, Integer.TYPE, nativeIntType);
            return;
        }
        if (Double.class == javaType || Double.TYPE == javaType) {
            if (!javaType.isPrimitive()) {
                AsmUtil.unboxNumber(mv, javaType, Double.TYPE);
            }
            mv.invokestatic(Double.class, "doubleToRawLongBits", Long.TYPE, Double.TYPE);
            return;
        }
        if (javaType.isPrimitive()) {
            NumberUtil.convertPrimitive(mv, javaType, nativeIntType, nativeType);
            return;
        }
        if (Number.class.isAssignableFrom(javaType)) {
            AsmUtil.unboxNumber(mv, javaType, nativeIntType, nativeType);
            return;
        }
        if (Boolean.class.isAssignableFrom(javaType)) {
            AsmUtil.unboxBoolean(mv, javaType, nativeIntType);
            return;
        }
        throw new IllegalArgumentException("unsupported numeric type " + javaType);
    }

    public void generate(AsmBuilder builder, SkinnyMethodAdapter mv, LocalVariableAllocator localVariableAllocator, Function function, ResultType resultType, ParameterType[] parameterTypes, boolean ignoreError) {
        Class<Float> nativeIntType = this.getInvokerType();
        LocalVariable objCount = localVariableAllocator.allocate(Integer.TYPE);
        LocalVariable[] parameters = AsmUtil.getParameterVariables(parameterTypes);
        LocalVariable[] pointers = new LocalVariable[parameterTypes.length];
        LocalVariable[] strategies = new LocalVariable[parameterTypes.length];
        LocalVariable[] converted = new LocalVariable[parameterTypes.length];
        int pointerCount = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class javaParameterType;
            AbstractFastNumericMethodGenerator.loadAndConvertParameter(builder, mv, parameters[i], parameterTypes[i]);
            if (parameterTypes[i].toNativeConverter instanceof ToNativeConverter.PostInvocation) {
                mv.dup();
                converted[i] = localVariableAllocator.allocate(Object.class);
                mv.astore(converted[i]);
            }
            if (Pointer.class.isAssignableFrom(javaParameterType = parameterTypes[i].effectiveJavaType()) && AsmUtil.isDelegate(parameterTypes[i])) {
                AsmUtil.unboxPointer(mv, nativeIntType);
                continue;
            }
            if (Pointer.class.isAssignableFrom(javaParameterType) || Struct.class.isAssignableFrom(javaParameterType) || String.class == javaParameterType || CharSequence.class == javaParameterType || ByteBuffer.class.isAssignableFrom(javaParameterType) || ShortBuffer.class.isAssignableFrom(javaParameterType) || IntBuffer.class.isAssignableFrom(javaParameterType) || LongBuffer.class.isAssignableFrom(javaParameterType) && NumberUtil.sizeof(NativeType.SLONG) == 8 || FloatBuffer.class.isAssignableFrom(javaParameterType) || DoubleBuffer.class.isAssignableFrom(javaParameterType) || byte[].class == javaParameterType || short[].class == javaParameterType || int[].class == javaParameterType || long[].class == javaParameterType && NumberUtil.sizeof(NativeType.SLONG) == 8 || float[].class == javaParameterType || double[].class == javaParameterType) {
                if (pointerCount++ <= 0) {
                    mv.pushInt(0);
                    mv.istore(objCount);
                }
                if (parameterTypes[i].toNativeConverter != null) {
                    pointers[i] = localVariableAllocator.allocate(Object.class);
                    mv.astore(pointers[i]);
                    mv.aload(pointers[i]);
                } else {
                    pointers[i] = parameters[i];
                }
                AbstractFastNumericMethodGenerator.emitPointerParameterStrategyLookup(mv, javaParameterType, parameterTypes[i].annotations);
                strategies[i] = localVariableAllocator.allocate(ObjectParameterStrategy.class);
                mv.astore(strategies[i]);
                mv.aload(strategies[i]);
                mv.getfield(CodegenUtils.p(PointerParameterStrategy.class), "objectCount", CodegenUtils.ci(Integer.TYPE));
                mv.iload(objCount);
                mv.iadd();
                mv.istore(objCount);
                if (CharSequence.class.isAssignableFrom(javaParameterType) || javaParameterType.isArray() && javaParameterType.getComponentType().isPrimitive()) {
                    if (Integer.TYPE == nativeIntType) {
                        mv.iconst_0();
                        continue;
                    }
                    mv.lconst_0();
                    continue;
                }
                mv.aload(strategies[i]);
                mv.aload(pointers[i]);
                mv.invokevirtual(PointerParameterStrategy.class, "address", Long.TYPE, Object.class);
                NumberUtil.narrow(mv, Long.TYPE, nativeIntType);
                continue;
            }
            this.emitNumericParameter(mv, javaParameterType, parameterTypes[i].nativeType);
        }
        Label hasObjects = new Label();
        Label convertResult = new Label();
        if (pointerCount > 0) {
            mv.iload(objCount);
            mv.ifne(hasObjects);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), this.getInvokerMethodName$5974725e(parameterTypes), this.getInvokerSignature$15ec99b1(parameterTypes.length));
        if (pointerCount > 0) {
            mv.label(convertResult);
        }
        AbstractFastNumericMethodGenerator.emitPostInvoke(builder, mv, parameterTypes, parameters, converted);
        Class javaReturnType = resultType.effectiveJavaType();
        Class<Number> nativeReturnType = nativeIntType;
        if (Float.class == javaReturnType || Float.TYPE == javaReturnType) {
            NumberUtil.narrow(mv, nativeIntType, Integer.TYPE);
            mv.invokestatic(Float.class, "intBitsToFloat", Float.TYPE, Integer.TYPE);
            nativeReturnType = Float.TYPE;
        } else if (Double.class == javaReturnType || Double.TYPE == javaReturnType) {
            NumberUtil.widen(mv, nativeIntType, Long.TYPE);
            mv.invokestatic(Double.class, "longBitsToDouble", Double.TYPE, Long.TYPE);
            nativeReturnType = Double.TYPE;
        }
        Class unboxedResultType = AsmUtil.unboxedReturnType(javaReturnType);
        NumberUtil.convertPrimitive(mv, nativeReturnType, unboxedResultType, resultType.nativeType);
        AbstractFastNumericMethodGenerator.convertAndReturnResult(builder, mv, resultType, unboxedResultType);
        if (pointerCount > 0) {
            mv.label(hasObjects);
            if (Integer.TYPE == nativeIntType) {
                int i;
                LocalVariable[] tmp = new LocalVariable[parameterTypes.length];
                for (i = parameterTypes.length - 1; i > 0; --i) {
                    tmp[i] = localVariableAllocator.allocate(Integer.TYPE);
                    mv.istore(tmp[i]);
                }
                if (parameterTypes.length > 0) {
                    mv.i2l();
                }
                for (i = 1; i < parameterTypes.length; ++i) {
                    mv.iload(tmp[i]);
                    mv.i2l();
                }
            }
            mv.iload(objCount);
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (pointers[i] == null) continue;
                mv.aload(pointers[i]);
                mv.aload(strategies[i]);
                mv.aload(0);
                ObjectParameterInfo info = ObjectParameterInfo.create(i, AsmUtil.getNativeArrayFlags(parameterTypes[i].annotations));
                mv.getfield(builder.getClassNamePath(), builder.getObjectParameterInfoName(info), CodegenUtils.ci(ObjectParameterInfo.class));
            }
            mv.invokevirtual(CodegenUtils.p(Invoker.class), AbstractFastNumericMethodGenerator.getObjectParameterMethodName(parameterTypes.length), AbstractFastNumericMethodGenerator.getObjectParameterMethodSignature(parameterTypes.length, pointerCount));
            NumberUtil.narrow(mv, Long.TYPE, nativeIntType);
            mv.go_to(convertResult);
        }
    }

    static void emitPointerParameterStrategyLookup(SkinnyMethodAdapter mv, Class javaParameterType, Annotation[] annotations) {
        boolean converted = false;
        for (Class c : pointerTypes) {
            if (!c.isAssignableFrom(javaParameterType)) continue;
            mv.invokestatic(AsmRuntime.class, "pointerParameterStrategy", PointerParameterStrategy.class, c);
            converted = true;
        }
        if (converted) {
            return;
        }
        if (Struct.class.isAssignableFrom(javaParameterType)) {
            if (ParameterFlags.isDirect(AsmUtil.getParameterFlags(annotations))) {
                mv.invokestatic(AsmRuntime.class, "directStructParameterStrategy", PointerParameterStrategy.class, Struct.class);
                return;
            }
            mv.invokestatic(AsmRuntime.class, "structParameterStrategy", PointerParameterStrategy.class, Struct.class);
            return;
        }
        throw new RuntimeException("no strategy for " + javaParameterType);
    }

    static String getObjectParameterMethodName(int parameterCount) {
        return "invokeN" + parameterCount;
    }

    static String getObjectParameterMethodSignature(int parameterCount, int pointerCount) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
        for (int i = 0; i < parameterCount; ++i) {
            sb.append('J');
        }
        sb.append('I');
        for (int n = 0; n < pointerCount; ++n) {
            sb.append(CodegenUtils.ci(Object.class));
            sb.append(CodegenUtils.ci(ObjectParameterStrategy.class));
            sb.append(CodegenUtils.ci(ObjectParameterInfo.class));
        }
        sb.append(")J");
        return sb.toString();
    }

    abstract String getInvokerMethodName$5974725e(ParameterType[] var1);

    abstract String getInvokerSignature$15ec99b1(int var1);

    abstract Class getInvokerType();

    static boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        return Boolean.valueOf(System.getProperty(propertyName, Boolean.valueOf(true).toString()));
    }
}

