// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
using System;
using System.Reflection;

/// <summary>
/// System.Reflection.FiledAttributes.SpecialName [v-jiajul]
/// </summary>
public class FieldAttributesSpecialName
{
    #region Public Methods
    public bool RunTests()
    {
        bool retVal = true;

        TestLibrary.TestFramework.LogInformation("[Positive]");
        retVal = PosTest1() && retVal;

        return retVal;
    }

    #region Positive Test Cases
    public bool PosTest1()
    {
        bool retVal = true;

        TestLibrary.TestFramework.BeginScenario("PosTest1: Check the Int32 value of the enumeration");

        try
        {
            FieldAttributes fieldAttributes = (FieldAttributes)512;
            if (fieldAttributes != FieldAttributes.SpecialName)
            {
                TestLibrary.TestFramework.LogError("001", "Result is not the value as expected,fieldAttributes is: " + fieldAttributes.ToString());
                retVal = false;
            }
        }
        catch (Exception e)
        {
            TestLibrary.TestFramework.LogError("002", "Unexpected exception: " + e);
            retVal = false;
        }

        return retVal;
    }
    #endregion

    #region Nagetive Test Cases
    #endregion
    #endregion

    public static int Main()
    {
        FieldAttributesSpecialName test = new FieldAttributesSpecialName();

        TestLibrary.TestFramework.BeginTestCase("FieldAttributesSpecialName");

        if (test.RunTests())
        {
            TestLibrary.TestFramework.EndTestCase();
            TestLibrary.TestFramework.LogInformation("PASS");
            return 100;
        }
        else
        {
            TestLibrary.TestFramework.EndTestCase();
            TestLibrary.TestFramework.LogInformation("FAIL");
            return 0;
        }
    }
}
