#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
JSON_NET_SOURCES=$SOURCE_ROOT/Newtonsoft.Json
DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet
ADD_PUBLIC_SIGN_CMD_PATH=$REPO_ROOT/tools/AddPublicSignToProjectJson/AddPublicSignToProjectJson.dll
SET_VERSION_CMD_PATH=$REPO_ROOT/tools/SetProjectJsonVersion/SetProjectJsonVersion.dll
ADD_CONSTANTS_CMD_PATH=$REPO_ROOT/tools/AddConstantsToProjectJson/AddConstantsToProjectJson.dll

PROJECT_JSON_VERSION=9.0.0
ASSEMBLY_VERSION=9.0.0.0
ASSEMBLY_FILE_VERSION=9.0.1.19813

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1
export NUGET_PACKAGES=$JSON_NET_SOURCES/packages

pushd $JSON_NET_SOURCES

grep -r -l 'AssemblyVersion(".*")' Src/ | xargs sed -i "s/AssemblyVersion(\".*\")/AssemblyVersion(\"$ASSEMBLY_VERSION\")/g"
grep -r -l 'AssemblyFileVersion(".*")' Src/ | xargs sed -i "s/AssemblyFileVersion(\".*\")/AssemblyFileVersion(\"$ASSEMBLY_FILE_VERSION\")/g"

$DOTNET_CMD $ADD_PUBLIC_SIGN_CMD_PATH Src/Newtonsoft.Json/project.json $REPO_ROOT/snks/Newtonsoft.Json.snk
$DOTNET_CMD $SET_VERSION_CMD_PATH Src/Newtonsoft.Json/project.json "9.0.1"
$DOTNET_CMD $ADD_CONSTANTS_CMD_PATH Src/Newtonsoft.Json/project.json "CODE_ANALYSIS;TRACE;dotnet;SIGNED"

$DOTNET_CMD restore Src/Newtonsoft.Json/project.json
$DOTNET_CMD build -c Release -f netstandard1.0 Src/Newtonsoft.Json/project.json
$DOTNET_CMD pack --no-build -c Release Src/Newtonsoft.Json/project.json -o Binaries/

cp Binaries/*.nupkg $REPO_ROOT/packages/source-built

popd
