#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
PATCHES_ROOT=$REPO_ROOT/patches

for patch_folder in $PATCHES_ROOT/*; do
    PROJECT_NAME=$(basename $patch_folder)
    pushd "$SOURCE_ROOT/$PROJECT_NAME" > /dev/null
    for patch_file in $patch_folder/*; do
	patch -p1 < $patch_file
    done
    popd > /dev/null
done
