set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
NUGET_SOURCE_ROOT=$SOURCE_ROOT/NuGet.Client

DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet
NUGET_CLIENT_VERSION_SUFFIX="beta2-1484"
ADD_PUBLIC_SIGN_CMD_PATH=$REPO_ROOT/tools/AddPublicSignToProjectJson/AddPublicSignToProjectJson.dll

pushd $NUGET_SOURCE_ROOT

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1
export NUGET_PACKAGES=$NUGET_SOURCE_ROOT/packages

## Enable public signing with the correct key
for project_json in $(grep -l -r --include project.json -e "netstandard1\.[0-6]" -e "netcoreapp1.0" src/NuGet.Core); do
    $DOTNET_CMD $ADD_PUBLIC_SIGN_CMD_PATH $project_json $REPO_ROOT/snks/NuGet.Client.snk
done

## We need to restore all the projects we might build.
for project_json in $(grep -l -r --include project.json -e "netstandard1\.[0-6]" -e "netcoreapp1.0" src/NuGet.Core); do
    $DOTNET_CMD restore $project_json
done

## now build each project
PROJECT_TFMS=("netstandard1.0" "netstandard1.1" "netstandard1.2" "netstandard1.3" "netstandard1.4" "netstandard1.5" "netstandard1.6" "netcoreapp1.0")
for project_tfm in "${PROJECT_TFMS[@]}"; do
    echo "building for $project_tfm"
    for project_json in $(grep -l -r --include project.json "$project_tfm" src/NuGet.Core); do
        $DOTNET_CMD build $project_json -c Release -f $project_tfm
    done
done

## package each project
for project_json in $(grep -l -r --include project.json -e "netstandard1\.[0-6]" -e "netcoreapp1.0" src/NuGet.Core); do
    $DOTNET_CMD pack --no-build -c Release -o $NUGET_SOURCE_ROOT/Nupkgs -s $project_json --version-suffix $NUGET_CLIENT_VERSION_SUFFIX
done

cp $NUGET_SOURCE_ROOT/Nupkgs/*.nupkg $REPO_ROOT/packages/source-built

popd
