#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.6-x64

export GIT_COMMIT_HASH=6ee58a54b776b26daf3a2a2c6820cbcbd8eb71ef
export GIT_COMMIT_COUNT=1797

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
