// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
//
// File: SecurityConfig.h
// 

// 
// Native implementation for security config access and manipulation
//


#ifndef _COMSecurityConfig_H_
#define _COMSecurityConfig_H_
#ifdef FEATURE_CAS_POLICY

#include "qcall.h"

class SecurityConfig
{
friend struct CacheHeader;

private:
    // These structures can be removed in the next SxS runtime version when we won't have to potentially read
    // config files generated by an in-place runtime that used to include them in the header.
    enum RegistryExtensionsAccessStatus {
        Unknown         = 0,
        NoExtensions    = 1,
        AccessFailure   = 2,
        AccessSuccess   = 3
    };

    struct RegistryExtensionsInfo {
        RegistryExtensionsAccessStatus  eStatus;
        FILETIME                        ftLastWriteTime;
    };

public:
    // Duplicated in System.Security.Util.Config.cs
    enum ConfigId
    {
        None                    = 0,
        MachinePolicyLevel      = 1,
        UserPolicyLevel         = 2,
        EnterprisePolicyLevel   = 3,
    };

    // Duplicated in System.Security.Util.Config.cs
    enum QuickCacheEntryType
    {
        FullTrustZoneMyComputer = 0x1000000,
        FullTrustZoneIntranet   = 0x2000000,
        FullTrustZoneInternet   = 0x4000000,
        FullTrustZoneTrusted    = 0x8000000,
        FullTrustZoneUntrusted  = 0x10000000,
        FullTrustAll            = 0x20000000,
    };

    // Duplicated in System.Security.Util.Config.cs
    enum ConfigRetval
    {
        NoFile = 0,
        ConfigFile = 1,
        CacheFile = 2
    };

    static ConfigRetval InitData( INT32 id, const WCHAR* configFileName, const WCHAR* cacheFileName );
    static ConfigRetval InitData( void* configData, BOOL addToList );

    static BOOL SaveCacheData( INT32 id );

    static
    void QCALLTYPE ResetCacheData(INT32 id);

    static
    HRESULT QCALLTYPE SaveDataByte(LPCWSTR wszConfigPath, LPCBYTE pbData, DWORD cbData);

    static
    BOOL QCALLTYPE RecoverData(INT32 id);

    static 
    void QCALLTYPE SetQuickCache(INT32 id, QuickCacheEntryType type);

    static
    BOOL QCALLTYPE GetCacheEntry(INT32 id, DWORD numEvidence, LPCBYTE pEvidence, DWORD cbEvidence, QCall::ObjectHandleOnStack retPolicy);

    static
    void QCALLTYPE AddCacheEntry(INT32 id, DWORD numEvidence, LPCBYTE pEvidence, DWORD cbEvidence, LPCBYTE pPolicy, DWORD cbPolicy);

    static
    void QCALLTYPE _GetMachineDirectory(QCall::StringHandleOnStack retDirectory);

    static
    void QCALLTYPE _GetUserDirectory(QCall::StringHandleOnStack retDirectory);

    static HRESULT GetMachineDirectory (__out_ecount(bufferCount) __out_z WCHAR* buffer, size_t bufferCount);
    static BOOL GetUserDirectory(__out_ecount(bufferCount) __out_z WCHAR* buffer, size_t bufferCount);
    static BOOL GetVIUserDirectory(__out_ecount(bufferCount) __out_z WCHAR* buffer, size_t bufferCount);

    static
    BOOL QCALLTYPE WriteToEventLog(LPCWSTR wszMessage);

#ifdef _DEBUG
    static
    HRESULT QCALLTYPE DebugOut(LPCWSTR wszFileName, LPCWSTR wszMessage);
#endif

    static void Init( void );
    static void Cleanup( void );
    static void Delete( void );

    static BOOL GetQuickCacheEntry( INT32 id, QuickCacheEntryType type );

    static void* GetData( INT32 id );

    static ArrayListStatic  entries_;
    static CrstStatic       dataLock_;

    static WCHAR* wcscatDWORD( __out_ecount(cchdst) __out_z WCHAR* dst, size_t cchdst, DWORD num );
};
#endif // FEATURE_CAS_POLICY
#endif
