// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

/*============================================================
**
** Source: test.c
**
** Purpose: Test for wsprintfA() function
**
**
**=========================================================*/

#include <palsuite.h>

/* memcmp is used to verify the results, so this test is dependent on it. */
/* ditto with strlen */

char * ErrorMessage; 
char buf[256];

BOOL test1()
{
    int pos = 42;


    /* Test 1 */
    wsprintf(buf, "foo %u", pos);
    if (memcmp(buf, "foo 42", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 1) Failed. The correct string is "
            "'foo 42' and the result returned was ";
        return FAIL;
    }

    /* Test 2 */
    wsprintf(buf, "foo %lu", 0xFFFF);
    if (memcmp(buf, "foo 65535", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 2) Failed. The correct string is "
            "'foo 65535' and the result returned was ";
        return FAIL;
    }

    /* Test 3 */
    wsprintf(buf, "foo %hu", 0xFFFF);
    if (memcmp(buf, "foo 65535", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 3) Failed. The correct string is "
            "'foo 65535' and the result returned was ";
        return FAIL;
    }

    /* Test 4 */
    wsprintf(buf, "foo %3u", pos);
    if (memcmp(buf, "foo  42", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 4) Failed. The correct string is "
            "'foo  42' and the result returned was ";
        return FAIL;
    }

    /* Test 5 */
    wsprintf(buf, "foo %-3u", pos);
    if (memcmp(buf, "foo 42 ", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 5) Failed. The correct string is "
            "'foo 42' and the result returned was ";
        return FAIL;
    }

    /* Test 6 */
    wsprintf(buf, "foo %.1u", pos);
    if (memcmp(buf, "foo 42", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 6) Failed. The correct string is "
            "'foo 42' and the result returned was ";
        return FAIL;
     }

    /* Test 7 */
    wsprintf(buf, "foo %.3u", pos);
    if (memcmp(buf, "foo 042", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 7) Failed. The correct string is "
            "'foo 042' and the result returned was ";
        return FAIL;
    }

    /* Test 8 */
    wsprintf(buf, "foo %03u", pos);
    if (memcmp(buf, "foo 042", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 8) Failed. The correct string is "
            "'foo 042' and the result returned was ";
        return FAIL;
    }

    /* Test 9 */
    wsprintf(buf, "foo %#u", pos);
    if (memcmp(buf, "foo 42", strlen(buf) + 1) != 0)
    {
        ErrorMessage = "ERROR: (Test 9) Failed. The correct string is "
            "'foo 42' and the result returned was ";
        return FAIL;
    }
    return PASS;
}


int __cdecl main(int argc, char *argv[])
{

    if(0 != (PAL_Initialize(argc, argv)))
    {
       return FAIL;
    }

    if(test1())
    {
       Fail("%s'%s'\n",ErrorMessage,buf);
    }

  PAL_Terminate();
  return PASS;
}


