#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
SHARED_FRAMEWORK_TGZ_FILENAME=dotnet-rhel-x64.1.1.13.tar.gz
RID=rhel.7.6-x64
SHARED_FRAMEWORK_VERSION=1.1.13

#
# Microsoft did not produce official builds of .NET Core Preview 2.1 with
# a 1.1.2 shared framework, so we can't match the exact commit and count
# here. This is the hash of a commit which moved CLI to use 1.1.2 I did
# locally.
#
export GIT_COMMIT_HASH=526c42658f4070fd0f138de799e2adfd063b71db
export GIT_COMMIT_COUNT=3391
export DOTNET_CLI_FRAMEWORK_HOST_COMPRESSED_FILE=$REPO_ROOT/packages/source-built/$SHARED_FRAMEWORK_TGZ_FILENAME

pushd $SOURCE_ROOT/cli

./build.sh --configuration Release --skip-prereqs --targets Init,Prepare,Compile,Package

cp artifacts/$RID/packages/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
