#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=43a8539a2b3c38d27dc58c6d12034a3b7df5db44
VERSION_SEED_DATE=2017-04-11
OFFICIAL_BUILD_ID=20171211-01

pushd $SOURCE_ROOT/coreclr

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

./sync.sh -p
./build.sh Release x64 skipnuget skiptests -skiprestore -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE
./build-packages.sh -BuildType=Release -BuildArch=x64 -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE

cp bin/Product/Linux.x64.Release/.nuget/pkg/*.nupkg $SOURCE_ROOT/../packages/source-built

popd
