// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using Microsoft.VisualStudio.LanguageServices.Implementation.RQName.SimpleTree;

namespace Microsoft.VisualStudio.LanguageServices.Implementation.RQName.Nodes
{
    internal class RQArrayType : RQArrayOrPointerType
    {
        public readonly int Rank;

        public RQArrayType(int rank, RQType elementType)
            : base(elementType)
        {
            this.Rank = rank;
        }

        public override SimpleTreeNode ToSimpleTree()
        {
            var rankNode = new SimpleLeafNode(Rank.ToString());
            return new SimpleGroupNode(RQNameStrings.Array, rankNode, ElementType.ToSimpleTree());
        }
    }
}
