#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=0ceb8c26f15bd10adc7ccf15d911d75632fb3f3e
VERSION_SEED_DATE=2017-04-20
OFFICIAL_BUILD_ID=20171015-03

pushd $SOURCE_ROOT/corefx

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

./build-managed.sh -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE -- /t:GenerateVersionSourceFile /p:GenerateVersionSourceFile=true 
./build-managed.sh -Platform=AnyCPU -ConfigurationGroup=Release -BuildTests=false -BuildPackages=false -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE -- /p:SkipVerifyPackageVersions=true
./build-native.sh -buildArch=x64 -Release
./build-packages.sh -ConfigurationGroup=Release -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE -- /p:BuildPackageLibraryReferences=false /p:SkipGenerationCheck=true /p:BuildAllPackages=true

cp bin/packages/Release/*.nupkg ../../packages/source-built

popd
