﻿// *********************************************************
//
// Copyright © Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of
// the License at
//
// http://www.apache.org/licenses/LICENSE-2.0 
//
// THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES
// OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED,
// INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES
// OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR
// PURPOSE, MERCHANTABILITY OR NON-INFRINGEMENT.
//
// See the Apache 2 License for the specific language
// governing permissions and limitations under the License.
//
// *********************************************************

using System;
using System.Reflection;

namespace TreeTransformsCS
{
    public class Program
    {
        public static void Main(string[] args)
        {
            // Run all the test cases in TreeTransformTests class
            foreach (var test in typeof(TreeTransformTests).GetMethods(BindingFlags.Static | BindingFlags.Public))
            {
                Console.Write(test.Name);
                dynamic result = test.Invoke(null, null);

                if (result)
                {
                    Console.WriteLine(" : Passed");
                }
                else
                {
                    Console.WriteLine(" : Failed");
                }
            }

            Console.Read();
        }
    }
}
