#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.4-x64

export GIT_COMMIT_HASH=6f9c8a907c9a28f930b6a00c0e8d4eae6357de9d
export GIT_COMMIT_COUNT=1653

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
