#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
SHARED_FRAMEWORK_TGZ_FILENAME=dotnet-rhel-x64.1.0.12.tar.gz
RID=rhel.7.5-x64
SHARED_FRAMEWORK_VERSION=1.0.12

pushd $SOURCE_ROOT/cli

export GIT_COMMIT_COUNT=3301
export GIT_COMMIT_HASH=772c4222a26f72e89ba3dfb3013bba7155764109

export DOTNET_CLI_FRAMEWORK_HOST_COMPRESSED_FILE=$REPO_ROOT/packages/source-built/$SHARED_FRAMEWORK_TGZ_FILENAME

./build.sh --configuration Release --skip-prereqs --targets Init,Prepare,Compile,Package

cp artifacts/$RID/packages/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
