#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.6-x64

export GIT_COMMIT_HASH=8f3458b0ff7d664d136231e6586328b59ae17a37
export GIT_COMMIT_COUNT=1115

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
