Updates:
1. Clone DotNet-Source-Build-Tarball, check out release/1.x branch.
2. Update download-sources.sh:
	1. If MSRC, comment out CoreCLR, CoreFX, and core-setup.
	2. If not, uncomment those lines.
3. Update unpack-sources.sh:
	1. If MSRC, add VSO API key and uncomment clone lines for CoreCLR, CoreFX, and core-setup.  Comment untar lines for same.
	2. If not, comment the clone lines and uncomment the untar lines.
4. Update actual hashes:
	1. If MSRC, in unpack-sources.sh.
	2. If not, in download-sources.sh.
5. Patch updates:
	1. CLI
		1. Patch 0003: Rename and update version number.
		2. Patch 0004: Rename and update version number.
	2. Roslyn
		1. Patch 0012: Rename and update version number.
6. Update hashes in scripts/:
	1. build-coreclr.sh: GIT_COMMIT should match actual hash, OFFICIAL_BUILD_ID should match Microsoft final CoreCLR OfficialBuildId.
	2. build-corefx.sh: same as build-coreclr.sh.
	3. build-core-setup.sh: GIT_COMMIT_HASH should match actual hash, GIT_COMMIT_COUNT is output of `git rev-list --count <hash>`.
	4. build-cli.sh
		1. SHARED_FRAMEWORK_VERSION should be actual shipping framework version.
		2. GIT_COMMIT_COUNT: I increment by 20 for the first tarball of a new release (1.0 has an even tens digit and 1.1 has an odd).  After that, each time we test the tarball, even internally, I add 1 to the count.
		3. GIT_COMMIT_HASH: Checkout the official build hash, `git am` our patches, and use the resulting hash.
7. Update version in smoke-test.sh.
8. RID updates if necessary:
	1. build-core-setup.sh
	2. build-cli.sh
	3. CLI patch 0012
	4. CoreFX patch 0005
	5. core-setup patch 0006
9. Delete sources/coreclr, sources/corefx, sources/core-setup directories.
10. At this point ./download-sources.sh && ./unpack-sources.sh should work and produce the sources/ directory with coreclr, corefx, and core-setup included.
11. If not MSRC, git init the coreclr, corefx, and core-setup directories and set them up with the corresponding hashes.
12. foreach repo in (coreclr, corefx, core-setup):
	1. cd sources/$repo
	2. git checkout \<old sha\>
	3. git am ../../patches/$repo/* --ignore-whitespace
	3. git rebase \<new sha\>
	4. rm ../../patches/$repo/*
	5. git format-patch -o ../../$repo \<new sha\>
	6. git checkout \<new sha\>
13. At this point, ./apply-patches.sh should work.
14. sudo unshare -n ./build.sh
15. Fix problems, ./clean.sh, repeat.

Before packing:
1. Double-check `dotnet --info` and `dotnet --version`.
2. Run smoke-test.sh and verify it passes.
3. Additional exploratory testing.
4. `./clean.sh`
5. If MSRC:
	1. `./unpack-sources.sh`
	2. Remove .git directories from coreclr, corefx, core-setup sources directories.
	3. From the sources directory, `tar czvf $repo.tar.gz $repo/`
	4. Move the tarballs to the source-tarball directory.
5. Reset unpack-sources.sh to remove VSO API key and change back to unpacking all tarballs.
6. `./unpack-sources.sh` and `./apply-patches.sh` to make sure tarballs are correct and patches apply clean.
7. `./clean.sh`
8. Make sure build.log file and testing-smoke directory were removed (can have sudo problems)
9. Push changes to DotNet-Source-Build-Tarball.
10. Remove root .git directory.
11. Rename directory to `cli-1.0.0-preview2-<version>`.
12. Tarball, upload to Azure Storage, send internally for testing.
