Here is a checklist you should tick through before submitting a pull request: 
 - [ ] Implementation is clean
 - [ ] Code adheres to the existing coding standards; e.g. no curlies for one-line blocks, no redundant empty lines between methods or code blocks, spaces rather than tabs, etc.
 - [ ] No ReSharper warnings
 - [ ] There is proper unit test coverage
 - [ ] If the code is copied from StackOverflow (or a blog or OSS) full disclosure is included. That includes required license files and/or file headers explaining where the code came from with proper attribution
 - [ ] There are very few or no comments (because comments shouldn't be needed if you write clean code)
 - [ ] Xml documentation is added/updated for the addition/change
 - [ ] Your PR is (re)based on top of the latest commits from the `dev` branch (more info below)
 - [ ] Link to the issue(s) you're fixing from your PR description. Use `fixes #<the issue number>`
 - [ ] Readme is updated if you change an existing feature or add a new one
 - [ ] Run either `build.cmd` or `build.ps1` and ensure there are no test failures
