// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Build", "CA2211:Non-constant fields should not be visible", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.Versioning.VersionComparer.VersionReleaseMetadata")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool FloatRange.Equals(FloatRange other)', validate parameter 'other' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.FloatRange.Equals(NuGet.Versioning.FloatRange)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1806:Parse calls TryParse but does not explicitly check whether the conversion succeeded. Either use the return value in a conditional statement or verify that the call site expects that the out argument will be set to the default value when the conversion fails.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.FloatRange.Parse(System.String)~NuGet.Versioning.FloatRange")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.EndsWith(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.Versioning.FloatRange.TryParse(string, out NuGet.Versioning.FloatRange)' with a call to 'string.EndsWith(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.FloatRange.TryParse(System.String,NuGet.Versioning.FloatRange@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetVersion.NuGetVersion(NuGetVersion version)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.NuGetVersion.#ctor(NuGet.Versioning.NuGetVersion)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetVersion.NuGetVersion(Version version, string releaseLabel = null, string metadata = null)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.NuGetVersion.#ctor(System.Version,System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'value'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.NuGetVersion.Parse(System.String)~NuGet.Versioning.NuGetVersion")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SemanticVersion.SemanticVersion(SemanticVersion version)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.SemanticVersion.#ctor(NuGet.Versioning.SemanticVersion)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T VersionExtensions.FindBestMatch<T>(IEnumerable<T> items, VersionRange ideal, Func<T, NuGetVersion> selector)', validate parameter 'items' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionExtensions.FindBestMatch``1(System.Collections.Generic.IEnumerable{``0},NuGet.Versioning.VersionRange,System.Func{``0,NuGet.Versioning.NuGetVersion})~``0")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'VersionRange.VersionRange(VersionRange range, FloatRange floatRange)', validate parameter 'range' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionRange.#ctor(NuGet.Versioning.VersionRange,NuGet.Versioning.FloatRange)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool VersionRangeBase.IsSubSetOrEqualTo(VersionRangeBase possibleSuperSet, IVersionComparer comparer)', validate parameter 'possibleSuperSet' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionRangeBase.IsSubSetOrEqualTo(NuGet.Versioning.VersionRangeBase,NuGet.Versioning.IVersionComparer)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool VersionRangeBase.Satisfies(NuGetVersion version, IVersionComparer comparer)', validate parameter 'comparer' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionRangeBase.Satisfies(NuGet.Versioning.NuGetVersion,NuGet.Versioning.IVersionComparer)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1822:Member GetLegacyString does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionRangeFormatter.GetLegacyString(NuGet.Versioning.VersionRangeBase)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member GetNormalizedString does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionRangeFormatter.GetNormalizedString(NuGet.Versioning.VersionRange)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member PrettyPrintBound does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Versioning.VersionRangeFormatter.PrettyPrintBound(System.Text.StringBuilder,NuGet.Versioning.NuGetVersion,System.Boolean,System.String)")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type VersionRangeBase should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Versioning.VersionRangeBase")]
