// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.ActionEventBase.ProjectIds")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'DateTime.ToString(string)' could vary based on the current user's locale settings. Replace this call in 'ActionEventBase.ActionEventBase(string, string, string[], DateTimeOffset, NuGetOperationStatus, int, DateTimeOffset, double)' with a call to 'DateTime.ToString(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ActionEventBase.#ctor(System.String,System.String,System.String[],System.DateTimeOffset,NuGet.Common.NuGetOperationStatus,System.Int32,System.DateTimeOffset,System.Double)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ActionEventBase.ActionEventBase(string eventName, string operationId, string[] projectIds, DateTimeOffset startTime, NuGetOperationStatus status, int packageCount, DateTimeOffset endTime, double duration)', validate parameter 'projectIds' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ActionEventBase.#ctor(System.String,System.String,System.String[],System.DateTimeOffset,NuGet.Common.NuGetOperationStatus,System.Int32,System.DateTimeOffset,System.Double)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task BuildIntegratedRestoreUtility.ExecuteInitPs1ScriptsAsync(BuildIntegratedNuGetProject project, IEnumerable<PackageIdentity> packages, FallbackPackagePathResolver pathResolver, INuGetProjectContext projectContext, CancellationToken token)', validate parameter 'pathResolver' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.BuildIntegratedRestoreUtility.ExecuteInitPs1ScriptsAsync(NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},NuGet.Packaging.FallbackPackagePathResolver,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void BuildIntegratedRestoreUtility.UpdatePackageReferenceMetadata(LockFile lockFile, FallbackPackagePathResolver pathResolver, PackageIdentity package)', validate parameter 'package' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.BuildIntegratedRestoreUtility.UpdatePackageReferenceMetadata(NuGet.ProjectModel.LockFile,NuGet.Packaging.FallbackPackagePathResolver,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<PackageSpec> DependencyGraphRestoreUtility.GetProjectSpec(IDependencyGraphProject project, DependencyGraphCacheContext context)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.GetProjectSpec(NuGet.ProjectManagement.IDependencyGraphProject,NuGet.ProjectManagement.DependencyGraphCacheContext)~System.Threading.Tasks.Task{NuGet.ProjectModel.PackageSpec}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<(DependencyGraphSpec dgSpec, IReadOnlyList<IAssetsLogMessage> additionalMessages)> DependencyGraphRestoreUtility.GetSolutionRestoreSpecAndAdditionalMessages(ISolutionManager solutionManager, DependencyGraphCacheContext context)', validate parameter 'solutionManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.GetSolutionRestoreSpecAndAdditionalMessages(NuGet.PackageManagement.ISolutionManager,NuGet.ProjectManagement.DependencyGraphCacheContext)~System.Threading.Tasks.Task{System.ValueTuple{NuGet.ProjectModel.DependencyGraphSpec,System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.IAssetsLogMessage}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool DependencyGraphRestoreUtility.IsRestoreRequired(DependencyGraphSpec solutionDgSpec)', validate parameter 'solutionDgSpec' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.IsRestoreRequired(NuGet.ProjectModel.DependencyGraphSpec)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'PersistDGSpec' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.PersistDGSpec(NuGet.ProjectModel.DependencyGraphSpec)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter token of method PreviewRestoreAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.PreviewRestoreAsync(NuGet.PackageManagement.ISolutionManager,NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject,NuGet.ProjectModel.PackageSpec,NuGet.ProjectManagement.DependencyGraphCacheContext,NuGet.Commands.RestoreCommandProvidersCache,System.Action{NuGet.Protocol.Core.Types.SourceCacheContext},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Guid,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Commands.RestoreResultPair}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter solutionManager of method RestoreAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.RestoreAsync(NuGet.PackageManagement.ISolutionManager,NuGet.ProjectModel.DependencyGraphSpec,NuGet.ProjectManagement.DependencyGraphCacheContext,NuGet.Commands.RestoreCommandProvidersCache,System.Action{NuGet.Protocol.Core.Types.SourceCacheContext},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Guid,System.Boolean,System.Boolean,System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.IAssetsLogMessage},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummary}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IReadOnlyList<RestoreSummary>> DependencyGraphRestoreUtility.RestoreAsync(ISolutionManager solutionManager, DependencyGraphSpec dgSpec, DependencyGraphCacheContext context, RestoreCommandProvidersCache providerCache, Action<SourceCacheContext> cacheContextModifier, IEnumerable<SourceRepository> sources, Guid parentId, bool forceRestore, bool isRestoreOriginalAction, IReadOnlyList<IAssetsLogMessage> additionalMessages, ILogger log, CancellationToken token)', validate parameter 'dgSpec' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.RestoreAsync(NuGet.PackageManagement.ISolutionManager,NuGet.ProjectModel.DependencyGraphSpec,NuGet.ProjectManagement.DependencyGraphCacheContext,NuGet.Commands.RestoreCommandProvidersCache,System.Action{NuGet.Protocol.Core.Types.SourceCacheContext},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Guid,System.Boolean,System.Boolean,System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.IAssetsLogMessage},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Commands.RestoreSummary}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<RestoreResult> DependencyGraphRestoreUtility.RestoreProjectAsync(ISolutionManager solutionManager, BuildIntegratedNuGetProject project, DependencyGraphCacheContext context, RestoreCommandProvidersCache providerCache, Action<SourceCacheContext> cacheContextModifier, IEnumerable<SourceRepository> sources, Guid parentId, ILogger log, CancellationToken token)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.DependencyGraphRestoreUtility.RestoreProjectAsync(NuGet.PackageManagement.ISolutionManager,NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject,NuGet.ProjectManagement.DependencyGraphCacheContext,NuGet.Commands.RestoreCommandProvidersCache,System.Action{NuGet.Protocol.Core.Types.SourceCacheContext},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Guid,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Commands.RestoreResult}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'exception'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ExceptionUtility.Unwrap(System.Exception)~System.Exception")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'GatherCacheResult GatherCache.GetPackage(PackageSource source, PackageIdentity package, NuGetFramework framework)', validate parameter 'package' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.GatherCache.GetPackage(NuGet.Configuration.PackageSource,NuGet.Packaging.Core.PackageIdentity,NuGet.Frameworks.NuGetFramework)~NuGet.PackageManagement.GatherCacheResult")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'packages'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.GatherCacheResult.#ctor(System.Boolean,System.Collections.Generic.IReadOnlyList{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo})")]
[assembly: SuppressMessage("Build", "CA1303:Method 'GatherCacheResult.GatherCacheResult(bool hasEntry, IReadOnlyList<SourcePackageDependencyInfo> packages)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Values in packages must not be null\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.GatherCacheResult.#ctor(System.Boolean,System.Collections.Generic.IReadOnlyList{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void GatherExceptionHelpers.ThrowIfVersionIsDisallowedByPackagesConfig(IEnumerable<string> targets, IEnumerable<PackageReference> packagesConfig, IEnumerable<PackageDependencyInfo> availablePackages, ILogger logger)', validate parameter 'logger' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.GatherExceptionHelpers.ThrowIfVersionIsDisallowedByPackagesConfig(System.Collections.Generic.IEnumerable{System.String},System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageDependencyInfo},NuGet.Common.ILogger)")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'commonOperations'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.IDEExecutionContext.#ctor(NuGet.PackageManagement.ICommonOperations)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void InstallationCompatibility.EnsurePackageCompatibility(NuGetProject nuGetProject, INuGetPathContext pathContext, IEnumerable<NuGetProjectAction> nuGetProjectActions, RestoreResult restoreResult)', validate parameter 'restoreResult' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.InstallationCompatibility.EnsurePackageCompatibility(NuGet.ProjectManagement.NuGetProject,NuGet.Common.INuGetPathContext,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction},NuGet.Commands.RestoreResult)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void NuGetPackageManager.CollectDependencies(HashSet<string> result, string id, IEnumerable<PackageIdentity> packages, IEnumerable<SourcePackageDependencyInfo> available, int depth)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"packages\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.CollectDependencies(System.Collections.Generic.HashSet{System.String},System.String,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},System.Int32)")]
[assembly: SuppressMessage("Build", "CA1822:Member CompleteTaskAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.CompleteTaskAsync(System.Collections.Generic.List{System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}})~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task NuGetPackageManager.ExecuteBuildIntegratedProjectActionsAsync(BuildIntegratedNuGetProject buildIntegratedProject, IEnumerable<NuGetProjectAction> nuGetProjectActions, INuGetProjectContext nuGetProjectContext, CancellationToken token)', validate parameter 'buildIntegratedProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.ExecuteBuildIntegratedProjectActionsAsync(NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction},NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ExecuteNuGetProjectActionsAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.ExecuteNuGetProjectActionsAsync(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction},NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<PackageIdentity>> NuGetPackageManager.GetInstalledPackagesInDependencyOrder(NuGetProject nuGetProject, CancellationToken token)', validate parameter 'nuGetProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetInstalledPackagesInDependencyOrder(NuGet.ProjectManagement.NuGetProject,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ResolvedPackage> NuGetPackageManager.GetLatestVersionAsync(PackageReference package, NuGetFramework framework, ResolutionContext resolutionContext, IEnumerable<SourceRepository> sources, ILogger log, CancellationToken token)', validate parameter 'sources' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetLatestVersionAsync(NuGet.Packaging.PackageReference,NuGet.Frameworks.NuGetFramework,NuGet.PackageManagement.ResolutionContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.ResolvedPackage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ResolvedPackage> NuGetPackageManager.GetLatestVersionAsync(string packageId, NuGetFramework framework, ResolutionContext resolutionContext, IEnumerable<SourceRepository> sources, ILogger log, CancellationToken token)', validate parameter 'sources' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetLatestVersionAsync(System.String,NuGet.Frameworks.NuGetFramework,NuGet.PackageManagement.ResolutionContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.ResolvedPackage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ResolvedPackage> NuGetPackageManager.GetLatestVersionAsync(string packageId, NuGetProject project, ResolutionContext resolutionContext, SourceRepository primarySourceRepository, ILogger log, CancellationToken token)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetLatestVersionAsync(System.String,NuGet.ProjectManagement.NuGetProject,NuGet.PackageManagement.ResolutionContext,NuGet.Protocol.Core.Types.SourceRepository,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.ResolvedPackage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ResolvedPackage> NuGetPackageManager.GetLatestVersionAsync(string packageId, NuGetProject project, ResolutionContext resolutionContext, IEnumerable<SourceRepository> sources, ILogger log, CancellationToken token)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetLatestVersionAsync(System.String,NuGet.ProjectManagement.NuGetProject,NuGet.PackageManagement.ResolutionContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.ResolvedPackage}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetPackagesToUpdateInProjectAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetPackagesToUpdateInProjectAsync(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.List{NuGet.Packaging.Core.PackageIdentity},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.List{NuGet.Packaging.Core.PackageIdentity}}")]
[assembly: SuppressMessage("Build", "CA1305:'NuGetPackageManager.GetProjectActionsForUpdate(NuGetProject, IEnumerable<PackageIdentity>, IEnumerable<PackageIdentity>, IEnumerable<SourcePackageDependencyInfo>, INuGetProjectContext, bool, IEnumerable<string>, bool)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetProjectActionsForUpdate(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},NuGet.ProjectManagement.INuGetProjectContext,System.Boolean,System.Collections.Generic.IEnumerable{System.String},System.Boolean)~System.Collections.Generic.List{NuGet.PackageManagement.NuGetProjectAction}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetSourceRepository' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetSourceRepository(NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.SourceRepository}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'NuGetPackageManager.GetSourceRepository(PackageIdentity, IEnumerable<SourceRepository>, SourceCacheContext, ILogger)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.GetSourceRepository(NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.SourceRepository}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task NuGetPackageManager.InstallPackageAsync(NuGetProject nuGetProject, PackageIdentity packageIdentity, ResolutionContext resolutionContext, INuGetProjectContext nuGetProjectContext, SourceRepository primarySourceRepository, IEnumerable<SourceRepository> secondarySources, CancellationToken token)', validate parameter 'resolutionContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.InstallPackageAsync(NuGet.ProjectManagement.NuGetProject,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.SourceRepository,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task NuGetPackageManager.InstallPackageAsync(NuGetProject nuGetProject, PackageIdentity packageIdentity, ResolutionContext resolutionContext, INuGetProjectContext nuGetProjectContext, IEnumerable<SourceRepository> primarySources, IEnumerable<SourceRepository> secondarySources, CancellationToken token)', validate parameter 'resolutionContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.InstallPackageAsync(NuGet.ProjectManagement.NuGetProject,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'NuGetPackageManager.InstallPackageAsync(NuGetProject, string, ResolutionContext, INuGetProjectContext, PackageDownloadContext, IEnumerable<SourceRepository>, IEnumerable<SourceRepository>, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.InstallPackageAsync(NuGet.ProjectManagement.NuGetProject,System.String,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task NuGetPackageManager.InstallPackageAsync(NuGetProject nuGetProject, string packageId, ResolutionContext resolutionContext, INuGetProjectContext nuGetProjectContext, SourceRepository primarySourceRepository, IEnumerable<SourceRepository> secondarySources, CancellationToken token)', validate parameter 'resolutionContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.InstallPackageAsync(NuGet.ProjectManagement.NuGetProject,System.String,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.SourceRepository,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task NuGetPackageManager.InstallPackageAsync(NuGetProject nuGetProject, string packageId, ResolutionContext resolutionContext, INuGetProjectContext nuGetProjectContext, IEnumerable<SourceRepository> primarySources, IEnumerable<SourceRepository> secondarySources, CancellationToken token)', validate parameter 'resolutionContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.InstallPackageAsync(NuGet.ProjectManagement.NuGetProject,System.String,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'NuGetPackageManager.PreviewInstallPackageAsync(NuGetProject, PackageIdentity, ResolutionContext, INuGetProjectContext, IEnumerable<SourceRepository>, IEnumerable<SourceRepository>, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.PreviewInstallPackageAsync(NuGet.ProjectManagement.NuGetProject,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<IEnumerable<NuGetProjectAction>> NuGetPackageManager.PreviewInstallPackageAsync(NuGetProject nuGetProject, PackageIdentity packageIdentity, ResolutionContext resolutionContext, INuGetProjectContext nuGetProjectContext, IEnumerable<SourceRepository> primarySources, IEnumerable<SourceRepository> secondarySources, CancellationToken token)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"primarySources\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.PreviewInstallPackageAsync(NuGet.ProjectManagement.NuGetProject,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'NuGetPackageManager.PreviewUninstallPackageAsync(NuGetProject, PackageIdentity, UninstallationContext, INuGetProjectContext, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.PreviewUninstallPackageAsync(NuGet.ProjectManagement.NuGetProject,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.UninstallationContext,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'NuGetPackageManager.PreviewUninstallPackageAsync(NuGetProject, string, UninstallationContext, INuGetProjectContext, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.PreviewUninstallPackageAsync(NuGet.ProjectManagement.NuGetProject,System.String,NuGet.PackageManagement.UninstallationContext,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<NuGetProjectAction>> NuGetPackageManager.PreviewUpdatePackagesAsync(List<PackageIdentity> packageIdentities, IEnumerable<NuGetProject> nuGetProjects, ResolutionContext resolutionContext, INuGetProjectContext nuGetProjectContext, IEnumerable<SourceRepository> primarySources, IEnumerable<SourceRepository> secondarySources, CancellationToken token)', validate parameter 'packageIdentities' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.PreviewUpdatePackagesAsync(System.Collections.Generic.List{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject},NuGet.PackageManagement.ResolutionContext,NuGet.ProjectManagement.INuGetProjectContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.PackageManagement.NuGetProjectAction}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'NuGetPackageManager.RestorePackageAsync(PackageIdentity, INuGetProjectContext, PackageDownloadContext, IEnumerable<SourceRepository>, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.RestorePackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> NuGetPackageManager.RestorePackageAsync(PackageIdentity packageIdentity, INuGetProjectContext nuGetProjectContext, PackageDownloadContext downloadContext, IEnumerable<SourceRepository> sourceRepositories, CancellationToken token)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.RestorePackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RollbackAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetPackageManager.RollbackAsync(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.Stack{NuGet.PackageManagement.NuGetProjectAction},System.Collections.Generic.HashSet{NuGet.Packaging.Core.PackageIdentity},NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'packageIdentity'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.NuGetProjectAction.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.NuGetProjectActionType,NuGet.ProjectManagement.NuGetProject,NuGet.Protocol.Core.Types.SourceRepository)")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new PackageArchiveReader(result.PackageStream)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to another object or wrapper that's created in the method and returned to the caller", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageDownloader.GetDownloadResourceResultAsync(NuGet.Protocol.Core.Types.SourceRepository,NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.PackageDownloadContext,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'CancellationTokenSource.CreateLinkedTokenSource(token)' before all references to it are out of scope.", Justification = "Dispose is called later in the finally block to avoid ObjectDisposedException", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageDownloader.GetDownloadResourceResultAsync(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.PackageDownloadContext,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetDownloadResourceResultAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageDownloader.GetDownloadResourceResultAsync(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.PackageDownloadContext,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IList<PackageDependencyInfo> PackageGraphAnalysisUtilities.GetDependantPackages(PackageDependencyInfo package, IList<PackageDependencyInfo> packageDependencyInfos)', validate parameter 'packageDependencyInfos' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageGraphAnalysisUtilities.GetDependantPackages(NuGet.Packaging.Core.PackageDependencyInfo,System.Collections.Generic.IList{NuGet.Packaging.Core.PackageDependencyInfo})~System.Collections.Generic.IList{NuGet.Packaging.Core.PackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<PackageDependencyInfo>> PackageGraphAnalysisUtilities.GetDependencyInfoForPackageIdentitiesAsync(IEnumerable<PackageIdentity> packageIdentities, NuGetFramework nuGetFramework, DependencyInfoResource dependencyInfoResource, SourceCacheContext sourceCacheContext, bool includeUnresolved, ILogger logger, CancellationToken cancellationToken)', validate parameter 'packageIdentities' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageGraphAnalysisUtilities.GetDependencyInfoForPackageIdentitiesAsync(System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.DependencyInfoResource,NuGet.Protocol.Core.Types.SourceCacheContext,System.Boolean,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IList<PackageWithDependants> PackageGraphAnalysisUtilities.GetPackagesWithDependants(IList<PackageDependencyInfo> packageDependencyInfos)', validate parameter 'packageDependencyInfos' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageGraphAnalysisUtilities.GetPackagesWithDependants(System.Collections.Generic.IList{NuGet.Packaging.Core.PackageDependencyInfo})~System.Collections.Generic.IList{NuGet.PackageManagement.PackageWithDependants}")]
[assembly: SuppressMessage("Build", "CA1816:Change PackagePreFetcherResult.Dispose() to call GC.SuppressFinalize(object). This will prevent derived types that introduce a finalizer from needing to re-implement 'IDisposable' to call it.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackagePreFetcherResult.Dispose")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'EnsureResultAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackagePreFetcherResult.EnsureResultAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new PackageArchiveReader(nupkgPath)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to another object or wrapper that's created in the method and returned to the caller", Scope = "member", Target = "~M:NuGet.PackageManagement.PackagePreFetcherResult.GetPackagesFolderResult(System.String)~NuGet.Protocol.Core.Types.DownloadResourceResult")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'GetPackagesFolderResult(_nupkgPath)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to another object or wrapper that's created in the method and returned to the caller", Scope = "member", Target = "~M:NuGet.PackageManagement.PackagePreFetcherResult.GetResultAsync~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackageReferenceComparer.Equals(PackageReference x, PackageReference y)', validate parameter 'y' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageReferenceComparer.Equals(NuGet.Packaging.PackageReference,NuGet.Packaging.PackageReference)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int PackageReferenceComparer.GetHashCode(PackageReference obj)', validate parameter 'obj' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageReferenceComparer.GetHashCode(NuGet.Packaging.PackageReference)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'packageIdentity'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageRestoredEventArgs.#ctor(NuGet.Packaging.Core.PackageIdentity,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetPackagesReferencesDictionaryAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageRestoreManager.GetPackagesReferencesDictionaryAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.Dictionary{NuGet.Packaging.PackageReference,System.Collections.Generic.List{System.String}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<PackageRestoreResult> PackageRestoreManager.RestoreMissingPackagesAsync(string solutionDirectory, IEnumerable<PackageRestoreData> packages, INuGetProjectContext nuGetProjectContext, PackageDownloadContext downloadContext, ILogger logger, CancellationToken token)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageRestoreManager.RestoreMissingPackagesAsync(System.String,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.PackageRestoreData},NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.PackageRestoreResult}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<PackageRestoreResult> PackageRestoreManager.RestoreMissingPackagesAsync(string solutionDirectory, IEnumerable<PackageRestoreData> packages, INuGetProjectContext nuGetProjectContext, PackageDownloadContext downloadContext, CancellationToken token)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageRestoreManager.RestoreMissingPackagesAsync(System.String,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.PackageRestoreData},NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.PackageRestoreResult}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RestorePackageAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackageRestoreManager.RestorePackageAsync(NuGet.Packaging.PackageReference,NuGet.PackageManagement.PackageRestoreContext,NuGet.ProjectManagement.INuGetProjectContext,NuGet.Protocol.Core.Types.PackageDownloadContext)~System.Threading.Tasks.Task{NuGet.PackageManagement.PackageRestoreManager.AttemptedPackage}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetNupkgMetadataPath does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackagesConfigContentHashProvider.GetNupkgMetadataPath(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1801:Parameter token of method GetNupkgPath is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PackagesConfigContentHashProvider.GetNupkgPath(NuGet.Packaging.Core.PackageIdentity,System.Threading.CancellationToken)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void ProjectContextLogger.Log(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ProjectContextLogger.Log(NuGet.Common.ILogMessage)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task ProjectContextLogger.LogAsync(ILogMessage message)', validate parameter 'message' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ProjectContextLogger.LogAsync(NuGet.Common.ILogMessage)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<SourcePackageDependencyInfo> PrunePackageTree.PruneAllButHighest(IEnumerable<SourcePackageDependencyInfo> packages, string packageId)', validate parameter 'packages' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PrunePackageTree.PruneAllButHighest(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},System.String)~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<SourcePackageDependencyInfo> PrunePackageTree.PruneByPrimaryTargets(IEnumerable<SourcePackageDependencyInfo> packages, IEnumerable<PackageIdentity> primaryTargets)', validate parameter 'primaryTargets' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PrunePackageTree.PruneByPrimaryTargets(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity})~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<SourcePackageDependencyInfo> PrunePackageTree.PruneByUpdateConstraints(IEnumerable<SourcePackageDependencyInfo> packages, IEnumerable<PackageReference> packageReferences, VersionConstraints versionConstraints)', validate parameter 'packageReferences' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PrunePackageTree.PruneByUpdateConstraints(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference},NuGet.PackageManagement.VersionConstraints)~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<SourcePackageDependencyInfo> PrunePackageTree.PruneDisallowedVersions(IEnumerable<SourcePackageDependencyInfo> packages, IEnumerable<PackageReference> packageReferences)', validate parameter 'packageReferences' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PrunePackageTree.PruneDisallowedVersions(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference})~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<SourcePackageDependencyInfo> PrunePackageTree.PruneDowngrades(IEnumerable<SourcePackageDependencyInfo> packages, IEnumerable<PackageReference> packageReferences)', validate parameter 'packageReferences' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PrunePackageTree.PruneDowngrades(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference})~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<SourcePackageDependencyInfo> PrunePackageTree.RemoveDisallowedVersions(IEnumerable<SourcePackageDependencyInfo> packages, PackageReference packageReference)', validate parameter 'packageReference' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.PrunePackageTree.RemoveDisallowedVersions(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo},NuGet.Packaging.PackageReference)~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<HashSet<SourcePackageDependencyInfo>> ResolverGather.GatherAsync(GatherContext context, CancellationToken token)', validate parameter 'context' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ResolverGather.GatherAsync(NuGet.PackageManagement.GatherContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.HashSet{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'ResolverGather.GatherAsync(CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ResolverGather.GatherAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.HashSet{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'ResolverGather.GatherPackageAsync(ResolverGather.GatherRequest, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ResolverGather.GatherPackageAsync(NuGet.PackageManagement.ResolverGather.GatherRequest,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.ResolverGather.GatherResult}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'ResolverGather.InitializeResourcesAsync(CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.ResolverGather.InitializeResourcesAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool SourceRepositoryComparer.Equals(SourceRepository x, SourceRepository y)', validate parameter 'x' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.SourceRepositoryComparer.Equals(NuGet.Protocol.Core.Types.SourceRepository,NuGet.Protocol.Core.Types.SourceRepository)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int SourceRepositoryComparer.GetHashCode(SourceRepository obj)', validate parameter 'obj' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.SourceRepositoryComparer.GetHashCode(NuGet.Protocol.Core.Types.SourceRepository)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IDictionary<PackageIdentity, HashSet<PackageIdentity>> UninstallResolver.GetPackageDependents(IEnumerable<PackageDependencyInfo> dependencyInfoEnumerable, IEnumerable<PackageIdentity> installedPackages, out IDictionary<PackageIdentity, HashSet<PackageIdentity>> dependenciesDict)', validate parameter 'dependencyInfoEnumerable' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UninstallResolver.GetPackageDependents(System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageDependencyInfo},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IDictionary{NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.HashSet{NuGet.Packaging.Core.PackageIdentity}}@)~System.Collections.Generic.IDictionary{NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.HashSet{NuGet.Packaging.Core.PackageIdentity}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ICollection<PackageIdentity> UninstallResolver.GetPackagesToBeUninstalled(PackageIdentity packageIdentity, IEnumerable<PackageDependencyInfo> dependencyInfoEnumerable, IEnumerable<PackageIdentity> installedPackages, UninstallationContext uninstallationContext)', validate parameter 'uninstallationContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UninstallResolver.GetPackagesToBeUninstalled(NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageDependencyInfo},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},NuGet.PackageManagement.UninstallationContext)~System.Collections.Generic.ICollection{NuGet.Packaging.Core.PackageIdentity}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool UriHelper.IsHttpSource(PackageSourceProvider packageSourceProvider)', validate parameter 'packageSourceProvider' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UriHelper.IsHttpSource(NuGet.Configuration.PackageSourceProvider)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool UriHelper.IsHttpSource(string source, PackageSourceProvider packageSourceProvider)', validate parameter 'packageSourceProvider' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UriHelper.IsHttpSource(System.String,NuGet.Configuration.PackageSourceProvider)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'PackagesConfigLockFileUtility.FromPackagesConfigFile(string, NuGetFramework, string, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Utility.PackagesConfigLockFileUtility.FromPackagesConfigFile(System.String,NuGet.Frameworks.NuGetFramework,System.String,System.Threading.CancellationToken)~NuGet.ProjectModel.PackagesLockFile")]
[assembly: SuppressMessage("Build", "CA1806:UpdateLockFile calls Replace but does not use the new string instance that the method returns. Pass the instance as an argument to another method, assign the instance to a variable, or remove the call if it is unnecessary.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Utility.PackagesConfigLockFileUtility.UpdateLockFile(NuGet.ProjectManagement.MSBuildNuGetProject,System.Collections.Generic.List{NuGet.PackageManagement.NuGetProjectAction},System.Threading.CancellationToken)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<LockFile> BuildIntegratedProjectUtility.GetLockFileOrNull(BuildIntegratedNuGetProject buildIntegratedProject)', validate parameter 'buildIntegratedProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.BuildIntegratedProjectUtility.GetLockFileOrNull(NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject)~System.Threading.Tasks.Task{NuGet.ProjectModel.LockFile}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IReadOnlyList<LibraryIdentity> BuildIntegratedProjectUtility.GetOrderedLockFileDependencies(LockFile lockFile)', validate parameter 'lockFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.BuildIntegratedProjectUtility.GetOrderedLockFileDependencies(NuGet.ProjectModel.LockFile)~System.Collections.Generic.IReadOnlyList{NuGet.LibraryModel.LibraryIdentity}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void CollectionsUtility.AddRange<T>(ICollection<T> collection, IEnumerable<T> items)', validate parameter 'items' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.CollectionsUtility.AddRange``1(System.Collections.Generic.ICollection{``0},System.Collections.Generic.IEnumerable{``0})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int CollectionsUtility.RemoveAll<T>(ICollection<T> collection, Func<T, bool> match)', validate parameter 'collection' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.CollectionsUtility.RemoveAll``1(System.Collections.Generic.ICollection{``0},System.Func{``0,System.Boolean})~System.Int32")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'writeToStream'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.AddFile(System.String,System.String,System.Action{System.IO.Stream},NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'stream'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.AddFile(System.String,System.String,System.IO.Stream,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter nuGetProjectContext of method CreateFile is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.CreateFile(System.String,NuGet.ProjectManagement.INuGetProjectContext)~System.IO.Stream")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void FileSystemUtility.DeleteDirectory(string fullPath, bool recursive, INuGetProjectContext nuGetProjectContext)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.DeleteDirectory(System.String,System.Boolean,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void FileSystemUtility.DeleteDirectorySafe(string fullPath, bool recursive, INuGetProjectContext nuGetProjectContext)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.DeleteDirectorySafe(System.String,System.Boolean,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void FileSystemUtility.DeleteFile(string fullPath, INuGetProjectContext nuGetProjectContext)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.DeleteFile(System.String,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void FileSystemUtility.DeleteFiles(IEnumerable<ZipFilePair> packageFiles, string packagesDir, INuGetProjectContext nuGetProjectContext)', validate parameter 'nuGetProjectContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.DeleteFiles(System.Collections.Generic.IEnumerable{NuGet.Packaging.ZipFilePair},System.String,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> FileSystemUtility.GetFiles(string root, string path, string filter, bool recursive)', validate parameter 'root' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.GetFiles(System.String,System.String,System.String,System.Boolean)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string FileSystemUtility.GetRelativePath(string root, string fullPath)', validate parameter 'fullPath' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.GetRelativePath(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string FileSystemUtility.MakeRelativePath(string root, string fullPath)', validate parameter 'root' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileSystemUtility.MakeRelativePath(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'uninstallExtension'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileTransformExtensions.#ctor(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool FileTransformExtensions.Equals(FileTransformExtensions other)', validate parameter 'other' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FileTransformExtensions.Equals(NuGet.ProjectManagement.FileTransformExtensions)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'DeletePackage' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FolderNuGetProject.DeletePackage(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetPackageSaveMode does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.FolderNuGetProject.GetPackageSaveMode(NuGet.ProjectManagement.INuGetProjectContext)~NuGet.Packaging.PackageSaveMode")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void JsonConfigUtility.AddDependency(JObject json, PackageDependency dependency)', validate parameter 'dependency' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.AddDependency(Newtonsoft.Json.Linq.JObject,NuGet.Packaging.Core.PackageDependency)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void JsonConfigUtility.AddDependency(JObject json, PackageIdentity package)', validate parameter 'package' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.AddDependency(Newtonsoft.Json.Linq.JObject,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void JsonConfigUtility.AddFramework(JObject json, NuGetFramework framework)', validate parameter 'framework' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.AddFramework(Newtonsoft.Json.Linq.JObject,NuGet.Frameworks.NuGetFramework)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void JsonConfigUtility.ClearFrameworks(JObject json)', validate parameter 'json' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.ClearFrameworks(Newtonsoft.Json.Linq.JObject)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<PackageDependency> JsonConfigUtility.GetDependencies(JObject json)', validate parameter 'json' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.GetDependencies(Newtonsoft.Json.Linq.JObject)~System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageDependency}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<NuGetFramework> JsonConfigUtility.GetFrameworks(JObject json)', validate parameter 'json' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.GetFrameworks(Newtonsoft.Json.Linq.JObject)~System.Collections.Generic.IEnumerable{NuGet.Frameworks.NuGetFramework}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageDependency JsonConfigUtility.ParseDependency(JToken dependencyToken)', validate parameter 'dependencyToken' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.ParseDependency(Newtonsoft.Json.Linq.JToken)~NuGet.Packaging.Core.PackageDependency")]
[assembly: SuppressMessage("Build", "CA1305:'JsonConfigUtility.ParseDependency(JToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.ParseDependency(Newtonsoft.Json.Linq.JToken)~NuGet.Packaging.Core.PackageDependency")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void JsonConfigUtility.RemoveDependency(JObject json, string packageId)', validate parameter 'json' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.JsonConfigUtility.RemoveDependency(Newtonsoft.Json.Linq.JObject,System.String)")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new PackageArchiveReader(downloadResourceResult.PackageStream, leaveStreamOpen: true)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is on the caller", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProject.InstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.DownloadResourceResult,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'AddFilesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.AddFilesAsync(NuGet.ProjectManagement.IMSBuildProjectSystem,NuGet.Packaging.Core.IAsyncPackageCoreReader,NuGet.Packaging.FrameworkSpecificGroup,System.Collections.Generic.IDictionary{NuGet.ProjectManagement.FileTransformExtensions,NuGet.ProjectManagement.IPackageFileTransformer},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter cancellationToken of method DeleteFileSafeAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.DeleteFileSafeAsync(System.String,System.Func{System.Threading.Tasks.Task{System.IO.Stream}},NuGet.ProjectManagement.IMSBuildProjectSystem,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'DeleteFilesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.DeleteFilesAsync(NuGet.ProjectManagement.IMSBuildProjectSystem,System.IO.Compression.ZipArchive,System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.FrameworkSpecificGroup,System.Collections.Generic.IDictionary{NuGet.ProjectManagement.FileTransformExtensions,NuGet.ProjectManagement.IPackageFileTransformer},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetDirectoriesSafe' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.GetDirectoriesSafe(NuGet.ProjectManagement.IMSBuildProjectSystem,System.String)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetFilesSafe' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.GetFilesSafe(NuGet.ProjectManagement.IMSBuildProjectSystem,System.String,System.String)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'PerformSafeAction' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.PerformSafeAction(System.Action,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter cancellationToken of method TryAddFileAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.MSBuildNuGetProjectSystemUtility.TryAddFileAsync(NuGet.ProjectManagement.IMSBuildProjectSystem,System.String,System.Func{System.Threading.Tasks.Task{System.IO.Stream}},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'CheckDevelopmentDependencyAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.PackagesConfigNuGetProject.CheckDevelopmentDependencyAsync(NuGet.Protocol.Core.Types.DownloadResourceResult,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'packageIdentity'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.PackagesConfigNuGetProject.InstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.DownloadResourceResult,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> PackagesConfigNuGetProject.InstallPackageAsync(PackageIdentity packageIdentity, DownloadResourceResult downloadResourceResult, INuGetProjectContext nuGetProjectContext, CancellationToken token)', validate parameter 'downloadResourceResult' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.PackagesConfigNuGetProject.InstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.DownloadResourceResult,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'packageIdentity'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.PackagesConfigNuGetProject.UninstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<bool> BuildIntegratedNuGetProject.InstallPackageAsync(PackageIdentity packageIdentity, DownloadResourceResult downloadResourceResult, INuGetProjectContext nuGetProjectContext, CancellationToken token)' passes a literal string as parameter 'message' of a call to 'NotImplementedException.NotImplementedException(string message)'. Retrieve the following string(s) from a resource table instead: \"This API should not be called for BuildIntegratedNuGetProject.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject.InstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.DownloadResourceResult,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'ProjectJsonNuGetProject.GetJson()' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.GetJson~Newtonsoft.Json.Linq.JObject")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'ProjectJsonNuGetProject.GetJsonAsync()' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.GetJsonAsync~System.Threading.Tasks.Task{Newtonsoft.Json.Linq.JObject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<(IReadOnlyList<PackageSpec> dgSpecs, IReadOnlyList<IAssetsLogMessage> additionalMessages)> ProjectJsonNuGetProject.GetPackageSpecsAndAdditionalMessagesAsync(DependencyGraphCacheContext context)', validate parameter 'context' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.GetPackageSpecsAndAdditionalMessagesAsync(NuGet.ProjectManagement.DependencyGraphCacheContext)~System.Threading.Tasks.Task{System.ValueTuple{System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.PackageSpec},System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.IAssetsLogMessage}}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'ProjectJsonNuGetProject.GetPackageSpecsAndAdditionalMessagesAsync(DependencyGraphCacheContext)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.GetPackageSpecsAndAdditionalMessagesAsync(NuGet.ProjectManagement.DependencyGraphCacheContext)~System.Threading.Tasks.Task{System.ValueTuple{System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.PackageSpec},System.Collections.Generic.IReadOnlyList{NuGet.ProjectModel.IAssetsLogMessage}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool ProjectJsonNuGetProject.IsUAPFramework(NuGetFramework framework)', validate parameter 'framework' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.IsUAPFramework(NuGet.Frameworks.NuGetFramework)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1822:Member IsUAPFramework does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.IsUAPFramework(NuGet.Frameworks.NuGetFramework)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1801:Parameter token of method RemoveDependencyAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.RemoveDependencyAsync(System.String,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> ProjectJsonNuGetProject.UninstallPackageAsync(PackageIdentity packageIdentity, INuGetProjectContext nuGetProjectContext, CancellationToken token)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.Projects.ProjectJsonNuGetProject.UninstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'settings'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.SourceControlManager.#ctor(NuGet.Configuration.ISettings)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SourceControlUtility.DisableSourceControlMode(ISettings settings)', validate parameter 'settings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.SourceControlUtility.DisableSourceControlMode(NuGet.Configuration.ISettings)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool StreamUtility.ContentEquals(Stream stream, Stream otherStream)', validate parameter 'stream' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.StreamUtility.ContentEquals(System.IO.Stream,System.IO.Stream)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool StreamUtility.IsBinary(Stream stream)', validate parameter 'stream' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.StreamUtility.IsBinary(System.IO.Stream)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Stream StreamUtility.StreamFromString(string content, Encoding encoding)', validate parameter 'encoding' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.StreamUtility.StreamFromString(System.String,System.Text.Encoding)~System.IO.Stream")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void XElementExtensions.AddIndented(XContainer container, XContainer content)', validate parameter 'content' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.AddIndented(System.Xml.Linq.XContainer,System.Xml.Linq.XContainer)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<XElement> XElementExtensions.ElementsNoNamespace(XContainer container, string localName)', validate parameter 'container' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.ElementsNoNamespace(System.Xml.Linq.XContainer,System.String)~System.Collections.Generic.IEnumerable{System.Xml.Linq.XElement}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XElement XElementExtensions.Except(XElement source, XElement target)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.Except(System.Xml.Linq.XElement,System.Xml.Linq.XElement)~System.Xml.Linq.XElement")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string XElementExtensions.GetOptionalAttributeValue(XElement element, string localName, string namespaceName = null)', validate parameter 'element' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.GetOptionalAttributeValue(System.Xml.Linq.XElement,System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string XElementExtensions.GetOptionalElementValue(XContainer element, string localName, string namespaceName = null)', validate parameter 'element' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.GetOptionalElementValue(System.Xml.Linq.XContainer,System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XElement XElementExtensions.MergeWith(XElement source, XElement target, IDictionary<XName, Action<XElement, XElement>> nodeActions)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.MergeWith(System.Xml.Linq.XElement,System.Xml.Linq.XElement,System.Collections.Generic.IDictionary{System.Xml.Linq.XName,System.Action{System.Xml.Linq.XElement,System.Xml.Linq.XElement}})~System.Xml.Linq.XElement")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void XElementExtensions.RemoveAttributes(XElement element, Func<XAttribute, bool> condition)', validate parameter 'element' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.RemoveAttributes(System.Xml.Linq.XElement,System.Func{System.Xml.Linq.XAttribute,System.Boolean})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void XElementExtensions.RemoveIndented(XNode element)', validate parameter 'element' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XElementExtensions.RemoveIndented(System.Xml.Linq.XNode)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<XElement> XmlTransformer.GetXmlAsync(InternalZipFileInfo packageFileInfo, IMSBuildProjectSystem projectSystem, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"internalZipFileInfo\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XmlTransformer.GetXmlAsync(NuGet.ProjectManagement.InternalZipFileInfo,NuGet.ProjectManagement.IMSBuildProjectSystem,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Xml.Linq.XElement}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task XmlTransformer.RevertFileAsync(Func<Task<Stream>> streamTaskFactory, string targetPath, IEnumerable<InternalZipFileInfo> matchingFiles, IMSBuildProjectSystem projectSystem, CancellationToken cancellationToken)', validate parameter 'matchingFiles' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XmlTransformer.RevertFileAsync(System.Func{System.Threading.Tasks.Task{System.IO.Stream}},System.String,System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.InternalZipFileInfo},NuGet.ProjectManagement.IMSBuildProjectSystem,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XDocument XmlUtility.CreateDocument(XName rootName, string path, IMSBuildProjectSystem msBuildNuGetProjectSystem)', validate parameter 'msBuildNuGetProjectSystem' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XmlUtility.CreateDocument(System.Xml.Linq.XName,System.String,NuGet.ProjectManagement.IMSBuildProjectSystem)~System.Xml.Linq.XDocument")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XDocument XmlUtility.GetOrCreateDocument(XName rootName, string path, IMSBuildProjectSystem msBuildNuGetProjectSystem)', validate parameter 'msBuildNuGetProjectSystem' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ProjectManagement.XmlUtility.GetOrCreateDocument(System.Xml.Linq.XName,System.String,NuGet.ProjectManagement.IMSBuildProjectSystem)~System.Xml.Linq.XDocument")]
[assembly: SuppressMessage("Build", "CA2227:Change 'DependencyGraphCache' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ProjectManagement.DependencyGraphCacheContext.DependencyGraphCache")]
[assembly: SuppressMessage("Build", "CA2227:Change 'DirectReferenceCache' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ProjectManagement.DependencyGraphCacheContext.DirectReferenceCache")]
[assembly: SuppressMessage("Build", "CA2227:Change 'PackageSpecCache' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ProjectManagement.DependencyGraphCacheContext.PackageSpecCache")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to PackageReferenceRollbackException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.PackageReferenceRollbackException")]
[assembly: SuppressMessage("Build", "CA1067:Type NuGet.ProjectManagement.FileTransformExtensions should override Equals because it implements IEquatable<T>", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.ProjectManagement.FileTransformExtensions")]
