﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

namespace Microsoft.AspNetCore.Mvc.Analyzers
{
    internal static class SymbolNames
    {
        public const string AllowAnonymousAttribute = "Microsoft.AspNetCore.Authorization.AllowAnonymousAttribute";

        public const string ApiConventionMethodAttribute = "Microsoft.AspNetCore.Mvc.ApiConventionMethodAttribute";

        public const string ApiConventionNameMatchAttribute = "Microsoft.AspNetCore.Mvc.ApiExplorer.ApiConventionNameMatchAttribute";

        public const string ApiConventionTypeMatchAttribute = "Microsoft.AspNetCore.Mvc.ApiExplorer.ApiConventionTypeMatchAttribute";

        public const string ApiConventionTypeAttribute = "Microsoft.AspNetCore.Mvc.ApiConventionTypeAttribute";

        public const string ActionResultOfT = "Microsoft.AspNetCore.Mvc.ActionResult`1";

        public const string AuthorizeAttribute = "Microsoft.AspNetCore.Authorization.AuthorizeAttribute";

        public const string BindAttribute = "Microsoft.AspNetCore.Mvc.BindAttribute";

        public const string ControllerAttribute = "Microsoft.AspNetCore.Mvc.ControllerAttribute";

        public const string DefaultStatusCodeAttribute = "Microsoft.AspNetCore.Mvc.Infrastructure.DefaultStatusCodeAttribute";

        public const string FromBodyAttribute = "Microsoft.AspNetCore.Mvc.FromBodyAttribute";

        public const string HtmlHelperPartialExtensionsType = "Microsoft.AspNetCore.Mvc.Rendering.HtmlHelperPartialExtensions";

        public const string IApiBehaviorMetadata = "Microsoft.AspNetCore.Mvc.Infrastructure.IApiBehaviorMetadata";

        public const string IBinderTypeProviderMetadata = "Microsoft.AspNetCore.Mvc.ModelBinding.IBinderTypeProviderMetadata";

        public const string IActionResult = "Microsoft.AspNetCore.Mvc.IActionResult";

        public const string IConvertToActionResult = "Microsoft.AspNetCore.Mvc.IConvertToActionResult";

        public const string IFilterMetadataType = "Microsoft.AspNetCore.Mvc.Filters.IFilterMetadata";

        public const string IHtmlHelperType = "Microsoft.AspNetCore.Mvc.Rendering.IHtmlHelper";

        public const string IModelNameProvider = "Microsoft.AspNetCore.Mvc.ModelBinding.IModelNameProvider";

        public const string IRouteTemplateProvider = "Microsoft.AspNetCore.Mvc.Routing.IRouteTemplateProvider";

        public const string ModelStateDictionary = "Microsoft.AspNetCore.Mvc.ModelBinding.ModelStateDictionary";

        public const string NonActionAttribute = "Microsoft.AspNetCore.Mvc.NonActionAttribute";

        public const string NonControllerAttribute = "Microsoft.AspNetCore.Mvc.NonControllerAttribute";

        public const string PageModelAttributeType = "Microsoft.AspNetCore.Mvc.RazorPages.Infrastructure.PageModelAttribute";

        public const string PartialMethod = "Partial";

        public const string ProducesDefaultResponseTypeAttribute = "Microsoft.AspNetCore.Mvc.ProducesDefaultResponseTypeAttribute";

        public const string ProducesResponseTypeAttribute = "Microsoft.AspNetCore.Mvc.ProducesResponseTypeAttribute";

        public const string RenderPartialMethod = "RenderPartial";

        public const string IApplicationBuilder = "Microsoft.AspNetCore.Builder.IApplicationBuilder";

        public const string IServiceCollection = "Microsoft.Extensions.DependencyInjection.IServiceCollection";

        public const string MvcOptions = "Microsoft.AspNetCore.Mvc.MvcOptions";

        public const string EnableEndpointRoutingProperty = "EnableEndpointRouting";

        public const string ConfigureServicesMethod = "ConfigureServices";

        public const string ConfigureMethod = "Configure";

        public const string RunAsyncMethodName = "RunAsync";

        public const string TaskTypeName = "System.Threading.Tasks.Task";

        public const string TagHelperRunnerTypeName = "Microsoft.AspNetCore.Razor.Runtime.TagHelpers.TagHelperRunner";
    }
}
