// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#include "pal_err.h"
#include "pal_utilities.h"

void CryptoNative_ErrClearError()
{
    ERR_clear_error();
}

uint64_t CryptoNative_ErrGetErrorAlloc(int32_t* isAllocFailure)
{
    unsigned long err = ERR_get_error();

    if (isAllocFailure)
    {
        *isAllocFailure = ERR_GET_REASON(err) == ERR_R_MALLOC_FAILURE;
    }

    return err;
}

uint64_t CryptoNative_ErrPeekError()
{
    return ERR_peek_error();
}

uint64_t CryptoNative_ErrPeekLastError()
{
    return ERR_peek_last_error();
}

const char* CryptoNative_ErrReasonErrorString(uint64_t error)
{
    const char* errStr = NULL;

#ifdef NEED_OPENSSL_1_1
    int result = pthread_mutex_lock(&g_err_mutex);
    assert(!result && "Acquiring the error string table mutex failed.");

    if (!g_err_unloaded)
    {
#endif
        errStr = ERR_reason_error_string((unsigned long)error);
#ifdef NEED_OPENSSL_1_1
    }

    result = pthread_mutex_unlock(&g_err_mutex);
    assert(!result && "Releasing the error string table mutex failed.");
#endif

    return errStr;
}

void CryptoNative_ErrErrorStringN(uint64_t e, char* buf, int32_t len)
{
#ifdef NEED_OPENSSL_1_1
    int result = pthread_mutex_lock(&g_err_mutex);
    assert(!result && "Acquiring the error string table mutex failed.");

    if (!g_err_unloaded)
    {
#endif
        ERR_error_string_n((unsigned long)e, buf, Int32ToSizeT(len));
#ifdef NEED_OPENSSL_1_1
    }
    else
    {
        // If there's no string table, just make it be the empty string.
        if (buf != NULL && len > 0)
        {
            buf[0] = 0;
        }
    }

    result = pthread_mutex_unlock(&g_err_mutex);
    assert(!result && "Releasing the error string table mutex failed.");
#endif
}
