// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/*****************************************************************************/
#ifndef SIMD_AS_HWINTRINSIC
#error Define SIMD_AS_HWINTRINSIC before including this file
#endif

#if defined(SIMD_AS_HWINTRINSIC_ID) || defined(SIMD_AS_HWINTRINSIC_NM)
#error SIMD_AS_HWINTRINSIC_ID and SIMD_AS_HWINTRINSIC_NM should not be defined before including this file
#endif
/*****************************************************************************/

// clang-format off

#ifdef FEATURE_HW_INTRINSICS

// Defines a SimdAsHWIntrinsic where the name is implicitly taken from the id
#define SIMD_AS_HWINTRINSIC_ID(classId, id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                      \
    SIMD_AS_HWINTRINSIC(classId, id, #id, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

// Defines a SimdAsHWIntrinsic where the name is explicit
#define SIMD_AS_HWINTRINSIC_NM(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)                \
    SIMD_AS_HWINTRINSIC(classId, id, name, numarg, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, flag)

/* Note
    * Each intrinsic has a unique Intrinsic ID with type of `enum NamedIntrinsic`
    * Each intrinsic has a `NumArg` for number of parameters
    * Each intrinsic has 10 `NamedIntrinsic` fields that list the HWIntrinsic that should be generated based-on the base type
        * NI_Illegal is used to represent an unsupported type
        * Using the same Intrinsic ID as the represented entry is used to indicate special handling is required
    * Each intrinsic has one or more flags with type of `enum SimdAsHWIntrinsicFlag`
*/

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector2 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector2,     Abs,                                                    1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Abs,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector2,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_CreateBroadcast,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector64_Dot,                                NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector2,     EqualsInstance,             "Equals",                   2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector64_op_Equality,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_One,                                                0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector2_get_One,                             NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector64_get_Zero,                           NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Max,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Max,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     Min,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Min,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Add,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Divide,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector64_op_Equality,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector64_op_Inequality,                      NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Multiply,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Subtract,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector2,     SquareRoot,                                             1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Sqrt,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector3 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector3,     Abs,                                                    1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Abs,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector3,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_CreateBroadcast,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_Dot,                               NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector3,     EqualsInstance,             "Equals",                   2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_op_Equality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_One,                                                0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector3_get_One,                             NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_get_Zero,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Max,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Max,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     Min,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Min,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Add,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Divide,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_op_Equality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_op_Inequality,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Multiply,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Subtract,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector3,     SquareRoot,                                             1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Sqrt,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector4 Intrinsics
SIMD_AS_HWINTRINSIC_ID(Vector4,     Abs,                                                    1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Abs,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector4,     CreateBroadcast,            ".ctor",                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_CreateBroadcast,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Dot,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_Dot,                               NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(Vector4,     EqualsInstance,             "Equals",                   2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_op_Equality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_One,                                                0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector4_get_One,                             NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     get_Zero,                                               0,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_get_Zero,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Max,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Max,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     Min,                                                    2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Min,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Addition,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Add,                                 NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Divide,                        NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Equality,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_op_Equality,                       NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Inequality,                                          2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_op_Inequality,                     NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Multiply,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Multiply,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     op_Subtraction,                                         2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Subtract,                            NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(Vector4,     SquareRoot,                                             1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Sqrt,                          NI_Illegal},                                    SimdAsHWIntrinsicFlag::None)

// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                     ISA          ID                          Name                        NumArg                                                                                                                                                                                                                      Instructions                                                                                                                                                                                                                                                                   Flags
//                                                                                                     {TYP_BYTE,                                      TYP_UBYTE,                                      TYP_SHORT,                                      TYP_USHORT,                                     TYP_INT,                                        TYP_UINT,                                       TYP_LONG,                                       TYP_ULONG,                                      TYP_FLOAT,                                      TYP_DOUBLE}
// *************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector<T> Intrinsics
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Abs,                                                    1,         {NI_AdvSimd_Abs,                                NI_VectorT128_Abs,                              NI_AdvSimd_Abs,                                 NI_VectorT128_Abs,                              NI_AdvSimd_Abs,                                 NI_VectorT128_Abs,                              NI_AdvSimd_Arm64_Abs,                           NI_VectorT128_Abs,                              NI_AdvSimd_Abs,                                 NI_AdvSimd_Arm64_Abs},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  AndNot,                                                 2,         {NI_AdvSimd_BitwiseClear,                       NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear,                        NI_AdvSimd_BitwiseClear},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Ceiling,                                                1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Ceiling,                             NI_AdvSimd_Arm64_Ceiling},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  ConditionalSelect,                                      3,         {NI_VectorT128_ConditionalSelect,               NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect,                NI_VectorT128_ConditionalSelect},               SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  CreateBroadcast,            ".ctor",                    2,         {NI_VectorT128_CreateBroadcast,                 NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast,                  NI_VectorT128_CreateBroadcast},                 SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Dot,                                                    2,         {NI_Vector128_Dot,                              NI_Vector128_Dot,                               NI_Vector128_Dot,                               NI_Vector128_Dot,                               NI_Vector128_Dot,                               NI_Vector128_Dot,                               NI_Illegal,                                     NI_Illegal,                                     NI_Vector128_Dot,                               NI_Vector128_Dot},                              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Equals,                                                 2,         {NI_AdvSimd_CompareEqual,                       NI_AdvSimd_CompareEqual,                        NI_AdvSimd_CompareEqual,                        NI_AdvSimd_CompareEqual,                        NI_AdvSimd_CompareEqual,                        NI_AdvSimd_CompareEqual,                        NI_AdvSimd_Arm64_CompareEqual,                  NI_AdvSimd_Arm64_CompareEqual,                  NI_AdvSimd_CompareEqual,                        NI_AdvSimd_Arm64_CompareEqual},                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_NM(VectorT128,  EqualsInstance,             "Equals",                   2,         {NI_Vector128_op_Equality,                      NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality},                      SimdAsHWIntrinsicFlag::InstanceMethod)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Floor,                                                  1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Floor,                               NI_AdvSimd_Arm64_Floor},                        SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_AllBitsSet,                                         0,         {NI_Vector128_get_AllBitsSet,                   NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet,                    NI_Vector128_get_AllBitsSet},                   SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Count,                                              0,         {NI_VectorT128_get_Count,                       NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count,                        NI_VectorT128_get_Count},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_One,                                                0,         {NI_VectorT128_get_One,                         NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One,                          NI_VectorT128_get_One},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  get_Zero,                                               0,         {NI_Vector128_get_Zero,                         NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero,                          NI_Vector128_get_Zero},                         SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThan,                                            2,         {NI_AdvSimd_CompareGreaterThan,                 NI_AdvSimd_CompareGreaterThan,                  NI_AdvSimd_CompareGreaterThan,                  NI_AdvSimd_CompareGreaterThan,                  NI_AdvSimd_CompareGreaterThan,                  NI_AdvSimd_CompareGreaterThan,                  NI_AdvSimd_Arm64_CompareGreaterThan,            NI_AdvSimd_Arm64_CompareGreaterThan,            NI_AdvSimd_CompareGreaterThan,                  NI_AdvSimd_Arm64_CompareGreaterThan},           SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  GreaterThanOrEqual,                                     2,         {NI_AdvSimd_CompareGreaterThanOrEqual,          NI_AdvSimd_CompareGreaterThanOrEqual,           NI_AdvSimd_CompareGreaterThanOrEqual,           NI_AdvSimd_CompareGreaterThanOrEqual,           NI_AdvSimd_CompareGreaterThanOrEqual,           NI_AdvSimd_CompareGreaterThanOrEqual,           NI_AdvSimd_Arm64_CompareGreaterThanOrEqual,     NI_AdvSimd_Arm64_CompareGreaterThanOrEqual,     NI_AdvSimd_CompareGreaterThanOrEqual,           NI_AdvSimd_Arm64_CompareGreaterThanOrEqual},    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThan,                                               2,         {NI_AdvSimd_CompareLessThan,                    NI_AdvSimd_CompareLessThan,                     NI_AdvSimd_CompareLessThan,                     NI_AdvSimd_CompareLessThan,                     NI_AdvSimd_CompareLessThan,                     NI_AdvSimd_CompareLessThan,                     NI_AdvSimd_Arm64_CompareLessThan,               NI_AdvSimd_Arm64_CompareLessThan,               NI_AdvSimd_CompareLessThan,                     NI_AdvSimd_Arm64_CompareLessThan},              SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  LessThanOrEqual,                                        2,         {NI_AdvSimd_CompareLessThanOrEqual,             NI_AdvSimd_CompareLessThanOrEqual,              NI_AdvSimd_CompareLessThanOrEqual,              NI_AdvSimd_CompareLessThanOrEqual,              NI_AdvSimd_CompareLessThanOrEqual,              NI_AdvSimd_CompareLessThanOrEqual,              NI_AdvSimd_Arm64_CompareLessThanOrEqual,        NI_AdvSimd_Arm64_CompareLessThanOrEqual,        NI_AdvSimd_CompareLessThanOrEqual,              NI_AdvSimd_Arm64_CompareLessThanOrEqual},       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Max,                                                    2,         {NI_AdvSimd_Max,                                NI_AdvSimd_Max,                                 NI_AdvSimd_Max,                                 NI_AdvSimd_Max,                                 NI_AdvSimd_Max,                                 NI_AdvSimd_Max,                                 NI_VectorT128_Max,                              NI_VectorT128_Max,                              NI_AdvSimd_Max,                                 NI_AdvSimd_Arm64_Max},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  Min,                                                    2,         {NI_AdvSimd_Min,                                NI_AdvSimd_Min,                                 NI_AdvSimd_Min,                                 NI_AdvSimd_Min,                                 NI_AdvSimd_Min,                                 NI_AdvSimd_Min,                                 NI_VectorT128_Min,                              NI_VectorT128_Min,                              NI_AdvSimd_Min,                                 NI_AdvSimd_Arm64_Min},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Addition,                                            2,         {NI_AdvSimd_Add,                                NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Add,                                 NI_AdvSimd_Arm64_Add},                          SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_BitwiseAnd,                                          2,         {NI_AdvSimd_And,                                NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And,                                 NI_AdvSimd_And},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_BitwiseOr,                                           2,         {NI_AdvSimd_Or,                                 NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or,                                  NI_AdvSimd_Or},                                 SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Division,                                            2,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Divide,                        NI_AdvSimd_Arm64_Divide},                       SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Equality,                                            2,         {NI_Vector128_op_Equality,                      NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality,                       NI_Vector128_op_Equality},                      SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_ExclusiveOr,                                         2,         {NI_AdvSimd_Xor,                                NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor,                                 NI_AdvSimd_Xor},                                SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Explicit,                                            1,         {NI_VectorT128_op_Explicit,                     NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit,                      NI_VectorT128_op_Explicit},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Inequality,                                          2,         {NI_Vector128_op_Inequality,                    NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality,                     NI_Vector128_op_Inequality},                    SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Multiply,                                            2,         {NI_AdvSimd_Multiply,                           NI_AdvSimd_Multiply,                            NI_AdvSimd_Multiply,                            NI_AdvSimd_Multiply,                            NI_AdvSimd_Multiply,                            NI_AdvSimd_Multiply,                            NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Multiply,                            NI_AdvSimd_Arm64_Multiply},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  op_Subtraction,                                         2,         {NI_AdvSimd_Subtract,                           NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Subtract,                            NI_AdvSimd_Arm64_Subtract},                     SimdAsHWIntrinsicFlag::None)
SIMD_AS_HWINTRINSIC_ID(VectorT128,  SquareRoot,                                             1,         {NI_Illegal,                                    NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_Illegal,                                     NI_AdvSimd_Arm64_Sqrt,                          NI_AdvSimd_Arm64_Sqrt},                         SimdAsHWIntrinsicFlag::None)

#undef SIMD_AS_HWINTRINSIC_NM
#undef SIMD_AS_HWINTRINSIC_ID

#endif // FEATURE_HW_INTRINSICS

#undef SIMD_AS_HWINTRINSIC

// clang-format on
