// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;

namespace NuGet.Packaging.Licenses
{

    // Auto-Generated by the GenerateLicenseList tool. DO NOT EDIT this manually. Use the update script at $repositoryRoot/scripts/utils/UpdateNuGetLicenseSPDXList.ps1
    public class NuGetLicenseData
    {
        public static string LicenseListVersion = "3.10-14-g0fb8a59";

        public static readonly IReadOnlyDictionary<string, LicenseData> LicenseList = new Dictionary<string, LicenseData>()
        {
            { "0BSD", new LicenseData(licenseID: "0BSD", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AAL", new LicenseData(licenseID: "AAL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Abstyles", new LicenseData(licenseID: "Abstyles", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Adobe-2006", new LicenseData(licenseID: "Adobe-2006", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Adobe-Glyph", new LicenseData(licenseID: "Adobe-Glyph", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ADSL", new LicenseData(licenseID: "ADSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AFL-1.1", new LicenseData(licenseID: "AFL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-1.2", new LicenseData(licenseID: "AFL-1.2", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-2.0", new LicenseData(licenseID: "AFL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-2.1", new LicenseData(licenseID: "AFL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AFL-3.0", new LicenseData(licenseID: "AFL-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Afmparse", new LicenseData(licenseID: "Afmparse", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AGPL-1.0", new LicenseData(licenseID: "AGPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "AGPL-1.0-only", new LicenseData(licenseID: "AGPL-1.0-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AGPL-1.0-or-later", new LicenseData(licenseID: "AGPL-1.0-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AGPL-3.0", new LicenseData(licenseID: "AGPL-3.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "AGPL-3.0-only", new LicenseData(licenseID: "AGPL-3.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "AGPL-3.0-or-later", new LicenseData(licenseID: "AGPL-3.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Aladdin", new LicenseData(licenseID: "Aladdin", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AMDPLPA", new LicenseData(licenseID: "AMDPLPA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AML", new LicenseData(licenseID: "AML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "AMPAS", new LicenseData(licenseID: "AMPAS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ANTLR-PD", new LicenseData(licenseID: "ANTLR-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Apache-1.0", new LicenseData(licenseID: "Apache-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Apache-1.1", new LicenseData(licenseID: "Apache-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Apache-2.0", new LicenseData(licenseID: "Apache-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "APAFML", new LicenseData(licenseID: "APAFML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APL-1.0", new LicenseData(licenseID: "APL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-1.0", new LicenseData(licenseID: "APSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-1.1", new LicenseData(licenseID: "APSL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-1.2", new LicenseData(licenseID: "APSL-1.2", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "APSL-2.0", new LicenseData(licenseID: "APSL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Artistic-1.0", new LicenseData(licenseID: "Artistic-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-1.0-cl8", new LicenseData(licenseID: "Artistic-1.0-cl8", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-1.0-Perl", new LicenseData(licenseID: "Artistic-1.0-Perl", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Artistic-2.0", new LicenseData(licenseID: "Artistic-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Bahyph", new LicenseData(licenseID: "Bahyph", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Barr", new LicenseData(licenseID: "Barr", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Beerware", new LicenseData(licenseID: "Beerware", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BitTorrent-1.0", new LicenseData(licenseID: "BitTorrent-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BitTorrent-1.1", new LicenseData(licenseID: "BitTorrent-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "blessing", new LicenseData(licenseID: "blessing", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BlueOak-1.0.0", new LicenseData(licenseID: "BlueOak-1.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Borceux", new LicenseData(licenseID: "Borceux", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-1-Clause", new LicenseData(licenseID: "BSD-1-Clause", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause", new LicenseData(licenseID: "BSD-2-Clause", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause-FreeBSD", new LicenseData(licenseID: "BSD-2-Clause-FreeBSD", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "BSD-2-Clause-NetBSD", new LicenseData(licenseID: "BSD-2-Clause-NetBSD", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "BSD-2-Clause-Patent", new LicenseData(licenseID: "BSD-2-Clause-Patent", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-2-Clause-Views", new LicenseData(licenseID: "BSD-2-Clause-Views", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause", new LicenseData(licenseID: "BSD-3-Clause", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-3-Clause-Attribution", new LicenseData(licenseID: "BSD-3-Clause-Attribution", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Clear", new LicenseData(licenseID: "BSD-3-Clause-Clear", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-3-Clause-LBNL", new LicenseData(licenseID: "BSD-3-Clause-LBNL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Nuclear-License", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-License", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Nuclear-License-2014", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-License-2014", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-No-Nuclear-Warranty", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-Warranty", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-3-Clause-Open-MPI", new LicenseData(licenseID: "BSD-3-Clause-Open-MPI", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-4-Clause", new LicenseData(licenseID: "BSD-4-Clause", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "BSD-4-Clause-UC", new LicenseData(licenseID: "BSD-4-Clause-UC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Protection", new LicenseData(licenseID: "BSD-Protection", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSD-Source-Code", new LicenseData(licenseID: "BSD-Source-Code", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "BSL-1.0", new LicenseData(licenseID: "BSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "bzip2-1.0.5", new LicenseData(licenseID: "bzip2-1.0.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "bzip2-1.0.6", new LicenseData(licenseID: "bzip2-1.0.6", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CAL-1.0", new LicenseData(licenseID: "CAL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CAL-1.0-Combined-Work-Exception", new LicenseData(licenseID: "CAL-1.0-Combined-Work-Exception", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Caldera", new LicenseData(licenseID: "Caldera", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CATOSL-1.1", new LicenseData(licenseID: "CATOSL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC0-1.0", new LicenseData(licenseID: "CC0-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CC-BY-1.0", new LicenseData(licenseID: "CC-BY-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-2.0", new LicenseData(licenseID: "CC-BY-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-2.5", new LicenseData(licenseID: "CC-BY-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0", new LicenseData(licenseID: "CC-BY-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-3.0-AT", new LicenseData(licenseID: "CC-BY-3.0-AT", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-4.0", new LicenseData(licenseID: "CC-BY-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CC-BY-NC-1.0", new LicenseData(licenseID: "CC-BY-NC-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-2.0", new LicenseData(licenseID: "CC-BY-NC-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-2.5", new LicenseData(licenseID: "CC-BY-NC-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-3.0", new LicenseData(licenseID: "CC-BY-NC-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-4.0", new LicenseData(licenseID: "CC-BY-NC-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-1.0", new LicenseData(licenseID: "CC-BY-NC-ND-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-2.0", new LicenseData(licenseID: "CC-BY-NC-ND-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-2.5", new LicenseData(licenseID: "CC-BY-NC-ND-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-3.0", new LicenseData(licenseID: "CC-BY-NC-ND-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-3.0-IGO", new LicenseData(licenseID: "CC-BY-NC-ND-3.0-IGO", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-ND-4.0", new LicenseData(licenseID: "CC-BY-NC-ND-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-1.0", new LicenseData(licenseID: "CC-BY-NC-SA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.0", new LicenseData(licenseID: "CC-BY-NC-SA-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-2.5", new LicenseData(licenseID: "CC-BY-NC-SA-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-3.0", new LicenseData(licenseID: "CC-BY-NC-SA-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-NC-SA-4.0", new LicenseData(licenseID: "CC-BY-NC-SA-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-1.0", new LicenseData(licenseID: "CC-BY-ND-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-2.0", new LicenseData(licenseID: "CC-BY-ND-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-2.5", new LicenseData(licenseID: "CC-BY-ND-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-3.0", new LicenseData(licenseID: "CC-BY-ND-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-ND-4.0", new LicenseData(licenseID: "CC-BY-ND-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-1.0", new LicenseData(licenseID: "CC-BY-SA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-2.0", new LicenseData(licenseID: "CC-BY-SA-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-2.5", new LicenseData(licenseID: "CC-BY-SA-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-3.0", new LicenseData(licenseID: "CC-BY-SA-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-3.0-AT", new LicenseData(licenseID: "CC-BY-SA-3.0-AT", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CC-BY-SA-4.0", new LicenseData(licenseID: "CC-BY-SA-4.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CC-PDDC", new LicenseData(licenseID: "CC-PDDC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDDL-1.0", new LicenseData(licenseID: "CDDL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CDDL-1.1", new LicenseData(licenseID: "CDDL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDLA-Permissive-1.0", new LicenseData(licenseID: "CDLA-Permissive-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CDLA-Sharing-1.0", new LicenseData(licenseID: "CDLA-Sharing-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-1.0", new LicenseData(licenseID: "CECILL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-1.1", new LicenseData(licenseID: "CECILL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-2.0", new LicenseData(licenseID: "CECILL-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CECILL-2.1", new LicenseData(licenseID: "CECILL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CECILL-B", new LicenseData(licenseID: "CECILL-B", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CECILL-C", new LicenseData(licenseID: "CECILL-C", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CERN-OHL-1.1", new LicenseData(licenseID: "CERN-OHL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-1.2", new LicenseData(licenseID: "CERN-OHL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-P-2.0", new LicenseData(licenseID: "CERN-OHL-P-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-S-2.0", new LicenseData(licenseID: "CERN-OHL-S-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CERN-OHL-W-2.0", new LicenseData(licenseID: "CERN-OHL-W-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ClArtistic", new LicenseData(licenseID: "ClArtistic", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CNRI-Jython", new LicenseData(licenseID: "CNRI-Jython", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CNRI-Python", new LicenseData(licenseID: "CNRI-Python", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CNRI-Python-GPL-Compatible", new LicenseData(licenseID: "CNRI-Python-GPL-Compatible", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Condor-1.1", new LicenseData(licenseID: "Condor-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "copyleft-next-0.3.0", new LicenseData(licenseID: "copyleft-next-0.3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "copyleft-next-0.3.1", new LicenseData(licenseID: "copyleft-next-0.3.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CPAL-1.0", new LicenseData(licenseID: "CPAL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CPL-1.0", new LicenseData(licenseID: "CPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "CPOL-1.02", new LicenseData(licenseID: "CPOL-1.02", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Crossword", new LicenseData(licenseID: "Crossword", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CrystalStacker", new LicenseData(licenseID: "CrystalStacker", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "CUA-OPL-1.0", new LicenseData(licenseID: "CUA-OPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Cube", new LicenseData(licenseID: "Cube", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "curl", new LicenseData(licenseID: "curl", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "D-FSL-1.0", new LicenseData(licenseID: "D-FSL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "diffmark", new LicenseData(licenseID: "diffmark", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DOC", new LicenseData(licenseID: "DOC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Dotseqn", new LicenseData(licenseID: "Dotseqn", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "DSDP", new LicenseData(licenseID: "DSDP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "dvipdfm", new LicenseData(licenseID: "dvipdfm", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ECL-1.0", new LicenseData(licenseID: "ECL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ECL-2.0", new LicenseData(licenseID: "ECL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "eCos-2.0", new LicenseData(licenseID: "eCos-2.0", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "EFL-1.0", new LicenseData(licenseID: "EFL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EFL-2.0", new LicenseData(licenseID: "EFL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "eGenix", new LicenseData(licenseID: "eGenix", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Entessa", new LicenseData(licenseID: "Entessa", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EPICS", new LicenseData(licenseID: "EPICS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EPL-1.0", new LicenseData(licenseID: "EPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "EPL-2.0", new LicenseData(licenseID: "EPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ErlPL-1.1", new LicenseData(licenseID: "ErlPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "etalab-2.0", new LicenseData(licenseID: "etalab-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EUDatagrid", new LicenseData(licenseID: "EUDatagrid", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "EUPL-1.0", new LicenseData(licenseID: "EUPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "EUPL-1.1", new LicenseData(licenseID: "EUPL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "EUPL-1.2", new LicenseData(licenseID: "EUPL-1.2", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Eurosym", new LicenseData(licenseID: "Eurosym", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Fair", new LicenseData(licenseID: "Fair", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Frameworx-1.0", new LicenseData(licenseID: "Frameworx-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FreeImage", new LicenseData(licenseID: "FreeImage", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFAP", new LicenseData(licenseID: "FSFAP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "FSFUL", new LicenseData(licenseID: "FSFUL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FSFULLR", new LicenseData(licenseID: "FSFULLR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "FTL", new LicenseData(licenseID: "FTL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.1", new LicenseData(licenseID: "GFDL-1.1", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GFDL-1.1-invariants-only", new LicenseData(licenseID: "GFDL-1.1-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-invariants-or-later", new LicenseData(licenseID: "GFDL-1.1-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-no-invariants-only", new LicenseData(licenseID: "GFDL-1.1-no-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-no-invariants-or-later", new LicenseData(licenseID: "GFDL-1.1-no-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.1-only", new LicenseData(licenseID: "GFDL-1.1-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.1-or-later", new LicenseData(licenseID: "GFDL-1.1-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.2", new LicenseData(licenseID: "GFDL-1.2", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GFDL-1.2-invariants-only", new LicenseData(licenseID: "GFDL-1.2-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-invariants-or-later", new LicenseData(licenseID: "GFDL-1.2-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-no-invariants-only", new LicenseData(licenseID: "GFDL-1.2-no-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-no-invariants-or-later", new LicenseData(licenseID: "GFDL-1.2-no-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.2-only", new LicenseData(licenseID: "GFDL-1.2-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.2-or-later", new LicenseData(licenseID: "GFDL-1.2-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.3", new LicenseData(licenseID: "GFDL-1.3", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GFDL-1.3-invariants-only", new LicenseData(licenseID: "GFDL-1.3-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-invariants-or-later", new LicenseData(licenseID: "GFDL-1.3-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-no-invariants-only", new LicenseData(licenseID: "GFDL-1.3-no-invariants-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-no-invariants-or-later", new LicenseData(licenseID: "GFDL-1.3-no-invariants-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GFDL-1.3-only", new LicenseData(licenseID: "GFDL-1.3-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GFDL-1.3-or-later", new LicenseData(licenseID: "GFDL-1.3-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Giftware", new LicenseData(licenseID: "Giftware", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GL2PS", new LicenseData(licenseID: "GL2PS", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Glide", new LicenseData(licenseID: "Glide", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Glulxe", new LicenseData(licenseID: "Glulxe", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GLWTPL", new LicenseData(licenseID: "GLWTPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "gnuplot", new LicenseData(licenseID: "gnuplot", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-1.0", new LicenseData(licenseID: "GPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-1.0+", new LicenseData(licenseID: "GPL-1.0+", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-1.0-only", new LicenseData(licenseID: "GPL-1.0-only", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GPL-1.0-or-later", new LicenseData(licenseID: "GPL-1.0-or-later", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "GPL-2.0", new LicenseData(licenseID: "GPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-2.0+", new LicenseData(licenseID: "GPL-2.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-2.0-only", new LicenseData(licenseID: "GPL-2.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-2.0-or-later", new LicenseData(licenseID: "GPL-2.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-2.0-with-autoconf-exception", new LicenseData(licenseID: "GPL-2.0-with-autoconf-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-bison-exception", new LicenseData(licenseID: "GPL-2.0-with-bison-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-classpath-exception", new LicenseData(licenseID: "GPL-2.0-with-classpath-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-font-exception", new LicenseData(licenseID: "GPL-2.0-with-font-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-2.0-with-GCC-exception", new LicenseData(licenseID: "GPL-2.0-with-GCC-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-3.0", new LicenseData(licenseID: "GPL-3.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-3.0+", new LicenseData(licenseID: "GPL-3.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "GPL-3.0-only", new LicenseData(licenseID: "GPL-3.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-3.0-or-later", new LicenseData(licenseID: "GPL-3.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "GPL-3.0-with-autoconf-exception", new LicenseData(licenseID: "GPL-3.0-with-autoconf-exception", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "GPL-3.0-with-GCC-exception", new LicenseData(licenseID: "GPL-3.0-with-GCC-exception", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "gSOAP-1.3b", new LicenseData(licenseID: "gSOAP-1.3b", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HaskellReport", new LicenseData(licenseID: "HaskellReport", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Hippocratic-2.1", new LicenseData(licenseID: "Hippocratic-2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "HPND", new LicenseData(licenseID: "HPND", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "HPND-sell-variant", new LicenseData(licenseID: "HPND-sell-variant", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IBM-pibs", new LicenseData(licenseID: "IBM-pibs", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ICU", new LicenseData(licenseID: "ICU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IJG", new LicenseData(licenseID: "IJG", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ImageMagick", new LicenseData(licenseID: "ImageMagick", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "iMatix", new LicenseData(licenseID: "iMatix", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Imlib2", new LicenseData(licenseID: "Imlib2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Info-ZIP", new LicenseData(licenseID: "Info-ZIP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Intel", new LicenseData(licenseID: "Intel", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Intel-ACPI", new LicenseData(licenseID: "Intel-ACPI", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Interbase-1.0", new LicenseData(licenseID: "Interbase-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "IPA", new LicenseData(licenseID: "IPA", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "IPL-1.0", new LicenseData(licenseID: "IPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ISC", new LicenseData(licenseID: "ISC", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "JasPer-2.0", new LicenseData(licenseID: "JasPer-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "JPNIC", new LicenseData(licenseID: "JPNIC", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "JSON", new LicenseData(licenseID: "JSON", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LAL-1.2", new LicenseData(licenseID: "LAL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LAL-1.3", new LicenseData(licenseID: "LAL-1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Latex2e", new LicenseData(licenseID: "Latex2e", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Leptonica", new LicenseData(licenseID: "Leptonica", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LGPL-2.0", new LicenseData(licenseID: "LGPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "LGPL-2.0+", new LicenseData(licenseID: "LGPL-2.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "LGPL-2.0-only", new LicenseData(licenseID: "LGPL-2.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LGPL-2.0-or-later", new LicenseData(licenseID: "LGPL-2.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LGPL-2.1", new LicenseData(licenseID: "LGPL-2.1", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-2.1+", new LicenseData(licenseID: "LGPL-2.1+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-2.1-only", new LicenseData(licenseID: "LGPL-2.1-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-2.1-or-later", new LicenseData(licenseID: "LGPL-2.1-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-3.0", new LicenseData(licenseID: "LGPL-3.0", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-3.0+", new LicenseData(licenseID: "LGPL-3.0+", isOsiApproved: true, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "LGPL-3.0-only", new LicenseData(licenseID: "LGPL-3.0-only", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPL-3.0-or-later", new LicenseData(licenseID: "LGPL-3.0-or-later", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LGPLLR", new LicenseData(licenseID: "LGPLLR", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Libpng", new LicenseData(licenseID: "Libpng", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libpng-2.0", new LicenseData(licenseID: "libpng-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libselinux-1.0", new LicenseData(licenseID: "libselinux-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "libtiff", new LicenseData(licenseID: "libtiff", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LiLiQ-P-1.1", new LicenseData(licenseID: "LiLiQ-P-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LiLiQ-R-1.1", new LicenseData(licenseID: "LiLiQ-R-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LiLiQ-Rplus-1.1", new LicenseData(licenseID: "LiLiQ-Rplus-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Linux-OpenIB", new LicenseData(licenseID: "Linux-OpenIB", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPL-1.0", new LicenseData(licenseID: "LPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPL-1.02", new LicenseData(licenseID: "LPL-1.02", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LPPL-1.0", new LicenseData(licenseID: "LPPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPPL-1.1", new LicenseData(licenseID: "LPPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "LPPL-1.2", new LicenseData(licenseID: "LPPL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LPPL-1.3a", new LicenseData(licenseID: "LPPL-1.3a", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "LPPL-1.3c", new LicenseData(licenseID: "LPPL-1.3c", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MakeIndex", new LicenseData(licenseID: "MakeIndex", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MirOS", new LicenseData(licenseID: "MirOS", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT", new LicenseData(licenseID: "MIT", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MIT-0", new LicenseData(licenseID: "MIT-0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-advertising", new LicenseData(licenseID: "MIT-advertising", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-CMU", new LicenseData(licenseID: "MIT-CMU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-enna", new LicenseData(licenseID: "MIT-enna", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MIT-feh", new LicenseData(licenseID: "MIT-feh", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MITNFA", new LicenseData(licenseID: "MITNFA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Motosoto", new LicenseData(licenseID: "Motosoto", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "mpich2", new LicenseData(licenseID: "mpich2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MPL-1.0", new LicenseData(licenseID: "MPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MPL-1.1", new LicenseData(licenseID: "MPL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MPL-2.0", new LicenseData(licenseID: "MPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MPL-2.0-no-copyleft-exception", new LicenseData(licenseID: "MPL-2.0-no-copyleft-exception", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MS-PL", new LicenseData(licenseID: "MS-PL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MS-RL", new LicenseData(licenseID: "MS-RL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "MTLL", new LicenseData(licenseID: "MTLL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MulanPSL-1.0", new LicenseData(licenseID: "MulanPSL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "MulanPSL-2.0", new LicenseData(licenseID: "MulanPSL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Multics", new LicenseData(licenseID: "Multics", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Mup", new LicenseData(licenseID: "Mup", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NASA-1.3", new LicenseData(licenseID: "NASA-1.3", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Naumen", new LicenseData(licenseID: "Naumen", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NBPL-1.0", new LicenseData(licenseID: "NBPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NCGL-UK-2.0", new LicenseData(licenseID: "NCGL-UK-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NCSA", new LicenseData(licenseID: "NCSA", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NetCDF", new LicenseData(licenseID: "NetCDF", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Net-SNMP", new LicenseData(licenseID: "Net-SNMP", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Newsletr", new LicenseData(licenseID: "Newsletr", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NGPL", new LicenseData(licenseID: "NGPL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NIST-PD", new LicenseData(licenseID: "NIST-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NIST-PD-fallback", new LicenseData(licenseID: "NIST-PD-fallback", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NLOD-1.0", new LicenseData(licenseID: "NLOD-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NLPL", new LicenseData(licenseID: "NLPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Nokia", new LicenseData(licenseID: "Nokia", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NOSL", new LicenseData(licenseID: "NOSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Noweb", new LicenseData(licenseID: "Noweb", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NPL-1.0", new LicenseData(licenseID: "NPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NPL-1.1", new LicenseData(licenseID: "NPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "NPOSL-3.0", new LicenseData(licenseID: "NPOSL-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NRL", new LicenseData(licenseID: "NRL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NTP", new LicenseData(licenseID: "NTP", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "NTP-0", new LicenseData(licenseID: "NTP-0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Nunit", new LicenseData(licenseID: "Nunit", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "OCCT-PL", new LicenseData(licenseID: "OCCT-PL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OCLC-2.0", new LicenseData(licenseID: "OCLC-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ODbL-1.0", new LicenseData(licenseID: "ODbL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ODC-By-1.0", new LicenseData(licenseID: "ODC-By-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.0", new LicenseData(licenseID: "OFL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OFL-1.0-no-RFN", new LicenseData(licenseID: "OFL-1.0-no-RFN", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.0-RFN", new LicenseData(licenseID: "OFL-1.0-RFN", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.1", new LicenseData(licenseID: "OFL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OFL-1.1-no-RFN", new LicenseData(licenseID: "OFL-1.1-no-RFN", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OFL-1.1-RFN", new LicenseData(licenseID: "OFL-1.1-RFN", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGC-1.0", new LicenseData(licenseID: "OGC-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-Canada-2.0", new LicenseData(licenseID: "OGL-Canada-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-UK-1.0", new LicenseData(licenseID: "OGL-UK-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-UK-2.0", new LicenseData(licenseID: "OGL-UK-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGL-UK-3.0", new LicenseData(licenseID: "OGL-UK-3.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OGTSL", new LicenseData(licenseID: "OGTSL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.1", new LicenseData(licenseID: "OLDAP-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.2", new LicenseData(licenseID: "OLDAP-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.3", new LicenseData(licenseID: "OLDAP-1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-1.4", new LicenseData(licenseID: "OLDAP-1.4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.0", new LicenseData(licenseID: "OLDAP-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.0.1", new LicenseData(licenseID: "OLDAP-2.0.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.1", new LicenseData(licenseID: "OLDAP-2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.2", new LicenseData(licenseID: "OLDAP-2.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.2.1", new LicenseData(licenseID: "OLDAP-2.2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.2.2", new LicenseData(licenseID: "OLDAP-2.2.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.3", new LicenseData(licenseID: "OLDAP-2.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OLDAP-2.4", new LicenseData(licenseID: "OLDAP-2.4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.5", new LicenseData(licenseID: "OLDAP-2.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.6", new LicenseData(licenseID: "OLDAP-2.6", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OLDAP-2.7", new LicenseData(licenseID: "OLDAP-2.7", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OLDAP-2.8", new LicenseData(licenseID: "OLDAP-2.8", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OML", new LicenseData(licenseID: "OML", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OpenSSL", new LicenseData(licenseID: "OpenSSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OPL-1.0", new LicenseData(licenseID: "OPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OSET-PL-2.1", new LicenseData(licenseID: "OSET-PL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "OSL-1.0", new LicenseData(licenseID: "OSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-1.1", new LicenseData(licenseID: "OSL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-2.0", new LicenseData(licenseID: "OSL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-2.1", new LicenseData(licenseID: "OSL-2.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "OSL-3.0", new LicenseData(licenseID: "OSL-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "O-UDA-1.0", new LicenseData(licenseID: "O-UDA-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Parity-6.0.0", new LicenseData(licenseID: "Parity-6.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Parity-7.0.0", new LicenseData(licenseID: "Parity-7.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PDDL-1.0", new LicenseData(licenseID: "PDDL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PHP-3.0", new LicenseData(licenseID: "PHP-3.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PHP-3.01", new LicenseData(licenseID: "PHP-3.01", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Plexus", new LicenseData(licenseID: "Plexus", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PolyForm-Noncommercial-1.0.0", new LicenseData(licenseID: "PolyForm-Noncommercial-1.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PolyForm-Small-Business-1.0.0", new LicenseData(licenseID: "PolyForm-Small-Business-1.0.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PostgreSQL", new LicenseData(licenseID: "PostgreSQL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "PSF-2.0", new LicenseData(licenseID: "PSF-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "psfrag", new LicenseData(licenseID: "psfrag", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "psutils", new LicenseData(licenseID: "psutils", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Python-2.0", new LicenseData(licenseID: "Python-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Qhull", new LicenseData(licenseID: "Qhull", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "QPL-1.0", new LicenseData(licenseID: "QPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Rdisc", new LicenseData(licenseID: "Rdisc", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RHeCos-1.1", new LicenseData(licenseID: "RHeCos-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RPL-1.1", new LicenseData(licenseID: "RPL-1.1", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RPL-1.5", new LicenseData(licenseID: "RPL-1.5", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RPSL-1.0", new LicenseData(licenseID: "RPSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "RSA-MD", new LicenseData(licenseID: "RSA-MD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "RSCPL", new LicenseData(licenseID: "RSCPL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Ruby", new LicenseData(licenseID: "Ruby", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Saxpath", new LicenseData(licenseID: "Saxpath", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SAX-PD", new LicenseData(licenseID: "SAX-PD", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SCEA", new LicenseData(licenseID: "SCEA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sendmail", new LicenseData(licenseID: "Sendmail", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sendmail-8.23", new LicenseData(licenseID: "Sendmail-8.23", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGI-B-1.0", new LicenseData(licenseID: "SGI-B-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGI-B-1.1", new LicenseData(licenseID: "SGI-B-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SGI-B-2.0", new LicenseData(licenseID: "SGI-B-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SHL-0.5", new LicenseData(licenseID: "SHL-0.5", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SHL-0.51", new LicenseData(licenseID: "SHL-0.51", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SimPL-2.0", new LicenseData(licenseID: "SimPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SISSL", new LicenseData(licenseID: "SISSL", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SISSL-1.2", new LicenseData(licenseID: "SISSL-1.2", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Sleepycat", new LicenseData(licenseID: "Sleepycat", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SMLNJ", new LicenseData(licenseID: "SMLNJ", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SMPPL", new LicenseData(licenseID: "SMPPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SNIA", new LicenseData(licenseID: "SNIA", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Spencer-86", new LicenseData(licenseID: "Spencer-86", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Spencer-94", new LicenseData(licenseID: "Spencer-94", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Spencer-99", new LicenseData(licenseID: "Spencer-99", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SPL-1.0", new LicenseData(licenseID: "SPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "SSH-OpenSSH", new LicenseData(licenseID: "SSH-OpenSSH", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SSH-short", new LicenseData(licenseID: "SSH-short", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SSPL-1.0", new LicenseData(licenseID: "SSPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "StandardML-NJ", new LicenseData(licenseID: "StandardML-NJ", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: true) },
            { "SugarCRM-1.1.3", new LicenseData(licenseID: "SugarCRM-1.1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "SWL", new LicenseData(licenseID: "SWL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TAPR-OHL-1.0", new LicenseData(licenseID: "TAPR-OHL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TCL", new LicenseData(licenseID: "TCL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TCP-wrappers", new LicenseData(licenseID: "TCP-wrappers", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TMate", new LicenseData(licenseID: "TMate", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TORQUE-1.1", new LicenseData(licenseID: "TORQUE-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TOSL", new LicenseData(licenseID: "TOSL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TU-Berlin-1.0", new LicenseData(licenseID: "TU-Berlin-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "TU-Berlin-2.0", new LicenseData(licenseID: "TU-Berlin-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "UCL-1.0", new LicenseData(licenseID: "UCL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-DFS-2015", new LicenseData(licenseID: "Unicode-DFS-2015", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-DFS-2016", new LicenseData(licenseID: "Unicode-DFS-2016", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unicode-TOU", new LicenseData(licenseID: "Unicode-TOU", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Unlicense", new LicenseData(licenseID: "Unlicense", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "UPL-1.0", new LicenseData(licenseID: "UPL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Vim", new LicenseData(licenseID: "Vim", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "VOSTROM", new LicenseData(licenseID: "VOSTROM", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "VSL-1.0", new LicenseData(licenseID: "VSL-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "W3C", new LicenseData(licenseID: "W3C", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "W3C-19980720", new LicenseData(licenseID: "W3C-19980720", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "W3C-20150513", new LicenseData(licenseID: "W3C-20150513", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Watcom-1.0", new LicenseData(licenseID: "Watcom-1.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Wsuipa", new LicenseData(licenseID: "Wsuipa", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "WTFPL", new LicenseData(licenseID: "WTFPL", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "wxWindows", new LicenseData(licenseID: "wxWindows", isOsiApproved: false, isDeprecatedLicenseId: true, isFsfLibre: false) },
            { "X11", new LicenseData(licenseID: "X11", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Xerox", new LicenseData(licenseID: "Xerox", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "XFree86-1.1", new LicenseData(licenseID: "XFree86-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "xinetd", new LicenseData(licenseID: "xinetd", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Xnet", new LicenseData(licenseID: "Xnet", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "xpp", new LicenseData(licenseID: "xpp", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "XSkat", new LicenseData(licenseID: "XSkat", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "YPL-1.0", new LicenseData(licenseID: "YPL-1.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "YPL-1.1", new LicenseData(licenseID: "YPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Zed", new LicenseData(licenseID: "Zed", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Zend-2.0", new LicenseData(licenseID: "Zend-2.0", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Zimbra-1.3", new LicenseData(licenseID: "Zimbra-1.3", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "Zimbra-1.4", new LicenseData(licenseID: "Zimbra-1.4", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "Zlib", new LicenseData(licenseID: "Zlib", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "zlib-acknowledgement", new LicenseData(licenseID: "zlib-acknowledgement", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ZPL-1.1", new LicenseData(licenseID: "ZPL-1.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: false) },
            { "ZPL-2.0", new LicenseData(licenseID: "ZPL-2.0", isOsiApproved: true, isDeprecatedLicenseId: false, isFsfLibre: true) },
            { "ZPL-2.1", new LicenseData(licenseID: "ZPL-2.1", isOsiApproved: false, isDeprecatedLicenseId: false, isFsfLibre: true) },
        };

        public static readonly IReadOnlyDictionary<string, ExceptionData> ExceptionList = new Dictionary<string, ExceptionData>()
        {
            { "389-exception", new ExceptionData(licenseID: "389-exception", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-2.0", new ExceptionData(licenseID: "Autoconf-exception-2.0", isDeprecatedLicenseId: false) },
            { "Autoconf-exception-3.0", new ExceptionData(licenseID: "Autoconf-exception-3.0", isDeprecatedLicenseId: false) },
            { "Bison-exception-2.2", new ExceptionData(licenseID: "Bison-exception-2.2", isDeprecatedLicenseId: false) },
            { "Bootloader-exception", new ExceptionData(licenseID: "Bootloader-exception", isDeprecatedLicenseId: false) },
            { "Classpath-exception-2.0", new ExceptionData(licenseID: "Classpath-exception-2.0", isDeprecatedLicenseId: false) },
            { "CLISP-exception-2.0", new ExceptionData(licenseID: "CLISP-exception-2.0", isDeprecatedLicenseId: false) },
            { "DigiRule-FOSS-exception", new ExceptionData(licenseID: "DigiRule-FOSS-exception", isDeprecatedLicenseId: false) },
            { "eCos-exception-2.0", new ExceptionData(licenseID: "eCos-exception-2.0", isDeprecatedLicenseId: false) },
            { "Fawkes-Runtime-exception", new ExceptionData(licenseID: "Fawkes-Runtime-exception", isDeprecatedLicenseId: false) },
            { "FLTK-exception", new ExceptionData(licenseID: "FLTK-exception", isDeprecatedLicenseId: false) },
            { "Font-exception-2.0", new ExceptionData(licenseID: "Font-exception-2.0", isDeprecatedLicenseId: false) },
            { "freertos-exception-2.0", new ExceptionData(licenseID: "freertos-exception-2.0", isDeprecatedLicenseId: false) },
            { "GCC-exception-2.0", new ExceptionData(licenseID: "GCC-exception-2.0", isDeprecatedLicenseId: false) },
            { "GCC-exception-3.1", new ExceptionData(licenseID: "GCC-exception-3.1", isDeprecatedLicenseId: false) },
            { "gnu-javamail-exception", new ExceptionData(licenseID: "gnu-javamail-exception", isDeprecatedLicenseId: false) },
            { "GPL-3.0-linking-exception", new ExceptionData(licenseID: "GPL-3.0-linking-exception", isDeprecatedLicenseId: false) },
            { "GPL-3.0-linking-source-exception", new ExceptionData(licenseID: "GPL-3.0-linking-source-exception", isDeprecatedLicenseId: false) },
            { "GPL-CC-1.0", new ExceptionData(licenseID: "GPL-CC-1.0", isDeprecatedLicenseId: false) },
            { "i2p-gpl-java-exception", new ExceptionData(licenseID: "i2p-gpl-java-exception", isDeprecatedLicenseId: false) },
            { "LGPL-3.0-linking-exception", new ExceptionData(licenseID: "LGPL-3.0-linking-exception", isDeprecatedLicenseId: false) },
            { "Libtool-exception", new ExceptionData(licenseID: "Libtool-exception", isDeprecatedLicenseId: false) },
            { "Linux-syscall-note", new ExceptionData(licenseID: "Linux-syscall-note", isDeprecatedLicenseId: false) },
            { "LLVM-exception", new ExceptionData(licenseID: "LLVM-exception", isDeprecatedLicenseId: false) },
            { "LZMA-exception", new ExceptionData(licenseID: "LZMA-exception", isDeprecatedLicenseId: false) },
            { "mif-exception", new ExceptionData(licenseID: "mif-exception", isDeprecatedLicenseId: false) },
            { "Nokia-Qt-exception-1.1", new ExceptionData(licenseID: "Nokia-Qt-exception-1.1", isDeprecatedLicenseId: true) },
            { "OCaml-LGPL-linking-exception", new ExceptionData(licenseID: "OCaml-LGPL-linking-exception", isDeprecatedLicenseId: false) },
            { "OCCT-exception-1.0", new ExceptionData(licenseID: "OCCT-exception-1.0", isDeprecatedLicenseId: false) },
            { "OpenJDK-assembly-exception-1.0", new ExceptionData(licenseID: "OpenJDK-assembly-exception-1.0", isDeprecatedLicenseId: false) },
            { "openvpn-openssl-exception", new ExceptionData(licenseID: "openvpn-openssl-exception", isDeprecatedLicenseId: false) },
            { "PS-or-PDF-font-exception-20170817", new ExceptionData(licenseID: "PS-or-PDF-font-exception-20170817", isDeprecatedLicenseId: false) },
            { "Qt-GPL-exception-1.0", new ExceptionData(licenseID: "Qt-GPL-exception-1.0", isDeprecatedLicenseId: false) },
            { "Qt-LGPL-exception-1.1", new ExceptionData(licenseID: "Qt-LGPL-exception-1.1", isDeprecatedLicenseId: false) },
            { "Qwt-exception-1.0", new ExceptionData(licenseID: "Qwt-exception-1.0", isDeprecatedLicenseId: false) },
            { "SHL-2.0", new ExceptionData(licenseID: "SHL-2.0", isDeprecatedLicenseId: false) },
            { "SHL-2.1", new ExceptionData(licenseID: "SHL-2.1", isDeprecatedLicenseId: false) },
            { "Swift-exception", new ExceptionData(licenseID: "Swift-exception", isDeprecatedLicenseId: false) },
            { "u-boot-exception-2.0", new ExceptionData(licenseID: "u-boot-exception-2.0", isDeprecatedLicenseId: false) },
            { "Universal-FOSS-exception-1.0", new ExceptionData(licenseID: "Universal-FOSS-exception-1.0", isDeprecatedLicenseId: false) },
            { "WxWindows-exception-3.1", new ExceptionData(licenseID: "WxWindows-exception-3.1", isDeprecatedLicenseId: false) },
        };
    }

    public class LicenseData
    {
        public LicenseData(string licenseID, bool isOsiApproved, bool isDeprecatedLicenseId, bool isFsfLibre)
        {
            LicenseID = licenseID;
            IsOsiApproved = isOsiApproved;
            IsDeprecatedLicenseId = isDeprecatedLicenseId;
            IsFsfLibre = isFsfLibre;
        }

        public string LicenseID
        {
            get;
        }

        public bool IsOsiApproved
        {
            get;
        }

        public bool IsDeprecatedLicenseId
        {
            get;
        }

        public bool IsFsfLibre
        {
            get;
        }
    }

    public class ExceptionData
    {
        public ExceptionData(string licenseID, bool isDeprecatedLicenseId)
        {
            LicenseExceptionID = licenseID;
            IsDeprecatedLicenseId = isDeprecatedLicenseId;
        }

        public string LicenseExceptionID
        {
            get;
        }

        public bool IsDeprecatedLicenseId
        {
            get;
        }
    }
}
