// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Diagnostics;

#pragma warning disable SA1001

// This file contains the handling of Windows OS specific culture features.

namespace System.Globalization
{
    internal enum IcuLocaleDataParts
    {
        Lcid = 0,
        AnsiCodePage = 1,
        OemCodePage = 2,
        MacCodePage = 3,
        EbcdicCodePage = 4,
        GeoId = 5,
        DigitSubstitution = 6,
        SpecificLocaleIndex = 7,
        ConsoleLocaleIndex = 8
    }

    internal static class IcuLocaleData
    {
        // this is done rather than using a large readonly array of strings to avoid
        // generating a large amount of code in the static constructor.
        // Using indices from s_localeNamesIndices, we binary search this string when mapping
        // an culture name to Lcid. Note that these names are all lowercase and are
        // sorted alphabetically (ordinal).
        private const string c_localeNames =
        //  culture name                    Lcid
            "aa"                      + //  01000 - 0
            "aa-dj"                   + //  01000 - 2
            "aa-er"                   + //  01000 - 7
            "aa-et"                   + //  01000 - 12
            "af"                      + //  00036 - 17
            "af-na"                   + //  01000 - 19
            "af-za"                   + //  00436 - 24
            "agq"                     + //  01000 - 29
            "agq-cm"                  + //  01000 - 32
            "ak"                      + //  01000 - 38
            "ak-gh"                   + //  01000 - 40
            "am"                      + //  0005e - 45
            "am-et"                   + //  0045e - 47
            "ar"                      + //  00001 - 52
            "ar-001"                  + //  01000 - 54
            "ar-ae"                   + //  03801 - 60
            "ar-bh"                   + //  03c01 - 65
            "ar-dj"                   + //  01000 - 70
            "ar-dz"                   + //  01401 - 75
            "ar-eg"                   + //  00c01 - 80
            "ar-er"                   + //  01000 - 85
            "ar-il"                   + //  01000 - 90
            "ar-iq"                   + //  00801 - 95
            "ar-jo"                   + //  02c01 - 100
            "ar-km"                   + //  01000 - 105
            "ar-kw"                   + //  03401 - 110
            "ar-lb"                   + //  03001 - 115
            "ar-ly"                   + //  01001 - 120
            "ar-ma"                   + //  01801 - 125
            "ar-mr"                   + //  01000 - 130
            "ar-om"                   + //  02001 - 135
            "ar-ps"                   + //  01000 - 140
            "ar-qa"                   + //  04001 - 145
            "ar-sa"                   + //  00401 - 150
            "ar-sd"                   + //  01000 - 155
            "ar-so"                   + //  01000 - 160
            "ar-ss"                   + //  01000 - 165
            "ar-sy"                   + //  02801 - 170
            "ar-td"                   + //  01000 - 175
            "ar-tn"                   + //  01c01 - 180
            "ar-ye"                   + //  02401 - 185
            "arn"                     + //  0007a - 190
            "arn-cl"                  + //  0047a - 193
            "as"                      + //  0004d - 199
            "as-in"                   + //  0044d - 201
            "asa"                     + //  01000 - 206
            "asa-tz"                  + //  01000 - 209
            "ast"                     + //  01000 - 215
            "ast-es"                  + //  01000 - 218
            "az"                      + //  0002c - 224
            "az-cyrl"                 + //  0742c - 226
            "az-cyrl-az"              + //  0082c - 233
            "az-latn"                 + //  0782c - 243
            "az-latn-az"              + //  0042c - 250
            "ba"                      + //  0006d - 260
            "ba-ru"                   + //  0046d - 262
            "bas"                     + //  01000 - 267
            "bas-cm"                  + //  01000 - 270
            "be"                      + //  00023 - 276
            "be-by"                   + //  00423 - 278
            "bem"                     + //  01000 - 283
            "bem-zm"                  + //  01000 - 286
            "bez"                     + //  01000 - 292
            "bez-tz"                  + //  01000 - 295
            "bg"                      + //  00002 - 301
            "bg-bg"                   + //  00402 - 303
            "bin"                     + //  00066 - 308
            "bin-ng"                  + //  00466 - 311
            "bm"                      + //  01000 - 317
            "bm-latn"                 + //  01000 - 319
            "bm-latn-ml"              + //  01000 - 326
            "bn"                      + //  00045 - 336
            "bn-bd"                   + //  00845 - 338
            "bn-in"                   + //  00445 - 343
            "bo"                      + //  00051 - 348
            "bo-cn"                   + //  00451 - 350
            "bo-in"                   + //  01000 - 355
            "br"                      + //  0007e - 360
            "br-fr"                   + //  0047e - 362
            "brx"                     + //  01000 - 367
            "brx-in"                  + //  01000 - 370
            "bs"                      + //  0781a - 376
            "bs-cyrl"                 + //  0641a - 378
            "bs-cyrl-ba"              + //  0201a - 385
            "bs-latn"                 + //  0681a - 395
            "bs-latn-ba"              + //  0141a - 402
            "byn"                     + //  01000 - 412
            "byn-er"                  + //  01000 - 415
            "ca"                      + //  00003 - 421
            "ca-ad"                   + //  01000 - 423
            "ca-es"                   + //  00403 - 428
            "ca-es-valencia"          + //  00803 - 433
            "ca-fr"                   + //  01000 - 447
            "ca-it"                   + //  01000 - 452
            "ce"                      + //  01000 - 457
            "ce-ru"                   + //  01000 - 459
            "cgg"                     + //  01000 - 464
            "cgg-ug"                  + //  01000 - 467
            "chr"                     + //  0005c - 473
            "chr-cher"                + //  07c5c - 476
            "chr-cher-us"             + //  0045c - 484
            "co"                      + //  00083 - 495
            "co-fr"                   + //  00483 - 497
            "cs"                      + //  00005 - 502
            "cs-cz"                   + //  00405 - 504
            "cu"                      + //  01000 - 509
            "cu-ru"                   + //  01000 - 511
            "cy"                      + //  00052 - 516
            "cy-gb"                   + //  00452 - 518
            "da"                      + //  00006 - 523
            "da-dk"                   + //  00406 - 525
            "da-gl"                   + //  01000 - 530
            "dav"                     + //  01000 - 535
            "dav-ke"                  + //  01000 - 538
            "de"                      + //  00007 - 544
            "de-at"                   + //  00c07 - 546
            "de-be"                   + //  01000 - 551
            "de-ch"                   + //  00807 - 556
            "de-de"                   + //  00407 - 561
            "de-de_phoneb"            + //  10407 - 566
            "de-it"                   + //  01000 - 578
            "de-li"                   + //  01407 - 583
            "de-lu"                   + //  01007 - 588
            "dje"                     + //  01000 - 593
            "dje-ne"                  + //  01000 - 596
            "dsb"                     + //  07c2e - 602
            "dsb-de"                  + //  0082e - 605
            "dua"                     + //  01000 - 611
            "dua-cm"                  + //  01000 - 614
            "dv"                      + //  00065 - 620
            "dv-mv"                   + //  00465 - 622
            "dyo"                     + //  01000 - 627
            "dyo-sn"                  + //  01000 - 630
            "dz"                      + //  01000 - 636
            "dz-bt"                   + //  00c51 - 638
            "ebu"                     + //  01000 - 643
            "ebu-ke"                  + //  01000 - 646
            "ee"                      + //  01000 - 652
            "ee-gh"                   + //  01000 - 654
            "ee-tg"                   + //  01000 - 659
            "el"                      + //  00008 - 664
            "el-cy"                   + //  01000 - 666
            "el-gr"                   + //  00408 - 671
            "en"                      + //  00009 - 676
            "en-001"                  + //  01000 - 678
            "en-029"                  + //  02409 - 684
            "en-150"                  + //  01000 - 690
            "en-ag"                   + //  01000 - 696
            "en-ai"                   + //  01000 - 701
            "en-as"                   + //  01000 - 706
            "en-at"                   + //  01000 - 711
            "en-au"                   + //  00c09 - 716
            "en-bb"                   + //  01000 - 721
            "en-be"                   + //  01000 - 726
            "en-bi"                   + //  01000 - 731
            "en-bm"                   + //  01000 - 736
            "en-bs"                   + //  01000 - 741
            "en-bw"                   + //  01000 - 746
            "en-bz"                   + //  02809 - 751
            "en-ca"                   + //  01009 - 756
            "en-cc"                   + //  01000 - 761
            "en-ch"                   + //  01000 - 766
            "en-ck"                   + //  01000 - 771
            "en-cm"                   + //  01000 - 776
            "en-cx"                   + //  01000 - 781
            "en-cy"                   + //  01000 - 786
            "en-de"                   + //  01000 - 791
            "en-dk"                   + //  01000 - 796
            "en-dm"                   + //  01000 - 801
            "en-er"                   + //  01000 - 806
            "en-fi"                   + //  01000 - 811
            "en-fj"                   + //  01000 - 816
            "en-fk"                   + //  01000 - 821
            "en-fm"                   + //  01000 - 826
            "en-gb"                   + //  00809 - 831
            "en-gd"                   + //  01000 - 836
            "en-gg"                   + //  01000 - 841
            "en-gh"                   + //  01000 - 846
            "en-gi"                   + //  01000 - 851
            "en-gm"                   + //  01000 - 856
            "en-gu"                   + //  01000 - 861
            "en-gy"                   + //  01000 - 866
            "en-hk"                   + //  03c09 - 871
            "en-id"                   + //  03809 - 876
            "en-ie"                   + //  01809 - 881
            "en-il"                   + //  01000 - 886
            "en-im"                   + //  01000 - 891
            "en-in"                   + //  04009 - 896
            "en-io"                   + //  01000 - 901
            "en-je"                   + //  01000 - 906
            "en-jm"                   + //  02009 - 911
            "en-ke"                   + //  01000 - 916
            "en-ki"                   + //  01000 - 921
            "en-kn"                   + //  01000 - 926
            "en-ky"                   + //  01000 - 931
            "en-lc"                   + //  01000 - 936
            "en-lr"                   + //  01000 - 941
            "en-ls"                   + //  01000 - 946
            "en-mg"                   + //  01000 - 951
            "en-mh"                   + //  01000 - 956
            "en-mo"                   + //  01000 - 961
            "en-mp"                   + //  01000 - 966
            "en-ms"                   + //  01000 - 971
            "en-mt"                   + //  01000 - 976
            "en-mu"                   + //  01000 - 981
            "en-mw"                   + //  01000 - 986
            "en-my"                   + //  04409 - 991
            "en-na"                   + //  01000 - 996
            "en-nf"                   + //  01000 - 1001
            "en-ng"                   + //  01000 - 1006
            "en-nl"                   + //  01000 - 1011
            "en-nr"                   + //  01000 - 1016
            "en-nu"                   + //  01000 - 1021
            "en-nz"                   + //  01409 - 1026
            "en-pg"                   + //  01000 - 1031
            "en-ph"                   + //  03409 - 1036
            "en-pk"                   + //  01000 - 1041
            "en-pn"                   + //  01000 - 1046
            "en-pr"                   + //  01000 - 1051
            "en-pw"                   + //  01000 - 1056
            "en-rw"                   + //  01000 - 1061
            "en-sb"                   + //  01000 - 1066
            "en-sc"                   + //  01000 - 1071
            "en-sd"                   + //  01000 - 1076
            "en-se"                   + //  01000 - 1081
            "en-sg"                   + //  04809 - 1086
            "en-sh"                   + //  01000 - 1091
            "en-si"                   + //  01000 - 1096
            "en-sl"                   + //  01000 - 1101
            "en-ss"                   + //  01000 - 1106
            "en-sx"                   + //  01000 - 1111
            "en-sz"                   + //  01000 - 1116
            "en-tc"                   + //  01000 - 1121
            "en-tk"                   + //  01000 - 1126
            "en-to"                   + //  01000 - 1131
            "en-tt"                   + //  02c09 - 1136
            "en-tv"                   + //  01000 - 1141
            "en-tz"                   + //  01000 - 1146
            "en-ug"                   + //  01000 - 1151
            "en-um"                   + //  01000 - 1156
            "en-us"                   + //  00409 - 1161
            "en-vc"                   + //  01000 - 1166
            "en-vg"                   + //  01000 - 1171
            "en-vi"                   + //  01000 - 1176
            "en-vu"                   + //  01000 - 1181
            "en-ws"                   + //  01000 - 1186
            "en-za"                   + //  01c09 - 1191
            "en-zm"                   + //  01000 - 1196
            "en-zw"                   + //  03009 - 1201
            "eo"                      + //  01000 - 1206
            "eo-001"                  + //  01000 - 1208
            "es"                      + //  0000a - 1214
            "es-419"                  + //  0580a - 1216
            "es-ar"                   + //  02c0a - 1222
            "es-bo"                   + //  0400a - 1227
            "es-br"                   + //  01000 - 1232
            "es-cl"                   + //  0340a - 1237
            "es-co"                   + //  0240a - 1242
            "es-cr"                   + //  0140a - 1247
            "es-cu"                   + //  05c0a - 1252
            "es-do"                   + //  01c0a - 1257
            "es-ec"                   + //  0300a - 1262
            "es-es"                   + //  00c0a - 1267
            "es-es_tradnl"            + //  0040a - 1272
            "es-gq"                   + //  01000 - 1284
            "es-gt"                   + //  0100a - 1289
            "es-hn"                   + //  0480a - 1294
            "es-mx"                   + //  0080a - 1299
            "es-ni"                   + //  04c0a - 1304
            "es-pa"                   + //  0180a - 1309
            "es-pe"                   + //  0280a - 1314
            "es-ph"                   + //  01000 - 1319
            "es-pr"                   + //  0500a - 1324
            "es-py"                   + //  03c0a - 1329
            "es-sv"                   + //  0440a - 1334
            "es-us"                   + //  0540a - 1339
            "es-uy"                   + //  0380a - 1344
            "es-ve"                   + //  0200a - 1349
            "et"                      + //  00025 - 1354
            "et-ee"                   + //  00425 - 1356
            "eu"                      + //  0002d - 1361
            "eu-es"                   + //  0042d - 1363
            "ewo"                     + //  01000 - 1368
            "ewo-cm"                  + //  01000 - 1371
            "fa"                      + //  00029 - 1377
            "fa-ir"                   + //  00429 - 1379
            "ff"                      + //  00067 - 1384
            "ff-cm"                   + //  01000 - 1386
            "ff-gn"                   + //  01000 - 1391
            "ff-latn"                 + //  07c67 - 1396
            "ff-latn-sn"              + //  00867 - 1403
            "ff-mr"                   + //  01000 - 1413
            "ff-ng"                   + //  00467 - 1418
            "fi"                      + //  0000b - 1423
            "fi-fi"                   + //  0040b - 1425
            "fil"                     + //  00064 - 1430
            "fil-ph"                  + //  00464 - 1433
            "fo"                      + //  00038 - 1439
            "fo-dk"                   + //  01000 - 1441
            "fo-fo"                   + //  00438 - 1446
            "fr"                      + //  0000c - 1451
            "fr-029"                  + //  01c0c - 1453
            "fr-be"                   + //  0080c - 1459
            "fr-bf"                   + //  01000 - 1464
            "fr-bi"                   + //  01000 - 1469
            "fr-bj"                   + //  01000 - 1474
            "fr-bl"                   + //  01000 - 1479
            "fr-ca"                   + //  00c0c - 1484
            "fr-cd"                   + //  0240c - 1489
            "fr-cf"                   + //  01000 - 1494
            "fr-cg"                   + //  01000 - 1499
            "fr-ch"                   + //  0100c - 1504
            "fr-ci"                   + //  0300c - 1509
            "fr-cm"                   + //  02c0c - 1514
            "fr-dj"                   + //  01000 - 1519
            "fr-dz"                   + //  01000 - 1524
            "fr-fr"                   + //  0040c - 1529
            "fr-ga"                   + //  01000 - 1534
            "fr-gf"                   + //  01000 - 1539
            "fr-gn"                   + //  01000 - 1544
            "fr-gp"                   + //  01000 - 1549
            "fr-gq"                   + //  01000 - 1554
            "fr-ht"                   + //  03c0c - 1559
            "fr-km"                   + //  01000 - 1564
            "fr-lu"                   + //  0140c - 1569
            "fr-ma"                   + //  0380c - 1574
            "fr-mc"                   + //  0180c - 1579
            "fr-mf"                   + //  01000 - 1584
            "fr-mg"                   + //  01000 - 1589
            "fr-ml"                   + //  0340c - 1594
            "fr-mq"                   + //  01000 - 1599
            "fr-mr"                   + //  01000 - 1604
            "fr-mu"                   + //  01000 - 1609
            "fr-nc"                   + //  01000 - 1614
            "fr-ne"                   + //  01000 - 1619
            "fr-pf"                   + //  01000 - 1624
            "fr-pm"                   + //  01000 - 1629
            "fr-re"                   + //  0200c - 1634
            "fr-rw"                   + //  01000 - 1639
            "fr-sc"                   + //  01000 - 1644
            "fr-sn"                   + //  0280c - 1649
            "fr-sy"                   + //  01000 - 1654
            "fr-td"                   + //  01000 - 1659
            "fr-tg"                   + //  01000 - 1664
            "fr-tn"                   + //  01000 - 1669
            "fr-vu"                   + //  01000 - 1674
            "fr-wf"                   + //  01000 - 1679
            "fr-yt"                   + //  01000 - 1684
            "fur"                     + //  01000 - 1689
            "fur-it"                  + //  01000 - 1692
            "fy"                      + //  00062 - 1698
            "fy-nl"                   + //  00462 - 1700
            "ga"                      + //  0003c - 1705
            "ga-ie"                   + //  0083c - 1707
            "gd"                      + //  00091 - 1712
            "gd-gb"                   + //  00491 - 1714
            "gl"                      + //  00056 - 1719
            "gl-es"                   + //  00456 - 1721
            "gn"                      + //  00074 - 1726
            "gn-py"                   + //  00474 - 1728
            "gsw"                     + //  00084 - 1733
            "gsw-ch"                  + //  01000 - 1736
            "gsw-fr"                  + //  00484 - 1742
            "gsw-li"                  + //  01000 - 1748
            "gu"                      + //  00047 - 1754
            "gu-in"                   + //  00447 - 1756
            "guz"                     + //  01000 - 1761
            "guz-ke"                  + //  01000 - 1764
            "gv"                      + //  01000 - 1770
            "gv-im"                   + //  01000 - 1772
            "ha"                      + //  00068 - 1777
            "ha-latn"                 + //  07c68 - 1779
            "ha-latn-gh"              + //  01000 - 1786
            "ha-latn-ne"              + //  01000 - 1796
            "ha-latn-ng"              + //  00468 - 1806
            "haw"                     + //  00075 - 1816
            "haw-us"                  + //  00475 - 1819
            "he"                      + //  0000d - 1825
            "he-il"                   + //  0040d - 1827
            "hi"                      + //  00039 - 1832
            "hi-in"                   + //  00439 - 1834
            "hr"                      + //  0001a - 1839
            "hr-ba"                   + //  0101a - 1841
            "hr-hr"                   + //  0041a - 1846
            "hsb"                     + //  0002e - 1851
            "hsb-de"                  + //  0042e - 1854
            "hu"                      + //  0000e - 1860
            "hu-hu"                   + //  0040e - 1862
            "hu-hu_technl"            + //  1040e - 1867
            "hy"                      + //  0002b - 1879
            "hy-am"                   + //  0042b - 1881
            "ia"                      + //  01000 - 1886
            "ia-001"                  + //  01000 - 1888
            "ia-fr"                   + //  01000 - 1894
            "ibb"                     + //  00069 - 1899
            "ibb-ng"                  + //  00469 - 1902
            "id"                      + //  00021 - 1908
            "id-id"                   + //  00421 - 1910
            "ig"                      + //  00070 - 1915
            "ig-ng"                   + //  00470 - 1917
            "ii"                      + //  00078 - 1922
            "ii-cn"                   + //  00478 - 1924
            "is"                      + //  0000f - 1929
            "is-is"                   + //  0040f - 1931
            "it"                      + //  00010 - 1936
            "it-ch"                   + //  00810 - 1938
            "it-it"                   + //  00410 - 1943
            "it-sm"                   + //  01000 - 1948
            "iu"                      + //  0005d - 1953
            "iu-cans"                 + //  0785d - 1955
            "iu-cans-ca"              + //  0045d - 1962
            "iu-latn"                 + //  07c5d - 1972
            "iu-latn-ca"              + //  0085d - 1979
            "ja"                      + //  00011 - 1989
            "ja-jp"                   + //  00411 - 1991
            "ja-jp_radstr"            + //  40411 - 1996
            "jgo"                     + //  01000 - 2008
            "jgo-cm"                  + //  01000 - 2011
            "jmc"                     + //  01000 - 2017
            "jmc-tz"                  + //  01000 - 2020
            "jv"                      + //  01000 - 2026
            "jv-java"                 + //  01000 - 2028
            "jv-java-id"              + //  01000 - 2035
            "jv-latn"                 + //  01000 - 2045
            "jv-latn-id"              + //  01000 - 2052
            "ka"                      + //  00037 - 2062
            "ka-ge"                   + //  00437 - 2064
            "ka-ge_modern"            + //  10437 - 2069
            "kab"                     + //  01000 - 2081
            "kab-dz"                  + //  01000 - 2084
            "kam"                     + //  01000 - 2090
            "kam-ke"                  + //  01000 - 2093
            "kde"                     + //  01000 - 2099
            "kde-tz"                  + //  01000 - 2102
            "kea"                     + //  01000 - 2108
            "kea-cv"                  + //  01000 - 2111
            "khq"                     + //  01000 - 2117
            "khq-ml"                  + //  01000 - 2120
            "ki"                      + //  01000 - 2126
            "ki-ke"                   + //  01000 - 2128
            "kk"                      + //  0003f - 2133
            "kk-kz"                   + //  0043f - 2135
            "kkj"                     + //  01000 - 2140
            "kkj-cm"                  + //  01000 - 2143
            "kl"                      + //  0006f - 2149
            "kl-gl"                   + //  0046f - 2151
            "kln"                     + //  01000 - 2156
            "kln-ke"                  + //  01000 - 2159
            "km"                      + //  00053 - 2165
            "km-kh"                   + //  00453 - 2167
            "kn"                      + //  0004b - 2172
            "kn-in"                   + //  0044b - 2174
            "ko"                      + //  00012 - 2179
            "ko-kp"                   + //  01000 - 2181
            "ko-kr"                   + //  00412 - 2186
            "kok"                     + //  00057 - 2191
            "kok-in"                  + //  00457 - 2194
            "kr"                      + //  00071 - 2200
            "kr-ng"                   + //  00471 - 2202
            "ks"                      + //  00060 - 2207
            "ks-arab"                 + //  00460 - 2209
            "ks-arab-in"              + //  01000 - 2216
            "ks-deva"                 + //  01000 - 2226
            "ks-deva-in"              + //  00860 - 2233
            "ksb"                     + //  01000 - 2243
            "ksb-tz"                  + //  01000 - 2246
            "ksf"                     + //  01000 - 2252
            "ksf-cm"                  + //  01000 - 2255
            "ksh"                     + //  01000 - 2261
            "ksh-de"                  + //  01000 - 2264
            "ku"                      + //  00092 - 2270
            "ku-arab"                 + //  07c92 - 2272
            "ku-arab-iq"              + //  00492 - 2279
            "ku-arab-ir"              + //  01000 - 2289
            "kw"                      + //  01000 - 2299
            "kw-gb"                   + //  01000 - 2301
            "ky"                      + //  00040 - 2306
            "ky-kg"                   + //  00440 - 2308
            "la"                      + //  00076 - 2313
            "la-001"                  + //  00476 - 2315
            "lag"                     + //  01000 - 2321
            "lag-tz"                  + //  01000 - 2324
            "lb"                      + //  0006e - 2330
            "lb-lu"                   + //  0046e - 2332
            "lg"                      + //  01000 - 2337
            "lg-ug"                   + //  01000 - 2339
            "lkt"                     + //  01000 - 2344
            "lkt-us"                  + //  01000 - 2347
            "ln"                      + //  01000 - 2353
            "ln-ao"                   + //  01000 - 2355
            "ln-cd"                   + //  01000 - 2360
            "ln-cf"                   + //  01000 - 2365
            "ln-cg"                   + //  01000 - 2370
            "lo"                      + //  00054 - 2375
            "lo-la"                   + //  00454 - 2377
            "lrc"                     + //  01000 - 2382
            "lrc-iq"                  + //  01000 - 2385
            "lrc-ir"                  + //  01000 - 2391
            "lt"                      + //  00027 - 2397
            "lt-lt"                   + //  00427 - 2399
            "lu"                      + //  01000 - 2404
            "lu-cd"                   + //  01000 - 2406
            "luo"                     + //  01000 - 2411
            "luo-ke"                  + //  01000 - 2414
            "luy"                     + //  01000 - 2420
            "luy-ke"                  + //  01000 - 2423
            "lv"                      + //  00026 - 2429
            "lv-lv"                   + //  00426 - 2431
            "mas"                     + //  01000 - 2436
            "mas-ke"                  + //  01000 - 2439
            "mas-tz"                  + //  01000 - 2445
            "mer"                     + //  01000 - 2451
            "mer-ke"                  + //  01000 - 2454
            "mfe"                     + //  01000 - 2460
            "mfe-mu"                  + //  01000 - 2463
            "mg"                      + //  01000 - 2469
            "mg-mg"                   + //  01000 - 2471
            "mgh"                     + //  01000 - 2476
            "mgh-mz"                  + //  01000 - 2479
            "mgo"                     + //  01000 - 2485
            "mgo-cm"                  + //  01000 - 2488
            "mi"                      + //  00081 - 2494
            "mi-nz"                   + //  00481 - 2496
            "mk"                      + //  0002f - 2501
            "mk-mk"                   + //  0042f - 2503
            "ml"                      + //  0004c - 2508
            "ml-in"                   + //  0044c - 2510
            "mn"                      + //  00050 - 2515
            "mn-cyrl"                 + //  07850 - 2517
            "mn-mn"                   + //  00450 - 2524
            "mn-mong"                 + //  07c50 - 2529
            "mn-mong-cn"              + //  00850 - 2536
            "mn-mong-mn"              + //  00c50 - 2546
            "mni"                     + //  00058 - 2556
            "mni-in"                  + //  00458 - 2559
            "moh"                     + //  0007c - 2565
            "moh-ca"                  + //  0047c - 2568
            "mr"                      + //  0004e - 2574
            "mr-in"                   + //  0044e - 2576
            "ms"                      + //  0003e - 2581
            "ms-bn"                   + //  0083e - 2583
            "ms-my"                   + //  0043e - 2588
            "ms-sg"                   + //  01000 - 2593
            "mt"                      + //  0003a - 2598
            "mt-mt"                   + //  0043a - 2600
            "mua"                     + //  01000 - 2605
            "mua-cm"                  + //  01000 - 2608
            "my"                      + //  00055 - 2614
            "my-mm"                   + //  00455 - 2616
            "mzn"                     + //  01000 - 2621
            "mzn-ir"                  + //  01000 - 2624
            "naq"                     + //  01000 - 2630
            "naq-na"                  + //  01000 - 2633
            "nb"                      + //  07c14 - 2639
            "nb-no"                   + //  00414 - 2641
            "nb-sj"                   + //  01000 - 2646
            "nd"                      + //  01000 - 2651
            "nd-zw"                   + //  01000 - 2653
            "nds"                     + //  01000 - 2658
            "nds-de"                  + //  01000 - 2661
            "nds-nl"                  + //  01000 - 2667
            "ne"                      + //  00061 - 2673
            "ne-in"                   + //  00861 - 2675
            "ne-np"                   + //  00461 - 2680
            "nl"                      + //  00013 - 2685
            "nl-aw"                   + //  01000 - 2687
            "nl-be"                   + //  00813 - 2692
            "nl-bq"                   + //  01000 - 2697
            "nl-cw"                   + //  01000 - 2702
            "nl-nl"                   + //  00413 - 2707
            "nl-sr"                   + //  01000 - 2712
            "nl-sx"                   + //  01000 - 2717
            "nmg"                     + //  01000 - 2722
            "nmg-cm"                  + //  01000 - 2725
            "nn"                      + //  07814 - 2731
            "nn-no"                   + //  00814 - 2733
            "nnh"                     + //  01000 - 2738
            "nnh-cm"                  + //  01000 - 2741
            "no"                      + //  00014 - 2747
            "nqo"                     + //  01000 - 2749
            "nqo-gn"                  + //  01000 - 2752
            "nr"                      + //  01000 - 2758
            "nr-za"                   + //  01000 - 2760
            "nso"                     + //  0006c - 2765
            "nso-za"                  + //  0046c - 2768
            "nus"                     + //  01000 - 2774
            "nus-ss"                  + //  01000 - 2777
            "nyn"                     + //  01000 - 2783
            "nyn-ug"                  + //  01000 - 2786
            "oc"                      + //  00082 - 2792
            "oc-fr"                   + //  00482 - 2794
            "om"                      + //  00072 - 2799
            "om-et"                   + //  00472 - 2801
            "om-ke"                   + //  01000 - 2806
            "or"                      + //  00048 - 2811
            "or-in"                   + //  00448 - 2813
            "os"                      + //  01000 - 2818
            "os-ge"                   + //  01000 - 2820
            "os-ru"                   + //  01000 - 2825
            "pa"                      + //  00046 - 2830
            "pa-arab"                 + //  07c46 - 2832
            "pa-arab-pk"              + //  00846 - 2839
            "pa-in"                   + //  00446 - 2849
            "pap"                     + //  00079 - 2854
            "pap-029"                 + //  00479 - 2857
            "pl"                      + //  00015 - 2864
            "pl-pl"                   + //  00415 - 2866
            "prg"                     + //  01000 - 2871
            "prg-001"                 + //  01000 - 2874
            "prs"                     + //  0008c - 2881
            "prs-af"                  + //  0048c - 2884
            "ps"                      + //  00063 - 2890
            "ps-af"                   + //  00463 - 2892
            "pt"                      + //  00016 - 2897
            "pt-ao"                   + //  01000 - 2899
            "pt-br"                   + //  00416 - 2904
            "pt-ch"                   + //  01000 - 2909
            "pt-cv"                   + //  01000 - 2914
            "pt-gq"                   + //  01000 - 2919
            "pt-gw"                   + //  01000 - 2924
            "pt-lu"                   + //  01000 - 2929
            "pt-mo"                   + //  01000 - 2934
            "pt-mz"                   + //  01000 - 2939
            "pt-pt"                   + //  00816 - 2944
            "pt-st"                   + //  01000 - 2949
            "pt-tl"                   + //  01000 - 2954
            "qps-latn-x-sh"           + //  00901 - 2959
            "qps-ploc"                + //  00501 - 2972
            "qps-ploca"               + //  005fe - 2980
            "qps-plocm"               + //  009ff - 2989
            "quc"                     + //  00086 - 2998
            "quc-latn"                + //  07c86 - 3001
            "quc-latn-gt"             + //  00486 - 3009
            "quz"                     + //  0006b - 3020
            "quz-bo"                  + //  0046b - 3023
            "quz-ec"                  + //  0086b - 3029
            "quz-pe"                  + //  00c6b - 3035
            "rm"                      + //  00017 - 3041
            "rm-ch"                   + //  00417 - 3043
            "rn"                      + //  01000 - 3048
            "rn-bi"                   + //  01000 - 3050
            "ro"                      + //  00018 - 3055
            "ro-md"                   + //  00818 - 3057
            "ro-ro"                   + //  00418 - 3062
            "rof"                     + //  01000 - 3067
            "rof-tz"                  + //  01000 - 3070
            "ru"                      + //  00019 - 3076
            "ru-by"                   + //  01000 - 3078
            "ru-kg"                   + //  01000 - 3083
            "ru-kz"                   + //  01000 - 3088
            "ru-md"                   + //  00819 - 3093
            "ru-ru"                   + //  00419 - 3098
            "ru-ua"                   + //  01000 - 3103
            "rw"                      + //  00087 - 3108
            "rw-rw"                   + //  00487 - 3110
            "rwk"                     + //  01000 - 3115
            "rwk-tz"                  + //  01000 - 3118
            "sa"                      + //  0004f - 3124
            "sa-in"                   + //  0044f - 3126
            "sah"                     + //  00085 - 3131
            "sah-ru"                  + //  00485 - 3134
            "saq"                     + //  01000 - 3140
            "saq-ke"                  + //  01000 - 3143
            "sbp"                     + //  01000 - 3149
            "sbp-tz"                  + //  01000 - 3152
            "sd"                      + //  00059 - 3158
            "sd-arab"                 + //  07c59 - 3160
            "sd-arab-pk"              + //  00859 - 3167
            "sd-deva"                 + //  01000 - 3177
            "sd-deva-in"              + //  00459 - 3184
            "se"                      + //  0003b - 3194
            "se-fi"                   + //  00c3b - 3196
            "se-no"                   + //  0043b - 3201
            "se-se"                   + //  0083b - 3206
            "seh"                     + //  01000 - 3211
            "seh-mz"                  + //  01000 - 3214
            "ses"                     + //  01000 - 3220
            "ses-ml"                  + //  01000 - 3223
            "sg"                      + //  01000 - 3229
            "sg-cf"                   + //  01000 - 3231
            "shi"                     + //  01000 - 3236
            "shi-latn"                + //  01000 - 3239
            "shi-latn-ma"             + //  01000 - 3247
            "shi-tfng"                + //  01000 - 3258
            "shi-tfng-ma"             + //  01000 - 3266
            "si"                      + //  0005b - 3277
            "si-lk"                   + //  0045b - 3279
            "sk"                      + //  0001b - 3284
            "sk-sk"                   + //  0041b - 3286
            "sl"                      + //  00024 - 3291
            "sl-si"                   + //  00424 - 3293
            "sma"                     + //  0783b - 3298
            "sma-no"                  + //  0183b - 3301
            "sma-se"                  + //  01c3b - 3307
            "smj"                     + //  07c3b - 3313
            "smj-no"                  + //  0103b - 3316
            "smj-se"                  + //  0143b - 3322
            "smn"                     + //  0703b - 3328
            "smn-fi"                  + //  0243b - 3331
            "sms"                     + //  0743b - 3337
            "sms-fi"                  + //  0203b - 3340
            "sn"                      + //  01000 - 3346
            "sn-latn"                 + //  01000 - 3348
            "sn-latn-zw"              + //  01000 - 3355
            "so"                      + //  00077 - 3365
            "so-dj"                   + //  01000 - 3367
            "so-et"                   + //  01000 - 3372
            "so-ke"                   + //  01000 - 3377
            "so-so"                   + //  00477 - 3382
            "sq"                      + //  0001c - 3387
            "sq-al"                   + //  0041c - 3389
            "sq-mk"                   + //  01000 - 3394
            "sq-xk"                   + //  01000 - 3399
            "sr"                      + //  07c1a - 3404
            "sr-cyrl"                 + //  06c1a - 3406
            "sr-cyrl-ba"              + //  01c1a - 3413
            "sr-cyrl-cs"              + //  00c1a - 3423
            "sr-cyrl-me"              + //  0301a - 3433
            "sr-cyrl-rs"              + //  0281a - 3443
            "sr-cyrl-xk"              + //  01000 - 3453
            "sr-latn"                 + //  0701a - 3463
            "sr-latn-ba"              + //  0181a - 3470
            "sr-latn-cs"              + //  0081a - 3480
            "sr-latn-me"              + //  02c1a - 3490
            "sr-latn-rs"              + //  0241a - 3500
            "sr-latn-xk"              + //  01000 - 3510
            "ss"                      + //  01000 - 3520
            "ss-sz"                   + //  01000 - 3522
            "ss-za"                   + //  01000 - 3527
            "ssy"                     + //  01000 - 3532
            "ssy-er"                  + //  01000 - 3535
            "st"                      + //  00030 - 3541
            "st-ls"                   + //  01000 - 3543
            "st-za"                   + //  00430 - 3548
            "sv"                      + //  0001d - 3553
            "sv-ax"                   + //  01000 - 3555
            "sv-fi"                   + //  0081d - 3560
            "sv-se"                   + //  0041d - 3565
            "sw"                      + //  00041 - 3570
            "sw-cd"                   + //  01000 - 3572
            "sw-ke"                   + //  00441 - 3577
            "sw-tz"                   + //  01000 - 3582
            "sw-ug"                   + //  01000 - 3587
            "swc"                     + //  01000 - 3592
            "swc-cd"                  + //  01000 - 3595
            "syr"                     + //  0005a - 3601
            "syr-sy"                  + //  0045a - 3604
            "ta"                      + //  00049 - 3610
            "ta-in"                   + //  00449 - 3612
            "ta-lk"                   + //  00849 - 3617
            "ta-my"                   + //  01000 - 3622
            "ta-sg"                   + //  01000 - 3627
            "te"                      + //  0004a - 3632
            "te-in"                   + //  0044a - 3634
            "teo"                     + //  01000 - 3639
            "teo-ke"                  + //  01000 - 3642
            "teo-ug"                  + //  01000 - 3648
            "tg"                      + //  00028 - 3654
            "tg-cyrl"                 + //  07c28 - 3656
            "tg-cyrl-tj"              + //  00428 - 3663
            "th"                      + //  0001e - 3673
            "th-th"                   + //  0041e - 3675
            "ti"                      + //  00073 - 3680
            "ti-er"                   + //  00873 - 3682
            "ti-et"                   + //  00473 - 3687
            "tig"                     + //  01000 - 3692
            "tig-er"                  + //  01000 - 3695
            "tk"                      + //  00042 - 3701
            "tk-tm"                   + //  00442 - 3703
            "tn"                      + //  00032 - 3708
            "tn-bw"                   + //  00832 - 3710
            "tn-za"                   + //  00432 - 3715
            "to"                      + //  01000 - 3720
            "to-to"                   + //  01000 - 3722
            "tr"                      + //  0001f - 3727
            "tr-cy"                   + //  01000 - 3729
            "tr-tr"                   + //  0041f - 3734
            "ts"                      + //  00031 - 3739
            "ts-za"                   + //  00431 - 3741
            "tt"                      + //  00044 - 3746
            "tt-ru"                   + //  00444 - 3748
            "twq"                     + //  01000 - 3753
            "twq-ne"                  + //  01000 - 3756
            "tzm"                     + //  0005f - 3762
            "tzm-arab"                + //  01000 - 3765
            "tzm-arab-ma"             + //  0045f - 3773
            "tzm-latn"                + //  07c5f - 3784
            "tzm-latn-dz"             + //  0085f - 3792
            "tzm-latn-ma"             + //  01000 - 3803
            "tzm-tfng"                + //  0785f - 3814
            "tzm-tfng-ma"             + //  0105f - 3822
            "ug"                      + //  00080 - 3833
            "ug-cn"                   + //  00480 - 3835
            "uk"                      + //  00022 - 3840
            "uk-ua"                   + //  00422 - 3842
            "ur"                      + //  00020 - 3847
            "ur-in"                   + //  00820 - 3849
            "ur-pk"                   + //  00420 - 3854
            "uz"                      + //  00043 - 3859
            "uz-arab"                 + //  01000 - 3861
            "uz-arab-af"              + //  01000 - 3868
            "uz-cyrl"                 + //  07843 - 3878
            "uz-cyrl-uz"              + //  00843 - 3885
            "uz-latn"                 + //  07c43 - 3895
            "uz-latn-uz"              + //  00443 - 3902
            "vai"                     + //  01000 - 3912
            "vai-latn"                + //  01000 - 3915
            "vai-latn-lr"             + //  01000 - 3923
            "vai-vaii"                + //  01000 - 3934
            "vai-vaii-lr"             + //  01000 - 3942
            "ve"                      + //  00033 - 3953
            "ve-za"                   + //  00433 - 3955
            "vi"                      + //  0002a - 3960
            "vi-vn"                   + //  0042a - 3962
            "vo"                      + //  01000 - 3967
            "vo-001"                  + //  01000 - 3969
            "vun"                     + //  01000 - 3975
            "vun-tz"                  + //  01000 - 3978
            "wae"                     + //  01000 - 3984
            "wae-ch"                  + //  01000 - 3987
            "wal"                     + //  01000 - 3993
            "wal-et"                  + //  01000 - 3996
            "wo"                      + //  00088 - 4002
            "wo-sn"                   + //  00488 - 4004
            "x-iv_mathan"             + //  1007f - 4009
            "xh"                      + //  00034 - 4020
            "xh-za"                   + //  00434 - 4022
            "xog"                     + //  01000 - 4027
            "xog-ug"                  + //  01000 - 4030
            "yav"                     + //  01000 - 4036
            "yav-cm"                  + //  01000 - 4039
            "yi"                      + //  0003d - 4045
            "yi-001"                  + //  0043d - 4047
            "yo"                      + //  0006a - 4053
            "yo-bj"                   + //  01000 - 4055
            "yo-ng"                   + //  0046a - 4060
            "yue"                     + //  01000 - 4065
            "yue-hk"                  + //  01000 - 4068
            "zgh"                     + //  01000 - 4074
            "zgh-tfng"                + //  01000 - 4077
            "zgh-tfng-ma"             + //  01000 - 4085
            "zh"                      + //  07804 - 4096
            "zh-chs"                  + //  00004 - 4098
            "zh-cht"                  + //  07c04 - 4104
            "zh-cn"                   + //  00804 - 4110
            "zh-cn_phoneb"            + //  50804 - 4115
            "zh-cn_stroke"            + //  20804 - 4127
            "zh-hans"                 + //  00004 - 4139
            "zh-hans-hk"              + //  01000 - 4146
            "zh-hans-mo"              + //  01000 - 4156
            "zh-hant"                 + //  07c04 - 4166
            "zh-hk"                   + //  00c04 - 4173
            "zh-hk_radstr"            + //  40c04 - 4178
            "zh-mo"                   + //  01404 - 4190
            "zh-mo_radstr"            + //  41404 - 4195
            "zh-mo_stroke"            + //  21404 - 4207
            "zh-sg"                   + //  01004 - 4219
            "zh-sg_phoneb"            + //  51004 - 4224
            "zh-sg_stroke"            + //  21004 - 4236
            "zh-tw"                   + //  00404 - 4248
            "zh-tw_pronun"            + //  30404 - 4253
            "zh-tw_radstr"            + //  40404 - 4265
            "zu"                      + //  00035 - 4277
            "zu-za";                    //  00435 - 4279

        // c_threeLetterWindowsLanguageName is string containing 3-letter Windows language names
        // every 3-characters entry is matching locale name entry in c_localeNames

        private const string c_threeLetterWindowsLanguageName =
            "ZZZ" + // aa
            "ZZZ" + // aa-dj
            "ZZZ" + // aa-er
            "ZZZ" + // aa-et
            "AFK" + // af
            "ZZZ" + // af-na
            "AFK" + // af-za
            "ZZZ" + // agq
            "ZZZ" + // agq-cm
            "ZZZ" + // ak
            "ZZZ" + // ak-gh
            "AMH" + // am
            "AMH" + // am-et
            "ARA" + // ar
            "ZZZ" + // ar-001
            "ARU" + // ar-ae
            "ARH" + // ar-bh
            "ZZZ" + // ar-dj
            "ARG" + // ar-dz
            "ARE" + // ar-eg
            "ZZZ" + // ar-er
            "ZZZ" + // ar-il
            "ARI" + // ar-iq
            "ARJ" + // ar-jo
            "ZZZ" + // ar-km
            "ARK" + // ar-kw
            "ARB" + // ar-lb
            "ARL" + // ar-ly
            "ARM" + // ar-ma
            "ZZZ" + // ar-mr
            "ARO" + // ar-om
            "ZZZ" + // ar-ps
            "ARQ" + // ar-qa
            "ARA" + // ar-sa
            "ZZZ" + // ar-sd
            "ZZZ" + // ar-so
            "ZZZ" + // ar-ss
            "ARS" + // ar-sy
            "ZZZ" + // ar-td
            "ART" + // ar-tn
            "ARY" + // ar-ye
            "MPD" + // arn
            "MPD" + // arn-cl
            "ASM" + // as
            "ASM" + // as-in
            "ZZZ" + // asa
            "ZZZ" + // asa-tz
            "ZZZ" + // ast
            "ZZZ" + // ast-es
            "AZE" + // az
            "AZC" + // az-cyrl
            "AZC" + // az-cyrl-az
            "AZE" + // az-latn
            "AZE" + // az-latn-az
            "BAS" + // ba
            "BAS" + // ba-ru
            "ZZZ" + // bas
            "ZZZ" + // bas-cm
            "BEL" + // be
            "BEL" + // be-by
            "ZZZ" + // bem
            "ZZZ" + // bem-zm
            "ZZZ" + // bez
            "ZZZ" + // bez-tz
            "BGR" + // bg
            "BGR" + // bg-bg
            "ZZZ" + // bin
            "ZZZ" + // bin-ng
            "ZZZ" + // bm
            "ZZZ" + // bm-latn
            "ZZZ" + // bm-latn-ml
            "BNB" + // bn
            "BNB" + // bn-bd
            "BNG" + // bn-in
            "BOB" + // bo
            "BOB" + // bo-cn
            "ZZZ" + // bo-in
            "BRE" + // br
            "BRE" + // br-fr
            "ZZZ" + // brx
            "ZZZ" + // brx-in
            "BSB" + // bs
            "BSC" + // bs-cyrl
            "BSC" + // bs-cyrl-ba
            "BSB" + // bs-latn
            "BSB" + // bs-latn-ba
            "ZZZ" + // byn
            "ZZZ" + // byn-er
            "CAT" + // ca
            "ZZZ" + // ca-ad
            "CAT" + // ca-es
            "VAL" + // ca-es-valencia
            "ZZZ" + // ca-fr
            "ZZZ" + // ca-it
            "ZZZ" + // ce
            "ZZZ" + // ce-ru
            "ZZZ" + // cgg
            "ZZZ" + // cgg-ug
            "CRE" + // chr
            "CRE" + // chr-cher
            "CRE" + // chr-cher-us
            "COS" + // co
            "COS" + // co-fr
            "CSY" + // cs
            "CSY" + // cs-cz
            "ZZZ" + // cu
            "ZZZ" + // cu-ru
            "CYM" + // cy
            "CYM" + // cy-gb
            "DAN" + // da
            "DAN" + // da-dk
            "ZZZ" + // da-gl
            "ZZZ" + // dav
            "ZZZ" + // dav-ke
            "DEU" + // de
            "DEA" + // de-at
            "ZZZ" + // de-be
            "DES" + // de-ch
            "DEU" + // de-de
            "DEU" + // de-de_phoneb
            "ZZZ" + // de-it
            "DEC" + // de-li
            "DEL" + // de-lu
            "ZZZ" + // dje
            "ZZZ" + // dje-ne
            "DSB" + // dsb
            "DSB" + // dsb-de
            "ZZZ" + // dua
            "ZZZ" + // dua-cm
            "DIV" + // dv
            "DIV" + // dv-mv
            "ZZZ" + // dyo
            "ZZZ" + // dyo-sn
            "ZZZ" + // dz
            "ZZZ" + // dz-bt
            "ZZZ" + // ebu
            "ZZZ" + // ebu-ke
            "ZZZ" + // ee
            "ZZZ" + // ee-gh
            "ZZZ" + // ee-tg
            "ELL" + // el
            "ZZZ" + // el-cy
            "ELL" + // el-gr
            "ENU" + // en
            "ZZZ" + // en-001
            "ENB" + // en-029
            "ZZZ" + // en-150
            "ZZZ" + // en-ag
            "ZZZ" + // en-ai
            "ZZZ" + // en-as
            "ZZZ" + // en-at
            "ENA" + // en-au
            "ZZZ" + // en-bb
            "ZZZ" + // en-be
            "ZZZ" + // en-bi
            "ZZZ" + // en-bm
            "ZZZ" + // en-bs
            "ZZZ" + // en-bw
            "ENL" + // en-bz
            "ENC" + // en-ca
            "ZZZ" + // en-cc
            "ZZZ" + // en-ch
            "ZZZ" + // en-ck
            "ZZZ" + // en-cm
            "ZZZ" + // en-cx
            "ZZZ" + // en-cy
            "ZZZ" + // en-de
            "ZZZ" + // en-dk
            "ZZZ" + // en-dm
            "ZZZ" + // en-er
            "ZZZ" + // en-fi
            "ZZZ" + // en-fj
            "ZZZ" + // en-fk
            "ZZZ" + // en-fm
            "ENG" + // en-gb
            "ZZZ" + // en-gd
            "ZZZ" + // en-gg
            "ZZZ" + // en-gh
            "ZZZ" + // en-gi
            "ZZZ" + // en-gm
            "ZZZ" + // en-gu
            "ZZZ" + // en-gy
            "ENH" + // en-hk
            "ZZZ" + // en-id
            "ENI" + // en-ie
            "ZZZ" + // en-il
            "ZZZ" + // en-im
            "ENN" + // en-in
            "ZZZ" + // en-io
            "ZZZ" + // en-je
            "ENJ" + // en-jm
            "ZZZ" + // en-ke
            "ZZZ" + // en-ki
            "ZZZ" + // en-kn
            "ZZZ" + // en-ky
            "ZZZ" + // en-lc
            "ZZZ" + // en-lr
            "ZZZ" + // en-ls
            "ZZZ" + // en-mg
            "ZZZ" + // en-mh
            "ZZZ" + // en-mo
            "ZZZ" + // en-mp
            "ZZZ" + // en-ms
            "ZZZ" + // en-mt
            "ZZZ" + // en-mu
            "ZZZ" + // en-mw
            "ENM" + // en-my
            "ZZZ" + // en-na
            "ZZZ" + // en-nf
            "ZZZ" + // en-ng
            "ZZZ" + // en-nl
            "ZZZ" + // en-nr
            "ZZZ" + // en-nu
            "ENZ" + // en-nz
            "ZZZ" + // en-pg
            "ENP" + // en-ph
            "ZZZ" + // en-pk
            "ZZZ" + // en-pn
            "ZZZ" + // en-pr
            "ZZZ" + // en-pw
            "ZZZ" + // en-rw
            "ZZZ" + // en-sb
            "ZZZ" + // en-sc
            "ZZZ" + // en-sd
            "ZZZ" + // en-se
            "ENE" + // en-sg
            "ZZZ" + // en-sh
            "ZZZ" + // en-si
            "ZZZ" + // en-sl
            "ZZZ" + // en-ss
            "ZZZ" + // en-sx
            "ZZZ" + // en-sz
            "ZZZ" + // en-tc
            "ZZZ" + // en-tk
            "ZZZ" + // en-to
            "ENT" + // en-tt
            "ZZZ" + // en-tv
            "ZZZ" + // en-tz
            "ZZZ" + // en-ug
            "ZZZ" + // en-um
            "ENU" + // en-us
            "ZZZ" + // en-vc
            "ZZZ" + // en-vg
            "ZZZ" + // en-vi
            "ZZZ" + // en-vu
            "ZZZ" + // en-ws
            "ENS" + // en-za
            "ZZZ" + // en-zm
            "ENW" + // en-zw
            "ZZZ" + // eo
            "ZZZ" + // eo-001
            "ESN" + // es
            "ESJ" + // es-419
            "ESS" + // es-ar
            "ESB" + // es-bo
            "ZZZ" + // es-br
            "ESL" + // es-cl
            "ESO" + // es-co
            "ESC" + // es-cr
            "ESK" + // es-cu
            "ESD" + // es-do
            "ESF" + // es-ec
            "ESN" + // es-es
            "ESP" + // es-es_tradnl
            "ZZZ" + // es-gq
            "ESG" + // es-gt
            "ESH" + // es-hn
            "ESM" + // es-mx
            "ESI" + // es-ni
            "ESA" + // es-pa
            "ESR" + // es-pe
            "ZZZ" + // es-ph
            "ESU" + // es-pr
            "ESZ" + // es-py
            "ESE" + // es-sv
            "EST" + // es-us
            "ESY" + // es-uy
            "ESV" + // es-ve
            "ETI" + // et
            "ETI" + // et-ee
            "EUQ" + // eu
            "EUQ" + // eu-es
            "ZZZ" + // ewo
            "ZZZ" + // ewo-cm
            "FAR" + // fa
            "FAR" + // fa-ir
            "FUL" + // ff
            "ZZZ" + // ff-cm
            "ZZZ" + // ff-gn
            "FUL" + // ff-latn
            "FUL" + // ff-latn-sn
            "ZZZ" + // ff-mr
            "ZZZ" + // ff-ng
            "FIN" + // fi
            "FIN" + // fi-fi
            "FPO" + // fil
            "FPO" + // fil-ph
            "FOS" + // fo
            "ZZZ" + // fo-dk
            "FOS" + // fo-fo
            "FRA" + // fr
            "ZZZ" + // fr-029
            "FRB" + // fr-be
            "ZZZ" + // fr-bf
            "ZZZ" + // fr-bi
            "ZZZ" + // fr-bj
            "ZZZ" + // fr-bl
            "FRC" + // fr-ca
            "FRD" + // fr-cd
            "ZZZ" + // fr-cf
            "ZZZ" + // fr-cg
            "FRS" + // fr-ch
            "FRI" + // fr-ci
            "FRE" + // fr-cm
            "ZZZ" + // fr-dj
            "ZZZ" + // fr-dz
            "FRA" + // fr-fr
            "ZZZ" + // fr-ga
            "ZZZ" + // fr-gf
            "ZZZ" + // fr-gn
            "ZZZ" + // fr-gp
            "ZZZ" + // fr-gq
            "FRH" + // fr-ht
            "ZZZ" + // fr-km
            "FRL" + // fr-lu
            "FRO" + // fr-ma
            "FRM" + // fr-mc
            "ZZZ" + // fr-mf
            "ZZZ" + // fr-mg
            "FRF" + // fr-ml
            "ZZZ" + // fr-mq
            "ZZZ" + // fr-mr
            "ZZZ" + // fr-mu
            "ZZZ" + // fr-nc
            "ZZZ" + // fr-ne
            "ZZZ" + // fr-pf
            "ZZZ" + // fr-pm
            "FRR" + // fr-re
            "ZZZ" + // fr-rw
            "ZZZ" + // fr-sc
            "FRN" + // fr-sn
            "ZZZ" + // fr-sy
            "ZZZ" + // fr-td
            "ZZZ" + // fr-tg
            "ZZZ" + // fr-tn
            "ZZZ" + // fr-vu
            "ZZZ" + // fr-wf
            "ZZZ" + // fr-yt
            "ZZZ" + // fur
            "ZZZ" + // fur-it
            "FYN" + // fy
            "FYN" + // fy-nl
            "IRE" + // ga
            "IRE" + // ga-ie
            "GLA" + // gd
            "GLA" + // gd-gb
            "GLC" + // gl
            "GLC" + // gl-es
            "GRN" + // gn
            "GRN" + // gn-py
            "ZZZ" + // gsw
            "ZZZ" + // gsw-ch
            "GSW" + // gsw-fr
            "ZZZ" + // gsw-li
            "GUJ" + // gu
            "GUJ" + // gu-in
            "ZZZ" + // guz
            "ZZZ" + // guz-ke
            "ZZZ" + // gv
            "ZZZ" + // gv-im
            "HAU" + // ha
            "HAU" + // ha-latn
            "ZZZ" + // ha-latn-gh
            "ZZZ" + // ha-latn-ne
            "HAU" + // ha-latn-ng
            "HAW" + // haw
            "HAW" + // haw-us
            "HEB" + // he
            "HEB" + // he-il
            "HIN" + // hi
            "HIN" + // hi-in
            "HRV" + // hr
            "HRB" + // hr-ba
            "HRV" + // hr-hr
            "HSB" + // hsb
            "HSB" + // hsb-de
            "HUN" + // hu
            "HUN" + // hu-hu
            "HUN" + // hu-hu_technl
            "HYE" + // hy
            "HYE" + // hy-am
            "ZZZ" + // ia
            "ZZZ" + // ia-001
            "ZZZ" + // ia-fr
            "ZZZ" + // ibb
            "ZZZ" + // ibb-ng
            "IND" + // id
            "IND" + // id-id
            "IBO" + // ig
            "IBO" + // ig-ng
            "III" + // ii
            "III" + // ii-cn
            "ISL" + // is
            "ISL" + // is-is
            "ITA" + // it
            "ITS" + // it-ch
            "ITA" + // it-it
            "ZZZ" + // it-sm
            "IUK" + // iu
            "IUS" + // iu-cans
            "IUS" + // iu-cans-ca
            "IUK" + // iu-latn
            "IUK" + // iu-latn-ca
            "JPN" + // ja
            "JPN" + // ja-jp
            "JPN" + // ja-jp_radstr
            "ZZZ" + // jgo
            "ZZZ" + // jgo-cm
            "ZZZ" + // jmc
            "ZZZ" + // jmc-tz
            "JAV" + // jv
            "ZZZ" + // jv-java
            "ZZZ" + // jv-java-id
            "JAV" + // jv-latn
            "JAV" + // jv-latn-id
            "KAT" + // ka
            "KAT" + // ka-ge
            "KAT" + // ka-ge_modern
            "ZZZ" + // kab
            "ZZZ" + // kab-dz
            "ZZZ" + // kam
            "ZZZ" + // kam-ke
            "ZZZ" + // kde
            "ZZZ" + // kde-tz
            "ZZZ" + // kea
            "ZZZ" + // kea-cv
            "ZZZ" + // khq
            "ZZZ" + // khq-ml
            "ZZZ" + // ki
            "ZZZ" + // ki-ke
            "KKZ" + // kk
            "KKZ" + // kk-kz
            "ZZZ" + // kkj
            "ZZZ" + // kkj-cm
            "KAL" + // kl
            "KAL" + // kl-gl
            "ZZZ" + // kln
            "ZZZ" + // kln-ke
            "KHM" + // km
            "KHM" + // km-kh
            "KDI" + // kn
            "KDI" + // kn-in
            "KOR" + // ko
            "ZZZ" + // ko-kp
            "KOR" + // ko-kr
            "KNK" + // kok
            "KNK" + // kok-in
            "ZZZ" + // kr
            "ZZZ" + // kr-ng
            "ZZZ" + // ks
            "ZZZ" + // ks-arab
            "ZZZ" + // ks-arab-in
            "ZZZ" + // ks-deva
            "ZZZ" + // ks-deva-in
            "ZZZ" + // ksb
            "ZZZ" + // ksb-tz
            "ZZZ" + // ksf
            "ZZZ" + // ksf-cm
            "ZZZ" + // ksh
            "ZZZ" + // ksh-de
            "KUR" + // ku
            "KUR" + // ku-arab
            "KUR" + // ku-arab-iq
            "ZZZ" + // ku-arab-ir
            "ZZZ" + // kw
            "ZZZ" + // kw-gb
            "KYR" + // ky
            "KYR" + // ky-kg
            "ZZZ" + // la
            "ZZZ" + // la-001
            "ZZZ" + // lag
            "ZZZ" + // lag-tz
            "LBX" + // lb
            "LBX" + // lb-lu
            "ZZZ" + // lg
            "ZZZ" + // lg-ug
            "ZZZ" + // lkt
            "ZZZ" + // lkt-us
            "ZZZ" + // ln
            "ZZZ" + // ln-ao
            "ZZZ" + // ln-cd
            "ZZZ" + // ln-cf
            "ZZZ" + // ln-cg
            "LAO" + // lo
            "LAO" + // lo-la
            "ZZZ" + // lrc
            "ZZZ" + // lrc-iq
            "ZZZ" + // lrc-ir
            "LTH" + // lt
            "LTH" + // lt-lt
            "ZZZ" + // lu
            "ZZZ" + // lu-cd
            "ZZZ" + // luo
            "ZZZ" + // luo-ke
            "ZZZ" + // luy
            "ZZZ" + // luy-ke
            "LVI" + // lv
            "LVI" + // lv-lv
            "ZZZ" + // mas
            "ZZZ" + // mas-ke
            "ZZZ" + // mas-tz
            "ZZZ" + // mer
            "ZZZ" + // mer-ke
            "ZZZ" + // mfe
            "ZZZ" + // mfe-mu
            "MLG" + // mg
            "MLG" + // mg-mg
            "ZZZ" + // mgh
            "ZZZ" + // mgh-mz
            "ZZZ" + // mgo
            "ZZZ" + // mgo-cm
            "MRI" + // mi
            "MRI" + // mi-nz
            "MKI" + // mk
            "MKI" + // mk-mk
            "MYM" + // ml
            "MYM" + // ml-in
            "MNN" + // mn
            "MNN" + // mn-cyrl
            "MNN" + // mn-mn
            "MNG" + // mn-mong
            "MNG" + // mn-mong-cn
            "MNM" + // mn-mong-mn
            "ZZZ" + // mni
            "ZZZ" + // mni-in
            "MWK" + // moh
            "MWK" + // moh-ca
            "MAR" + // mr
            "MAR" + // mr-in
            "MSL" + // ms
            "MSB" + // ms-bn
            "MSL" + // ms-my
            "ZZZ" + // ms-sg
            "MLT" + // mt
            "MLT" + // mt-mt
            "ZZZ" + // mua
            "ZZZ" + // mua-cm
            "MYA" + // my
            "MYA" + // my-mm
            "ZZZ" + // mzn
            "ZZZ" + // mzn-ir
            "ZZZ" + // naq
            "ZZZ" + // naq-na
            "NOR" + // nb
            "NOR" + // nb-no
            "ZZZ" + // nb-sj
            "ZZZ" + // nd
            "ZZZ" + // nd-zw
            "ZZZ" + // nds
            "ZZZ" + // nds-de
            "ZZZ" + // nds-nl
            "NEP" + // ne
            "NEI" + // ne-in
            "NEP" + // ne-np
            "NLD" + // nl
            "ZZZ" + // nl-aw
            "NLB" + // nl-be
            "ZZZ" + // nl-bq
            "ZZZ" + // nl-cw
            "NLD" + // nl-nl
            "ZZZ" + // nl-sr
            "ZZZ" + // nl-sx
            "ZZZ" + // nmg
            "ZZZ" + // nmg-cm
            "NON" + // nn
            "NON" + // nn-no
            "ZZZ" + // nnh
            "ZZZ" + // nnh-cm
            "NOR" + // no
            "NQO" + // nqo
            "NQO" + // nqo-gn
            "ZZZ" + // nr
            "ZZZ" + // nr-za
            "NSO" + // nso
            "NSO" + // nso-za
            "ZZZ" + // nus
            "ZZZ" + // nus-ss
            "ZZZ" + // nyn
            "ZZZ" + // nyn-ug
            "OCI" + // oc
            "OCI" + // oc-fr
            "ORM" + // om
            "ORM" + // om-et
            "ZZZ" + // om-ke
            "ORI" + // or
            "ORI" + // or-in
            "ZZZ" + // os
            "ZZZ" + // os-ge
            "ZZZ" + // os-ru
            "PAN" + // pa
            "PAP" + // pa-arab
            "PAP" + // pa-arab-pk
            "PAN" + // pa-in
            "ZZZ" + // pap
            "ZZZ" + // pap-029
            "PLK" + // pl
            "PLK" + // pl-pl
            "ZZZ" + // prg
            "ZZZ" + // prg-001
            "PRS" + // prs
            "PRS" + // prs-af
            "PAS" + // ps
            "PAS" + // ps-af
            "PTB" + // pt
            "PTA" + // pt-ao
            "PTB" + // pt-br
            "ZZZ" + // pt-ch
            "ZZZ" + // pt-cv
            "ZZZ" + // pt-gq
            "ZZZ" + // pt-gw
            "ZZZ" + // pt-lu
            "ZZZ" + // pt-mo
            "ZZZ" + // pt-mz
            "PTG" + // pt-pt
            "ZZZ" + // pt-st
            "ZZZ" + // pt-tl
            "ENJ" + // qps-latn-x-sh
            "ENU" + // qps-ploc
            "JPN" + // qps-ploca
            "ARA" + // qps-plocm
            "QUT" + // quc
            "QUT" + // quc-latn
            "QUT" + // quc-latn-gt
            "QUB" + // quz
            "QUB" + // quz-bo
            "QUE" + // quz-ec
            "QUP" + // quz-pe
            "RMC" + // rm
            "RMC" + // rm-ch
            "ZZZ" + // rn
            "ZZZ" + // rn-bi
            "ROM" + // ro
            "ROD" + // ro-md
            "ROM" + // ro-ro
            "ZZZ" + // rof
            "ZZZ" + // rof-tz
            "RUS" + // ru
            "ZZZ" + // ru-by
            "ZZZ" + // ru-kg
            "ZZZ" + // ru-kz
            "RUM" + // ru-md
            "RUS" + // ru-ru
            "ZZZ" + // ru-ua
            "KIN" + // rw
            "KIN" + // rw-rw
            "ZZZ" + // rwk
            "ZZZ" + // rwk-tz
            "SAN" + // sa
            "SAN" + // sa-in
            "SAH" + // sah
            "SAH" + // sah-ru
            "ZZZ" + // saq
            "ZZZ" + // saq-ke
            "ZZZ" + // sbp
            "ZZZ" + // sbp-tz
            "SIP" + // sd
            "SIP" + // sd-arab
            "SIP" + // sd-arab-pk
            "ZZZ" + // sd-deva
            "ZZZ" + // sd-deva-in
            "SME" + // se
            "SMG" + // se-fi
            "SME" + // se-no
            "SMF" + // se-se
            "ZZZ" + // seh
            "ZZZ" + // seh-mz
            "ZZZ" + // ses
            "ZZZ" + // ses-ml
            "ZZZ" + // sg
            "ZZZ" + // sg-cf
            "ZZZ" + // shi
            "ZZZ" + // shi-latn
            "ZZZ" + // shi-latn-ma
            "ZZZ" + // shi-tfng
            "ZZZ" + // shi-tfng-ma
            "SIN" + // si
            "SIN" + // si-lk
            "SKY" + // sk
            "SKY" + // sk-sk
            "SLV" + // sl
            "SLV" + // sl-si
            "SMB" + // sma
            "SMA" + // sma-no
            "SMB" + // sma-se
            "SMK" + // smj
            "SMJ" + // smj-no
            "SMK" + // smj-se
            "SMN" + // smn
            "SMN" + // smn-fi
            "SMS" + // sms
            "SMS" + // sms-fi
            "SNA" + // sn
            "SNA" + // sn-latn
            "SNA" + // sn-latn-zw
            "SOM" + // so
            "ZZZ" + // so-dj
            "ZZZ" + // so-et
            "ZZZ" + // so-ke
            "SOM" + // so-so
            "SQI" + // sq
            "SQI" + // sq-al
            "ZZZ" + // sq-mk
            "ZZZ" + // sq-xk
            "SRM" + // sr
            "SRO" + // sr-cyrl
            "SRN" + // sr-cyrl-ba
            "SRB" + // sr-cyrl-cs
            "SRQ" + // sr-cyrl-me
            "SRO" + // sr-cyrl-rs
            "ZZZ" + // sr-cyrl-xk
            "SRM" + // sr-latn
            "SRS" + // sr-latn-ba
            "SRL" + // sr-latn-cs
            "SRP" + // sr-latn-me
            "SRM" + // sr-latn-rs
            "ZZZ" + // sr-latn-xk
            "ZZZ" + // ss
            "ZZZ" + // ss-sz
            "ZZZ" + // ss-za
            "ZZZ" + // ssy
            "ZZZ" + // ssy-er
            "SOT" + // st
            "ZZZ" + // st-ls
            "SOT" + // st-za
            "SVE" + // sv
            "ZZZ" + // sv-ax
            "SVF" + // sv-fi
            "SVE" + // sv-se
            "SWK" + // sw
            "ZZZ" + // sw-cd
            "SWK" + // sw-ke
            "ZZZ" + // sw-tz
            "ZZZ" + // sw-ug
            "ZZZ" + // swc
            "ZZZ" + // swc-cd
            "SYR" + // syr
            "SYR" + // syr-sy
            "TAI" + // ta
            "TAI" + // ta-in
            "TAM" + // ta-lk
            "ZZZ" + // ta-my
            "ZZZ" + // ta-sg
            "TEL" + // te
            "TEL" + // te-in
            "ZZZ" + // teo
            "ZZZ" + // teo-ke
            "ZZZ" + // teo-ug
            "TAJ" + // tg
            "TAJ" + // tg-cyrl
            "TAJ" + // tg-cyrl-tj
            "THA" + // th
            "THA" + // th-th
            "TIR" + // ti
            "TIR" + // ti-er
            "TIE" + // ti-et
            "ZZZ" + // tig
            "ZZZ" + // tig-er
            "TUK" + // tk
            "TUK" + // tk-tm
            "TSN" + // tn
            "TSB" + // tn-bw
            "TSN" + // tn-za
            "ZZZ" + // to
            "ZZZ" + // to-to
            "TRK" + // tr
            "ZZZ" + // tr-cy
            "TRK" + // tr-tr
            "TSO" + // ts
            "TSO" + // ts-za
            "TTT" + // tt
            "TTT" + // tt-ru
            "ZZZ" + // twq
            "ZZZ" + // twq-ne
            "TZA" + // tzm
            "ZZZ" + // tzm-arab
            "ZZZ" + // tzm-arab-ma
            "TZA" + // tzm-latn
            "TZA" + // tzm-latn-dz
            "ZZZ" + // tzm-latn-ma
            "TZM" + // tzm-tfng
            "TZM" + // tzm-tfng-ma
            "UIG" + // ug
            "UIG" + // ug-cn
            "UKR" + // uk
            "UKR" + // uk-ua
            "URD" + // ur
            "URI" + // ur-in
            "URD" + // ur-pk
            "UZB" + // uz
            "ZZZ" + // uz-arab
            "ZZZ" + // uz-arab-af
            "UZC" + // uz-cyrl
            "UZC" + // uz-cyrl-uz
            "UZB" + // uz-latn
            "UZB" + // uz-latn-uz
            "ZZZ" + // vai
            "ZZZ" + // vai-latn
            "ZZZ" + // vai-latn-lr
            "ZZZ" + // vai-vaii
            "ZZZ" + // vai-vaii-lr
            "ZZZ" + // ve
            "ZZZ" + // ve-za
            "VIT" + // vi
            "VIT" + // vi-vn
            "ZZZ" + // vo
            "ZZZ" + // vo-001
            "ZZZ" + // vun
            "ZZZ" + // vun-tz
            "ZZZ" + // wae
            "ZZZ" + // wae-ch
            "ZZZ" + // wal
            "ZZZ" + // wal-et
            "WOL" + // wo
            "WOL" + // wo-sn
            "IVL" + // x-iv_mathan
            "XHO" + // xh
            "XHO" + // xh-za
            "ZZZ" + // xog
            "ZZZ" + // xog-ug
            "ZZZ" + // yav
            "ZZZ" + // yav-cm
            "ZZZ" + // yi
            "ZZZ" + // yi-001
            "YOR" + // yo
            "ZZZ" + // yo-bj
            "YOR" + // yo-ng
            "ZZZ" + // yue
            "ZZZ" + // yue-hk
            "ZHG" + // zgh
            "ZHG" + // zgh-tfng
            "ZHG" + // zgh-tfng-ma
            "CHS" + // zh
            "CHS" + // zh-chs
            "CHT" + // zh-cht
            "CHS" + // zh-cn
            "CHS" + // zh-cn_phoneb
            "CHS" + // zh-cn_stroke
            "CHS" + // zh-hans
            "ZZZ" + // zh-hans-hk
            "ZZZ" + // zh-hans-mo
            "ZHH" + // zh-hant
            "ZHH" + // zh-hk
            "ZHH" + // zh-hk_radstr
            "ZHM" + // zh-mo
            "ZHM" + // zh-mo_radstr
            "ZHM" + // zh-mo_stroke
            "ZHI" + // zh-sg
            "ZHI" + // zh-sg_phoneb
            "ZHI" + // zh-sg_stroke
            "CHT" + // zh-tw
            "CHT" + // zh-tw_pronun
            "CHT" + // zh-tw_radstr
            "ZUL" + // zu
            "ZUL";  // zu-za

        // s_localeNamesIndices contains the start index of every culture name in the string
        // s_localeNames. We infer the length of each string by looking at the start index
        // of the next string.
        private static readonly int[] s_localeNamesIndices = new int[]
        {
            // c_localeNames index, // index to this array - culture name
            0   , // 0    - aa
            2   , // 1    - aa-dj
            7   , // 2    - aa-er
            12  , // 3    - aa-et
            17  , // 4    - af
            19  , // 5    - af-na
            24  , // 6    - af-za
            29  , // 7    - agq
            32  , // 8    - agq-cm
            38  , // 9    - ak
            40  , // 10   - ak-gh
            45  , // 11   - am
            47  , // 12   - am-et
            52  , // 13   - ar
            54  , // 14   - ar-001
            60  , // 15   - ar-ae
            65  , // 16   - ar-bh
            70  , // 17   - ar-dj
            75  , // 18   - ar-dz
            80  , // 19   - ar-eg
            85  , // 20   - ar-er
            90  , // 21   - ar-il
            95  , // 22   - ar-iq
            100 , // 23   - ar-jo
            105 , // 24   - ar-km
            110 , // 25   - ar-kw
            115 , // 26   - ar-lb
            120 , // 27   - ar-ly
            125 , // 28   - ar-ma
            130 , // 29   - ar-mr
            135 , // 30   - ar-om
            140 , // 31   - ar-ps
            145 , // 32   - ar-qa
            150 , // 33   - ar-sa
            155 , // 34   - ar-sd
            160 , // 35   - ar-so
            165 , // 36   - ar-ss
            170 , // 37   - ar-sy
            175 , // 38   - ar-td
            180 , // 39   - ar-tn
            185 , // 40   - ar-ye
            190 , // 41   - arn
            193 , // 42   - arn-cl
            199 , // 43   - as
            201 , // 44   - as-in
            206 , // 45   - asa
            209 , // 46   - asa-tz
            215 , // 47   - ast
            218 , // 48   - ast-es
            224 , // 49   - az
            226 , // 50   - az-cyrl
            233 , // 51   - az-cyrl-az
            243 , // 52   - az-latn
            250 , // 53   - az-latn-az
            260 , // 54   - ba
            262 , // 55   - ba-ru
            267 , // 56   - bas
            270 , // 57   - bas-cm
            276 , // 58   - be
            278 , // 59   - be-by
            283 , // 60   - bem
            286 , // 61   - bem-zm
            292 , // 62   - bez
            295 , // 63   - bez-tz
            301 , // 64   - bg
            303 , // 65   - bg-bg
            308 , // 66   - bin
            311 , // 67   - bin-ng
            317 , // 68   - bm
            319 , // 69   - bm-latn
            326 , // 70   - bm-latn-ml
            336 , // 71   - bn
            338 , // 72   - bn-bd
            343 , // 73   - bn-in
            348 , // 74   - bo
            350 , // 75   - bo-cn
            355 , // 76   - bo-in
            360 , // 77   - br
            362 , // 78   - br-fr
            367 , // 79   - brx
            370 , // 80   - brx-in
            376 , // 81   - bs
            378 , // 82   - bs-cyrl
            385 , // 83   - bs-cyrl-ba
            395 , // 84   - bs-latn
            402 , // 85   - bs-latn-ba
            412 , // 86   - byn
            415 , // 87   - byn-er
            421 , // 88   - ca
            423 , // 89   - ca-ad
            428 , // 90   - ca-es
            433 , // 91   - ca-es-valencia
            447 , // 92   - ca-fr
            452 , // 93   - ca-it
            457 , // 94   - ce
            459 , // 95   - ce-ru
            464 , // 96   - cgg
            467 , // 97   - cgg-ug
            473 , // 98   - chr
            476 , // 99   - chr-cher
            484 , // 100  - chr-cher-us
            495 , // 101  - co
            497 , // 102  - co-fr
            502 , // 103  - cs
            504 , // 104  - cs-cz
            509 , // 105  - cu
            511 , // 106  - cu-ru
            516 , // 107  - cy
            518 , // 108  - cy-gb
            523 , // 109  - da
            525 , // 110  - da-dk
            530 , // 111  - da-gl
            535 , // 112  - dav
            538 , // 113  - dav-ke
            544 , // 114  - de
            546 , // 115  - de-at
            551 , // 116  - de-be
            556 , // 117  - de-ch
            561 , // 118  - de-de
            566 , // 119  - de-de_phoneb
            578 , // 120  - de-it
            583 , // 121  - de-li
            588 , // 122  - de-lu
            593 , // 123  - dje
            596 , // 124  - dje-ne
            602 , // 125  - dsb
            605 , // 126  - dsb-de
            611 , // 127  - dua
            614 , // 128  - dua-cm
            620 , // 129  - dv
            622 , // 130  - dv-mv
            627 , // 131  - dyo
            630 , // 132  - dyo-sn
            636 , // 133  - dz
            638 , // 134  - dz-bt
            643 , // 135  - ebu
            646 , // 136  - ebu-ke
            652 , // 137  - ee
            654 , // 138  - ee-gh
            659 , // 139  - ee-tg
            664 , // 140  - el
            666 , // 141  - el-cy
            671 , // 142  - el-gr
            676 , // 143  - en
            678 , // 144  - en-001
            684 , // 145  - en-029
            690 , // 146  - en-150
            696 , // 147  - en-ag
            701 , // 148  - en-ai
            706 , // 149  - en-as
            711 , // 150  - en-at
            716 , // 151  - en-au
            721 , // 152  - en-bb
            726 , // 153  - en-be
            731 , // 154  - en-bi
            736 , // 155  - en-bm
            741 , // 156  - en-bs
            746 , // 157  - en-bw
            751 , // 158  - en-bz
            756 , // 159  - en-ca
            761 , // 160  - en-cc
            766 , // 161  - en-ch
            771 , // 162  - en-ck
            776 , // 163  - en-cm
            781 , // 164  - en-cx
            786 , // 165  - en-cy
            791 , // 166  - en-de
            796 , // 167  - en-dk
            801 , // 168  - en-dm
            806 , // 169  - en-er
            811 , // 170  - en-fi
            816 , // 171  - en-fj
            821 , // 172  - en-fk
            826 , // 173  - en-fm
            831 , // 174  - en-gb
            836 , // 175  - en-gd
            841 , // 176  - en-gg
            846 , // 177  - en-gh
            851 , // 178  - en-gi
            856 , // 179  - en-gm
            861 , // 180  - en-gu
            866 , // 181  - en-gy
            871 , // 182  - en-hk
            876 , // 183  - en-id
            881 , // 184  - en-ie
            886 , // 185  - en-il
            891 , // 186  - en-im
            896 , // 187  - en-in
            901 , // 188  - en-io
            906 , // 189  - en-je
            911 , // 190  - en-jm
            916 , // 191  - en-ke
            921 , // 192  - en-ki
            926 , // 193  - en-kn
            931 , // 194  - en-ky
            936 , // 195  - en-lc
            941 , // 196  - en-lr
            946 , // 197  - en-ls
            951 , // 198  - en-mg
            956 , // 199  - en-mh
            961 , // 200  - en-mo
            966 , // 201  - en-mp
            971 , // 202  - en-ms
            976 , // 203  - en-mt
            981 , // 204  - en-mu
            986 , // 205  - en-mw
            991 , // 206  - en-my
            996 , // 207  - en-na
            1001, // 208  - en-nf
            1006, // 209  - en-ng
            1011, // 210  - en-nl
            1016, // 211  - en-nr
            1021, // 212  - en-nu
            1026, // 213  - en-nz
            1031, // 214  - en-pg
            1036, // 215  - en-ph
            1041, // 216  - en-pk
            1046, // 217  - en-pn
            1051, // 218  - en-pr
            1056, // 219  - en-pw
            1061, // 220  - en-rw
            1066, // 221  - en-sb
            1071, // 222  - en-sc
            1076, // 223  - en-sd
            1081, // 224  - en-se
            1086, // 225  - en-sg
            1091, // 226  - en-sh
            1096, // 227  - en-si
            1101, // 228  - en-sl
            1106, // 229  - en-ss
            1111, // 230  - en-sx
            1116, // 231  - en-sz
            1121, // 232  - en-tc
            1126, // 233  - en-tk
            1131, // 234  - en-to
            1136, // 235  - en-tt
            1141, // 236  - en-tv
            1146, // 237  - en-tz
            1151, // 238  - en-ug
            1156, // 239  - en-um
            1161, // 240  - en-us
            1166, // 241  - en-vc
            1171, // 242  - en-vg
            1176, // 243  - en-vi
            1181, // 244  - en-vu
            1186, // 245  - en-ws
            1191, // 246  - en-za
            1196, // 247  - en-zm
            1201, // 248  - en-zw
            1206, // 249  - eo
            1208, // 250  - eo-001
            1214, // 251  - es
            1216, // 252  - es-419
            1222, // 253  - es-ar
            1227, // 254  - es-bo
            1232, // 255  - es-br
            1237, // 256  - es-cl
            1242, // 257  - es-co
            1247, // 258  - es-cr
            1252, // 259  - es-cu
            1257, // 260  - es-do
            1262, // 261  - es-ec
            1267, // 262  - es-es
            1272, // 263  - es-es_tradnl
            1284, // 264  - es-gq
            1289, // 265  - es-gt
            1294, // 266  - es-hn
            1299, // 267  - es-mx
            1304, // 268  - es-ni
            1309, // 269  - es-pa
            1314, // 270  - es-pe
            1319, // 271  - es-ph
            1324, // 272  - es-pr
            1329, // 273  - es-py
            1334, // 274  - es-sv
            1339, // 275  - es-us
            1344, // 276  - es-uy
            1349, // 277  - es-ve
            1354, // 278  - et
            1356, // 279  - et-ee
            1361, // 280  - eu
            1363, // 281  - eu-es
            1368, // 282  - ewo
            1371, // 283  - ewo-cm
            1377, // 284  - fa
            1379, // 285  - fa-ir
            1384, // 286  - ff
            1386, // 287  - ff-cm
            1391, // 288  - ff-gn
            1396, // 289  - ff-latn
            1403, // 290  - ff-latn-sn
            1413, // 291  - ff-mr
            1418, // 292  - ff-ng
            1423, // 293  - fi
            1425, // 294  - fi-fi
            1430, // 295  - fil
            1433, // 296  - fil-ph
            1439, // 297  - fo
            1441, // 298  - fo-dk
            1446, // 299  - fo-fo
            1451, // 300  - fr
            1453, // 301  - fr-029
            1459, // 302  - fr-be
            1464, // 303  - fr-bf
            1469, // 304  - fr-bi
            1474, // 305  - fr-bj
            1479, // 306  - fr-bl
            1484, // 307  - fr-ca
            1489, // 308  - fr-cd
            1494, // 309  - fr-cf
            1499, // 310  - fr-cg
            1504, // 311  - fr-ch
            1509, // 312  - fr-ci
            1514, // 313  - fr-cm
            1519, // 314  - fr-dj
            1524, // 315  - fr-dz
            1529, // 316  - fr-fr
            1534, // 317  - fr-ga
            1539, // 318  - fr-gf
            1544, // 319  - fr-gn
            1549, // 320  - fr-gp
            1554, // 321  - fr-gq
            1559, // 322  - fr-ht
            1564, // 323  - fr-km
            1569, // 324  - fr-lu
            1574, // 325  - fr-ma
            1579, // 326  - fr-mc
            1584, // 327  - fr-mf
            1589, // 328  - fr-mg
            1594, // 329  - fr-ml
            1599, // 330  - fr-mq
            1604, // 331  - fr-mr
            1609, // 332  - fr-mu
            1614, // 333  - fr-nc
            1619, // 334  - fr-ne
            1624, // 335  - fr-pf
            1629, // 336  - fr-pm
            1634, // 337  - fr-re
            1639, // 338  - fr-rw
            1644, // 339  - fr-sc
            1649, // 340  - fr-sn
            1654, // 341  - fr-sy
            1659, // 342  - fr-td
            1664, // 343  - fr-tg
            1669, // 344  - fr-tn
            1674, // 345  - fr-vu
            1679, // 346  - fr-wf
            1684, // 347  - fr-yt
            1689, // 348  - fur
            1692, // 349  - fur-it
            1698, // 350  - fy
            1700, // 351  - fy-nl
            1705, // 352  - ga
            1707, // 353  - ga-ie
            1712, // 354  - gd
            1714, // 355  - gd-gb
            1719, // 356  - gl
            1721, // 357  - gl-es
            1726, // 358  - gn
            1728, // 359  - gn-py
            1733, // 360  - gsw
            1736, // 361  - gsw-ch
            1742, // 362  - gsw-fr
            1748, // 363  - gsw-li
            1754, // 364  - gu
            1756, // 365  - gu-in
            1761, // 366  - guz
            1764, // 367  - guz-ke
            1770, // 368  - gv
            1772, // 369  - gv-im
            1777, // 370  - ha
            1779, // 371  - ha-latn
            1786, // 372  - ha-latn-gh
            1796, // 373  - ha-latn-ne
            1806, // 374  - ha-latn-ng
            1816, // 375  - haw
            1819, // 376  - haw-us
            1825, // 377  - he
            1827, // 378  - he-il
            1832, // 379  - hi
            1834, // 380  - hi-in
            1839, // 381  - hr
            1841, // 382  - hr-ba
            1846, // 383  - hr-hr
            1851, // 384  - hsb
            1854, // 385  - hsb-de
            1860, // 386  - hu
            1862, // 387  - hu-hu
            1867, // 388  - hu-hu_technl
            1879, // 389  - hy
            1881, // 390  - hy-am
            1886, // 391  - ia
            1888, // 392  - ia-001
            1894, // 393  - ia-fr
            1899, // 394  - ibb
            1902, // 395  - ibb-ng
            1908, // 396  - id
            1910, // 397  - id-id
            1915, // 398  - ig
            1917, // 399  - ig-ng
            1922, // 400  - ii
            1924, // 401  - ii-cn
            1929, // 402  - is
            1931, // 403  - is-is
            1936, // 404  - it
            1938, // 405  - it-ch
            1943, // 406  - it-it
            1948, // 407  - it-sm
            1953, // 408  - iu
            1955, // 409  - iu-cans
            1962, // 410  - iu-cans-ca
            1972, // 411  - iu-latn
            1979, // 412  - iu-latn-ca
            1989, // 413  - ja
            1991, // 414  - ja-jp
            1996, // 415  - ja-jp_radstr
            2008, // 416  - jgo
            2011, // 417  - jgo-cm
            2017, // 418  - jmc
            2020, // 419  - jmc-tz
            2026, // 420  - jv
            2028, // 421  - jv-java
            2035, // 422  - jv-java-id
            2045, // 423  - jv-latn
            2052, // 424  - jv-latn-id
            2062, // 425  - ka
            2064, // 426  - ka-ge
            2069, // 427  - ka-ge_modern
            2081, // 428  - kab
            2084, // 429  - kab-dz
            2090, // 430  - kam
            2093, // 431  - kam-ke
            2099, // 432  - kde
            2102, // 433  - kde-tz
            2108, // 434  - kea
            2111, // 435  - kea-cv
            2117, // 436  - khq
            2120, // 437  - khq-ml
            2126, // 438  - ki
            2128, // 439  - ki-ke
            2133, // 440  - kk
            2135, // 441  - kk-kz
            2140, // 442  - kkj
            2143, // 443  - kkj-cm
            2149, // 444  - kl
            2151, // 445  - kl-gl
            2156, // 446  - kln
            2159, // 447  - kln-ke
            2165, // 448  - km
            2167, // 449  - km-kh
            2172, // 450  - kn
            2174, // 451  - kn-in
            2179, // 452  - ko
            2181, // 453  - ko-kp
            2186, // 454  - ko-kr
            2191, // 455  - kok
            2194, // 456  - kok-in
            2200, // 457  - kr
            2202, // 458  - kr-ng
            2207, // 459  - ks
            2209, // 460  - ks-arab
            2216, // 461  - ks-arab-in
            2226, // 462  - ks-deva
            2233, // 463  - ks-deva-in
            2243, // 464  - ksb
            2246, // 465  - ksb-tz
            2252, // 466  - ksf
            2255, // 467  - ksf-cm
            2261, // 468  - ksh
            2264, // 469  - ksh-de
            2270, // 470  - ku
            2272, // 471  - ku-arab
            2279, // 472  - ku-arab-iq
            2289, // 473  - ku-arab-ir
            2299, // 474  - kw
            2301, // 475  - kw-gb
            2306, // 476  - ky
            2308, // 477  - ky-kg
            2313, // 478  - la
            2315, // 479  - la-001
            2321, // 480  - lag
            2324, // 481  - lag-tz
            2330, // 482  - lb
            2332, // 483  - lb-lu
            2337, // 484  - lg
            2339, // 485  - lg-ug
            2344, // 486  - lkt
            2347, // 487  - lkt-us
            2353, // 488  - ln
            2355, // 489  - ln-ao
            2360, // 490  - ln-cd
            2365, // 491  - ln-cf
            2370, // 492  - ln-cg
            2375, // 493  - lo
            2377, // 494  - lo-la
            2382, // 495  - lrc
            2385, // 496  - lrc-iq
            2391, // 497  - lrc-ir
            2397, // 498  - lt
            2399, // 499  - lt-lt
            2404, // 500  - lu
            2406, // 501  - lu-cd
            2411, // 502  - luo
            2414, // 503  - luo-ke
            2420, // 504  - luy
            2423, // 505  - luy-ke
            2429, // 506  - lv
            2431, // 507  - lv-lv
            2436, // 508  - mas
            2439, // 509  - mas-ke
            2445, // 510  - mas-tz
            2451, // 511  - mer
            2454, // 512  - mer-ke
            2460, // 513  - mfe
            2463, // 514  - mfe-mu
            2469, // 515  - mg
            2471, // 516  - mg-mg
            2476, // 517  - mgh
            2479, // 518  - mgh-mz
            2485, // 519  - mgo
            2488, // 520  - mgo-cm
            2494, // 521  - mi
            2496, // 522  - mi-nz
            2501, // 523  - mk
            2503, // 524  - mk-mk
            2508, // 525  - ml
            2510, // 526  - ml-in
            2515, // 527  - mn
            2517, // 528  - mn-cyrl
            2524, // 529  - mn-mn
            2529, // 530  - mn-mong
            2536, // 531  - mn-mong-cn
            2546, // 532  - mn-mong-mn
            2556, // 533  - mni
            2559, // 534  - mni-in
            2565, // 535  - moh
            2568, // 536  - moh-ca
            2574, // 537  - mr
            2576, // 538  - mr-in
            2581, // 539  - ms
            2583, // 540  - ms-bn
            2588, // 541  - ms-my
            2593, // 542  - ms-sg
            2598, // 543  - mt
            2600, // 544  - mt-mt
            2605, // 545  - mua
            2608, // 546  - mua-cm
            2614, // 547  - my
            2616, // 548  - my-mm
            2621, // 549  - mzn
            2624, // 550  - mzn-ir
            2630, // 551  - naq
            2633, // 552  - naq-na
            2639, // 553  - nb
            2641, // 554  - nb-no
            2646, // 555  - nb-sj
            2651, // 556  - nd
            2653, // 557  - nd-zw
            2658, // 558  - nds
            2661, // 559  - nds-de
            2667, // 560  - nds-nl
            2673, // 561  - ne
            2675, // 562  - ne-in
            2680, // 563  - ne-np
            2685, // 564  - nl
            2687, // 565  - nl-aw
            2692, // 566  - nl-be
            2697, // 567  - nl-bq
            2702, // 568  - nl-cw
            2707, // 569  - nl-nl
            2712, // 570  - nl-sr
            2717, // 571  - nl-sx
            2722, // 572  - nmg
            2725, // 573  - nmg-cm
            2731, // 574  - nn
            2733, // 575  - nn-no
            2738, // 576  - nnh
            2741, // 577  - nnh-cm
            2747, // 578  - no
            2749, // 579  - nqo
            2752, // 580  - nqo-gn
            2758, // 581  - nr
            2760, // 582  - nr-za
            2765, // 583  - nso
            2768, // 584  - nso-za
            2774, // 585  - nus
            2777, // 586  - nus-ss
            2783, // 587  - nyn
            2786, // 588  - nyn-ug
            2792, // 589  - oc
            2794, // 590  - oc-fr
            2799, // 591  - om
            2801, // 592  - om-et
            2806, // 593  - om-ke
            2811, // 594  - or
            2813, // 595  - or-in
            2818, // 596  - os
            2820, // 597  - os-ge
            2825, // 598  - os-ru
            2830, // 599  - pa
            2832, // 600  - pa-arab
            2839, // 601  - pa-arab-pk
            2849, // 602  - pa-in
            2854, // 603  - pap
            2857, // 604  - pap-029
            2864, // 605  - pl
            2866, // 606  - pl-pl
            2871, // 607  - prg
            2874, // 608  - prg-001
            2881, // 609  - prs
            2884, // 610  - prs-af
            2890, // 611  - ps
            2892, // 612  - ps-af
            2897, // 613  - pt
            2899, // 614  - pt-ao
            2904, // 615  - pt-br
            2909, // 616  - pt-ch
            2914, // 617  - pt-cv
            2919, // 618  - pt-gq
            2924, // 619  - pt-gw
            2929, // 620  - pt-lu
            2934, // 621  - pt-mo
            2939, // 622  - pt-mz
            2944, // 623  - pt-pt
            2949, // 624  - pt-st
            2954, // 625  - pt-tl
            2959, // 626  - qps-latn-x-sh
            2972, // 627  - qps-ploc
            2980, // 628  - qps-ploca
            2989, // 629  - qps-plocm
            2998, // 630  - quc
            3001, // 631  - quc-latn
            3009, // 632  - quc-latn-gt
            3020, // 633  - quz
            3023, // 634  - quz-bo
            3029, // 635  - quz-ec
            3035, // 636  - quz-pe
            3041, // 637  - rm
            3043, // 638  - rm-ch
            3048, // 639  - rn
            3050, // 640  - rn-bi
            3055, // 641  - ro
            3057, // 642  - ro-md
            3062, // 643  - ro-ro
            3067, // 644  - rof
            3070, // 645  - rof-tz
            3076, // 646  - ru
            3078, // 647  - ru-by
            3083, // 648  - ru-kg
            3088, // 649  - ru-kz
            3093, // 650  - ru-md
            3098, // 651  - ru-ru
            3103, // 652  - ru-ua
            3108, // 653  - rw
            3110, // 654  - rw-rw
            3115, // 655  - rwk
            3118, // 656  - rwk-tz
            3124, // 657  - sa
            3126, // 658  - sa-in
            3131, // 659  - sah
            3134, // 660  - sah-ru
            3140, // 661  - saq
            3143, // 662  - saq-ke
            3149, // 663  - sbp
            3152, // 664  - sbp-tz
            3158, // 665  - sd
            3160, // 666  - sd-arab
            3167, // 667  - sd-arab-pk
            3177, // 668  - sd-deva
            3184, // 669  - sd-deva-in
            3194, // 670  - se
            3196, // 671  - se-fi
            3201, // 672  - se-no
            3206, // 673  - se-se
            3211, // 674  - seh
            3214, // 675  - seh-mz
            3220, // 676  - ses
            3223, // 677  - ses-ml
            3229, // 678  - sg
            3231, // 679  - sg-cf
            3236, // 680  - shi
            3239, // 681  - shi-latn
            3247, // 682  - shi-latn-ma
            3258, // 683  - shi-tfng
            3266, // 684  - shi-tfng-ma
            3277, // 685  - si
            3279, // 686  - si-lk
            3284, // 687  - sk
            3286, // 688  - sk-sk
            3291, // 689  - sl
            3293, // 690  - sl-si
            3298, // 691  - sma
            3301, // 692  - sma-no
            3307, // 693  - sma-se
            3313, // 694  - smj
            3316, // 695  - smj-no
            3322, // 696  - smj-se
            3328, // 697  - smn
            3331, // 698  - smn-fi
            3337, // 699  - sms
            3340, // 700  - sms-fi
            3346, // 701  - sn
            3348, // 702  - sn-latn
            3355, // 703  - sn-latn-zw
            3365, // 704  - so
            3367, // 705  - so-dj
            3372, // 706  - so-et
            3377, // 707  - so-ke
            3382, // 708  - so-so
            3387, // 709  - sq
            3389, // 710  - sq-al
            3394, // 711  - sq-mk
            3399, // 712  - sq-xk
            3404, // 713  - sr
            3406, // 714  - sr-cyrl
            3413, // 715  - sr-cyrl-ba
            3423, // 716  - sr-cyrl-cs
            3433, // 717  - sr-cyrl-me
            3443, // 718  - sr-cyrl-rs
            3453, // 719  - sr-cyrl-xk
            3463, // 720  - sr-latn
            3470, // 721  - sr-latn-ba
            3480, // 722  - sr-latn-cs
            3490, // 723  - sr-latn-me
            3500, // 724  - sr-latn-rs
            3510, // 725  - sr-latn-xk
            3520, // 726  - ss
            3522, // 727  - ss-sz
            3527, // 728  - ss-za
            3532, // 729  - ssy
            3535, // 730  - ssy-er
            3541, // 731  - st
            3543, // 732  - st-ls
            3548, // 733  - st-za
            3553, // 734  - sv
            3555, // 735  - sv-ax
            3560, // 736  - sv-fi
            3565, // 737  - sv-se
            3570, // 738  - sw
            3572, // 739  - sw-cd
            3577, // 740  - sw-ke
            3582, // 741  - sw-tz
            3587, // 742  - sw-ug
            3592, // 743  - swc
            3595, // 744  - swc-cd
            3601, // 745  - syr
            3604, // 746  - syr-sy
            3610, // 747  - ta
            3612, // 748  - ta-in
            3617, // 749  - ta-lk
            3622, // 750  - ta-my
            3627, // 751  - ta-sg
            3632, // 752  - te
            3634, // 753  - te-in
            3639, // 754  - teo
            3642, // 755  - teo-ke
            3648, // 756  - teo-ug
            3654, // 757  - tg
            3656, // 758  - tg-cyrl
            3663, // 759  - tg-cyrl-tj
            3673, // 760  - th
            3675, // 761  - th-th
            3680, // 762  - ti
            3682, // 763  - ti-er
            3687, // 764  - ti-et
            3692, // 765  - tig
            3695, // 766  - tig-er
            3701, // 767  - tk
            3703, // 768  - tk-tm
            3708, // 769  - tn
            3710, // 770  - tn-bw
            3715, // 771  - tn-za
            3720, // 772  - to
            3722, // 773  - to-to
            3727, // 774  - tr
            3729, // 775  - tr-cy
            3734, // 776  - tr-tr
            3739, // 777  - ts
            3741, // 778  - ts-za
            3746, // 779  - tt
            3748, // 780  - tt-ru
            3753, // 781  - twq
            3756, // 782  - twq-ne
            3762, // 783  - tzm
            3765, // 784  - tzm-arab
            3773, // 785  - tzm-arab-ma
            3784, // 786  - tzm-latn
            3792, // 787  - tzm-latn-dz
            3803, // 788  - tzm-latn-ma
            3814, // 789  - tzm-tfng
            3822, // 790  - tzm-tfng-ma
            3833, // 791  - ug
            3835, // 792  - ug-cn
            3840, // 793  - uk
            3842, // 794  - uk-ua
            3847, // 795  - ur
            3849, // 796  - ur-in
            3854, // 797  - ur-pk
            3859, // 798  - uz
            3861, // 799  - uz-arab
            3868, // 800  - uz-arab-af
            3878, // 801  - uz-cyrl
            3885, // 802  - uz-cyrl-uz
            3895, // 803  - uz-latn
            3902, // 804  - uz-latn-uz
            3912, // 805  - vai
            3915, // 806  - vai-latn
            3923, // 807  - vai-latn-lr
            3934, // 808  - vai-vaii
            3942, // 809  - vai-vaii-lr
            3953, // 810  - ve
            3955, // 811  - ve-za
            3960, // 812  - vi
            3962, // 813  - vi-vn
            3967, // 814  - vo
            3969, // 815  - vo-001
            3975, // 816  - vun
            3978, // 817  - vun-tz
            3984, // 818  - wae
            3987, // 819  - wae-ch
            3993, // 820  - wal
            3996, // 821  - wal-et
            4002, // 822  - wo
            4004, // 823  - wo-sn
            4009, // 824  - x-iv_mathan
            4020, // 825  - xh
            4022, // 826  - xh-za
            4027, // 827  - xog
            4030, // 828  - xog-ug
            4036, // 829  - yav
            4039, // 830  - yav-cm
            4045, // 831  - yi
            4047, // 832  - yi-001
            4053, // 833  - yo
            4055, // 834  - yo-bj
            4060, // 835  - yo-ng
            4065, // 836  - yue
            4068, // 837  - yue-hk
            4074, // 838  - zgh
            4077, // 839  - zgh-tfng
            4085, // 840  - zgh-tfng-ma
            4096, // 841  - zh
            4098, // 842  - zh-chs
            4104, // 843  - zh-cht
            4110, // 844  - zh-cn
            4115, // 845  - zh-cn_phoneb
            4127, // 846  - zh-cn_stroke
            4139, // 847  - zh-hans
            4146, // 848  - zh-hans-hk
            4156, // 849  - zh-hans-mo
            4166, // 850  - zh-hant
            4173, // 851  - zh-hk
            4178, // 852  - zh-hk_radstr
            4190, // 853  - zh-mo
            4195, // 854  - zh-mo_radstr
            4207, // 855  - zh-mo_stroke
            4219, // 856  - zh-sg
            4224, // 857  - zh-sg_phoneb
            4236, // 858  - zh-sg_stroke
            4248, // 859  - zh-tw
            4253, // 860  - zh-tw_pronun
            4265, // 861  - zh-tw_radstr
            4277, // 862  - zu
            4279,  // 863  - zu-za
            4284
        };

        private const int NUMERIC_LOCALE_DATA_COUNT_PER_ROW = 9;
        // s_nameIndexToNumericData is mapping from index in s_localeNamesIndices to locale data.
        // each row in the table will have the following data:
        //      Lcid, Ansi codepage, Oem codepage, MAC codepage, EBCDIC codepage, Geo Id, Digit Substitution, specific locale index, Console locale index
        private static readonly int[] s_nameIndexToNumericData = new int[]
        {
         // Lcid,  Ansi CP, Oem CP, MAC CP, EBCDIC CP, Geo Id, digit substitution, Specific culture index, keyboard Id, Console locale index  // index - locale name
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 3   , 240 , // 0    - aa
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3e  , 1 , 1   , 240 , // 1    - aa-dj
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 2   , 240 , // 2    - aa-er
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 3   , 240 , // 3    - aa-et
            0x36   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 6   , 6   , // 4    - af
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xfe  , 1 , 5   , 240 , // 5    - af-na
            0x436  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 6   , 6   , // 6    - af-za
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 8   , 240 , // 7    - agq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 8   , 240 , // 8    - agq-cm
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x59  , 1 , 10  , 240 , // 9    - ak
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x59  , 1 , 10  , 240 , // 10   - ak-gh
            0x5e   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 12  , 143 , // 11   - am
            0x45e  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 12  , 143 , // 12   - am-et
            0x1    , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xcd  , 0 , 33  , 143 , // 13   - ar
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x989e, 0 , 14  , 240 , // 14   - ar-001
            0x3801 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xe0  , 0 , 15  , 143 , // 15   - ar-ae
            0x3c01 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x11  , 0 , 16  , 143 , // 16   - ar-bh
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x3e  , 0 , 17  , 240 , // 17   - ar-dj
            0x1401 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x4   , 1 , 18  , 300 , // 18   - ar-dz
            0xc01  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x43  , 0 , 19  , 143 , // 19   - ar-eg
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x47  , 0 , 20  , 240 , // 20   - ar-er
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x75  , 0 , 21  , 240 , // 21   - ar-il
            0x801  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x79  , 0 , 22  , 143 , // 22   - ar-iq
            0x2c01 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x7e  , 0 , 23  , 143 , // 23   - ar-jo
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x32  , 0 , 24  , 240 , // 24   - ar-km
            0x3401 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x88  , 0 , 25  , 143 , // 25   - ar-kw
            0x3001 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x8b  , 0 , 26  , 143 , // 26   - ar-lb
            0x1001 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x94  , 1 , 27  , 143 , // 27   - ar-ly
            0x1801 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x9f  , 1 , 28  , 300 , // 28   - ar-ma
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xa2  , 0 , 29  , 240 , // 29   - ar-mr
            0x2001 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xa4  , 0 , 30  , 143 , // 30   - ar-om
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xb8  , 0 , 31  , 240 , // 31   - ar-ps
            0x4001 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xc5  , 0 , 32  , 143 , // 32   - ar-qa
            0x401  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xcd  , 0 , 33  , 143 , // 33   - ar-sa
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xdb  , 0 , 34  , 240 , // 34   - ar-sd
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xd8  , 0 , 35  , 240 , // 35   - ar-so
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x114 , 0 , 36  , 240 , // 36   - ar-ss
            0x2801 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xde  , 0 , 37  , 143 , // 37   - ar-sy
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x29  , 0 , 38  , 240 , // 38   - ar-td
            0x1c01 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xea  , 1 , 39  , 300 , // 39   - ar-tn
            0x2401 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x105 , 0 , 40  , 143 , // 40   - ar-ye
            0x7a   , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x2e  , 1 , 42  , 42  , // 41   - arn
            0x47a  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x2e  , 1 , 42  , 42  , // 42   - arn-cl
            0x4d   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 44  , 143 , // 43   - as
            0x44d  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 44  , 143 , // 44   - as-in
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 46  , 240 , // 45   - asa
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 46  , 240 , // 46   - asa-tz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd9  , 1 , 48  , 240 , // 47   - ast
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd9  , 1 , 48  , 240 , // 48   - ast-es
            0x2c   , 0x4e6 , 0x359 , 0x2761, 0x51a9, 0x5   , 1 , 53  , 53  , // 49   - az
            0x742c , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x5   , 1 , 51  , 51  , // 50   - az-cyrl
            0x82c  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x5   , 1 , 51  , 51  , // 51   - az-cyrl-az
            0x782c , 0x4e6 , 0x359 , 0x2761, 0x51a9, 0x5   , 1 , 53  , 53  , // 52   - az-latn
            0x42c  , 0x4e6 , 0x359 , 0x2761, 0x51a9, 0x5   , 1 , 53  , 53  , // 53   - az-latn-az
            0x6d   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 55  , 55  , // 54   - ba
            0x46d  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 55  , 55  , // 55   - ba-ru
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 57  , 240 , // 56   - bas
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 57  , 240 , // 57   - bas-cm
            0x23   , 0x4e3 , 0x362 , 0x2717, 0x1f4 , 0x1d  , 1 , 59  , 59  , // 58   - be
            0x423  , 0x4e3 , 0x362 , 0x2717, 0x1f4 , 0x1d  , 1 , 59  , 59  , // 59   - be-by
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x107 , 1 , 61  , 240 , // 60   - bem
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x107 , 1 , 61  , 240 , // 61   - bem-zm
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 63  , 240 , // 62   - bez
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 63  , 240 , // 63   - bez-tz
            0x2    , 0x4e3 , 0x362 , 0x2717, 0x5221, 0x23  , 1 , 65  , 65  , // 64   - bg
            0x402  , 0x4e3 , 0x362 , 0x2717, 0x5221, 0x23  , 1 , 65  , 65  , // 65   - bg-bg
            0x66   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 67  , 240 , // 66   - bin
            0x466  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 67  , 240 , // 67   - bin-ng
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 70  , 240 , // 68   - bm
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 70  , 240 , // 69   - bm-latn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 70  , 240 , // 70   - bm-latn-ml
            0x45   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x17  , 1 , 72  , 143 , // 71   - bn
            0x845  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x17  , 1 , 72  , 143 , // 72   - bn-bd
            0x445  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 73  , 143 , // 73   - bn-in
            0x51   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2d  , 1 , 75  , 143 , // 74   - bo
            0x451  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2d  , 1 , 75  , 143 , // 75   - bo-cn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 76  , 240 , // 76   - bo-in
            0x7e   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 78  , 78  , // 77   - br
            0x47e  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 78  , 78  , // 78   - br-fr
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 80  , 240 , // 79   - brx
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 80  , 240 , // 80   - brx-in
            0x781a , 0x4e2 , 0x354 , 0x2762, 0x366 , 0x19  , 1 , 85  , 85  , // 81   - bs
            0x641a , 0x4e3 , 0x357 , 0x2762, 0x366 , 0x19  , 1 , 83  , 83  , // 82   - bs-cyrl
            0x201a , 0x4e3 , 0x357 , 0x2762, 0x366 , 0x19  , 1 , 83  , 83  , // 83   - bs-cyrl-ba
            0x681a , 0x4e2 , 0x354 , 0x2762, 0x366 , 0x19  , 1 , 85  , 85  , // 84   - bs-latn
            0x141a , 0x4e2 , 0x354 , 0x2762, 0x366 , 0x19  , 1 , 85  , 85  , // 85   - bs-latn-ba
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 87  , 240 , // 86   - byn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 87  , 240 , // 87   - byn-er
            0x3    , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd9  , 1 , 90  , 90  , // 88   - ca
            0x1000 , 0x4e4 , 0x352 , 0x2   , 0x1f4 , 0x8   , 1 , 89  , 240 , // 89   - ca-ad
            0x403  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd9  , 1 , 90  , 90  , // 90   - ca-es
            0x803  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd9  , 1 , 91  , 90  , // 91   - ca-es-valencia
            0x1000 , 0x4e4 , 0x352 , 0x2   , 0x1f4 , 0x54  , 1 , 92  , 240 , // 92   - ca-fr
            0x1000 , 0x4e4 , 0x352 , 0x2   , 0x1f4 , 0x76  , 1 , 93  , 240 , // 93   - ca-it
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xcb  , 1 , 95  , 240 , // 94   - ce
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xcb  , 1 , 95  , 240 , // 95   - ce-ru
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 97  , 240 , // 96   - cgg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 97  , 240 , // 97   - cgg-ug
            0x5c   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf4  , 1 , 100 , 240 , // 98   - chr
            0x7c5c , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf4  , 1 , 100 , 240 , // 99   - chr-cher
            0x45c  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf4  , 1 , 100 , 240 , // 100  - chr-cher-us
            0x83   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 102 , 102 , // 101  - co
            0x483  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 102 , 102 , // 102  - co-fr
            0x5    , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x4b  , 1 , 104 , 104 , // 103  - cs
            0x405  , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x4b  , 1 , 104 , 104 , // 104  - cs-cz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xcb  , 1 , 106 , 240 , // 105  - cu
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xcb  , 1 , 106 , 240 , // 106  - cu-ru
            0x52   , 0x4e4 , 0x352 , 0x2710, 0x4f3d, 0xf2  , 1 , 108 , 108 , // 107  - cy
            0x452  , 0x4e4 , 0x352 , 0x2710, 0x4f3d, 0xf2  , 1 , 108 , 108 , // 108  - cy-gb
            0x6    , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0x3d  , 1 , 110 , 110 , // 109  - da
            0x406  , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0x3d  , 1 , 110 , 110 , // 110  - da-dk
            0x1000 , 0x4e4 , 0x352 , 0x2   , 0x1f4 , 0x5d  , 1 , 111 , 240 , // 111  - da-gl
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 113 , 240 , // 112  - dav
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 113 , 240 , // 113  - dav-ke
            0x7    , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0x5e  , 1 , 118 , 118 , // 114  - de
            0xc07  , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0xe   , 1 , 115 , 115 , // 115  - de-at
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0x15  , 1 , 116 , 240 , // 116  - de-be
            0x807  , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0xdf  , 1 , 117 , 117 , // 117  - de-ch
            0x407  , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0x5e  , 1 , 118 , 118 , // 118  - de-de
            0x10407, 0x4e4 , 0x352 , 0x2710, 0x4f31, 0x5e  , 1 , 118 , 118 , // 119  - de-de_phoneb
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x76  , 1 , 120 , 240 , // 120  - de-it
            0x1407 , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0x91  , 1 , 121 , 121 , // 121  - de-li
            0x1007 , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0x93  , 1 , 122 , 122 , // 122  - de-lu
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xad  , 1 , 124 , 240 , // 123  - dje
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xad  , 1 , 124 , 240 , // 124  - dje-ne
            0x7c2e , 0x4e4 , 0x352 , 0x2710, 0x366 , 0x5e  , 1 , 126 , 126 , // 125  - dsb
            0x82e  , 0x4e4 , 0x352 , 0x2710, 0x366 , 0x5e  , 1 , 126 , 126 , // 126  - dsb-de
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 128 , 240 , // 127  - dua
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 128 , 240 , // 128  - dua-cm
            0x65   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa5  , 1 , 130 , 143 , // 129  - dv
            0x465  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa5  , 1 , 130 , 143 , // 130  - dv-mv
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd2  , 1 , 132 , 240 , // 131  - dyo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd2  , 1 , 132 , 240 , // 132  - dyo-sn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x22  , 2 , 134 , 240 , // 133  - dz
            0xc51  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x22  , 2 , 134 , 240 , // 134  - dz-bt
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 136 , 240 , // 135  - ebu
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 136 , 240 , // 136  - ebu-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x59  , 1 , 138 , 240 , // 137  - ee
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x59  , 1 , 138 , 240 , // 138  - ee-gh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xe8  , 1 , 139 , 240 , // 139  - ee-tg
            0x8    , 0x4e5 , 0x2e1 , 0x2716, 0x4f31, 0x62  , 1 , 142 , 142 , // 140  - el
            0x1000 , 0x4e5 , 0x2e1 , 0x2716, 0x4f31, 0x3b  , 1 , 141 , 240 , // 141  - el-cy
            0x408  , 0x4e5 , 0x2e1 , 0x2716, 0x4f31, 0x62  , 1 , 142 , 142 , // 142  - el-gr
            0x9    , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xf4  , 1 , 240 , 240 , // 143  - en
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x989e, 1 , 144 , 240 , // 144  - en-001
            0x2409 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x993248, 1 , 145 , 145 , // 145  - en-029
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x292d, 1 , 146 , 240 , // 146  - en-150
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x2   , 1 , 147 , 240 , // 147  - en-ag
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x12c , 1 , 148 , 240 , // 148  - en-ai
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xa   , 1 , 149 , 240 , // 149  - en-as
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xe   , 1 , 150 , 240 , // 150  - en-at
            0xc09  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xc   , 1 , 151 , 151 , // 151  - en-au
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x12  , 1 , 152 , 240 , // 152  - en-bb
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x15  , 1 , 153 , 240 , // 153  - en-be
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x26  , 1 , 154 , 240 , // 154  - en-bi
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x14  , 1 , 155 , 240 , // 155  - en-bm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x16  , 1 , 156 , 240 , // 156  - en-bs
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x13  , 1 , 157 , 240 , // 157  - en-bw
            0x2809 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x18  , 1 , 158 , 158 , // 158  - en-bz
            0x1009 , 0x4e4 , 0x352 , 0x2710, 0x25  , 0x27  , 1 , 159 , 159 , // 159  - en-ca
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x137 , 1 , 160 , 240 , // 160  - en-cc
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xdf  , 1 , 161 , 240 , // 161  - en-ch
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x138 , 1 , 162 , 240 , // 162  - en-ck
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x31  , 1 , 163 , 240 , // 163  - en-cm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x135 , 1 , 164 , 240 , // 164  - en-cx
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3b  , 1 , 165 , 240 , // 165  - en-cy
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x5e  , 1 , 166 , 240 , // 166  - en-de
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3d  , 1 , 167 , 240 , // 167  - en-dk
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x3f  , 1 , 168 , 240 , // 168  - en-dm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x47  , 1 , 169 , 240 , // 169  - en-er
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x4d  , 1 , 170 , 240 , // 170  - en-fi
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x4e  , 1 , 171 , 240 , // 171  - en-fj
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x13b , 1 , 172 , 240 , // 172  - en-fk
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x50  , 1 , 173 , 240 , // 173  - en-fm
            0x809  , 0x4e4 , 0x352 , 0x2710, 0x4f3d, 0xf2  , 1 , 174 , 174 , // 174  - en-gb
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x5b  , 1 , 175 , 240 , // 175  - en-gd
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x144 , 1 , 176 , 240 , // 176  - en-gg
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x59  , 1 , 177 , 240 , // 177  - en-gh
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x5a  , 1 , 178 , 240 , // 178  - en-gi
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x56  , 1 , 179 , 240 , // 179  - en-gm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x142 , 1 , 180 , 240 , // 180  - en-gu
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x65  , 1 , 181 , 240 , // 181  - en-gy
            0x3c09 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x68  , 1 , 182 , 240 , // 182  - en-hk
            0x3809 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 183 , 240 , // 183  - en-id
            0x1809 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x44  , 1 , 184 , 184 , // 184  - en-ie
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x75  , 1 , 185 , 240 , // 185  - en-il
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x3b16, 1 , 186 , 240 , // 186  - en-im
            0x4009 , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0x71  , 1 , 187 , 187 , // 187  - en-in
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x72  , 1 , 188 , 240 , // 188  - en-io
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x148 , 1 , 189 , 240 , // 189  - en-je
            0x2009 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x7c  , 1 , 190 , 190 , // 190  - en-jm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x81  , 1 , 191 , 240 , // 191  - en-ke
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x85  , 1 , 192 , 240 , // 192  - en-ki
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xcf  , 1 , 193 , 240 , // 193  - en-kn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x133 , 1 , 194 , 240 , // 194  - en-ky
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xda  , 1 , 195 , 240 , // 195  - en-lc
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x8e  , 1 , 196 , 240 , // 196  - en-lr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x92  , 1 , 197 , 240 , // 197  - en-ls
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x95  , 1 , 198 , 240 , // 198  - en-mg
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xc7  , 1 , 199 , 240 , // 199  - en-mh
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x97  , 1 , 200 , 240 , // 200  - en-mo
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x151 , 1 , 201 , 240 , // 201  - en-mp
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x14c , 1 , 202 , 240 , // 202  - en-ms
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xa3  , 1 , 203 , 240 , // 203  - en-mt
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xa0  , 1 , 204 , 240 , // 204  - en-mu
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x9c  , 1 , 205 , 240 , // 205  - en-mw
            0x4409 , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xa7  , 1 , 206 , 206 , // 206  - en-my
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xfe  , 1 , 207 , 240 , // 207  - en-na
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x150 , 1 , 208 , 240 , // 208  - en-nf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 209 , 240 , // 209  - en-ng
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xb0  , 1 , 210 , 240 , // 210  - en-nl
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb4  , 1 , 211 , 240 , // 211  - en-nr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x14f , 1 , 212 , 240 , // 212  - en-nu
            0x1409 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb7  , 1 , 213 , 213 , // 213  - en-nz
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xc2  , 1 , 214 , 240 , // 214  - en-pg
            0x3409 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xc9  , 1 , 215 , 215 , // 215  - en-ph
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xbe  , 1 , 216 , 240 , // 216  - en-pk
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x153 , 1 , 217 , 240 , // 217  - en-pn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xca  , 1 , 218 , 240 , // 218  - en-pr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xc3  , 1 , 219 , 240 , // 219  - en-pw
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xcc  , 1 , 220 , 240 , // 220  - en-rw
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x1e  , 1 , 221 , 240 , // 221  - en-sb
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd0  , 1 , 222 , 240 , // 222  - en-sc
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xdb  , 1 , 223 , 240 , // 223  - en-sd
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xdd  , 1 , 224 , 240 , // 224  - en-se
            0x4809 , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xd7  , 1 , 225 , 225 , // 225  - en-sg
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x157 , 1 , 226 , 240 , // 226  - en-sh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd4  , 1 , 227 , 240 , // 227  - en-si
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd5  , 1 , 228 , 240 , // 228  - en-sl
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x114 , 1 , 229 , 240 , // 229  - en-ss
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x78f7, 1 , 230 , 240 , // 230  - en-sx
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x104 , 1 , 231 , 240 , // 231  - en-sz
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x15d , 1 , 232 , 240 , // 232  - en-tc
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x15b , 1 , 233 , 240 , // 233  - en-tk
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xe7  , 1 , 234 , 240 , // 234  - en-to
            0x2c09 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xe1  , 1 , 235 , 235 , // 235  - en-tt
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xec  , 1 , 236 , 240 , // 236  - en-tv
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xef  , 1 , 237 , 240 , // 237  - en-tz
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xf0  , 1 , 238 , 240 , // 238  - en-ug
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x9a55d40, 1 , 239 , 240 , // 239  - en-um
            0x409  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xf4  , 1 , 240 , 240 , // 240  - en-us
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xf8  , 1 , 241 , 240 , // 241  - en-vc
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x15f , 1 , 242 , 240 , // 242  - en-vg
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xfc  , 1 , 243 , 240 , // 243  - en-vi
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xae  , 1 , 244 , 240 , // 244  - en-vu
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x103 , 1 , 245 , 240 , // 245  - en-ws
            0x1c09 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xd1  , 1 , 246 , 246 , // 246  - en-za
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x107 , 1 , 247 , 240 , // 247  - en-zm
            0x3009 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0x108 , 1 , 248 , 248 , // 248  - en-zw
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 250 , 240 , // 249  - eo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 250 , 240 , // 250  - eo-001
            0xa    , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xd9  , 1 , 262 , 262 , // 251  - es
            0x580a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x9a55d41, 1 , 252 , 240 , // 252  - es-419
            0x2c0a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xb   , 1 , 253 , 253 , // 253  - es-ar
            0x400a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x1a  , 1 , 254 , 254 , // 254  - es-bo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x20  , 1 , 255 , 240 , // 255  - es-br
            0x340a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x2e  , 1 , 256 , 256 , // 256  - es-cl
            0x240a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x33  , 1 , 257 , 257 , // 257  - es-co
            0x140a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x36  , 1 , 258 , 258 , // 258  - es-cr
            0x5c0a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x38  , 1 , 259 , 240 , // 259  - es-cu
            0x1c0a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x41  , 1 , 260 , 260 , // 260  - es-do
            0x300a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x42  , 1 , 261 , 261 , // 261  - es-ec
            0xc0a  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xd9  , 1 , 262 , 262 , // 262  - es-es
            0x40a  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xd9  , 1 , 263 , 263 , // 263  - es-es_tradnl
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x45  , 1 , 264 , 240 , // 264  - es-gq
            0x100a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x63  , 1 , 265 , 265 , // 265  - es-gt
            0x480a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x6a  , 1 , 266 , 266 , // 266  - es-hn
            0x80a  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xa6  , 1 , 267 , 267 , // 267  - es-mx
            0x4c0a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xb6  , 1 , 268 , 268 , // 268  - es-ni
            0x180a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xc0  , 1 , 269 , 269 , // 269  - es-pa
            0x280a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xbb  , 1 , 270 , 270 , // 270  - es-pe
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xc9  , 1 , 271 , 240 , // 271  - es-ph
            0x500a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xca  , 1 , 272 , 272 , // 272  - es-pr
            0x3c0a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xb9  , 1 , 273 , 273 , // 273  - es-py
            0x440a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x48  , 1 , 274 , 274 , // 274  - es-sv
            0x540a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xf4  , 1 , 275 , 275 , // 275  - es-us
            0x380a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xf6  , 1 , 276 , 276 , // 276  - es-uy
            0x200a , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xf9  , 1 , 277 , 277 , // 277  - es-ve
            0x25   , 0x4e9 , 0x307 , 0x272d, 0x1f4 , 0x46  , 1 , 279 , 279 , // 278  - et
            0x425  , 0x4e9 , 0x307 , 0x272d, 0x1f4 , 0x46  , 1 , 279 , 279 , // 279  - et-ee
            0x2d   , 0x4e4 , 0x352 , 0x2   , 0x1f4 , 0xd9  , 1 , 281 , 240 , // 280  - eu
            0x42d  , 0x4e4 , 0x352 , 0x2   , 0x1f4 , 0xd9  , 1 , 281 , 240 , // 281  - eu-es
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 283 , 240 , // 282  - ewo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 283 , 240 , // 283  - ewo-cm
            0x29   , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x74  , 0 , 285 , 143 , // 284  - fa
            0x429  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x74  , 0 , 285 , 143 , // 285  - fa-ir
            0x67   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd2  , 1 , 290 , 290 , // 286  - ff
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x31  , 1 , 287 , 240 , // 287  - ff-cm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x64  , 1 , 288 , 240 , // 288  - ff-gn
            0x7c67 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd2  , 1 , 290 , 290 , // 289  - ff-latn
            0x867  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd2  , 1 , 290 , 290 , // 290  - ff-latn-sn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xa2  , 1 , 291 , 240 , // 291  - ff-mr
            0x467  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xaf  , 1 , 292 , 240 , // 292  - ff-ng
            0xb    , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 294 , 294 , // 293  - fi
            0x40b  , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 294 , 294 , // 294  - fi-fi
            0x64   , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xc9  , 1 , 296 , 296 , // 295  - fil
            0x464  , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xc9  , 1 , 296 , 296 , // 296  - fil-ph
            0x38   , 0x4e4 , 0x352 , 0x275f, 0x4f35, 0x51  , 1 , 299 , 299 , // 297  - fo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3d  , 1 , 298 , 240 , // 298  - fo-dk
            0x438  , 0x4e4 , 0x352 , 0x275f, 0x4f35, 0x51  , 1 , 299 , 299 , // 299  - fo-fo
            0xc    , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 316 , 316 , // 300  - fr
            0x1c0c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x993248, 1 , 301 , 316 , // 301  - fr-029
            0x80c  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x15  , 1 , 302 , 302 , // 302  - fr-be
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xf5  , 1 , 303 , 240 , // 303  - fr-bf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x26  , 1 , 304 , 240 , // 304  - fr-bi
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x1c  , 1 , 305 , 240 , // 305  - fr-bj
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x9a55c4f, 1 , 306 , 240 , // 306  - fr-bl
            0xc0c  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x27  , 1 , 307 , 307 , // 307  - fr-ca
            0x240c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x2c  , 1 , 308 , 240 , // 308  - fr-cd
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x37  , 1 , 309 , 240 , // 309  - fr-cf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x2b  , 1 , 310 , 240 , // 310  - fr-cg
            0x100c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xdf  , 1 , 311 , 311 , // 311  - fr-ch
            0x300c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x77  , 1 , 312 , 240 , // 312  - fr-ci
            0x2c0c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x31  , 1 , 313 , 240 , // 313  - fr-cm
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x3e  , 1 , 314 , 240 , // 314  - fr-dj
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x4   , 1 , 315 , 240 , // 315  - fr-dz
            0x40c  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 316 , 316 , // 316  - fr-fr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x57  , 1 , 317 , 240 , // 317  - fr-ga
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x13d , 1 , 318 , 240 , // 318  - fr-gf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x64  , 1 , 319 , 240 , // 319  - fr-gn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x141 , 1 , 320 , 240 , // 320  - fr-gp
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x45  , 1 , 321 , 240 , // 321  - fr-gq
            0x3c0c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x67  , 1 , 322 , 240 , // 322  - fr-ht
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x32  , 1 , 323 , 240 , // 323  - fr-km
            0x140c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x93  , 1 , 324 , 324 , // 324  - fr-lu
            0x380c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x9f  , 1 , 325 , 240 , // 325  - fr-ma
            0x180c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x9e  , 1 , 326 , 326 , // 326  - fr-mc
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x7bda, 1 , 327 , 240 , // 327  - fr-mf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x95  , 1 , 328 , 240 , // 328  - fr-mg
            0x340c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x9d  , 1 , 329 , 240 , // 329  - fr-ml
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x14a , 1 , 330 , 240 , // 330  - fr-mq
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xa2  , 1 , 331 , 240 , // 331  - fr-mr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xa0  , 1 , 332 , 240 , // 332  - fr-mu
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x14e , 1 , 333 , 240 , // 333  - fr-nc
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xad  , 1 , 334 , 240 , // 334  - fr-ne
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x13e , 1 , 335 , 240 , // 335  - fr-pf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xce  , 1 , 336 , 240 , // 336  - fr-pm
            0x200c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xc6  , 1 , 337 , 240 , // 337  - fr-re
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xcc  , 1 , 338 , 240 , // 338  - fr-rw
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd0  , 1 , 339 , 240 , // 339  - fr-sc
            0x280c , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd2  , 1 , 340 , 240 , // 340  - fr-sn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xde  , 1 , 341 , 240 , // 341  - fr-sy
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x29  , 1 , 342 , 240 , // 342  - fr-td
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xe8  , 1 , 343 , 240 , // 343  - fr-tg
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xea  , 1 , 344 , 240 , // 344  - fr-tn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xae  , 1 , 345 , 240 , // 345  - fr-vu
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x160 , 1 , 346 , 240 , // 346  - fr-wf
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x14b , 1 , 347 , 240 , // 347  - fr-yt
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x76  , 1 , 349 , 240 , // 348  - fur
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x76  , 1 , 349 , 240 , // 349  - fur-it
            0x62   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb0  , 1 , 351 , 351 , // 350  - fy
            0x462  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb0  , 1 , 351 , 351 , // 351  - fy-nl
            0x3c   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x44  , 1 , 353 , 353 , // 352  - ga
            0x83c  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x44  , 1 , 353 , 353 , // 353  - ga-ie
            0x91   , 0x4e4 , 0x352 , 0x2710, 0x4f3d, 0xf2  , 1 , 355 , 355 , // 354  - gd
            0x491  , 0x4e4 , 0x352 , 0x2710, 0x4f3d, 0xf2  , 1 , 355 , 355 , // 355  - gd-gb
            0x56   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd9  , 1 , 357 , 357 , // 356  - gl
            0x456  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd9  , 1 , 357 , 357 , // 357  - gl-es
            0x74   , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xb9  , 1 , 359 , 359 , // 358  - gn
            0x474  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xb9  , 1 , 359 , 359 , // 359  - gn-py
            0x84   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xdf  , 1 , 361 , 240 , // 360  - gsw
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xdf  , 1 , 361 , 240 , // 361  - gsw-ch
            0x484  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 362 , 362 , // 362  - gsw-fr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x91  , 1 , 363 , 240 , // 363  - gsw-li
            0x47   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 365 , 143 , // 364  - gu
            0x447  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 365 , 143 , // 365  - gu-in
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 367 , 240 , // 366  - guz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 367 , 240 , // 367  - guz-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3b16, 1 , 369 , 240 , // 368  - gv
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3b16, 1 , 369 , 240 , // 369  - gv-im
            0x68   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 374 , 374 , // 370  - ha
            0x7c68 , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 374 , 374 , // 371  - ha-latn
            0x1000 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0x59  , 1 , 372 , 240 , // 372  - ha-latn-gh
            0x1000 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xad  , 1 , 373 , 240 , // 373  - ha-latn-ne
            0x468  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 374 , 374 , // 374  - ha-latn-ng
            0x75   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xf4  , 1 , 376 , 376 , // 375  - haw
            0x475  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xf4  , 1 , 376 , 376 , // 376  - haw-us
            0xd    , 0x4e7 , 0x35e , 0x2715, 0x1f4 , 0x75  , 1 , 378 , 143 , // 377  - he
            0x40d  , 0x4e7 , 0x35e , 0x2715, 0x1f4 , 0x75  , 1 , 378 , 143 , // 378  - he-il
            0x39   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 380 , 143 , // 379  - hi
            0x439  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 380 , 143 , // 380  - hi-in
            0x1a   , 0x4e2 , 0x354 , 0x2762, 0x1f4 , 0x6c  , 1 , 383 , 383 , // 381  - hr
            0x101a , 0x4e2 , 0x354 , 0x2762, 0x366 , 0x19  , 1 , 382 , 382 , // 382  - hr-ba
            0x41a  , 0x4e2 , 0x354 , 0x2762, 0x1f4 , 0x6c  , 1 , 383 , 383 , // 383  - hr-hr
            0x2e   , 0x4e4 , 0x352 , 0x2710, 0x366 , 0x5e  , 1 , 385 , 385 , // 384  - hsb
            0x42e  , 0x4e4 , 0x352 , 0x2710, 0x366 , 0x5e  , 1 , 385 , 385 , // 385  - hsb-de
            0xe    , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x6d  , 1 , 387 , 387 , // 386  - hu
            0x40e  , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x6d  , 1 , 387 , 387 , // 387  - hu-hu
            0x1040e, 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x6d  , 1 , 387 , 387 , // 388  - hu-hu_technl
            0x2b   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x7   , 1 , 390 , 390 , // 389  - hy
            0x42b  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x7   , 1 , 390 , 390 , // 390  - hy-am
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x54  , 1 , 393 , 240 , // 391  - ia
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 392 , 240 , // 392  - ia-001
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x54  , 1 , 393 , 240 , // 393  - ia-fr
            0x69   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 395 , 240 , // 394  - ibb
            0x469  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 395 , 240 , // 395  - ibb-ng
            0x21   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 397 , 397 , // 396  - id
            0x421  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 397 , 397 , // 397  - id-id
            0x70   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 399 , 399 , // 398  - ig
            0x470  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 399 , 399 , // 399  - ig-ng
            0x78   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2d  , 1 , 401 , 143 , // 400  - ii
            0x478  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2d  , 1 , 401 , 143 , // 401  - ii-cn
            0xf    , 0x4e4 , 0x352 , 0x275f, 0x5187, 0x6e  , 1 , 403 , 403 , // 402  - is
            0x40f  , 0x4e4 , 0x352 , 0x275f, 0x5187, 0x6e  , 1 , 403 , 403 , // 403  - is-is
            0x10   , 0x4e4 , 0x352 , 0x2710, 0x4f38, 0x76  , 1 , 406 , 406 , // 404  - it
            0x810  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xdf  , 1 , 405 , 405 , // 405  - it-ch
            0x410  , 0x4e4 , 0x352 , 0x2710, 0x4f38, 0x76  , 1 , 406 , 406 , // 406  - it-it
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f38, 0xd6  , 1 , 407 , 240 , // 407  - it-sm
            0x5d   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0x27  , 1 , 412 , 412 , // 408  - iu
            0x785d , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x27  , 1 , 410 , 143 , // 409  - iu-cans
            0x45d  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x27  , 1 , 410 , 143 , // 410  - iu-cans-ca
            0x7c5d , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0x27  , 1 , 412 , 412 , // 411  - iu-latn
            0x85d  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0x27  , 1 , 412 , 412 , // 412  - iu-latn-ca
            0x11   , 0x3a4 , 0x3a4 , 0x2711, 0x4f42, 0x7a  , 1 , 414 , 414 , // 413  - ja
            0x411  , 0x3a4 , 0x3a4 , 0x2711, 0x4f42, 0x7a  , 1 , 414 , 414 , // 414  - ja-jp
            0x40411, 0x3a4 , 0x3a4 , 0x2711, 0x4f42, 0x7a  , 1 , 414 , 414 , // 415  - ja-jp_radstr
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 417 , 240 , // 416  - jgo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 417 , 240 , // 417  - jgo-cm
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 419 , 240 , // 418  - jmc
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 419 , 240 , // 419  - jmc-tz
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 424 , 424 , // 420  - jv
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 422 , 424 , // 421  - jv-java
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 422 , 424 , // 422  - jv-java-id
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 424 , 424 , // 423  - jv-latn
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f  , 1 , 424 , 424 , // 424  - jv-latn-id
            0x37   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x58  , 1 , 426 , 426 , // 425  - ka
            0x437  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x58  , 1 , 426 , 426 , // 426  - ka-ge
            0x10437, 0x0   , 0x1   , 0x2   , 0x1f4 , 0x58  , 1 , 426 , 426 , // 427  - ka-ge_modern
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x4   , 1 , 429 , 240 , // 428  - kab
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x4   , 1 , 429 , 240 , // 429  - kab-dz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 431 , 240 , // 430  - kam
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 431 , 240 , // 431  - kam-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 433 , 240 , // 432  - kde
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 433 , 240 , // 433  - kde-tz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x39  , 1 , 435 , 240 , // 434  - kea
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x39  , 1 , 435 , 240 , // 435  - kea-cv
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 437 , 240 , // 436  - khq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 437 , 240 , // 437  - khq-ml
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 439 , 240 , // 438  - ki
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 439 , 240 , // 439  - ki-ke
            0x3f   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x89  , 1 , 441 , 441 , // 440  - kk
            0x43f  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x89  , 1 , 441 , 441 , // 441  - kk-kz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 443 , 240 , // 442  - kkj
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 443 , 240 , // 443  - kkj-cm
            0x6f   , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0x5d  , 1 , 445 , 445 , // 444  - kl
            0x46f  , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0x5d  , 1 , 445 , 445 , // 445  - kl-gl
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 447 , 240 , // 446  - kln
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 447 , 240 , // 447  - kln-ke
            0x53   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x28  , 2 , 449 , 143 , // 448  - km
            0x453  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x28  , 2 , 449 , 143 , // 449  - km-kh
            0x4b   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 451 , 143 , // 450  - kn
            0x44b  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 451 , 143 , // 451  - kn-in
            0x12   , 0x3b5 , 0x3b5 , 0x2713, 0x5161, 0x86  , 1 , 454 , 454 , // 452  - ko
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x83  , 1 , 453 , 240 , // 453  - ko-kp
            0x412  , 0x3b5 , 0x3b5 , 0x2713, 0x5161, 0x86  , 1 , 454 , 454 , // 454  - ko-kr
            0x57   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 456 , 143 , // 455  - kok
            0x457  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 456 , 143 , // 456  - kok-in
            0x71   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 458 , 240 , // 457  - kr
            0x471  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xaf  , 1 , 458 , 240 , // 458  - kr-ng
            0x60   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 2 , 461 , 240 , // 459  - ks
            0x460  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 2 , 461 , 240 , // 460  - ks-arab
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 2 , 461 , 240 , // 461  - ks-arab-in
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 463 , 187 , // 462  - ks-deva
            0x860  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 463 , 187 , // 463  - ks-deva-in
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 465 , 240 , // 464  - ksb
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 465 , 240 , // 465  - ksb-tz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 467 , 240 , // 466  - ksf
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 467 , 240 , // 467  - ksf-cm
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x5e  , 1 , 469 , 240 , // 468  - ksh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x5e  , 1 , 469 , 240 , // 469  - ksh-de
            0x92   , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x79  , 0 , 472 , 143 , // 470  - ku
            0x7c92 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x79  , 0 , 472 , 143 , // 471  - ku-arab
            0x492  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x79  , 0 , 472 , 143 , // 472  - ku-arab-iq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x74  , 0 , 473 , 240 , // 473  - ku-arab-ir
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf2  , 1 , 475 , 240 , // 474  - kw
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf2  , 1 , 475 , 240 , // 475  - kw-gb
            0x40   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x82  , 1 , 477 , 477 , // 476  - ky
            0x440  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x82  , 1 , 477 , 477 , // 477  - ky-kg
            0x76   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0x989e, 1 , 479 , 143 , // 478  - la
            0x476  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0x989e, 1 , 479 , 143 , // 479  - la-001
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 481 , 240 , // 480  - lag
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 481 , 240 , // 481  - lag-tz
            0x6e   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x93  , 1 , 483 , 483 , // 482  - lb
            0x46e  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x93  , 1 , 483 , 483 , // 483  - lb-lu
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 485 , 240 , // 484  - lg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 485 , 240 , // 485  - lg-ug
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf4  , 1 , 487 , 240 , // 486  - lkt
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf4  , 1 , 487 , 240 , // 487  - lkt-us
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2c  , 1 , 490 , 240 , // 488  - ln
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9   , 1 , 489 , 240 , // 489  - ln-ao
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2c  , 1 , 490 , 240 , // 490  - ln-cd
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x37  , 1 , 491 , 240 , // 491  - ln-cf
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2b  , 1 , 492 , 240 , // 492  - ln-cg
            0x54   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8a  , 1 , 494 , 143 , // 493  - lo
            0x454  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8a  , 1 , 494 , 143 , // 494  - lo-la
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x74  , 2 , 497 , 240 , // 495  - lrc
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x79  , 2 , 496 , 240 , // 496  - lrc-iq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x74  , 2 , 497 , 240 , // 497  - lrc-ir
            0x27   , 0x4e9 , 0x307 , 0x272d, 0x1f4 , 0x8d  , 1 , 499 , 499 , // 498  - lt
            0x427  , 0x4e9 , 0x307 , 0x272d, 0x1f4 , 0x8d  , 1 , 499 , 499 , // 499  - lt-lt
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2c  , 1 , 501 , 240 , // 500  - lu
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2c  , 1 , 501 , 240 , // 501  - lu-cd
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 503 , 240 , // 502  - luo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 503 , 240 , // 503  - luo-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 505 , 240 , // 504  - luy
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 505 , 240 , // 505  - luy-ke
            0x26   , 0x4e9 , 0x307 , 0x272d, 0x1f4 , 0x8c  , 1 , 507 , 507 , // 506  - lv
            0x426  , 0x4e9 , 0x307 , 0x272d, 0x1f4 , 0x8c  , 1 , 507 , 507 , // 507  - lv-lv
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 509 , 240 , // 508  - mas
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 509 , 240 , // 509  - mas-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 510 , 240 , // 510  - mas-tz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 512 , 240 , // 511  - mer
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 512 , 240 , // 512  - mer-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa0  , 1 , 514 , 240 , // 513  - mfe
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa0  , 1 , 514 , 240 , // 514  - mfe-mu
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x95  , 1 , 516 , 240 , // 515  - mg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x95  , 1 , 516 , 240 , // 516  - mg-mg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa8  , 1 , 518 , 240 , // 517  - mgh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa8  , 1 , 518 , 240 , // 518  - mgh-mz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 520 , 240 , // 519  - mgo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 520 , 240 , // 520  - mgo-cm
            0x81   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xb7  , 1 , 522 , 522 , // 521  - mi
            0x481  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xb7  , 1 , 522 , 522 , // 522  - mi-nz
            0x2f   , 0x4e3 , 0x362 , 0x2717, 0x1f4 , 0x4ca2, 1 , 524 , 524 , // 523  - mk
            0x42f  , 0x4e3 , 0x362 , 0x2717, 0x1f4 , 0x4ca2, 1 , 524 , 524 , // 524  - mk-mk
            0x4c   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 526 , 143 , // 525  - ml
            0x44c  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 526 , 143 , // 526  - ml-in
            0x50   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x9a  , 1 , 529 , 529 , // 527  - mn
            0x7850 , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x9a  , 1 , 529 , 529 , // 528  - mn-cyrl
            0x450  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0x9a  , 1 , 529 , 529 , // 529  - mn-mn
            0x7c50 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2d  , 1 , 531 , 531 , // 530  - mn-mong
            0x850  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2d  , 1 , 531 , 531 , // 531  - mn-mong-cn
            0xc50  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9a  , 1 , 532 , 532 , // 532  - mn-mong-mn
            0x58   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 534 , 187 , // 533  - mni
            0x458  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 534 , 187 , // 534  - mni-in
            0x7c   , 0x4e4 , 0x352 , 0x2710, 0x25  , 0x27  , 1 , 536 , 240 , // 535  - moh
            0x47c  , 0x4e4 , 0x352 , 0x2710, 0x25  , 0x27  , 1 , 536 , 240 , // 536  - moh-ca
            0x4e   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 538 , 143 , // 537  - mr
            0x44e  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 538 , 143 , // 538  - mr-in
            0x3e   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xa7  , 1 , 541 , 541 , // 539  - ms
            0x83e  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x25  , 1 , 540 , 540 , // 540  - ms-bn
            0x43e  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xa7  , 1 , 541 , 541 , // 541  - ms-my
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd7  , 1 , 542 , 240 , // 542  - ms-sg
            0x3a   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa3  , 1 , 544 , 544 , // 543  - mt
            0x43a  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa3  , 1 , 544 , 544 , // 544  - mt-mt
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 546 , 240 , // 545  - mua
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 546 , 240 , // 546  - mua-cm
            0x55   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x1b  , 2 , 548 , 240 , // 547  - my
            0x455  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x1b  , 2 , 548 , 240 , // 548  - my-mm
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x74  , 2 , 550 , 240 , // 549  - mzn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x74  , 2 , 550 , 240 , // 550  - mzn-ir
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xfe  , 1 , 552 , 240 , // 551  - naq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xfe  , 1 , 552 , 240 , // 552  - naq-na
            0x7c14 , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 554 , 554 , // 553  - nb
            0x414  , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 554 , 554 , // 554  - nb-no
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xdc  , 1 , 555 , 240 , // 555  - nb-sj
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x108 , 1 , 557 , 240 , // 556  - nd
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x108 , 1 , 557 , 240 , // 557  - nd-zw
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x5e  , 1 , 559 , 240 , // 558  - nds
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x5e  , 1 , 559 , 240 , // 559  - nds-de
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xb0  , 1 , 560 , 240 , // 560  - nds-nl
            0x61   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xb2  , 1 , 563 , 143 , // 561  - ne
            0x861  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 2 , 562 , 240 , // 562  - ne-in
            0x461  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xb2  , 1 , 563 , 143 , // 563  - ne-np
            0x13   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb0  , 1 , 569 , 569 , // 564  - nl
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x12e , 1 , 565 , 240 , // 565  - nl-aw
            0x813  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x15  , 1 , 566 , 566 , // 566  - nl-be
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x9a55d42, 1 , 567 , 240 , // 567  - nl-bq
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x111 , 1 , 568 , 240 , // 568  - nl-cw
            0x413  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb0  , 1 , 569 , 569 , // 569  - nl-nl
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xb5  , 1 , 570 , 240 , // 570  - nl-sr
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x78f7, 1 , 571 , 240 , // 571  - nl-sx
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 573 , 240 , // 572  - nmg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 573 , 240 , // 573  - nmg-cm
            0x7814 , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 575 , 575 , // 574  - nn
            0x814  , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 575 , 575 , // 575  - nn-no
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 577 , 240 , // 576  - nnh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 577 , 240 , // 577  - nnh-cm
            0x14   , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 554 , 554 , // 578  - no
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x64  , 2 , 580 , 143 , // 579  - nqo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x64  , 2 , 580 , 143 , // 580  - nqo-gn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 582 , 240 , // 581  - nr
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 582 , 240 , // 582  - nr-za
            0x6c   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 584 , 584 , // 583  - nso
            0x46c  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 584 , 584 , // 584  - nso-za
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x114 , 1 , 586 , 240 , // 585  - nus
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x114 , 1 , 586 , 240 , // 586  - nus-ss
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 588 , 240 , // 587  - nyn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 588 , 240 , // 588  - nyn-ug
            0x82   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 590 , 590 , // 589  - oc
            0x482  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x54  , 1 , 590 , 590 , // 590  - oc-fr
            0x72   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 592 , 240 , // 591  - om
            0x472  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 592 , 240 , // 592  - om-et
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 593 , 240 , // 593  - om-ke
            0x48   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 595 , 143 , // 594  - or
            0x448  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 595 , 143 , // 595  - or-in
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x58  , 1 , 597 , 240 , // 596  - os
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x58  , 1 , 597 , 240 , // 597  - os-ge
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xcb  , 1 , 598 , 240 , // 598  - os-ru
            0x46   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 602 , 143 , // 599  - pa
            0x7c46 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 2 , 601 , 143 , // 600  - pa-arab
            0x846  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 2 , 601 , 143 , // 601  - pa-arab-pk
            0x446  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 602 , 143 , // 602  - pa-in
            0x79   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x993248, 1 , 604 , 145 , // 603  - pap
            0x479  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x993248, 1 , 604 , 145 , // 604  - pap-029
            0x15   , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xbf  , 1 , 606 , 606 , // 605  - pl
            0x415  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xbf  , 1 , 606 , 606 , // 606  - pl-pl
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 608 , 240 , // 607  - prg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 608 , 240 , // 608  - prg-001
            0x8c   , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x3   , 2 , 610 , 143 , // 609  - prs
            0x48c  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x3   , 2 , 610 , 143 , // 610  - prs-af
            0x63   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3   , 2 , 612 , 143 , // 611  - ps
            0x463  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3   , 2 , 612 , 143 , // 612  - ps-af
            0x16   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x20  , 1 , 615 , 615 , // 613  - pt
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x9   , 1 , 614 , 240 , // 614  - pt-ao
            0x416  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x20  , 1 , 615 , 615 , // 615  - pt-br
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xdf  , 1 , 616 , 240 , // 616  - pt-ch
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x39  , 1 , 617 , 240 , // 617  - pt-cv
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x45  , 1 , 618 , 240 , // 618  - pt-gq
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xc4  , 1 , 619 , 240 , // 619  - pt-gw
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x93  , 1 , 620 , 240 , // 620  - pt-lu
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x97  , 1 , 621 , 240 , // 621  - pt-mo
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xa8  , 1 , 622 , 240 , // 622  - pt-mz
            0x816  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xc1  , 1 , 623 , 623 , // 623  - pt-pt
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xe9  , 1 , 624 , 240 , // 624  - pt-st
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x6f60e7, 1 , 625 , 240 , // 625  - pt-tl
            0x901  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x7c  , 1 , 626 , 190 , // 626  - qps-latn-x-sh
            0x501  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xf4  , 1 , 627 , 627 , // 627  - qps-ploc
            0x5fe  , 0x3a4 , 0x3a4 , 0x2711, 0x4f42, 0x7a  , 1 , 628 , 628 , // 628  - qps-ploca
            0x9ff  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xcd  , 0 , 629 , 143 , // 629  - qps-plocm
            0x86   , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x63  , 1 , 632 , 632 , // 630  - quc
            0x7c86 , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x63  , 1 , 632 , 632 , // 631  - quc-latn
            0x486  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x63  , 1 , 632 , 632 , // 632  - quc-latn-gt
            0x6b   , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x1a  , 1 , 634 , 634 , // 633  - quz
            0x46b  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x1a  , 1 , 634 , 634 , // 634  - quz-bo
            0x86b  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0x42  , 1 , 635 , 635 , // 635  - quz-ec
            0xc6b  , 0x4e4 , 0x352 , 0x2710, 0x4f3c, 0xbb  , 1 , 636 , 636 , // 636  - quz-pe
            0x17   , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0xdf  , 1 , 638 , 638 , // 637  - rm
            0x417  , 0x4e4 , 0x352 , 0x2710, 0x4f31, 0xdf  , 1 , 638 , 638 , // 638  - rm-ch
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x26  , 1 , 640 , 240 , // 639  - rn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x26  , 1 , 640 , 240 , // 640  - rn-bi
            0x18   , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xc8  , 1 , 643 , 643 , // 641  - ro
            0x818  , 0x4e2 , 0x354 , 0x2   , 0x1f4 , 0x98  , 1 , 642 , 240 , // 642  - ro-md
            0x418  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xc8  , 1 , 643 , 643 , // 643  - ro-ro
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 645 , 240 , // 644  - rof
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 645 , 240 , // 645  - rof-tz
            0x19   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 651 , 651 , // 646  - ru
            0x1000 , 0x4e3 , 0x362 , 0x2   , 0x1f4 , 0x1d  , 1 , 647 , 240 , // 647  - ru-by
            0x1000 , 0x4e3 , 0x362 , 0x2   , 0x1f4 , 0x82  , 1 , 648 , 240 , // 648  - ru-kg
            0x1000 , 0x4e3 , 0x362 , 0x2   , 0x1f4 , 0x89  , 1 , 649 , 240 , // 649  - ru-kz
            0x819  , 0x4e3 , 0x362 , 0x2   , 0x1f4 , 0x98  , 1 , 650 , 240 , // 650  - ru-md
            0x419  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 651 , 651 , // 651  - ru-ru
            0x1000 , 0x4e3 , 0x362 , 0x2   , 0x1f4 , 0xf1  , 1 , 652 , 240 , // 652  - ru-ua
            0x87   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xcc  , 1 , 654 , 654 , // 653  - rw
            0x487  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xcc  , 1 , 654 , 654 , // 654  - rw-rw
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 656 , 240 , // 655  - rwk
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 656 , 240 , // 656  - rwk-tz
            0x4f   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 658 , 143 , // 657  - sa
            0x44f  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 658 , 143 , // 658  - sa-in
            0x85   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 660 , 660 , // 659  - sah
            0x485  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 660 , 660 , // 660  - sah-ru
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 662 , 240 , // 661  - saq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 662 , 240 , // 662  - saq-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 664 , 240 , // 663  - sbp
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 664 , 240 , // 664  - sbp-tz
            0x59   , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 2 , 667 , 143 , // 665  - sd
            0x7c59 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 2 , 667 , 143 , // 666  - sd-arab
            0x859  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 2 , 667 , 143 , // 667  - sd-arab-pk
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 669 , 187 , // 668  - sd-deva
            0x459  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 669 , 187 , // 669  - sd-deva-in
            0x3b   , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 672 , 672 , // 670  - se
            0xc3b  , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 671 , 671 , // 671  - se-fi
            0x43b  , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 672 , 672 , // 672  - se-no
            0x83b  , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 673 , 673 , // 673  - se-se
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa8  , 1 , 675 , 240 , // 674  - seh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa8  , 1 , 675 , 240 , // 675  - seh-mz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 677 , 240 , // 676  - ses
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9d  , 1 , 677 , 240 , // 677  - ses-ml
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x37  , 1 , 679 , 240 , // 678  - sg
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x37  , 1 , 679 , 240 , // 679  - sg-cf
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 684 , 240 , // 680  - shi
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 682 , 240 , // 681  - shi-latn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 682 , 240 , // 682  - shi-latn-ma
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 684 , 240 , // 683  - shi-tfng
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 684 , 240 , // 684  - shi-tfng-ma
            0x5b   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2a  , 1 , 686 , 143 , // 685  - si
            0x45b  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2a  , 1 , 686 , 143 , // 686  - si-lk
            0x1b   , 0x4e2 , 0x354 , 0x272d, 0x5190, 0x8f  , 1 , 688 , 688 , // 687  - sk
            0x41b  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0x8f  , 1 , 688 , 688 , // 688  - sk-sk
            0x24   , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xd4  , 1 , 690 , 690 , // 689  - sl
            0x424  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xd4  , 1 , 690 , 690 , // 690  - sl-si
            0x783b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 693 , 693 , // 691  - sma
            0x183b , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 692 , 692 , // 692  - sma-no
            0x1c3b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 693 , 693 , // 693  - sma-se
            0x7c3b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 696 , 696 , // 694  - smj
            0x103b , 0x4e4 , 0x352 , 0x2710, 0x4f35, 0xb1  , 1 , 695 , 695 , // 695  - smj-no
            0x143b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 696 , 696 , // 696  - smj-se
            0x703b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 698 , 698 , // 697  - smn
            0x243b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 698 , 698 , // 698  - smn-fi
            0x743b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 700 , 700 , // 699  - sms
            0x203b , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 700 , 700 , // 700  - sms-fi
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x108 , 1 , 703 , 240 , // 701  - sn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x108 , 1 , 703 , 240 , // 702  - sn-latn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x108 , 1 , 703 , 240 , // 703  - sn-latn-zw
            0x77   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd8  , 1 , 708 , 240 , // 704  - so
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3e  , 1 , 705 , 240 , // 705  - so-dj
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 706 , 240 , // 706  - so-et
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 707 , 240 , // 707  - so-ke
            0x477  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd8  , 1 , 708 , 240 , // 708  - so-so
            0x1c   , 0x4e2 , 0x354 , 0x272d, 0x5190, 0x6   , 1 , 710 , 710 , // 709  - sq
            0x41c  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0x6   , 1 , 710 , 710 , // 710  - sq-al
            0x1000 , 0x4e2 , 0x354 , 0x272d, 0x5190, 0x4ca2, 1 , 711 , 240 , // 711  - sq-mk
            0x1000 , 0x4e2 , 0x354 , 0x272d, 0x5190, 0x974941, 1 , 712 , 240 , // 712  - sq-xk
            0x7c1a , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x10f , 1 , 724 , 724 , // 713  - sr
            0x6c1a , 0x4e3 , 0x357 , 0x2717, 0x5221, 0x10f , 1 , 718 , 718 , // 714  - sr-cyrl
            0x1c1a , 0x4e3 , 0x357 , 0x2717, 0x5221, 0x19  , 1 , 715 , 715 , // 715  - sr-cyrl-ba
            0xc1a  , 0x4e3 , 0x357 , 0x2717, 0x5221, 0x10d , 1 , 716 , 716 , // 716  - sr-cyrl-cs
            0x301a , 0x4e3 , 0x357 , 0x2717, 0x5221, 0x10e , 1 , 717 , 717 , // 717  - sr-cyrl-me
            0x281a , 0x4e3 , 0x357 , 0x2717, 0x5221, 0x10f , 1 , 718 , 718 , // 718  - sr-cyrl-rs
            0x1000 , 0x4e3 , 0x357 , 0x2717, 0x5221, 0x974941, 1 , 719 , 240 , // 719  - sr-cyrl-xk
            0x701a , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x10f , 1 , 724 , 724 , // 720  - sr-latn
            0x181a , 0x4e2 , 0x354 , 0x2762, 0x366 , 0x19  , 1 , 721 , 721 , // 721  - sr-latn-ba
            0x81a  , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x10d , 1 , 722 , 722 , // 722  - sr-latn-cs
            0x2c1a , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x10e , 1 , 723 , 723 , // 723  - sr-latn-me
            0x241a , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x10f , 1 , 724 , 724 , // 724  - sr-latn-rs
            0x1000 , 0x4e2 , 0x354 , 0x272d, 0x1f4 , 0x974941, 1 , 725 , 240 , // 725  - sr-latn-xk
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 728 , 240 , // 726  - ss
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x104 , 1 , 727 , 240 , // 727  - ss-sz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 728 , 240 , // 728  - ss-za
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 730 , 240 , // 729  - ssy
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 730 , 240 , // 730  - ssy-er
            0x30   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 733 , 240 , // 731  - st
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x92  , 1 , 732 , 240 , // 732  - st-ls
            0x430  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 733 , 240 , // 733  - st-za
            0x1d   , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 737 , 737 , // 734  - sv
            0x1000 , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x9906f5, 1 , 735 , 240 , // 735  - sv-ax
            0x81d  , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0x4d  , 1 , 736 , 736 , // 736  - sv-fi
            0x41d  , 0x4e4 , 0x352 , 0x2710, 0x4f36, 0xdd  , 1 , 737 , 737 , // 737  - sv-se
            0x41   , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0x81  , 1 , 740 , 740 , // 738  - sw
            0x1000 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0x2c  , 1 , 739 , 740 , // 739  - sw-cd
            0x441  , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0x81  , 1 , 740 , 740 , // 740  - sw-ke
            0x1000 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xef  , 1 , 741 , 240 , // 741  - sw-tz
            0x1000 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0xf0  , 1 , 742 , 240 , // 742  - sw-ug
            0x1000 , 0x0   , 0x1   , 0x0   , 0x1f4 , 0x2c  , 1 , 744 , 240 , // 743  - swc
            0x1000 , 0x0   , 0x1   , 0x0   , 0x1f4 , 0x2c  , 1 , 744 , 240 , // 744  - swc-cd
            0x5a   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xde  , 1 , 746 , 143 , // 745  - syr
            0x45a  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xde  , 1 , 746 , 143 , // 746  - syr-sy
            0x49   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 748 , 143 , // 747  - ta
            0x449  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 748 , 143 , // 748  - ta-in
            0x849  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x2a  , 1 , 749 , 143 , // 749  - ta-lk
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xa7  , 1 , 750 , 240 , // 750  - ta-my
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd7  , 1 , 751 , 240 , // 751  - ta-sg
            0x4a   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 753 , 143 , // 752  - te
            0x44a  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x71  , 1 , 753 , 143 , // 753  - te-in
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 756 , 240 , // 754  - teo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x81  , 1 , 755 , 240 , // 755  - teo-ke
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 756 , 240 , // 756  - teo-ug
            0x28   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xe4  , 1 , 759 , 759 , // 757  - tg
            0x7c28 , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xe4  , 1 , 759 , 759 , // 758  - tg-cyrl
            0x428  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xe4  , 1 , 759 , 759 , // 759  - tg-cyrl-tj
            0x1e   , 0x36a , 0x36a , 0x2725, 0x5166, 0xe3  , 1 , 761 , 143 , // 760  - th
            0x41e  , 0x36a , 0x36a , 0x2725, 0x5166, 0xe3  , 1 , 761 , 143 , // 761  - th-th
            0x73   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 763 , 143 , // 762  - ti
            0x873  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 763 , 143 , // 763  - ti-er
            0x473  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 764 , 143 , // 764  - ti-et
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 766 , 240 , // 765  - tig
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x47  , 1 , 766 , 240 , // 766  - tig-er
            0x42   , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xee  , 1 , 768 , 768 , // 767  - tk
            0x442  , 0x4e2 , 0x354 , 0x272d, 0x5190, 0xee  , 1 , 768 , 768 , // 768  - tk-tm
            0x32   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 771 , 771 , // 769  - tn
            0x832  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0x13  , 1 , 770 , 770 , // 770  - tn-bw
            0x432  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 771 , 771 , // 771  - tn-za
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xe7  , 1 , 773 , 240 , // 772  - to
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xe7  , 1 , 773 , 240 , // 773  - to-to
            0x1f   , 0x4e6 , 0x359 , 0x2761, 0x51a9, 0xeb  , 1 , 776 , 776 , // 774  - tr
            0x1000 , 0x4e6 , 0x359 , 0x2761, 0x51a9, 0x3b  , 1 , 775 , 240 , // 775  - tr-cy
            0x41f  , 0x4e6 , 0x359 , 0x2761, 0x51a9, 0xeb  , 1 , 776 , 776 , // 776  - tr-tr
            0x31   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 778 , 240 , // 777  - ts
            0x431  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 778 , 240 , // 778  - ts-za
            0x44   , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 780 , 780 , // 779  - tt
            0x444  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xcb  , 1 , 780 , 780 , // 780  - tt-ru
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xad  , 1 , 782 , 240 , // 781  - twq
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xad  , 1 , 782 , 240 , // 782  - twq-ne
            0x5f   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x4   , 1 , 787 , 787 , // 783  - tzm
            0x1000 , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x9f  , 1 , 785 , 240 , // 784  - tzm-arab
            0x45f  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x9f  , 1 , 785 , 240 , // 785  - tzm-arab-ma
            0x7c5f , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x4   , 1 , 787 , 787 , // 786  - tzm-latn
            0x85f  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0x4   , 1 , 787 , 787 , // 787  - tzm-latn-dz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 788 , 240 , // 788  - tzm-latn-ma
            0x785f , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 790 , 316 , // 789  - tzm-tfng
            0x105f , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 790 , 316 , // 790  - tzm-tfng-ma
            0x80   , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x2d  , 1 , 792 , 143 , // 791  - ug
            0x480  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0x2d  , 1 , 792 , 143 , // 792  - ug-cn
            0x22   , 0x4e3 , 0x362 , 0x2721, 0x1f4 , 0xf1  , 1 , 794 , 794 , // 793  - uk
            0x422  , 0x4e3 , 0x362 , 0x2721, 0x1f4 , 0xf1  , 1 , 794 , 794 , // 794  - uk-ua
            0x20   , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 1 , 797 , 143 , // 795  - ur
            0x820  , 0x4e8 , 0x2d0 , 0x2   , 0x1f4 , 0x71  , 2 , 796 , 240 , // 796  - ur-in
            0x420  , 0x4e8 , 0x2d0 , 0x2714, 0x4fc4, 0xbe  , 1 , 797 , 143 , // 797  - ur-pk
            0x43   , 0x4e6 , 0x359 , 0x272d, 0x1f4 , 0xf7  , 1 , 804 , 804 , // 798  - uz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3   , 2 , 800 , 240 , // 799  - uz-arab
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x3   , 2 , 800 , 240 , // 800  - uz-arab-af
            0x7843 , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xf7  , 1 , 802 , 802 , // 801  - uz-cyrl
            0x843  , 0x4e3 , 0x362 , 0x2717, 0x5190, 0xf7  , 1 , 802 , 802 , // 802  - uz-cyrl-uz
            0x7c43 , 0x4e6 , 0x359 , 0x272d, 0x1f4 , 0xf7  , 1 , 804 , 804 , // 803  - uz-latn
            0x443  , 0x4e6 , 0x359 , 0x272d, 0x1f4 , 0xf7  , 1 , 804 , 804 , // 804  - uz-latn-uz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8e  , 1 , 809 , 240 , // 805  - vai
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8e  , 1 , 807 , 240 , // 806  - vai-latn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8e  , 1 , 807 , 240 , // 807  - vai-latn-lr
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8e  , 1 , 809 , 240 , // 808  - vai-vaii
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x8e  , 1 , 809 , 240 , // 809  - vai-vaii-lr
            0x33   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 811 , 240 , // 810  - ve
            0x433  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xd1  , 1 , 811 , 240 , // 811  - ve-za
            0x2a   , 0x4ea , 0x4ea , 0x2710, 0x1f4 , 0xfb  , 1 , 813 , 143 , // 812  - vi
            0x42a  , 0x4ea , 0x4ea , 0x2710, 0x1f4 , 0xfb  , 1 , 813 , 143 , // 813  - vi-vn
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 815 , 240 , // 814  - vo
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 815 , 240 , // 815  - vo-001
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 817 , 240 , // 816  - vun
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xef  , 1 , 817 , 240 , // 817  - vun-tz
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xdf  , 1 , 819 , 240 , // 818  - wae
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xdf  , 1 , 819 , 240 , // 819  - wae-ch
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 821 , 240 , // 820  - wal
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x49  , 1 , 821 , 240 , // 821  - wal-et
            0x88   , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd2  , 1 , 823 , 823 , // 822  - wo
            0x488  , 0x4e4 , 0x352 , 0x2710, 0x4f49, 0xd2  , 1 , 823 , 823 , // 823  - wo-sn
            0x1007f, 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xf4  , 1 , -1  , -1  , // 824  - x-iv_mathan
            0x34   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 826 , 826 , // 825  - xh
            0x434  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 826 , 826 , // 826  - xh-za
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 828 , 240 , // 827  - xog
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0xf0  , 1 , 828 , 240 , // 828  - xog-ug
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 830 , 240 , // 829  - yav
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x31  , 1 , 830 , 240 , // 830  - yav-cm
            0x3d   , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 832 , 240 , // 831  - yi
            0x43d  , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x989e, 1 , 832 , 240 , // 832  - yi-001
            0x6a   , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 835 , 835 , // 833  - yo
            0x1000 , 0x4e4 , 0x1b5 , 0x2710, 0x1f4 , 0x1c  , 1 , 834 , 240 , // 834  - yo-bj
            0x46a  , 0x4e4 , 0x1b5 , 0x2710, 0x25  , 0xaf  , 1 , 835 , 835 , // 835  - yo-ng
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x68  , 1 , 837 , 240 , // 836  - yue
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x68  , 1 , 837 , 240 , // 837  - yue-hk
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 840 , 316 , // 838  - zgh
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 840 , 316 , // 839  - zgh-tfng
            0x1000 , 0x0   , 0x1   , 0x2   , 0x1f4 , 0x9f  , 1 , 840 , 316 , // 840  - zgh-tfng-ma
            0x7804 , 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x2d  , 1 , 844 , 844 , // 841  - zh
            0x4    , 0x3a8 , 0x3a8 , 0x0   , 0x1f4 , 0x2d  , 1 , 844 , 844 , // 842  - zh-chs
            0x7c04 , 0x3b6 , 0x3b6 , 0x0   , 0x1f4 , 0x68  , 1 , 851 , 851 , // 843  - zh-cht
            0x804  , 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x2d  , 1 , 844 , 844 , // 844  - zh-cn
            0x50804, 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x2d  , 1 , 844 , 844 , // 845  - zh-cn_phoneb
            0x20804, 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x2d  , 1 , 844 , 844 , // 846  - zh-cn_stroke
            0x4    , 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x2d  , 1 , 844 , 844 , // 847  - zh-hans
            0x1000 , 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x68  , 1 , 848 , 240 , // 848  - zh-hans-hk
            0x1000 , 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0x97  , 1 , 849 , 240 , // 849  - zh-hans-mo
            0x7c04 , 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0x68  , 1 , 851 , 851 , // 850  - zh-hant
            0xc04  , 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0x68  , 1 , 851 , 851 , // 851  - zh-hk
            0x40c04, 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0x68  , 1 , 851 , 851 , // 852  - zh-hk_radstr
            0x1404 , 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0x97  , 1 , 853 , 853 , // 853  - zh-mo
            0x41404, 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0x97  , 1 , 853 , 853 , // 854  - zh-mo_radstr
            0x21404, 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0x97  , 1 , 853 , 853 , // 855  - zh-mo_stroke
            0x1004 , 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0xd7  , 1 , 856 , 856 , // 856  - zh-sg
            0x51004, 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0xd7  , 1 , 856 , 856 , // 857  - zh-sg_phoneb
            0x21004, 0x3a8 , 0x3a8 , 0x2718, 0x1f4 , 0xd7  , 1 , 856 , 856 , // 858  - zh-sg_stroke
            0x404  , 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0xed  , 1 , 859 , 859 , // 859  - zh-tw
            0x30404, 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0xed  , 1 , 859 , 859 , // 860  - zh-tw_pronun
            0x40404, 0x3b6 , 0x3b6 , 0x2712, 0x1f4 , 0xed  , 1 , 859 , 859 , // 861  - zh-tw_radstr
            0x35   , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 863 , 863 , // 862  - zu
            0x435  , 0x4e4 , 0x352 , 0x2710, 0x1f4 , 0xd1  , 1 , 863 , 863 , // 863  - zu-za
        };

        // s_lcids list all supported lcids. used to binary search and we use the index of the matched lcid to
        // get the index in s_localeNamesIndices using s_lcidToCultureNameIndices
        private static readonly int[] s_lcids = new int[]
        {
            // Lcid , index   - index in c_localeNames
            0x1    , // 0    - 52
            0x2    , // 1    - 301
            0x3    , // 2    - 421
            0x4    , // 3    - 4139
            0x5    , // 4    - 502
            0x6    , // 5    - 523
            0x7    , // 6    - 544
            0x8    , // 7    - 664
            0x9    , // 8    - 676
            0xa    , // 9    - 1214
            0xb    , // 10   - 1423
            0xc    , // 11   - 1451
            0xd    , // 12   - 1825
            0xe    , // 13   - 1860
            0xf    , // 14   - 1929
            0x10   , // 15   - 1936
            0x11   , // 16   - 1989
            0x12   , // 17   - 2179
            0x13   , // 18   - 2685
            0x14   , // 19   - 2747
            0x15   , // 20   - 2864
            0x16   , // 21   - 2897
            0x17   , // 22   - 3041
            0x18   , // 23   - 3055
            0x19   , // 24   - 3076
            0x1a   , // 25   - 1839
            0x1b   , // 26   - 3284
            0x1c   , // 27   - 3387
            0x1d   , // 28   - 3553
            0x1e   , // 29   - 3673
            0x1f   , // 30   - 3727
            0x20   , // 31   - 3847
            0x21   , // 32   - 1908
            0x22   , // 33   - 3840
            0x23   , // 34   - 276
            0x24   , // 35   - 3291
            0x25   , // 36   - 1354
            0x26   , // 37   - 2429
            0x27   , // 38   - 2397
            0x28   , // 39   - 3654
            0x29   , // 40   - 1377
            0x2a   , // 41   - 3960
            0x2b   , // 42   - 1879
            0x2c   , // 43   - 224
            0x2d   , // 44   - 1361
            0x2e   , // 45   - 1851
            0x2f   , // 46   - 2501
            0x30   , // 47   - 3541
            0x31   , // 48   - 3739
            0x32   , // 49   - 3708
            0x33   , // 50   - 3953
            0x34   , // 51   - 4020
            0x35   , // 52   - 4277
            0x36   , // 53   - 17
            0x37   , // 54   - 2062
            0x38   , // 55   - 1439
            0x39   , // 56   - 1832
            0x3a   , // 57   - 2598
            0x3b   , // 58   - 3194
            0x3c   , // 59   - 1705
            0x3d   , // 60   - 4045
            0x3e   , // 61   - 2581
            0x3f   , // 62   - 2133
            0x40   , // 63   - 2306
            0x41   , // 64   - 3570
            0x42   , // 65   - 3701
            0x43   , // 66   - 3859
            0x44   , // 67   - 3746
            0x45   , // 68   - 336
            0x46   , // 69   - 2830
            0x47   , // 70   - 1754
            0x48   , // 71   - 2811
            0x49   , // 72   - 3610
            0x4a   , // 73   - 3632
            0x4b   , // 74   - 2172
            0x4c   , // 75   - 2508
            0x4d   , // 76   - 199
            0x4e   , // 77   - 2574
            0x4f   , // 78   - 3124
            0x50   , // 79   - 2515
            0x51   , // 80   - 348
            0x52   , // 81   - 516
            0x53   , // 82   - 2165
            0x54   , // 83   - 2375
            0x55   , // 84   - 2614
            0x56   , // 85   - 1719
            0x57   , // 86   - 2191
            0x58   , // 87   - 2556
            0x59   , // 88   - 3158
            0x5a   , // 89   - 3601
            0x5b   , // 90   - 3277
            0x5c   , // 91   - 473
            0x5d   , // 92   - 1953
            0x5e   , // 93   - 45
            0x5f   , // 94   - 3762
            0x60   , // 95   - 2207
            0x61   , // 96   - 2673
            0x62   , // 97   - 1698
            0x63   , // 98   - 2890
            0x64   , // 99   - 1430
            0x65   , // 100  - 620
            0x66   , // 101  - 308
            0x67   , // 102  - 1384
            0x68   , // 103  - 1777
            0x69   , // 104  - 1899
            0x6a   , // 105  - 4053
            0x6b   , // 106  - 3020
            0x6c   , // 107  - 2765
            0x6d   , // 108  - 260
            0x6e   , // 109  - 2330
            0x6f   , // 110  - 2149
            0x70   , // 111  - 1915
            0x71   , // 112  - 2200
            0x72   , // 113  - 2799
            0x73   , // 114  - 3680
            0x74   , // 115  - 1726
            0x75   , // 116  - 1816
            0x76   , // 117  - 2313
            0x77   , // 118  - 3365
            0x78   , // 119  - 1922
            0x79   , // 120  - 2854
            0x7a   , // 121  - 190
            0x7c   , // 122  - 2565
            0x7e   , // 123  - 360
            0x80   , // 124  - 3833
            0x81   , // 125  - 2494
            0x82   , // 126  - 2792
            0x83   , // 127  - 495
            0x84   , // 128  - 1733
            0x85   , // 129  - 3131
            0x86   , // 130  - 2998
            0x87   , // 131  - 3108
            0x88   , // 132  - 4002
            0x8c   , // 133  - 2881
            0x91   , // 134  - 1712
            0x92   , // 135  - 2270
            0x401  , // 136  - 150
            0x402  , // 137  - 303
            0x403  , // 138  - 428
            0x404  , // 139  - 4248
            0x405  , // 140  - 504
            0x406  , // 141  - 525
            0x407  , // 142  - 561
            0x408  , // 143  - 671
            0x409  , // 144  - 1161
            0x40a  , // 145  - 1272
            0x40b  , // 146  - 1425
            0x40c  , // 147  - 1529
            0x40d  , // 148  - 1827
            0x40e  , // 149  - 1862
            0x40f  , // 150  - 1931
            0x410  , // 151  - 1943
            0x411  , // 152  - 1991
            0x412  , // 153  - 2186
            0x413  , // 154  - 2707
            0x414  , // 155  - 2641
            0x415  , // 156  - 2866
            0x416  , // 157  - 2904
            0x417  , // 158  - 3043
            0x418  , // 159  - 3062
            0x419  , // 160  - 3098
            0x41a  , // 161  - 1846
            0x41b  , // 162  - 3286
            0x41c  , // 163  - 3389
            0x41d  , // 164  - 3565
            0x41e  , // 165  - 3675
            0x41f  , // 166  - 3734
            0x420  , // 167  - 3854
            0x421  , // 168  - 1910
            0x422  , // 169  - 3842
            0x423  , // 170  - 278
            0x424  , // 171  - 3293
            0x425  , // 172  - 1356
            0x426  , // 173  - 2431
            0x427  , // 174  - 2399
            0x428  , // 175  - 3663
            0x429  , // 176  - 1379
            0x42a  , // 177  - 3962
            0x42b  , // 178  - 1881
            0x42c  , // 179  - 250
            0x42d  , // 180  - 1363
            0x42e  , // 181  - 1854
            0x42f  , // 182  - 2503
            0x430  , // 183  - 3548
            0x431  , // 184  - 3741
            0x432  , // 185  - 3715
            0x433  , // 186  - 3955
            0x434  , // 187  - 4022
            0x435  , // 188  - 4279
            0x436  , // 189  - 24
            0x437  , // 190  - 2064
            0x438  , // 191  - 1446
            0x439  , // 192  - 1834
            0x43a  , // 193  - 2600
            0x43b  , // 194  - 3201
            0x43d  , // 195  - 4047
            0x43e  , // 196  - 2588
            0x43f  , // 197  - 2135
            0x440  , // 198  - 2308
            0x441  , // 199  - 3577
            0x442  , // 200  - 3703
            0x443  , // 201  - 3902
            0x444  , // 202  - 3748
            0x445  , // 203  - 343
            0x446  , // 204  - 2849
            0x447  , // 205  - 1756
            0x448  , // 206  - 2813
            0x449  , // 207  - 3612
            0x44a  , // 208  - 3634
            0x44b  , // 209  - 2174
            0x44c  , // 210  - 2510
            0x44d  , // 211  - 201
            0x44e  , // 212  - 2576
            0x44f  , // 213  - 3126
            0x450  , // 214  - 2524
            0x451  , // 215  - 350
            0x452  , // 216  - 518
            0x453  , // 217  - 2167
            0x454  , // 218  - 2377
            0x455  , // 219  - 2616
            0x456  , // 220  - 1721
            0x457  , // 221  - 2194
            0x458  , // 222  - 2559
            0x459  , // 223  - 3184
            0x45a  , // 224  - 3604
            0x45b  , // 225  - 3279
            0x45c  , // 226  - 484
            0x45d  , // 227  - 1962
            0x45e  , // 228  - 47
            0x45f  , // 229  - 3773
            0x460  , // 230  - 2209
            0x461  , // 231  - 2680
            0x462  , // 232  - 1700
            0x463  , // 233  - 2892
            0x464  , // 234  - 1433
            0x465  , // 235  - 622
            0x466  , // 236  - 311
            0x467  , // 237  - 1418
            0x468  , // 238  - 1806
            0x469  , // 239  - 1902
            0x46a  , // 240  - 4060
            0x46b  , // 241  - 3023
            0x46c  , // 242  - 2768
            0x46d  , // 243  - 262
            0x46e  , // 244  - 2332
            0x46f  , // 245  - 2151
            0x470  , // 246  - 1917
            0x471  , // 247  - 2202
            0x472  , // 248  - 2801
            0x473  , // 249  - 3687
            0x474  , // 250  - 1728
            0x475  , // 251  - 1819
            0x476  , // 252  - 2315
            0x477  , // 253  - 3382
            0x478  , // 254  - 1924
            0x479  , // 255  - 2857
            0x47a  , // 256  - 193
            0x47c  , // 257  - 2568
            0x47e  , // 258  - 362
            0x480  , // 259  - 3835
            0x481  , // 260  - 2496
            0x482  , // 261  - 2794
            0x483  , // 262  - 497
            0x484  , // 263  - 1742
            0x485  , // 264  - 3134
            0x486  , // 265  - 3009
            0x487  , // 266  - 3110
            0x488  , // 267  - 4004
            0x48c  , // 268  - 2884
            0x491  , // 269  - 1714
            0x492  , // 270  - 2279
            0x501  , // 271  - 2972
            0x5fe  , // 272  - 2980
            0x801  , // 273  - 95
            0x803  , // 274  - 433
            0x804  , // 275  - 4110
            0x807  , // 276  - 556
            0x809  , // 277  - 831
            0x80a  , // 278  - 1299
            0x80c  , // 279  - 1459
            0x810  , // 280  - 1938
            0x813  , // 281  - 2692
            0x814  , // 282  - 2733
            0x816  , // 283  - 2944
            0x818  , // 284  - 3057
            0x819  , // 285  - 3093
            0x81a  , // 286  - 3480
            0x81d  , // 287  - 3560
            0x820  , // 288  - 3849
            0x82c  , // 289  - 233
            0x82e  , // 290  - 605
            0x832  , // 291  - 3710
            0x83b  , // 292  - 3206
            0x83c  , // 293  - 1707
            0x83e  , // 294  - 2583
            0x843  , // 295  - 3885
            0x845  , // 296  - 338
            0x846  , // 297  - 2839
            0x849  , // 298  - 3617
            0x850  , // 299  - 2536
            0x859  , // 300  - 3167
            0x85d  , // 301  - 1979
            0x85f  , // 302  - 3792
            0x860  , // 303  - 2233
            0x861  , // 304  - 2675
            0x867  , // 305  - 1403
            0x86b  , // 306  - 3029
            0x873  , // 307  - 3682
            0x901  , // 308  - 2959
            0x9ff  , // 309  - 2989
            0xc01  , // 310  - 80
            0xc04  , // 311  - 4173
            0xc07  , // 312  - 546
            0xc09  , // 313  - 716
            0xc0a  , // 314  - 1267
            0xc0c  , // 315  - 1484
            0xc1a  , // 316  - 3423
            0xc3b  , // 317  - 3196
            0xc50  , // 318  - 2546
            0xc51  , // 319  - 638
            0xc6b  , // 320  - 3035
            0x1001 , // 321  - 120
            0x1004 , // 322  - 4219
            0x1007 , // 323  - 588
            0x1009 , // 324  - 756
            0x100a , // 325  - 1289
            0x100c , // 326  - 1504
            0x101a , // 327  - 1841
            0x103b , // 328  - 3316
            0x105f , // 329  - 3822
            0x1401 , // 330  - 75
            0x1404 , // 331  - 4190
            0x1407 , // 332  - 583
            0x1409 , // 333  - 1026
            0x140a , // 334  - 1247
            0x140c , // 335  - 1569
            0x141a , // 336  - 402
            0x143b , // 337  - 3322
            0x1801 , // 338  - 125
            0x1809 , // 339  - 881
            0x180a , // 340  - 1309
            0x180c , // 341  - 1579
            0x181a , // 342  - 3470
            0x183b , // 343  - 3301
            0x1c01 , // 344  - 180
            0x1c09 , // 345  - 1191
            0x1c0a , // 346  - 1257
            0x1c0c , // 347  - 1453
            0x1c1a , // 348  - 3413
            0x1c3b , // 349  - 3307
            0x2001 , // 350  - 135
            0x2009 , // 351  - 911
            0x200a , // 352  - 1349
            0x200c , // 353  - 1634
            0x201a , // 354  - 385
            0x203b , // 355  - 3340
            0x2401 , // 356  - 185
            0x2409 , // 357  - 684
            0x240a , // 358  - 1242
            0x240c , // 359  - 1489
            0x241a , // 360  - 3500
            0x243b , // 361  - 3331
            0x2801 , // 362  - 170
            0x2809 , // 363  - 751
            0x280a , // 364  - 1314
            0x280c , // 365  - 1649
            0x281a , // 366  - 3443
            0x2c01 , // 367  - 100
            0x2c09 , // 368  - 1136
            0x2c0a , // 369  - 1222
            0x2c0c , // 370  - 1514
            0x2c1a , // 371  - 3490
            0x3001 , // 372  - 115
            0x3009 , // 373  - 1201
            0x300a , // 374  - 1262
            0x300c , // 375  - 1509
            0x301a , // 376  - 3433
            0x3401 , // 377  - 110
            0x3409 , // 378  - 1036
            0x340a , // 379  - 1237
            0x340c , // 380  - 1594
            0x3801 , // 381  - 60
            0x3809 , // 382  - 876
            0x380a , // 383  - 1344
            0x380c , // 384  - 1574
            0x3c01 , // 385  - 65
            0x3c09 , // 386  - 871
            0x3c0a , // 387  - 1329
            0x3c0c , // 388  - 1559
            0x4001 , // 389  - 145
            0x4009 , // 390  - 896
            0x400a , // 391  - 1227
            0x4409 , // 392  - 991
            0x440a , // 393  - 1334
            0x4809 , // 394  - 1086
            0x480a , // 395  - 1294
            0x4c0a , // 396  - 1304
            0x500a , // 397  - 1324
            0x540a , // 398  - 1339
            0x580a , // 399  - 1216
            0x5c0a , // 400  - 1252
            0x641a , // 401  - 378
            0x681a , // 402  - 395
            0x6c1a , // 403  - 3406
            0x701a , // 404  - 3463
            0x703b , // 405  - 3328
            0x742c , // 406  - 226
            0x743b , // 407  - 3337
            0x7804 , // 408  - 4096
            0x7814 , // 409  - 2731
            0x781a , // 410  - 376
            0x782c , // 411  - 243
            0x783b , // 412  - 3298
            0x7843 , // 413  - 3878
            0x7850 , // 414  - 2517
            0x785d , // 415  - 1955
            0x785f , // 416  - 3814
            0x7c04 , // 417  - 4166
            0x7c14 , // 418  - 2639
            0x7c1a , // 419  - 3404
            0x7c28 , // 420  - 3656
            0x7c2e , // 421  - 602
            0x7c3b , // 422  - 3313
            0x7c43 , // 423  - 3895
            0x7c46 , // 424  - 2832
            0x7c50 , // 425  - 2529
            0x7c59 , // 426  - 3160
            0x7c5c , // 427  - 476
            0x7c5d , // 428  - 1972
            0x7c5f , // 429  - 3784
            0x7c67 , // 430  - 1396
            0x7c68 , // 431  - 1779
            0x7c86 , // 432  - 3001
            0x7c92 , // 433  - 2272
            0x1007f, // 434  - 4009
            0x10407, // 435  - 566
            0x1040e, // 436  - 1867
            0x10437, // 437  - 2069
            0x20804, // 438  - 4127
            0x21004, // 439  - 4236
            0x21404, // 440  - 4207
            0x30404, // 441  - 4253
            0x40404, // 442  - 4265
            0x40411, // 443  - 1996
            0x40c04, // 444  - 4178
            0x41404, // 445  - 4195
            0x50804, // 446  - 4115
            0x51004  // 447  - 4224
        };
        // each element in s_lcidToCultureNameIndices is index to s_localeNamesIndices
        private static readonly int[] s_lcidToCultureNameIndices = new int[]
        {
        // Index to s_localeNamesIndices, index to this array - lcid  - index to the c_localeNames
            13   , // 0    - 1     - 52
            64   , // 1    - 2     - 301
            88   , // 2    - 3     - 421
            847  , // 3    - 4     - 4139
            103  , // 4    - 5     - 502
            109  , // 5    - 6     - 523
            114  , // 6    - 7     - 544
            140  , // 7    - 8     - 664
            143  , // 8    - 9     - 676
            251  , // 9    - a     - 1214
            293  , // 10   - b     - 1423
            300  , // 11   - c     - 1451
            377  , // 12   - d     - 1825
            386  , // 13   - e     - 1860
            402  , // 14   - f     - 1929
            404  , // 15   - 10    - 1936
            413  , // 16   - 11    - 1989
            452  , // 17   - 12    - 2179
            564  , // 18   - 13    - 2685
            578  , // 19   - 14    - 2747
            605  , // 20   - 15    - 2864
            613  , // 21   - 16    - 2897
            637  , // 22   - 17    - 3041
            641  , // 23   - 18    - 3055
            646  , // 24   - 19    - 3076
            381  , // 25   - 1a    - 1839
            687  , // 26   - 1b    - 3284
            709  , // 27   - 1c    - 3387
            734  , // 28   - 1d    - 3553
            760  , // 29   - 1e    - 3673
            774  , // 30   - 1f    - 3727
            795  , // 31   - 20    - 3847
            396  , // 32   - 21    - 1908
            793  , // 33   - 22    - 3840
            58   , // 34   - 23    - 276
            689  , // 35   - 24    - 3291
            278  , // 36   - 25    - 1354
            506  , // 37   - 26    - 2429
            498  , // 38   - 27    - 2397
            757  , // 39   - 28    - 3654
            284  , // 40   - 29    - 1377
            812  , // 41   - 2a    - 3960
            389  , // 42   - 2b    - 1879
            49   , // 43   - 2c    - 224
            280  , // 44   - 2d    - 1361
            384  , // 45   - 2e    - 1851
            523  , // 46   - 2f    - 2501
            731  , // 47   - 30    - 3541
            777  , // 48   - 31    - 3739
            769  , // 49   - 32    - 3708
            810  , // 50   - 33    - 3953
            825  , // 51   - 34    - 4020
            862  , // 52   - 35    - 4277
            4    , // 53   - 36    - 17
            425  , // 54   - 37    - 2062
            297  , // 55   - 38    - 1439
            379  , // 56   - 39    - 1832
            543  , // 57   - 3a    - 2598
            670  , // 58   - 3b    - 3194
            352  , // 59   - 3c    - 1705
            831  , // 60   - 3d    - 4045
            539  , // 61   - 3e    - 2581
            440  , // 62   - 3f    - 2133
            476  , // 63   - 40    - 2306
            738  , // 64   - 41    - 3570
            767  , // 65   - 42    - 3701
            798  , // 66   - 43    - 3859
            779  , // 67   - 44    - 3746
            71   , // 68   - 45    - 336
            599  , // 69   - 46    - 2830
            364  , // 70   - 47    - 1754
            594  , // 71   - 48    - 2811
            747  , // 72   - 49    - 3610
            752  , // 73   - 4a    - 3632
            450  , // 74   - 4b    - 2172
            525  , // 75   - 4c    - 2508
            43   , // 76   - 4d    - 199
            537  , // 77   - 4e    - 2574
            657  , // 78   - 4f    - 3124
            527  , // 79   - 50    - 2515
            74   , // 80   - 51    - 348
            107  , // 81   - 52    - 516
            448  , // 82   - 53    - 2165
            493  , // 83   - 54    - 2375
            547  , // 84   - 55    - 2614
            356  , // 85   - 56    - 1719
            455  , // 86   - 57    - 2191
            533  , // 87   - 58    - 2556
            665  , // 88   - 59    - 3158
            745  , // 89   - 5a    - 3601
            685  , // 90   - 5b    - 3277
            98   , // 91   - 5c    - 473
            408  , // 92   - 5d    - 1953
            11   , // 93   - 5e    - 45
            783  , // 94   - 5f    - 3762
            459  , // 95   - 60    - 2207
            561  , // 96   - 61    - 2673
            350  , // 97   - 62    - 1698
            611  , // 98   - 63    - 2890
            295  , // 99   - 64    - 1430
            129  , // 100  - 65    - 620
            66   , // 101  - 66    - 308
            286  , // 102  - 67    - 1384
            370  , // 103  - 68    - 1777
            394  , // 104  - 69    - 1899
            833  , // 105  - 6a    - 4053
            633  , // 106  - 6b    - 3020
            583  , // 107  - 6c    - 2765
            54   , // 108  - 6d    - 260
            482  , // 109  - 6e    - 2330
            444  , // 110  - 6f    - 2149
            398  , // 111  - 70    - 1915
            457  , // 112  - 71    - 2200
            591  , // 113  - 72    - 2799
            762  , // 114  - 73    - 3680
            358  , // 115  - 74    - 1726
            375  , // 116  - 75    - 1816
            478  , // 117  - 76    - 2313
            704  , // 118  - 77    - 3365
            400  , // 119  - 78    - 1922
            603  , // 120  - 79    - 2854
            41   , // 121  - 7a    - 190
            535  , // 122  - 7c    - 2565
            77   , // 123  - 7e    - 360
            791  , // 124  - 80    - 3833
            521  , // 125  - 81    - 2494
            589  , // 126  - 82    - 2792
            101  , // 127  - 83    - 495
            360  , // 128  - 84    - 1733
            659  , // 129  - 85    - 3131
            630  , // 130  - 86    - 2998
            653  , // 131  - 87    - 3108
            822  , // 132  - 88    - 4002
            609  , // 133  - 8c    - 2881
            354  , // 134  - 91    - 1712
            470  , // 135  - 92    - 2270
            33   , // 136  - 401   - 150
            65   , // 137  - 402   - 303
            90   , // 138  - 403   - 428
            859  , // 139  - 404   - 4248
            104  , // 140  - 405   - 504
            110  , // 141  - 406   - 525
            118  , // 142  - 407   - 561
            142  , // 143  - 408   - 671
            240  , // 144  - 409   - 1161
            263  , // 145  - 40a   - 1272
            294  , // 146  - 40b   - 1425
            316  , // 147  - 40c   - 1529
            378  , // 148  - 40d   - 1827
            387  , // 149  - 40e   - 1862
            403  , // 150  - 40f   - 1931
            406  , // 151  - 410   - 1943
            414  , // 152  - 411   - 1991
            454  , // 153  - 412   - 2186
            569  , // 154  - 413   - 2707
            554  , // 155  - 414   - 2641
            606  , // 156  - 415   - 2866
            615  , // 157  - 416   - 2904
            638  , // 158  - 417   - 3043
            643  , // 159  - 418   - 3062
            651  , // 160  - 419   - 3098
            383  , // 161  - 41a   - 1846
            688  , // 162  - 41b   - 3286
            710  , // 163  - 41c   - 3389
            737  , // 164  - 41d   - 3565
            761  , // 165  - 41e   - 3675
            776  , // 166  - 41f   - 3734
            797  , // 167  - 420   - 3854
            397  , // 168  - 421   - 1910
            794  , // 169  - 422   - 3842
            59   , // 170  - 423   - 278
            690  , // 171  - 424   - 3293
            279  , // 172  - 425   - 1356
            507  , // 173  - 426   - 2431
            499  , // 174  - 427   - 2399
            759  , // 175  - 428   - 3663
            285  , // 176  - 429   - 1379
            813  , // 177  - 42a   - 3962
            390  , // 178  - 42b   - 1881
            53   , // 179  - 42c   - 250
            281  , // 180  - 42d   - 1363
            385  , // 181  - 42e   - 1854
            524  , // 182  - 42f   - 2503
            733  , // 183  - 430   - 3548
            778  , // 184  - 431   - 3741
            771  , // 185  - 432   - 3715
            811  , // 186  - 433   - 3955
            826  , // 187  - 434   - 4022
            863  , // 188  - 435   - 4279
            6    , // 189  - 436   - 24
            426  , // 190  - 437   - 2064
            299  , // 191  - 438   - 1446
            380  , // 192  - 439   - 1834
            544  , // 193  - 43a   - 2600
            672  , // 194  - 43b   - 3201
            832  , // 195  - 43d   - 4047
            541  , // 196  - 43e   - 2588
            441  , // 197  - 43f   - 2135
            477  , // 198  - 440   - 2308
            740  , // 199  - 441   - 3577
            768  , // 200  - 442   - 3703
            804  , // 201  - 443   - 3902
            780  , // 202  - 444   - 3748
            73   , // 203  - 445   - 343
            602  , // 204  - 446   - 2849
            365  , // 205  - 447   - 1756
            595  , // 206  - 448   - 2813
            748  , // 207  - 449   - 3612
            753  , // 208  - 44a   - 3634
            451  , // 209  - 44b   - 2174
            526  , // 210  - 44c   - 2510
            44   , // 211  - 44d   - 201
            538  , // 212  - 44e   - 2576
            658  , // 213  - 44f   - 3126
            529  , // 214  - 450   - 2524
            75   , // 215  - 451   - 350
            108  , // 216  - 452   - 518
            449  , // 217  - 453   - 2167
            494  , // 218  - 454   - 2377
            548  , // 219  - 455   - 2616
            357  , // 220  - 456   - 1721
            456  , // 221  - 457   - 2194
            534  , // 222  - 458   - 2559
            669  , // 223  - 459   - 3184
            746  , // 224  - 45a   - 3604
            686  , // 225  - 45b   - 3279
            100  , // 226  - 45c   - 484
            410  , // 227  - 45d   - 1962
            12   , // 228  - 45e   - 47
            785  , // 229  - 45f   - 3773
            460  , // 230  - 460   - 2209
            563  , // 231  - 461   - 2680
            351  , // 232  - 462   - 1700
            612  , // 233  - 463   - 2892
            296  , // 234  - 464   - 1433
            130  , // 235  - 465   - 622
            67   , // 236  - 466   - 311
            292  , // 237  - 467   - 1418
            374  , // 238  - 468   - 1806
            395  , // 239  - 469   - 1902
            835  , // 240  - 46a   - 4060
            634  , // 241  - 46b   - 3023
            584  , // 242  - 46c   - 2768
            55   , // 243  - 46d   - 262
            483  , // 244  - 46e   - 2332
            445  , // 245  - 46f   - 2151
            399  , // 246  - 470   - 1917
            458  , // 247  - 471   - 2202
            592  , // 248  - 472   - 2801
            764  , // 249  - 473   - 3687
            359  , // 250  - 474   - 1728
            376  , // 251  - 475   - 1819
            479  , // 252  - 476   - 2315
            708  , // 253  - 477   - 3382
            401  , // 254  - 478   - 1924
            604  , // 255  - 479   - 2857
            42   , // 256  - 47a   - 193
            536  , // 257  - 47c   - 2568
            78   , // 258  - 47e   - 362
            792  , // 259  - 480   - 3835
            522  , // 260  - 481   - 2496
            590  , // 261  - 482   - 2794
            102  , // 262  - 483   - 497
            362  , // 263  - 484   - 1742
            660  , // 264  - 485   - 3134
            632  , // 265  - 486   - 3009
            654  , // 266  - 487   - 3110
            823  , // 267  - 488   - 4004
            610  , // 268  - 48c   - 2884
            355  , // 269  - 491   - 1714
            472  , // 270  - 492   - 2279
            627  , // 271  - 501   - 2972
            628  , // 272  - 5fe   - 2980
            22   , // 273  - 801   - 95
            91   , // 274  - 803   - 433
            844  , // 275  - 804   - 4110
            117  , // 276  - 807   - 556
            174  , // 277  - 809   - 831
            267  , // 278  - 80a   - 1299
            302  , // 279  - 80c   - 1459
            405  , // 280  - 810   - 1938
            566  , // 281  - 813   - 2692
            575  , // 282  - 814   - 2733
            623  , // 283  - 816   - 2944
            642  , // 284  - 818   - 3057
            650  , // 285  - 819   - 3093
            722  , // 286  - 81a   - 3480
            736  , // 287  - 81d   - 3560
            796  , // 288  - 820   - 3849
            51   , // 289  - 82c   - 233
            126  , // 290  - 82e   - 605
            770  , // 291  - 832   - 3710
            673  , // 292  - 83b   - 3206
            353  , // 293  - 83c   - 1707
            540  , // 294  - 83e   - 2583
            802  , // 295  - 843   - 3885
            72   , // 296  - 845   - 338
            601  , // 297  - 846   - 2839
            749  , // 298  - 849   - 3617
            531  , // 299  - 850   - 2536
            667  , // 300  - 859   - 3167
            412  , // 301  - 85d   - 1979
            787  , // 302  - 85f   - 3792
            463  , // 303  - 860   - 2233
            562  , // 304  - 861   - 2675
            290  , // 305  - 867   - 1403
            635  , // 306  - 86b   - 3029
            763  , // 307  - 873   - 3682
            626  , // 308  - 901   - 2959
            629  , // 309  - 9ff   - 2989
            19   , // 310  - c01   - 80
            851  , // 311  - c04   - 4173
            115  , // 312  - c07   - 546
            151  , // 313  - c09   - 716
            262  , // 314  - c0a   - 1267
            307  , // 315  - c0c   - 1484
            716  , // 316  - c1a   - 3423
            671  , // 317  - c3b   - 3196
            532  , // 318  - c50   - 2546
            134  , // 319  - c51   - 638
            636  , // 320  - c6b   - 3035
            27   , // 321  - 1001  - 120
            856  , // 322  - 1004  - 4219
            122  , // 323  - 1007  - 588
            159  , // 324  - 1009  - 756
            265  , // 325  - 100a  - 1289
            311  , // 326  - 100c  - 1504
            382  , // 327  - 101a  - 1841
            695  , // 328  - 103b  - 3316
            790  , // 329  - 105f  - 3822
            18   , // 330  - 1401  - 75
            853  , // 331  - 1404  - 4190
            121  , // 332  - 1407  - 583
            213  , // 333  - 1409  - 1026
            258  , // 334  - 140a  - 1247
            324  , // 335  - 140c  - 1569
            85   , // 336  - 141a  - 402
            696  , // 337  - 143b  - 3322
            28   , // 338  - 1801  - 125
            184  , // 339  - 1809  - 881
            269  , // 340  - 180a  - 1309
            326  , // 341  - 180c  - 1579
            721  , // 342  - 181a  - 3470
            692  , // 343  - 183b  - 3301
            39   , // 344  - 1c01  - 180
            246  , // 345  - 1c09  - 1191
            260  , // 346  - 1c0a  - 1257
            301  , // 347  - 1c0c  - 1453
            715  , // 348  - 1c1a  - 3413
            693  , // 349  - 1c3b  - 3307
            30   , // 350  - 2001  - 135
            190  , // 351  - 2009  - 911
            277  , // 352  - 200a  - 1349
            337  , // 353  - 200c  - 1634
            83   , // 354  - 201a  - 385
            700  , // 355  - 203b  - 3340
            40   , // 356  - 2401  - 185
            145  , // 357  - 2409  - 684
            257  , // 358  - 240a  - 1242
            308  , // 359  - 240c  - 1489
            724  , // 360  - 241a  - 3500
            698  , // 361  - 243b  - 3331
            37   , // 362  - 2801  - 170
            158  , // 363  - 2809  - 751
            270  , // 364  - 280a  - 1314
            340  , // 365  - 280c  - 1649
            718  , // 366  - 281a  - 3443
            23   , // 367  - 2c01  - 100
            235  , // 368  - 2c09  - 1136
            253  , // 369  - 2c0a  - 1222
            313  , // 370  - 2c0c  - 1514
            723  , // 371  - 2c1a  - 3490
            26   , // 372  - 3001  - 115
            248  , // 373  - 3009  - 1201
            261  , // 374  - 300a  - 1262
            312  , // 375  - 300c  - 1509
            717  , // 376  - 301a  - 3433
            25   , // 377  - 3401  - 110
            215  , // 378  - 3409  - 1036
            256  , // 379  - 340a  - 1237
            329  , // 380  - 340c  - 1594
            15   , // 381  - 3801  - 60
            183  , // 382  - 3809  - 876
            276  , // 383  - 380a  - 1344
            325  , // 384  - 380c  - 1574
            16   , // 385  - 3c01  - 65
            182  , // 386  - 3c09  - 871
            273  , // 387  - 3c0a  - 1329
            322  , // 388  - 3c0c  - 1559
            32   , // 389  - 4001  - 145
            187  , // 390  - 4009  - 896
            254  , // 391  - 400a  - 1227
            206  , // 392  - 4409  - 991
            274  , // 393  - 440a  - 1334
            225  , // 394  - 4809  - 1086
            266  , // 395  - 480a  - 1294
            268  , // 396  - 4c0a  - 1304
            272  , // 397  - 500a  - 1324
            275  , // 398  - 540a  - 1339
            252  , // 399  - 580a  - 1216
            259  , // 400  - 5c0a  - 1252
            82   , // 401  - 641a  - 378
            84   , // 402  - 681a  - 395
            714  , // 403  - 6c1a  - 3406
            720  , // 404  - 701a  - 3463
            697  , // 405  - 703b  - 3328
            50   , // 406  - 742c  - 226
            699  , // 407  - 743b  - 3337
            841  , // 408  - 7804  - 4096
            574  , // 409  - 7814  - 2731
            81   , // 410  - 781a  - 376
            52   , // 411  - 782c  - 243
            691  , // 412  - 783b  - 3298
            801  , // 413  - 7843  - 3878
            528  , // 414  - 7850  - 2517
            409  , // 415  - 785d  - 1955
            789  , // 416  - 785f  - 3814
            850  , // 417  - 7c04  - 4166
            553  , // 418  - 7c14  - 2639
            713  , // 419  - 7c1a  - 3404
            758  , // 420  - 7c28  - 3656
            125  , // 421  - 7c2e  - 602
            694  , // 422  - 7c3b  - 3313
            803  , // 423  - 7c43  - 3895
            600  , // 424  - 7c46  - 2832
            530  , // 425  - 7c50  - 2529
            666  , // 426  - 7c59  - 3160
            99   , // 427  - 7c5c  - 476
            411  , // 428  - 7c5d  - 1972
            786  , // 429  - 7c5f  - 3784
            289  , // 430  - 7c67  - 1396
            371  , // 431  - 7c68  - 1779
            631  , // 432  - 7c86  - 3001
            471  , // 433  - 7c92  - 2272
            824  , // 434  - 1007f - 4009
            119  , // 435  - 10407 - 566
            388  , // 436  - 1040e - 1867
            427  , // 437  - 10437 - 2069
            846  , // 438  - 20804 - 4127
            858  , // 439  - 21004 - 4236
            855  , // 440  - 21404 - 4207
            860  , // 441  - 30404 - 4253
            861  , // 442  - 40404 - 4265
            415  , // 443  - 40411 - 1996
            852  , // 444  - 40c04 - 4178
            854  , // 445  - 41404 - 4195
            845  , // 446  - 50804 - 4115
            857    // 447  - 51004 - 4224
        };

        internal static string? LCIDToLocaleName(int culture)
        {
            int left = 0;
            int right = s_lcids.Length - 1;
            int index;

            Debug.Assert(s_lcids.Length == s_lcidToCultureNameIndices.Length);

            while (left <= right)
            {
                index = (right + left) / 2;

                if (culture == s_lcids[index])
                {
                    int indexToLocaleNamesIndices = s_lcidToCultureNameIndices[index];
                    Debug.Assert(indexToLocaleNamesIndices < s_localeNamesIndices.Length - 1);

                    return c_localeNames.Substring(s_localeNamesIndices[indexToLocaleNamesIndices],
                                                                         s_localeNamesIndices[indexToLocaleNamesIndices + 1] -
                                                                         s_localeNamesIndices[indexToLocaleNamesIndices]);
                }
                else if (culture < s_lcids[index])
                {
                    right = index - 1;
                }
                else
                {
                    left = index + 1;
                }
            }

            return null;
        }

        internal static int GetLocaleDataNumericPart(string cultureName, IcuLocaleDataParts part)
        {
            int index = SearchCultureName(cultureName);
            if (index < 0)
            {
                return -1;
            }

            Debug.Assert((s_localeNamesIndices.Length-1 == (s_nameIndexToNumericData.Length/NUMERIC_LOCALE_DATA_COUNT_PER_ROW)) &&
                            index < s_localeNamesIndices.Length);

            return s_nameIndexToNumericData[index * NUMERIC_LOCALE_DATA_COUNT_PER_ROW + (int) part];
        }

        internal static string? GetThreeLetterWindowsLanguageName(string cultureName)
        {
            int index = SearchCultureName(cultureName);
            if (index < 0)
            {
                return null;
            }

            Debug.Assert(s_localeNamesIndices.Length-1 == (c_threeLetterWindowsLanguageName.Length / 3));
            return c_threeLetterWindowsLanguageName.Substring(index * 3, 3);
        }

        internal static string GetLocaleDataMappedCulture(string cultureName, IcuLocaleDataParts part)
        {
            int indexToIndicesTable = GetLocaleDataNumericPart(cultureName, part);
            if (indexToIndicesTable < 0)
            {
                return ""; // fallback to invariant
            }

            Debug.Assert(indexToIndicesTable < s_localeNamesIndices.Length-1);

            return c_localeNames.Substring(s_localeNamesIndices[indexToIndicesTable],
                                           s_localeNamesIndices[indexToIndicesTable+1] - s_localeNamesIndices[indexToIndicesTable]);
        }

        internal static string GetSpecificCultureName(string cultureName)
        {
            return GetLocaleDataMappedCulture(cultureName, IcuLocaleDataParts.SpecificLocaleIndex);
        }

        internal static string GetConsoleUICulture(string cultureName)
        {
            return GetLocaleDataMappedCulture(cultureName, IcuLocaleDataParts.ConsoleLocaleIndex);
        }

        // SearchCultureName will binary search c_localeNames using s_localeNamesIndices.
        // return index in s_localeNamesIndices, or -1 if it fail finding any match
        private static int SearchCultureName(string name)
        {
            int left = 0;
            int right = s_localeNamesIndices.Length - 2;
            int index;
            int result;

            Debug.Assert(s_localeNamesIndices[s_localeNamesIndices.Length - 1] == c_localeNames.Length);

            name = CultureData.AnsiToLower(name);

            // Binary search the array until we have only a couple of elements left and then
            // just walk those elements.
            while ((right - left) > 3)
            {
                index = ((right - left) / 2) + left;

                Debug.Assert(index < s_localeNamesIndices.Length - 1);
                result = CompareOrdinal(name, c_localeNames, s_localeNamesIndices[index], s_localeNamesIndices[index + 1] - s_localeNamesIndices[index]);
                if (result == 0)
                {
                    return index;
                }
                else if (result < 0)
                {
                    right = index;
                }
                else
                {
                    left = index;
                }
            }

            // Walk the remaining elements (it'll be 3 or fewer).
            for (; left <= right; left++)
            {
                Debug.Assert(left < s_localeNamesIndices.Length - 1);
                if (CompareOrdinal(name, c_localeNames, s_localeNamesIndices[left], s_localeNamesIndices[left + 1] - s_localeNamesIndices[left]) == 0)
                {
                    return (left);
                }
            }

            // couldn't find culture name
            return -1;
        }

        // optimized to avoid parameters checking
        private static int CompareOrdinal(string s1, string s2, int index, int length)
        {
            int count = s1.Length;
            if (count > length)
                count = length;

            int i = 0;
            while (i < count && s1[i] == s2[index + i])
                i++;

            if (i < count)
                return (int)(s1[i] - s2[index + i]);

            return s1.Length - length;
        }
    }
}
