﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Diagnostics.CodeAnalysis
{
	/// <summary>
	/// Specifies the types of members that are dynamically accessed.
	///
	/// This enumeration has a <see cref="FlagsAttribute"/> attribute that allows a
	/// bitwise combination of its member values.
	/// </summary>
	/// <remarks>
	/// This is a copy of the enum definition in the framework at https://github.com/dotnet/runtime/blob/master/src/libraries/System.Private.CoreLib/src/System/Diagnostics/CodeAnalysis/DynamicallyAccessedMemberTypes.cs
	/// </remarks>
	[Flags]
	internal enum DynamicallyAccessedMemberTypes
	{
		/// <summary>
		/// Specifies no members.
		/// </summary>
		None = 0,

		/// <summary>
		/// Specifies the default, parameterless public constructor.
		/// </summary>
		PublicParameterlessConstructor = 0x0001,

		/// <summary>
		/// Specifies all public constructors.
		/// </summary>
		PublicConstructors = 0x0002 | PublicParameterlessConstructor,

		/// <summary>
		/// Specifies all non-public constructors.
		/// </summary>
		NonPublicConstructors = 0x0004,

		/// <summary>
		/// Specifies all public methods.
		/// </summary>
		PublicMethods = 0x0008,

		/// <summary>
		/// Specifies all non-public methods.
		/// </summary>
		NonPublicMethods = 0x0010,

		/// <summary>
		/// Specifies all public fields.
		/// </summary>
		PublicFields = 0x0020,

		/// <summary>
		/// Specifies all non-public fields.
		/// </summary>
		NonPublicFields = 0x0040,

		/// <summary>
		/// Specifies all public nested types.
		/// </summary>
		PublicNestedTypes = 0x0080,

		/// <summary>
		/// Specifies all non-public nested types.
		/// </summary>
		NonPublicNestedTypes = 0x0100,

		/// <summary>
		/// Specifies all public properties.
		/// </summary>
		PublicProperties = 0x0200,

		/// <summary>
		/// Specifies all non-public properties.
		/// </summary>
		NonPublicProperties = 0x0400,

		/// <summary>
		/// Specifies all public events.
		/// </summary>
		PublicEvents = 0x0800,

		/// <summary>
		/// Specifies all non-public events.
		/// </summary>
		NonPublicEvents = 0x1000,

		/// <summary>
		/// Specifies all members.
		/// </summary>
		All = ~None
	}
}
