ASP.NET Core Identity
=====================

ASP.NET Core Identity is the membership system for building ASP.NET Core web applications, including membership, login, and user data. ASP.NET Core Identity allows you to add login features to your application and makes it easy to customize data about the logged in user.

## ASP.NET Identity for ASP.NET MVC 5

The previous versions of Identity for MVC5 and lower, previously available on CodePlex, are available at https://github.com/aspnet/AspNetIdentity

## Community Maintained Store Providers

**IMPORTANT: Extensions are built by a variety of sources and not maintained as part of the ASP.NET Identity project. When considering a third party provider, be sure to evaluate quality, licensing, compatibility, support, etc. to ensure they meet your requirements.**

* [ASP.NET Identity Azure Table Storage Provider](https://dlmelendez.github.io/identityazuretable/)
* [ASP.NET Identity CosmosDB SQL Provider](https://github.com/dlmelendez/identitycosmosdb)
* ASP.NET Identity MongoDB Providers:
  * [By Tugberk Ugurlu](https://github.com/tugberkugurlu/AspNetCore.Identity.MongoDB)
  * [By Alexandre Spieser](https://github.com/alexandre-spieser/AspNetCore.Identity.MongoDbCore)
 * [ASP.NET Identity LinqToDB Provider](https://github.com/ili/LinqToDB.Identity)
 * [ASP.NET Identity DynamoDB Provider](https://github.com/miltador/AspNetCore.Identity.DynamoDB)
 * ASP.NET Identity RavenDB Providers:
    * [By Judah Gabriel Himango](https://github.com/JudahGabriel/RavenDB.Identity)
    * [By Iskandar Rafiev](https://github.com/maqduni/AspNetCore.Identity.RavenDB)
 * [ASP.NET Identity Cassandra Provider](https://github.com/lkubis/AspNetCore.Identity.Cassandra)
 * [ASP.NET Identity Firebase Provider](https://github.com/aguacongas/Identity.Firebase)
 * [ASP.NET Identity Redis Provider](https://github.com/aguacongas/Identity.Redis)
 * [ASP.NET Identity DocumentDB](https://github.com/codekoenig/AspNetCore.Identity.DocumentDb)
 * [ASP.NET Identity Amazon Cognito Provider](https://github.com/aws/aws-aspnet-cognito-identity-provider)
 * [ASP.NET Identity Marten Provider](https://github.com/yetanotherchris/Marten.AspNetIdentity)
