// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Reflection.Emit
{
    public struct StringToken
    {
        internal StringToken(int str)
        {
            Token = str;
        }

        // Returns the metadata token for this particular string.
        // Generated by a call to Module.GetStringConstant().
        //
        public int Token { get; }

        public override int GetHashCode() => Token;

        public override bool Equals(object? obj) => obj is StringToken st && Equals(st);

        public bool Equals(StringToken obj) => obj.Token == Token;

        public static bool operator ==(StringToken a, StringToken b) => a.Equals(b);

        public static bool operator !=(StringToken a, StringToken b) => !(a == b);
    }
}
