# General Resources
 * [MSBuild Concepts](https://msdn.microsoft.com/en-us/library/dd637714.aspx)
 * [MSBuild Reserved and Well-Known Properties](https://msdn.microsoft.com/en-us/library/ms164309.aspx)
 * [MSBuild Tips & Tricks](MSBuild-Tips-&-Tricks.md)
 * [Target Maps](Target-Maps.md)

# MSBuild Source Code
 * [https://github.com/Microsoft/MSBuild](https://github.com/Microsoft/MSBuild)
 * [https://source.dot.net](https://source.dot.net)
 * Use [http://referencesource.microsoft.com](http://referencesource.microsoft.com) or [http://source.roslyn.io](http://source.roslyn.io) to browse Microsoft MSBuild targets. Examples:
   * search for "[_FindDependencies MSBuildProperty](http://referencesource.microsoft.com/#q=_FindDependencies%20MSBuildProperty)"
   * find targets [http://referencesource.microsoft.com/#MSBuildTarget=ResolveAssemblyReferences](http://referencesource.microsoft.com/#MSBuildTarget=ResolveAssemblyReferences)

# Tools
**Note:** These are third party tools
 * [MSBuildStructuredLog](http://msbuildlog.com/)
   * A log viewer that displays a structured representation of executed targets, tasks, property and item values.
 * [MSBuildExtensionPack](http://www.msbuildextensionpack.com)
   * Provides a large collection of MSBuild Tasks, MSBuild Loggers and MSBuild TaskFactories.
 * [MSBuilder](https://github.com/MobileEssentials/MSBuilder)
   * Reusable blocks of MSBuild helpers; MSBuilder's goal is to provide fine-grained nuget packages that can be installed when only a certain MSBuild extension (task, property, target) is needed.
 * [MSBuildExplorer](http://msbuildexplorer.com) ([GitHub](https://github.com/mikefourie/MSBuildExplorer))
   * Use MSBuild Explorer to help you find your way around the make-up of your build file(s).
 * [MSBuild Sidekick](http://attrice.info/msbuild)
   * MSBuild Sidekick allows you to view, edit, build and debug Visual Studio projects and solution files as well as custom MSBuild projects.
 * [MSBuildDumper](https://github.com/KirillOsenkov/MSBuildTools)
     * Very quick tool to dump properties and items of a project without building it.
     * Install from Chocolatey `cinst MSBuildDumper`.
 * [MSBuild Profiler](https://msbuildprofiler.codeplex.com/)
   * A performance measurement tool for MSBuild scripts. MSBuild Profiler shows a graphical performance output for all your MSBuild scripts.
 * [MsBuildPipeLogger](https://msbuildpipelogger.netlify.com/) ([GitHub](https://github.com/daveaglick/MsBuildPipeLogger))
   * A logger for MSBuild that sends event data over anonymous or named pipes.
 * [MSBuild Shell Extension](https://msbuildshellex.codeplex.com/) Note: Not supported on Windows 10.
   * Lets you build Visual Studio solutions and projects as well as any MSBuild file through a context menu without opening Visual Studio.

# Books
 * [Inside the Microsoft Build Engine: Using MSBuild and Team Foundation Build (2nd Edition) by Sayed Hashimi, William Bartholomew](http://www.amazon.com/Inside-Microsoft-Build-Engine-Foundation/dp/0735645248)
 * [MSBuild Trickery: 99 Ways to Bend the Build Engine to Your Will, by Brian Kretzler](http://www.amazon.com/MSBuild-Trickery-Ways-Build-Engine/dp/061550907X)

# Blogs
 * [https://blogs.msdn.microsoft.com/msbuild](https://blogs.msdn.microsoft.com/msbuild)
 * [Sayed Hashimi's blog http://sedodream.com](http://sedodream.com)
 * [Mike Fourie's blog https://mikefourie.wordpress.com](https://mikefourie.wordpress.com)

# MSBuild Assemblies
![MSBuild Assemblies](https://raw.githubusercontent.com/KirillOsenkov/MSBuildStructuredLog/master/docs/MSBuildAssemblies.png)
