# System.Data.OleDb

``` diff
+namespace System.Data.OleDb {
+    public sealed class OleDbCommand : DbCommand, ICloneable, IDbCommand, IDisposable {
+        public OleDbCommand();
+        public OleDbCommand(string cmdText);
+        public OleDbCommand(string cmdText, OleDbConnection connection);
+        public OleDbCommand(string cmdText, OleDbConnection connection, OleDbTransaction transaction);
+        public override string CommandText { get; set; }
+        public override int CommandTimeout { get; set; }
+        public override CommandType CommandType { get; set; }
+        public new OleDbConnection Connection { get; set; }
+        protected override DbConnection DbConnection { get; set; }
+        protected override DbParameterCollection DbParameterCollection { get; }
+        protected override DbTransaction DbTransaction { get; set; }
+        public override bool DesignTimeVisible { get; set; }
+        public new OleDbParameterCollection Parameters { get; }
+        public new OleDbTransaction Transaction { get; set; }
+        public override UpdateRowSource UpdatedRowSource { get; set; }
+        public override void Cancel();
+        public OleDbCommand Clone();
+        protected override DbParameter CreateDbParameter();
+        public new OleDbParameter CreateParameter();
+        protected override void Dispose(bool disposing);
+        protected override DbDataReader ExecuteDbDataReader(CommandBehavior behavior);
+        public override int ExecuteNonQuery();
+        public new OleDbDataReader ExecuteReader();
+        public new OleDbDataReader ExecuteReader(CommandBehavior behavior);
+        public override object ExecuteScalar();
+        public override void Prepare();
+        public void ResetCommandTimeout();
+        IDataReader System.Data.IDbCommand.ExecuteReader();
+        IDataReader System.Data.IDbCommand.ExecuteReader(CommandBehavior behavior);
+        object System.ICloneable.Clone();
+    }
+    public sealed class OleDbCommandBuilder : DbCommandBuilder {
+        public OleDbCommandBuilder();
+        public OleDbCommandBuilder(OleDbDataAdapter adapter);
+        public new OleDbDataAdapter DataAdapter { get; set; }
+        protected override void ApplyParameterInfo(DbParameter parameter, DataRow datarow, StatementType statementType, bool whereClause);
+        public static void DeriveParameters(OleDbCommand command);
+        public new OleDbCommand GetDeleteCommand();
+        public new OleDbCommand GetDeleteCommand(bool useColumnsForParameterNames);
+        public new OleDbCommand GetInsertCommand();
+        public new OleDbCommand GetInsertCommand(bool useColumnsForParameterNames);
+        protected override string GetParameterName(int parameterOrdinal);
+        protected override string GetParameterName(string parameterName);
+        protected override string GetParameterPlaceholder(int parameterOrdinal);
+        public new OleDbCommand GetUpdateCommand();
+        public new OleDbCommand GetUpdateCommand(bool useColumnsForParameterNames);
+        public override string QuoteIdentifier(string unquotedIdentifier);
+        public string QuoteIdentifier(string unquotedIdentifier, OleDbConnection connection);
+        protected override void SetRowUpdatingHandler(DbDataAdapter adapter);
+        public override string UnquoteIdentifier(string quotedIdentifier);
+        public string UnquoteIdentifier(string quotedIdentifier, OleDbConnection connection);
+    }
+    public sealed class OleDbConnection : DbConnection, ICloneable, IDbConnection, IDisposable {
+        public OleDbConnection();
+        public OleDbConnection(string connectionString);
+        public override string ConnectionString { get; set; }
+        public override int ConnectionTimeout { get; }
+        public override string Database { get; }
+        public override string DataSource { get; }
+        public string Provider { get; }
+        public override string ServerVersion { get; }
+        public override ConnectionState State { get; }
+        public event OleDbInfoMessageEventHandler InfoMessage;
+        protected override DbTransaction BeginDbTransaction(IsolationLevel isolationLevel);
+        public new OleDbTransaction BeginTransaction();
+        public new OleDbTransaction BeginTransaction(IsolationLevel isolationLevel);
+        public override void ChangeDatabase(string value);
+        public override void Close();
+        public new OleDbCommand CreateCommand();
+        protected override DbCommand CreateDbCommand();
+        protected override void Dispose(bool disposing);
+        public void EnlistDistributedTransaction(ITransaction transaction);
+        public override void EnlistTransaction(Transaction transaction);
+        public DataTable GetOleDbSchemaTable(Guid schema, object[] restrictions);
+        public override DataTable GetSchema();
+        public override DataTable GetSchema(string collectionName);
+        public override DataTable GetSchema(string collectionName, string[] restrictionValues);
+        public override void Open();
+        public static void ReleaseObjectPool();
+        public void ResetState();
+        object System.ICloneable.Clone();
+    }
+    public sealed class OleDbConnectionStringBuilder : DbConnectionStringBuilder {
+        public OleDbConnectionStringBuilder();
+        public OleDbConnectionStringBuilder(string connectionString);
+        public string DataSource { get; set; }
+        public string FileName { get; set; }
+        public override ICollection Keys { get; }
+        public int OleDbServices { get; set; }
+        public bool PersistSecurityInfo { get; set; }
+        public string Provider { get; set; }
+        public override object this[string keyword] { get; set; }
+        public override void Clear();
+        public override bool ContainsKey(string keyword);
+        protected override void GetProperties(Hashtable propertyDescriptors);
+        public override bool Remove(string keyword);
+        public override bool TryGetValue(string keyword, out object value);
+    }
+    public sealed class OleDbDataAdapter : DbDataAdapter, ICloneable, IDataAdapter, IDbDataAdapter {
+        public OleDbDataAdapter();
+        public OleDbDataAdapter(OleDbCommand selectCommand);
+        public OleDbDataAdapter(string selectCommandText, OleDbConnection selectConnection);
+        public OleDbDataAdapter(string selectCommandText, string selectConnectionString);
+        public new OleDbCommand DeleteCommand { get; set; }
+        public new OleDbCommand InsertCommand { get; set; }
+        public new OleDbCommand SelectCommand { get; set; }
+        IDbCommand System.Data.IDbDataAdapter.DeleteCommand { get; set; }
+        IDbCommand System.Data.IDbDataAdapter.InsertCommand { get; set; }
+        IDbCommand System.Data.IDbDataAdapter.SelectCommand { get; set; }
+        IDbCommand System.Data.IDbDataAdapter.UpdateCommand { get; set; }
+        public new OleDbCommand UpdateCommand { get; set; }
+        public event OleDbRowUpdatedEventHandler RowUpdated;
+        public event OleDbRowUpdatingEventHandler RowUpdating;
+        protected override RowUpdatedEventArgs CreateRowUpdatedEvent(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        protected override RowUpdatingEventArgs CreateRowUpdatingEvent(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        public int Fill(DataSet dataSet, object ADODBRecordSet, string srcTable);
+        public int Fill(DataTable dataTable, object ADODBRecordSet);
+        protected override void OnRowUpdated(RowUpdatedEventArgs value);
+        protected override void OnRowUpdating(RowUpdatingEventArgs value);
+        object System.ICloneable.Clone();
+    }
+    public sealed class OleDbDataReader : DbDataReader {
+        public override int Depth { get; }
+        public override int FieldCount { get; }
+        public override bool HasRows { get; }
+        public override bool IsClosed { get; }
+        public override int RecordsAffected { get; }
+        public override object this[int index] { get; }
+        public override object this[string name] { get; }
+        public override int VisibleFieldCount { get; }
+        public override void Close();
+        public override bool GetBoolean(int ordinal);
+        public override byte GetByte(int ordinal);
+        public override long GetBytes(int ordinal, long dataIndex, byte[] buffer, int bufferIndex, int length);
+        public override char GetChar(int ordinal);
+        public override long GetChars(int ordinal, long dataIndex, char[] buffer, int bufferIndex, int length);
+        public new OleDbDataReader GetData(int ordinal);
+        public override string GetDataTypeName(int index);
+        public override DateTime GetDateTime(int ordinal);
+        protected override DbDataReader GetDbDataReader(int ordinal);
+        public override decimal GetDecimal(int ordinal);
+        public override double GetDouble(int ordinal);
+        public override IEnumerator GetEnumerator();
+        public override Type GetFieldType(int index);
+        public override float GetFloat(int ordinal);
+        public override Guid GetGuid(int ordinal);
+        public override short GetInt16(int ordinal);
+        public override int GetInt32(int ordinal);
+        public override long GetInt64(int ordinal);
+        public override string GetName(int index);
+        public override int GetOrdinal(string name);
+        public override DataTable GetSchemaTable();
+        public override string GetString(int ordinal);
+        public TimeSpan GetTimeSpan(int ordinal);
+        public override object GetValue(int ordinal);
+        public override int GetValues(object[] values);
+        public override bool IsDBNull(int ordinal);
+        public override bool NextResult();
+        public override bool Read();
+    }
+    public sealed class OleDbEnumerator {
+        public OleDbEnumerator();
+        public DataTable GetElements();
+        public static OleDbDataReader GetEnumerator(Type type);
+        public static OleDbDataReader GetRootEnumerator();
+    }
+    public sealed class OleDbError {
+        public string Message { get; }
+        public int NativeError { get; }
+        public string Source { get; }
+        public string SQLState { get; }
+        public override string ToString();
+    }
+    public sealed class OleDbErrorCollection : ICollection, IEnumerable {
+        public int Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public OleDbError this[int index] { get; }
+        public void CopyTo(Array array, int index);
+        public void CopyTo(OleDbError[] array, int index);
+        public IEnumerator GetEnumerator();
+    }
+    public sealed class OleDbException : DbException {
+        public override int ErrorCode { get; }
+        public OleDbErrorCollection Errors { get; }
+        public override void GetObjectData(SerializationInfo si, StreamingContext context);
+    }
+    public sealed class OleDbFactory : DbProviderFactory {
+        public static readonly OleDbFactory Instance;
+        public override DbCommand CreateCommand();
+        public override DbCommandBuilder CreateCommandBuilder();
+        public override DbConnection CreateConnection();
+        public override DbConnectionStringBuilder CreateConnectionStringBuilder();
+        public override DbDataAdapter CreateDataAdapter();
+        public override DbParameter CreateParameter();
+        public override CodeAccessPermission CreatePermission(PermissionState state);
+    }
+    public sealed class OleDbInfoMessageEventArgs : EventArgs {
+        public int ErrorCode { get; }
+        public OleDbErrorCollection Errors { get; }
+        public string Message { get; }
+        public string Source { get; }
+        public override string ToString();
+    }
+    public delegate void OleDbInfoMessageEventHandler(object sender, OleDbInfoMessageEventArgs e);
+    public enum OleDbLiteral {
+        Binary_Literal = 1,
+        Catalog_Name = 2,
+        Catalog_Separator = 3,
+        Char_Literal = 4,
+        Column_Alias = 5,
+        Column_Name = 6,
+        Correlation_Name = 7,
+        Cube_Name = 21,
+        Cursor_Name = 8,
+        Dimension_Name = 22,
+        Escape_Percent_Prefix = 9,
+        Escape_Percent_Suffix = 29,
+        Escape_Underscore_Prefix = 10,
+        Escape_Underscore_Suffix = 30,
+        Hierarchy_Name = 23,
+        Index_Name = 11,
+        Invalid = 0,
+        Level_Name = 24,
+        Like_Percent = 12,
+        Like_Underscore = 13,
+        Member_Name = 25,
+        Procedure_Name = 14,
+        Property_Name = 26,
+        Quote_Prefix = 15,
+        Quote_Suffix = 28,
+        Schema_Name = 16,
+        Schema_Separator = 27,
+        Table_Name = 17,
+        Text_Command = 18,
+        User_Name = 19,
+        View_Name = 20,
+    }
+    public static class OleDbMetaDataCollectionNames {
+        public static readonly string Catalogs;
+        public static readonly string Collations;
+        public static readonly string Columns;
+        public static readonly string Indexes;
+        public static readonly string ProcedureColumns;
+        public static readonly string ProcedureParameters;
+        public static readonly string Procedures;
+        public static readonly string Tables;
+        public static readonly string Views;
+    }
+    public static class OleDbMetaDataColumnNames {
+        public static readonly string BooleanFalseLiteral;
+        public static readonly string BooleanTrueLiteral;
+        public static readonly string DateTimeDigits;
+        public static readonly string NativeDataType;
+    }
+    public sealed class OleDbParameter : DbParameter, ICloneable, IDataParameter, IDbDataParameter {
+        public OleDbParameter();
+        public OleDbParameter(string name, OleDbType dataType);
+        public OleDbParameter(string name, OleDbType dataType, int size);
+        public OleDbParameter(string parameterName, OleDbType dbType, int size, ParameterDirection direction, bool isNullable, byte precision, byte scale, string srcColumn, DataRowVersion srcVersion, object value);
+        public OleDbParameter(string parameterName, OleDbType dbType, int size, ParameterDirection direction, byte precision, byte scale, string sourceColumn, DataRowVersion sourceVersion, bool sourceColumnNullMapping, object value);
+        public OleDbParameter(string name, OleDbType dataType, int size, string srcColumn);
+        public OleDbParameter(string name, object value);
+        public override DbType DbType { get; set; }
+        public override ParameterDirection Direction { get; set; }
+        public override bool IsNullable { get; set; }
+        public OleDbType OleDbType { get; set; }
+        public override string ParameterName { get; set; }
+        public new byte Precision { get; set; }
+        public new byte Scale { get; set; }
+        public override int Size { get; set; }
+        public override string SourceColumn { get; set; }
+        public override bool SourceColumnNullMapping { get; set; }
+        public override DataRowVersion SourceVersion { get; set; }
+        public override object Value { get; set; }
+        public override void ResetDbType();
+        public void ResetOleDbType();
+        object System.ICloneable.Clone();
+        public override string ToString();
+    }
+    public sealed class OleDbParameterCollection : DbParameterCollection {
+        public override int Count { get; }
+        public override bool IsFixedSize { get; }
+        public override bool IsReadOnly { get; }
+        public override bool IsSynchronized { get; }
+        public override object SyncRoot { get; }
+        public new OleDbParameter this[int index] { get; set; }
+        public new OleDbParameter this[string parameterName] { get; set; }
+        public OleDbParameter Add(OleDbParameter value);
+        public override int Add(object value);
+        public OleDbParameter Add(string parameterName, OleDbType oleDbType);
+        public OleDbParameter Add(string parameterName, OleDbType oleDbType, int size);
+        public OleDbParameter Add(string parameterName, OleDbType oleDbType, int size, string sourceColumn);
+        public OleDbParameter Add(string parameterName, object value);
+        public override void AddRange(Array values);
+        public void AddRange(OleDbParameter[] values);
+        public OleDbParameter AddWithValue(string parameterName, object value);
+        public override void Clear();
+        public bool Contains(OleDbParameter value);
+        public override bool Contains(object value);
+        public override bool Contains(string value);
+        public override void CopyTo(Array array, int index);
+        public void CopyTo(OleDbParameter[] array, int index);
+        public override IEnumerator GetEnumerator();
+        protected override DbParameter GetParameter(int index);
+        protected override DbParameter GetParameter(string parameterName);
+        public int IndexOf(OleDbParameter value);
+        public override int IndexOf(object value);
+        public override int IndexOf(string parameterName);
+        public void Insert(int index, OleDbParameter value);
+        public override void Insert(int index, object value);
+        public void Remove(OleDbParameter value);
+        public override void Remove(object value);
+        public override void RemoveAt(int index);
+        public override void RemoveAt(string parameterName);
+        protected override void SetParameter(int index, DbParameter value);
+        protected override void SetParameter(string parameterName, DbParameter value);
+    }
+    public sealed class OleDbPermission : DBDataPermission {
+        public OleDbPermission();
+        public OleDbPermission(PermissionState state);
+        public OleDbPermission(PermissionState state, bool allowBlankPassword);
+        public string Provider { get; set; }
+        public override IPermission Copy();
+    }
+    public sealed class OleDbPermissionAttribute : DBDataPermissionAttribute {
+        public OleDbPermissionAttribute(SecurityAction action);
+        public string Provider { get; set; }
+        public override IPermission CreatePermission();
+    }
+    public sealed class OleDbRowUpdatedEventArgs : RowUpdatedEventArgs {
+        public OleDbRowUpdatedEventArgs(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        public new OleDbCommand Command { get; }
+    }
+    public delegate void OleDbRowUpdatedEventHandler(object sender, OleDbRowUpdatedEventArgs e);
+    public sealed class OleDbRowUpdatingEventArgs : RowUpdatingEventArgs {
+        public OleDbRowUpdatingEventArgs(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
+        protected override IDbCommand BaseCommand { get; set; }
+        public new OleDbCommand Command { get; set; }
+    }
+    public delegate void OleDbRowUpdatingEventHandler(object sender, OleDbRowUpdatingEventArgs e);
+    public sealed class OleDbSchemaGuid {
+        public static readonly Guid Assertions;
+        public static readonly Guid Catalogs;
+        public static readonly Guid Character_Sets;
+        public static readonly Guid Check_Constraints;
+        public static readonly Guid Check_Constraints_By_Table;
+        public static readonly Guid Collations;
+        public static readonly Guid Columns;
+        public static readonly Guid Column_Domain_Usage;
+        public static readonly Guid Column_Privileges;
+        public static readonly Guid Constraint_Column_Usage;
+        public static readonly Guid Constraint_Table_Usage;
+        public static readonly Guid DbInfoKeywords;
+        public static readonly Guid DbInfoLiterals;
+        public static readonly Guid Foreign_Keys;
+        public static readonly Guid Indexes;
+        public static readonly Guid Key_Column_Usage;
+        public static readonly Guid Primary_Keys;
+        public static readonly Guid Procedures;
+        public static readonly Guid Procedure_Columns;
+        public static readonly Guid Procedure_Parameters;
+        public static readonly Guid Provider_Types;
+        public static readonly Guid Referential_Constraints;
+        public static readonly Guid SchemaGuids;
+        public static readonly Guid Schemata;
+        public static readonly Guid Sql_Languages;
+        public static readonly Guid Statistics;
+        public static readonly Guid Tables;
+        public static readonly Guid Tables_Info;
+        public static readonly Guid Table_Constraints;
+        public static readonly Guid Table_Privileges;
+        public static readonly Guid Table_Statistics;
+        public static readonly Guid Translations;
+        public static readonly Guid Trustee;
+        public static readonly Guid Usage_Privileges;
+        public static readonly Guid Views;
+        public static readonly Guid View_Column_Usage;
+        public static readonly Guid View_Table_Usage;
+        public OleDbSchemaGuid();
+    }
+    public sealed class OleDbTransaction : DbTransaction {
+        public new OleDbConnection Connection { get; }
+        protected override DbConnection DbConnection { get; }
+        public override IsolationLevel IsolationLevel { get; }
+        public OleDbTransaction Begin();
+        public OleDbTransaction Begin(IsolationLevel isolevel);
+        public override void Commit();
+        protected override void Dispose(bool disposing);
+        public override void Rollback();
+    }
+    public enum OleDbType {
+        BigInt = 20,
+        Binary = 128,
+        Boolean = 11,
+        BSTR = 8,
+        Char = 129,
+        Currency = 6,
+        Date = 7,
+        DBDate = 133,
+        DBTime = 134,
+        DBTimeStamp = 135,
+        Decimal = 14,
+        Double = 5,
+        Empty = 0,
+        Error = 10,
+        Filetime = 64,
+        Guid = 72,
+        IDispatch = 9,
+        Integer = 3,
+        IUnknown = 13,
+        LongVarBinary = 205,
+        LongVarChar = 201,
+        LongVarWChar = 203,
+        Numeric = 131,
+        PropVariant = 138,
+        Single = 4,
+        SmallInt = 2,
+        TinyInt = 16,
+        UnsignedBigInt = 21,
+        UnsignedInt = 19,
+        UnsignedSmallInt = 18,
+        UnsignedTinyInt = 17,
+        VarBinary = 204,
+        VarChar = 200,
+        Variant = 12,
+        VarNumeric = 139,
+        VarWChar = 202,
+        WChar = 130,
+    }
+}
```

