$targetFile = Join-Path (Split-Path -parent $PSCommandPath) "..\build\assets.props";

$platforms = @(
    @{
        Platform = "x64";
        VCPlatform = "x64";
    },
    @{
        Platform = "x86";
        VCPlatform = "Win32";
    }
);
$srcDir = "`$(MSBuildThisFileDirectory)..";
$projects = @(
     @{
        ProjectDirectory = "$srcDir\AspNetCoreModuleV2\AspNetCore";
        ProjectName = "AspNetCore.vcxproj";
        OutDirName = "AspNetCoreModuleShim";
        NativeAsset = "aspnetcorev2";
        BaseOutputPath = "AspNetCoreModuleV2"
        PropetyName = "AspNetCoreModuleV2Shim"
     },
     @{
        ProjectDirectory = "$srcDir\AspNetCoreModuleV2\InProcessRequestHandler";
        ProjectName = "InProcessRequestHandler.vcxproj";
        OutDirName = "InProcessRequestHandler";
        NativeAsset = "aspnetcorev2_inprocess";
        BaseOutputPath = "AspNetCoreModuleV2";
        PropetyName = "AspNetCoreModuleV2InProcessHandler"
     },
     @{
        ProjectDirectory = "$srcDir\AspNetCoreModuleV2\OutOfProcessRequestHandler";
        ProjectName = "OutOfProcessRequestHandler.vcxproj";
        OutDirName = "OutOfProcessRequestHandler";
        NativeAsset = "aspnetcorev2_outofprocess";
        BaseOutputPath = "AspNetCoreModuleV2";
        PackageSubPath = "`$(AspNetCoreModuleOutOfProcessVersion)\";
        PropetyName = "AspNetCoreModuleV2OutOfProcessHandler"
     }
);
$currentPlatform = @{
    Platform = "`$(NativePlatform)";
    VCPlatform = "`$(NativeVCPlatform)";
};
$components = @();
$shimComponents = @();
$inProcessComponents = @();
$runShimComponents = @();
$runInProcessComponents = @();
$properties = @();

function CopyProperties($from, $to)
{
    foreach ($key in $from.Keys)
    {
        $to.Add($key, $from.$key);
    }
}

function Write-Group($group, $name)
{
    return $(
        foreach ($item in $group){
        "       <$name$(foreach ($pair in $item.GetEnumerator()) {
        "`n          $($pair.Key)=`"`"$($pair.Value)`"`""})
        />`n"});
}
function Write-Properties($group)
{
    return $(
        foreach ($item in $group){
        "`n       <$($item.Name)>$($item.Value)</$($item.Name)>"});
}

function New-Component($project, $platform)
{
    $component = [ordered]@{};
    CopyProperties -from $platform -to $component;
    CopyProperties -from $project -to $component;
    CopyProperties -from @{
        Include = "$($project.ProjectDirectory)\$($project.ProjectName)";
        DllLocation = "`$(ArtifactsBinDir)$($project.OutDirName)\$($platform.VCPlatform)\`$(Configuration)\$($project.NativeAsset).dll";
        PdbLocation = "`$(ArtifactsBinDir)$($project.OutDirName)\$($platform.VCPlatform)\`$(Configuration)\$($project.NativeAsset).pdb";
    } -to $component;

    return $component;
}

foreach ($project in $projects)
{
    foreach ($platform in $platforms)
    {
        $component = New-Component $project $platform;
        $components += $component;

        if ($project.ProjectName.Contains("InProcess"))
        {
            $inProcessComponents += $component;
        }
        else
        {
            $shimComponents += $component;
        }
    }

    $properties += @{
        Name = "$($project.PropetyName)Dll";
        Value = "`$(ArtifactsBinDir)$($project.OutDirName)\`$(NativeVCPlatform)\`$(Configuration)\$($project.NativeAsset).dll";
    };

    $runComponent = New-Component $project $currentPlatform;

    if ($project.ProjectName.Contains("InProcess"))
    {
        $runInProcessComponents += $runComponent;
    }
    else
    {
        $runShimComponents += $runComponent;
    }
}

$content = @"
<!-- This file is autogenerated -->
<Project>
    <PropertyGroup>
        <PackNativeAssets Condition="'`$(BuildIisNativeProjects)' == 'true'">true</PackNativeAssets>
        <NativePlatform Condition="'`$(Platform)' == 'AnyCPU'">x64</NativePlatform>
        <NativePlatform Condition="'`$(NativePlatform)' == ''">`$(Platform)</NativePlatform>
        <NativeVCPlatform Condition="'`$(NativePlatform)' == 'x86'">Win32</NativeVCPlatform>
        <NativeVCPlatform Condition="'`$(NativeVCPlatform)' == ''">`$(NativePlatform)</NativeVCPlatform>
    </PropertyGroup>
    <ItemGroup>
$(Write-Group $components "Components" )
$(Write-Group $shimComponents "ShimComponents")
$(Write-Group $inProcessComponents "InProcessComponents")
$(Write-Group $runShimComponents "RunShimComponents")
$(Write-Group $runInProcessComponents "RunInProcessComponents")
    </ItemGroup>
    <PropertyGroup>
$(Write-Properties $properties)
    </PropertyGroup>
</Project>
"@;

[IO.File]::WriteAllLines($targetFile, $content)
