--
-- Setup UdtTestDb and associated UDTS, tables and procedures.
--
PRINT N'============================================================================='
GO
PRINT N'Starting UdtTestDb Setup Script'
GO
PRINT N'============================================================================='
GO
SET NOCOUNT ON
print 'Creating UdtTestDb database.'

if  exists (select name from [master].[dbo].[sysdatabases] where name = N'UdtTestDb')
    drop database [UdtTestDb]
go
create database [UdtTestDb]
go
alter database [UdtTestDb] set trustworthy on 
go 

print 'Configuring UdtTestDb database...'

use UdtTestDb
go

EXEC sp_configure 'clr enabled', 1
    go
    RECONFIGURE
    go
EXEC sp_configure 'clr enabled'
    go
	
create assembly address
from
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
with permission_set = safe
go
create assembly circle from
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
with permission_set = safe
go
create assembly shapes from
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
with permission_set = safe
go
create assembly weakpoint from
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
with permission_set = safe
go
create assembly weakline from
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
with permission_set = safe
go
create assembly weakcircle from
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
with permission_set = safe
go

create type Point external name shapes.[Point]
create type Line external name shapes.[Line]
create type Circle external name circle.[Circle]
create type Address external name address.[Address]
create type WeakPoint external name weakpoint.[WeakPoint]
create type WeakLine external name weakline.[WeakLine]
go

create type CustomerAddress as table( name nvarchar(30) NOT NULL, addr Address NULL )
go

create table cities (name sysname,location Point)
create table lines(ids int null, pos Line null)
create table customers(name nvarchar(30), address Address)
create table circles(num int, def Circle)
create table lines_weak(ids int, pos WeakLine)
go

insert into cities values('redmond',convert(Point,'3,4'))
insert into cities values('bellevue',convert(Point,'6,8'))
insert into cities values('seattle',convert(Point,'10,11'))
insert into cities values('portland',convert(Point,'20,15'))
insert into cities values('LA',convert(Point,'3,4'))
insert into cities values('SFO',convert(Point,'6,8'))
insert into cities values('beaverton',convert(Point,'10,11'))
insert into cities values('new york',convert(Point,'20,15'))
insert into cities values('yukon',convert(Point,'20,25'))

insert into lines values (1, CONVERT(Line,'1,2,3,4'))
insert into lines values (2, CONVERT(Line,'3,4,5,6'))
insert into lines values (3, CONVERT(Line,'11,23,15,32'))
insert into lines values (4, CONVERT(Line,'444,555,245,634'))
insert into lines values (5, CONVERT(Line,'1,2,3,4'))
insert into lines values (6, CONVERT(Line,'3,4,5,6'))
insert into lines values (7, CONVERT(Line,'11,23,15,32'))
insert into lines values (8, CONVERT(Line,'444,555,245,634'))

insert into customers values('first', convert(Address, 'Address 1 | Address 2'))
insert into customers values('second', convert(Address, '123 Park Lane | New York'))
insert into customers values('third', convert(Address, '21 Forest grove | Portland'))
insert into customers values('fourth', convert(Address, '34 Lake Blvd | Seattle'))
insert into customers values('fifth', convert(Address, 'A2 Meadows | Bellevue'))

insert into circles values (1, CONVERT(Circle,'1,2,3'))
insert into circles values (2, CONVERT(Circle,'3,4,5'))
insert into circles values (3, CONVERT(Circle,'11,23,32'))
insert into circles values (4, CONVERT(Circle,'444,555,634'))
insert into circles values (5, CONVERT(Circle,'1,2,3'))
insert into circles values (6, CONVERT(Circle,'3,4,5'))
insert into circles values (7, CONVERT(Circle,'11,23,32'))
insert into circles values (8, CONVERT(Circle,'444,245,634'))

insert into lines_weak values (1, CONVERT(WeakLine,'1,2,3,4'))
insert into lines_weak values (2, CONVERT(WeakLine,'3,4,5,6'))
insert into lines_weak values (3, CONVERT(WeakLine,'11,23,15,32'))
insert into lines_weak values (4, CONVERT(WeakLine,'444,555,245,634'))
insert into lines_weak values (5, CONVERT(WeakLine,'1,2,3,4'))
insert into lines_weak values (6, CONVERT(WeakLine,'3,4,5,6'))
insert into lines_weak values (7, CONVERT(WeakLine,'11,23,15,32'))
insert into lines_weak values (8, CONVERT(WeakLine,'444,555,245,634'))
go

create proc vicinity @boundary Point output
as
select name, location from cities where location.Distance() < @boundary.Distance()
go

create proc sp_insert_customer(@name nvarchar(30), @addr Address output)
as
insert into customers values (@name, @addr)
go

create proc sp_insert_customers ( @customers CustomerAddress READONLY )
as
insert into customers(name,address) select name,addr from @customers
go

create assembly Utf8String from 
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
with permission_set = safe
go

create type Utf8String external name Utf8String.[Microsoft.Samples.SqlServer.Utf8String]
go

create table Testtable (udtstring Utf8String Primary Key)
go

insert into Testtable (udtstring) values (Convert(Utf8String, 'this'))
insert into Testtable (udtstring) values (Convert(Utf8String, 'is'))
insert into Testtable (udtstring) values (Convert(Utf8String, 'a'))
insert into Testtable (udtstring) values (Convert(Utf8String, 'test'))
go

create procedure UDTTest @value Utf8String OUTPUT AS select @value = Convert(Utf8String, 'this is an outparam test');
go

create table TesttableNull (udtstring Utf8String null)
go

insert into TesttableNull (udtstring) values (Convert(Utf8String, 'this'))
insert into TesttableNull (udtstring) values (Convert(Utf8String, 'is'))
insert into TesttableNull (udtstring) values (Convert(Utf8String, 'a'))
insert into TesttableNull (udtstring) values (Convert(Utf8String, 'test'))
go

PRINT N'Creation of UdtTestDb database complete.'
go


PRINT N'============================================================================='
GO
PRINT N'Finished executing Script'
GO
PRINT N'============================================================================='
GO