# System.Collections.Immutable

``` diff
+namespace System.Collections.Immutable {
+    public interface IImmutableDictionary<TKey, TValue> : IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+        IImmutableDictionary<TKey, TValue> Add(TKey key, TValue value);
+        IImmutableDictionary<TKey, TValue> AddRange(IEnumerable<KeyValuePair<TKey, TValue>> pairs);
+        IImmutableDictionary<TKey, TValue> Clear();
+        bool Contains(KeyValuePair<TKey, TValue> pair);
+        IImmutableDictionary<TKey, TValue> Remove(TKey key);
+        IImmutableDictionary<TKey, TValue> RemoveRange(IEnumerable<TKey> keys);
+        IImmutableDictionary<TKey, TValue> SetItem(TKey key, TValue value);
+        IImmutableDictionary<TKey, TValue> SetItems(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        bool TryGetKey(TKey equalKey, out TKey actualKey);
+    }
+    public interface IImmutableList<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+        IImmutableList<T> Add(T value);
+        IImmutableList<T> AddRange(IEnumerable<T> items);
+        IImmutableList<T> Clear();
+        int IndexOf(T item, int index, int count, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> Insert(int index, T element);
+        IImmutableList<T> InsertRange(int index, IEnumerable<T> items);
+        int LastIndexOf(T item, int index, int count, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> Remove(T value, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> RemoveAll(Predicate<T> match);
+        IImmutableList<T> RemoveAt(int index);
+        IImmutableList<T> RemoveRange(IEnumerable<T> items, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> RemoveRange(int index, int count);
+        IImmutableList<T> Replace(T oldValue, T newValue, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> SetItem(int index, T value);
+    }
+    public interface IImmutableQueue<T> : IEnumerable, IEnumerable<T> {
+        bool IsEmpty { get; }
+        IImmutableQueue<T> Clear();
+        IImmutableQueue<T> Dequeue();
+        IImmutableQueue<T> Enqueue(T value);
+        T Peek();
+    }
+    public interface IImmutableSet<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
+        IImmutableSet<T> Add(T value);
+        IImmutableSet<T> Clear();
+        bool Contains(T value);
+        IImmutableSet<T> Except(IEnumerable<T> other);
+        IImmutableSet<T> Intersect(IEnumerable<T> other);
+        bool IsProperSubsetOf(IEnumerable<T> other);
+        bool IsProperSupersetOf(IEnumerable<T> other);
+        bool IsSubsetOf(IEnumerable<T> other);
+        bool IsSupersetOf(IEnumerable<T> other);
+        bool Overlaps(IEnumerable<T> other);
+        IImmutableSet<T> Remove(T value);
+        bool SetEquals(IEnumerable<T> other);
+        IImmutableSet<T> SymmetricExcept(IEnumerable<T> other);
+        bool TryGetValue(T equalValue, out T actualValue);
+        IImmutableSet<T> Union(IEnumerable<T> other);
+    }
+    public interface IImmutableStack<T> : IEnumerable, IEnumerable<T> {
+        bool IsEmpty { get; }
+        IImmutableStack<T> Clear();
+        T Peek();
+        IImmutableStack<T> Pop();
+        IImmutableStack<T> Push(T value);
+    }
+    public static class ImmutableArray {
+        public static int BinarySearch<T>(this ImmutableArray<T> array, int index, int length, T value);
+        public static int BinarySearch<T>(this ImmutableArray<T> array, int index, int length, T value, IComparer<T> comparer);
+        public static int BinarySearch<T>(this ImmutableArray<T> array, T value);
+        public static int BinarySearch<T>(this ImmutableArray<T> array, T value, IComparer<T> comparer);
+        public static ImmutableArray<T> Create<T>();
+        public static ImmutableArray<T> Create<T>(ImmutableArray<T> items, int start, int length);
+        public static ImmutableArray<T> Create<T>(T item);
+        public static ImmutableArray<T> Create<T>(T item1, T item2);
+        public static ImmutableArray<T> Create<T>(T item1, T item2, T item3);
+        public static ImmutableArray<T> Create<T>(T item1, T item2, T item3, T item4);
+        public static ImmutableArray<T> Create<T>(params T[] items);
+        public static ImmutableArray<T> Create<T>(T[] items, int start, int length);
+        public static ImmutableArray<T>.Builder CreateBuilder<T>();
+        public static ImmutableArray<T>.Builder CreateBuilder<T>(int initialCapacity);
+        public static ImmutableArray<T> CreateRange<T>(IEnumerable<T> items);
+        public static ImmutableArray<TResult> CreateRange<TSource, TArg, TResult>(ImmutableArray<TSource> items, Func<TSource, TArg, TResult> selector, TArg arg);
+        public static ImmutableArray<TResult> CreateRange<TSource, TArg, TResult>(ImmutableArray<TSource> items, int start, int length, Func<TSource, TArg, TResult> selector, TArg arg);
+        public static ImmutableArray<TResult> CreateRange<TSource, TResult>(ImmutableArray<TSource> items, Func<TSource, TResult> selector);
+        public static ImmutableArray<TResult> CreateRange<TSource, TResult>(ImmutableArray<TSource> items, int start, int length, Func<TSource, TResult> selector);
+        public static ImmutableArray<TSource> ToImmutableArray<TSource>(this IEnumerable<TSource> items);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ImmutableArray<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IEquatable<ImmutableArray<T>>, IImmutableArray, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStructuralComparable, IStructuralEquatable {
+        public static readonly ImmutableArray<T> Empty;
+        public bool IsDefault { get; }
+        public bool IsDefaultOrEmpty { get; }
+        public bool IsEmpty { get; }
+        public int Length { get; }
+        int System.Collections.Generic.ICollection<T>.Count { get; }
+        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+        T System.Collections.Generic.IList<T>.this[int index] { get; set; }
+        int System.Collections.Generic.IReadOnlyCollection<T>.Count { get; }
+        T System.Collections.Generic.IReadOnlyList<T>.this[int index] { get; }
+        int System.Collections.ICollection.Count { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public T this[int index] { get; }
+        public ImmutableArray<T> Add(T item);
+        public ImmutableArray<T> AddRange(IEnumerable<T> items);
+        public ImmutableArray<T> AddRange(ImmutableArray<T> items);
+        public ImmutableArray<TOther> As<TOther>() where TOther : class;
+        public ImmutableArray<TOther> CastArray<TOther>() where TOther : class;
+        public static ImmutableArray<T> CastUp<TDerived>(ImmutableArray<TDerived> items) where TDerived : class, T;
+        public ImmutableArray<T> Clear();
+        public bool Contains(T item);
+        public void CopyTo(int sourceIndex, T[] destination, int destinationIndex, int length);
+        public void CopyTo(T[] destination);
+        public void CopyTo(T[] destination, int destinationIndex);
+        public bool Equals(ImmutableArray<T> other);
+        public override bool Equals(object obj);
+        public ImmutableArray<T>.Enumerator GetEnumerator();
+        public override int GetHashCode();
+        public int IndexOf(T item);
+        public int IndexOf(T item, int startIndex);
+        public int IndexOf(T item, int startIndex, IEqualityComparer<T> equalityComparer);
+        public int IndexOf(T item, int startIndex, int count);
+        public int IndexOf(T item, int startIndex, int count, IEqualityComparer<T> equalityComparer);
+        public ImmutableArray<T> Insert(int index, T item);
+        public ImmutableArray<T> InsertRange(int index, IEnumerable<T> items);
+        public ImmutableArray<T> InsertRange(int index, ImmutableArray<T> items);
+        public int LastIndexOf(T item);
+        public int LastIndexOf(T item, int startIndex);
+        public int LastIndexOf(T item, int startIndex, int count);
+        public int LastIndexOf(T item, int startIndex, int count, IEqualityComparer<T> equalityComparer);
+        public IEnumerable<TResult> OfType<TResult>();
+        public static bool operator ==(ImmutableArray<T> left, ImmutableArray<T> right);
+        public static bool operator ==(Nullable<ImmutableArray<T>> left, Nullable<ImmutableArray<T>> right);
+        public static bool operator !=(ImmutableArray<T> left, ImmutableArray<T> right);
+        public static bool operator !=(Nullable<ImmutableArray<T>> left, Nullable<ImmutableArray<T>> right);
+        public ImmutableArray<T> Remove(T item);
+        public ImmutableArray<T> Remove(T item, IEqualityComparer<T> equalityComparer);
+        public ImmutableArray<T> RemoveAll(Predicate<T> match);
+        public ImmutableArray<T> RemoveAt(int index);
+        public ImmutableArray<T> RemoveRange(IEnumerable<T> items);
+        public ImmutableArray<T> RemoveRange(IEnumerable<T> items, IEqualityComparer<T> equalityComparer);
+        public ImmutableArray<T> RemoveRange(ImmutableArray<T> items);
+        public ImmutableArray<T> RemoveRange(ImmutableArray<T> items, IEqualityComparer<T> equalityComparer);
+        public ImmutableArray<T> RemoveRange(int index, int length);
+        public ImmutableArray<T> Replace(T oldValue, T newValue);
+        public ImmutableArray<T> Replace(T oldValue, T newValue, IEqualityComparer<T> equalityComparer);
+        public ImmutableArray<T> SetItem(int index, T item);
+        public ImmutableArray<T> Sort();
+        public ImmutableArray<T> Sort(IComparer<T> comparer);
+        public ImmutableArray<T> Sort(Comparison<T> comparison);
+        public ImmutableArray<T> Sort(int index, int count, IComparer<T> comparer);
+        void System.Collections.Generic.ICollection<T>.Add(T item);
+        void System.Collections.Generic.ICollection<T>.Clear();
+        bool System.Collections.Generic.ICollection<T>.Remove(T item);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        void System.Collections.Generic.IList<T>.Insert(int index, T item);
+        void System.Collections.Generic.IList<T>.RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        int System.Collections.IList.Add(object value);
+        void System.Collections.IList.Clear();
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+        void System.Collections.IList.RemoveAt(int index);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Add(T value);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.AddRange(IEnumerable<T> items);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Clear();
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Insert(int index, T element);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.InsertRange(int index, IEnumerable<T> items);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Remove(T value, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveAll(Predicate<T> match);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveAt(int index);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveRange(IEnumerable<T> items, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveRange(int index, int count);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Replace(T oldValue, T newValue, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.SetItem(int index, T value);
+        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
+        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
+        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
+        public ImmutableArray<T>.Builder ToBuilder();
+        public sealed class Builder : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public int Capacity { get; set; }
+            public int Count { get; set; }
+            bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+            public T this[int index] { get; set; }
+            public void Add(T item);
+            public void AddRange(ImmutableArray<T>.Builder items);
+            public void AddRange(IEnumerable<T> items);
+            public void AddRange(ImmutableArray<T> items);
+            public void AddRange(ImmutableArray<T> items, int length);
+            public void AddRange(params T[] items);
+            public void AddRange(T[] items, int length);
+            public void AddRange<TDerived>(ImmutableArray<TDerived>.Builder items) where TDerived : T;
+            public void AddRange<TDerived>(ImmutableArray<TDerived> items) where TDerived : T;
+            public void AddRange<TDerived>(TDerived[] items) where TDerived : T;
+            public void Clear();
+            public bool Contains(T item);
+            public void CopyTo(T[] array, int index);
+            public IEnumerator<T> GetEnumerator();
+            public int IndexOf(T item);
+            public int IndexOf(T item, int startIndex);
+            public int IndexOf(T item, int startIndex, int count);
+            public int IndexOf(T item, int startIndex, int count, IEqualityComparer<T> equalityComparer);
+            public void Insert(int index, T item);
+            public int LastIndexOf(T item);
+            public int LastIndexOf(T item, int startIndex);
+            public int LastIndexOf(T item, int startIndex, int count);
+            public int LastIndexOf(T item, int startIndex, int count, IEqualityComparer<T> equalityComparer);
+            public ImmutableArray<T> MoveToImmutable();
+            public bool Remove(T element);
+            public void RemoveAt(int index);
+            public void Reverse();
+            public void Sort();
+            public void Sort(IComparer<T> comparer);
+            public void Sort(Comparison<T> comparison);
+            public void Sort(int index, int count, IComparer<T> comparer);
+            IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public T[] ToArray();
+            public ImmutableArray<T> ToImmutable();
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator {
+            public T Current { get; }
+            public bool MoveNext();
+        }
+    }
+    public static class ImmutableDictionary {
+        public static bool Contains<TKey, TValue>(this IImmutableDictionary<TKey, TValue> map, TKey key, TValue value);
+        public static ImmutableDictionary<TKey, TValue> Create<TKey, TValue>();
+        public static ImmutableDictionary<TKey, TValue> Create<TKey, TValue>(IEqualityComparer<TKey> keyComparer);
+        public static ImmutableDictionary<TKey, TValue> Create<TKey, TValue>(IEqualityComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableDictionary<TKey, TValue>.Builder CreateBuilder<TKey, TValue>();
+        public static ImmutableDictionary<TKey, TValue>.Builder CreateBuilder<TKey, TValue>(IEqualityComparer<TKey> keyComparer);
+        public static ImmutableDictionary<TKey, TValue>.Builder CreateBuilder<TKey, TValue>(IEqualityComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableDictionary<TKey, TValue> CreateRange<TKey, TValue>(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public static ImmutableDictionary<TKey, TValue> CreateRange<TKey, TValue>(IEqualityComparer<TKey> keyComparer, IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public static ImmutableDictionary<TKey, TValue> CreateRange<TKey, TValue>(IEqualityComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer, IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public static TValue GetValueOrDefault<TKey, TValue>(this IImmutableDictionary<TKey, TValue> dictionary, TKey key);
+        public static TValue GetValueOrDefault<TKey, TValue>(this IImmutableDictionary<TKey, TValue> dictionary, TKey key, TValue defaultValue);
+        public static ImmutableDictionary<TKey, TValue> ToImmutableDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source);
+        public static ImmutableDictionary<TKey, TValue> ToImmutableDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, IEqualityComparer<TKey> keyComparer);
+        public static ImmutableDictionary<TKey, TValue> ToImmutableDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, IEqualityComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableDictionary<TKey, TValue> ToImmutableDictionary<TSource, TKey, TValue>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TValue> elementSelector);
+        public static ImmutableDictionary<TKey, TValue> ToImmutableDictionary<TSource, TKey, TValue>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TValue> elementSelector, IEqualityComparer<TKey> keyComparer);
+        public static ImmutableDictionary<TKey, TValue> ToImmutableDictionary<TSource, TKey, TValue>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TValue> elementSelector, IEqualityComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableDictionary<TKey, TSource> ToImmutableDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
+        public static ImmutableDictionary<TKey, TSource> ToImmutableDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> keyComparer);
+    }
+    public sealed class ImmutableDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IHashKeyCollection<TKey>, IImmutableDictionary<TKey, TValue>, IImmutableDictionaryInternal<TKey, TValue>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+        public static readonly ImmutableDictionary<TKey, TValue> Empty;
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        public IEqualityComparer<TKey> KeyComparer { get; }
+        public IEnumerable<TKey> Keys { get; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
+        TValue System.Collections.Generic.IDictionary<TKey,TValue>.this[TKey key] { get; set; }
+        ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
+        ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IDictionary.IsFixedSize { get; }
+        bool System.Collections.IDictionary.IsReadOnly { get; }
+        object System.Collections.IDictionary.this[object key] { get; set; }
+        ICollection System.Collections.IDictionary.Keys { get; }
+        ICollection System.Collections.IDictionary.Values { get; }
+        public TValue this[TKey key] { get; }
+        public IEqualityComparer<TValue> ValueComparer { get; }
+        public IEnumerable<TValue> Values { get; }
+        public ImmutableDictionary<TKey, TValue> Add(TKey key, TValue value);
+        public ImmutableDictionary<TKey, TValue> AddRange(IEnumerable<KeyValuePair<TKey, TValue>> pairs);
+        public ImmutableDictionary<TKey, TValue> Clear();
+        public bool Contains(KeyValuePair<TKey, TValue> pair);
+        public bool ContainsKey(TKey key);
+        public bool ContainsValue(TValue value);
+        public ImmutableDictionary<TKey, TValue>.Enumerator GetEnumerator();
+        public ImmutableDictionary<TKey, TValue> Remove(TKey key);
+        public ImmutableDictionary<TKey, TValue> RemoveRange(IEnumerable<TKey> keys);
+        public ImmutableDictionary<TKey, TValue> SetItem(TKey key, TValue value);
+        public ImmutableDictionary<TKey, TValue> SetItems(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Clear();
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> item);
+        void System.Collections.Generic.IDictionary<TKey,TValue>.Add(TKey key, TValue value);
+        bool System.Collections.Generic.IDictionary<TKey,TValue>.Remove(TKey key);
+        IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+        void System.Collections.IDictionary.Add(object key, object value);
+        void System.Collections.IDictionary.Clear();
+        bool System.Collections.IDictionary.Contains(object key);
+        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
+        void System.Collections.IDictionary.Remove(object key);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.Add(TKey key, TValue value);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.AddRange(IEnumerable<KeyValuePair<TKey, TValue>> pairs);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.Clear();
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.Remove(TKey key);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.RemoveRange(IEnumerable<TKey> keys);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.SetItem(TKey key, TValue value);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.SetItems(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public ImmutableDictionary<TKey, TValue>.Builder ToBuilder();
+        public bool TryGetKey(TKey equalKey, out TKey actualKey);
+        public bool TryGetValue(TKey key, out TValue value);
+        public ImmutableDictionary<TKey, TValue> WithComparers(IEqualityComparer<TKey> keyComparer);
+        public ImmutableDictionary<TKey, TValue> WithComparers(IEqualityComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public sealed class Builder : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+            public int Count { get; }
+            public IEqualityComparer<TKey> KeyComparer { get; set; }
+            public IEnumerable<TKey> Keys { get; }
+            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
+            ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
+            ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            bool System.Collections.IDictionary.IsFixedSize { get; }
+            bool System.Collections.IDictionary.IsReadOnly { get; }
+            object System.Collections.IDictionary.this[object key] { get; set; }
+            ICollection System.Collections.IDictionary.Keys { get; }
+            ICollection System.Collections.IDictionary.Values { get; }
+            public TValue this[TKey key] { get; set; }
+            public IEqualityComparer<TValue> ValueComparer { get; set; }
+            public IEnumerable<TValue> Values { get; }
+            public void Add(KeyValuePair<TKey, TValue> item);
+            public void Add(TKey key, TValue value);
+            public void AddRange(IEnumerable<KeyValuePair<TKey, TValue>> items);
+            public void Clear();
+            public bool Contains(KeyValuePair<TKey, TValue> item);
+            public bool ContainsKey(TKey key);
+            public bool ContainsValue(TValue value);
+            public ImmutableDictionary<TKey, TValue>.Enumerator GetEnumerator();
+            public TValue GetValueOrDefault(TKey key);
+            public TValue GetValueOrDefault(TKey key, TValue defaultValue);
+            public bool Remove(KeyValuePair<TKey, TValue> item);
+            public bool Remove(TKey key);
+            public void RemoveRange(IEnumerable<TKey> keys);
+            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
+            IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
+            void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+            void System.Collections.IDictionary.Add(object key, object value);
+            bool System.Collections.IDictionary.Contains(object key);
+            IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
+            void System.Collections.IDictionary.Remove(object key);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public ImmutableDictionary<TKey, TValue> ToImmutable();
+            public bool TryGetKey(TKey equalKey, out TKey actualKey);
+            public bool TryGetValue(TKey key, out TValue value);
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<TKey, TValue>> {
+            public KeyValuePair<TKey, TValue> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            public void Reset();
+        }
+    }
+    public static class ImmutableHashSet {
+        public static ImmutableHashSet<T> Create<T>();
+        public static ImmutableHashSet<T> Create<T>(IEqualityComparer<T> equalityComparer);
+        public static ImmutableHashSet<T> Create<T>(IEqualityComparer<T> equalityComparer, T item);
+        public static ImmutableHashSet<T> Create<T>(IEqualityComparer<T> equalityComparer, params T[] items);
+        public static ImmutableHashSet<T> Create<T>(T item);
+        public static ImmutableHashSet<T> Create<T>(params T[] items);
+        public static ImmutableHashSet<T>.Builder CreateBuilder<T>();
+        public static ImmutableHashSet<T>.Builder CreateBuilder<T>(IEqualityComparer<T> equalityComparer);
+        public static ImmutableHashSet<T> CreateRange<T>(IEnumerable<T> items);
+        public static ImmutableHashSet<T> CreateRange<T>(IEqualityComparer<T> equalityComparer, IEnumerable<T> items);
+        public static ImmutableHashSet<TSource> ToImmutableHashSet<TSource>(this IEnumerable<TSource> source);
+        public static ImmutableHashSet<TSource> ToImmutableHashSet<TSource>(this IEnumerable<TSource> source, IEqualityComparer<TSource> equalityComparer);
+    }
+    public sealed class ImmutableHashSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IHashKeyCollection<T>, IImmutableSet<T>, IReadOnlyCollection<T>, ISet<T>, IStrongEnumerable<T, ImmutableHashSet<T>.Enumerator> {
+        public static readonly ImmutableHashSet<T> Empty;
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        public IEqualityComparer<T> KeyComparer { get; }
+        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        public ImmutableHashSet<T> Add(T item);
+        public ImmutableHashSet<T> Clear();
+        public bool Contains(T item);
+        public ImmutableHashSet<T> Except(IEnumerable<T> other);
+        public ImmutableHashSet<T>.Enumerator GetEnumerator();
+        public ImmutableHashSet<T> Intersect(IEnumerable<T> other);
+        public bool IsProperSubsetOf(IEnumerable<T> other);
+        public bool IsProperSupersetOf(IEnumerable<T> other);
+        public bool IsSubsetOf(IEnumerable<T> other);
+        public bool IsSupersetOf(IEnumerable<T> other);
+        public bool Overlaps(IEnumerable<T> other);
+        public ImmutableHashSet<T> Remove(T item);
+        public bool SetEquals(IEnumerable<T> other);
+        public ImmutableHashSet<T> SymmetricExcept(IEnumerable<T> other);
+        void System.Collections.Generic.ICollection<T>.Add(T item);
+        void System.Collections.Generic.ICollection<T>.Clear();
+        void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<T>.Remove(T item);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        bool System.Collections.Generic.ISet<T>.Add(T item);
+        void System.Collections.Generic.ISet<T>.ExceptWith(IEnumerable<T> other);
+        void System.Collections.Generic.ISet<T>.IntersectWith(IEnumerable<T> other);
+        void System.Collections.Generic.ISet<T>.SymmetricExceptWith(IEnumerable<T> other);
+        void System.Collections.Generic.ISet<T>.UnionWith(IEnumerable<T> other);
+        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Add(T item);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Clear();
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Except(IEnumerable<T> other);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Intersect(IEnumerable<T> other);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Remove(T item);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.SymmetricExcept(IEnumerable<T> other);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Union(IEnumerable<T> other);
+        public ImmutableHashSet<T>.Builder ToBuilder();
+        public bool TryGetValue(T equalValue, out T actualValue);
+        public ImmutableHashSet<T> Union(IEnumerable<T> other);
+        public ImmutableHashSet<T> WithComparer(IEqualityComparer<T> equalityComparer);
+        public sealed class Builder : ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISet<T> {
+            public int Count { get; }
+            public IEqualityComparer<T> KeyComparer { get; set; }
+            bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+            public bool Add(T item);
+            public void Clear();
+            public bool Contains(T item);
+            public void ExceptWith(IEnumerable<T> other);
+            public ImmutableHashSet<T>.Enumerator GetEnumerator();
+            public void IntersectWith(IEnumerable<T> other);
+            public bool IsProperSubsetOf(IEnumerable<T> other);
+            public bool IsProperSupersetOf(IEnumerable<T> other);
+            public bool IsSubsetOf(IEnumerable<T> other);
+            public bool IsSupersetOf(IEnumerable<T> other);
+            public bool Overlaps(IEnumerable<T> other);
+            public bool Remove(T item);
+            public bool SetEquals(IEnumerable<T> other);
+            public void SymmetricExceptWith(IEnumerable<T> other);
+            void System.Collections.Generic.ICollection<T>.Add(T item);
+            void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);
+            IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public ImmutableHashSet<T> ToImmutable();
+            public void UnionWith(IEnumerable<T> other);
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T>, IStrongEnumerator<T> {
+            public T Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            public void Reset();
+        }
+    }
+    public static class ImmutableInterlocked {
+        public static TValue AddOrUpdate<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, Func<TKey, TValue> addValueFactory, Func<TKey, TValue, TValue> updateValueFactory);
+        public static TValue AddOrUpdate<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue addValue, Func<TKey, TValue, TValue> updateValueFactory);
+        public static void Enqueue<T>(ref ImmutableQueue<T> location, T value);
+        public static TValue GetOrAdd<TKey, TValue, TArg>(ref ImmutableDictionary<TKey, TValue> location, TKey key, Func<TKey, TArg, TValue> valueFactory, TArg factoryArgument);
+        public static TValue GetOrAdd<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, Func<TKey, TValue> valueFactory);
+        public static TValue GetOrAdd<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue value);
+        public static ImmutableArray<T> InterlockedCompareExchange<T>(ref ImmutableArray<T> location, ImmutableArray<T> value, ImmutableArray<T> comparand);
+        public static ImmutableArray<T> InterlockedExchange<T>(ref ImmutableArray<T> location, ImmutableArray<T> value);
+        public static bool InterlockedInitialize<T>(ref ImmutableArray<T> location, ImmutableArray<T> value);
+        public static void Push<T>(ref ImmutableStack<T> location, T value);
+        public static bool TryAdd<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue value);
+        public static bool TryDequeue<T>(ref ImmutableQueue<T> location, out T value);
+        public static bool TryPop<T>(ref ImmutableStack<T> location, out T value);
+        public static bool TryRemove<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, out TValue value);
+        public static bool TryUpdate<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue newValue, TValue comparisonValue);
+        public static bool Update<T, TArg>(ref T location, Func<T, TArg, T> transformer, TArg transformerArgument) where T : class;
+        public static bool Update<T>(ref T location, Func<T, T> transformer) where T : class;
+    }
+    public static class ImmutableList {
+        public static ImmutableList<T> Create<T>();
+        public static ImmutableList<T> Create<T>(T item);
+        public static ImmutableList<T> Create<T>(params T[] items);
+        public static ImmutableList<T>.Builder CreateBuilder<T>();
+        public static ImmutableList<T> CreateRange<T>(IEnumerable<T> items);
+        public static int IndexOf<T>(this IImmutableList<T> list, T item);
+        public static int IndexOf<T>(this IImmutableList<T> list, T item, IEqualityComparer<T> equalityComparer);
+        public static int IndexOf<T>(this IImmutableList<T> list, T item, int startIndex);
+        public static int IndexOf<T>(this IImmutableList<T> list, T item, int startIndex, int count);
+        public static int LastIndexOf<T>(this IImmutableList<T> list, T item);
+        public static int LastIndexOf<T>(this IImmutableList<T> list, T item, IEqualityComparer<T> equalityComparer);
+        public static int LastIndexOf<T>(this IImmutableList<T> list, T item, int startIndex);
+        public static int LastIndexOf<T>(this IImmutableList<T> list, T item, int startIndex, int count);
+        public static IImmutableList<T> Remove<T>(this IImmutableList<T> list, T value);
+        public static IImmutableList<T> RemoveRange<T>(this IImmutableList<T> list, IEnumerable<T> items);
+        public static IImmutableList<T> Replace<T>(this IImmutableList<T> list, T oldValue, T newValue);
+        public static ImmutableList<TSource> ToImmutableList<TSource>(this IEnumerable<TSource> source);
+    }
+    public sealed class ImmutableList<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableList<T>, IImmutableListQueries<T>, IList, IList<T>, IOrderedCollection<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStrongEnumerable<T, ImmutableList<T>.Enumerator> {
+        public static readonly ImmutableList<T> Empty;
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+        T System.Collections.Generic.IList<T>.this[int index] { get; set; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public T this[int index] { get; }
+        public ImmutableList<T> Add(T value);
+        public ImmutableList<T> AddRange(IEnumerable<T> items);
+        public int BinarySearch(int index, int count, T item, IComparer<T> comparer);
+        public int BinarySearch(T item);
+        public int BinarySearch(T item, IComparer<T> comparer);
+        public ImmutableList<T> Clear();
+        public bool Contains(T value);
+        public ImmutableList<TOutput> ConvertAll<TOutput>(Func<T, TOutput> converter);
+        public void CopyTo(int index, T[] array, int arrayIndex, int count);
+        public void CopyTo(T[] array);
+        public void CopyTo(T[] array, int arrayIndex);
+        public bool Exists(Predicate<T> match);
+        public T Find(Predicate<T> match);
+        public ImmutableList<T> FindAll(Predicate<T> match);
+        public int FindIndex(int startIndex, int count, Predicate<T> match);
+        public int FindIndex(int startIndex, Predicate<T> match);
+        public int FindIndex(Predicate<T> match);
+        public T FindLast(Predicate<T> match);
+        public int FindLastIndex(int startIndex, int count, Predicate<T> match);
+        public int FindLastIndex(int startIndex, Predicate<T> match);
+        public int FindLastIndex(Predicate<T> match);
+        public void ForEach(Action<T> action);
+        public ImmutableList<T>.Enumerator GetEnumerator();
+        public ImmutableList<T> GetRange(int index, int count);
+        public int IndexOf(T value);
+        public int IndexOf(T item, int index, int count, IEqualityComparer<T> equalityComparer);
+        public ImmutableList<T> Insert(int index, T item);
+        public ImmutableList<T> InsertRange(int index, IEnumerable<T> items);
+        public int LastIndexOf(T item, int index, int count, IEqualityComparer<T> equalityComparer);
+        public ImmutableList<T> Remove(T value);
+        public ImmutableList<T> Remove(T value, IEqualityComparer<T> equalityComparer);
+        public ImmutableList<T> RemoveAll(Predicate<T> match);
+        public ImmutableList<T> RemoveAt(int index);
+        public ImmutableList<T> RemoveRange(IEnumerable<T> items);
+        public ImmutableList<T> RemoveRange(IEnumerable<T> items, IEqualityComparer<T> equalityComparer);
+        public ImmutableList<T> RemoveRange(int index, int count);
+        public ImmutableList<T> Replace(T oldValue, T newValue);
+        public ImmutableList<T> Replace(T oldValue, T newValue, IEqualityComparer<T> equalityComparer);
+        public ImmutableList<T> Reverse();
+        public ImmutableList<T> Reverse(int index, int count);
+        public ImmutableList<T> SetItem(int index, T value);
+        public ImmutableList<T> Sort();
+        public ImmutableList<T> Sort(IComparer<T> comparer);
+        public ImmutableList<T> Sort(Comparison<T> comparison);
+        public ImmutableList<T> Sort(int index, int count, IComparer<T> comparer);
+        void System.Collections.Generic.ICollection<T>.Add(T item);
+        void System.Collections.Generic.ICollection<T>.Clear();
+        bool System.Collections.Generic.ICollection<T>.Remove(T item);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        void System.Collections.Generic.IList<T>.Insert(int index, T item);
+        void System.Collections.Generic.IList<T>.RemoveAt(int index);
+        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        int System.Collections.IList.Add(object value);
+        void System.Collections.IList.Clear();
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+        void System.Collections.IList.RemoveAt(int index);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Add(T value);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.AddRange(IEnumerable<T> items);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Clear();
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Insert(int index, T item);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.InsertRange(int index, IEnumerable<T> items);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Remove(T value, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveAll(Predicate<T> match);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveAt(int index);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveRange(IEnumerable<T> items, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.RemoveRange(int index, int count);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.Replace(T oldValue, T newValue, IEqualityComparer<T> equalityComparer);
+        IImmutableList<T> System.Collections.Immutable.IImmutableList<T>.SetItem(int index, T value);
+        public ImmutableList<T>.Builder ToBuilder();
+        public bool TrueForAll(Predicate<T> match);
+        public sealed class Builder : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableListQueries<T>, IList, IList<T>, IOrderedCollection<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public int Count { get; }
+            bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            bool System.Collections.IList.IsFixedSize { get; }
+            bool System.Collections.IList.IsReadOnly { get; }
+            object System.Collections.IList.this[int index] { get; set; }
+            public T this[int index] { get; set; }
+            public void Add(T item);
+            public void AddRange(IEnumerable<T> items);
+            public int BinarySearch(int index, int count, T item, IComparer<T> comparer);
+            public int BinarySearch(T item);
+            public int BinarySearch(T item, IComparer<T> comparer);
+            public void Clear();
+            public bool Contains(T item);
+            public ImmutableList<TOutput> ConvertAll<TOutput>(Func<T, TOutput> converter);
+            public void CopyTo(int index, T[] array, int arrayIndex, int count);
+            public void CopyTo(T[] array);
+            public void CopyTo(T[] array, int arrayIndex);
+            public bool Exists(Predicate<T> match);
+            public T Find(Predicate<T> match);
+            public ImmutableList<T> FindAll(Predicate<T> match);
+            public int FindIndex(int startIndex, int count, Predicate<T> match);
+            public int FindIndex(int startIndex, Predicate<T> match);
+            public int FindIndex(Predicate<T> match);
+            public T FindLast(Predicate<T> match);
+            public int FindLastIndex(int startIndex, int count, Predicate<T> match);
+            public int FindLastIndex(int startIndex, Predicate<T> match);
+            public int FindLastIndex(Predicate<T> match);
+            public void ForEach(Action<T> action);
+            public ImmutableList<T>.Enumerator GetEnumerator();
+            public ImmutableList<T> GetRange(int index, int count);
+            public int IndexOf(T item);
+            public int IndexOf(T item, int index);
+            public int IndexOf(T item, int index, int count);
+            public int IndexOf(T item, int index, int count, IEqualityComparer<T> equalityComparer);
+            public void Insert(int index, T item);
+            public void InsertRange(int index, IEnumerable<T> items);
+            public int LastIndexOf(T item);
+            public int LastIndexOf(T item, int startIndex);
+            public int LastIndexOf(T item, int startIndex, int count);
+            public int LastIndexOf(T item, int startIndex, int count, IEqualityComparer<T> equalityComparer);
+            public bool Remove(T item);
+            public int RemoveAll(Predicate<T> match);
+            public void RemoveAt(int index);
+            public void Reverse();
+            public void Reverse(int index, int count);
+            public void Sort();
+            public void Sort(IComparer<T> comparer);
+            public void Sort(Comparison<T> comparison);
+            public void Sort(int index, int count, IComparer<T> comparer);
+            IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+            void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            int System.Collections.IList.Add(object value);
+            void System.Collections.IList.Clear();
+            bool System.Collections.IList.Contains(object value);
+            int System.Collections.IList.IndexOf(object value);
+            void System.Collections.IList.Insert(int index, object value);
+            void System.Collections.IList.Remove(object value);
+            public ImmutableList<T> ToImmutable();
+            public bool TrueForAll(Predicate<T> match);
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T>, ISecurePooledObjectUser, IStrongEnumerator<T> {
+            public T Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            public void Reset();
+        }
+    }
+    public static class ImmutableQueue {
+        public static ImmutableQueue<T> Create<T>();
+        public static ImmutableQueue<T> Create<T>(T item);
+        public static ImmutableQueue<T> Create<T>(params T[] items);
+        public static ImmutableQueue<T> CreateRange<T>(IEnumerable<T> items);
+        public static IImmutableQueue<T> Dequeue<T>(this IImmutableQueue<T> queue, out T value);
+    }
+    public sealed class ImmutableQueue<T> : IEnumerable, IEnumerable<T>, IImmutableQueue<T> {
+        public static ImmutableQueue<T> Empty { get; }
+        public bool IsEmpty { get; }
+        public ImmutableQueue<T> Clear();
+        public ImmutableQueue<T> Dequeue();
+        public ImmutableQueue<T> Dequeue(out T value);
+        public ImmutableQueue<T> Enqueue(T value);
+        public ImmutableQueue<T>.Enumerator GetEnumerator();
+        public T Peek();
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        IImmutableQueue<T> System.Collections.Immutable.IImmutableQueue<T>.Clear();
+        IImmutableQueue<T> System.Collections.Immutable.IImmutableQueue<T>.Dequeue();
+        IImmutableQueue<T> System.Collections.Immutable.IImmutableQueue<T>.Enqueue(T value);
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator {
+            public T Current { get; }
+            public bool MoveNext();
+        }
+    }
+    public static class ImmutableSortedDictionary {
+        public static ImmutableSortedDictionary<TKey, TValue> Create<TKey, TValue>();
+        public static ImmutableSortedDictionary<TKey, TValue> Create<TKey, TValue>(IComparer<TKey> keyComparer);
+        public static ImmutableSortedDictionary<TKey, TValue> Create<TKey, TValue>(IComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableSortedDictionary<TKey, TValue>.Builder CreateBuilder<TKey, TValue>();
+        public static ImmutableSortedDictionary<TKey, TValue>.Builder CreateBuilder<TKey, TValue>(IComparer<TKey> keyComparer);
+        public static ImmutableSortedDictionary<TKey, TValue>.Builder CreateBuilder<TKey, TValue>(IComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableSortedDictionary<TKey, TValue> CreateRange<TKey, TValue>(IComparer<TKey> keyComparer, IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public static ImmutableSortedDictionary<TKey, TValue> CreateRange<TKey, TValue>(IComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer, IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public static ImmutableSortedDictionary<TKey, TValue> CreateRange<TKey, TValue>(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public static ImmutableSortedDictionary<TKey, TValue> ToImmutableSortedDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source);
+        public static ImmutableSortedDictionary<TKey, TValue> ToImmutableSortedDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, IComparer<TKey> keyComparer);
+        public static ImmutableSortedDictionary<TKey, TValue> ToImmutableSortedDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, IComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public static ImmutableSortedDictionary<TKey, TValue> ToImmutableSortedDictionary<TSource, TKey, TValue>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TValue> elementSelector);
+        public static ImmutableSortedDictionary<TKey, TValue> ToImmutableSortedDictionary<TSource, TKey, TValue>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TValue> elementSelector, IComparer<TKey> keyComparer);
+        public static ImmutableSortedDictionary<TKey, TValue> ToImmutableSortedDictionary<TSource, TKey, TValue>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TValue> elementSelector, IComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+    }
+    public sealed class ImmutableSortedDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IImmutableDictionary<TKey, TValue>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue>, ISortKeyCollection<TKey> {
+        public static readonly ImmutableSortedDictionary<TKey, TValue> Empty;
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        public IComparer<TKey> KeyComparer { get; }
+        public IEnumerable<TKey> Keys { get; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
+        TValue System.Collections.Generic.IDictionary<TKey,TValue>.this[TKey key] { get; set; }
+        ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
+        ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IDictionary.IsFixedSize { get; }
+        bool System.Collections.IDictionary.IsReadOnly { get; }
+        object System.Collections.IDictionary.this[object key] { get; set; }
+        ICollection System.Collections.IDictionary.Keys { get; }
+        ICollection System.Collections.IDictionary.Values { get; }
+        public TValue this[TKey key] { get; }
+        public IEqualityComparer<TValue> ValueComparer { get; }
+        public IEnumerable<TValue> Values { get; }
+        public ImmutableSortedDictionary<TKey, TValue> Add(TKey key, TValue value);
+        public ImmutableSortedDictionary<TKey, TValue> AddRange(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public ImmutableSortedDictionary<TKey, TValue> Clear();
+        public bool Contains(KeyValuePair<TKey, TValue> pair);
+        public bool ContainsKey(TKey key);
+        public bool ContainsValue(TValue value);
+        public ImmutableSortedDictionary<TKey, TValue>.Enumerator GetEnumerator();
+        public ImmutableSortedDictionary<TKey, TValue> Remove(TKey value);
+        public ImmutableSortedDictionary<TKey, TValue> RemoveRange(IEnumerable<TKey> keys);
+        public ImmutableSortedDictionary<TKey, TValue> SetItem(TKey key, TValue value);
+        public ImmutableSortedDictionary<TKey, TValue> SetItems(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Clear();
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> item);
+        void System.Collections.Generic.IDictionary<TKey,TValue>.Add(TKey key, TValue value);
+        bool System.Collections.Generic.IDictionary<TKey,TValue>.Remove(TKey key);
+        IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        void System.Collections.IDictionary.Add(object key, object value);
+        void System.Collections.IDictionary.Clear();
+        bool System.Collections.IDictionary.Contains(object key);
+        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
+        void System.Collections.IDictionary.Remove(object key);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.Add(TKey key, TValue value);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.AddRange(IEnumerable<KeyValuePair<TKey, TValue>> pairs);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.Clear();
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.Remove(TKey key);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.RemoveRange(IEnumerable<TKey> keys);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.SetItem(TKey key, TValue value);
+        IImmutableDictionary<TKey, TValue> System.Collections.Immutable.IImmutableDictionary<TKey,TValue>.SetItems(IEnumerable<KeyValuePair<TKey, TValue>> items);
+        public ImmutableSortedDictionary<TKey, TValue>.Builder ToBuilder();
+        public bool TryGetKey(TKey equalKey, out TKey actualKey);
+        public bool TryGetValue(TKey key, out TValue value);
+        public ImmutableSortedDictionary<TKey, TValue> WithComparers(IComparer<TKey> keyComparer);
+        public ImmutableSortedDictionary<TKey, TValue> WithComparers(IComparer<TKey> keyComparer, IEqualityComparer<TValue> valueComparer);
+        public sealed class Builder : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+            public int Count { get; }
+            public IComparer<TKey> KeyComparer { get; set; }
+            public IEnumerable<TKey> Keys { get; }
+            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
+            ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
+            ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            bool System.Collections.IDictionary.IsFixedSize { get; }
+            bool System.Collections.IDictionary.IsReadOnly { get; }
+            object System.Collections.IDictionary.this[object key] { get; set; }
+            ICollection System.Collections.IDictionary.Keys { get; }
+            ICollection System.Collections.IDictionary.Values { get; }
+            public TValue this[TKey key] { get; set; }
+            public IEqualityComparer<TValue> ValueComparer { get; set; }
+            public IEnumerable<TValue> Values { get; }
+            public void Add(KeyValuePair<TKey, TValue> item);
+            public void Add(TKey key, TValue value);
+            public void AddRange(IEnumerable<KeyValuePair<TKey, TValue>> items);
+            public void Clear();
+            public bool Contains(KeyValuePair<TKey, TValue> item);
+            public bool ContainsKey(TKey key);
+            public bool ContainsValue(TValue value);
+            public ImmutableSortedDictionary<TKey, TValue>.Enumerator GetEnumerator();
+            public TValue GetValueOrDefault(TKey key);
+            public TValue GetValueOrDefault(TKey key, TValue defaultValue);
+            public bool Remove(KeyValuePair<TKey, TValue> item);
+            public bool Remove(TKey key);
+            public void RemoveRange(IEnumerable<TKey> keys);
+            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
+            IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
+            void System.Collections.ICollection.CopyTo(Array array, int index);
+            void System.Collections.IDictionary.Add(object key, object value);
+            bool System.Collections.IDictionary.Contains(object key);
+            IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
+            void System.Collections.IDictionary.Remove(object key);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public ImmutableSortedDictionary<TKey, TValue> ToImmutable();
+            public bool TryGetKey(TKey equalKey, out TKey actualKey);
+            public bool TryGetValue(TKey key, out TValue value);
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<TKey, TValue>>, ISecurePooledObjectUser {
+            public KeyValuePair<TKey, TValue> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            public void Reset();
+        }
+    }
+    public static class ImmutableSortedSet {
+        public static ImmutableSortedSet<T> Create<T>();
+        public static ImmutableSortedSet<T> Create<T>(IComparer<T> comparer);
+        public static ImmutableSortedSet<T> Create<T>(IComparer<T> comparer, T item);
+        public static ImmutableSortedSet<T> Create<T>(IComparer<T> comparer, params T[] items);
+        public static ImmutableSortedSet<T> Create<T>(T item);
+        public static ImmutableSortedSet<T> Create<T>(params T[] items);
+        public static ImmutableSortedSet<T>.Builder CreateBuilder<T>();
+        public static ImmutableSortedSet<T>.Builder CreateBuilder<T>(IComparer<T> comparer);
+        public static ImmutableSortedSet<T> CreateRange<T>(IComparer<T> comparer, IEnumerable<T> items);
+        public static ImmutableSortedSet<T> CreateRange<T>(IEnumerable<T> items);
+        public static ImmutableSortedSet<TSource> ToImmutableSortedSet<TSource>(this IEnumerable<TSource> source);
+        public static ImmutableSortedSet<TSource> ToImmutableSortedSet<TSource>(this IEnumerable<TSource> source, IComparer<TSource> comparer);
+    }
+    public sealed class ImmutableSortedSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, ISet<T>, ISortKeyCollection<T>, IStrongEnumerable<T, ImmutableSortedSet<T>.Enumerator> {
+        public static readonly ImmutableSortedSet<T> Empty;
+        public int Count { get; }
+        public bool IsEmpty { get; }
+        public IComparer<T> KeyComparer { get; }
+        public T Max { get; }
+        public T Min { get; }
+        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+        T System.Collections.Generic.IList<T>.this[int index] { get; set; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        public T this[int index] { get; }
+        public ImmutableSortedSet<T> Add(T value);
+        public ImmutableSortedSet<T> Clear();
+        public bool Contains(T value);
+        public ImmutableSortedSet<T> Except(IEnumerable<T> other);
+        public ImmutableSortedSet<T>.Enumerator GetEnumerator();
+        public int IndexOf(T item);
+        public ImmutableSortedSet<T> Intersect(IEnumerable<T> other);
+        public bool IsProperSubsetOf(IEnumerable<T> other);
+        public bool IsProperSupersetOf(IEnumerable<T> other);
+        public bool IsSubsetOf(IEnumerable<T> other);
+        public bool IsSupersetOf(IEnumerable<T> other);
+        public bool Overlaps(IEnumerable<T> other);
+        public ImmutableSortedSet<T> Remove(T value);
+        public IEnumerable<T> Reverse();
+        public bool SetEquals(IEnumerable<T> other);
+        public ImmutableSortedSet<T> SymmetricExcept(IEnumerable<T> other);
+        void System.Collections.Generic.ICollection<T>.Add(T item);
+        void System.Collections.Generic.ICollection<T>.Clear();
+        void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<T>.Remove(T item);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        void System.Collections.Generic.IList<T>.Insert(int index, T item);
+        void System.Collections.Generic.IList<T>.RemoveAt(int index);
+        bool System.Collections.Generic.ISet<T>.Add(T item);
+        void System.Collections.Generic.ISet<T>.ExceptWith(IEnumerable<T> other);
+        void System.Collections.Generic.ISet<T>.IntersectWith(IEnumerable<T> other);
+        void System.Collections.Generic.ISet<T>.SymmetricExceptWith(IEnumerable<T> other);
+        void System.Collections.Generic.ISet<T>.UnionWith(IEnumerable<T> other);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        int System.Collections.IList.Add(object value);
+        void System.Collections.IList.Clear();
+        bool System.Collections.IList.Contains(object value);
+        int System.Collections.IList.IndexOf(object value);
+        void System.Collections.IList.Insert(int index, object value);
+        void System.Collections.IList.Remove(object value);
+        void System.Collections.IList.RemoveAt(int index);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Add(T value);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Clear();
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Except(IEnumerable<T> other);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Intersect(IEnumerable<T> other);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Remove(T value);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.SymmetricExcept(IEnumerable<T> other);
+        IImmutableSet<T> System.Collections.Immutable.IImmutableSet<T>.Union(IEnumerable<T> other);
+        public ImmutableSortedSet<T>.Builder ToBuilder();
+        public bool TryGetValue(T equalValue, out T actualValue);
+        public ImmutableSortedSet<T> Union(IEnumerable<T> other);
+        public ImmutableSortedSet<T> WithComparer(IComparer<T> comparer);
+        public sealed class Builder : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISet<T>, ISortKeyCollection<T> {
+            public int Count { get; }
+            public IComparer<T> KeyComparer { get; set; }
+            public T Max { get; }
+            public T Min { get; }
+            bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            public T this[int index] { get; }
+            public bool Add(T item);
+            public void Clear();
+            public bool Contains(T item);
+            public void ExceptWith(IEnumerable<T> other);
+            public ImmutableSortedSet<T>.Enumerator GetEnumerator();
+            public void IntersectWith(IEnumerable<T> other);
+            public bool IsProperSubsetOf(IEnumerable<T> other);
+            public bool IsProperSupersetOf(IEnumerable<T> other);
+            public bool IsSubsetOf(IEnumerable<T> other);
+            public bool IsSupersetOf(IEnumerable<T> other);
+            public bool Overlaps(IEnumerable<T> other);
+            public bool Remove(T item);
+            public IEnumerable<T> Reverse();
+            public bool SetEquals(IEnumerable<T> other);
+            public void SymmetricExceptWith(IEnumerable<T> other);
+            void System.Collections.Generic.ICollection<T>.Add(T item);
+            void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);
+            IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+            void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public ImmutableSortedSet<T> ToImmutable();
+            public void UnionWith(IEnumerable<T> other);
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T>, ISecurePooledObjectUser, IStrongEnumerator<T> {
+            public T Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            public void Reset();
+        }
+    }
+    public static class ImmutableStack {
+        public static ImmutableStack<T> Create<T>();
+        public static ImmutableStack<T> Create<T>(T item);
+        public static ImmutableStack<T> Create<T>(params T[] items);
+        public static ImmutableStack<T> CreateRange<T>(IEnumerable<T> items);
+        public static IImmutableStack<T> Pop<T>(this IImmutableStack<T> stack, out T value);
+    }
+    public sealed class ImmutableStack<T> : IEnumerable, IEnumerable<T>, IImmutableStack<T> {
+        public static ImmutableStack<T> Empty { get; }
+        public bool IsEmpty { get; }
+        public ImmutableStack<T> Clear();
+        public ImmutableStack<T>.Enumerator GetEnumerator();
+        public T Peek();
+        public ImmutableStack<T> Pop();
+        public ImmutableStack<T> Pop(out T value);
+        public ImmutableStack<T> Push(T value);
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        IImmutableStack<T> System.Collections.Immutable.IImmutableStack<T>.Clear();
+        IImmutableStack<T> System.Collections.Immutable.IImmutableStack<T>.Pop();
+        IImmutableStack<T> System.Collections.Immutable.IImmutableStack<T>.Push(T value);
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator {
+            public T Current { get; }
+            public bool MoveNext();
+        }
+    }
+}
```

