# MEF1 vs. MEF2

* MEF1 is used to compose different pieces of code together for dynamic extensions. It has attributes like `Export` and `Import`, hooking up import classes to exports. MEF has a catalog that keeps track of exports and looks at assembly, directory, type catalogs to discover exports. Container instantiates objects and satisfies imports. We do a series of object instantiations, catalog lookups, and finding exports to get the model that is handed out from a container. 

* MEF2 is purely type-based and in order to compose the graph it creates a catalog at compile-time. It builds graphs using expression trees. The expression trees in MEF2 fundamentally cannot have cycles in them. This is a limitation you get when you go for MEF2 that is an optimzed version of MEF1. This was done to improve performance and to have the graph known already at compile-time.

* It is important to recognize that MEF2 is not a new version of MEF1, but instead they serve different purposes. MEF2 is mostly suitable for web apps in order to make them more efficient. MEF1, on the other hand, uses a lot of reflection code in order to import exports, to build catalogs, and to do object instantiations but then it is more flexible in that it accepts cycles. This makes MEF1 a good option for adding dynamic extensions for long running applications. For web apps it is important to have fast response times and we deal with situations where servers might shut down, which is a good use case for MEF2.

* The `System.ComponentModel.Composition` package on nuget is most widely known as MEF1 and was originally shipped for .NET Framework. `Microsoft.Composition` package later became `System.Composition` package and both are known as MEF2. For more information on MEF you can check out the [archive](https://github.com/microsoftarchive/mef) which holds old wiki documentations in it where you can find out more about differences between MEF1 and MEF2 and links to other material. The source code for MEF1 and MEF2 can be found in this repository under [`System.ComponentModel.Composition`](https://github.com/dotnet/corefx/tree/master/src/System.ComponentModel.Composition) and [`System.Composition`](https://github.com/dotnet/corefx/tree/master/src/System.Composition) respectively.
