<instrumentationManifest xmlns="http://schemas.microsoft.com/win/2004/08/events">
    <instrumentation xmlns:xs="http://www.w3.org/2001/XMLSchema"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
          xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events">

        <events xmlns="http://schemas.microsoft.com/win/2004/08/events">
            <!--CLR Runtime Publisher-->
            <provider name="Microsoft-Windows-DotNETRuntime"
                      guid="{e13c0d23-ccbc-4e12-931b-d9cc2eee27e4}"
                      symbol="MICROSOFT_WINDOWS_DOTNETRUNTIME_PROVIDER"
                      resourceFileName="%INSTALL_PATH%\clretwrc.dll"
                      messageFileName="%INSTALL_PATH%\clretwrc.dll">

                <!--Keywords-->
                <keywords>
                    <keyword name="GCKeyword" mask="0x1"
                             message="$(string.RuntimePublisher.GCKeywordMessage)" symbol="CLR_GC_KEYWORD"/>
                    <keyword name="GCHandleKeyword" mask="0x2"
                             message="$(string.RuntimePublisher.GCHandleKeywordMessage)" symbol="CLR_GCHANDLE_KEYWORD"/>
                    <keyword name="FusionKeyword" mask="0x4"
                             message="$(string.RuntimePublisher.FusionKeywordMessage)" symbol="CLR_FUSION_KEYWORD"/>
                    <keyword name="LoaderKeyword" mask="0x8"
                             message="$(string.RuntimePublisher.LoaderKeywordMessage)" symbol="CLR_LOADER_KEYWORD"/>
                    <keyword name="JitKeyword" mask="0x10"
                             message="$(string.RuntimePublisher.JitKeywordMessage)" symbol="CLR_JIT_KEYWORD"/>
                    <keyword name="NGenKeyword" mask="0x20"
                             message="$(string.RuntimePublisher.NGenKeywordMessage)" symbol="CLR_NGEN_KEYWORD"/>
                    <keyword name="StartEnumerationKeyword" mask="0x40"
                             message="$(string.RuntimePublisher.StartEnumerationKeywordMessage)" symbol="CLR_STARTENUMERATION_KEYWORD"/>
                    <keyword name="EndEnumerationKeyword" mask="0x80"
                             message="$(string.RuntimePublisher.EndEnumerationKeywordMessage)" symbol="CLR_ENDENUMERATION_KEYWORD"/>
                    <!-- Keyword mask 0x100 is now defunct -->
                    <!-- Keyword mask 0x200 is now defunct -->
                    <keyword name="SecurityKeyword" mask="0x400"
                             message="$(string.RuntimePublisher.SecurityKeywordMessage)" symbol="CLR_SECURITY_KEYWORD"/>
                    <keyword name="AppDomainResourceManagementKeyword" mask="0x800"
                             message="$(string.RuntimePublisher.AppDomainResourceManagementKeywordMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_KEYWORD"/>
                    <keyword name="JitTracingKeyword" mask="0x1000"
                             message="$(string.RuntimePublisher.JitTracingKeywordMessage)" symbol="CLR_JITTRACING_KEYWORD"/>
                    <keyword name="InteropKeyword" mask="0x2000"
                             message="$(string.RuntimePublisher.InteropKeywordMessage)" symbol="CLR_INTEROP_KEYWORD"/>
                    <keyword name="ContentionKeyword" mask="0x4000"
                             message="$(string.RuntimePublisher.ContentionKeywordMessage)" symbol="CLR_CONTENTION_KEYWORD"/>
                    <keyword name="ExceptionKeyword" mask="0x8000"
                             message="$(string.RuntimePublisher.ExceptionKeywordMessage)" symbol="CLR_EXCEPTION_KEYWORD"/>
                    <keyword name="ThreadingKeyword" mask="0x10000"
                             message="$(string.RuntimePublisher.ThreadingKeywordMessage)" symbol="CLR_THREADING_KEYWORD"/>
                    <keyword name="JittedMethodILToNativeMapKeyword" mask="0x20000"
                             message="$(string.RuntimePublisher.JittedMethodILToNativeMapKeywordMessage)" symbol="CLR_JITTEDMETHODILTONATIVEMAP_KEYWORD"/>
                    <keyword name="OverrideAndSuppressNGenEventsKeyword" mask="0x40000"
                             message="$(string.RuntimePublisher.OverrideAndSuppressNGenEventsKeywordMessage)" symbol="CLR_OVERRIDEANDSUPPRESSNGENEVENTS_KEYWORD"/>
                    <keyword name="TypeKeyword" mask="0x80000"
                             message="$(string.RuntimePublisher.TypeKeywordMessage)" symbol="CLR_TYPE_KEYWORD"/>
                    <keyword name="GCHeapDumpKeyword" mask="0x100000"
                             message="$(string.RuntimePublisher.GCHeapDumpKeywordMessage)" symbol="CLR_GCHEAPDUMP_KEYWORD"/>
                    <keyword name="GCSampledObjectAllocationHighKeyword" mask="0x200000"
                             message="$(string.RuntimePublisher.GCSampledObjectAllocationHighKeywordMessage)" symbol="CLR_GCHEAPALLOCHIGH_KEYWORD"/>
                    <keyword name="GCHeapSurvivalAndMovementKeyword" mask="0x400000"
                             message="$(string.RuntimePublisher.GCHeapSurvivalAndMovementKeywordMessage)" symbol="CLR_GCHEAPSURVIVALANDMOVEMENT_KEYWORD"/>
                    <keyword name="GCHeapCollectKeyword" mask="0x800000"
                             message="$(string.RuntimePublisher.GCHeapCollectKeyword)" symbol="CLR_GCHEAPCOLLECT_KEYWORD"/>
                    <keyword name="GCHeapAndTypeNamesKeyword" mask="0x1000000"
                             message="$(string.RuntimePublisher.GCHeapAndTypeNamesKeyword)" symbol="CLR_GCHEAPANDTYPENAMES_KEYWORD"/>
                    <keyword name="GCSampledObjectAllocationLowKeyword" mask="0x2000000"
                             message="$(string.RuntimePublisher.GCSampledObjectAllocationLowKeywordMessage)" symbol="CLR_GCHEAPALLOCLOW_KEYWORD"/>
                    <keyword name="PerfTrackKeyword" mask="0x20000000"
                             message="$(string.RuntimePublisher.PerfTrackKeywordMessage)" symbol="CLR_PERFTRACK_KEYWORD"/>
                    <keyword name="StackKeyword" mask="0x40000000"
                             message="$(string.RuntimePublisher.StackKeywordMessage)" symbol="CLR_STACK_KEYWORD"/>
                    <keyword name="ThreadTransferKeyword" mask="0x80000000"
                             message="$(string.RuntimePublisher.ThreadTransferKeywordMessage)" symbol="CLR_THREADTRANSFER_KEYWORD"/>
                    <keyword name="DebuggerKeyword" mask="0x100000000"
                             message="$(string.RuntimePublisher.DebuggerKeywordMessage)" symbol="CLR_DEBUGGER_KEYWORD" />
                    <keyword name="MonitoringKeyword" mask="0x200000000"
                             message="$(string.RuntimePublisher.MonitoringKeywordMessage)" symbol="CLR_MONITORING_KEYWORD" />
                    <keyword name="CodeSymbolsKeyword" mask="0x400000000"
                             message="$(string.RuntimePublisher.CodeSymbolsKeywordMessage)" symbol="CLR_CODESYMBOLS_KEYWORD" />
                    <keyword name="EventSourceKeyword" mask="0x800000000"
                             message="$(string.RuntimePublisher.EventSourceKeywordMessage)" symbol="CLR_EVENTSOURCE_KEYWORD" />
                    <keyword name="CompilationKeyword" mask="0x1000000000"
                             message="$(string.RuntimePublisher.CompilationKeywordMessage)" symbol="CLR_COMPILATION_KEYWORD" />
                    <keyword name="CompilationDiagnosticKeyword" mask="0x2000000000"
                             message="$(string.RuntimePublisher.CompilationDiagnosticKeywordMessage)" symbol="CLR_COMPILATIONDIAGNOSTIC_KEYWORD" />
                </keywords>
                <!--Tasks-->
                <tasks>
                    <task name="GarbageCollection" symbol="CLR_GC_TASK"
                          value="1" eventGUID="{044973cd-251f-4dff-a3e9-9d6307286b05}"
                          message="$(string.RuntimePublisher.GarbageCollectionTaskMessage)">
                        <opcodes>

                            <!-- These opcode use to be 4 through 9 but we added 128 to them to avoid using the reserved range 0-10 -->
                            <opcode name="GCRestartEEEnd" message="$(string.RuntimePublisher.GCRestartEEEndOpcodeMessage)" symbol="CLR_GC_RESTARTEEEND_OPCODE" value="132"> </opcode>
                            <opcode name="GCHeapStats" message="$(string.RuntimePublisher.GCHeapStatsOpcodeMessage)" symbol="CLR_GC_HEAPSTATS_OPCODE" value="133"> </opcode>
                            <opcode name="GCCreateSegment" message="$(string.RuntimePublisher.GCCreateSegmentOpcodeMessage)" symbol="CLR_GC_CREATESEGMENT_OPCODE" value="134"> </opcode>
                            <opcode name="GCFreeSegment" message="$(string.RuntimePublisher.GCFreeSegmentOpcodeMessage)" symbol="CLR_GC_FREESEGMENT_OPCODE" value="135"> </opcode>
                            <opcode name="GCRestartEEBegin" message="$(string.RuntimePublisher.GCRestartEEBeginOpcodeMessage)" symbol="CLR_GC_RESTARTEEBEING_OPCODE" value="136"> </opcode>
                            <opcode name="GCSuspendEEEnd" message="$(string.RuntimePublisher.GCSuspendEEEndOpcodeMessage)" symbol="CLR_GC_SUSPENDEEND_OPCODE" value="137"> </opcode>
                            <opcode name="GCSuspendEEBegin" message="$(string.RuntimePublisher.GCSuspendEEBeginOpcodeMessage)" symbol="CLR_GC_SUSPENDEEBEGIN_OPCODE" value="10"> </opcode>
                            <opcode name="GCAllocationTick" message="$(string.RuntimePublisher.GCAllocationTickOpcodeMessage)" symbol="CLR_GC_ALLOCATIONTICK_OPCODE" value="11"> </opcode>
                            <opcode name="GCCreateConcurrentThread" message="$(string.RuntimePublisher.GCCreateConcurrentThreadOpcodeMessage)" symbol="CLR_GC_CREATECONCURRENTTHREAD_OPCODE" value="12"> </opcode>
                            <opcode name="GCTerminateConcurrentThread" message="$(string.RuntimePublisher.GCTerminateConcurrentThreadOpcodeMessage)" symbol="CLR_GC_TERMINATECONCURRENTTHREAD_OPCODE" value="13"> </opcode>
                            <opcode name="GCFinalizersEnd" message="$(string.RuntimePublisher.GCFinalizersEndOpcodeMessage)" symbol="CLR_GC_FINALIZERSEND_OPCODE" value="15"> </opcode>
                            <opcode name="GCFinalizersBegin" message="$(string.RuntimePublisher.GCFinalizersBeginOpcodeMessage)" symbol="CLR_GC_FINALIZERSBEGIN_OPCODE" value="19"> </opcode>
                            <opcode name="GCBulkRootEdge" message="$(string.RuntimePublisher.GCBulkRootEdgeOpcodeMessage)" symbol="CLR_GC_BULKROOTEDGE_OPCODE" value="20"> </opcode>
                            <opcode name="GCBulkRootConditionalWeakTableElementEdge" message="$(string.RuntimePublisher.GCBulkRootConditionalWeakTableElementEdgeOpcodeMessage)" symbol="CLR_GC_BULKROOTCONDITIONALWEAKTABLEELEMENTEDGE_OPCODE" value="21"> </opcode>
                            <opcode name="GCBulkNode" message="$(string.RuntimePublisher.GCBulkNodeOpcodeMessage)" symbol="CLR_GC_BULKNODE_OPCODE" value="22"> </opcode>
                            <opcode name="GCBulkEdge" message="$(string.RuntimePublisher.GCBulkEdgeOpcodeMessage)" symbol="CLR_GC_BULKEDGE_OPCODE" value="23"> </opcode>
                            <opcode name="GCSampledObjectAllocation" message="$(string.RuntimePublisher.GCSampledObjectAllocationOpcodeMessage)" symbol="CLR_GC_OBJECTALLOCATION_OPCODE" value="24"> </opcode>
                            <opcode name="GCBulkSurvivingObjectRanges" message="$(string.RuntimePublisher.GCBulkSurvivingObjectRangesOpcodeMessage)" symbol="CLR_GC_BULKSURVIVINGOBJECTRANGES_OPCODE" value="25"> </opcode>
                            <opcode name="GCBulkMovedObjectRanges" message="$(string.RuntimePublisher.GCBulkMovedObjectRangesOpcodeMessage)" symbol="CLR_GC_BULKMOVEDOBJECTRANGES_OPCODE" value="26"> </opcode>
                            <opcode name="GCGenerationRange" message="$(string.RuntimePublisher.GCGenerationRangeOpcodeMessage)" symbol="CLR_GC_GENERATIONRANGE_OPCODE" value="27"> </opcode>
                            <opcode name="GCMarkStackRoots" message="$(string.RuntimePublisher.GCMarkStackRootsOpcodeMessage)" symbol="CLR_GC_MARKSTACKROOTS_OPCODE" value="28"> </opcode>
                            <opcode name="GCMarkFinalizeQueueRoots" message="$(string.RuntimePublisher.GCMarkFinalizeQueueRootsOpcodeMessage)" symbol="CLR_GC_MARKFINALIZEQUEUEROOTS_OPCODE" value="29"> </opcode>
                            <opcode name="GCMarkHandles" message="$(string.RuntimePublisher.GCMarkHandlesOpcodeMessage)" symbol="CLR_GC_MARKHANDLES_OPCODE" value="30"> </opcode>
                            <opcode name="GCMarkOlderGenerationRoots" message="$(string.RuntimePublisher.GCMarkOlderGenerationRootsOpcodeMessage)" symbol="CLR_GC_MARKCARDS_OPCODE" value="31"> </opcode>
                            <opcode name="FinalizeObject" message="$(string.RuntimePublisher.FinalizeObjectOpcodeMessage)" symbol="CLR_GC_FINALIZEOBJECT_OPCODE" value="32"> </opcode>
                            <opcode name="SetGCHandle" message="$(string.RuntimePublisher.SetGCHandleOpcodeMessage)" symbol="CLR_GC_SETGCHANDLE_OPCODE" value="33"> </opcode>
                            <opcode name="DestroyGCHandle" message="$(string.RuntimePublisher.DestroyGCHandleOpcodeMessage)" symbol="CLR_GC_DESTROYGCHANDLE_OPCODE" value="34"> </opcode>
                            <opcode name="Triggered" message="$(string.RuntimePublisher.TriggeredOpcodeMessage)" symbol="CLR_GC_TRIGGERED_OPCODE" value="35"> </opcode>
                            <opcode name="PinObjectAtGCTime" message="$(string.RuntimePublisher.PinObjectAtGCTimeOpcodeMessage)" symbol="CLR_GC_PINGCOBJECT_OPCODE" value="36"> </opcode>
                            <opcode name="GCBulkRootCCW" message="$(string.RuntimePublisher.GCBulkRootCCWOpcodeMessage)" symbol="CLR_GC_BULKROOTCCW_OPCODE" value="38"> </opcode>
                            <opcode name="GCBulkRCW" message="$(string.RuntimePublisher.GCBulkRCWOpcodeMessage)" symbol="CLR_GC_BULKRCW_OPCODE" value="39"> </opcode>
                            <opcode name="GCBulkRootStaticVar" message="$(string.RuntimePublisher.GCBulkRootStaticVarOpcodeMessage)" symbol="CLR_GC_BULKROOTSTATICVAR_OPCODE" value="40"> </opcode>
                            <opcode name="GCDynamicEvent" message="$(string.RuntimePublisher.GCDynamicEventOpcodeMessage)" symbol="CLR_GC_DYNAMICEVENT_OPCODE" value="41"> </opcode>
                            <opcode name="IncreaseMemoryPressure" message="$(string.RuntimePublisher.IncreaseMemoryPressureOpcodeMessage)" symbol="CLR_GC_INCREASEMEMORYPRESSURE_OPCODE" value="200"> </opcode>
                            <opcode name="DecreaseMemoryPressure" message="$(string.RuntimePublisher.DecreaseMemoryPressureOpcodeMessage)" symbol="CLR_GC_DECREASEMEMORYPRESSURE_OPCODE" value="201"> </opcode>
                            <opcode name="GCMarkWithType" message="$(string.RuntimePublisher.GCMarkOpcodeMessage)" symbol="CLR_GC_MARK_OPCODE" value="202"> </opcode>
                            <opcode name="GCJoin" message="$(string.RuntimePublisher.GCJoinOpcodeMessage)" symbol="CLR_GC_JOIN_OPCODE" value="203"> </opcode>
                            <opcode name="GCPerHeapHistory" message="$(string.RuntimePublisher.GCPerHeapHistoryOpcodeMessage)" symbol="CLR_GC_GCPERHEAPHISTORY_OPCODE" value="204"> </opcode>
                            <opcode name="GCGlobalHeapHistory" message="$(string.RuntimePublisher.GCGlobalHeapHistoryOpcodeMessage)" symbol="CLR_GC_GCGLOBALHEAPHISTORY_OPCODE" value="205"> </opcode>
                        </opcodes>
                    </task>

                    <task name="WorkerThreadCreation" symbol="CLR_WORKERTHREADCREATE_TASK"
                          value="2" eventGUID="{cfc4ba53-fb42-4757-8b70-5f5d51fee2f4}"
                          message="$(string.RuntimePublisher.WorkerThreadCreationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="IOThreadCreation" symbol="CLR_IOTHREADCREATE_TASK"
                          value="3" eventGUID="{c71408de-42cc-4f81-9c93-b8912abf2a0f}"
                          message="$(string.RuntimePublisher.IOThreadCreationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="WorkerThreadRetirement" symbol="CLR_WORKERTHREADRETIRE_TASK"
                          value="4" eventGUID="{efdf1eac-1d5d-4e84-893a-19b80f692176}"
                          message="$(string.RuntimePublisher.WorkerThreadRetirementTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="IOThreadRetirement" symbol="CLR_IOTHREADRETIRE_TASK"
                          value="5" eventGUID="{840c8456-6457-4eb7-9cd0-d28f01c64f5e}"
                          message="$(string.RuntimePublisher.IOThreadRetirementTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="ThreadpoolSuspension" symbol="CLR_THREADPOOLSUSPEND_TASK"
                          value="6" eventGUID="{c424b3e3-2ae0-416e-a039-410c5d8e5f14}"
                          message="$(string.RuntimePublisher.ThreadpoolSuspensionTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="Exception" symbol="CLR_EXCEPTION_TASK"
                          value="7" eventGUID="{300ce105-86d1-41f8-b9d2-83fcbff32d99}"
                          message="$(string.RuntimePublisher.ExceptionTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="ExceptionCatch" symbol="CLR_EXCEPTION_CATCH_TASK"
                          value="27" eventGUID="{5BBF9499-1715-4658-88DC-AFD7690A8711}"
                          message="$(string.RuntimePublisher.ExceptionCatchTaskMessage)">
                      <opcodes>
                      </opcodes>
                    </task>

                    <task name="ExceptionFinally" symbol="CLR_EXCEPTION_FINALLY_TASK"
                          value="28" eventGUID="{9565BC31-300F-4EA2-A532-30BCE9A14199}"
                          message="$(string.RuntimePublisher.ExceptionFinallyTaskMessage)">
                      <opcodes>
                      </opcodes>
                    </task>

                    <task name="ExceptionFilter" symbol="CLR_EXCEPTION_FILTER_TASK"
                          value="29" eventGUID="{72E72606-BB71-4290-A242-D5F36CE5312E}"
                          message="$(string.RuntimePublisher.ExceptionFilterTaskMessage)">
                      <opcodes>
                      </opcodes>
                    </task>

                  <task name="Contention" symbol="CLR_CONTENTION_TASK"
                          value="8" eventGUID="{561410f5-a138-4ab3-945e-516483cddfbc}"
                          message="$(string.RuntimePublisher.ContentionTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="CLRMethod" symbol="CLR_METHOD_TASK"
                          value="9" eventGUID="{3044F61A-99B0-4c21-B203-D39423C73B00}"
                          message="$(string.RuntimePublisher.MethodTaskMessage)">
                        <opcodes>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="DCStartComplete" message="$(string.RuntimePublisher.DCStartCompleteOpcodeMessage)" symbol="CLR_METHOD_DCSTARTCOMPLETE_OPCODE" value="14"> </opcode>
                            <opcode name="DCEndComplete" message="$(string.RuntimePublisher.DCEndCompleteOpcodeMessage)" symbol="CLR_METHOD_DCENDCOMPLETE_OPCODE" value="15"> </opcode>
                            <opcode name="MethodLoad" message="$(string.RuntimePublisher.MethodLoadOpcodeMessage)" symbol="CLR_METHOD_METHODLOAD_OPCODE" value="33"> </opcode>
                            <opcode name="MethodUnload" message="$(string.RuntimePublisher.MethodUnloadOpcodeMessage)" symbol="CLR_METHOD_METHODUNLOAD_OPCODE" value="34"> </opcode>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="MethodDCStart" message="$(string.RuntimePublisher.MethodDCStartOpcodeMessage)" symbol="CLR_METHOD_METHODDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="MethodDCEnd" message="$(string.RuntimePublisher.MethodDCEndOpcodeMessage)" symbol="CLR_METHOD_METHODDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="MethodLoadVerbose" message="$(string.RuntimePublisher.MethodLoadVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODLOADVERBOSE_OPCODE" value="37"> </opcode>
                            <opcode name="MethodUnloadVerbose" message="$(string.RuntimePublisher.MethodUnloadVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODUNLOADVERBOSE_OPCODE" value="38"> </opcode>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="MethodDCStartVerbose" message="$(string.RuntimePublisher.MethodDCStartVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODDCSTARTVERBOSE_OPCODE" value="39"> </opcode>
                            <opcode name="MethodDCEndVerbose" message="$(string.RuntimePublisher.MethodDCEndVerboseOpcodeMessage)" symbol="CLR_METHOD_METHODDCENDVERBOSE_OPCODE" value="40"> </opcode>
                            <opcode name="MethodJittingStarted" message="$(string.RuntimePublisher.MethodJittingStartedOpcodeMessage)" symbol="CLR_METHOD_METHODJITTINGSTARTED_OPCODE" value="42"> </opcode>
                            <opcode name="JitInliningSucceeded" message="$(string.RuntimePublisher.JitInliningSucceededOpcodeMessage)" symbol="CLR_JITINLININGSUCCEEDED_OPCODE" value="83"> </opcode>
                            <opcode name="JitInliningFailed" message="$(string.RuntimePublisher.JitInliningFailedOpcodeMessage)" symbol="CLR_JITINLININGFAILED_OPCODE" value="84"> </opcode>
                            <opcode name="JitTailCallSucceeded" message="$(string.RuntimePublisher.JitTailCallSucceededOpcodeMessage)" symbol="CLR_JITTAILCALLSUCCEEDED_OPCODE" value="85"> </opcode>
                            <opcode name="JitTailCallFailed" message="$(string.RuntimePublisher.JitTailCallFailedOpcodeMessage)" symbol="CLR_JITTAILCALLFAILED_OPCODE" value="86"> </opcode>
                            <opcode name="MethodILToNativeMap" message="$(string.RuntimePublisher.MethodILToNativeMapOpcodeMessage)" symbol="CLR_METHODILTONATIVEMAP_OPCODE" value="87"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRLoader" symbol="CLR_LOADER_TASK"
                          value="10" eventGUID="{D00792DA-07B7-40f5-97EB-5D974E054740}"
                          message="$(string.RuntimePublisher.LoaderTaskMessage)">
                        <opcodes>
                            <opcode name="DomainModuleLoad" message="$(string.RuntimePublisher.DomainModuleLoadOpcodeMessage)" symbol="CLR_DOMAINMODULELOAD_OPCODE" value="45"> </opcode>
                            <opcode name="ModuleLoad" message="$(string.RuntimePublisher.ModuleLoadOpcodeMessage)" symbol="CLR_MODULELOAD_OPCODE" value="33"> </opcode>
                            <opcode name="ModuleUnload" message="$(string.RuntimePublisher.ModuleUnloadOpcodeMessage)" symbol="CLR_MODULEUNLOAD_OPCODE" value="34"> </opcode>
                            <!-- The following 2 opcodes are now defunct -->
                            <opcode name="ModuleDCStart" message="$(string.RuntimePublisher.ModuleDCStartOpcodeMessage)" symbol="CLR_MODULEDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="ModuleDCEnd" message="$(string.RuntimePublisher.ModuleDCEndOpcodeMessage)" symbol="CLR_MODULEDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="AssemblyLoad" message="$(string.RuntimePublisher.AssemblyLoadOpcodeMessage)" symbol="CLR_ASSEMBLYLOAD_OPCODE" value="37"> </opcode>
                            <opcode name="AssemblyUnload" message="$(string.RuntimePublisher.AssemblyUnloadOpcodeMessage)" symbol="CLR_ASSEMBLYUNLOAD_OPCODE" value="38"> </opcode>
                            <opcode name="AppDomainLoad" message="$(string.RuntimePublisher.AppDomainLoadOpcodeMessage)" symbol="CLR_APPDOMAINLOAD_OPCODE" value="41"> </opcode>
                            <opcode name="AppDomainUnload" message="$(string.RuntimePublisher.AppDomainUnloadOpcodeMessage)" symbol="CLR_APPDOMAINUNLOAD_OPCODE" value="42"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRStack" symbol="CLR_STACK_TASK"
                          value="11" eventGUID="{d3363dc0-243a-4620-a4d0-8a07d772f533}"
                          message="$(string.RuntimePublisher.StackTaskMessage)" >
                        <opcodes>
                            <opcode name="CLRStackWalk" message="$(string.RuntimePublisher.CLRStackWalkOpcodeMessage)" symbol="CLR_STACK_STACKWALK_OPCODE" value="82"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRStrongNameVerification" symbol="CLR_STRONGNAMEVERIFICATION_TASK"
                          value="12" eventGUID="{15447A14-B523-46ae-B75B-023F900B4393}"
                          message="$(string.RuntimePublisher.StrongNameVerificationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="CLRAuthenticodeVerification" symbol="CLR_AUTHENTICODEVERIFICATION_TASK"
                          value="13" eventGUID="{B17304D9-5AFA-4da6-9F7B-5A4FA73129B6}"
                          message="$(string.RuntimePublisher.AuthenticodeVerificationTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="AppDomainResourceManagement" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_TASK"
                          value="14" eventGUID="{88e83959-6185-4e0b-95b8-0e4a35df6122}"
                          message="$(string.RuntimePublisher.AppDomainResourceManagementTaskMessage)">
                        <opcodes>

                            <opcode name="AppDomainMemAllocated" message="$(string.RuntimePublisher.AppDomainMemAllocatedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_APPDOMAINMEMALLOCATED_OPCODE" value="48"> </opcode>
                            <opcode name="AppDomainMemSurvived" message="$(string.RuntimePublisher.AppDomainMemSurvivedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_APPDOMAINMEMSURVIVED_OPCODE" value="49"> </opcode>
                            <opcode name="ThreadCreated" message="$(string.RuntimePublisher.ThreadCreatedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_THREADCREATED_OPCODE" value="50"> </opcode>
                            <opcode name="ThreadTerminated" message="$(string.RuntimePublisher.ThreadTerminatedOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_THREADTERMINATED_OPCODE" value="51"> </opcode>
                            <opcode name="ThreadDomainEnter" message="$(string.RuntimePublisher.ThreadDomainEnterOpcodeMessage)" symbol="CLR_APPDOMAINRESOURCEMANAGEMENT_THREADDOMAINENTER_OPCODE" value="52"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRILStub" symbol="CLR_IL_STUB"
                          value="15" eventGUID="{D00792DA-07B7-40f5-0000-5D974E054740}"
                          message="$(string.RuntimePublisher.ILStubTaskMessage)">
                        <opcodes>
                            <opcode name="ILStubGenerated" message="$(string.RuntimePublisher.ILStubGeneratedOpcodeMessage)" symbol="CLR_ILSTUB_ILSTUBGENERATED_OPCODE" value="88"> </opcode>
                            <opcode name="ILStubCacheHit" message="$(string.RuntimePublisher.ILStubCacheHitOpcodeMessage)" symbol="CLR_ILSTUB_ILSTUBCACHEHIT_OPCODE" value="89"> </opcode>
                        </opcodes>
                    </task>

                    <task name="ThreadPoolWorkerThread" symbol="CLR_THREADPOOLWORKERTHREAD_TASK"
                          value="16" eventGUID="{8a9a44ab-f681-4271-8810-830dab9f5621}"
                          message="$(string.RuntimePublisher.ThreadPoolWorkerThreadTaskMessage)">
                        <opcodes>
                            <opcode name="Wait" message="$(string.RuntimePublisher.WaitOpcodeMessage)" symbol="CLR_WAIT_OPCODE" value="90"> </opcode>
                        </opcodes>
                    </task>

                    <task name="ThreadPoolWorkerThreadRetirement" symbol="CLR_THREADPOOLWORKERTHREADRETIREMENT_TASK"
                          value="17" eventGUID="{402ee399-c137-4dc0-a5ab-3c2dea64ac9c}"
                          message="$(string.RuntimePublisher.ThreadPoolWorkerThreadRetirementTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="ThreadPoolWorkerThreadAdjustment" symbol="CLR_THREADPOOLWORKERTHREADADJUSTMENT_TASK"
                          value="18" eventGUID="{94179831-e99a-4625-8824-23ca5e00ca7d}"
                          message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentTaskMessage)">
                        <opcodes>
                            <opcode name="Sample" message="$(string.RuntimePublisher.SampleOpcodeMessage)" symbol="CLR_THREADPOOL_WORKERTHREADADJUSTMENT_SAMPLE_OPCODE"  value="100"> </opcode>
                            <opcode name="Adjustment" message="$(string.RuntimePublisher.AdjustmentOpcodeMessage)" symbol="CLR_THREADPOOL_WORKERTHREADADJUSTMENT_ADJUSTMENT_OPCODE" value="101"> </opcode>
                            <opcode name="Stats" message="$(string.RuntimePublisher.StatsOpcodeMessage)" symbol="CLR_THREADPOOL_WORKERTHREADADJUSTMENT_STATS_OPCODE" value="102"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRRuntimeInformation" symbol="CLR_EEStartup_TASK"
                          value="19" eventGUID="{CD7D3E32-65FE-40cd-9225-A2577D203FC3}"
                          message="$(string.RuntimePublisher.EEStartupTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="CLRPerfTrack" symbol="CLR_PERFTRACK_TASK"
                          value="20" eventGUID="{EAC685F6-2104-4dec-88FD-91E4254221EC}"
                          message="$(string.RuntimePublisher.PerfTrackTaskMessage)">
                      <opcodes>
                        <opcode name="ModuleRangeLoad" message="$(string.RuntimePublisher.ModuleRangeLoadOpcodeMessage)" symbol="CLR_PERFTRACK_MODULERANGELOAD_OPCODE" value="10"> </opcode>
                      </opcodes>
                    </task>
                    <task name="Type" symbol="CLR_TYPE_TASK"
                          value="21" eventGUID="{003E5A9B-4757-4d3e-B4A1-E47BFB489408}"
                          message="$(string.RuntimePublisher.TypeTaskMessage)">
                      <opcodes>
                        <opcode name="BulkType" message="$(string.RuntimePublisher.BulkTypeOpcodeMessage)" symbol="CLR_BULKTYPE_OPCODE" value="10"> </opcode>
                      </opcodes>
                    </task>
                    <task name="ThreadPoolWorkingThreadCount" symbol="CLR_THREADPOOLWORKINGTHREADCOUNT_TASK"
                          value="22" eventGUID="{1b032b96-767c-42e4-8481-cb528a66d7bd}"
                          message="$(string.RuntimePublisher.ThreadPoolWorkingThreadCountTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="ThreadPool" symbol="CLR_THREADPOOL_TASK"
                          value="23" eventGUID="{EAD685F6-2104-4dec-88FD-91E4254221E9}"
                          message="$(string.RuntimePublisher.ThreadPoolTaskMessage)">
                        <opcodes>
                            <opcode name="Enqueue" message="$(string.RuntimePublisher.EnqueueOpcodeMessage)" symbol="CLR_ENQUEUE_OPCODE" value="11"> </opcode>
                            <opcode name="Dequeue" message="$(string.RuntimePublisher.DequeueOpcodeMessage)" symbol="CLR_DEQUEUE_OPCODE" value="12"> </opcode>
                            <opcode name="IOEnqueue" message="$(string.RuntimePublisher.IOEnqueueOpcodeMessage)" symbol="CLR_IOENQUEUE_OPCODE" value="13"> </opcode>
                            <opcode name="IODequeue" message="$(string.RuntimePublisher.IODequeueOpcodeMessage)" symbol="CLR_IODEQUEUE_OPCODE" value="14"> </opcode>
                            <opcode name="IOPack" message="$(string.RuntimePublisher.IOPackOpcodeMessage)" symbol="CLR_IOPACK_OPCODE" value="15"> </opcode>
                        </opcodes>
                    </task>
                    <task name="Thread" symbol="CLR_THREADING_TASK"
                          value="24" eventGUID="{641994C5-16F2-4123-91A7-A2999DD7BFC3}"
                          message="$(string.RuntimePublisher.ThreadTaskMessage)">
                        <opcodes>
                            <opcode name="Creating" message="$(string.RuntimePublisher.ThreadCreatingOpcodeMessage)" symbol="CLR_THREAD_CREATING_OPCODE" value="11"> </opcode>
                            <opcode name="Running" message="$(string.RuntimePublisher.ThreadRunningOpcodeMessage)" symbol="CLR_THREAD_RUNNING_OPCODE" value="12"> </opcode>
                        </opcodes>
                    </task>
                    <task name="DebugIPCEvent" symbol="CLR_DEBUG_IPC_EVENT_TASK"
                          value="25" eventGUID="{EC2F3703-8321-4301-BD51-2CB9A09F31B1}"
                          message="$(string.RuntimePublisher.DebugIPCEventTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="DebugExceptionProcessing" symbol="CLR_EXCEPTION_PROCESSING_TASK"
                          value="26" eventGUID="{C4412198-EF03-47F1-9BD1-11C6637A2062}"
                          message="$(string.RuntimePublisher.DebugExceptionProcessingTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="CodeSymbols" symbol="CLR_CODE_SYMBOLS_TASK"
                          value="30" eventGUID="{53aedf69-2049-4f7d-9345-d3018b5c4d80}"
                          message="$(string.RuntimePublisher.CodeSymbolsTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>
                    <task name="TieredCompilation" symbol="CLR_TIERED_COMPILATION_TASK"
                          value="31" eventGUID="{A77F474D-9D0D-4311-B98E-CFBCF84B9E0F}"
                          message="$(string.RuntimePublisher.TieredCompilationTaskMessage)">
                        <opcodes>
                            <opcode name="Settings" message="$(string.RuntimePublisher.TieredCompilationSettingsOpcodeMessage)" symbol="CLR_TIERED_COMPILATION_SETTINGS_OPCODE" value="11"/>
                            <opcode name="Pause" message="$(string.RuntimePublisher.TieredCompilationPauseOpcodeMessage)" symbol="CLR_TIERED_COMPILATION_PAUSE_OPCODE" value="12"/>
                            <opcode name="Resume" message="$(string.RuntimePublisher.TieredCompilationResumeOpcodeMessage)" symbol="CLR_TIERED_COMPILATION_RESUME_OPCODE" value="13"/>
                        </opcodes>
                    </task>
                <!--Next available ID is 32-->
                </tasks>
                <!--Maps-->
                <maps>
                    <!-- ValueMaps -->
                    <valueMap name="GCSegmentTypeMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCSegment.SmallObjectHeapMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCSegment.LargeObjectHeapMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCSegment.ReadOnlyHeapMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCAllocationKindMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCAllocation.SmallMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCAllocation.LargeMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCTypeMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCType.NonConcurrentGCMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCType.BackgroundGCMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCType.ForegroundGCMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCReasonMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCReason.AllocSmallMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCReason.InducedMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCReason.LowMemoryMapMessage)"/>
                        <map value="0x3" message="$(string.RuntimePublisher.GCReason.EmptyMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.GCReason.AllocLargeMapMessage)"/>
                        <map value="0x5" message="$(string.RuntimePublisher.GCReason.OutOfSpaceSmallObjectHeapMapMessage)"/>
                        <map value="0x6" message="$(string.RuntimePublisher.GCReason.OutOfSpaceLargeObjectHeapMapMessage)"/>
                        <map value="0x7" message="$(string.RuntimePublisher.GCReason.InducedNoForceMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.GCReason.StressMapMessage)"/>
                        <map value="0x9" message="$(string.RuntimePublisher.GCReason.InducedLowMemoryMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCSuspendEEReasonMap">
                        <map value="0x0" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendOtherMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForGCMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForAppDomainShutdownMapMessage)"/>
                        <map value="0x3" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForCodePitchingMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForShutdownMapMessage)"/>
                        <map value="0x5" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerMapMessage)"/>
                        <map value="0x6" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForGCPrepMapMessage)"/>
                        <map value="0x7" message="$(string.RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerSweepMapMessage)"/>
                    </valueMap>
                    <valueMap name="ContentionFlagsMap">
                        <map value="0x0" message="$(string.RuntimePublisher.Contention.ManagedMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.Contention.NativeMapMessage)"/>
                    </valueMap>
                    <valueMap name="TailCallTypeMap">
                        <map value="0x0" message="$(string.RuntimePublisher.TailCallType.OptimizedMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.TailCallType.RecursiveMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.TailCallType.HelperMapMessage)"/>
                    </valueMap>
                    <valueMap name="ThreadAdjustmentReasonMap">
                        <map value="0x0" message="$(string.RuntimePublisher.ThreadAdjustmentReason.WarmupMapMessage)"/>
                        <map value="0x1" message="$(string.RuntimePublisher.ThreadAdjustmentReason.InitializingMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.ThreadAdjustmentReason.RandomMoveMapMessage)"/>
                        <map value="0x3" message="$(string.RuntimePublisher.ThreadAdjustmentReason.ClimbingMoveMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.ThreadAdjustmentReason.ChangePointMapMessage)"/>
                        <map value="0x5" message="$(string.RuntimePublisher.ThreadAdjustmentReason.StabilizingMapMessage)"/>
                        <map value="0x6" message="$(string.RuntimePublisher.ThreadAdjustmentReason.StarvationMapMessage)"/>
                        <map value="0x7" message="$(string.RuntimePublisher.ThreadAdjustmentReason.ThreadTimedOutMapMessage)"/>
                    </valueMap>
                    <valueMap name="GCRootKindMap">
                        <map value="0" message="$(string.RuntimePublisher.GCRootKind.Stack)"/>
                        <map value="1" message="$(string.RuntimePublisher.GCRootKind.Finalizer)"/>
                        <map value="2" message="$(string.RuntimePublisher.GCRootKind.Handle)"/>
                        <map value="3" message="$(string.RuntimePublisher.GCRootKind.Older)"/>
                        <map value="4" message="$(string.RuntimePublisher.GCRootKind.SizedRef)"/>
                        <map value="5" message="$(string.RuntimePublisher.GCRootKind.Overflow)"/>
                    </valueMap>
                    <valueMap name="GCHandleKindMap">
                      <map value="0x0" message="$(string.RuntimePublisher.GCHandleKind.WeakShortMessage)"/>
                      <map value="0x1" message="$(string.RuntimePublisher.GCHandleKind.WeakLongMessage)"/>
                      <map value="0x2" message="$(string.RuntimePublisher.GCHandleKind.StrongMessage)"/>
                      <map value="0x3" message="$(string.RuntimePublisher.GCHandleKind.PinnedMessage)"/>
                      <map value="0x4" message="$(string.RuntimePublisher.GCHandleKind.VariableMessage)"/>
                      <map value="0x5" message="$(string.RuntimePublisher.GCHandleKind.RefCountedMessage)"/>
                      <map value="0x6" message="$(string.RuntimePublisher.GCHandleKind.DependentMessage)"/>
                      <map value="0x7" message="$(string.RuntimePublisher.GCHandleKind.AsyncPinnedMessage)"/>
                      <map value="0x8" message="$(string.RuntimePublisher.GCHandleKind.SizedRefMessage)"/>
                    </valueMap>

                    <!-- BitMaps -->
                    <bitMap name="ModuleRangeTypeMap">
                        <map value="0x4" message="$(string.RuntimePublisher.ModuleRangeTypeMap.ColdRangeMessage)"/>
                    </bitMap>

                    <bitMap name="AppDomainFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.AppDomain.DefaultMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.AppDomain.ExecutableMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.AppDomain.SharedMapMessage)"/>
                    </bitMap>
                    <bitMap name="AssemblyFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.Assembly.DomainNeutralMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.Assembly.DynamicMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.Assembly.NativeMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.Assembly.CollectibleMapMessage)"/>
                    </bitMap>
                    <bitMap name="ModuleFlagsMap">
                        <map value= "0x1" message="$(string.RuntimePublisher.Module.DomainNeutralMapMessage)"/>
                        <map value= "0x2" message="$(string.RuntimePublisher.Module.NativeMapMessage)"/>
                        <map value= "0x4" message="$(string.RuntimePublisher.Module.DynamicMapMessage)"/>
                        <map value= "0x8" message="$(string.RuntimePublisher.Module.ManifestMapMessage)"/>
                        <map value= "0x10" message="$(string.RuntimePublisher.Module.IbcOptimizedMapMessage)"/>
                        <map value= "0x20" message="$(string.RuntimePublisher.Module.ReadyToRunModuleMapMessage)"/>
                        <map value= "0x40" message="$(string.RuntimePublisher.Module.PartialReadyToRunModuleMapMessage)"/>
                    </bitMap>
                    <bitMap name="MethodFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.Method.DynamicMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.Method.GenericMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.Method.HasSharedGenericCodeMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.Method.JittedMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.Method.JitHelperMapMessage)"/>
                        <map value="0x20" message="$(string.RuntimePublisher.Method.ProfilerRejectedPrecompiledCodeMapMessage)"/>
                        <map value="0x40" message="$(string.RuntimePublisher.Method.ReadyToRunRejectedPrecompiledCodeMapMessage)"/>
                        <!-- 0x80 to 0x200 are used for the optimization tier -->
                    </bitMap>
                    <bitMap name="StartupModeMap">
                        <map value="0x1" message="$(string.RuntimePublisher.StartupMode.ManagedExeMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.StartupMode.HostedCLRMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.StartupMode.IjwDllMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.StartupMode.ComActivatedMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.StartupMode.OtherMapMessage)"/>
                    </bitMap>
                    <bitMap name="RuntimeSkuMap">
                        <map value="0x1" message="$(string.RuntimePublisher.RuntimeSku.DesktopCLRMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.RuntimeSku.CoreCLRMapMessage)"/>
                    </bitMap>
                    <bitMap name="ExceptionThrownFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.ExceptionThrown.HasInnerExceptionMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.ExceptionThrown.NestedMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.ExceptionThrown.ReThrownMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.ExceptionThrown.CorruptedStateMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.ExceptionThrown.CLSCompliantMapMessage)"/>
                    </bitMap>
                    <bitMap name="ILStubGeneratedFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.ILStubGenerated.ReverseInteropMapMessage)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.ILStubGenerated.COMInteropMapMessage)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.ILStubGenerated.NGenedStubMapMessage)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.ILStubGenerated.DelegateMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.ILStubGenerated.VarArgMapMessage)"/>
                        <map value="0x20" message="$(string.RuntimePublisher.ILStubGenerated.UnmanagedCalleeMapMessage)"/>
                    </bitMap>
                    <bitMap name="StartupFlagsMap">
                        <map value="0x000001" message="$(string.RuntimePublisher.Startup.CONCURRENT_GCMapMessage)"/>
                        <map value="0x000002" message="$(string.RuntimePublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage)"/>
                        <map value="0x000004" message="$(string.RuntimePublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage)"/>
                        <map value="0x000010" message="$(string.RuntimePublisher.Startup.LOADER_SAFEMODEMapMessage)"/>
                        <map value="0x000100" message="$(string.RuntimePublisher.Startup.LOADER_SETPREFERENCEMapMessage)"/>
                        <map value="0x001000" message="$(string.RuntimePublisher.Startup.SERVER_GCMapMessage)"/>
                        <map value="0x002000" message="$(string.RuntimePublisher.Startup.HOARD_GC_VMMapMessage)"/>
                        <map value="0x004000" message="$(string.RuntimePublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage)"/>
                        <map value="0x010000" message="$(string.RuntimePublisher.Startup.LEGACY_IMPERSONATIONMapMessage)"/>
                        <map value="0x020000" message="$(string.RuntimePublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage)"/>
                        <map value="0x040000" message="$(string.RuntimePublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage)"/>
                        <map value="0x080000" message="$(string.RuntimePublisher.Startup.TRIM_GC_COMMITMapMessage)"/>
                        <map value="0x100000" message="$(string.RuntimePublisher.Startup.ETWMapMessage)"/>
                        <map value="0x200000" message="$(string.RuntimePublisher.Startup.SERVER_BUILDMapMessage)"/>
                        <map value="0x400000" message="$(string.RuntimePublisher.Startup.ARMMapMessage)"/>
                    </bitMap>
                    <bitMap name="TypeFlagsMap">
                        <map value="0x1" message="$(string.RuntimePublisher.TypeFlags.Delegate)"/>
                        <map value="0x2" message="$(string.RuntimePublisher.TypeFlags.Finalizable)"/>
                        <map value="0x4" message="$(string.RuntimePublisher.TypeFlags.ExternallyImplementedCOMObject)"/>
                        <map value="0x8" message="$(string.RuntimePublisher.TypeFlags.Array)"/>
                    </bitMap>
                    <bitMap name="GCRootFlagsMap">
                      <map value="0x1" message="$(string.RuntimePublisher.GCRootFlags.Pinning)"/>
                      <map value="0x2" message="$(string.RuntimePublisher.GCRootFlags.WeakRef)"/>
                      <map value="0x4" message="$(string.RuntimePublisher.GCRootFlags.Interior)"/>
                      <map value="0x8" message="$(string.RuntimePublisher.GCRootFlags.RefCounted)"/>
                    </bitMap>
                    <bitMap name="GCRootStaticVarFlagsMap">
                      <map value="0x1" message="$(string.RuntimePublisher.GCRootStaticVarFlags.ThreadLocal)"/>
                    </bitMap>
                    <bitMap name="GCRootCCWFlagsMap">
                      <map value="0x1" message="$(string.RuntimePublisher.GCRootCCWFlags.Strong)"/>
                      <map value="0x2" message="$(string.RuntimePublisher.GCRootCCWFlags.Pegged)"/>
                    </bitMap>
                    <bitMap name="ThreadFlagsMap">
                      <map value="0x1" message="$(string.RuntimePublisher.ThreadFlags.GCSpecial)"/>
                      <map value="0x2" message="$(string.RuntimePublisher.ThreadFlags.Finalizer)"/>
                      <map value="0x4" message="$(string.RuntimePublisher.ThreadFlags.ThreadPoolWorker)"/>
                    </bitMap>
                    <bitMap name="TieredCompilationSettingsFlagsMap">
                      <map value="0x0" message="$(string.RuntimePublisher.TieredCompilationSettingsFlags.NoneMapMessage)"/>
                      <map value="0x1" message="$(string.RuntimePublisher.TieredCompilationSettingsFlags.QuickJitMapMessage)"/>
                      <map value="0x2" message="$(string.RuntimePublisher.TieredCompilationSettingsFlags.QuickJitForLoopsMapMessage)"/>
                    </bitMap>
                </maps>

                <!--Templates-->
                <templates>
                    <template tid="EventSource">
                        <data name="EventID" inType="win:Int32" />
                        <data name="EventName" inType="win:UnicodeString" />
                        <data name="EventSourceName" inType="win:UnicodeString" />
                        <data name="Payload" inType="win:UnicodeString" />

                        <UserData>
                            <EventSource xmlns="myNs">
                                <EventID> %1 </EventID>
                                <EventName> %2 </EventName>
                                <EventSourceName> %3 </EventSourceName>
                                <Payload> %4 </Payload>
                            </EventSource>
                        </UserData>
                    </template>
                    <template tid="StrongNameVerification">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString" />

                        <UserData>
                            <StrongNameVerification xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <FullyQualifiedAssemblyName> %3 </FullyQualifiedAssemblyName>
                            </StrongNameVerification>
                        </UserData>
                    </template>

                    <template tid="StrongNameVerification_V1">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <StrongNameVerification_V1 xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <FullyQualifiedAssemblyName> %3 </FullyQualifiedAssemblyName>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </StrongNameVerification_V1>
                        </UserData>
                    </template>

                    <template tid="AuthenticodeVerification">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ModulePath" inType="win:UnicodeString" />

                        <UserData>
                            <AuthenticodeVerification xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <ModulePath> %3 </ModulePath>
                            </AuthenticodeVerification>
                        </UserData>
                    </template>

                    <template tid="AuthenticodeVerification_V1">
                        <data name="VerificationFlags" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ErrorCode" inType="win:UInt32" outType="win:HexInt32"/>
                        <data name="ModulePath" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <AuthenticodeVerification_V1 xmlns="myNs">
                                <VerificationFlags> %1 </VerificationFlags>
                                <ErrorCode> %2 </ErrorCode>
                                <ModulePath> %3 </ModulePath>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </AuthenticodeVerification_V1>
                        </UserData>
                    </template>

                    <template tid="RuntimeInformation">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Sku" inType="win:UInt16" map="RuntimeSkuMap" />
                        <data name="BclMajorVersion" inType="win:UInt16" />
                        <data name="BclMinorVersion" inType="win:UInt16" />
                        <data name="BclBuildNumber" inType="win:UInt16" />
                        <data name="BclQfeNumber" inType="win:UInt16" />
                        <data name="VMMajorVersion" inType="win:UInt16" />
                        <data name="VMMinorVersion" inType="win:UInt16" />
                        <data name="VMBuildNumber" inType="win:UInt16" />
                        <data name="VMQfeNumber" inType="win:UInt16" />
                        <data name="StartupFlags" inType="win:UInt32" map="StartupFlagsMap" />
                        <data name="StartupMode" inType="win:UInt8" map="StartupModeMap" />
                        <data name="CommandLine" inType="win:UnicodeString" />
                        <data name="ComObjectGuid" inType="win:GUID" />
                        <data name="RuntimeDllPath" inType="win:UnicodeString" />

                        <UserData>
                            <RuntimeInformation xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <Sku> %2 </Sku>
                                <BclMajorVersion> %3 </BclMajorVersion>
                                <BclMinorVersion> %4 </BclMinorVersion>
                                <BclBuildNumber> %5 </BclBuildNumber>
                                <BclQfeNumber> %6 </BclQfeNumber>
                                <VMMajorVersion> %7 </VMMajorVersion>
                                <VMMinorVersion> %8 </VMMinorVersion>
                                <VMBuildNumber> %9 </VMBuildNumber>
                                <VMQfeNumber> %10 </VMQfeNumber>
                                <StartupFlags> %11 </StartupFlags>
                                <StartupMode> %12 </StartupMode>
                                <CommandLine> %13 </CommandLine>
                                <ComObjectGuid> %14 </ComObjectGuid>
                                <RuntimeDllPath> %15 </RuntimeDllPath>
                            </RuntimeInformation>
                        </UserData>
                    </template>

                    <template tid="GCStart">
                        <data name="Count" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="Reason" inType="win:UInt32" map="GCReasonMap" />

                        <UserData>
                            <GCStart xmlns="myNs">
                                <Count> %1 </Count>
                                <Reason> %2 </Reason>
                            </GCStart>
                        </UserData>
                    </template>

                    <template tid="GCStart_V1">
                        <data name="Count" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="Depth" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="Reason" inType="win:UInt32" map="GCReasonMap" />
                        <data name="Type" inType="win:UInt32" map="GCTypeMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCStart_V1 xmlns="myNs">
                                <Count> %1 </Count>
                                <Depth> %2 </Depth>
                                <Reason> %3 </Reason>
                                <Type> %4 </Type>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </GCStart_V1>
                        </UserData>
                    </template>

                    <template tid="GCStart_V2">
                      <data name="Count" inType="win:UInt32" outType="xs:unsignedInt"/>
                      <data name="Depth" inType="win:UInt32" outType="xs:unsignedInt"/>
                      <data name="Reason" inType="win:UInt32" map="GCReasonMap" />
                      <data name="Type" inType="win:UInt32" map="GCTypeMap" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <data name="ClientSequenceNumber" inType="win:UInt64" />

                      <UserData>
                        <GCStart_V1 xmlns="myNs">
                          <Count> %1 </Count>
                          <Depth> %2 </Depth>
                          <Reason> %3 </Reason>
                          <Type> %4 </Type>
                          <ClrInstanceID> %5 </ClrInstanceID>
                          <ClientSequenceNumber> %6 </ClientSequenceNumber>
                        </GCStart_V1>
                      </UserData>
                    </template>

                    <template tid="GCEnd">
                        <data name="Count" inType="win:UInt32" />
                        <data name="Depth" inType="win:UInt16" />

                        <UserData>
                            <GCEnd xmlns="myNs">
                                <Count> %1 </Count>
                                <Depth> %2 </Depth>
                            </GCEnd>
                        </UserData>
                    </template>

                    <template tid="GCEnd_V1">
                        <data name="Count" inType="win:UInt32" />
                        <data name="Depth" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCEnd_V1 xmlns="myNs">
                                <Count> %1 </Count>
                                <Depth> %2 </Depth>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCEnd_V1>
                        </UserData>
                    </template>

                    <template tid="GCHeapStats">
                        <data name="GenerationSize0" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize0" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationSize1" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize1" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationSize2" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize2" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationSize3" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize3" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="FinalizationPromotedSize" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="FinalizationPromotedCount" inType="win:UInt64" />
                        <data name="PinnedObjectCount" inType="win:UInt32" />
                        <data name="SinkBlockCount" inType="win:UInt32" />
                        <data name="GCHandleCount" inType="win:UInt32" />

                        <UserData>
                            <GCHeapStats xmlns="myNs">
                                <GenerationSize0> %1 </GenerationSize0>
                                <TotalPromotedSize0> %2 </TotalPromotedSize0>
                                <GenerationSize1> %3 </GenerationSize1>
                                <TotalPromotedSize1> %4 </TotalPromotedSize1>
                                <GenerationSize2> %5 </GenerationSize2>
                                <TotalPromotedSize2> %6 </TotalPromotedSize2>
                                <GenerationSize3> %7 </GenerationSize3>
                                <TotalPromotedSize3> %8 </TotalPromotedSize3>
                                <FinalizationPromotedSize> %9 </FinalizationPromotedSize>
                                <FinalizationPromotedCount> %10 </FinalizationPromotedCount>
                                <PinnedObjectCount> %11 </PinnedObjectCount>
                                <SinkBlockCount> %12 </SinkBlockCount>
                                <GCHandleCount> %13 </GCHandleCount>
                            </GCHeapStats>
                        </UserData>
                    </template>

                    <template tid="GCHeapStats_V1">
                        <data name="GenerationSize0" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize0" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationSize1" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize1" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationSize2" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize2" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationSize3" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TotalPromotedSize3" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="FinalizationPromotedSize" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="FinalizationPromotedCount" inType="win:UInt64" />
                        <data name="PinnedObjectCount" inType="win:UInt32" />
                        <data name="SinkBlockCount" inType="win:UInt32" />
                        <data name="GCHandleCount" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCHeapStats_V1 xmlns="myNs">
                                <GenerationSize0> %1 </GenerationSize0>
                                <TotalPromotedSize0> %2 </TotalPromotedSize0>
                                <GenerationSize1> %3 </GenerationSize1>
                                <TotalPromotedSize1> %4 </TotalPromotedSize1>
                                <GenerationSize2> %5 </GenerationSize2>
                                <TotalPromotedSize2> %6 </TotalPromotedSize2>
                                <GenerationSize3> %7 </GenerationSize3>
                                <TotalPromotedSize3> %8 </TotalPromotedSize3>
                                <FinalizationPromotedSize> %9 </FinalizationPromotedSize>
                                <FinalizationPromotedCount> %10 </FinalizationPromotedCount>
                                <PinnedObjectCount> %11 </PinnedObjectCount>
                                <SinkBlockCount> %12 </SinkBlockCount>
                                <GCHandleCount> %13 </GCHandleCount>
                                <ClrInstanceID> %14 </ClrInstanceID>
                            </GCHeapStats_V1>
                        </UserData>
                    </template>

                    <template tid="GCCreateSegment">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Size" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Type" inType="win:UInt32" map="GCSegmentTypeMap" />

                        <UserData>
                            <GCCreateSegment xmlns="myNs">
                                <Address> %1 </Address>
                                <Size> %2 </Size>
                                <Type> %3 </Type>
                            </GCCreateSegment>
                        </UserData>
                    </template>

                    <template tid="GCCreateSegment_V1">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Size" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Type" inType="win:UInt32" map="GCSegmentTypeMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCCreateSegment_V1 xmlns="myNs">
                                <Address> %1 </Address>
                                <Size> %2 </Size>
                                <Type> %3 </Type>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </GCCreateSegment_V1>
                        </UserData>
                    </template>

                    <template tid="GCFreeSegment">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64" />

                        <UserData>
                            <GCFreeSegment xmlns="myNs">
                                <Address> %1 </Address>
                            </GCFreeSegment>
                        </UserData>
                    </template>

                    <template tid="GCFreeSegment_V1">
                        <data name="Address" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCFreeSegment_V1 xmlns="myNs">
                                <Address> %1 </Address>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </GCFreeSegment_V1>
                        </UserData>
                    </template>

                    <template tid="GCNoUserData">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <GCNoUserData xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCNoUserData>
                        </UserData>
                    </template>

                    <template tid="GCSuspendEE">
                        <data name="Reason" inType="win:UInt16" map="GCSuspendEEReasonMap" />

                        <UserData>
                            <GCSuspendEE xmlns="myNs">
                                <Reason> %1 </Reason>
                            </GCSuspendEE>
                        </UserData>
                    </template>

                    <template tid="GCSuspendEE_V1">
                        <data name="Reason" inType="win:UInt32" map="GCSuspendEEReasonMap" />
                        <data name="Count" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCSuspendEE_V1 xmlns="myNs">
                                <Reason> %1 </Reason>
                                <Count> %2 </Count>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCSuspendEE_V1>
                        </UserData>
                    </template>

                    <template tid="GCAllocationTick">
                        <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap" />

                        <UserData>
                            <GCAllocationTick xmlns="myNs">
                                <AllocationAmount> %1 </AllocationAmount>
                                <AllocationKind> %2 </AllocationKind>
                            </GCAllocationTick>
                        </UserData>
                    </template>

                    <template tid="GCAllocationTick_V1">
                        <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCAllocationTick_V1 xmlns="myNs">
                                <AllocationAmount> %1 </AllocationAmount>
                                <AllocationKind> %2 </AllocationKind>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCAllocationTick_V1>
                        </UserData>
                    </template>

                    <template tid="GCAllocationTick_V2">
                        <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="AllocationAmount64" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TypeID" inType="win:Pointer" />
                        <data name="TypeName" inType="win:UnicodeString" />
                        <data name="HeapIndex" inType="win:UInt32" />

                      <UserData>
                            <GCAllocationTick_V2 xmlns="myNs">
                                <AllocationAmount> %1 </AllocationAmount>
                                <AllocationKind> %2 </AllocationKind>
                                <ClrInstanceID> %3 </ClrInstanceID>
                                <AllocationAmount64> %4 </AllocationAmount64>
                                <TypeID> %5 </TypeID>
                                <TypeName> %6 </TypeName>
                                <HeapIndex> %7 </HeapIndex>
                            </GCAllocationTick_V2>
                        </UserData>
                    </template>

                    <template tid="GCAllocationTick_V3">
                      <data name="AllocationAmount" inType="win:UInt32" outType="win:HexInt32" />
                      <data name="AllocationKind" inType="win:UInt32" map="GCAllocationKindMap" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <data name="AllocationAmount64" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="TypeID" inType="win:Pointer" />
                      <data name="TypeName" inType="win:UnicodeString" />
                      <data name="HeapIndex" inType="win:UInt32" />
                      <data name="Address" inType="win:Pointer" />

                      <UserData>
                        <GCAllocationTick_V3 xmlns="myNs">
                          <AllocationAmount> %1 </AllocationAmount>
                          <AllocationKind> %2 </AllocationKind>
                          <ClrInstanceID> %3 </ClrInstanceID>
                          <AllocationAmount64> %4 </AllocationAmount64>
                          <TypeID> %5 </TypeID>
                          <TypeName> %6 </TypeName>
                          <HeapIndex> %7 </HeapIndex>
                          <Address> %8 </Address>
                        </GCAllocationTick_V3>
                      </UserData>
                  </template>

                  <template tid="GCCreateConcurrentThread">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <GCCreateConcurrentThread xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCCreateConcurrentThread>
                        </UserData>
                    </template>

                    <template tid="GCTerminateConcurrentThread">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <GCTerminateConcurrentThread xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCTerminateConcurrentThread>
                        </UserData>
                    </template>

                    <template tid="GCFinalizersEnd">
                        <data name="Count" inType="win:UInt32" />
                        <UserData>
                            <GCFinalizersEnd xmlns="myNs">
                                <Count> %1 </Count>
                            </GCFinalizersEnd>
                        </UserData>
                    </template>

                    <template tid="GCFinalizersEnd_V1">
                        <data name="Count" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <GCFinalizersEnd_V1 xmlns="myNs">
                                <Count> %1 </Count>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </GCFinalizersEnd_V1>
                        </UserData>
                    </template>

                    <template tid="GCMark">
                      <data name="HeapNum" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />

                      <UserData>
                        <GCMark xmlns="myNs">
                          <HeapNum> %1 </HeapNum>
                          <ClrInstanceID> %2 </ClrInstanceID>
                        </GCMark>
                      </UserData>
                    </template>

                    <template tid="GCMarkWithType">
                      <data name="HeapNum" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <data name="Type" inType="win:UInt32" map="GCRootKindMap" />
                      <data name="Bytes" inType="win:UInt64" />

                      <UserData>
                        <GCMarkWithType xmlns="myNs">
                          <HeapNum> %1 </HeapNum>
                          <ClrInstanceID> %2 </ClrInstanceID>
                          <Type> %3 </Type>
                          <Bytes> %4 </Bytes>
                        </GCMarkWithType>
                      </UserData>
                    </template>

                    <template tid="GCJoin_V2">
                        <data name="Heap" inType="win:UInt32" />
                        <data name="JoinTime" inType="win:UInt32" />
                        <data name="JoinType" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="JoinID" inType="win:UInt32" />

                        <UserData>
                            <GCJoin_V2 xmlns="myNs">
                                <Heap> %1 </Heap>
                                <JoinTime> %2 </JoinTime>
                                <JoinType> %3 </JoinType>
                                <ClrInstanceID> %4 </ClrInstanceID>
                                <JoinID> %5 </JoinID>
                            </GCJoin_V2>
                        </UserData>
                    </template>

                    <template tid="GCPerHeapHistory_V3">
                        <data name="ClrInstanceID" inType="win:UInt16" />
     					<data name="FreeListAllocated" inType="win:Pointer" outType="win:HexInt64" />
     					<data name="FreeListRejected" inType="win:Pointer" outType="win:HexInt64" />
     					<data name="EndOfSegAllocated" inType="win:Pointer" outType="win:HexInt64" />
     					<data name="CondemnedAllocated" inType="win:Pointer" outType="win:HexInt64" />
     					<data name="PinnedAllocated" inType="win:Pointer" outType="win:HexInt64" />
     					<data name="PinnedAllocatedAdvance" inType="win:Pointer" outType="win:HexInt64" />
     					<data name="RunningFreeListEfficiency" inType="win:UInt32" />
     					<data name="CondemnReasons0" inType="win:UInt32" />
     					<data name="CondemnReasons1" inType="win:UInt32" />
     					<data name="CompactMechanisms" inType="win:UInt32" />
     					<data name="ExpandMechanisms" inType="win:UInt32" />
     					<data name="HeapIndex" inType="win:UInt32" />
     					<data name="ExtraGen0Commit" inType="win:Pointer" outType="win:HexInt64" />
                        <data name="Count" inType="win:UInt32"    />
                        <struct name="Values"   count="Count"  >
							<data name="SizeBefore" inType="win:Pointer" outType="win:HexInt64" />
							<data name="FreeListBefore" inType="win:Pointer" outType="win:HexInt64" />
							<data name="FreeObjBefore" inType="win:Pointer" outType="win:HexInt64" />
							<data name="SizeAfter" inType="win:Pointer" outType="win:HexInt64" />
							<data name="FreeListAfter" inType="win:Pointer" outType="win:HexInt64" />
							<data name="FreeObjAfter" inType="win:Pointer" outType="win:HexInt64" />
							<data name="In" inType="win:Pointer" outType="win:HexInt64" />
							<data name="PinnedSurv" inType="win:Pointer" outType="win:HexInt64" />
							<data name="NonePinnedSurv" inType="win:Pointer" outType="win:HexInt64" />
							<data name="NewAllocation" inType="win:Pointer" outType="win:HexInt64" />
                        </struct>
                        <UserData>
                            <GCPerHeapHistory_V3 xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <FreeListAllocated> %2 </FreeListAllocated>
                                <FreeListRejected> %3 </FreeListRejected>
                                <EndOfSegAllocated> %4 </EndOfSegAllocated>
                                <CondemnedAllocated> %5 </CondemnedAllocated>
                                <PinnedAllocated> %6 </PinnedAllocated>
                                <PinnedAllocatedAdvance> %7 </PinnedAllocatedAdvance>
                                <RunningFreeListEfficiency> %8 </RunningFreeListEfficiency>
                                <CondemnReasons0> %9 </CondemnReasons0>
                                <CondemnReasons1> %10 </CondemnReasons1>
                                <CompactMechanisms> %11 </CompactMechanisms>
                                <ExpandMechanisms> %12 </ExpandMechanisms>
                                <HeapIndex> %13 </HeapIndex>
                                <ExtraGen0Commit> %14 </ExtraGen0Commit>
                                <Count> %15 </Count>
                            </GCPerHeapHistory_V3>
                        </UserData>
                    </template>

                    <template tid="GCGlobalHeap_V2">
                        <data name="FinalYoungestDesired" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="NumHeaps" inType="win:Int32" />
                        <data name="CondemnedGeneration" inType="win:UInt32" />
                        <data name="Gen0ReductionCount" inType="win:UInt32" />
                        <data name="Reason" inType="win:UInt32" />
                        <data name="GlobalMechanisms" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="PauseMode" inType="win:UInt32" />
                        <data name="MemoryPressure" inType="win:UInt32" />

                        <UserData>
                            <GCGlobalHeap_V2 xmlns="myNs">
                                <FinalYoungestDesired> %1 </FinalYoungestDesired>
                                <NumHeaps> %2 </NumHeaps>
                                <CondemnedGeneration> %3 </CondemnedGeneration>
                                <Gen0ReductionCount> %4 </Gen0ReductionCount>
                                <Reason> %5 </Reason>
                                <GlobalMechanisms> %6 </GlobalMechanisms>
                                <ClrInstanceID> %7 </ClrInstanceID>
                                <PauseMode> %8 </PauseMode>
                                <MemoryPressure> %9 </MemoryPressure>
                            </GCGlobalHeap_V2>
                        </UserData>
                    </template>

                    <template tid="FinalizeObject">
                      <data name="TypeID" inType="win:Pointer" />
                      <data name="ObjectID" inType="win:Pointer" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <FinalizeObject xmlns="myNs">
                          <TypeID> %1 </TypeID>
                          <ObjectID> %2 </ObjectID>
                          <ClrInstanceID> %3 </ClrInstanceID>
                        </FinalizeObject>
                      </UserData>
                    </template>

                    <template tid="DestroyGCHandle">
                      <data name="HandleID" inType="win:Pointer" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <DestroyGCHandle xmlns="myNs">
                          <HandleID> %1 </HandleID>
                          <ClrInstanceID> %2 </ClrInstanceID>
                        </DestroyGCHandle>
                      </UserData>
                    </template>

                    <template tid="SetGCHandle">
                      <data name="HandleID" inType="win:Pointer" />
                      <data name="ObjectID" inType="win:Pointer" />
                      <data name="Kind" map="GCHandleKindMap" inType="win:UInt32" />
                      <data name="Generation" inType="win:UInt32" />
                      <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <SetGCHandle xmlns="myNs">
                          <HandleID> %1 </HandleID>
                          <ObjectID> %2 </ObjectID>
                          <Kind> %3 </Kind>
                          <Generation> %4 </Generation>
                          <AppDomainID> %5 </AppDomainID>
                          <ClrInstanceID> %6 </ClrInstanceID>
                        </SetGCHandle>
                      </UserData>
                    </template>

                    <template tid="GCTriggered">
                        <data name="Reason" inType="win:UInt32" map="GCReasonMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCTriggered xmlns="myNs">
                                <Reason> %1 </Reason>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </GCTriggered>
                        </UserData>
                    </template>

                    <template tid="PinObjectAtGCTime">
                        <data name="HandleID" inType="win:Pointer" />
                        <data name="ObjectID" inType="win:Pointer" />
                        <data name="ObjectSize" inType="win:UInt64" />
                        <data name="TypeName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="GCDynamicEvent">
                        <data name="Name" inType="win:UnicodeString" />
                        <data name="DataSize" inType="win:UInt32" />
                        <data name="Data" inType="win:Binary" length="DataSize" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="IncreaseMemoryPressure">
                        <data name="BytesAllocated" inType="win:UInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="DecreaseMemoryPressure">
                        <data name="BytesFreed" inType="win:UInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="ClrWorkerThread">
                        <data name="WorkerThreadCount" inType="win:UInt32" />
                        <data name="RetiredWorkerThreads" inType="win:UInt32" />

                        <UserData>
                            <WorkerThread xmlns="myNs">
                                <WorkerThreadCount> %1 </WorkerThreadCount>
                                <RetiredWorkerThreads> %2 </RetiredWorkerThreads>
                            </WorkerThread>
                        </UserData>
                    </template>

                    <template tid="IOThread">
                        <data name="IOThreadCount" inType="win:UInt32" />
                        <data name="RetiredIOThreads" inType="win:UInt32" />

                        <UserData>
                            <IOThread xmlns="myNs">
                                <IOThreadCount> %1 </IOThreadCount>
                                <RetiredIOThreads> %2 </RetiredIOThreads>
                            </IOThread>
                        </UserData>
                    </template>

                    <template tid="IOThread_V1">
                        <data name="IOThreadCount" inType="win:UInt32" />
                        <data name="RetiredIOThreads" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <IOThread_V1 xmlns="myNs">
                                <IOThreadCount> %1 </IOThreadCount>
                                <RetiredIOThreads> %2 </RetiredIOThreads>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </IOThread_V1>
                        </UserData>
                    </template>

                    <template tid="ClrThreadPoolSuspend">
                        <data name="ClrThreadID" inType="win:UInt32" />
                        <data name="CpuUtilization" inType="win:UInt32" />

                        <UserData>
                            <CLRThreadPoolSuspend xmlns="myNs">
                                <ClrThreadID> %1 </ClrThreadID>
                                <CpuUtilization> %2 </CpuUtilization>
                            </CLRThreadPoolSuspend>
                        </UserData>
                    </template>

                    <template tid="ThreadPoolWorkerThread">
                        <data name="ActiveWorkerThreadCount" inType="win:UInt32" />
                        <data name="RetiredWorkerThreadCount" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadPoolWorkerThread xmlns="myNs">
                                <ActiveWorkerThreadCount> %1 </ActiveWorkerThreadCount>
                                <RetiredWorkerThreadCount> %2 </RetiredWorkerThreadCount>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </ThreadPoolWorkerThread>
                        </UserData>
                    </template>

                    <template tid="ThreadPoolWorkerThreadAdjustmentSample">
                        <data name="Throughput" inType="win:Double" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadPoolWorkerThreadAdjustmentSample xmlns="myNs">
                                <Throughput> %1 </Throughput>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </ThreadPoolWorkerThreadAdjustmentSample>
                        </UserData>
                    </template>

                    <template tid="ThreadPoolWorkerThreadAdjustmentAdjustment">
                        <data name="AverageThroughput" inType="win:Double" />
                        <data name="NewWorkerThreadCount" inType="win:UInt32" />
                        <data name="Reason" inType="win:UInt32" map="ThreadAdjustmentReasonMap"/>
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadPoolWorkerThreadAdjustmentAdjustment xmlns="myNs">
                                <AverageThroughput> %1 </AverageThroughput>
                                <NewWorkerThreadCount> %2 </NewWorkerThreadCount>
                                <Reason> %3 </Reason>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </ThreadPoolWorkerThreadAdjustmentAdjustment>
                        </UserData>
                    </template>

                    <template tid="ThreadPoolWorkerThreadAdjustmentStats">
                        <data name="Duration" inType="win:Double" />
                        <data name="Throughput" inType="win:Double" />
                        <data name="ThreadWave" inType="win:Double"/>
                        <data name="ThroughputWave" inType="win:Double"/>
                        <data name="ThroughputErrorEstimate" inType="win:Double"/>
                        <data name="AverageThroughputErrorEstimate" inType="win:Double"/>
                        <data name="ThroughputRatio" inType="win:Double" />
                        <data name="Confidence" inType="win:Double" />
                        <data name="NewControlSetting" inType="win:Double" />
                        <data name="NewThreadWaveMagnitude" inType="win:UInt16" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadPoolWorkerThreadAdjustmentStats xmlns="myNs">
                                <Duration> %1 </Duration>
                                <Throughput> %2 </Throughput>
                                <ThreadWave> %3 </ThreadWave>
                                <ThroughputWave> %4 </ThroughputWave>
                                <ThroughputErrorEstimate> %5 </ThroughputErrorEstimate>
                                <AverageThroughputErrorEstimate> %6 </AverageThroughputErrorEstimate>
                                <ThroughputRatio> %7 </ThroughputRatio>
                                <Confidence> %8 </Confidence>
                                <NewControlSetting> %9 </NewControlSetting>
                                <NewThreadWaveMagnitude> %10 </NewThreadWaveMagnitude>
                                <ClrInstanceID> %11 </ClrInstanceID>
                            </ThreadPoolWorkerThreadAdjustmentStats>
                        </UserData>
                    </template>

                    <template tid="ThreadPoolWork">
                        <data name="WorkID" inType="win:Pointer" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="ThreadPoolIOWork">
                        <data name="NativeOverlapped" inType="win:Pointer" />
                        <data name="Overlapped" inType="win:Pointer" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="ThreadPoolIOWorkEnqueue">
                        <data name="NativeOverlapped" inType="win:Pointer" />
                        <data name="Overlapped" inType="win:Pointer" />
                        <data name="MultiDequeues" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="ThreadPoolWorkingThreadCount">
                        <data name="Count" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadPoolWorkingThreadCount xmlns="myNs">
                                <Count> %1 </Count>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </ThreadPoolWorkingThreadCount>
                        </UserData>
                    </template>

                    <template tid="ThreadStartWork">
                        <data name="ID" inType="win:Pointer" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="Exception">
                        <data name="ExceptionType" inType="win:UnicodeString" />
                        <data name="ExceptionMessage" inType="win:UnicodeString" />
                        <data name="ExceptionEIP" inType="win:Pointer" />
                        <data name="ExceptionHRESULT" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="ExceptionFlags" inType="win:UInt16" map="ExceptionThrownFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <Exception xmlns="myNs">
                                <ExceptionType> %1 </ExceptionType>
                                <ExceptionMessage> %2 </ExceptionMessage>
                                <ExceptionEIP> %3 </ExceptionEIP>
                                <ExceptionHRESULT> %4 </ExceptionHRESULT>
                                <ExceptionFlags> %5 </ExceptionFlags>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </Exception>
                        </UserData>
                    </template>

                    <template tid="ExceptionHandling">
                        <data name="EntryEIP" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <ExceptionHandling xmlns="myNs">
                                <EntryEIP> %1 </EntryEIP>
                                <MethodID> %2 </MethodID>
                                <MethodName> %3 </MethodName>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </ExceptionHandling>
                        </UserData>
                    </template>

                    <template tid="Contention">
                        <data name="ContentionFlags" inType="win:UInt8" map="ContentionFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <Contention xmlns="myNs">
                                <ContentionFlags> %1 </ContentionFlags>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </Contention>
                        </UserData>
                    </template>

                    <template tid="ContentionStop_V1">
                        <data name="ContentionFlags" inType="win:UInt8" map="ContentionFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="DurationNs" inType="win:Double" />
                        <UserData>
                            <Contention xmlns="myNs">
                                <ContentionFlags> %1 </ContentionFlags>
                                <ClrInstanceID> %2 </ClrInstanceID>
                                <DurationNs> %3 </DurationNs>
                            </Contention>
                        </UserData>
                    </template>

                    <template tid="DomainModuleLoadUnload">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />
                        <UserData>
                            <DomainModuleLoadUnload xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                            </DomainModuleLoadUnload>
                        </UserData>
                    </template>

                    <template tid="DomainModuleLoadUnload_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <DomainModuleLoadUnload_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </DomainModuleLoadUnload_V1>
                        </UserData>
                    </template>

                    <template tid="ModuleLoadUnload">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />
                        <UserData>
                            <ModuleLoadUnload xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                            </ModuleLoadUnload>
                        </UserData>
                    </template>

                    <template tid="ModuleLoadUnload_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <ModuleLoadUnload_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ModuleLoadUnload_V1>
                        </UserData>
                    </template>

                  <template tid="ModuleLoadUnload_V2">
                      <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                      <data name="Reserved1"   inType="win:UInt32" />
                      <data name="ModuleILPath" inType="win:UnicodeString" />
                      <data name="ModuleNativePath" inType="win:UnicodeString" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <data name="ManagedPdbSignature" inType="win:GUID" />
                      <data name="ManagedPdbAge" inType="win:UInt32" />
                      <data name="ManagedPdbBuildPath" inType="win:UnicodeString" />
                      <data name="NativePdbSignature" inType="win:GUID" />
                      <data name="NativePdbAge" inType="win:UInt32" />
                      <data name="NativePdbBuildPath" inType="win:UnicodeString" />
                    <UserData>
                          <ModuleLoadUnload_V2 xmlns="myNs">
                              <ModuleID> %1 </ModuleID>
                              <AssemblyID> %2 </AssemblyID>
                              <ModuleFlags> %3 </ModuleFlags>
                              <ModuleILPath> %4 </ModuleILPath>
                              <ModuleNativePath> %5 </ModuleNativePath>
                              <ClrInstanceID> %6 </ClrInstanceID>
                              <ManagedPdbSignature> %7 </ManagedPdbSignature>
                              <ManagedPdbAge> %8 </ManagedPdbAge>
                              <ManagedPdbBuildPath> %9 </ManagedPdbBuildPath>
                              <NativePdbSignature> %10 </NativePdbSignature>
                              <NativePdbAge> %11 </NativePdbAge>
                              <NativePdbBuildPath> %12 </NativePdbBuildPath>
                          </ModuleLoadUnload_V2>
                      </UserData>
                  </template>

                    <template tid="AssemblyLoadUnload">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap" />
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString" />
                        <UserData>
                            <AssemblyLoadUnload xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <AssemblyFlags> %3 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %4 </FullyQualifiedAssemblyName>
                            </AssemblyLoadUnload>
                        </UserData>
                    </template>

                    <template tid="AssemblyLoadUnload_V1">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="BindingID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap" />
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <AssemblyLoadUnload_V1 xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <BindingID> %3 </BindingID>
                                <AssemblyFlags> %4 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %5 </FullyQualifiedAssemblyName>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </AssemblyLoadUnload_V1>
                        </UserData>
                    </template>

                    <template tid="AppDomainLoadUnload">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap" />
                        <data name="AppDomainName" inType="win:UnicodeString" />
                        <UserData>
                            <AppDomainLoadUnload xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                            </AppDomainLoadUnload>
                        </UserData>
                    </template>

                    <template tid="AppDomainLoadUnload_V1">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap" />
                        <data name="AppDomainName" inType="win:UnicodeString" />
                        <data name="AppDomainIndex" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <AppDomainLoadUnload_V1 xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                                <AppDomainIndex> %4 </AppDomainIndex>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </AppDomainLoadUnload_V1>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnload">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />

                        <UserData>
                            <MethodLoadUnload xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                            </MethodLoadUnload>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnload_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodLoadUnload_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </MethodLoadUnload_V1>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnload_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64" />

                        <UserData>
                            <MethodLoadUnload_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                                <ReJITID> %8 </ReJITID>
                            </MethodLoadUnload_V2>
                        </UserData>
                    </template>

                    <template tid="R2RGetEntryPoint">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <data name="EntryPoint" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <R2RGetEntryPoint xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <MethodNamespace> %2 </MethodNamespace>
                                <MethodName> %3 </MethodName>
                                <MethodSignature> %4 </MethodSignature>
                                <EntryPoint> %5 </EntryPoint>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </R2RGetEntryPoint>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadVerbose">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <UserData>
                            <MethodLoadUnloadVerbose xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                            </MethodLoadUnloadVerbose>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadVerbose_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <MethodLoadUnloadVerbose_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                            </MethodLoadUnloadVerbose_V1>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadVerbose_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64" />
                      <UserData>
                          <MethodLoadUnloadVerbose_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                                <ReJITID> %11 </ReJITID>
                            </MethodLoadUnloadVerbose_V2>
                        </UserData>
                    </template>

                    <template tid="MethodJittingStarted">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodILSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />

                        <UserData>
                            <MethodJittingStarted xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodToken> %3 </MethodToken>
                                <MethodILSize> %4 </MethodILSize>
                                <MethodNamespace> %5 </MethodNamespace>
                                <MethodName> %6 </MethodName>
                                <MethodSignature> %7 </MethodSignature>
                            </MethodJittingStarted>
                        </UserData>
                    </template>

                    <template tid="MethodJittingStarted_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodILSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJittingStarted_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodToken> %3 </MethodToken>
                                <MethodILSize> %4 </MethodILSize>
                                <MethodNamespace> %5 </MethodNamespace>
                                <MethodName> %6 </MethodName>
                                <MethodSignature> %7 </MethodSignature>
                                <ClrInstanceID> %8 </ClrInstanceID>
                            </MethodJittingStarted_V1>
                        </UserData>
                    </template>

                    <template tid="MethodJitInliningSucceeded">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString" />
                        <data name="InlinerNamespace" inType="win:UnicodeString" />
                        <data name="InlinerName" inType="win:UnicodeString" />
                        <data name="InlinerNameSignature" inType="win:UnicodeString" />
                        <data name="InlineeNamespace" inType="win:UnicodeString" />
                        <data name="InlineeName" inType="win:UnicodeString" />
                        <data name="InlineeNameSignature" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJitInliningSucceeded xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <InlinerNamespace> %4 </InlinerNamespace>
                                <InlinerName> %5 </InlinerName>
                                <InlinerNameSignature> %6 </InlinerNameSignature>
                                <InlineeNamespace> %7 </InlineeNamespace>
                                <InlineeName> %8 </InlineeName>
                                <InlineeNameSignature> %9 </InlineeNameSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                            </MethodJitInliningSucceeded>
                        </UserData>
                    </template>

                    <template tid="MethodJitInliningFailed">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString" />
                        <data name="InlinerNamespace" inType="win:UnicodeString" />
                        <data name="InlinerName" inType="win:UnicodeString" />
                        <data name="InlinerNameSignature" inType="win:UnicodeString" />
                        <data name="InlineeNamespace" inType="win:UnicodeString" />
                        <data name="InlineeName" inType="win:UnicodeString" />
                        <data name="InlineeNameSignature" inType="win:UnicodeString" />
                        <data name="FailAlways" inType="win:Boolean" />
                        <data name="FailReason" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJitInliningFailed xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <InlinerNamespace> %4 </InlinerNamespace>
                                <InlinerName> %5 </InlinerName>
                                <InlinerNameSignature> %6 </InlinerNameSignature>
                                <InlineeNamespace> %7 </InlineeNamespace>
                                <InlineeName> %8 </InlineeName>
                                <InlineeNameSignature> %9 </InlineeNameSignature>
                                <FailAlways> %10 </FailAlways>
                                <FailReason> %11 </FailReason>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitInliningFailed>
                        </UserData>
                    </template>

                    <template tid="MethodJitInliningFailedAnsi">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString" />
                        <data name="InlinerNamespace" inType="win:UnicodeString" />
                        <data name="InlinerName" inType="win:UnicodeString" />
                        <data name="InlinerNameSignature" inType="win:UnicodeString" />
                        <data name="InlineeNamespace" inType="win:UnicodeString" />
                        <data name="InlineeName" inType="win:UnicodeString" />
                        <data name="InlineeNameSignature" inType="win:UnicodeString" />
                        <data name="FailAlways" inType="win:Boolean" />
                        <data name="FailReason" inType="win:AnsiString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJitInliningFailedAnsi xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <InlinerNamespace> %4 </InlinerNamespace>
                                <InlinerName> %5 </InlinerName>
                                <InlinerNameSignature> %6 </InlinerNameSignature>
                                <InlineeNamespace> %7 </InlineeNamespace>
                                <InlineeName> %8 </InlineeName>
                                <InlineeNameSignature> %9 </InlineeNameSignature>
                                <FailAlways> %10 </FailAlways>
                                <FailReason> %11 </FailReason>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitInliningFailedAnsi>
                        </UserData>
                    </template>

                    <template tid="MethodJitTailCallSucceeded">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString" />
                        <data name="CallerNamespace" inType="win:UnicodeString" />
                        <data name="CallerName" inType="win:UnicodeString" />
                        <data name="CallerNameSignature" inType="win:UnicodeString" />
                        <data name="CalleeNamespace" inType="win:UnicodeString" />
                        <data name="CalleeName" inType="win:UnicodeString" />
                        <data name="CalleeNameSignature" inType="win:UnicodeString" />
                        <data name="TailPrefix" inType="win:Boolean" />
                        <data name="TailCallType" inType="win:UInt32" map="TailCallTypeMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJitTailCallSucceeded xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <CallerNamespace> %4 </CallerNamespace>
                                <CallerName> %5 </CallerName>
                                <CallerNameSignature> %6 </CallerNameSignature>
                                <CalleeNamespace> %7 </CalleeNamespace>
                                <CalleeName> %8 </CalleeName>
                                <CalleeNameSignature> %9 </CalleeNameSignature>
                                <TailPrefix> %10 </TailPrefix>
                                <TailCallType> %11 </TailCallType>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitTailCallSucceeded>
                        </UserData>
                    </template>

                    <template tid="MethodJitTailCallFailed">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString" />
                        <data name="CallerNamespace" inType="win:UnicodeString" />
                        <data name="CallerName" inType="win:UnicodeString" />
                        <data name="CallerNameSignature" inType="win:UnicodeString" />
                        <data name="CalleeNamespace" inType="win:UnicodeString" />
                        <data name="CalleeName" inType="win:UnicodeString" />
                        <data name="CalleeNameSignature" inType="win:UnicodeString" />
                        <data name="TailPrefix" inType="win:Boolean" />
                        <data name="FailReason" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJitTailCallFailed xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <CallerNamespace> %4 </CallerNamespace>
                                <CallerName> %5 </CallerName>
                                <CallerNameSignature> %6 </CallerNameSignature>
                                <CalleeNamespace> %7 </CalleeNamespace>
                                <CalleeName> %8 </CalleeName>
                                <CalleeNameSignature> %9 </CalleeNameSignature>
                                <TailPrefix> %10 </TailPrefix>
                                <FailReason> %11 </FailReason>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitTailCallFailed>
                        </UserData>
                    </template>

                    <template tid="MethodJitTailCallFailedAnsi">
                        <data name="MethodBeingCompiledNamespace" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledName" inType="win:UnicodeString" />
                        <data name="MethodBeingCompiledNameSignature" inType="win:UnicodeString" />
                        <data name="CallerNamespace" inType="win:UnicodeString" />
                        <data name="CallerName" inType="win:UnicodeString" />
                        <data name="CallerNameSignature" inType="win:UnicodeString" />
                        <data name="CalleeNamespace" inType="win:UnicodeString" />
                        <data name="CalleeName" inType="win:UnicodeString" />
                        <data name="CalleeNameSignature" inType="win:UnicodeString" />
                        <data name="TailPrefix" inType="win:Boolean" />
                        <data name="FailReason" inType="win:AnsiString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodJitTailCallFailedAnsi xmlns="myNs">
                                <MethodBeingCompiledNamespace> %1 </MethodBeingCompiledNamespace>
                                <MethodBeingCompiledName> %2 </MethodBeingCompiledName>
                                <MethodBeingCompiledNameSignature> %3 </MethodBeingCompiledNameSignature>
                                <CallerNamespace> %4 </CallerNamespace>
                                <CallerName> %5 </CallerName>
                                <CallerNameSignature> %6 </CallerNameSignature>
                                <CalleeNamespace> %7 </CalleeNamespace>
                                <CalleeName> %8 </CalleeName>
                                <CalleeNameSignature> %9 </CalleeNameSignature>
                                <TailPrefix> %10 </TailPrefix>
                                <FailReason> %11 </FailReason>
                                <ClrInstanceID> %12 </ClrInstanceID>
                            </MethodJitTailCallFailedAnsi>
                        </UserData>
                    </template>

                    <template tid="MethodILToNativeMap">
                      <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="MethodExtent" inType="win:UInt8" />
                      <data name="CountOfMapEntries" inType="win:UInt16" />
                      <data name="ILOffsets" count="CountOfMapEntries" inType="win:UInt32" />
                      <data name="NativeOffsets" count="CountOfMapEntries" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <MethodILToNativeMap xmlns="myNs">
                          <MethodID> %1 </MethodID>
                          <ReJITID> %2 </ReJITID>
                          <MethodExtent> %3 </MethodExtent>
                          <CountOfMapEntries> %4 </CountOfMapEntries>
                          <ClrInstanceID> %5 </ClrInstanceID>
                        </MethodILToNativeMap>
                      </UserData>
                    </template>

                    <template tid="ClrStackWalk">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Reserved1" inType="win:UInt8" />
                        <data name="Reserved2" inType="win:UInt8" />
                        <data name="FrameCount" inType="win:UInt32" />
                        <data name="Stack" count="2" inType="win:Pointer" />
                    </template>

                    <template tid="AppDomainMemAllocated">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Allocated" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <AppDomainMemAllocated xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <Allocated> %2 </Allocated>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </AppDomainMemAllocated>
                        </UserData>
                    </template>

                    <template tid="AppDomainMemSurvived">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Survived" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ProcessSurvived" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <AppDomainMemSurvived xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <Survived> %2 </Survived>
                                <ProcessSurvived> %3 </ProcessSurvived>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </AppDomainMemSurvived>
                        </UserData>
                    </template>

                    <template tid="ThreadCreated">
                        <data name="ManagedThreadID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Flags" inType="win:UInt32" map="ThreadFlagsMap" />
                        <data name="ManagedThreadIndex" inType="win:UInt32" />
                        <data name="OSThreadID" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadCreated xmlns="myNs">
                                <ManagedThreadID> %1 </ManagedThreadID>
                                <AppDomainID> %2 </AppDomainID>
                                <Flags> %3 </Flags>
                                <ManagedThreadIndex> %4 </ManagedThreadIndex>
                                <OSThreadID> %5 </OSThreadID>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ThreadCreated>
                        </UserData>
                    </template>

                    <template tid="ThreadTerminatedOrTransition">
                        <data name="ManagedThreadID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadTerminatedOrTransition xmlns="myNs">
                                <ManagedThreadID> %1 </ManagedThreadID>
                                <AppDomainID> %2 </AppDomainID>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </ThreadTerminatedOrTransition>
                        </UserData>
                    </template>

                    <template tid="ILStubGenerated">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="StubMethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="StubFlags" inType="win:UInt32" map="ILStubGeneratedFlagsMap" />
                        <data name="ManagedInteropMethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="ManagedInteropMethodNamespace" inType="win:UnicodeString" />
                        <data name="ManagedInteropMethodName" inType="win:UnicodeString" />
                        <data name="ManagedInteropMethodSignature" inType="win:UnicodeString" />
                        <data name="NativeMethodSignature" inType="win:UnicodeString" />
                        <data name="StubMethodSignature" inType="win:UnicodeString" />
                        <data name="StubMethodILCode" inType="win:UnicodeString" />
                        <UserData>
                            <ILStubGenerated xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <StubMethodID> %3 </StubMethodID>
                                <StubFlags> %4 </StubFlags>
                                <ManagedInteropMethodToken> %5 </ManagedInteropMethodToken>
                                <ManagedInteropMethodNamespace> %6 </ManagedInteropMethodNamespace>
                                <ManagedInteropMethodName> %7 </ManagedInteropMethodName>
                                <ManagedInteropMethodSignature> %8 </ManagedInteropMethodSignature>
                                <NativeMethodSignature> %9 </NativeMethodSignature>
                                <StubMethodSignature> %10 </StubMethodSignature>
                                <StubMethodILCode> %11 </StubMethodILCode>
                            </ILStubGenerated>
                        </UserData>
                    </template>

                    <template tid="ILStubCacheHit">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="StubMethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ManagedInteropMethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="ManagedInteropMethodNamespace" inType="win:UnicodeString" />
                        <data name="ManagedInteropMethodName" inType="win:UnicodeString" />
                        <data name="ManagedInteropMethodSignature" inType="win:UnicodeString" />
                        <UserData>
                            <ILStubCacheHit xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <StubMethodID> %3 </StubMethodID>
                                <ManagedInteropMethodToken> %4 </ManagedInteropMethodToken>
                                <ManagedInteropMethodNamespace> %5 </ManagedInteropMethodNamespace>
                                <ManagedInteropMethodName> %6 </ManagedInteropMethodName>
                                <ManagedInteropMethodSignature> %7 </ManagedInteropMethodSignature>
                            </ILStubCacheHit>
                        </UserData>
                    </template>

                    <template tid="ModuleRange">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ModuleID" inType="win:UInt64"  outType="win:HexInt64"/>
                        <data name="RangeBegin" inType="win:UInt32"  outType="win:HexInt32"/>
                        <data name="RangeSize" inType="win:UInt32"  outType="win:HexInt32"/>
                        <data name="RangeType" map="ModuleRangeTypeMap" inType="win:UInt8"/>
                        <UserData>
                            <ModuleRange xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <RangeBegin> %3 </RangeBegin>
                                <RangeSize> %4 </RangeSize>
                                <RangeType> %5 </RangeType>
                            </ModuleRange>
                        </UserData>
                    </template>

                    <template tid="BulkType">
                      <data name="Count" inType="win:UInt32"    />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values" count="Count" >
                        <data name="TypeID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TypeNameID" inType="win:UInt32" />
                        <data name="Flags" inType="win:UInt32" map="TypeFlagsMap"/>
                        <data name="CorElementType"  inType="win:UInt8" />
                        <data name="Name" inType="win:UnicodeString" />
                        <data name="TypeParameterCount" inType="win:UInt32" />
                        <data name="TypeParameters"  count="TypeParameterCount"  inType="win:UInt64" outType="win:HexInt64" />
                      </struct>
                      <UserData>
                        <Type xmlns="myNs">
                          <Count> %1 </Count>
                          <ClrInstanceID> %2 </ClrInstanceID>
                        </Type>
                      </UserData>
                    </template>

                    <template tid="GCBulkRootEdge">
                      <data name="Index" inType="win:UInt32"    />
                      <data name="Count" inType="win:UInt32"    />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values"   count="Count"  >
                        <data name="RootedNodeAddress" inType="win:Pointer" />
                        <data name="GCRootKind" inType="win:UInt8"    map="GCRootKindMap" />
                        <data name="GCRootFlag" inType="win:UInt32"   map="GCRootFlagsMap" />
                        <data name="GCRootID" inType="win:Pointer" />
                      </struct>
                      <UserData>
                        <GCBulkRootEdge xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Index> %2 </Index>
                          <Count> %3 </Count>
                        </GCBulkRootEdge>
                      </UserData>
                    </template>

                    <template tid="GCBulkRootCCW">
                      <data name="Count" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values" count="Count" >
                        <data name="GCRootID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ObjectID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TypeID"   inType="win:UInt64" outType="win:HexInt64" />
                        <data name="IUnknown" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="RefCount" inType="win:UInt32"/>
                        <data name="PeggedRefCount" inType="win:UInt32"/>
                        <data name="Flags" inType="win:UInt32" map="GCRootCCWFlagsMap"/>
                      </struct>
                      <UserData>
                        <Type xmlns="myNs">
                          <Count> %1 </Count>
                          <ClrInstanceID> %2 </ClrInstanceID>
                        </Type>
                      </UserData>
                    </template>

                    <template tid="GCBulkRCW">
                      <data name="Count" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values" count="Count" >
                        <data name="ObjectID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TypeID"   inType="win:UInt64" outType="win:HexInt64" />
                        <data name="IUnknown" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="VTable"   inType="win:UInt64" outType="win:HexInt64" />
                        <data name="RefCount" inType="win:UInt32"/>
                        <data name="Flags"    inType="win:UInt32"/>
                      </struct>
                      <UserData>
                        <Type xmlns="myNs">
                          <Count> %1 </Count>
                          <ClrInstanceID> %2 </ClrInstanceID>
                        </Type>
                      </UserData>
                    </template>

                    <template tid="GCBulkRootStaticVar">
                      <data name="Count" inType="win:UInt32" />
                      <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values" count="Count" >
                        <data name="GCRootID"  inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ObjectID"  inType="win:UInt64" outType="win:HexInt64" />
                        <data name="TypeID"    inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Flags"     inType="win:UInt32" map="GCRootStaticVarFlagsMap" />
                        <data name="FieldName" inType="win:UnicodeString" />
                      </struct>
                      <UserData>
                        <Type xmlns="myNs">
                          <Count> %1 </Count>
                          <ClrInstanceID> %2 </ClrInstanceID>
                        </Type>
                      </UserData>
                    </template>

                    <template tid="GCBulkRootConditionalWeakTableElementEdge">
                      <data name="Index" inType="win:UInt32"    />
                      <data name="Count" inType="win:UInt32"    />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct  name="Values"  count="Count"  >
                        <data name="GCKeyNodeID"  inType="win:Pointer" />
                        <data name="GCValueNodeID" inType="win:Pointer"  />
                        <data name="GCRootID" inType="win:Pointer" />
                      </struct>
                      <UserData>
                        <GCBulkRootConditionalWeakTableElementEdge xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Index> %2 </Index>
                          <Count> %3 </Count>
                        </GCBulkRootConditionalWeakTableElementEdge>
                      </UserData>
                    </template>

                    <template tid="GCBulkNode">
                      <data name="Index" inType="win:UInt32"   />
                      <data name="Count" inType="win:UInt32"   />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values"  count="Count"   >
                        <data  name="Address"  inType="win:Pointer" />
                        <data  name="Size"     inType="win:UInt64"  />
                        <data  name="TypeID"   inType="win:UInt64"  />
                        <data  name="EdgeCount" inType="win:UInt64" />
                      </struct>
                      <UserData>
                        <GCBulkNode xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Index> %2 </Index>
                          <Count> %3 </Count>
                        </GCBulkNode>
                      </UserData>
                    </template>

                    <template tid="GCBulkEdge">
                      <data  name="Index" inType="win:UInt32"    />
                      <data  name="Count" inType="win:UInt32"    />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values"  count="Count"   >
                        <data  name="Value"  inType="win:Pointer"  outType="win:HexInt64"  />
                        <data name="ReferencingFieldID" inType="win:UInt32" />
                      </struct>
                      <UserData>
                        <GCBulkEdge xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Index> %2 </Index>
                          <Count> %3 </Count>
                        </GCBulkEdge>
                      </UserData>
                    </template>

                    <template tid="GCSampledObjectAllocation">
                      <data name="Address" inType="win:Pointer"  />
                      <data name="TypeID"  inType="win:Pointer" />
                      <data name="ObjectCountForTypeSample" inType="win:UInt32"  />
                      <data name="TotalSizeForTypeSample" inType="win:UInt64"  />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <GCSampledObjectAllocation xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Address> %2 </Address>
                          <TypeID> %3 </TypeID>
                          <ObjectCountForTypeSample> %4 </ObjectCountForTypeSample>
                          <TotalSizeForTypeSample> %5 </TotalSizeForTypeSample>
                        </GCSampledObjectAllocation>
                      </UserData>
                    </template>

                    <template tid="GCBulkSurvivingObjectRanges">
                      <data  name="Index" inType="win:UInt32"    />
                      <data name="Count" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct  name="Values"  count="Count"  >
                        <data  name="RangeBase" inType="win:Pointer"   outType="win:HexInt64"  />
                        <data  name="RangeLength" inType="win:UInt64"  />
                      </struct>
                      <UserData>
                        <GCBulkSurvivingObjectRanges xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Index> %2 </Index>
                          <Count> %3 </Count>
                        </GCBulkSurvivingObjectRanges>
                      </UserData>
                    </template>

                    <template tid="GCBulkMovedObjectRanges">
                      <data  name="Index" inType="win:UInt32"    />
                      <data name="Count" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <struct name="Values"   count="Count"  >
                        <data   name="OldRangeBase" inType="win:Pointer"  outType="win:HexInt64"  />
                        <data   name="NewRangeBase" inType="win:Pointer"  outType="win:HexInt64"  />
                        <data  name="RangeLength"  inType="win:UInt64"  />
                      </struct>
                      <UserData>
                        <GCBulkMovedObjectRanges xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Index> %2 </Index>
                          <Count> %3 </Count>
                        </GCBulkMovedObjectRanges>
                      </UserData>
                    </template>

                    <template tid="GCGenerationRange">
                      <data name="Generation"           inType="win:UInt8"    />
                      <data name="RangeStart"           inType="win:Pointer" outType="win:HexInt64"  />
                      <data name="RangeUsedLength"      inType="win:UInt64"  />
                      <data name="RangeReservedLength"  inType="win:UInt64"  />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <GCGenerationRange xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Generation> %2 </Generation>
                          <RangeStart> %3 </RangeStart>
                          <RangeUsedLength> %4 </RangeUsedLength>
                          <RangeReservedLength> %5 </RangeReservedLength>
                        </GCGenerationRange>
                      </UserData>
                    </template>

                    <template tid="CodeSymbols">
                      <data name="ModuleId"           inType="win:UInt64"    />
                      <data name="TotalChunks"        inType="win:UInt16"  />
                      <data name="ChunkNumber"        inType="win:UInt16"  />
                      <data name="ChunkLength"        inType="win:UInt32"  />
                      <data name="Chunk"              inType="win:Binary" length="ChunkLength"/>
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <CodeSymbols xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <ModuleId> %2 </ModuleId>
                          <TotalChunks> %3 </TotalChunks>
                          <ChunkNumber> %4 </ChunkNumber>
                          <ChunkLength> %5 </ChunkLength>
                          <Chunk> %6 </Chunk>
                        </CodeSymbols>
                      </UserData>
                    </template>

                    <template tid="TieredCompilationEmpty">
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <UserData>
                        <Settings xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                        </Settings>
                      </UserData>
                    </template>

                    <template tid="TieredCompilationSettings">
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="Flags" inType="win:UInt32" outType="win:HexInt32" map="TieredCompilationSettingsFlagsMap"/>
                      <UserData>
                        <Settings xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Flags> %2 </Flags>
                        </Settings>
                      </UserData>
                    </template>

                    <template tid="TieredCompilationResume">
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="NewMethodCount" inType="win:UInt32"/>
                      <UserData>
                        <Settings xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <NewMethodCount> %2 </NewMethodCount>
                        </Settings>
                      </UserData>
                    </template>

                    <template tid="TieredCompilationBackgroundJitStart">
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="PendingMethodCount" inType="win:UInt32"/>
                      <UserData>
                        <Settings xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <PendingMethodCount> %2 </PendingMethodCount>
                        </Settings>
                      </UserData>
                    </template>

                    <template tid="TieredCompilationBackgroundJitStop">
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="PendingMethodCount" inType="win:UInt32"/>
                      <data name="JittedMethodCount" inType="win:UInt32"/>
                      <UserData>
                        <Settings xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <PendingMethodCount> %2 </PendingMethodCount>
                          <JittedMethodCount> %2 </JittedMethodCount>
                        </Settings>
                      </UserData>
                    </template>
                </templates>

                <events>
                    <!-- CLR GC events, value reserved from 0 to 39 and 200 to 239 -->
                    <!-- Note the opcode's for GC events do include 0 to 9 for backward compatibility, even though
          they don't mean what those predefined opcodes are supposed to mean -->
                    <event value="1" version="0" level="win:Informational"  template="GCStart"
                           keywords="GCKeyword" opcode="win:Start"
                           task="GarbageCollection"
                           symbol="GCStart" message="$(string.RuntimePublisher.GCStartEventMessage)"/>

                    <event value="1" version="1" level="win:Informational"  template="GCStart_V1"
                           keywords="GCKeyword" opcode="win:Start"
                           task="GarbageCollection"
                           symbol="GCStart_V1" message="$(string.RuntimePublisher.GCStart_V1EventMessage)"/>

                    <event value="1" version="2" level="win:Informational"  template="GCStart_V2"
                           keywords="GCKeyword" opcode="win:Start"
                           task="GarbageCollection"
                           symbol="GCStart_V2" message="$(string.RuntimePublisher.GCStart_V2EventMessage)"/>

                    <event value="2" version="0" level="win:Informational"  template="GCEnd"
                           keywords="GCKeyword" opcode="win:Stop"
                           task="GarbageCollection"
                           symbol="GCEnd" message="$(string.RuntimePublisher.GCEndEventMessage)"/>

                    <event value="2" version="1" level="win:Informational"  template="GCEnd_V1"
                           keywords ="GCKeyword" opcode="win:Stop"
                           task="GarbageCollection"
                           symbol="GCEnd_V1" message="$(string.RuntimePublisher.GCEnd_V1EventMessage)"/>

                    <event value="3" version="0" level="win:Informational"
                           keywords ="GCKeyword" opcode="GCRestartEEEnd"
                           task="GarbageCollection"
                           symbol="GCRestartEEEnd" message="$(string.RuntimePublisher.GCRestartEEEndEventMessage)"/>

                    <event value="3" version="1" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCKeyword" opcode="GCRestartEEEnd"
                           task="GarbageCollection"
                           symbol="GCRestartEEEnd_V1" message="$(string.RuntimePublisher.GCRestartEEEnd_V1EventMessage)"/>

                    <event value="4" version="0" level="win:Informational"  template="GCHeapStats"
                           keywords ="GCKeyword" opcode="GCHeapStats"
                           task="GarbageCollection"
                           symbol="GCHeapStats" message="$(string.RuntimePublisher.GCHeapStatsEventMessage)"/>

                    <event value="4" version="1" level="win:Informational"  template="GCHeapStats_V1"
                           keywords ="GCKeyword" opcode="GCHeapStats"
                           task="GarbageCollection"
                           symbol="GCHeapStats_V1" message="$(string.RuntimePublisher.GCHeapStats_V1EventMessage)"/>

                    <event value="5" version="0" level="win:Informational"  template="GCCreateSegment"
                           keywords ="GCKeyword" opcode="GCCreateSegment"
                           task="GarbageCollection"
                           symbol="GCCreateSegment" message="$(string.RuntimePublisher.GCCreateSegmentEventMessage)"/>

                    <event value="5" version="1" level="win:Informational"  template="GCCreateSegment_V1"
                           keywords ="GCKeyword" opcode="GCCreateSegment"
                           task="GarbageCollection"
                           symbol="GCCreateSegment_V1" message="$(string.RuntimePublisher.GCCreateSegment_V1EventMessage)"/>

                    <event value="6" version="0" level="win:Informational"  template="GCFreeSegment"
                           keywords ="GCKeyword"  opcode="GCFreeSegment"
                           task="GarbageCollection"
                           symbol="GCFreeSegment" message="$(string.RuntimePublisher.GCFreeSegmentEventMessage)"/>

                    <event value="6" version="1" level="win:Informational"  template="GCFreeSegment_V1"
                           keywords ="GCKeyword"  opcode="GCFreeSegment"
                           task="GarbageCollection"
                           symbol="GCFreeSegment_V1" message="$(string.RuntimePublisher.GCFreeSegment_V1EventMessage)"/>

                    <event value="7" version="0" level="win:Informational"
                           keywords ="GCKeyword"  opcode="GCRestartEEBegin"
                           task="GarbageCollection"
                           symbol="GCRestartEEBegin" message="$(string.RuntimePublisher.GCRestartEEBeginEventMessage)"/>

                    <event value="7" version="1" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCKeyword"  opcode="GCRestartEEBegin"
                           task="GarbageCollection"
                           symbol="GCRestartEEBegin_V1" message="$(string.RuntimePublisher.GCRestartEEBegin_V1EventMessage)"/>

                    <event value="8" version="0" level="win:Informational"
                           keywords ="GCKeyword"  opcode="GCSuspendEEEnd"
                           task="GarbageCollection"
                           symbol="GCSuspendEEEnd" message="$(string.RuntimePublisher.GCSuspendEEEndEventMessage)"/>

                    <event value="8" version="1" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCKeyword"  opcode="GCSuspendEEEnd"
                           task="GarbageCollection"
                           symbol="GCSuspendEEEnd_V1" message="$(string.RuntimePublisher.GCSuspendEEEnd_V1EventMessage)"/>

                    <event value="9" version="0" level="win:Informational"  template="GCSuspendEE"
                           keywords ="GCKeyword"  opcode="GCSuspendEEBegin"
                           task="GarbageCollection"
                           symbol="GCSuspendEEBegin" message="$(string.RuntimePublisher.GCSuspendEEEventMessage)"/>

                    <event value="9" version="1" level="win:Informational"  template="GCSuspendEE_V1"
                           keywords ="GCKeyword"  opcode="GCSuspendEEBegin"
                           task="GarbageCollection"
                           symbol="GCSuspendEEBegin_V1" message="$(string.RuntimePublisher.GCSuspendEE_V1EventMessage)"/>

                    <event value="10" version="0" level="win:Verbose"  template="GCAllocationTick"
                           keywords="GCKeyword"  opcode="GCAllocationTick"
                           task="GarbageCollection"
                           symbol="GCAllocationTick" message="$(string.RuntimePublisher.GCAllocationTickEventMessage)"/>

                    <event value="10" version="1" level="win:Verbose"  template="GCAllocationTick_V1"
                           keywords="GCKeyword"  opcode="GCAllocationTick"
                           task="GarbageCollection"
                           symbol="GCAllocationTick_V1" message="$(string.RuntimePublisher.GCAllocationTick_V1EventMessage)"/>

                    <event value="10" version="2" level="win:Verbose"  template="GCAllocationTick_V2"
                           keywords="GCKeyword"  opcode="GCAllocationTick"
                           task="GarbageCollection"
                           symbol="GCAllocationTick_V2" message="$(string.RuntimePublisher.GCAllocationTick_V2EventMessage)"/>

                    <event value="10" version="3" level="win:Verbose"  template="GCAllocationTick_V3"
                           keywords="GCKeyword"  opcode="GCAllocationTick"
                           task="GarbageCollection"
                           symbol="GCAllocationTick_V3" message="$(string.RuntimePublisher.GCAllocationTick_V3EventMessage)"/>

                    <event value="11" version="0" level="win:Informational"
                           keywords ="GCKeyword"  opcode="GCCreateConcurrentThread"
                           task="GarbageCollection"
                           symbol="GCCreateConcurrentThread" message="$(string.RuntimePublisher.GCCreateConcurrentThreadEventMessage)"/>

                    <event value="11" version="1" level="win:Informational"  template="GCCreateConcurrentThread"
                           keywords ="GCKeyword ThreadingKeyword"  opcode="GCCreateConcurrentThread"
                           task="GarbageCollection"
                           symbol="GCCreateConcurrentThread_V1" message="$(string.RuntimePublisher.GCCreateConcurrentThread_V1EventMessage)"/>

                    <event value="12" version="0" level="win:Informational"
                           keywords ="GCKeyword"  opcode="GCTerminateConcurrentThread"
                           task="GarbageCollection"
                           symbol="GCTerminateConcurrentThread" message="$(string.RuntimePublisher.GCTerminateConcurrentThreadEventMessage)"/>

                    <event value="12" version="1" level="win:Informational"  template="GCTerminateConcurrentThread"
                           keywords ="GCKeyword ThreadingKeyword"  opcode="GCTerminateConcurrentThread"
                           task="GarbageCollection"
                           symbol="GCTerminateConcurrentThread_V1" message="$(string.RuntimePublisher.GCTerminateConcurrentThread_V1EventMessage)"/>

                    <event value="13" version="0" level="win:Informational"  template="GCFinalizersEnd"
                           keywords ="GCKeyword"  opcode="GCFinalizersEnd"
                           task="GarbageCollection"
                           symbol="GCFinalizersEnd" message="$(string.RuntimePublisher.GCFinalizersEndEventMessage)"/>

                    <event value="13" version="1" level="win:Informational"  template="GCFinalizersEnd_V1"
                           keywords ="GCKeyword"  opcode="GCFinalizersEnd"
                           task="GarbageCollection"
                           symbol="GCFinalizersEnd_V1" message="$(string.RuntimePublisher.GCFinalizersEnd_V1EventMessage)"/>

                    <event value="14" version="0" level="win:Informational"
                           keywords ="GCKeyword"  opcode="GCFinalizersBegin"
                           task="GarbageCollection"
                           symbol="GCFinalizersBegin" message="$(string.RuntimePublisher.GCFinalizersBeginEventMessage)"/>

                    <event value="14" version="1" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCKeyword"  opcode="GCFinalizersBegin"
                           task="GarbageCollection"
                           symbol="GCFinalizersBegin_V1" message="$(string.RuntimePublisher.GCFinalizersBegin_V1EventMessage)"/>

                    <event value="15" version="0" level="win:Informational"  template="BulkType"
                           keywords ="TypeKeyword"  opcode="BulkType"
                           task="Type"
                           symbol="BulkType" message="$(string.RuntimePublisher.BulkTypeEventMessage)"/>

                    <event value="16" version="0" level="win:Informational"  template="GCBulkRootEdge"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkRootEdge"
                           task="GarbageCollection"
                           symbol="GCBulkRootEdge" message="$(string.RuntimePublisher.GCBulkRootEdgeEventMessage)"/>

                    <event value="17" version="0" level="win:Informational"  template="GCBulkRootConditionalWeakTableElementEdge"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkRootConditionalWeakTableElementEdge"
                           task="GarbageCollection"
                           symbol="GCBulkRootConditionalWeakTableElementEdge" message="$(string.RuntimePublisher.GCBulkRootConditionalWeakTableElementEdgeEventMessage)"/>

                    <event value="18" version="0" level="win:Informational"  template="GCBulkNode"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkNode"
                           task="GarbageCollection"
                           symbol="GCBulkNode" message="$(string.RuntimePublisher.GCBulkNodeEventMessage)"/>

                    <event value="19" version="0" level="win:Informational"  template="GCBulkEdge"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkEdge"
                           task="GarbageCollection"
                           symbol="GCBulkEdge" message="$(string.RuntimePublisher.GCBulkEdgeEventMessage)"/>

                    <event value="20" version="0" level="win:Informational"  template="GCSampledObjectAllocation"
                           keywords ="GCSampledObjectAllocationHighKeyword"  opcode="GCSampledObjectAllocation"
                           task="GarbageCollection"
                           symbol="GCSampledObjectAllocationHigh" message="$(string.RuntimePublisher.GCSampledObjectAllocationHighEventMessage)"/>

                    <event value="21" version="0" level="win:Informational"  template="GCBulkSurvivingObjectRanges"
                           keywords ="GCHeapSurvivalAndMovementKeyword"  opcode="GCBulkSurvivingObjectRanges"
                           task="GarbageCollection"
                           symbol="GCBulkSurvivingObjectRanges" message="$(string.RuntimePublisher.GCBulkSurvivingObjectRangesEventMessage)"/>

                    <event value="22" version="0" level="win:Informational"  template="GCBulkMovedObjectRanges"
                           keywords ="GCHeapSurvivalAndMovementKeyword"  opcode="GCBulkMovedObjectRanges"
                           task="GarbageCollection"
                           symbol="GCBulkMovedObjectRanges" message="$(string.RuntimePublisher.GCBulkMovedObjectRangesEventMessage)"/>

                    <event value="23" version="0" level="win:Informational"  template="GCGenerationRange"
                           keywords ="GCHeapSurvivalAndMovementKeyword"  opcode="GCGenerationRange"
                           task="GarbageCollection"
                           symbol="GCGenerationRange" message="$(string.RuntimePublisher.GCGenerationRangeEventMessage)"/>

                    <event value="25" version="0" level="win:Informational"  template="GCMark"
                           keywords ="GCKeyword"  opcode="GCMarkStackRoots"
                           task="GarbageCollection"
                           symbol="GCMarkStackRoots" message="$(string.RuntimePublisher.GCMarkStackRootsEventMessage)"/>

                    <event value="26" version="0" level="win:Informational"  template="GCMark"
                           keywords ="GCKeyword"  opcode="GCMarkFinalizeQueueRoots"
                           task="GarbageCollection"
                           symbol="GCMarkFinalizeQueueRoots" message="$(string.RuntimePublisher.GCMarkFinalizeQueueRootsEventMessage)"/>

                    <event value="27" version="0" level="win:Informational"  template="GCMark"
                           keywords ="GCKeyword"  opcode="GCMarkHandles"
                           task="GarbageCollection"
                           symbol="GCMarkHandles" message="$(string.RuntimePublisher.GCMarkHandlesEventMessage)"/>

                    <event value="28" version="0" level="win:Informational"  template="GCMark"
                           keywords ="GCKeyword"  opcode="GCMarkOlderGenerationRoots"
                           task="GarbageCollection"
                           symbol="GCMarkOlderGenerationRoots" message="$(string.RuntimePublisher.GCMarkOlderGenerationRootsEventMessage)"/>

                    <event value="29" version="0" level="win:Verbose"  template="FinalizeObject"
                           keywords ="GCKeyword"
                           opcode="FinalizeObject"
                           task="GarbageCollection"
                           symbol="FinalizeObject" message="$(string.RuntimePublisher.FinalizeObjectEventMessage)"/>

                    <event value="30" version="0" level="win:Informational"  template="SetGCHandle"
                           keywords="GCHandleKeyword"
                           opcode="SetGCHandle"
                           task="GarbageCollection"
                           symbol="SetGCHandle" message="$(string.RuntimePublisher.SetGCHandleEventMessage)"/>

                    <event value="31" version="0" level="win:Informational"  template="DestroyGCHandle"
                           keywords="GCHandleKeyword"
                           opcode="DestroyGCHandle"
                           task="GarbageCollection"
                           symbol="DestroyGCHandle" message="$(string.RuntimePublisher.DestroyGCHandleEventMessage)"/>

                    <event value="32" version="0" level="win:Informational"  template="GCSampledObjectAllocation"
                           keywords ="GCSampledObjectAllocationLowKeyword"  opcode="GCSampledObjectAllocation"
                           task="GarbageCollection"
                           symbol="GCSampledObjectAllocationLow" message="$(string.RuntimePublisher.GCSampledObjectAllocationLowEventMessage)"/>


                    <event value="33" version="0" level="win:Verbose" template="PinObjectAtGCTime"
                           keywords="GCKeyword"
                           opcode="PinObjectAtGCTime"
                           task="GarbageCollection"
                           symbol="PinObjectAtGCTime" message="$(string.RuntimePublisher.PinObjectAtGCTimeEventMessage)"/>

                    <event value="35" version="0" level="win:Informational"  template="GCTriggered"
                           keywords="GCKeyword" opcode="Triggered"
                           task="GarbageCollection"
                           symbol="GCTriggered" message="$(string.RuntimePublisher.GCTriggeredEventMessage)"/>

                    <event value="36" version="0" level="win:Informational"  template="GCBulkRootCCW"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkRootCCW"
                           task="GarbageCollection"
                           symbol="GCBulkRootCCW" message="$(string.RuntimePublisher.GCBulkRootCCWEventMessage)"/>

                    <event value="37" version="0" level="win:Informational"  template="GCBulkRCW"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkRCW"
                           task="GarbageCollection"
                           symbol="GCBulkRCW" message="$(string.RuntimePublisher.GCBulkRCWEventMessage)"/>

                    <event value="38" version="0" level="win:Informational"  template="GCBulkRootStaticVar"
                           keywords ="GCHeapDumpKeyword"  opcode="GCBulkRootStaticVar"
                           task="GarbageCollection"
                           symbol="GCBulkRootStaticVar" message="$(string.RuntimePublisher.GCBulkRootStaticVarEventMessage)"/>

                    <event value="39" version="0" level="win:LogAlways" template="GCDynamicEvent"
                           keywords= "GCKeyword GCHandleKeyword GCHeapDumpKeyword GCSampledObjectAllocationHighKeyword GCHeapSurvivalAndMovementKeyword GCHeapCollectKeyword GCHeapAndTypeNamesKeyword GCSampledObjectAllocationLowKeyword"
                           opcode="GCDynamicEvent"
                           task="GarbageCollection"
                           symbol="GCDynamicEvent"/>

                    <!-- CLR Threading events, value reserved from 40 to 79 -->
                    <event value="40" version="0" level="win:Informational"  template="ClrWorkerThread"
                           keywords="ThreadingKeyword" opcode="win:Start"
                           task="WorkerThreadCreation"
                           symbol="WorkerThreadCreate" message="$(string.RuntimePublisher.WorkerThreadCreateEventMessage)"/>

                    <event value="41" version="0" level="win:Informational"  template="ClrWorkerThread"
                           keywords="ThreadingKeyword" opcode="win:Stop"
                           task="WorkerThreadCreation"
                           symbol="WorkerThreadTerminate" message="$(string.RuntimePublisher.WorkerThreadTerminateEventMessage)"/>

                    <event value="42" version="0" level="win:Informational"  template="ClrWorkerThread"
                           keywords="ThreadingKeyword" opcode="win:Start"
                           task="WorkerThreadRetirement"
                           symbol="WorkerThreadRetire" message="$(string.RuntimePublisher.WorkerThreadRetirementRetireThreadEventMessage)"/>

                    <event value="43" version="0" level="win:Informational"  template="ClrWorkerThread"
                           keywords="ThreadingKeyword" opcode="win:Stop"
                           task="WorkerThreadRetirement"
                           symbol="WorkerThreadUnretire" message="$(string.RuntimePublisher.WorkerThreadRetirementUnretireThreadEventMessage)"/>

                    <event value="44" version="0" level="win:Informational"  template="IOThread"
                           keywords="ThreadingKeyword" opcode="win:Start"
                           task="IOThreadCreation"
                           symbol="IOThreadCreate" message="$(string.RuntimePublisher.IOThreadCreateEventMessage)"/>

                    <event value="44" version="1" level="win:Informational"  template="IOThread_V1"
                           keywords="ThreadingKeyword" opcode="win:Start"
                           task="IOThreadCreation"
                           symbol="IOThreadCreate_V1" message="$(string.RuntimePublisher.IOThreadCreate_V1EventMessage)"/>

                    <event value="45" version="0" level="win:Informational"  template="IOThread"
                           keywords="ThreadingKeyword" opcode="win:Stop"
                           task="IOThreadCreation"
                           symbol="IOThreadTerminate" message="$(string.RuntimePublisher.IOThreadTerminateEventMessage)"/>

                    <event value="45" version="1" level="win:Informational"  template="IOThread_V1"
                           keywords="ThreadingKeyword" opcode="win:Stop"
                           task="IOThreadCreation"
                           symbol="IOThreadTerminate_V1" message="$(string.RuntimePublisher.IOThreadTerminate_V1EventMessage)"/>

                    <event value="46" version="0" level="win:Informational"  template="IOThread"
                           keywords="ThreadingKeyword" opcode="win:Start"
                           task="IOThreadRetirement"
                           symbol="IOThreadRetire" message="$(string.RuntimePublisher.IOThreadRetirementRetireThreadEventMessage)"/>

                    <event value="46" version="1" level="win:Informational"  template="IOThread_V1"
                           keywords="ThreadingKeyword" opcode="win:Start"
                           task="IOThreadRetirement"
                           symbol="IOThreadRetire_V1" message="$(string.RuntimePublisher.IOThreadRetirementRetireThread_V1EventMessage)"/>

                    <event value="47" version="0" level="win:Informational"  template="IOThread"
                           keywords="ThreadingKeyword" opcode="win:Stop"
                           task="IOThreadRetirement"
                           symbol="IOThreadUnretire" message="$(string.RuntimePublisher.IOThreadRetirementUnretireThreadEventMessage)"/>

                    <event value="47" version="1" level="win:Informational"  template="IOThread_V1"
                           keywords="ThreadingKeyword" opcode="win:Stop"
                           task="IOThreadRetirement"
                           symbol="IOThreadUnretire_V1" message="$(string.RuntimePublisher.IOThreadRetirementUnretireThread_V1EventMessage)"/>

                    <event value="48" version="0" level="win:Informational"  template="ClrThreadPoolSuspend"
                           keywords ="ThreadingKeyword"  opcode="win:Start"
                           task="ThreadpoolSuspension"
                           symbol="ThreadpoolSuspensionSuspendThread" message="$(string.RuntimePublisher.ThreadPoolSuspendSuspendThreadEventMessage)"/>

                    <event value="49" version="0" level="win:Informational"  template="ClrThreadPoolSuspend"
                           keywords ="ThreadingKeyword"  opcode="win:Stop"
                           task="ThreadpoolSuspension"
                           symbol="ThreadpoolSuspensionResumeThread" message="$(string.RuntimePublisher.ThreadPoolSuspendResumeThreadEventMessage)"/>

                    <event value="50" version="0" level="win:Informational"  template="ThreadPoolWorkerThread"
                           keywords ="ThreadingKeyword"  opcode="win:Start"
                           task="ThreadPoolWorkerThread"
                           symbol="ThreadPoolWorkerThreadStart" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>

                    <event value="51" version="0" level="win:Informational"  template="ThreadPoolWorkerThread"
                           keywords ="ThreadingKeyword"  opcode="win:Stop"
                           task="ThreadPoolWorkerThread"
                           symbol="ThreadPoolWorkerThreadStop" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>

                    <event value="52" version="0" level="win:Informational"  template="ThreadPoolWorkerThread"
                           keywords ="ThreadingKeyword"  opcode="win:Start"
                           task="ThreadPoolWorkerThreadRetirement"
                           symbol="ThreadPoolWorkerThreadRetirementStart" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>

                    <event value="53" version="0" level="win:Informational"  template="ThreadPoolWorkerThread"
                           keywords ="ThreadingKeyword"  opcode="win:Stop"
                           task="ThreadPoolWorkerThreadRetirement"
                           symbol="ThreadPoolWorkerThreadRetirementStop" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>

                    <event value="54" version="0" level="win:Informational"  template="ThreadPoolWorkerThreadAdjustmentSample"
                           keywords ="ThreadingKeyword"  opcode="Sample"
                           task="ThreadPoolWorkerThreadAdjustment"
                           symbol="ThreadPoolWorkerThreadAdjustmentSample" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentSampleEventMessage)"/>

                    <event value="55" version="0" level="win:Informational"  template="ThreadPoolWorkerThreadAdjustmentAdjustment"
                           keywords ="ThreadingKeyword"  opcode="Adjustment"
                           task="ThreadPoolWorkerThreadAdjustment"
                           symbol="ThreadPoolWorkerThreadAdjustmentAdjustment" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentAdjustmentEventMessage)"/>

                    <event value="56" version="0" level="win:Verbose"  template="ThreadPoolWorkerThreadAdjustmentStats"
                           keywords ="ThreadingKeyword"  opcode="Stats"
                           task="ThreadPoolWorkerThreadAdjustment"
                           symbol="ThreadPoolWorkerThreadAdjustmentStats" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadAdjustmentStatsEventMessage)"/>

                    <event value="57" version="0" level="win:Informational"  template="ThreadPoolWorkerThread"
                           keywords ="ThreadingKeyword"  opcode="Wait"
                           task="ThreadPoolWorkerThread"
                           symbol="ThreadPoolWorkerThreadWait" message="$(string.RuntimePublisher.ThreadPoolWorkerThreadEventMessage)"/>

                    <!-- CLR private ThreadPool events -->
                    <event value="60" version="0" level="win:Verbose"  template="ThreadPoolWorkingThreadCount"
                           keywords="ThreadingKeyword"
                           opcode="win:Start"
                           task="ThreadPoolWorkingThreadCount"
                           symbol="ThreadPoolWorkingThreadCount" message="$(string.RuntimePublisher.ThreadPoolWorkingThreadCountEventMessage)"/>

                    <event value="61" version="0" level="win:Verbose"  template="ThreadPoolWork"
                           keywords="ThreadingKeyword ThreadTransferKeyword"
                           task="ThreadPool"
                           opcode="Enqueue"
                           symbol="ThreadPoolEnqueue"
                           message="$(string.RuntimePublisher.ThreadPoolEnqueueEventMessage)"/>

                    <event value="62" version="0" level="win:Verbose"  template="ThreadPoolWork"
                           keywords="ThreadingKeyword ThreadTransferKeyword"
                           task="ThreadPool"
                           opcode="Dequeue"
                           symbol="ThreadPoolDequeue"
                           message="$(string.RuntimePublisher.ThreadPoolDequeueEventMessage)"/>

                    <event value="63" version="0" level="win:Verbose"  template="ThreadPoolIOWorkEnqueue"
                           keywords="ThreadingKeyword ThreadTransferKeyword"
                           task="ThreadPool"
                           opcode="IOEnqueue"
                           symbol="ThreadPoolIOEnqueue"
                           message="$(string.RuntimePublisher.ThreadPoolIOEnqueueEventMessage)"/>

                    <event value="64" version="0" level="win:Verbose"  template="ThreadPoolIOWork"
                           keywords="ThreadingKeyword ThreadTransferKeyword"
                           task="ThreadPool"
                           opcode="IODequeue"
                           symbol="ThreadPoolIODequeue"
                           message="$(string.RuntimePublisher.ThreadPoolIODequeueEventMessage)"/>

                    <event value="65" version="0" level="win:Verbose"  template="ThreadPoolIOWork"
                           keywords="ThreadingKeyword"
                           task="ThreadPool"
                           opcode="IOPack"
                           symbol="ThreadPoolIOPack"
                           message="$(string.RuntimePublisher.ThreadPoolIOPackEventMessage)"/>

                    <event value="70" version="0" level="win:Informational"  template="ThreadStartWork"
                           keywords="ThreadingKeyword ThreadTransferKeyword"
                           task="Thread"
                           opcode="Creating"
                           symbol="ThreadCreating"
                           message="$(string.RuntimePublisher.ThreadCreatingEventMessage)"/>

                    <event value="71" version="0" level="win:Informational"  template="ThreadStartWork"
                           keywords="ThreadingKeyword ThreadTransferKeyword"
                           task="Thread"
                           opcode="Running"
                           symbol="ThreadRunning"
                           message="$(string.RuntimePublisher.ThreadRunningEventMessage)"/>

                    <!-- CLR Exception events -->
                    <event value="80" version="0" level="win:Informational"
                           opcode="win:Start"
                           task="Exception"
                           symbol="ExceptionThrown" message="$(string.RuntimePublisher.ExceptionExceptionThrownEventMessage)"/>

                    <event value="80" version="1" level="win:Error"  template="Exception"
                           keywords ="ExceptionKeyword MonitoringKeyword"  opcode="win:Start"
                           task="Exception"
                           symbol="ExceptionThrown_V1" message="$(string.RuntimePublisher.ExceptionExceptionThrown_V1EventMessage)"/>

                    <event value="250" version="0" level="win:Informational"  template="ExceptionHandling"
                           keywords ="ExceptionKeyword"  opcode="win:Start"
                           task="ExceptionCatch"
                           symbol="ExceptionCatchStart" message="$(string.RuntimePublisher.ExceptionExceptionHandlingEventMessage)"/>

                    <event value="251" version="0" level="win:Informational"
                           keywords ="ExceptionKeyword"  opcode="win:Stop"
                           task="ExceptionCatch"
                           symbol="ExceptionCatchStop" message="$(string.RuntimePublisher.ExceptionExceptionHandlingNoneEventMessage)"/>

                    <event value="252" version="0" level="win:Informational"  template="ExceptionHandling"
                           keywords ="ExceptionKeyword"  opcode="win:Start"
                           task="ExceptionFinally"
                           symbol="ExceptionFinallyStart" message="$(string.RuntimePublisher.ExceptionExceptionHandlingEventMessage)"/>

                    <event value="253" version="0" level="win:Informational"
                           keywords ="ExceptionKeyword"  opcode="win:Stop"
                           task="ExceptionFinally"
                           symbol="ExceptionFinallyStop" message="$(string.RuntimePublisher.ExceptionExceptionHandlingNoneEventMessage)"/>

                    <event value="254" version="0" level="win:Informational"  template="ExceptionHandling"
                           keywords ="ExceptionKeyword"  opcode="win:Start"
                           task="ExceptionFilter"
                           symbol="ExceptionFilterStart" message="$(string.RuntimePublisher.ExceptionExceptionHandlingEventMessage)"/>

                    <event value="255" version="0" level="win:Informational"
                           keywords ="ExceptionKeyword"  opcode="win:Stop"
                           task="ExceptionFilter"
                           symbol="ExceptionFilterStop" message="$(string.RuntimePublisher.ExceptionExceptionHandlingNoneEventMessage)"/>

                    <event value="256" version="0" level="win:Informational"
                           keywords ="ExceptionKeyword"  opcode="win:Stop"
                           task="Exception"
                           symbol="ExceptionThrownStop" message="$(string.RuntimePublisher.ExceptionExceptionHandlingNoneEventMessage)"/>

                    <!-- CLR Contention events -->
                    <event value="81" version="0" level="win:Informational"
                           opcode="win:Start"
                           task="Contention"
                           symbol="Contention" message="$(string.RuntimePublisher.ContentionStartEventMessage)"/>

                    <event value="81" version="1" level="win:Informational"  template="Contention"
                           keywords ="ContentionKeyword"  opcode="win:Start"
                           task="Contention"
                           symbol="ContentionStart_V1" message="$(string.RuntimePublisher.ContentionStart_V1EventMessage)"/>

                    <event value="91" version="0" level="win:Informational"  template="Contention"
                           keywords ="ContentionKeyword"  opcode="win:Stop"
                           task="Contention"
                           symbol="ContentionStop" message="$(string.RuntimePublisher.ContentionStopEventMessage)"/>

                    <event value="91" version="1" level="win:Informational"  template="ContentionStop_V1"
                           keywords ="ContentionKeyword"  opcode="win:Stop"
                           task="Contention"
                           symbol="ContentionStop_V1" message="$(string.RuntimePublisher.ContentionStop_V1EventMessage)"/>

                    <!-- CLR Stack events -->
                    <event value="82" version="0" level="win:LogAlways"  template="ClrStackWalk"
                           keywords ="StackKeyword"  opcode="CLRStackWalk"
                           task="CLRStack"
                           symbol="CLRStackWalk" message="$(string.RuntimePublisher.StackEventMessage)"/>

                    <!-- CLR AppDomainResourceManagement events -->
                    <event value="83" version="0" level="win:Informational"  template="AppDomainMemAllocated"
                           keywords ="AppDomainResourceManagementKeyword"  opcode="AppDomainMemAllocated"
                           task="AppDomainResourceManagement"
                           symbol="AppDomainMemAllocated" message="$(string.RuntimePublisher.AppDomainMemAllocatedEventMessage)"/>

                    <event value="84" version="0" level="win:Informational"  template="AppDomainMemSurvived"
                           keywords ="AppDomainResourceManagementKeyword"  opcode="AppDomainMemSurvived"
                           task="AppDomainResourceManagement"
                           symbol="AppDomainMemSurvived" message="$(string.RuntimePublisher.AppDomainMemSurvivedEventMessage)"/>

                    <event value="85" version="0" level="win:Informational"  template="ThreadCreated"
                           keywords ="AppDomainResourceManagementKeyword ThreadingKeyword"  opcode="ThreadCreated"
                           task="AppDomainResourceManagement"
                           symbol="ThreadCreated" message="$(string.RuntimePublisher.ThreadCreatedEventMessage)"/>

                    <event value="86" version="0" level="win:Informational"  template="ThreadTerminatedOrTransition"
                           keywords ="AppDomainResourceManagementKeyword ThreadingKeyword"  opcode="ThreadTerminated"
                           task="AppDomainResourceManagement"
                           symbol="ThreadTerminated" message="$(string.RuntimePublisher.ThreadTerminatedEventMessage)"/>

                    <event value="87" version="0" level="win:Informational"  template="ThreadTerminatedOrTransition"
                           keywords ="AppDomainResourceManagementKeyword ThreadingKeyword"  opcode="ThreadDomainEnter"
                           task="AppDomainResourceManagement"
                           symbol="ThreadDomainEnter" message="$(string.RuntimePublisher.ThreadDomainEnterEventMessage)"/>

                    <!-- CLR Interop events -->
                    <event value="88" version="0" level="win:Informational"  template="ILStubGenerated"
                           keywords ="InteropKeyword"  opcode="ILStubGenerated"
                           task="CLRILStub"
                           symbol="ILStubGenerated" message="$(string.RuntimePublisher.ILStubGeneratedEventMessage)"/>

                    <event value="89" version="0" level="win:Informational"  template="ILStubCacheHit"
                           keywords ="InteropKeyword"  opcode="ILStubCacheHit"
                           task="CLRILStub"
                           symbol="ILStubCacheHit" message="$(string.RuntimePublisher.ILStubCacheHitEventMessage)"/>

                    <!-- CLR Method events -->
                    <!-- The following 6 events are now defunct -->
                    <event value="135" version="0" level="win:Informational"
                           keywords ="JitKeyword NGenKeyword" opcode="DCStartComplete"
                           task="CLRMethod"
                           symbol="DCStartCompleteV2" message="$(string.RuntimePublisher.DCStartCompleteEventMessage)"/>

                    <event value="136" version="0" level="win:Informational"
                           keywords ="JitKeyword NGenKeyword" opcode="DCEndComplete"
                           task="CLRMethod"
                           symbol="DCEndCompleteV2" message="$(string.RuntimePublisher.DCEndCompleteEventMessage)"/>

                    <event value="137" version="0" level="win:Informational"  template="MethodLoadUnload"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodDCStart"
                           task="CLRMethod"
                           symbol="MethodDCStartV2" message="$(string.RuntimePublisher.MethodDCStartEventMessage)"/>

                    <event value="138" version="0" level="win:Informational"  template="MethodLoadUnload"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodDCEnd"
                           task="CLRMethod"
                           symbol="MethodDCEndV2" message="$(string.RuntimePublisher.MethodDCEndEventMessage)"/>

                    <event value="139" version="0" level="win:Informational"  template="MethodLoadUnloadVerbose"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodDCStartVerbose"
                           task="CLRMethod"
                           symbol="MethodDCStartVerboseV2" message="$(string.RuntimePublisher.MethodDCStartEventMessage)"/>

                    <event value="140" version="0" level="win:Informational"  template="MethodLoadUnloadVerbose"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodDCEndVerbose"
                           task="CLRMethod"
                           symbol="MethodDCEndVerboseV2" message="$(string.RuntimePublisher.MethodDCEndVerboseEventMessage)"/>

                    <event value="141" version="0" level="win:Informational"  template="MethodLoadUnload"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodLoad"
                           task="CLRMethod"
                           symbol="MethodLoad" message="$(string.RuntimePublisher.MethodLoadEventMessage)"/>

                    <event value="141" version="1" level="win:Informational"  template="MethodLoadUnload_V1"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodLoad"
                           task="CLRMethod"
                           symbol="MethodLoad_V1" message="$(string.RuntimePublisher.MethodLoad_V1EventMessage)"/>

                    <event value="141" version="2" level="win:Informational"  template="MethodLoadUnload_V2"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodLoad"
                           task="CLRMethod"
                           symbol="MethodLoad_V2" message="$(string.RuntimePublisher.MethodLoad_V2EventMessage)"/>

                    <event value="159" version="0" level="win:Verbose" template="R2RGetEntryPoint"
                           keywords ="CompilationDiagnosticKeyword" opcode="MethodLoad"
                           task="CLRMethod"
                           symbol="R2RGetEntryPoint" message="$(string.RuntimePublisher.R2RGetEntryPointEventMessage)"/>

                    <event value="142" version="0" level="win:Informational"  template="MethodLoadUnload"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodUnload"
                           task="CLRMethod"
                           symbol="MethodUnload" message="$(string.RuntimePublisher.MethodUnloadEventMessage)"/>

                    <event value="142" version="1" level="win:Informational"  template="MethodLoadUnload_V1"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodUnload"
                           task="CLRMethod"
                           symbol="MethodUnload_V1" message="$(string.RuntimePublisher.MethodUnload_V1EventMessage)"/>

                    <event value="142" version="2" level="win:Informational"  template="MethodLoadUnload_V2"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodUnload"
                           task="CLRMethod"
                           symbol="MethodUnload_V2" message="$(string.RuntimePublisher.MethodUnload_V2EventMessage)"/>

                    <event value="143" version="0" level="win:Informational"  template="MethodLoadUnloadVerbose"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodLoadVerbose"
                           task="CLRMethod"
                           symbol="MethodLoadVerbose" message="$(string.RuntimePublisher.MethodLoadVerboseEventMessage)"/>

                    <event value="143" version="1" level="win:Informational"  template="MethodLoadUnloadVerbose_V1"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodLoadVerbose"
                           task="CLRMethod"
                           symbol="MethodLoadVerbose_V1" message="$(string.RuntimePublisher.MethodLoadVerbose_V1EventMessage)"/>

                    <event value="143" version="2" level="win:Informational"  template="MethodLoadUnloadVerbose_V2"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodLoadVerbose"
                           task="CLRMethod"
                           symbol="MethodLoadVerbose_V2" message="$(string.RuntimePublisher.MethodLoadVerbose_V2EventMessage)"/>

                    <event value="144" version="0" level="win:Informational"  template="MethodLoadUnloadVerbose"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodUnloadVerbose"
                           task="CLRMethod"
                           symbol="MethodUnloadVerbose" message="$(string.RuntimePublisher.MethodUnloadVerboseEventMessage)"/>

                    <event value="144" version="1" level="win:Informational"  template="MethodLoadUnloadVerbose_V1"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodUnloadVerbose"
                           task="CLRMethod"
                           symbol="MethodUnloadVerbose_V1" message="$(string.RuntimePublisher.MethodUnloadVerbose_V1EventMessage)"/>

                    <event value="144" version="2" level="win:Informational"  template="MethodLoadUnloadVerbose_V2"
                           keywords ="JitKeyword NGenKeyword" opcode="MethodUnloadVerbose"
                           task="CLRMethod"
                           symbol="MethodUnloadVerbose_V2" message="$(string.RuntimePublisher.MethodUnloadVerbose_V2EventMessage)"/>

                    <event value="145" version="0" level="win:Verbose"  template="MethodJittingStarted"
                           keywords ="JitKeyword" opcode="MethodJittingStarted"
                           task="CLRMethod"
                           symbol="MethodJittingStarted" message="$(string.RuntimePublisher.MethodJittingStartedEventMessage)"/>

                    <event value="145" version="1" level="win:Verbose"  template="MethodJittingStarted_V1"
                           keywords ="JitKeyword" opcode="MethodJittingStarted"
                           task="CLRMethod"
                           symbol="MethodJittingStarted_V1" message="$(string.RuntimePublisher.MethodJittingStarted_V1EventMessage)"/>

                    <event value="185" version="0" level="win:Verbose"  template="MethodJitInliningSucceeded"
                           keywords ="JitTracingKeyword" opcode="JitInliningSucceeded"
                           task="CLRMethod"
                           symbol="MethodJitInliningSucceeded"
                           message="$(string.RuntimePublisher.MethodJitInliningSucceededEventMessage)"/>

                    <event value="186" version="0" level="win:Verbose"  template="MethodJitInliningFailedAnsi"
                           keywords ="JitTracingKeyword" opcode="JitInliningFailed"
                           task="CLRMethod"
                           symbol="MethodJitInliningFailedAnsi"
                           message="$(string.RuntimePublisher.MethodJitInliningFailedEventMessage)"/>

                    <event value="188" version="0" level="win:Verbose"  template="MethodJitTailCallSucceeded"
                           keywords ="JitTracingKeyword" opcode="JitTailCallSucceeded"
                           task="CLRMethod"
                           symbol="MethodJitTailCallSucceeded"
                           message="$(string.RuntimePublisher.MethodJitTailCallSucceededEventMessage)"/>

                    <event value="189" version="0" level="win:Verbose"  template="MethodJitTailCallFailedAnsi"
                           keywords ="JitTracingKeyword" opcode="JitTailCallFailed"
                           task="CLRMethod"
                           symbol="MethodJitTailCallFailedAnsi"
                           message="$(string.RuntimePublisher.MethodJitTailCallFailedEventMessage)"/>

                    <event value="190" version="0" level="win:Verbose"  template="MethodILToNativeMap"
                           keywords ="JittedMethodILToNativeMapKeyword" opcode="MethodILToNativeMap"
                           task="CLRMethod"
                           symbol="MethodILToNativeMap"
                           message="$(string.RuntimePublisher.MethodILToNativeMapEventMessage)"/>

                    <event value="191" version="0" level="win:Verbose"  template="MethodJitTailCallFailed"
                           keywords ="JitTracingKeyword" opcode="JitTailCallFailed"
                           task="CLRMethod"
                           symbol="MethodJitTailCallFailed"
                           message="$(string.RuntimePublisher.MethodJitTailCallFailedEventMessage)"/>

                    <event value="192" version="0" level="win:Verbose"  template="MethodJitInliningFailed"
                           keywords ="JitTracingKeyword" opcode="JitInliningFailed"
                           task="CLRMethod"
                           symbol="MethodJitInliningFailed"
                           message="$(string.RuntimePublisher.MethodJitInliningFailedEventMessage)"/>

                    <!-- CLR Loader events -->
                    <!-- The following 2 events are now defunct -->
                    <event value="149" version="0" level="win:Informational"  template="ModuleLoadUnload"
                           keywords ="LoaderKeyword" opcode="ModuleDCStart"
                           task="CLRLoader"
                           symbol="ModuleDCStartV2" message="$(string.RuntimePublisher.ModuleDCStartEventMessage)"/>

                    <event value="150" version="0" level="win:Informational"  template="ModuleLoadUnload"
                           keywords ="LoaderKeyword" opcode="ModuleDCEnd"
                           task="CLRLoader"
                           symbol="ModuleDCEndV2" message="$(string.RuntimePublisher.ModuleDCEndEventMessage)"/>

                    <event value="151" version="0" level="win:Informational"  template="DomainModuleLoadUnload"
                           keywords ="LoaderKeyword" opcode="DomainModuleLoad"
                           task="CLRLoader"
                           symbol="DomainModuleLoad" message="$(string.RuntimePublisher.DomainModuleLoadEventMessage)"/>

                    <event value="151" version="1" level="win:Informational"  template="DomainModuleLoadUnload_V1"
                           keywords ="LoaderKeyword" opcode="DomainModuleLoad"
                           task="CLRLoader"
                           symbol="DomainModuleLoad_V1" message="$(string.RuntimePublisher.DomainModuleLoad_V1EventMessage)"/>

                    <event value="152" version="0" level="win:Informational"  template="ModuleLoadUnload"
                           keywords ="LoaderKeyword" opcode="ModuleLoad"
                           task="CLRLoader"
                           symbol="ModuleLoad" message="$(string.RuntimePublisher.ModuleLoadEventMessage)"/>

                    <event value="152" version="1" level="win:Informational"  template="ModuleLoadUnload_V1"
                           keywords ="LoaderKeyword PerfTrackKeyword" opcode="ModuleLoad"
                           task="CLRLoader"
                           symbol="ModuleLoad_V1" message="$(string.RuntimePublisher.ModuleLoad_V1EventMessage)"/>

                    <event value="152" version="2" level="win:Informational"  template="ModuleLoadUnload_V2"
                           keywords ="LoaderKeyword PerfTrackKeyword" opcode="ModuleLoad"
                           task="CLRLoader"
                           symbol="ModuleLoad_V2" message="$(string.RuntimePublisher.ModuleLoad_V2EventMessage)"/>

                    <event value="153" version="0" level="win:Informational"  template="ModuleLoadUnload"
                           keywords ="LoaderKeyword" opcode="ModuleUnload"
                           task="CLRLoader"
                           symbol="ModuleUnload" message="$(string.RuntimePublisher.ModuleUnloadEventMessage)"/>

                    <event value="153" version="1" level="win:Informational"  template="ModuleLoadUnload_V1"
                           keywords ="LoaderKeyword PerfTrackKeyword" opcode="ModuleUnload"
                           task="CLRLoader"
                           symbol="ModuleUnload_V1" message="$(string.RuntimePublisher.ModuleUnload_V1EventMessage)"/>

                    <event value="153" version="2" level="win:Informational"  template="ModuleLoadUnload_V2"
                           keywords ="LoaderKeyword PerfTrackKeyword" opcode="ModuleUnload"
                           task="CLRLoader"
                           symbol="ModuleUnload_V2" message="$(string.RuntimePublisher.ModuleUnload_V2EventMessage)"/>

                    <event value="154" version="0" level="win:Informational"  template="AssemblyLoadUnload"
                           keywords ="LoaderKeyword" opcode="AssemblyLoad"
                           task="CLRLoader"
                           symbol="AssemblyLoad" message="$(string.RuntimePublisher.AssemblyLoadEventMessage)"/>

                    <event value="154" version="1" level="win:Informational"  template="AssemblyLoadUnload_V1"
                           keywords ="LoaderKeyword" opcode="AssemblyLoad"
                           task="CLRLoader"
                           symbol="AssemblyLoad_V1" message="$(string.RuntimePublisher.AssemblyLoad_V1EventMessage)"/>

                    <event value="155" version="0" level="win:Informational"  template="AssemblyLoadUnload"
                           keywords ="LoaderKeyword" opcode="AssemblyUnload"
                           task="CLRLoader"
                           symbol="AssemblyUnload" message="$(string.RuntimePublisher.AssemblyUnloadEventMessage)"/>

                    <event value="155" version="1" level="win:Informational"  template="AssemblyLoadUnload_V1"
                           keywords ="LoaderKeyword" opcode="AssemblyUnload"
                           task="CLRLoader"
                           symbol="AssemblyUnload_V1" message="$(string.RuntimePublisher.AssemblyUnload_V1EventMessage)"/>

                    <event value="156" version="0" level="win:Informational"  template="AppDomainLoadUnload"
                           keywords ="LoaderKeyword" opcode="AppDomainLoad"
                           task="CLRLoader"
                           symbol="AppDomainLoad" message="$(string.RuntimePublisher.AppDomainLoadEventMessage)"/>

                    <event value="156" version="1" level="win:Informational"  template="AppDomainLoadUnload_V1"
                           keywords ="LoaderKeyword" opcode="AppDomainLoad"
                           task="CLRLoader"
                           symbol="AppDomainLoad_V1" message="$(string.RuntimePublisher.AppDomainLoad_V1EventMessage)"/>

                    <event value="157" version="0" level="win:Informational"  template="AppDomainLoadUnload"
                           keywords ="LoaderKeyword" opcode="AppDomainUnload"
                           task="CLRLoader"
                           symbol="AppDomainUnload" message="$(string.RuntimePublisher.AppDomainUnloadEventMessage)"/>

                    <event value="157" version="1" level="win:Informational"  template="AppDomainLoadUnload_V1"
                           keywords ="LoaderKeyword" opcode="AppDomainUnload"
                           task="CLRLoader"
                           symbol="AppDomainUnload_V1" message="$(string.RuntimePublisher.AppDomainUnload_V1EventMessage)"/>

                    <event value="158" version="0" level="win:Informational"  template="ModuleRange"
                           keywords ="PerfTrackKeyword" opcode="ModuleRangeLoad"
                           task="CLRPerfTrack"
                           symbol="ModuleRangeLoad" message="$(string.RuntimePublisher.ModuleRangeLoadEventMessage)"/>

                    <!-- CLR Security events -->
                    <event value="181" version="0" level="win:Verbose"  template="StrongNameVerification"
                           keywords ="SecurityKeyword" opcode="win:Start"
                           task="CLRStrongNameVerification"
                           symbol="StrongNameVerificationStart" message="$(string.RuntimePublisher.StrongNameVerificationStartEventMessage)"/>

                    <event value="181" version="1" level="win:Verbose"  template="StrongNameVerification_V1"
                           keywords ="SecurityKeyword" opcode="win:Start"
                           task="CLRStrongNameVerification"
                           symbol="StrongNameVerificationStart_V1" message="$(string.RuntimePublisher.StrongNameVerificationStart_V1EventMessage)"/>

                    <event value="182" version="0" level="win:Informational"  template="StrongNameVerification"
                           keywords ="SecurityKeyword" opcode="win:Stop"
                           task="CLRStrongNameVerification"
                           symbol="StrongNameVerificationStop" message="$(string.RuntimePublisher.StrongNameVerificationEndEventMessage)"/>

                    <event value="182" version="1" level="win:Informational"  template="StrongNameVerification_V1"
                           keywords ="SecurityKeyword" opcode="win:Stop"
                           task="CLRStrongNameVerification"
                           symbol="StrongNameVerificationStop_V1" message="$(string.RuntimePublisher.StrongNameVerificationEnd_V1EventMessage)"/>

                    <event value="183" version="0" level="win:Verbose"  template="AuthenticodeVerification"
                           keywords ="SecurityKeyword" opcode="win:Start"
                           task="CLRAuthenticodeVerification"
                           symbol="AuthenticodeVerificationStart" message="$(string.RuntimePublisher.AuthenticodeVerificationStartEventMessage)"/>

                    <event value="183" version="1" level="win:Verbose"  template="AuthenticodeVerification_V1"
                           keywords ="SecurityKeyword" opcode="win:Start"
                           task="CLRAuthenticodeVerification"
                           symbol="AuthenticodeVerificationStart_V1" message="$(string.RuntimePublisher.AuthenticodeVerificationStart_V1EventMessage)"/>

                    <event value="184" version="0" level="win:Informational"  template="AuthenticodeVerification"
                           keywords ="SecurityKeyword" opcode="win:Stop"
                           task="CLRAuthenticodeVerification"
                           symbol="AuthenticodeVerificationStop" message="$(string.RuntimePublisher.AuthenticodeVerificationEndEventMessage)"/>

                    <event value="184" version="1" level="win:Informational"  template="AuthenticodeVerification_V1"
                           keywords ="SecurityKeyword" opcode="win:Stop"
                           task="CLRAuthenticodeVerification"
                           symbol="AuthenticodeVerificationStop_V1" message="$(string.RuntimePublisher.AuthenticodeVerificationEnd_V1EventMessage)"/>

                    <!-- CLR RuntimeInformation events -->
                    <event value="187" version="0" level="win:Informational"  template="RuntimeInformation"
                           opcode="win:Start"
                           task="CLRRuntimeInformation"
                           symbol="RuntimeInformationStart" message="$(string.RuntimePublisher.RuntimeInformationEventMessage)"/>

                    <!-- Additional GC events 200-239 -->
                    <event value="200" version="0" level="win:Verbose" template="IncreaseMemoryPressure"
                           keywords="GCKeyword" opcode="IncreaseMemoryPressure"
                           task="GarbageCollection"
                           symbol="IncreaseMemoryPressure" message="$(string.RuntimePublisher.IncreaseMemoryPressureEventMessage)"/>

                    <event value="201" version="0" level="win:Verbose" template="DecreaseMemoryPressure"
                           keywords="GCKeyword" opcode="DecreaseMemoryPressure"
                           task="GarbageCollection"
                           symbol="DecreaseMemoryPressure" message="$(string.RuntimePublisher.DecreaseMemoryPressureEventMessage)"/>

                    <event value="202" version="0" level="win:Informational"  template="GCMarkWithType"
                           keywords ="GCKeyword"  opcode="GCMarkWithType"
                           task="GarbageCollection"
                           symbol="GCMarkWithType" message="$(string.RuntimePublisher.GCMarkWithTypeEventMessage)"/>

                    <event value="203" version="2" level="win:Verbose"  template="GCJoin_V2"
                           keywords ="GCKeyword"  opcode="GCJoin"
                           task="GarbageCollection"
                           symbol="GCJoin_V2" message="$(string.RuntimePublisher.GCJoin_V2EventMessage)"/>

                    <event value="204" version="3" level="win:Informational"  template="GCPerHeapHistory_V3"
                           keywords ="GCKeyword"  opcode="GCPerHeapHistory"
                           task="GarbageCollection"
                           symbol="GCPerHeapHistory_V3" message="$(string.RuntimePublisher.GCPerHeapHistory_V3EventMessage)"/>

                    <event value="205" version="2" level="win:Informational"  template="GCGlobalHeap_V2"
                           keywords ="GCKeyword"  opcode="GCGlobalHeapHistory"
                           task="GarbageCollection"
                           symbol="GCGlobalHeapHistory_V2" message="$(string.RuntimePublisher.GCGlobalHeap_V2EventMessage)"/>

                    <!-- CLR Debugger events 240-249 -->
                    <event value="240" version="0" level="win:Informational"
                           keywords="DebuggerKeyword" opcode="win:Start"
                           task="DebugIPCEvent"
                           symbol="DebugIPCEventStart" />
                    <event value="241" version="0" level="win:Informational"
                           keywords="DebuggerKeyword" opcode="win:Stop"
                           task="DebugIPCEvent"
                           symbol="DebugIPCEventEnd" />
                    <event value="242" version="0" level="win:Informational"
                           keywords="DebuggerKeyword" opcode="win:Start"
                           task="DebugExceptionProcessing"
                           symbol="DebugExceptionProcessingStart" />
                    <event value="243" version="0" level="win:Informational"
                           keywords="DebuggerKeyword" opcode="win:Stop"
                           task="DebugExceptionProcessing"
                           symbol="DebugExceptionProcessingEnd" />

                    <!-- CLR Code Symbol Emission events 260-269 -->
                    <event value="260" version="0" level="win:Verbose" template="CodeSymbols"
                           keywords="CodeSymbolsKeyword" opcode="win:Start"
                           task="CodeSymbols"
                           symbol="CodeSymbols" message="$(string.RuntimePublisher.CodeSymbolsEventMessage)"/>

                    <event value="270" version="0" level="win:Informational"  template="EventSource"
                           keywords="EventSourceKeyword"
                           symbol="EventSource" />

                    <!-- Tiered compilation events 280-289 -->
                    <event value="280" version="0" level="win:Informational" template="TieredCompilationSettings"
                           keywords="CompilationKeyword" task="TieredCompilation" opcode="Settings"
                           symbol="TieredCompilationSettings" message="$(string.RuntimePublisher.TieredCompilationSettingsEventMessage)"/>
                    <event value="281" version="0" level="win:Informational" template="TieredCompilationEmpty"
                           keywords="CompilationKeyword" task="TieredCompilation" opcode="Pause"
                           symbol="TieredCompilationPause" message="$(string.RuntimePublisher.TieredCompilationPauseEventMessage)"/>
                    <event value="282" version="0" level="win:Informational" template="TieredCompilationResume"
                           keywords="CompilationKeyword" task="TieredCompilation" opcode="Resume"
                           symbol="TieredCompilationResume" message="$(string.RuntimePublisher.TieredCompilationResumeEventMessage)"/>
                    <event value="283" version="0" level="win:Informational" template="TieredCompilationBackgroundJitStart"
                           keywords="CompilationKeyword" task="TieredCompilation" opcode="win:Start"
                           symbol="TieredCompilationBackgroundJitStart" message="$(string.RuntimePublisher.TieredCompilationBackgroundJitStartEventMessage)"/>
                    <event value="284" version="0" level="win:Informational" template="TieredCompilationBackgroundJitStop"
                           keywords="CompilationKeyword" task="TieredCompilation" opcode="win:Stop"
                           symbol="TieredCompilationBackgroundJitStop" message="$(string.RuntimePublisher.TieredCompilationBackgroundJitStopEventMessage)"/>
                </events>
            </provider>


            <!--CLR Rundown Publisher-->
            <provider name="Microsoft-Windows-DotNETRuntimeRundown"
                      guid="{A669021C-C450-4609-A035-5AF59AF4DF18}"
                      symbol="MICROSOFT_WINDOWS_DOTNETRUNTIME_RUNDOWN_PROVIDER"
                      resourceFileName="%INSTALL_PATH%\clretwrc.dll"
                      messageFileName="%INSTALL_PATH%\clretwrc.dll">

                <!--Keywords-->
                <keywords>
                    <keyword name="LoaderRundownKeyword" mask="0x8"
                             message="$(string.RundownPublisher.LoaderKeywordMessage)" symbol="CLR_RUNDOWNLOADER_KEYWORD"/>
                    <keyword name="JitRundownKeyword" mask="0x10"
                             message="$(string.RundownPublisher.JitKeywordMessage)" symbol="CLR_RUNDOWNJIT_KEYWORD"/>
                    <keyword name="NGenRundownKeyword" mask="0x20"
                             message="$(string.RundownPublisher.NGenKeywordMessage)" symbol="CLR_RUNDOWNNGEN_KEYWORD"/>
                    <keyword name="StartRundownKeyword" mask="0x40"
                             message="$(string.RundownPublisher.StartRundownKeywordMessage)" symbol="CLR_RUNDOWNSTART_KEYWORD"/>
                    <keyword name="EndRundownKeyword" mask="0x100"
                             message="$(string.RundownPublisher.EndRundownKeywordMessage)" symbol="CLR_RUNDOWNEND_KEYWORD"/>
                    <!-- Keyword mask 0x200 is now defunct -->
                    <keyword name="AppDomainResourceManagementRundownKeyword" mask="0x800"
                             message="$(string.RuntimePublisher.AppDomainResourceManagementRundownKeywordMessage)" symbol="CLR_RUNDOWNAPPDOMAINRESOURCEMANAGEMENT_KEYWORD"/>
                    <keyword name="ThreadingKeyword" mask="0x10000"
                             message="$(string.RundownPublisher.ThreadingKeywordMessage)" symbol="CLR_RUNDOWNTHREADING_KEYWORD"/>
                    <keyword name="JittedMethodILToNativeMapRundownKeyword" mask="0x20000"
                             message="$(string.RundownPublisher.JittedMethodILToNativeMapRundownKeywordMessage)" symbol="CLR_RUNDOWNJITTEDMETHODILTONATIVEMAP_KEYWORD"/>
                    <keyword name="OverrideAndSuppressNGenEventsRundownKeyword" mask="0x40000"
                             message="$(string.RundownPublisher.OverrideAndSuppressNGenEventsRundownKeywordMessage)" symbol="CLR_RUNDOWNOVERRIDEANDSUPPRESSNGENEVENTS_KEYWORD"/>
                    <keyword name="PerfTrackRundownKeyword" mask="0x20000000"
                             message="$(string.RundownPublisher.PerfTrackRundownKeywordMessage)" symbol="CLR_RUNDOWNPERFTRACK_KEYWORD"/>
                    <keyword name="StackKeyword" mask="0x40000000"
                             message="$(string.RundownPublisher.StackKeywordMessage)" symbol="CLR_RUNDOWNSTACK_KEYWORD"/>
                    <keyword name="CompilationKeyword" mask="0x1000000000"
                             message="$(string.RundownPublisher.CompilationKeywordMessage)" symbol="CLR_COMPILATION_RUNDOWN_KEYWORD" />
                </keywords>

                <!--Tasks-->
                <tasks>
                    <task name="CLRMethodRundown" symbol="CLR_METHODRUNDOWN_TASK"
                          value="1" eventGUID="{0BCD91DB-F943-454a-A662-6EDBCFBB76D2}"
                          message="$(string.RundownPublisher.MethodTaskMessage)">
                        <opcodes>
                            <opcode name="MethodDCStart" message="$(string.RundownPublisher.MethodDCStartOpcodeMessage)" symbol="CLR_METHODDC_METHODDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="MethodDCEnd" message="$(string.RundownPublisher.MethodDCEndOpcodeMessage)" symbol="CLR_METHODDC_METHODDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="MethodDCStartVerbose" message="$(string.RundownPublisher.MethodDCStartVerboseOpcodeMessage)" symbol="CLR_METHODDC_METHODDCSTARTVERBOSE_OPCODE" value="39"> </opcode>
                            <opcode name="MethodDCEndVerbose" message="$(string.RundownPublisher.MethodDCEndVerboseOpcodeMessage)" symbol="CLR_METHODDC_METHODDCENDVERBOSE_OPCODE" value="40"> </opcode>
                            <opcode name="MethodDCStartILToNativeMap" message="$(string.RundownPublisher.MethodDCStartILToNativeMapOpcodeMessage)" symbol="CLR_METHODDC_METHODDCSTARTILTONATIVEMAP_OPCODE" value="41"> </opcode>
                            <opcode name="MethodDCEndILToNativeMap" message="$(string.RundownPublisher.MethodDCEndILToNativeMapOpcodeMessage)" symbol="CLR_METHODDC_METHODDCENDILTONATIVEMAP_OPCODE" value="42"> </opcode>
                            <opcode name="DCStartComplete" message="$(string.RundownPublisher.DCStartCompleteOpcodeMessage)" symbol="CLR_METHODDC_DCSTARTCOMPLETE_OPCODE" value="14"> </opcode>
                            <opcode name="DCEndComplete" message="$(string.RundownPublisher.DCEndCompleteOpcodeMessage)" symbol="CLR_METHODDC_DCENDCOMPLETE_OPCODE" value="15"> </opcode>
                            <opcode name="DCStartInit" message="$(string.RundownPublisher.DCStartInitOpcodeMessage)" symbol="CLR_METHODDC_DCSTARTINIT_OPCODE" value="16"> </opcode>
                            <opcode name="DCEndInit" message="$(string.RundownPublisher.DCEndInitOpcodeMessage)" symbol="CLR_METHODDC_DCENDINIT_OPCODE" value="17"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRLoaderRundown" symbol="CLR_LOADERRUNDOWN_TASK"
                          value="2" eventGUID="{5A54F4DF-D302-4fee-A211-6C2C0C1DCB1A}"
                          message="$(string.RundownPublisher.LoaderTaskMessage)">
                        <opcodes>
                            <opcode name="ModuleDCStart" message="$(string.RundownPublisher.ModuleDCStartOpcodeMessage)" symbol="CLR_LOADERDC_MODULEDCSTART_OPCODE" value="35"> </opcode>
                            <opcode name="ModuleDCEnd" message="$(string.RundownPublisher.ModuleDCEndOpcodeMessage)" symbol="CLR_LOADERDC_MODULEDCEND_OPCODE" value="36"> </opcode>
                            <opcode name="AssemblyDCStart" message="$(string.RundownPublisher.AssemblyDCStartOpcodeMessage)" symbol="CLR_LOADERDC_ASSEMBLYDCSTART_OPCODE" value="39"> </opcode>
                            <opcode name="AssemblyDCEnd" message="$(string.RundownPublisher.AssemblyDCEndOpcodeMessage)" symbol="CLR_LOADERDC_ASSEMBLYDCEND_OPCODE" value="40"> </opcode>
                            <opcode name="AppDomainDCStart" message="$(string.RundownPublisher.AppDomainDCStartOpcodeMessage)" symbol="CLR_LOADERDC_APPDOMAINDCSTART_OPCODE" value="43"> </opcode>
                            <opcode name="AppDomainDCEnd" message="$(string.RundownPublisher.AppDomainDCEndOpcodeMessage)" symbol="CLR_LOADERDC_APPDOMAINDCEND_OPCODE" value="44"> </opcode>
                            <opcode name="DomainModuleDCStart" message="$(string.RundownPublisher.DomainModuleDCStartOpcodeMessage)" symbol="CLR_LOADERDC_DOMAINMODULEDCSTART_OPCODE" value="46"> </opcode>
                            <opcode name="DomainModuleDCEnd" message="$(string.RundownPublisher.DomainModuleDCEndOpcodeMessage)" symbol="CLR_LOADERDC_DOMAINMODULEDCEND_OPCODE" value="47"> </opcode>
                            <opcode name="ThreadDC" message="$(string.RundownPublisher.ThreadDCOpcodeMessage)" symbol="CLR_LOADERDC_THREADDC_OPCODE" value="48"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRStackRundown" symbol="CLR_STACKRUNDOWN_TASK"
                          value="11" eventGUID="{d3363dc0-243a-4620-a4d0-8a07d772f533}"
                          message="$(string.RundownPublisher.StackTaskMessage)">
                        <opcodes>
                            <opcode name="CLRStackWalk" message="$(string.RundownPublisher.CLRStackWalkOpcodeMessage)" symbol="CLR_RUNDOWNSTACK_STACKWALK_OPCODE" value="82"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRRuntimeInformationRundown" symbol="CLR_RuntimeInformation_TASK"
                          value="19" eventGUID="{CD7D3E32-65FE-40cd-9225-A2577D203FC3}"
                          message="$(string.RundownPublisher.EEStartupTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="CLRPerfTrackRundown" symbol="CLR_PERFTRACKRUNDOWN_TASK"
                          value="20" eventGUID="{EAC685F6-2104-4dec-88FD-91E4254221EC}"
                          message="$(string.RundownPublisher.PerfTrackTaskMessage)">
                        <opcodes>
                            <opcode name="ModuleRangeDCStart" message="$(string.RundownPublisher.ModuleRangeDCStartOpcodeMessage)" symbol="CLR_PERFTRACKRUNDOWN_MODULERANGEDCSTART_OPCODE" value="10"> </opcode>
                            <opcode name="ModuleRangeDCEnd" message="$(string.RundownPublisher.ModuleRangeDCEndOpcodeMessage)" symbol="CLR_PERFTRACKRUNDOWN_MODULERANGEDCEND_OPCODE" value="11"> </opcode>
                        </opcodes>
                    </task>

                    <task name="TieredCompilationRundown" symbol="CLR_TIERED_COMPILATION_RUNDOWN_TASK"
                          value="31" eventGUID="{A1673472-0564-48EA-A95D-B49D4173F105}"
                          message="$(string.RundownPublisher.TieredCompilationTaskMessage)">
                        <opcodes>
                            <opcode name="SettingsDCStart" message="$(string.RundownPublisher.TieredCompilationSettingsDCStartOpcodeMessage)" symbol="CLR_TIERED_COMPILATION_SETTINGS_DCSTART_OPCODE" value="11"/>
                        </opcodes>
                    </task>
                </tasks>

                <maps>
                    <bitMap name="ModuleRangeTypeMap">
                        <map value="0x4" message="$(string.RundownPublisher.ModuleRangeTypeMap.ColdRangeMessage)"/>
                    </bitMap>

                    <!-- BitMaps -->
                    <bitMap name="AppDomainFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.AppDomain.DefaultMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.AppDomain.ExecutableMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.AppDomain.SharedMapMessage)"/>
                    </bitMap>
                    <bitMap name="AssemblyFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.Assembly.DomainNeutralMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.Assembly.DynamicMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.Assembly.NativeMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.Assembly.CollectibleMapMessage)"/>
                    </bitMap>
                    <bitMap name="ModuleFlagsMap">
                        <map value= "0x1" message="$(string.RundownPublisher.Module.DomainNeutralMapMessage)"/>
                        <map value= "0x2" message="$(string.RundownPublisher.Module.NativeMapMessage)"/>
                        <map value= "0x4" message="$(string.RundownPublisher.Module.DynamicMapMessage)"/>
                        <map value= "0x8" message="$(string.RundownPublisher.Module.ManifestMapMessage)"/>
                        <map value= "0x10" message="$(string.RundownPublisher.Module.IbcOptimizedMapMessage)"/>
                        <map value= "0x20" message="$(string.RundownPublisher.Module.ReadyToRunModuleMapMessage)"/>
                        <map value= "0x40" message="$(string.RundownPublisher.Module.PartialReadyToRunModuleMapMessage)"/>
                    </bitMap>
                    <bitMap name="MethodFlagsMap">
                        <map value="0x1" message="$(string.RundownPublisher.Method.DynamicMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.Method.GenericMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.Method.HasSharedGenericCodeMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.Method.JittedMapMessage)"/>
                        <map value="0x10" message="$(string.RuntimePublisher.Method.JitHelperMapMessage)"/>
                        <map value="0x20" message="$(string.RuntimePublisher.Method.ProfilerRejectedPrecompiledCodeMapMessage)"/>
                        <map value="0x40" message="$(string.RuntimePublisher.Method.ReadyToRunRejectedPrecompiledCodeMapMessage)"/>
                      <!-- 0x80 to 0x200 are used for the optimization tier -->
                    </bitMap>
                    <bitMap name="StartupModeMap">
                        <map value="0x1" message="$(string.RundownPublisher.StartupMode.ManagedExeMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.StartupMode.HostedCLRMapMessage)"/>
                        <map value="0x4" message="$(string.RundownPublisher.StartupMode.IjwDllMapMessage)"/>
                        <map value="0x8" message="$(string.RundownPublisher.StartupMode.ComActivatedMapMessage)"/>
                        <map value="0x10" message="$(string.RundownPublisher.StartupMode.OtherMapMessage)"/>
                    </bitMap>
                    <bitMap name="RuntimeSkuMap">
                        <map value="0x1" message="$(string.RundownPublisher.RuntimeSku.DesktopCLRMapMessage)"/>
                        <map value="0x2" message="$(string.RundownPublisher.RuntimeSku.CoreCLRMapMessage)"/>
                    </bitMap>
                    <bitMap name="StartupFlagsMap">
                        <map value="0x000001" message="$(string.RundownPublisher.Startup.CONCURRENT_GCMapMessage)"/>
                        <map value="0x000002" message="$(string.RundownPublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage)"/>
                        <map value="0x000004" message="$(string.RundownPublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage)"/>
                        <map value="0x000010" message="$(string.RundownPublisher.Startup.LOADER_SAFEMODEMapMessage)"/>
                        <map value="0x000100" message="$(string.RundownPublisher.Startup.LOADER_SETPREFERENCEMapMessage)"/>
                        <map value="0x001000" message="$(string.RundownPublisher.Startup.SERVER_GCMapMessage)"/>
                        <map value="0x002000" message="$(string.RundownPublisher.Startup.HOARD_GC_VMMapMessage)"/>
                        <map value="0x004000" message="$(string.RundownPublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage)"/>
                        <map value="0x010000" message="$(string.RundownPublisher.Startup.LEGACY_IMPERSONATIONMapMessage)"/>
                        <map value="0x020000" message="$(string.RundownPublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage)"/>
                        <map value="0x040000" message="$(string.RundownPublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage)"/>
                        <map value="0x080000" message="$(string.RundownPublisher.Startup.TRIM_GC_COMMITMapMessage)"/>
                        <map value="0x100000" message="$(string.RundownPublisher.Startup.ETWMapMessage)"/>
                        <map value="0x200000" message="$(string.RundownPublisher.Startup.SERVER_BUILDMapMessage)"/>
                        <map value="0x400000" message="$(string.RundownPublisher.Startup.ARMMapMessage)"/>
                    </bitMap>
                    <bitMap name="ThreadFlagsMap">
                      <map value="0x1" message="$(string.RundownPublisher.ThreadFlags.GCSpecial)"/>
                      <map value="0x2" message="$(string.RundownPublisher.ThreadFlags.Finalizer)"/>
                      <map value="0x4" message="$(string.RundownPublisher.ThreadFlags.ThreadPoolWorker)"/>
                    </bitMap>
                    <bitMap name="TieredCompilationSettingsFlagsMap">
                      <map value="0x0" message="$(string.RundownPublisher.TieredCompilationSettingsFlags.NoneMapMessage)"/>
                      <map value="0x1" message="$(string.RundownPublisher.TieredCompilationSettingsFlags.QuickJitMapMessage)"/>
                      <map value="0x2" message="$(string.RundownPublisher.TieredCompilationSettingsFlags.QuickJitForLoopsMapMessage)"/>
                    </bitMap>
                </maps>

                <!--Templates-->
                <templates>
                    <template tid="RuntimeInformationRundown">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Sku" inType="win:UInt16" map="RuntimeSkuMap" />
                        <data name="BclMajorVersion" inType="win:UInt16" />
                        <data name="BclMinorVersion" inType="win:UInt16" />
                        <data name="BclBuildNumber" inType="win:UInt16" />
                        <data name="BclQfeNumber" inType="win:UInt16" />
                        <data name="VMMajorVersion" inType="win:UInt16" />
                        <data name="VMMinorVersion" inType="win:UInt16" />
                        <data name="VMBuildNumber" inType="win:UInt16" />
                        <data name="VMQfeNumber" inType="win:UInt16" />
                        <data name="StartupFlags" inType="win:UInt32" map="StartupFlagsMap" />
                        <data name="StartupMode" inType="win:UInt8" map="StartupModeMap" />
                        <data name="CommandLine" inType="win:UnicodeString" />
                        <data name="ComObjectGuid" inType="win:GUID" />
                        <data name="RuntimeDllPath" inType="win:UnicodeString" />

                        <UserData>
                            <RuntimeInformationRundown xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <Sku> %2 </Sku>
                                <BclMajorVersion> %3 </BclMajorVersion>
                                <BclMinorVersion> %4 </BclMinorVersion>
                                <BclBuildNumber> %5 </BclBuildNumber>
                                <BclQfeNumber> %6 </BclQfeNumber>
                                <VMMajorVersion> %7 </VMMajorVersion>
                                <VMMinorVersion> %8 </VMMinorVersion>
                                <VMBuildNumber> %9 </VMBuildNumber>
                                <VMQfeNumber> %10 </VMQfeNumber>
                                <StartupFlags> %11 </StartupFlags>
                                <StartupMode> %12 </StartupMode>
                                <CommandLine> %13 </CommandLine>
                                <ComObjectGuid> %14 </ComObjectGuid>
                                <RuntimeDllPath> %15 </RuntimeDllPath>
                            </RuntimeInformationRundown>
                        </UserData>
                    </template>

                    <template tid="DomainModuleLoadUnloadRundown">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />

                        <UserData>
                            <DomainModuleLoadUnloadRundown xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                            </DomainModuleLoadUnloadRundown>
                        </UserData>
                    </template>

                    <template tid="DomainModuleLoadUnloadRundown_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <DomainModuleLoadUnloadRundown_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <AppDomainID> %3 </AppDomainID>
                                <ModuleFlags> %4 </ModuleFlags>
                                <ModuleILPath> %5 </ModuleILPath>
                                <ModuleNativePath> %6 </ModuleNativePath>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </DomainModuleLoadUnloadRundown_V1>
                        </UserData>
                    </template>

                    <template tid="ModuleLoadUnloadRundown">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />

                        <UserData>
                            <ModuleLoadUnloadRundown xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                            </ModuleLoadUnloadRundown>
                        </UserData>
                    </template>

                    <template tid="ModuleLoadUnloadRundown_V1">
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                        <data name="Reserved1"   inType="win:UInt32" />
                        <data name="ModuleILPath" inType="win:UnicodeString" />
                        <data name="ModuleNativePath" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ModuleLoadUnloadRundown_V1 xmlns="myNs">
                                <ModuleID> %1 </ModuleID>
                                <AssemblyID> %2 </AssemblyID>
                                <ModuleFlags> %3 </ModuleFlags>
                                <ModuleILPath> %4 </ModuleILPath>
                                <ModuleNativePath> %5 </ModuleNativePath>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ModuleLoadUnloadRundown_V1>
                        </UserData>
                    </template>

                    <template tid="ModuleLoadUnloadRundown_V2">
                      <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="ModuleFlags" inType="win:UInt32" map="ModuleFlagsMap" />
                      <data name="Reserved1"   inType="win:UInt32" />
                      <data name="ModuleILPath" inType="win:UnicodeString" />
                      <data name="ModuleNativePath" inType="win:UnicodeString" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <data name="ManagedPdbSignature" inType="win:GUID" />
                      <data name="ManagedPdbAge" inType="win:UInt32" />
                      <data name="ManagedPdbBuildPath" inType="win:UnicodeString" />
                      <data name="NativePdbSignature" inType="win:GUID" />
                      <data name="NativePdbAge" inType="win:UInt32" />
                      <data name="NativePdbBuildPath" inType="win:UnicodeString" />

                      <UserData>
                          <ModuleLoadUnloadRundown_V2 xmlns="myNs">
                              <ModuleID> %1 </ModuleID>
                              <AssemblyID> %2 </AssemblyID>
                              <ModuleFlags> %3 </ModuleFlags>
                              <ModuleILPath> %4 </ModuleILPath>
                              <ModuleNativePath> %5 </ModuleNativePath>
                              <ClrInstanceID> %6 </ClrInstanceID>
                              <ManagedPdbSignature> %7 </ManagedPdbSignature>
                              <ManagedPdbAge> %8 </ManagedPdbAge>
                              <ManagedPdbBuildPath> %9 </ManagedPdbBuildPath>
                              <NativePdbSignature> %10 </NativePdbSignature>
                              <NativePdbAge> %11 </NativePdbAge>
                              <NativePdbBuildPath> %12 </NativePdbBuildPath>
                          </ModuleLoadUnloadRundown_V2>
                        </UserData>
                    </template>

                    <template tid="AssemblyLoadUnloadRundown">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap" />
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString" />

                        <UserData>
                            <AssemblyLoadUnloadRundown xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <AssemblyFlags> %3 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %4 </FullyQualifiedAssemblyName>
                            </AssemblyLoadUnloadRundown>
                        </UserData>
                    </template>

                    <template tid="AssemblyLoadUnloadRundown_V1">
                        <data name="AssemblyID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="BindingID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AssemblyFlags" inType="win:UInt32" map="AssemblyFlagsMap" />
                        <data name="FullyQualifiedAssemblyName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <AssemblyLoadUnloadRundown_V1 xmlns="myNs">
                                <AssemblyID> %1 </AssemblyID>
                                <AppDomainID> %2 </AppDomainID>
                                <BindingID> %3 </BindingID>
                                <AssemblyFlags> %4 </AssemblyFlags>
                                <FullyQualifiedAssemblyName> %5 </FullyQualifiedAssemblyName>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </AssemblyLoadUnloadRundown_V1>
                        </UserData>
                    </template>

                    <template tid="AppDomainLoadUnloadRundown">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap" />
                        <data name="AppDomainName" inType="win:UnicodeString" />

                        <UserData>
                            <AppDomainLoadUnloadRundown xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                            </AppDomainLoadUnloadRundown>
                        </UserData>
                    </template>

                    <template tid="AppDomainLoadUnloadRundown_V1">
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainFlags" inType="win:UInt32" map="AppDomainFlagsMap" />
                        <data name="AppDomainName" inType="win:UnicodeString" />
                        <data name="AppDomainIndex" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <AppDomainLoadUnloadRundown_V1 xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <AppDomainFlags> %2 </AppDomainFlags>
                                <AppDomainName> %3 </AppDomainName>
                                <AppDomainIndex> %4 </AppDomainIndex>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </AppDomainLoadUnloadRundown_V1>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadRundown">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" />
                        <data name="MethodToken" inType="win:UInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />

                        <UserData>
                            <MethodLoadUnloadRundown xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                            </MethodLoadUnloadRundown>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadRundown_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodLoadUnloadRundown_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </MethodLoadUnloadRundown_V1>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadRundown_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64" />

                        <UserData>
                            <MethodLoadUnloadRundown_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <ClrInstanceID> %7 </ClrInstanceID>
                                <ReJITID> %8 </ReJITID>
                            </MethodLoadUnloadRundown_V2>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadRundownVerbose">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <UserData>
                            <MethodLoadUnloadRundownVerbose xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                            </MethodLoadUnloadRundownVerbose>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadRundownVerbose_V1">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <MethodLoadUnloadRundownVerbose_V1 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                            </MethodLoadUnloadRundownVerbose_V1>
                        </UserData>
                    </template>

                    <template tid="MethodLoadUnloadRundownVerbose_V2">
                        <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ModuleID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodStartAddress" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="MethodSize" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodToken" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="MethodFlags" inType="win:UInt32" map="MethodFlagsMap" />
                        <data name="MethodNamespace" inType="win:UnicodeString" />
                        <data name="MethodName" inType="win:UnicodeString" />
                        <data name="MethodSignature" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64" />
                        <UserData>
                            <MethodLoadUnloadRundownVerbose_V2 xmlns="myNs">
                                <MethodID> %1 </MethodID>
                                <ModuleID> %2 </ModuleID>
                                <MethodStartAddress> %3 </MethodStartAddress>
                                <MethodSize> %4 </MethodSize>
                                <MethodToken> %5 </MethodToken>
                                <MethodFlags> %6 </MethodFlags>
                                <MethodNamespace> %7 </MethodNamespace>
                                <MethodName> %8 </MethodName>
                                <MethodSignature> %9 </MethodSignature>
                                <ClrInstanceID> %10 </ClrInstanceID>
                                <ReJITID> %11 </ReJITID>
                            </MethodLoadUnloadRundownVerbose_V2>
                        </UserData>
                    </template>

                    <template tid="MethodILToNativeMapRundown">
                      <data name="MethodID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="ReJITID" inType="win:UInt64" outType="win:HexInt64" />
                      <data name="MethodExtent" inType="win:UInt8" />
                      <data name="CountOfMapEntries" inType="win:UInt16" />
                      <data name="ILOffsets" count="CountOfMapEntries" inType="win:UInt32" />
                      <data name="NativeOffsets" count="CountOfMapEntries" inType="win:UInt32" />
                      <data name="ClrInstanceID" inType="win:UInt16" />
                      <UserData>
                        <MethodILToNativeMap xmlns="myNs">
                          <MethodID> %1 </MethodID>
                          <ReJITID> %2 </ReJITID>
                          <MethodExtent> %3 </MethodExtent>
                          <CountOfMapEntries> %4 </CountOfMapEntries>
                          <ClrInstanceID> %5 </ClrInstanceID>
                        </MethodILToNativeMap>
                      </UserData>
                    </template>

                    <template tid="DCStartEnd">
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <DCStartEnd xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </DCStartEnd>
                        </UserData>
                    </template>

                    <template tid="ClrStackWalk">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Reserved1" inType="win:UInt8" />
                        <data name="Reserved2" inType="win:UInt8" />
                        <data name="FrameCount" inType="win:UInt32" />
                        <data name="Stack" count="2" inType="win:Pointer" />
                    </template>

                    <template tid="ThreadCreatedRundown">
                        <data name="ManagedThreadID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="Flags" inType="win:UInt32" map="ThreadFlagsMap" />
                        <data name="ManagedThreadIndex" inType="win:UInt32" />
                        <data name="OSThreadID" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ThreadCreatedRundown xmlns="myNs">
                                <ManagedThreadID> %1 </ManagedThreadID>
                                <AppDomainID> %2 </AppDomainID>
                                <Flags> %3 </Flags>
                                <ManagedThreadIndex> %4 </ManagedThreadIndex>
                                <OSThreadID> %5 </OSThreadID>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </ThreadCreatedRundown>
                        </UserData>
                    </template>

                    <template tid="ModuleRangeRundown">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ModuleID" inType="win:UInt64"  outType="win:HexInt64"/>
                        <data name="RangeBegin" count="1" inType="win:UInt32"  outType="win:HexInt32"/>
                        <data name="RangeSize" count="1" inType="win:UInt32"  outType="win:HexInt32"/>
                        <data name="RangeType" map="ModuleRangeTypeMap" inType="win:UInt8"/>
                        <UserData>
                            <ModuleRangeRundown xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <RangeBegin> %3 </RangeBegin>
                                <RangeSize> %4 </RangeSize>
                                <RangeType> %5 </RangeType>
                            </ModuleRangeRundown>
                        </UserData>
                    </template>

                    <template tid="TieredCompilationSettings">
                      <data name="ClrInstanceID" inType="win:UInt16"/>
                      <data name="Flags" inType="win:UInt32" outType="win:HexInt32" map="TieredCompilationSettingsFlagsMap"/>
                      <UserData>
                        <Settings xmlns="myNs">
                          <ClrInstanceID> %1 </ClrInstanceID>
                          <Flags> %2 </Flags>
                        </Settings>
                      </UserData>
                    </template>
                </templates>

                <events>
                    <!-- CLR StackWalk Rundown Events -->
                    <event value="0" version="0" level="win:LogAlways"  template="ClrStackWalk"
                           keywords ="StackKeyword"  opcode="CLRStackWalk"
                           task="CLRStackRundown"
                           symbol="CLRStackWalkDCStart" message="$(string.RundownPublisher.StackEventMessage)"/>

                    <!-- CLR Method Rundown Events -->
                    <event value="141" version="0" level="win:Informational"  template="MethodLoadUnloadRundown"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStart"
                           task="CLRMethodRundown"
                           symbol="MethodDCStart" message="$(string.RundownPublisher.MethodDCStartEventMessage)"/>

                    <event value="141" version="1" level="win:Informational"  template="MethodLoadUnloadRundown_V1"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStart"
                           task="CLRMethodRundown"
                           symbol="MethodDCStart_V1" message="$(string.RundownPublisher.MethodDCStart_V1EventMessage)"/>

                    <event value="141" version="2" level="win:Informational"  template="MethodLoadUnloadRundown_V2"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStart"
                           task="CLRMethodRundown"
                           symbol="MethodDCStart_V2" message="$(string.RundownPublisher.MethodDCStart_V2EventMessage)"/>

                    <event value="142" version="0" level="win:Informational"  template="MethodLoadUnloadRundown"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEnd"
                           task="CLRMethodRundown"
                           symbol="MethodDCEnd" message="$(string.RundownPublisher.MethodDCEndEventMessage)"/>

                    <event value="142" version="1" level="win:Informational"  template="MethodLoadUnloadRundown_V1"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEnd"
                           task="CLRMethodRundown"
                           symbol="MethodDCEnd_V1" message="$(string.RundownPublisher.MethodDCEnd_V1EventMessage)"/>

                    <event value="142" version="2" level="win:Informational"  template="MethodLoadUnloadRundown_V2"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEnd"
                           task="CLRMethodRundown"
                           symbol="MethodDCEnd_V2" message="$(string.RundownPublisher.MethodDCEnd_V2EventMessage)"/>

                    <event value="143" version="0" level="win:Informational"  template="MethodLoadUnloadRundownVerbose"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStartVerbose"
                           task="CLRMethodRundown"
                           symbol="MethodDCStartVerbose" message="$(string.RundownPublisher.MethodDCStartVerboseEventMessage)"/>

                    <event value="143" version="1" level="win:Informational"  template="MethodLoadUnloadRundownVerbose_V1"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStartVerbose"
                           task="CLRMethodRundown"
                           symbol="MethodDCStartVerbose_V1" message="$(string.RundownPublisher.MethodDCStartVerbose_V1EventMessage)"/>

                    <event value="143" version="2" level="win:Informational"  template="MethodLoadUnloadRundownVerbose_V2"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCStartVerbose"
                           task="CLRMethodRundown"
                           symbol="MethodDCStartVerbose_V2" message="$(string.RundownPublisher.MethodDCStartVerbose_V2EventMessage)"/>

                    <event value="144" version="0" level="win:Informational"  template="MethodLoadUnloadRundownVerbose"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEndVerbose"
                           task="CLRMethodRundown"
                           symbol="MethodDCEndVerbose" message="$(string.RundownPublisher.MethodDCEndVerboseEventMessage)"/>

                    <event value="144" version="1" level="win:Informational"  template="MethodLoadUnloadRundownVerbose_V1"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEndVerbose"
                           task="CLRMethodRundown"
                           symbol="MethodDCEndVerbose_V1" message="$(string.RundownPublisher.MethodDCEndVerbose_V1EventMessage)"/>

                    <event value="144" version="2" level="win:Informational"  template="MethodLoadUnloadRundownVerbose_V2"
                           keywords ="JitRundownKeyword NGenRundownKeyword" opcode="MethodDCEndVerbose"
                           task="CLRMethodRundown"
                           symbol="MethodDCEndVerbose_V2" message="$(string.RundownPublisher.MethodDCEndVerbose_V2EventMessage)"/>

                    <event value="145" version="0" level="win:Informational"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartComplete"
                           task="CLRMethodRundown"
                           symbol="DCStartComplete"/>

                    <event value="145" version="1" level="win:Informational" template="DCStartEnd"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartComplete"
                           task="CLRMethodRundown"
                           symbol="DCStartComplete_V1" message="$(string.RundownPublisher.DCStartCompleteEventMessage)"/>

                    <event value="146" version="0" level="win:Informational"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndComplete"
                           task="CLRMethodRundown"
                           symbol="DCEndComplete"/>

                    <event value="146" version="1" level="win:Informational" template="DCStartEnd"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndComplete"
                           task="CLRMethodRundown"
                           symbol="DCEndComplete_V1" message="$(string.RundownPublisher.DCEndCompleteEventMessage)"/>

                    <event value="147" version="0" level="win:Informational"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartInit"
                           task="CLRMethodRundown"
                           symbol="DCStartInit"/>

                    <event value="147" version="1" level="win:Informational" template="DCStartEnd"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCStartInit"
                           task="CLRMethodRundown"
                           symbol="DCStartInit_V1" message="$(string.RundownPublisher.DCStartInitEventMessage)"/>

                    <event value="148" version="0" level="win:Informational"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndInit"
                           task="CLRMethodRundown"
                           symbol="DCEndInit"/>

                    <event value="148" version="1" level="win:Informational" template="DCStartEnd"
                           keywords ="JitRundownKeyword JittedMethodILToNativeMapRundownKeyword NGenRundownKeyword LoaderRundownKeyword" opcode="DCEndInit"
                           task="CLRMethodRundown"
                           symbol="DCEndInit_V1" message="$(string.RundownPublisher.DCEndInitEventMessage)"/>

                    <event value="149" version="0" level="win:Verbose"  template="MethodILToNativeMapRundown"
                           keywords ="JittedMethodILToNativeMapRundownKeyword" opcode="MethodDCStartILToNativeMap"
                           task="CLRMethodRundown"
                           symbol="MethodDCStartILToNativeMap"
                           message="$(string.RundownPublisher.MethodDCStartILToNativeMapEventMessage)"/>

                    <event value="150" version="0" level="win:Verbose"  template="MethodILToNativeMapRundown"
                           keywords ="JittedMethodILToNativeMapRundownKeyword" opcode="MethodDCEndILToNativeMap"
                           task="CLRMethodRundown"
                           symbol="MethodDCEndILToNativeMap"
                           message="$(string.RundownPublisher.MethodDCEndILToNativeMapEventMessage)"/>

                    <!-- CLR Loader Rundown Events -->
                    <event value="151" version="0" level="win:Informational"  template="DomainModuleLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="DomainModuleDCStart"
                           task="CLRLoaderRundown"
                           symbol="DomainModuleDCStart" message="$(string.RundownPublisher.DomainModuleDCStartEventMessage)"/>

                    <event value="151" version="1" level="win:Informational"  template="DomainModuleLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword" opcode="DomainModuleDCStart"
                           task="CLRLoaderRundown"
                           symbol="DomainModuleDCStart_V1" message="$(string.RundownPublisher.DomainModuleDCStart_V1EventMessage)"/>

                    <event value="152" version="0" level="win:Informational"  template="DomainModuleLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="DomainModuleDCEnd"
                           task="CLRLoaderRundown"
                           symbol="DomainModuleDCEnd" message="$(string.RundownPublisher.DomainModuleDCEndEventMessage)"/>

                    <event value="152" version="1" level="win:Informational"  template="DomainModuleLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword" opcode="DomainModuleDCEnd"
                           task="CLRLoaderRundown"
                           symbol="DomainModuleDCEnd_V1" message="$(string.RundownPublisher.DomainModuleDCEnd_V1EventMessage)"/>

                    <event value="153" version="0" level="win:Informational"  template="ModuleLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="ModuleDCStart"
                           task="CLRLoaderRundown"
                           symbol="ModuleDCStart" message="$(string.RundownPublisher.ModuleDCStartEventMessage)"/>

                    <event value="153" version="1" level="win:Informational"  template="ModuleLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCStart"
                           task="CLRLoaderRundown"
                           symbol="ModuleDCStart_V1" message="$(string.RundownPublisher.ModuleDCStart_V1EventMessage)"/>

                    <event value="153" version="2" level="win:Informational"  template="ModuleLoadUnloadRundown_V2"
                           keywords ="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCStart"
                           task="CLRLoaderRundown"
                           symbol="ModuleDCStart_V2" message="$(string.RundownPublisher.ModuleDCStart_V2EventMessage)"/>

                    <event value="154" version="0" level="win:Informational"  template="ModuleLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="ModuleDCEnd"
                           task="CLRLoaderRundown"
                           symbol="ModuleDCEnd" message="$(string.RundownPublisher.ModuleDCEndEventMessage)"/>

                    <event value="154" version="1" level="win:Informational"  template="ModuleLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCEnd"
                           task="CLRLoaderRundown"
                           symbol="ModuleDCEnd_V1" message="$(string.RundownPublisher.ModuleDCEnd_V1EventMessage)"/>

                    <event value="154" version="2" level="win:Informational"  template="ModuleLoadUnloadRundown_V2"
                           keywords ="LoaderRundownKeyword PerfTrackRundownKeyword" opcode="ModuleDCEnd"
                           task="CLRLoaderRundown"
                           symbol="ModuleDCEnd_V2" message="$(string.RundownPublisher.ModuleDCEnd_V2EventMessage)"/>

                    <event value="155" version="0" level="win:Informational"  template="AssemblyLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="AssemblyDCStart"
                           task="CLRLoaderRundown"
                           symbol="AssemblyDCStart" message="$(string.RundownPublisher.AssemblyDCStartEventMessage)"/>

                    <event value="155" version="1" level="win:Informational"  template="AssemblyLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword" opcode="AssemblyDCStart"
                           task="CLRLoaderRundown"
                           symbol="AssemblyDCStart_V1" message="$(string.RundownPublisher.AssemblyDCStart_V1EventMessage)"/>

                    <event value="156" version="0" level="win:Informational"  template="AssemblyLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="AssemblyDCEnd"
                           task="CLRLoaderRundown"
                           symbol="AssemblyDCEnd" message="$(string.RundownPublisher.AssemblyDCEndEventMessage)"/>

                    <event value="156" version="1" level="win:Informational"  template="AssemblyLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword" opcode="AssemblyDCEnd"
                           task="CLRLoaderRundown"
                           symbol="AssemblyDCEnd_V1" message="$(string.RundownPublisher.AssemblyDCEnd_V1EventMessage)"/>

                    <event value="157" version="0" level="win:Informational"  template="AppDomainLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="AppDomainDCStart"
                           task="CLRLoaderRundown"
                           symbol="AppDomainDCStart" message="$(string.RundownPublisher.AppDomainDCStartEventMessage)"/>

                    <event value="157" version="1" level="win:Informational"  template="AppDomainLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword" opcode="AppDomainDCStart"
                           task="CLRLoaderRundown"
                           symbol="AppDomainDCStart_V1" message="$(string.RundownPublisher.AppDomainDCStart_V1EventMessage)"/>

                    <event value="158" version="0" level="win:Informational"  template="AppDomainLoadUnloadRundown"
                           keywords ="LoaderRundownKeyword" opcode="AppDomainDCEnd"
                           task="CLRLoaderRundown"
                           symbol="AppDomainDCEnd" message="$(string.RundownPublisher.AppDomainDCEndEventMessage)"/>

                    <event value="158" version="1" level="win:Informational"  template="AppDomainLoadUnloadRundown_V1"
                           keywords ="LoaderRundownKeyword" opcode="AppDomainDCEnd"
                           task="CLRLoaderRundown"
                           symbol="AppDomainDCEnd_V1" message="$(string.RundownPublisher.AppDomainDCEnd_V1EventMessage)"/>

                    <event value="159" version="0" level="win:Informational"  template="ThreadCreatedRundown"
                           keywords ="AppDomainResourceManagementRundownKeyword ThreadingKeyword" opcode="ThreadDC"
                           task="CLRLoaderRundown"
                           symbol="ThreadDC" message="$(string.RundownPublisher.ThreadCreatedEventMessage)"/>

                    <event value="160" version="0" level="win:Informational"  template="ModuleRangeRundown"
                           keywords ="PerfTrackRundownKeyword" opcode="ModuleRangeDCStart"
                           task="CLRPerfTrackRundown"
                           symbol="ModuleRangeDCStart" message="$(string.RundownPublisher.ModuleRangeDCStartEventMessage)"/>

                    <event value="161" version="0" level="win:Informational"  template="ModuleRangeRundown"
                           keywords ="PerfTrackRundownKeyword" opcode="ModuleRangeDCEnd"
                           task="CLRPerfTrackRundown"
                           symbol="ModuleRangeDCEnd" message="$(string.RundownPublisher.ModuleRangeDCEndEventMessage)"/>

                    <!-- CLR Runtime Information events for rundown -->
                    <event value="187" version="0" level="win:Informational"  template="RuntimeInformationRundown"
                           opcode="win:Start"
                           task="CLRRuntimeInformationRundown"
                           symbol="RuntimeInformationDCStart" message="$(string.RundownPublisher.RuntimeInformationEventMessage)"/>

                    <!-- Tiered compilation events 280-289 -->
                    <event value="280" version="0" level="win:Informational" template="TieredCompilationSettings"
                           keywords="CompilationKeyword" task="TieredCompilationRundown" opcode="SettingsDCStart"
                           symbol="TieredCompilationSettingsDCStart" message="$(string.RundownPublisher.TieredCompilationSettingsDCStartEventMessage)"/>
                </events>
            </provider>

            <provider name="Microsoft-Windows-DotNETRuntimeStress"
                      guid="{CC2BCBBA-16B6-4cf3-8990-D74C2E8AF500}"
                      symbol="MICROSOFT_WINDOWS_DOTNETRUNTIME_STRESS_PROVIDER"
                      resourceFileName="%INSTALL_PATH%\clretwrc.dll"
                      messageFileName="%INSTALL_PATH%\clretwrc.dll">
                <!-- CLR Stress Publisher-->

                <!--Keywords-->
                <keywords>
                    <!-- Add your keywords here -->
                    <keyword name="StackKeyword" mask="0x40000000"
                             message="$(string.StressPublisher.StackKeywordMessage)" symbol="CLR_STRESSSTACK_KEYWORD"/>
                </keywords>

                <!--Tasks-->
                <tasks>
                    <task name="StressLogTask" symbol="CLR_STRESSLOG_TASK" value="1"
                          eventGUID="{EA40C74D-4F65-4561-BB26-656231C8967F}"
                          message="$(string.StressPublisher.StressTaskMessage)">
                        <opcodes>
                        </opcodes>
                    </task>

                    <task name="CLRStackStress" symbol="CLR_STACKSTRESS_TASK"
                          value="11" eventGUID="{d3363dc0-243a-4620-a4d0-8a07d772f533}"
                          message="$(string.StressPublisher.StackTaskMessage)">
                        <opcodes>
                            <opcode name="CLRStackWalk" message="$(string.StressPublisher.CLRStackWalkOpcodeMessage)" symbol="CLR_STRESSSTACK_STACKWALK_OPCODE" value="82"> </opcode>
                        </opcodes>
                    </task>
                </tasks>

                <!--Templates-->
                <templates>
                    <template tid="StressLog">
                        <data name="Facility" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="LogLevel" inType="win:UInt8" />
                        <data name="Message" inType="win:AnsiString" />

                        <UserData>
                            <StressLog xmlns="myNs">
                                <Facility> %1 </Facility>
                                <LogLevel> %2 </LogLevel>
                                <Message> %3 </Message>
                            </StressLog>
                        </UserData>
                    </template>

                    <template tid="StressLog_V1">
                        <data name="Facility" inType="win:UInt32" outType="win:HexInt32" />
                        <data name="LogLevel" inType="win:UInt8" />
                        <data name="Message" inType="win:AnsiString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <StressLog_V1 xmlns="myNs">
                                <Facility> %1 </Facility>
                                <LogLevel> %2 </LogLevel>
                                <Message> %3 </Message>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </StressLog_V1>
                        </UserData>
                    </template>

                    <template tid="ClrStackWalk">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Reserved1" inType="win:UInt8" />
                        <data name="Reserved2" inType="win:UInt8" />
                        <data name="FrameCount" inType="win:UInt32" />
                        <data name="Stack" count="2" inType="win:Pointer" />
                    </template>
                </templates>

                <!--Events-->
                <events>
                    <event value="0" version="0" level="win:Informational"  template="StressLog"
                           task="StressLogTask"
                           opcode="win:Start"
                           symbol="StressLogEvent" message="$(string.StressPublisher.StressLogEventMessage)"/>

                    <event value="0" version="1" level="win:Informational"  template="StressLog_V1"
                           task="StressLogTask"
                           opcode="win:Start"
                           symbol="StressLogEvent_V1" message="$(string.StressPublisher.StressLog_V1EventMessage)"/>

                    <event value="1" version="0" level="win:LogAlways"  template="ClrStackWalk"
                           keywords ="StackKeyword"  opcode="CLRStackWalk"
                           task="CLRStackStress"
                           symbol="CLRStackWalkStress" message="$(string.StressPublisher.StackEventMessage)"/>
                </events>
            </provider>

            <!-- CLR Private Publisher-->
            <provider name="Microsoft-Windows-DotNETRuntimePrivate"
                      guid="{763FD754-7086-4dfe-95EB-C01A46FAF4CA}"
                      symbol="MICROSOFT_WINDOWS_DOTNETRUNTIME_PRIVATE_PROVIDER"
                      resourceFileName="%INSTALL_PATH%\clretwrc.dll"
                      messageFileName="%INSTALL_PATH%\clretwrc.dll">
                <!--CLR Private Publisher-->

                <!--Keywords-->
                <keywords>
                    <keyword name="GCPrivateKeyword" mask="0x00000001"
                             message="$(string.PrivatePublisher.GCPrivateKeywordMessage)"  symbol="CLR_PRIVATEGC_KEYWORD"/>
                    <keyword name="BindingKeyword" mask="0x00000002"
                             message="$(string.PrivatePublisher.BindingKeywordMessage)" symbol="CLR_PRIVATEBINDING_KEYWORD"/>
                    <keyword name="NGenForceRestoreKeyword" mask="0x00000004"
                             message="$(string.PrivatePublisher.NGenForceRestoreKeywordMessage)" symbol="CLR_PRIVATENGENFORCERESTORE_KEYWORD"/>
                    <keyword name="PrivateFusionKeyword" mask="0x00000008"
                             message="$(string.PrivatePublisher.PrivateFusionKeywordMessage)" symbol="CLR_PRIVATEFUSION_KEYWORD"/>
                    <keyword name="LoaderHeapPrivateKeyword" mask="0x00000010"
                             message="$(string.PrivatePublisher.LoaderHeapPrivateKeywordMessage)" symbol="CLR_PRIVATELOADERHEAP_KEYWORD"/>
                    <keyword name="SecurityPrivateKeyword" mask="0x00000400"
                             message="$(string.PrivatePublisher.SecurityPrivateKeywordMessage)" symbol="CLR_PRIVATESECURITY_KEYWORD"/>
                    <keyword name="InteropPrivateKeyword" mask="0x2000"
                             message="$(string.PrivatePublisher.InteropPrivateKeywordMessage)" symbol="CLR_INTEROP_KEYWORD"/>
                    <keyword name="GCHandlePrivateKeyword" mask="0x4000"
                             message="$(string.PrivatePublisher.GCHandlePrivateKeywordMessage)" symbol="CLR_PRIVATEGCHANDLE_KEYWORD"/>
                    <keyword name="MulticoreJitPrivateKeyword" mask="0x20000"
                             message="$(string.PrivatePublisher.MulticoreJitPrivateKeywordMessage)" symbol="CLR_PRIVATEMULTICOREJIT_KEYWORD"/>
                    <keyword name="StackKeyword" mask="0x40000000"
                             message="$(string.PrivatePublisher.StackKeywordMessage)" symbol="CLR_PRIVATESTACK_KEYWORD"/>
                    <keyword name="StartupKeyword" mask="0x80000000"
                             message="$(string.PrivatePublisher.StartupKeywordMessage)"  symbol="CLR_PRIVATESTARTUP_KEYWORD"/>
                    <keyword name="PerfTrackPrivateKeyword" mask="0x20000000"
                      message="$(string.PrivatePublisher.PerfTrackKeywordMessage)" symbol="CLR_PERFTRACK_PRIVATE_KEYWORD"/>

	            <!-- NOTE: This is not used anymore. They are kept around for backcompat with traces that might have already contained these -->
                    <keyword name="DynamicTypeUsageKeyword" mask="0x00000020"
                             message="$(string.PrivatePublisher.DynamicTypeUsageMessage)" symbol="CLR_PRIVATE_DYNAMICTYPEUSAGE_KEYWORD"/>
                </keywords>

                <!--Tasks-->
                <tasks>
                    <task name="GarbageCollectionPrivate" symbol="CLR_GCPRIVATE_TASK"
                          value="1" eventGUID="{2f1b6bf6-18ff-4645-9501-15df6c64c2cf}"
                          message="$(string.PrivatePublisher.GarbageCollectionTaskMessage)">
                        <opcodes>
                            <opcode name="GCDecision" message="$(string.PrivatePublisher.GCDecisionOpcodeMessage)" symbol="CLR_PRIVATEGC_GCDECISION_OPCODE" value="132"> </opcode>
                            <opcode name="GCSettings" message="$(string.PrivatePublisher.GCSettingsOpcodeMessage)" symbol="CLR_PRIVATEGC_GCSETTINGS_OPCODE" value="14"> </opcode>
                            <opcode name="GCOptimized" message="$(string.PrivatePublisher.GCOptimizedOpcodeMessage)" symbol="CLR_PRIVATEGC_GCOPTIMIZED_OPCODE" value="16"> </opcode>
                            <opcode name="GCPerHeapHistory" message="$(string.PrivatePublisher.GCPerHeapHistoryOpcodeMessage)" symbol="CLR_PRIVATEGC_GCPERHEAPHISTORY_OPCODE" value="17"> </opcode>
                            <opcode name="GCGlobalHeapHistory" message="$(string.PrivatePublisher.GCGlobalHeapHistoryOpcodeMessage)" symbol="CLR_PRIVATEGC_GCGLOBALHEAPHISTORY_OPCODE" value="18"> </opcode>
                            <opcode name="GCFullNotify" message="$(string.PrivatePublisher.GCFullNotifyOpcodeMessage)" symbol="CLR_PRIVATEGC_GCFULLNOTIFY_OPCODE" value="19"> </opcode>
                            <opcode name="GCJoin" message="$(string.PrivatePublisher.GCJoinOpcodeMessage)" symbol="CLR_PRIVATEGC_JOIN_OPCODE" value="20"> </opcode>
                            <opcode name="PrvGCMarkStackRoots" message="$(string.PrivatePublisher.GCMarkStackRootsOpcodeMessage)" symbol="CLR_PRIVATEGC_MARKSTACKROOTS_OPCODE" value="21"> </opcode>
                            <opcode name="PrvGCMarkFinalizeQueueRoots" message="$(string.PrivatePublisher.GCMarkFinalizeQueueRootsOpcodeMessage)" symbol="CLR_PRIVATEGC_MARKFINALIZEQUEUEROOTS_OPCODE" value="22"> </opcode>
                            <opcode name="PrvGCMarkHandles" message="$(string.PrivatePublisher.GCMarkHandlesOpcodeMessage)" symbol="CLR_PRIVATEGC_MARKHANDLES_OPCODE" value="23"> </opcode>
                            <opcode name="PrvGCMarkCards" message="$(string.PrivatePublisher.GCMarkCardsOpcodeMessage)" symbol="CLR_PRIVATEGC_MARKCARDS_OPCODE" value="24"> </opcode>
                            <opcode name="BGCBegin" message="$(string.PrivatePublisher.BGCBeginOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCBEGIN_OPCODE" value="25"> </opcode>
                            <opcode name="BGC1stNonConEnd" message="$(string.PrivatePublisher.BGC1stNonCondEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC1STNONCONEND_OPCODE" value="26"> </opcode>
                            <opcode name="BGC1stConEnd" message="$(string.PrivatePublisher.BGC1stConEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC1STCONEND_OPCODE" value="27"> </opcode>
                            <opcode name="BGC2ndNonConBegin" message="$(string.PrivatePublisher.BGC2ndNonConBeginOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC2NDNONCONBEGIN_OPCODE" value="28"> </opcode>
                            <opcode name="BGC2ndNonConEnd" message="$(string.PrivatePublisher.BGC2ndNonConEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC2NDNONCONEND_OPCODE" value="29"> </opcode>
                            <opcode name="BGC2ndConBegin" message="$(string.PrivatePublisher.BGC2ndConBeginOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC2NDCONBEGIN_OPCODE" value="30"> </opcode>
                            <opcode name="BGC2ndConEnd" message="$(string.PrivatePublisher.BGC2ndConEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC2NDCONEND_OPCODE" value="31"> </opcode>
                            <opcode name="BGCPlanEnd" message="$(string.PrivatePublisher.BGCPlanEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCPLANEND_OPCODE" value="32"> </opcode>
                            <opcode name="BGCSweepEnd" message="$(string.PrivatePublisher.BGCSweepEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCSWEEPEND_OPCODE" value="33"> </opcode>
                            <opcode name="BGCDrainMark" message="$(string.PrivatePublisher.BGCDrainMarkOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCDRAINMARK_OPCODE" value="34"> </opcode>
                            <opcode name="BGCRevisit" message="$(string.PrivatePublisher.BGCRevisitOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCREVISIT_OPCODE" value="35"> </opcode>
                            <opcode name="BGCOverflow" message="$(string.PrivatePublisher.BGCOverflowOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCOVERFLOW_OPCODE" value="36"> </opcode>
                            <opcode name="BGCAllocWaitBegin" message="$(string.PrivatePublisher.BGCAllocWaitBeginOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCALLOCWAITBEGIN_OPCODE" value="37"> </opcode>
                            <opcode name="BGCAllocWaitEnd" message="$(string.PrivatePublisher.BGCAllocWaitEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGCALLOCWAITEND_OPCODE" value="38"> </opcode>
                            <opcode name="PrvFinalizeObject" message="$(string.PrivatePublisher.FinalizeObjectOpcodeMessage)" symbol="CLR_PRIVATEGC_FINALIZEOBJECT_OPCODE" value="39"> </opcode>
                            <opcode name="CCWRefCountChange" message="$(string.PrivatePublisher.CCWRefCountChangeOpcodeMessage)" symbol="CLR_PRIVATEGC_CCWREFCOUNTCHANGE_OPCODE" value="40"> </opcode>
                            <opcode name="SetGCHandle" message="$(string.PrivatePublisher.SetGCHandleOpcodeMessage)" symbol="CLR_PRIVATEGC_SETGCHANDLE_OPCODE" value="42"> </opcode>
                            <opcode name="DestroyGCHandle" message="$(string.PrivatePublisher.DestroyGCHandleOpcodeMessage)" symbol="CLR_PRIVATEGC_DESTROYGCHANDLE_OPCODE" value="43"> </opcode>
                            <opcode name="PinPlugAtGCTime" message="$(string.PrivatePublisher.PinPlugAtGCTimeOpcodeMessage)" symbol="CLR_PRIVATEGC_PINGCPLUG_OPCODE" value="44"> </opcode>
                            <opcode name="BGC1stSweepEnd" message="$(string.PrivatePublisher.BGC1stSweepEndOpcodeMessage)" symbol="CLR_PRIVATEGC_BGC1STSWEEPEND_OPCODE" value="45"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRFailFast" symbol="CLR_FAILFAST_TASK"
                          value="2" eventGUID="{EE9EDE12-C5F5-4995-81A2-DCFB5F6B80C8}"
                          message="$(string.PrivatePublisher.FailFastTaskMessage)">
                        <opcodes>
                            <opcode name="FailFast" message="$(string.PrivatePublisher.FailFastOpcodeMessage)" symbol="CLR_FAILFAST_FAILFAST_OPCODE" value="52"> </opcode>
                        </opcodes>
                    </task>

                    <task name="Startup" symbol="CLR_STARTUP_TASK"
                          value="9" eventGUID="{02D08A4F-FD01-4538-989B-03E437B950F4}"
                          message="$(string.PrivatePublisher.StartupTaskMessage)">
                        <opcodes>
                            <opcode name="EEStartupStart" message="$(string.PrivatePublisher.EEStartupStartOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EESTARTUPSTART_OPCODE" value="128"> </opcode>
                            <opcode name="EEStartupEnd" message="$(string.PrivatePublisher.EEStartupEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EESTARTUPEND_OPCODE" value="129"> </opcode>
                            <opcode name="EEConfigSetup" message="$(string.PrivatePublisher.EEConfigSetupOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EECONFIGSETUP_OPCODE" value="130"> </opcode>
                            <opcode name="EEConfigSetupEnd" message="$(string.PrivatePublisher.EEConfigSetupEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EECONFIGSETUPEND_OPCODE" value="131"> </opcode>
                            <opcode name="LoadSystemBases" message="$(string.PrivatePublisher.LoadSystemBasesOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_LOADSYSTEMBASES_OPCODE" value="132"> </opcode>
                            <opcode name="LoadSystemBasesEnd" message="$(string.PrivatePublisher.LoadSystemBasesEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_LOADSYSTEMBASESEND_OPCODE" value="133"> </opcode>
                            <opcode name="ExecExe" message="$(string.PrivatePublisher.ExecExeOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EXEEXE_OPCODE" value="134"> </opcode>
                            <opcode name="ExecExeEnd" message="$(string.PrivatePublisher.ExecExeEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EXEEXEEND_OPCODE" value="135"> </opcode>
                            <opcode name="Main" message="$(string.PrivatePublisher.MainOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_MAIN_OPCODE" value="136"> </opcode>
                            <opcode name="MainEnd" message="$(string.PrivatePublisher.MainEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_MAINEND_OPCODE" value="137"> </opcode>

                            <opcode name="ApplyPolicyStart" message="$(string.PrivatePublisher.ApplyPolicyStartOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_APPLYPOLICYSTART_OPCODE" value="10"> </opcode>
                            <opcode name="ApplyPolicyEnd" message="$(string.PrivatePublisher.ApplyPolicyEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_APPLYPOLICYEND_OPCODE" value="11"> </opcode>
                            <opcode name="LdLibShFolder" message="$(string.PrivatePublisher.LdLibShFolderOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_LDLIBSHFOLDER_OPCODE" value="12"> </opcode>
                            <opcode name="LdLibShFolderEnd" message="$(string.PrivatePublisher.LdLibShFolderEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_LDLIBSHFOLDEREND_OPCODE" value="13"> </opcode>
                            <opcode name="PrestubWorker" message="$(string.PrivatePublisher.PrestubWorkerOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_PRESTUBWORKER_OPCODE" value="14"> </opcode>
                            <opcode name="PrestubWorkerEnd" message="$(string.PrivatePublisher.PrestubWorkerEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_PRESTUBWORKEREND_OPCODE" value="15"> </opcode>
                            <opcode name="GetInstallationStart" message="$(string.PrivatePublisher.GetInstallationStartOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_GETINSTALLATIONSTART_OPCODE" value="16"> </opcode>
                            <opcode name="GetInstallationEnd" message="$(string.PrivatePublisher.GetInstallationEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_GETINSTALLATIONEND_OPCODE" value="17"> </opcode>
                            <opcode name="OpenHModule" message="$(string.PrivatePublisher.OpenHModuleOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_OPENHMODULE_OPCODE" value="18"> </opcode>
                            <opcode name="OpenHModuleEnd" message="$(string.PrivatePublisher.OpenHModuleEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_OPENHMODULEEND_OPCODE" value="19"> </opcode>
                            <opcode name="ExplicitBindStart" message="$(string.PrivatePublisher.ExplicitBindStartOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EXPLICITBINDSTART_OPCODE" value="20"> </opcode>
                            <opcode name="ExplicitBindEnd" message="$(string.PrivatePublisher.ExplicitBindEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EXPLICITBINDEND_OPCODE" value="21"> </opcode>
                            <opcode name="ParseXml" message="$(string.PrivatePublisher.ParseXmlOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_PARSEXML_OPCODE" value="22"> </opcode>
                            <opcode name="ParseXmlEnd" message="$(string.PrivatePublisher.ParseXmlEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_PARSEXMLEND_OPCODE" value="23"> </opcode>
                            <opcode name="InitDefaultDomain" message="$(string.PrivatePublisher.InitDefaultDomainOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_INITDEFAULTDOMAIN_OPCODE" value="24"> </opcode>
                            <opcode name="InitDefaultDomainEnd" message="$(string.PrivatePublisher.InitDefaultDomainEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_INITDEFAULTDOMAINEND_OPCODE" value="25"> </opcode>
                            <opcode name="InitSecurity" message="$(string.PrivatePublisher.InitSecurityOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_INITSECURITY_OPCODE" value="26"> </opcode>
                            <opcode name="InitSecurityEnd" message="$(string.PrivatePublisher.InitSecurityEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_INITSECURITYEND_OPCODE" value="27"> </opcode>
                            <opcode name="AllowBindingRedirs" message="$(string.PrivatePublisher.AllowBindingRedirsOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_ALLOWBINDINGREDIRS_OPCODE" value="28"> </opcode>
                            <opcode name="AllowBindingRedirsEnd" message="$(string.PrivatePublisher.AllowBindingRedirsEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_ALLOWBINDINGREDIRSEND_OPCODE" value="29"> </opcode>
                            <opcode name="EEConfigSync" message="$(string.PrivatePublisher.EEConfigSyncOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EECONFIGSYNC_OPCODE" value="30"> </opcode>
                            <opcode name="EEConfigSyncEnd" message="$(string.PrivatePublisher.EEConfigSyncEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_EECONFIGSYNCEND_OPCODE" value="31"> </opcode>
                            <opcode name="FusionBinding" message="$(string.PrivatePublisher.FusionBindingOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSIONBINDING_OPCODE" value="32"> </opcode>
                            <opcode name="FusionBindingEnd" message="$(string.PrivatePublisher.FusionBindingEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSIONBINDINGEND_OPCODE" value="33"> </opcode>
                            <opcode name="LoaderCatchCall" message="$(string.PrivatePublisher.LoaderCatchCallOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_LOADERCATCHCALL_OPCODE" value="34"> </opcode>
                            <opcode name="LoaderCatchCallEnd" message="$(string.PrivatePublisher.LoaderCatchCallEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_LOADERCATCHCALLEND_OPCODE" value="35"> </opcode>
                            <opcode name="FusionInit" message="$(string.PrivatePublisher.FusionInitOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSIONINIT_OPCODE" value="36"> </opcode>
                            <opcode name="FusionInitEnd" message="$(string.PrivatePublisher.FusionInitEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSIONINITEND_OPCODE" value="37"> </opcode>
                            <opcode name="FusionAppCtx" message="$(string.PrivatePublisher.FusionAppCtxOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSIONAPPCTX_OPCODE" value="38"> </opcode>
                            <opcode name="FusionAppCtxEnd" message="$(string.PrivatePublisher.FusionAppCtxEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSIONAPPCTXEND_OPCODE" value="39"> </opcode>
                            <opcode name="Fusion2EE" message="$(string.PrivatePublisher.Fusion2EEOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSION2EE_OPCODE" value="40"> </opcode>
                            <opcode name="Fusion2EEEnd" message="$(string.PrivatePublisher.Fusion2EEEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_FUSION2EEEND_OPCODE" value="41"> </opcode>
                            <opcode name="SecurityCatchCall" message="$(string.PrivatePublisher.SecurityCatchCallOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_SECURITYCATCHCALL_OPCODE" value="42"> </opcode>
                            <opcode name="SecurityCatchCallEnd" message="$(string.PrivatePublisher.SecurityCatchCallEndOpcodeMessage)" symbol="CLR_PRIVATESTARTUP_SECURITYCATCHCALLEND_OPCODE" value="43"> </opcode>
                        </opcodes>
                    </task>

                    <task name="Binding" symbol="CLR_BINDING_TASK"
                          value="10" eventGUID="{E90E32BA-E396-4e6a-A790-0A08C6C925DC}"
                          message="$(string.PrivatePublisher.BindingTaskMessage)">
                        <opcodes>
                            <opcode name="BindingPolicyPhaseStart" message="$(string.PrivatePublisher.BindingPolicyPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGPOLICYPHASESTART_OPCODE" value="51"> </opcode>
                            <opcode name="BindingPolicyPhaseEnd" message="$(string.PrivatePublisher.BindingPolicyPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGPOLICYPHASEEND_OPCODE" value="52"> </opcode>
                            <opcode name="BindingNgenPhaseStart" message="$(string.PrivatePublisher.BindingNgenPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGNGENPHASESTART_OPCODE" value="53"> </opcode>
                            <opcode name="BindingNgenPhaseEnd" message="$(string.PrivatePublisher.BindingNgenPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGNGENPHASEEND_OPCODE" value="54"> </opcode>
                            <opcode name="BindingLookupAndProbingPhaseStart" message="$(string.PrivatePublisher.BindingLoopupAndProbingPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGLOOKUPANDPROBINGPHASESTART_OPCODE" value="55"> </opcode>
                            <opcode name="BindingLookupAndProbingPhaseEnd" message="$(string.PrivatePublisher.BindingLookupAndProbingPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGLOOKUPANDPROBINGPHASEEND_OPCODE" value="56"> </opcode>
                            <opcode name="LoaderPhaseStart" message="$(string.PrivatePublisher.LoaderPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERPHASESTART_OPCODE" value="57"> </opcode>
                            <opcode name="LoaderPhaseEnd" message="$(string.PrivatePublisher.LoaderPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERPHASEEND_OPCODE" value="58"> </opcode>
                            <opcode name="BindingPhaseStart" message="$(string.PrivatePublisher.BindingPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGPHASESTART_OPCODE" value="59"> </opcode>
                            <opcode name="BindingPhaseEnd" message="$(string.PrivatePublisher.BindingPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGPHASEEND_OPCODE" value="60"> </opcode>
                            <opcode name="BindingDownloadPhaseStart" message="$(string.PrivatePublisher.BindingDownloadPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGDOWNLOADPHASESTART_OPCODE" value="61"> </opcode>
                            <opcode name="BindingDownloadPhaseEnd" message="$(string.PrivatePublisher.BindingDownloadPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_BINDINGDOWNLOADPHASEEND_OPCODE" value="62"> </opcode>
                            <opcode name="LoaderAssemblyInitPhaseStart" message="$(string.PrivatePublisher.LoaderAssemblyInitPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERASSEMBLYINITPHASESTART_OPCODE" value="63"> </opcode>
                            <opcode name="LoaderAssemblyInitPhaseEnd" message="$(string.PrivatePublisher.LoaderAssemblyInitPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERASSEMBLYINITPHASEEND_OPCODE" value="64"> </opcode>
                            <opcode name="LoaderMappingPhaseStart" message="$(string.PrivatePublisher.LoaderMappingPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERMAPPINGPHASESTART_OPCODE" value="65"> </opcode>
                            <opcode name="LoaderMappingPhaseEnd" message="$(string.PrivatePublisher.LoaderMappingPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERMAPPINGPHASEEND_OPCODE" value="66"> </opcode>
                            <opcode name="LoaderDeliverEventsPhaseStart" message="$(string.PrivatePublisher.LoaderDeliverEventPhaseStartOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERDELIVERYEVENTSPHASESTART_OPCODE" value="67"> </opcode>
                            <opcode name="LoaderDeliverEventsPhaseEnd" message="$(string.PrivatePublisher.LoaderDeliverEventsPhaseEndOpcodeMessage)" symbol="CLR_PRIVATEBINDING_LOADERDELIVERYEVENTSPHASEEND_OPCODE" value="68"> </opcode>
                            <opcode name="FusionMessage" message="$(string.PrivatePublisher.FusionMessageOpcodeMessage)" symbol="CLR_PRIVATEBINDING_FUSIONMESSAGE_OPCODE" value="70"> </opcode>
                            <opcode name="FusionErrorCode" message="$(string.PrivatePublisher.FusionErrorCodeOpcodeMessage)" symbol="CLR_PRIVATEBINDING_FUSIONERRORCODE_OPCODE" value="71"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRStackPrivate" symbol="CLR_STACKPRIVATE_TASK"
                          value="11" eventGUID="{d3363dc0-243a-4620-a4d0-8a07d772f533}"
                          message="$(string.PrivatePublisher.StackTaskMessage)">
                        <opcodes>
                            <opcode name="CLRStackWalk" message="$(string.PrivatePublisher.CLRStackWalkOpcodeMessage)" symbol="CLR_PRIVATESTACK_STACKWALK_OPCODE" value="82"> </opcode>
                        </opcodes>
                    </task>

                    <task name="EvidenceGeneratedTask" symbol="CLR_EVIDENCE_GENERATED_TASK"
                          value="12" eventGUID="{24333617-5ae4-4f9e-a5c5-5ede1bc59207}"
                          message="$(string.PrivatePublisher.EvidenceGeneratedTaskMessage)">
                        <opcodes>
                            <opcode name="EvidenceGenerated" message="$(string.PrivatePublisher.EvidenceGeneratedMessage)" symbol="CLR_EVIDENCEGENERATED_OPCODE" value="10"/>
                        </opcodes>
                    </task>

                    <task name="CLRNgenBinder" symbol="CLR_NGEN_BINDER_TASK"
                         value="13" eventGUID="{861f5339-19d6-4873-b350-7b03228bda7c}"
                         message="$(string.PrivatePublisher.NgenBinderTaskMessage)">
                        <opcodes>
                            <opcode name="NgenBind" message="$(string.PrivatePublisher.NgenBindOpcodeMessage)" symbol="CLR_NGEN_BINDER_OPCODE" value="69"></opcode>
                        </opcodes>
                    </task>

                    <task name="TransparencyComputation" symbol="CLR_TRANSPARENCY_COMPUTATION_TASK"
                          value="14" eventGUID="{e2444377-ddf9-4589-a885-08d6092521df}"
                          message="$(string.PrivatePublisher.TransparencyComputationMessage)">
                        <opcodes>
                            <opcode name="ModuleTransparencyComputationStart" message="$(string.PrivatePublisher.ModuleTransparencyComputationStartMessage)" symbol="CLR_MODULE_TRANSPARENCY_COMPUTATION_START_OPCODE" value="83"/>
                            <opcode name="ModuleTransparencyComputationEnd" message="$(string.PrivatePublisher.ModuleTransparencyComputationEndMessage)" symbol="CLR_MODULE_TRANSPARENCY_COMPUTATION_END_OPCODE" value="84"/>
                            <opcode name="TypeTransparencyComputationStart" message="$(string.PrivatePublisher.TypeTransparencyComputationStartMessage)" symbol="CLR_TYPE_TRANSPARENCY_COMPUTATION_START_OPCODE" value="85"/>
                            <opcode name="TypeTransparencyComputationEnd" message="$(string.PrivatePublisher.TypeTransparencyComputationEndMessage)" symbol="CLR_TYPE_TRANSPARENCY_COMPUTATION_END_OPCODE" value="86"/>
                            <opcode name="MethodTransparencyComputationStart" message="$(string.PrivatePublisher.MethodTransparencyComputationStartMessage)" symbol="CLR_METHOD_TRANSPARENCY_COMPUTATION_START_OPCODE" value="87"/>
                            <opcode name="MethodTransparencyComputationEnd" message="$(string.PrivatePublisher.MethodTransparencyComputationEndMessage)" symbol="CLR_METHOD_TRANSPARENCY_COMPUTATION_END_OPCODE" value="88"/>
                            <opcode name="FieldTransparencyComputationStart" message="$(string.PrivatePublisher.FieldTransparencyComputationStartMessage)" symbol="CLR_FIELD_TRANSPARENCY_COMPUTATION_START_OPCODE" value="89"/>
                            <opcode name="FieldTransparencyComputationEnd" message="$(string.PrivatePublisher.FieldTransparencyComputationEndMessage)" symbol="CLR_FIELD_TRANSPARENCY_COMPUTATION_END_OPCODE" value="90"/>
                            <opcode name="TokenTransparencyComputationStart" message="$(string.PrivatePublisher.TokenTransparencyComputationStartMessage)" symbol="CLR_TOKEN_TRANSPARENCY_COMPUTATION_START_OPCODE" value="91"/>
                            <opcode name="TokenTransparencyComputationEnd" message="$(string.PrivatePublisher.TokenTransparencyComputationEndMessage)" symbol="CLR_TOKEN_TRANSPARENCY_COMPUTATION_END_OPCODE" value="92"/>
                        </opcodes>
                    </task>

                    <task name="LoaderHeapAllocation" symbol="CLR_LOADERHEAPALLOCATIONPRIVATE_TASK"
                          value="16" eventGUID="{87f1e966-d604-41ba-b1ab-183849dff29d}"
                          message="$(string.PrivatePublisher.LoaderHeapAllocationPrivateTaskMessage)">
                        <opcodes>
                            <opcode name="AllocRequest" message="$(string.PrivatePublisher.LoaderHeapPrivateAllocRequestMessage)" symbol="CLR_LOADERHEAP_ALLOCREQUEST_OPCODE" value="97"/>
                        </opcodes>
                    </task>

                    <task name="CLRMulticoreJit" symbol="CLR_MULTICOREJIT_TASK"
                          value="17" eventGUID="{B85AD9E5-658B-4215-8DDB-834040F4BC10}"
                          message="$(string.PrivatePublisher.MulticoreJitTaskMessage)">
                        <opcodes>
                            <opcode name="Common" message="$(string.PrivatePublisher.MulticoreJitOpcodeMessage)" symbol="CLR_MULTICOREJIT_COMMON_OPCODE" value="10"> </opcode>
                            <opcode name="MethodCodeReturned" message="$(string.PrivatePublisher.MulticoreJitOpcodeMethodCodeReturnedMessage)" symbol="CLR_MULTICOREJIT_METHODCODERETURNED_OPCODE" value="11"> </opcode>
                        </opcodes>
                    </task>

                    <task name="CLRPerfTrackPrivate" symbol="CLR_PERFTRACK_PRIVATE_TASK"
                        value="20" eventGUID="{EAC685F6-2104-4dec-88FD-91E4254221EC}"
                        message="$(string.PrivatePublisher.PerfTrackTaskMessage)">
                        <opcodes>
                            <opcode name="ModuleRangeLoadPrivate" message="$(string.PrivatePublisher.ModuleRangeLoadOpcodeMessage)" symbol="CLR_PERFTRACK_PRIVATE_MODULE_RANGE_LOAD_OPCODE" value="10"> </opcode>
                        </opcodes>
                    </task>

                    <!-- NOTE: These are not used anymore. They are kept around for backcompat with traces that might have already contained these -->
                    <task name="DynamicTypeUsage" symbol="CLR_DYNAMICTYPEUSAGE_TASK"
                          value="22" eventGUID="{4F67E18D-EEDD-4056-B8CE-DD822FE54553}"
                          message="$(string.PrivatePublisher.DynamicTypeUsageTaskMessage)">
                        <opcodes>
                            <opcode name="IInspectableRuntimeClassName" message="$(string.PrivatePublisher.IInspectableRuntimeClassNameOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_IINSPECTABLERUNTIMECLASSNAME_OPCODE" value="11"> </opcode>
                            <opcode name="WinRTUnbox" message="$(string.PrivatePublisher.WinRTUnboxOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_WINRTUNBOX_OPCODE" value="12"> </opcode>
                            <opcode name="CreateRCW" message="$(string.PrivatePublisher.CreateRCWOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_CREATERCW_OPCODE" value="13"> </opcode>
                            <opcode name="RCWVariance" message="$(string.PrivatePublisher.RCWVarianceOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_RCWVARIANCE_OPCODE" value="14"> </opcode>
                            <opcode name="RCWIEnumerableCasting" message="$(string.PrivatePublisher.RCWIEnumerableCastingOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_RCWIENUMERABLECASTING_OPCODE" value="15"> </opcode>
                            <opcode name="CreateCCW" message="$(string.PrivatePublisher.CreateCCWOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_CREATECCW_OPCODE" value="16"> </opcode>
                            <opcode name="CCWVariance" message="$(string.PrivatePublisher.CCWVarianceOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_CCWVARIANCE_OPCODE" value="17"> </opcode>
                            <opcode name="ObjectVariantMarshallingToNative" message="$(string.PrivatePublisher.ObjectVariantMarshallingToNativeOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_OBJECTVARIANTMARSHALLINGTONATIVE_OPCODE" value="18"> </opcode>
                            <opcode name="GetTypeFromGUID" message="$(string.PrivatePublisher.GetTypeFromGUIDOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_GETTYPEFROMGUID_OPCODE" value="19"> </opcode>
                            <opcode name="GetTypeFromProgID" message="$(string.PrivatePublisher.GetTypeFromProgIDOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_GETTYPEFROMPROGID_OPCODE" value="20"> </opcode>
                            <opcode name="ConvertToCallbackEtw" message="$(string.PrivatePublisher.ConvertToCallbackEtwOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_CONVERTTOCALLBACKETW_OPCODE" value="21"> </opcode>
                            <opcode name="BeginCreateManagedReference" message="$(string.PrivatePublisher.BeginCreateManagedReferenceOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_BEGINCREATEMANAGEDREFERENCE_OPCODE" value="22"> </opcode>
                            <opcode name="EndCreateManagedReference" message="$(string.PrivatePublisher.EndCreateManagedReferenceOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_ENDCREATEMANAGEDREFERENCE_OPCODE" value="23"> </opcode>
                            <opcode name="ObjectVariantMarshallingToManaged" message="$(string.PrivatePublisher.ObjectVariantMarshallingToManagedOpcodeMessage)" symbol="CLR_DYNAMICTYPEUSAGE_OBJECTVARIANTMARSHALLINGTOMANAGED_OPCODE" value="24"> </opcode>
                        </opcodes>
                    </task>
                </tasks>

                <maps>
                    <valueMap name="ModuleRangeSectionTypeMap">
                        <map value="0x1" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ModuleSection)"/>
                        <map value="0x2" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.EETableSection)"/>
                        <map value="0x3" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.WriteDataSection)"/>
                        <map value="0x4" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.WriteableDataSection)"/>
                        <map value="0x5" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.DataSection)"/>
                        <map value="0x6" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.RVAStaticsSection)"/>
                        <map value="0x7" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.EEDataSection)"/>
                        <map value="0x8" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoTableEagerSection)"/>
                        <map value="0x9" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoTableSection)"/>
                        <map value="0xA" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.EEReadonlyData)"/>
                        <map value="0xB" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ReadonlyData)"/>
                        <map value="0xC" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ClassSection)"/>
                        <map value="0xD" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.CrossDomainInfoSection)"/>
                        <map value="0xE" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.MethodDescSection)"/>
                        <map value="0xF" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.MethodDescWriteableSection)"/>
                        <map value="0x10" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ExceptionSection)"/>
                        <map value="0x11" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.InstrumentSection)"/>
                        <map value="0x12" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.VirtualImportThunkSection)"/>
                        <map value="0x13" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ExternalMethodThunkSection)"/>
                        <map value="0x14" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.HelperTableSection)"/>
                        <map value="0x15" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.MethodPrecodeWriteableSection)"/>
                        <map value="0x16" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.MethodPrecodeWriteSection)"/>
                        <map value="0x17" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.MethodPrecodeSection)"/>
                        <map value="0x18" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.Win32ResourcesSection)"/>
                        <map value="0x19" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.HeaderSection)"/>
                        <map value="0x1A" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.MetadataSection)"/>
                        <map value="0x1B" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoSection)"/>
                        <map value="0x1C" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ImportTableSection)"/>
                        <map value="0x1D" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.CodeSection)"/>
                        <map value="0x1E" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.CodeHeaderSection)"/>
                        <map value="0x1F" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.CodeManagerSection)"/>
                        <map value="0x20" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.UnwindDataSection)"/>
                        <map value="0x21" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.RuntimeFunctionSection)"/>
                        <map value="0x22" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.StubsSection)"/>
                        <map value="0x23" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.StubDispatchDataSection)"/>
                        <map value="0x24" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ExternalMethodDataSection)"/>
                        <map value="0x25" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoDelayListSection)"/>
                        <map value="0x26" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ReadonlySharedSection)"/>
                        <map value="0x27" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ReadonlySection)"/>
                        <map value="0x28" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ILSection)"/>
                        <map value="0x29" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.GCInfoSection)"/>
                        <map value="0x2A" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ILMetadataSection)"/>
                        <map value="0x2B" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.ResourcesSection)"/>
                        <map value="0x2C" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.CompressedMapsSection)"/>
                        <map value="0x2D" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.DebugSection)"/>
                        <map value="0x2E" message="$(string.PrivatePublisher.ModuleRangeSectionTypeMap.BaseRelocsSection)"/>
                    </valueMap>

                    <valueMap name="GCHandleKindMap">
                        <map value="0x0" message="$(string.PrivatePublisher.GCHandleKind.WeakShortMessage)"/>
                        <map value="0x1" message="$(string.PrivatePublisher.GCHandleKind.WeakLongMessage)"/>
                        <map value="0x2" message="$(string.PrivatePublisher.GCHandleKind.StrongMessage)"/>
                        <map value="0x3" message="$(string.PrivatePublisher.GCHandleKind.PinnedMessage)"/>
                        <map value="0x4" message="$(string.PrivatePublisher.GCHandleKind.VariableMessage)"/>
                        <map value="0x5" message="$(string.PrivatePublisher.GCHandleKind.RefCountedMessage)"/>
                        <map value="0x6" message="$(string.PrivatePublisher.GCHandleKind.DependentMessage)"/>
                        <map value="0x7" message="$(string.PrivatePublisher.GCHandleKind.AsyncPinnedMessage)"/>
                        <map value="0x8" message="$(string.PrivatePublisher.GCHandleKind.SizedRefMessage)"/>
                    </valueMap>

                    <bitMap name="ModuleRangeIBCTypeMap">
                        <map value="0x1" message="$(string.PrivatePublisher.ModuleRangeIBCTypeMap.IBCUnprofiledSectionMessage)"/>
                        <map value="0x2" message="$(string.PrivatePublisher.ModuleRangeIBCTypeMap.IBCProfiledSectionMessage)"/>
                    </bitMap>
                    <bitMap name="ModuleRangeTypeMap">
                        <map value="0x1" message="$(string.PrivatePublisher.ModuleRangeTypeMap.HotRangeMessage)"/>
                        <map value="0x2" message="$(string.PrivatePublisher.ModuleRangeTypeMap.WarmRangeMessage)"/>
                        <map value="0x4" message="$(string.PrivatePublisher.ModuleRangeTypeMap.ColdRangeMessage)"/>
                        <map value="0x8" message="$(string.PrivatePublisher.ModuleRangeTypeMap.HotColdRangeMessage)"/>
                    </bitMap>
                </maps>

                <!--Templates-->
                <templates>
                    <!--Private Templates-->
                    <template tid="ClrStackWalk">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Reserved1" inType="win:UInt8" />
                        <data name="Reserved2" inType="win:UInt8" />
                        <data name="FrameCount" inType="win:UInt32" />
                        <data name="Stack" count="2" inType="win:Pointer" />
                    </template>

                    <template tid="EvidenceGenerated">
                        <data name="Type" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="AppDomain" inType="win:UInt32" outType="xs:unsignedInt"/>
                        <data name="ILImage" inType="win:UnicodeString"/>
                        <data name="ClrInstanceID" inType="win:UInt16"/>

                        <UserData>
                            <EvidenceGenerated xmlns="myNs">
                                <Type> %1 </Type>
                                <AppDomain> %2 </AppDomain>
                                <ILImage> %3 </ILImage>
                            </EvidenceGenerated>
                        </UserData>
                    </template>

                    <template tid="GCDecision">
                        <data name="DoCompact" inType="win:Boolean" />

                        <UserData>
                            <GCDecision xmlns="myNs">
                                <DoCompact> %1 </DoCompact>
                            </GCDecision>
                        </UserData>
                    </template>

                    <template tid="GCDecision_V1">
                        <data name="DoCompact" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCDecision_V1 xmlns="myNs">
                                <DoCompact> %1 </DoCompact>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </GCDecision_V1>
                        </UserData>
                    </template>

                    <template tid="PrvGCMark">
                        <data name="HeapNum" inType="win:UInt32" />

                        <UserData>
                            <PrvGCMark xmlns="myNs">
                                <HeapNum> %1 </HeapNum>
                            </PrvGCMark>
                        </UserData>
                    </template>

                    <template tid="PrvGCMark_V1">
                        <data name="HeapNum" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                          <PrvGCMark_V1 xmlns="myNs">
                            <HeapNum> %1 </HeapNum>
                            <ClrInstanceID> %2 </ClrInstanceID>
                          </PrvGCMark_V1>
                        </UserData>
                    </template>

                    <template tid="GCPerHeapHistory">
                    </template>

                    <template tid="GCPerHeapHistory_V1">
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCPerHeapHistory_V1 xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCPerHeapHistory_V1>
                        </UserData>
                    </template>

                    <template tid="GCGlobalHeap">
                        <data name="FinalYoungestDesired" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="NumHeaps" inType="win:Int32" />
                        <data name="CondemnedGeneration" inType="win:UInt32" />
                        <data name="Gen0ReductionCount" inType="win:UInt32" />
                        <data name="Reason" inType="win:UInt32" />
                        <data name="GlobalMechanisms" inType="win:UInt32" />

                        <UserData>
                            <GCGlobalHeap xmlns="myNs">
                                <FinalYoungestDesired> %1 </FinalYoungestDesired>
                                <NumHeaps> %2 </NumHeaps>
                                <CondemnedGeneration> %3 </CondemnedGeneration>
                                <Gen0ReductionCount> %4 </Gen0ReductionCount>
                                <Reason> %5 </Reason>
                                <GlobalMechanisms> %6 </GlobalMechanisms>
                            </GCGlobalHeap>
                        </UserData>
                    </template>

                    <template tid="GCGlobalHeap_V1">
                        <data name="FinalYoungestDesired" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="NumHeaps" inType="win:Int32" />
                        <data name="CondemnedGeneration" inType="win:UInt32" />
                        <data name="Gen0ReductionCount" inType="win:UInt32" />
                        <data name="Reason" inType="win:UInt32" />
                        <data name="GlobalMechanisms" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCGlobalHeap_V1 xmlns="myNs">
                                <FinalYoungestDesired> %1 </FinalYoungestDesired>
                                <NumHeaps> %2 </NumHeaps>
                                <CondemnedGeneration> %3 </CondemnedGeneration>
                                <Gen0ReductionCount> %4 </Gen0ReductionCount>
                                <Reason> %5 </Reason>
                                <GlobalMechanisms> %6 </GlobalMechanisms>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </GCGlobalHeap_V1>
                        </UserData>
                    </template>

                    <template tid="GCJoin">
                        <data name="Heap" inType="win:UInt32" />
                        <data name="JoinTime" inType="win:UInt32" />
                        <data name="JoinType" inType="win:UInt32" />

                        <UserData>
                            <GCJoin xmlns="myNs">
                                <Heap> %1 </Heap>
                                <JoinTime> %2 </JoinTime>
                                <JoinType> %3 </JoinType>
                            </GCJoin>
                        </UserData>
                    </template>

                    <template tid="GCJoin_V1">
                        <data name="Heap" inType="win:UInt32" />
                        <data name="JoinTime" inType="win:UInt32" />
                        <data name="JoinType" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCJoin_V1 xmlns="myNs">
                                <Heap> %1 </Heap>
                                <JoinTime> %2 </JoinTime>
                                <JoinType> %3 </JoinType>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </GCJoin_V1>
                        </UserData>
                    </template>

                    <template tid="GCOptimized">
                        <data name="DesiredAllocation" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="NewAllocation" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationNumber" inType="win:UInt32" />

                        <UserData>
                            <GCOptimized xmlns="myNs">
                                <DesiredAllocation> %1 </DesiredAllocation>
                                <NewAllocation> %2 </NewAllocation>
                                <GenerationNumber> %3 </GenerationNumber>
                            </GCOptimized>
                        </UserData>
                    </template>

                    <template tid="GCOptimized_V1">
                        <data name="DesiredAllocation" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="NewAllocation" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="GenerationNumber" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCOptimized_V1 xmlns="myNs">
                                <DesiredAllocation> %1 </DesiredAllocation>
                                <NewAllocation> %2 </NewAllocation>
                                <GenerationNumber> %3 </GenerationNumber>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </GCOptimized_V1>
                        </UserData>
                    </template>

                    <template tid="GCSettings">
                        <data name="SegmentSize" inType="win:UInt64" />
                        <data name="LargeObjectSegmentSize" inType="win:UInt64" />
                        <data name="ServerGC" inType="win:Boolean" />

                        <UserData>
                            <GCSettings xmlns="myNs">
                                <SegmentSize> %1 </SegmentSize>
                                <LargeObjectSegmentSize> %2 </LargeObjectSegmentSize>
                                <ServerGC> %3 </ServerGC>
                            </GCSettings>
                        </UserData>
                    </template>

                    <template tid="GCSettings_V1">
                        <data name="SegmentSize" inType="win:UInt64" />
                        <data name="LargeObjectSegmentSize" inType="win:UInt64" />
                        <data name="ServerGC" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCSettings_V1 xmlns="myNs">
                                <SegmentSize> %1 </SegmentSize>
                                <LargeObjectSegmentSize> %2 </LargeObjectSegmentSize>
                                <ServerGC> %3 </ServerGC>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </GCSettings_V1>
                        </UserData>
                    </template>

                    <template tid="BGCDrainMark">
                        <data name="Objects" inType="win:UInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <BGCDrainMark xmlns="myNs">
                                <Objects> %1 </Objects>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </BGCDrainMark>
                        </UserData>
                    </template>

                    <template tid="BGCRevisit">
                        <data name="Pages" inType="win:UInt64" />
                        <data name="Objects" inType="win:UInt64" />
                        <data name="IsLarge" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <BGCRevisit xmlns="myNs">
                                <Pages> %1 </Pages>
                                <Objects> %2 </Objects>
                                <IsLarge> %3 </IsLarge>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </BGCRevisit>
                        </UserData>
                    </template>

                    <template tid="BGCOverflow">
                        <data name="Min" inType="win:UInt64" />
                        <data name="Max" inType="win:UInt64" />
                        <data name="Objects" inType="win:UInt64" />
                        <data name="IsLarge" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <BGCOverflow xmlns="myNs">
                                <Min> %1 </Min>
                                <Max> %2 </Max>
                                <Objects> %3 </Objects>
                                <IsLarge> %4 </IsLarge>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </BGCOverflow>
                        </UserData>
                    </template>

                    <template tid="BGCAllocWait">
                        <data name="Reason" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <BGCAllocWait xmlns="myNs">
                                <Reason> %1 </Reason>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </BGCAllocWait>
                        </UserData>
                    </template>

                    <template tid="GCFullNotify">
                        <data name="GenNumber" inType="win:UInt32" />
                        <data name="IsAlloc" inType="win:UInt32" />

                        <UserData>
                            <GCFullNotify xmlns="myNs">
                                <GenNumber> %1 </GenNumber>
                                <IsAlloc> %2 </IsAlloc>
                            </GCFullNotify>
                        </UserData>
                    </template>


                    <template tid="GCFullNotify_V1">
                        <data name="GenNumber" inType="win:UInt32" />
                        <data name="IsAlloc" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <GCFullNotify_V1 xmlns="myNs">
                                <GenNumber> %1 </GenNumber>
                                <IsAlloc> %2 </IsAlloc>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </GCFullNotify_V1>
                        </UserData>
                    </template>

                    <template tid="BGC1stSweepEnd">
                        <data name="GenNumber" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <BGC1stSweepEnd xmlns="myNs">
                                <GenNumber> %1 </GenNumber>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </BGC1stSweepEnd>
                        </UserData>
                    </template>

                    <template tid="GCNoUserData">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <GCNoUserData xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </GCNoUserData>
                        </UserData>
                    </template>

                    <template tid="Startup">
                        <UserData>
                            <Startup xmlns="myNs">
                            </Startup>
                        </UserData>
                    </template>

                    <template tid="Startup_V1">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <Startup_V1 xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </Startup_V1>
                        </UserData>
                    </template>

                    <template tid="FusionMessage">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Prepend" inType="win:Boolean" />
                        <data name="Message" inType="win:UnicodeString"/>
                        <UserData>
                            <FusionMessage xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <Prepend> %2 </Prepend>
                                <Message> %3 </Message>
                            </FusionMessage>
                        </UserData>
                    </template>

                    <template tid="FusionErrorCode">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="Category" inType="win:UInt32" />
                        <data name="ErrorCode" inType="win:UInt32" />
                        <UserData>
                            <FusionErrorCode xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <Category> %2 </Category>
                                <ErrorCode> %3 </ErrorCode>
                            </FusionErrorCode>
                        </UserData>
                    </template>

                    <template tid="Binding">
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="LoadContextID" inType="win:UInt32" />
                        <data name="FromLoaderCache" inType="win:UInt32" />
                        <data name="DynamicLoad" inType="win:UInt32" />
                        <data name="AssemblyCodebase" inType="win:UnicodeString" />
                        <data name="AssemblyName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <Binding xmlns="myNs">
                                <AppDomainID> %1 </AppDomainID>
                                <LoadContextID> %2 </LoadContextID>
                                <FromLoaderCache> %3 </FromLoaderCache>
                                <DynamicLoad> %4 </DynamicLoad>
                                <AssemblyCodebase> %5 </AssemblyCodebase>
                                <AssemblyName> %6 </AssemblyName>
                                <ClrInstanceID> %7 </ClrInstanceID>
                            </Binding>
                        </UserData>
                    </template>

                    <template tid="NgenBindEvent">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="BindingID" inType="win:UInt64" />
                        <data name="ReasonCode" inType="win:UInt32" />
                        <data name="AssemblyName" inType="win:UnicodeString" />

                        <UserData>
                            <NgenBindEvent xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <BindingID> %2 </BindingID>
                                <ReasonCode> %3 </ReasonCode>
                                <AssemblyName> %4 </AssemblyName>
                            </NgenBindEvent>
                        </UserData>
                    </template>

                    <template tid="ModuleTransparencyCalculation">
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ModuleTransparencyCalculation xmlns="myNs">
                                <Module> %1 </Module>
                                <AppDomainID> %2 </AppDomainID>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </ModuleTransparencyCalculation>
                        </UserData>
                    </template>

                    <template tid="TypeTransparencyCalculation">
                        <data name="Type" inType="win:UnicodeString" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <TypeTransparencyCalculation xmlns="myNs">
                                <Type> %1 </Type>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </TypeTransparencyCalculation>
                        </UserData>
                    </template>

                    <template tid="MethodTransparencyCalculation">
                        <data name="Method" inType="win:UnicodeString" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodTransparencyCalculation xmlns="myNs">
                                <Method> %1 </Method>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </MethodTransparencyCalculation>
                        </UserData>
                    </template>

                    <template tid="FieldTransparencyCalculation">
                        <data name="Field" inType="win:UnicodeString" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <FieldTransparencyCalculation xmlns="myNs">
                                <Field> %1 </Field>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </FieldTransparencyCalculation>
                        </UserData>
                    </template>

                    <template tid="TokenTransparencyCalculation">
                        <data name="Token" inType="win:UInt32" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID"  inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <TokenTransparencyCalculation xmlns="myNs">
                                <Token> %1 </Token>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </TokenTransparencyCalculation>
                        </UserData>
                    </template>

                    <template tid="ModuleTransparencyCalculationResult">
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="IsAllCritical" inType="win:Boolean" />
                        <data name="IsAllTransparent" inType="win:Boolean" />
                        <data name="IsTreatAsSafe" inType="win:Boolean" />
                        <data name="IsOpportunisticallyCritical" inType="win:Boolean" />
                        <data name="SecurityRuleSet" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <ModuleTransparencyCalculationResult xmlns="myNs">
                                <Module> %1 </Module>
                                <AppDomainID> %2 </AppDomainID>
                                <IsAllCritical> %3 </IsAllCritical>
                                <IsAllTransparent> %4 </IsAllTransparent>
                                <IsTreatAsSafe> %5 </IsTreatAsSafe>
                                <IsOpportunisticallyCritical> %6 </IsOpportunisticallyCritical>
                                <SecurityRuleSet> %7 </SecurityRuleSet>
                                <ClrInstanceID> %8 </ClrInstanceID>
                            </ModuleTransparencyCalculationResult>
                        </UserData>
                    </template>

                    <template tid="TypeTransparencyCalculationResult">
                        <data name="Type" inType="win:UnicodeString" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="IsAllCritical" inType="win:Boolean" />
                        <data name="IsAllTransparent" inType="win:Boolean" />
                        <data name="IsCritical" inType="win:Boolean" />
                        <data name="IsTreatAsSafe" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <TypeTransparencyCalculationResult xmlns="myNs">
                                <Type> %1 </Type>
                                <Module> %2 </Module>
                                <AppDomainID> %3</AppDomainID>
                                <IsAllCritical> %4 </IsAllCritical>
                                <IsAllTransparent> %5 </IsAllTransparent>
                                <IsCritical> %6 </IsCritical>
                                <IsTreatAsSafe> %7 </IsTreatAsSafe>
                                <ClrInstanceID> %8 </ClrInstanceID>
                            </TypeTransparencyCalculationResult>
                        </UserData>
                    </template>

                    <template tid="MethodTransparencyCalculationResult">
                        <data name="Method" inType="win:UnicodeString" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="IsCritical" inType="win:Boolean" />
                        <data name="IsTreatAsSafe" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <MethodTransparencyCalculationResult xmlns="myNs">
                                <Method> %1 </Method>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <IsCritical> %4 </IsCritical>
                                <IsTreatAsSafe> %5 </IsTreatAsSafe>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </MethodTransparencyCalculationResult>
                        </UserData>
                    </template>

                    <template tid="FieldTransparencyCalculationResult">
                        <data name="Field" inType="win:UnicodeString" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="IsCritical" inType="win:Boolean" />
                        <data name="IsTreatAsSafe" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <FieldTransparencyCalculationResult xmlns="myNs">
                                <Field> %1 </Field>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <IsCritical> %4 </IsCritical>
                                <IsTreatAsSafe> %5 </IsTreatAsSafe>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </FieldTransparencyCalculationResult>
                        </UserData>
                    </template>


                    <template tid="TokenTransparencyCalculationResult">
                        <data name="Token" inType="win:UInt32" />
                        <data name="Module" inType="win:UnicodeString" />
                        <data name="AppDomainID" inType="win:UInt32" />
                        <data name="IsCritical" inType="win:Boolean" />
                        <data name="IsTreatAsSafe" inType="win:Boolean" />
                        <data name="ClrInstanceID" inType="win:UInt16" />

                        <UserData>
                            <TokenTransparencyCalculationResult xmlns="myNs">
                                <Token> %1 </Token>
                                <Module> %2 </Module>
                                <AppDomainID> %3 </AppDomainID>
                                <IsCritical> %4 </IsCritical>
                                <IsTreatAsSafe> %5 </IsTreatAsSafe>
                                <ClrInstanceID> %6 </ClrInstanceID>
                            </TokenTransparencyCalculationResult>
                        </UserData>
                    </template>

                    <template tid="FailFast">
                        <data name="FailFastUserMessage" inType="win:UnicodeString" />
                        <data name="FailedEIP" inType="win:Pointer" />
                        <data name="OSExitCode" inType="win:UInt32" />
                        <data name="ClrExitCode" inType="win:UInt32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <FailFast xmlns="myNs">
                                <FailFastUserMessage> %1 </FailFastUserMessage>
                                <FailedEIP> %2 </FailedEIP>
                                <OSExitCode> %3 </OSExitCode>
                                <ClrExitCode> %4 </ClrExitCode>
                                <ClrInstanceID> %5 </ClrInstanceID>
                            </FailFast>
                        </UserData>
                    </template>

                    <template tid="PrvFinalizeObject">
                        <data name="TypeID" inType="win:Pointer" />
                        <data name="ObjectID" inType="win:Pointer" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="TypeName" inType="win:UnicodeString" />
                    </template>

                    <template tid="CCWRefCountChange">
                        <data name="HandleID" inType="win:Pointer" />
                        <data name="ObjectID" inType="win:Pointer" />
                        <data name="COMInterfacePointer" inType="win:Pointer" />
                        <data name="NewRefCount" inType="win:UInt32" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClassName" inType="win:UnicodeString" />
                        <data name="NameSpace" inType="win:UnicodeString" />
                        <data name="Operation" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="CCWRefCountChangeAnsi">
                        <data name="HandleID" inType="win:Pointer" />
                        <data name="ObjectID" inType="win:Pointer" />
                        <data name="COMInterfacePointer" inType="win:Pointer" />
                        <data name="NewRefCount" inType="win:UInt32" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClassName" inType="win:AnsiString" />
                        <data name="NameSpace" inType="win:AnsiString" />
                        <data name="Operation" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="PinPlugAtGCTime">
                        <data name="PlugStart" inType="win:Pointer" />
                        <data name="PlugEnd" inType="win:Pointer" />
                        <data name="GapBeforeSize" inType="win:Pointer" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="PrvDestroyGCHandle">
                        <data name="HandleID" inType="win:Pointer" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="PrvSetGCHandle">
                        <data name="HandleID" inType="win:Pointer" />
                        <data name="ObjectID" inType="win:Pointer" />
                        <data name="Kind" map="GCHandleKindMap" inType="win:UInt32" />
                        <data name="Generation" inType="win:UInt32" />
                        <data name="AppDomainID" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                    </template>

                    <template tid="LoaderHeapPrivate">
                        <data name="LoaderHeapPtr" inType="win:Pointer" />
                        <data name="MemoryAddress" inType="win:Pointer" />
                        <data name="RequestSize" inType="win:UInt32" />
                        <!-- we had a weird problem where the EtwCallout callback (which does stack traces)
                             was not being called for only this event.  By adding this field which makes
                             the sigature of this event the same as SetGCHandle, we avoid the problem.
                             ideally this gets ripped out at some point -->
                        <data name="Unused1" inType="win:UInt32" />
                        <data name="Unused2" inType="win:UInt64" outType="win:HexInt64" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <LoaderHeapPrivate xmlns="myNs">
                                <LoaderHeapPtr> %1 </LoaderHeapPtr>
                                <MemoryAddress> %2 </MemoryAddress>
                                <RequestSize> %3 </RequestSize>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </LoaderHeapPrivate>
                        </UserData>
                    </template>

                    <template tid="ModuleRangePrivate">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ModuleID" inType="win:UInt64"  outType="win:HexInt64"/>
                        <data name="RangeBegin" count="1" inType="win:UInt32"  outType="win:HexInt32"/>
                        <data name="RangeSize" count="1" inType="win:UInt32"  outType="win:HexInt32"/>
                        <data name="RangeType" map="ModuleRangeTypeMap" inType="win:UInt8"/>
                        <data name="IBCType" map="ModuleRangeIBCTypeMap" inType="win:UInt8"/>
                        <data name="SectionType" map="ModuleRangeSectionTypeMap" inType="win:UInt16" />
                        <UserData>
                            <ModuleRange xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <RangeBegin> %3 </RangeBegin>
                                <RangeSize> %4 </RangeSize>
                                <RangeType> %5 </RangeType>
                                <IBCType> %6 </IBCType>
                                <SectionType> %7 </SectionType>
                            </ModuleRange>
                        </UserData>
                    </template>

                    <template tid="MulticoreJitPrivate">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="String1" inType="win:UnicodeString" />
                        <data name="String2" inType="win:UnicodeString" />
                        <data name="Int1" inType="win:Int32" />
                        <data name="Int2" inType="win:Int32" />
                        <data name="Int3" inType="win:Int32" />
                        <UserData>
                            <MulticoreJit xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <String1> %2 </String1>
                                <String2> %3 </String2>
                                <Int1> %4 </Int1>
                                <Int2> %5 </Int2>
                                <Int3> %6 </Int3>
                            </MulticoreJit>
                        </UserData>
                    </template>

                    <template tid="MulticoreJitMethodCodeReturnedPrivate">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <data name="ModuleID" inType="win:UInt64" />
                        <data name="MethodID" inType="win:UInt64" />
                        <UserData>
                            <MulticoreJitMethodCodeReturned xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                                <ModuleID> %2 </ModuleID>
                                <MethodID> %3 </MethodID>
                            </MulticoreJitMethodCodeReturned>
                        </UserData>
                    </template>

                    <template tid="DynamicTypeUsePrivate">
                        <data name="TypeName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <DynamicTypeUse xmlns="myNs">
                                <TypeName> %1 </TypeName>
                                <ClrInstanceID> %2 </ClrInstanceID>
                            </DynamicTypeUse>
                        </UserData>
                    </template>

                    <template tid="DynamicTypeUseTwoParametersPrivate">
                        <data name="TypeName" inType="win:UnicodeString" />
                        <data name="SecondTypeName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <DynamicTypeUseTwoParameters xmlns="myNs">
                                <TypeName> %1 </TypeName>
                                <SecondTypeName> %2 </SecondTypeName>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </DynamicTypeUseTwoParameters>
                        </UserData>
                    </template>

                    <template tid="DynamicTypeUsePrivateVariance">
                        <data name="TypeName" inType="win:UnicodeString" />
                        <data name="InterfaceTypeName" inType="win:UnicodeString" />
                        <data name="VariantInterfaceTypeName" inType="win:UnicodeString" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <DynamicTypeVariance xmlns="myNs">
                                <TypeName> %1 </TypeName>
                                <InterfaceTypeName> %2 </InterfaceTypeName>
                                <VariantInterfaceTypeName> %3 </VariantInterfaceTypeName>
                                <ClrInstanceID> %4 </ClrInstanceID>
                            </DynamicTypeVariance>
                        </UserData>
                    </template>

                    <template tid="DynamicTypeUseStringAndIntPrivate">
                        <data name="TypeName" inType="win:UnicodeString" />
                        <data name="Int1" inType="win:Int32" />
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <DynamicTypeUseStringAndInt xmlns="myNs">
                                <TypeName> %1 </TypeName>
                                <Int1> %2 </Int1>
                                <ClrInstanceID> %3 </ClrInstanceID>
                            </DynamicTypeUseStringAndInt>
                        </UserData>
                    </template>

                    <template tid="DynamicTypeUseNoParametersPrivate">
                        <data name="ClrInstanceID" inType="win:UInt16" />
                        <UserData>
                            <DynamicTypeUseStringAndInt xmlns="myNs">
                                <ClrInstanceID> %1 </ClrInstanceID>
                            </DynamicTypeUseStringAndInt>
                        </UserData>
                    </template>

                </templates>

                <!--Events-->
                <events>
                    <!--Private GC events, value reserved from 0 to 79-->
                    <event value="1" version="0" level="win:Informational"  template="GCDecision"
                           keywords ="GCPrivateKeyword"  opcode="GCDecision"
                           task="GarbageCollectionPrivate"
                           symbol="GCDecision" message="$(string.PrivatePublisher.GCDecisionEventMessage)"/>

                    <event value="1" version="1" level="win:Informational"  template="GCDecision_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCDecision"
                           task="GarbageCollectionPrivate"
                           symbol="GCDecision_V1" message="$(string.PrivatePublisher.GCDecision_V1EventMessage)"/>

                    <event value="2" version="0" level="win:Informational"  template="GCSettings"
                           keywords ="GCPrivateKeyword"  opcode="GCSettings"
                           task="GarbageCollectionPrivate"
                           symbol="GCSettings" message="$(string.PrivatePublisher.GCSettingsEventMessage)"/>

                    <event value="2" version="1" level="win:Informational"  template="GCSettings_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCSettings"
                           task="GarbageCollectionPrivate"
                           symbol="GCSettings_V1" message="$(string.PrivatePublisher.GCSettings_V1EventMessage)"/>

                    <event value="3" version="0" level="win:Verbose"  template="GCOptimized"
                           keywords ="GCPrivateKeyword"  opcode="GCOptimized"
                           task="GarbageCollectionPrivate"
                           symbol="GCOptimized" message="$(string.PrivatePublisher.GCOptimizedEventMessage)"/>

                    <event value="3" version="1" level="win:Verbose"  template="GCOptimized_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCOptimized"
                           task="GarbageCollectionPrivate"
                           symbol="GCOptimized_V1" message="$(string.PrivatePublisher.GCOptimized_V1EventMessage)"/>

                    <event value="4" version="2" level="win:Informational"  template="GCPerHeapHistory"
                           keywords ="GCPrivateKeyword"  opcode="GCPerHeapHistory"
                           task="GarbageCollectionPrivate"
                           symbol="GCPerHeapHistory" message="$(string.PrivatePublisher.GCPerHeapHistoryEventMessage)"/>

                    <event value="4" version="1" level="win:Informational"  template="GCPerHeapHistory_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCPerHeapHistory"
                           task="GarbageCollectionPrivate"
                           symbol="GCPerHeapHistory_V1" message="$(string.PrivatePublisher.GCPerHeapHistory_V1EventMessage)"/>

                    <event value="5" version="0" level="win:Informational"  template="GCGlobalHeap"
                           keywords ="GCPrivateKeyword"  opcode="GCGlobalHeapHistory"
                           task="GarbageCollectionPrivate"
                           symbol="GCGlobalHeapHistory" message="$(string.PrivatePublisher.GCGlobalHeapEventMessage)"/>

                    <event value="5" version="1" level="win:Informational"  template="GCGlobalHeap_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCGlobalHeapHistory"
                           task="GarbageCollectionPrivate"
                           symbol="GCGlobalHeapHistory_V1" message="$(string.PrivatePublisher.GCGlobalHeap_V1EventMessage)"/>

                    <event value="6" version="0" level="win:Verbose"  template="GCJoin"
                           keywords ="GCPrivateKeyword"  opcode="GCJoin"
                           task="GarbageCollectionPrivate"
                           symbol="GCJoin" message="$(string.PrivatePublisher.GCJoinEventMessage)"/>

                    <event value="6" version="1" level="win:Verbose"  template="GCJoin_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCJoin"
                           task="GarbageCollectionPrivate"
                           symbol="GCJoin_V1" message="$(string.PrivatePublisher.GCJoin_V1EventMessage)"/>

                    <event value="7" version="0" level="win:Informational"  template="PrvGCMark"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkStackRoots"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkStackRoots" message="$(string.PrivatePublisher.GCMarkStackRootsEventMessage)"/>

                    <event value="7" version="1" level="win:Informational"  template="PrvGCMark_V1"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkStackRoots"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkStackRoots_V1" message="$(string.PrivatePublisher.GCMarkStackRoots_V1EventMessage)"/>

                    <event value="8" version="0" level="win:Informational"  template="PrvGCMark"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkFinalizeQueueRoots"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkFinalizeQueueRoots" message="$(string.PrivatePublisher.GCMarkFinalizeQueueRootsEventMessage)"/>

                    <event value="8" version="1" level="win:Informational"  template="PrvGCMark_V1"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkFinalizeQueueRoots"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkFinalizeQueueRoots_V1" message="$(string.PrivatePublisher.GCMarkFinalizeQueueRoots_V1EventMessage)"/>

                    <event value="9" version="0" level="win:Informational"  template="PrvGCMark"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkHandles"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkHandles" message="$(string.PrivatePublisher.GCMarkHandlesEventMessage)"/>

                    <event value="9" version="1" level="win:Informational"  template="PrvGCMark_V1"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkHandles"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkHandles_V1" message="$(string.PrivatePublisher.GCMarkHandles_V1EventMessage)"/>

                    <event value="10" version="0" level="win:Informational"  template="PrvGCMark"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkCards"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkCards" message="$(string.PrivatePublisher.GCMarkCardsEventMessage)"/>

                    <event value="10" version="1" level="win:Informational"  template="PrvGCMark_V1"
                           keywords ="GCPrivateKeyword"  opcode="PrvGCMarkCards"
                           task="GarbageCollectionPrivate"
                           symbol="PrvGCMarkCards_V1" message="$(string.PrivatePublisher.GCMarkCards_V1EventMessage)"/>

                    <event value="11" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGCBegin"
                           task="GarbageCollectionPrivate"
                           symbol="BGCBegin" message="$(string.PrivatePublisher.BGCBeginEventMessage)"/>

                    <event value="12" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGC1stNonConEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGC1stNonConEnd" message="$(string.PrivatePublisher.BGC1stNonConEndEventMessage)"/>

                    <event value="13" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGC1stConEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGC1stConEnd" message="$(string.PrivatePublisher.BGC1stConEndEventMessage)"/>

                    <event value="14" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGC2ndNonConBegin"
                           task="GarbageCollectionPrivate"
                           symbol="BGC2ndNonConBegin" message="$(string.PrivatePublisher.BGC2ndNonConBeginEventMessage)"/>

                    <event value="15" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGC2ndNonConEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGC2ndNonConEnd" message="$(string.PrivatePublisher.BGC2ndNonConEndEventMessage)"/>

                    <event value="16" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGC2ndConBegin"
                           task="GarbageCollectionPrivate"
                           symbol="BGC2ndConBegin" message="$(string.PrivatePublisher.BGC2ndConBeginEventMessage)"/>

                    <event value="17" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGC2ndConEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGC2ndConEnd" message="$(string.PrivatePublisher.BGC2ndConEndEventMessage)"/>

                    <event value="18" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGCPlanEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGCPlanEnd" message="$(string.PrivatePublisher.BGCPlanEndEventMessage)"/>

                    <event value="19" version="0" level="win:Informational"  template="GCNoUserData"
                           keywords ="GCPrivateKeyword"  opcode="BGCSweepEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGCSweepEnd" message="$(string.PrivatePublisher.BGCSweepEndEventMessage)"/>

                    <event value="20" version="0" level="win:Informational"  template="BGCDrainMark"
                           keywords ="GCPrivateKeyword"  opcode="BGCDrainMark"
                           task="GarbageCollectionPrivate"
                           symbol="BGCDrainMark" message="$(string.PrivatePublisher.BGCDrainMarkEventMessage)"/>

                    <event value="21" version="0" level="win:Informational"  template="BGCRevisit"
                           keywords ="GCPrivateKeyword"  opcode="BGCRevisit"
                           task="GarbageCollectionPrivate"
                           symbol="BGCRevisit" message="$(string.PrivatePublisher.BGCRevisitEventMessage)"/>

                    <event value="22" version="0" level="win:Informational"  template="BGCOverflow"
                           keywords ="GCPrivateKeyword"  opcode="BGCOverflow"
                           task="GarbageCollectionPrivate"
                           symbol="BGCOverflow" message="$(string.PrivatePublisher.BGCOverflowEventMessage)"/>

                    <event value="23" version="0" level="win:Informational"  template="BGCAllocWait"
                           keywords ="GCPrivateKeyword"  opcode="BGCAllocWaitBegin"
                           task="GarbageCollectionPrivate"
                           symbol="BGCAllocWaitBegin" message="$(string.PrivatePublisher.BGCAllocWaitEventMessage)"/>

                    <event value="24" version="0" level="win:Informational"  template="BGCAllocWait"
                           keywords ="GCPrivateKeyword"  opcode="BGCAllocWaitEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGCAllocWaitEnd" message="$(string.PrivatePublisher.BGCAllocWaitEventMessage)"/>

                    <event value="25" version="0" level="win:Informational"  template="GCFullNotify"
                           keywords ="GCPrivateKeyword"  opcode="GCFullNotify"
                           task="GarbageCollectionPrivate"
                           symbol="GCFullNotify" message="$(string.PrivatePublisher.GCFullNotifyEventMessage)"/>

                    <event value="25" version="1" level="win:Informational"  template="GCFullNotify_V1"
                           keywords ="GCPrivateKeyword"  opcode="GCFullNotify"
                           task="GarbageCollectionPrivate"
                           symbol="GCFullNotify_V1" message="$(string.PrivatePublisher.GCFullNotify_V1EventMessage)"/>

                    <event value="26" version="0" level="win:Informational"  template="BGC1stSweepEnd"
                           keywords ="GCPrivateKeyword"  opcode="BGC1stSweepEnd"
                           task="GarbageCollectionPrivate"
                           symbol="BGC1stSweepEnd" message="$(string.PrivatePublisher.BGC1stSweepEndEventMessage)"/>

                    <!--Private events from other components in CLR, starting value 80-->
                    <event value="80" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="EEStartupStart"
                           task="Startup"
                           symbol="EEStartupStart" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="80" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="EEStartupStart"
                           task="Startup"
                           symbol="EEStartupStart_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="81" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="EEStartupEnd"
                           task="Startup"
                           symbol="EEStartupEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="81" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="EEStartupEnd"
                           task="Startup"
                           symbol="EEStartupEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="82" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="EEConfigSetup"
                           task="Startup"
                           symbol="EEConfigSetup" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="82" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="EEConfigSetup"
                           task="Startup"
                           symbol="EEConfigSetup_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="83" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="EEConfigSetupEnd"
                           task="Startup"
                           symbol="EEConfigSetupEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="83" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="EEConfigSetupEnd"
                           task="Startup"
                           symbol="EEConfigSetupEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="84" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="LoadSystemBases"
                           task="Startup"
                           symbol="LdSysBases" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="84" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="LoadSystemBases"
                           task="Startup"
                           symbol="LdSysBases_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="85" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="LoadSystemBasesEnd"
                           task="Startup"
                           symbol="LdSysBasesEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="85" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="LoadSystemBasesEnd"
                           task="Startup"
                           symbol="LdSysBasesEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="86" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ExecExe"
                           task="Startup"
                           symbol="ExecExe" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="86" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ExecExe"
                           task="Startup"
                           symbol="ExecExe_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="87" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ExecExeEnd"
                           task="Startup"
                           symbol="ExecExeEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="87" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ExecExeEnd"
                           task="Startup"
                           symbol="ExecExeEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="88" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="Main"
                           task="Startup"
                           symbol="Main" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="88" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="Main"
                           task="Startup"
                           symbol="Main_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="89" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="MainEnd"
                           task="Startup"
                           symbol="MainEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="89" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="MainEnd"
                           task="Startup"
                           symbol="MainEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="90" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ApplyPolicyStart"
                           task="Startup"
                           symbol="ApplyPolicyStart" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="90" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ApplyPolicyStart"
                           task="Startup"
                           symbol="ApplyPolicyStart_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="91" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ApplyPolicyEnd"
                           task="Startup"
                           symbol="ApplyPolicyEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="91" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ApplyPolicyEnd"
                           task="Startup"
                           symbol="ApplyPolicyEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="92" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="LdLibShFolder"
                           task="Startup"
                           symbol="LdLibShFolder" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="92" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="LdLibShFolder"
                           task="Startup"
                           symbol="LdLibShFolder_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="93" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="LdLibShFolderEnd"
                           task="Startup"
                           symbol="LdLibShFolderEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="93" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="LdLibShFolderEnd"
                           task="Startup"
                           symbol="LdLibShFolderEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="94" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="PrestubWorker"
                           task="Startup"
                           symbol="PrestubWorker" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="94" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="PrestubWorker"
                           task="Startup"
                           symbol="PrestubWorker_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="95" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="PrestubWorkerEnd"
                           task="Startup"
                           symbol="PrestubWorkerEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="95" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="PrestubWorkerEnd"
                           task="Startup"
                           symbol="PrestubWorkerEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="96" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="GetInstallationStart"
                           task="Startup"
                           symbol="GetInstallationStart" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="96" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="GetInstallationStart"
                           task="Startup"
                           symbol="GetInstallationStart_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="97" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="GetInstallationEnd"
                           task="Startup"
                           symbol="GetInstallationEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="97" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="GetInstallationEnd"
                           task="Startup"
                           symbol="GetInstallationEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="98" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="OpenHModule"
                           task="Startup"
                           symbol="OpenHModule" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="98" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="OpenHModule"
                           task="Startup"
                           symbol="OpenHModule_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="99" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="OpenHModuleEnd"
                           task="Startup"
                           symbol="OpenHModuleEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="99" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="OpenHModuleEnd"
                           task="Startup"
                           symbol="OpenHModuleEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="100" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ExplicitBindStart"
                           task="Startup"
                           symbol="ExplicitBindStart" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="100" version="1" level="win:Informational"  template="Startup_V1"
                           task="Startup"
                           keywords ="StartupKeyword"  opcode="ExplicitBindStart"
                           symbol="ExplicitBindStart_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="101" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ExplicitBindEnd"
                           task="Startup"
                           symbol="ExplicitBindEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="101" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ExplicitBindEnd"
                           task="Startup"
                           symbol="ExplicitBindEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="102" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ParseXml"
                           task="Startup"
                           symbol="ParseXml" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="102" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ParseXml"
                           task="Startup"
                           symbol="ParseXml_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="103" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="ParseXmlEnd"
                           task="Startup"
                           symbol="ParseXmlEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="103" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="ParseXmlEnd"
                           task="Startup"
                           symbol="ParseXmlEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="104" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="InitDefaultDomain"
                           task="Startup"
                           symbol="InitDefaultDomain" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="104" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="InitDefaultDomain"
                           task="Startup"
                           symbol="InitDefaultDomain_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="105" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="InitDefaultDomainEnd"
                           task="Startup"
                           symbol="InitDefaultDomainEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="105" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="InitDefaultDomainEnd"
                           task="Startup"
                           symbol="InitDefaultDomainEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="106" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="InitSecurity"
                           task="Startup"
                           symbol="InitSecurity" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="106" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="InitSecurity"
                           task="Startup"
                           symbol="InitSecurity_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="107" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="InitSecurityEnd"
                           task="Startup"
                           symbol="InitSecurityEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="107" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="InitSecurityEnd"
                           task="Startup"
                           symbol="InitSecurityEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="108" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="AllowBindingRedirs"
                           task="Startup"
                           symbol="AllowBindingRedirs" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="108" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="AllowBindingRedirs"
                           task="Startup"
                           symbol="AllowBindingRedirs_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="109" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="AllowBindingRedirsEnd"
                           task="Startup"
                           symbol="AllowBindingRedirsEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="109" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="AllowBindingRedirsEnd"
                           task="Startup"
                           symbol="AllowBindingRedirsEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="110" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="EEConfigSync"
                           task="Startup"
                           symbol="EEConfigSync" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="110" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="EEConfigSync"
                           task="Startup"
                           symbol="EEConfigSync_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="111" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="EEConfigSyncEnd"
                           task="Startup"
                           symbol="EEConfigSyncEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="111" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="EEConfigSyncEnd"
                           task="Startup"
                           symbol="EEConfigSyncEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="112" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="FusionBinding"
                           task="Startup"
                           symbol="FusionBinding" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="112" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="FusionBinding"
                           task="Startup"
                           symbol="FusionBinding_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="113" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="FusionBindingEnd"
                           task="Startup"
                           symbol="FusionBindingEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="113" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="FusionBindingEnd"
                           task="Startup"
                           symbol="FusionBindingEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="114" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="LoaderCatchCall"
                           task="Startup"
                           symbol="LoaderCatchCall" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="114" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="LoaderCatchCall"
                           task="Startup"
                           symbol="LoaderCatchCall_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="115" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="LoaderCatchCallEnd"
                           task="Startup"
                           symbol="LoaderCatchCallEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="115" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="LoaderCatchCallEnd"
                           task="Startup"
                           symbol="LoaderCatchCallEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="116" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="FusionInit"
                           task="Startup"
                           symbol="FusionInit" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="116" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="FusionInit"
                           task="Startup"
                           symbol="FusionInit_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="117" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="FusionInitEnd"
                           task="Startup"
                           symbol="FusionInitEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="117" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="FusionInitEnd"
                           task="Startup"
                           symbol="FusionInitEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="118" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="FusionAppCtx"
                           task="Startup"
                           symbol="FusionAppCtx" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="118" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="FusionAppCtx"
                           task="Startup"
                           symbol="FusionAppCtx_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="119" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="FusionAppCtxEnd"
                           task="Startup"
                           symbol="FusionAppCtxEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="119" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="FusionAppCtxEnd"
                           task="Startup"
                           symbol="FusionAppCtxEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="120" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="Fusion2EE"
                           task="Startup"
                           symbol="Fusion2EE" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="120" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="Fusion2EE"
                           task="Startup"
                           symbol="Fusion2EE_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="121" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="Fusion2EEEnd"
                           task="Startup"
                           symbol="Fusion2EEEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="121" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="Fusion2EEEnd"
                           task="Startup"
                           symbol="Fusion2EEEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="122" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="SecurityCatchCall"
                           task="Startup"
                           symbol="SecurityCatchCall" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="122" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="SecurityCatchCall"
                           task="Startup"
                           symbol="SecurityCatchCall_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="123" version="0" level="win:Informational"  template="Startup"
                           keywords ="StartupKeyword"  opcode="SecurityCatchCallEnd"
                           task="Startup"
                           symbol="SecurityCatchCallEnd" message="$(string.PrivatePublisher.StartupEventMessage)"/>

                    <event value="123" version="1" level="win:Informational"  template="Startup_V1"
                           keywords ="StartupKeyword"  opcode="SecurityCatchCallEnd"
                           task="Startup"
                           symbol="SecurityCatchCallEnd_V1" message="$(string.PrivatePublisher.Startup_V1EventMessage)"/>

                    <event value="151" version="0" level="win:LogAlways"  template="ClrStackWalk"
                           keywords ="StackKeyword"  opcode="CLRStackWalk"
                           task="CLRStackPrivate"
                           symbol="CLRStackWalkPrivate" message="$(string.PrivatePublisher.StackEventMessage)"/>

                    <event value="158" version="0" level="win:Informational"  template="ModuleRangePrivate"
                        keywords ="PerfTrackPrivateKeyword" opcode="ModuleRangeLoadPrivate"
                        task="CLRPerfTrackPrivate"
                        symbol="ModuleRangeLoadPrivate" message="$(string.PrivatePublisher.ModuleRangeLoadEventMessage)"/>

                    <event value="159" version="0" level="win:Informational"  template="Binding"
                         keywords ="BindingKeyword"  opcode="BindingPolicyPhaseStart"
                         task="Binding"
                         symbol="BindingPolicyPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="160" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingPolicyPhaseEnd"
                           task="Binding"
                           symbol="BindingPolicyPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="161" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingNgenPhaseStart"
                           task="Binding"
                           symbol="BindingNgenPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="162" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingNgenPhaseEnd"
                           task="Binding"
                           symbol="BindingNgenPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="163" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingLookupAndProbingPhaseStart"
                           task="Binding"
                           symbol="BindingLookupAndProbingPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="164" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingLookupAndProbingPhaseEnd"
                           task="Binding"
                           symbol="BindingLookupAndProbingPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="165" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderPhaseStart"
                           task="Binding"
                           symbol="LoaderPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="166" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderPhaseEnd"
                           task="Binding"
                           symbol="LoaderPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="167" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingPhaseStart"
                           task="Binding"
                           symbol="BindingPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="168" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingPhaseEnd"
                           task="Binding"
                           symbol="BindingPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="169" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingDownloadPhaseStart"
                           task="Binding"
                           symbol="BindingDownloadPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="170" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="BindingDownloadPhaseEnd"
                           task="Binding"
                           symbol="BindingDownloadPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="171" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderAssemblyInitPhaseStart"
                           task="Binding"
                           symbol="LoaderAssemblyInitPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="172" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderAssemblyInitPhaseEnd"
                           task="Binding"
                           symbol="LoaderAssemblyInitPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="173" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderMappingPhaseStart"
                           task="Binding"
                           symbol="LoaderMappingPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="174" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderMappingPhaseEnd"
                           task="Binding"
                           symbol="LoaderMappingPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="175" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderDeliverEventsPhaseStart"
                           task="Binding"
                           symbol="LoaderDeliverEventsPhaseStart" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="176" version="0" level="win:Informational"  template="Binding"
                           keywords ="BindingKeyword"  opcode="LoaderDeliverEventsPhaseEnd"
                           task="Binding"
                           symbol="LoaderDeliverEventsPhaseEnd" message="$(string.PrivatePublisher.BindingEventMessage)"/>

                    <event value="177" version="0" level="win:Informational" template="EvidenceGenerated"
                           keywords="SecurityPrivateKeyword" opcode="EvidenceGenerated"
                           task="EvidenceGeneratedTask"
                           symbol="EvidenceGenerated" message="$(string.PrivatePublisher.EvidenceGeneratedEventMessage)"/>

                    <event value="178" version="0" level="win:Informational" template="ModuleTransparencyCalculation"
                           keywords="SecurityPrivateKeyword" opcode="ModuleTransparencyComputationStart"
                           task="TransparencyComputation"
                           symbol="ModuleTransparencyComputationStart" message="$(string.PrivatePublisher.ModuleTransparencyComputationStartEventMessage)" />

                    <event value="179" version="0" level="win:Informational" template="ModuleTransparencyCalculationResult"
                           keywords="SecurityPrivateKeyword" opcode="ModuleTransparencyComputationEnd"
                           task="TransparencyComputation"
                           symbol="ModuleTransparencyComputationEnd" message="$(string.PrivatePublisher.ModuleTransparencyComputationEndEventMessage)" />

                    <event value="180" version="0" level="win:Informational" template="TypeTransparencyCalculation"
                           keywords="SecurityPrivateKeyword" opcode="TypeTransparencyComputationStart"
                           task="TransparencyComputation"
                           symbol="TypeTransparencyComputationStart" message="$(string.PrivatePublisher.TypeTransparencyComputationStartEventMessage)" />

                    <event value="181" version="0" level="win:Informational" template="TypeTransparencyCalculationResult"
                           keywords="SecurityPrivateKeyword" opcode="TypeTransparencyComputationEnd"
                           task="TransparencyComputation"
                           symbol="TypeTransparencyComputationEnd" message="$(string.PrivatePublisher.TypeTransparencyComputationEndEventMessage)" />

                    <event value="182" version="0" level="win:Informational" template="MethodTransparencyCalculation"
                           keywords="SecurityPrivateKeyword" opcode="MethodTransparencyComputationStart"
                           task="TransparencyComputation"
                           symbol="MethodTransparencyComputationStart" message="$(string.PrivatePublisher.MethodTransparencyComputationStartEventMessage)" />

                    <event value="183" version="0" level="win:Informational" template="MethodTransparencyCalculationResult"
                           keywords="SecurityPrivateKeyword" opcode="MethodTransparencyComputationEnd"
                           task="TransparencyComputation"
                           symbol="MethodTransparencyComputationEnd" message="$(string.PrivatePublisher.MethodTransparencyComputationEndEventMessage)" />

                    <event value="184" version="0" level="win:Informational" template="FieldTransparencyCalculation"
                           keywords="SecurityPrivateKeyword" opcode="FieldTransparencyComputationStart"
                           task="TransparencyComputation"
                           symbol="FieldTransparencyComputationStart" message="$(string.PrivatePublisher.FieldTransparencyComputationStartEventMessage)" />

                    <event value="185" version="0" level="win:Informational" template="FieldTransparencyCalculationResult"
                           keywords="SecurityPrivateKeyword" opcode="FieldTransparencyComputationEnd"
                           task="TransparencyComputation"
                           symbol="FieldTransparencyComputationEnd" message="$(string.PrivatePublisher.FieldTransparencyComputationEndEventMessage)" />

                    <event value="186" version="0" level="win:Informational" template="TokenTransparencyCalculation"
                           keywords="SecurityPrivateKeyword" opcode="TokenTransparencyComputationStart"
                           task="TransparencyComputation"
                           symbol="TokenTransparencyComputationStart" message="$(string.PrivatePublisher.TokenTransparencyComputationStartEventMessage)" />

                    <event value="187" version="0" level="win:Informational" template="TokenTransparencyCalculationResult"
                           keywords="SecurityPrivateKeyword" opcode="TokenTransparencyComputationEnd"
                           task="TransparencyComputation"
                           symbol="TokenTransparencyComputationEnd" message="$(string.PrivatePublisher.TokenTransparencyComputationEndEventMessage)" />

                    <event value="188" version="0" level="win:Informational" template="NgenBindEvent"
                           keywords="PrivateFusionKeyword" opcode="NgenBind"
                           task="CLRNgenBinder"
                           symbol="NgenBindEvent" message="$(string.PrivatePublisher.NgenBinderMessage)"/>

                    <!-- CLR FailFast events -->
                    <event value="191" version="0" level="win:Critical"  template="FailFast"
                           opcode="FailFast"
                           task="CLRFailFast"
                           symbol="FailFast" message="$(string.PrivatePublisher.FailFastEventMessage)"/>

                    <event value="192" version="0" level="win:Verbose"  template="PrvFinalizeObject"
                           keywords ="GCPrivateKeyword"
                           opcode="PrvFinalizeObject"
                           task="GarbageCollectionPrivate"
                           symbol="PrvFinalizeObject" message="$(string.PrivatePublisher.FinalizeObjectEventMessage)"/>

                    <event value="193" version="0" level="win:Verbose"  template="CCWRefCountChangeAnsi"
                           keywords="InteropPrivateKeyword"
                           opcode="CCWRefCountChange"
                           task="GarbageCollectionPrivate"
                           symbol="CCWRefCountChangeAnsi" message="$(string.PrivatePublisher.CCWRefCountChangeEventMessage)"/>

                    <event value="194" version="0" level="win:Verbose"  template="PrvSetGCHandle"
                           keywords="GCHandlePrivateKeyword"
                           opcode="SetGCHandle"
                           task="GarbageCollectionPrivate"
                           symbol="PrvSetGCHandle" message="$(string.PrivatePublisher.SetGCHandleEventMessage)"/>

                    <event value="195" version="0" level="win:Verbose"  template="PrvDestroyGCHandle"
                           keywords="GCHandlePrivateKeyword"
                           opcode="DestroyGCHandle"
                           task="GarbageCollectionPrivate"
                           symbol="PrvDestroyGCHandle" message="$(string.PrivatePublisher.DestroyGCHandleEventMessage)"/>

                    <event value="196" version="0" level="win:Informational" template="FusionMessage"
                            keywords="BindingKeyword" opcode="FusionMessage"
                            task="Binding"
                            symbol="FusionMessageEvent" message="$(string.PrivatePublisher.FusionMessageEventMessage)"/>

                    <event value="197" version="0" level="win:Informational" template="FusionErrorCode"
                            keywords="BindingKeyword" opcode="FusionErrorCode"
                            task="Binding"
                            symbol="FusionErrorCodeEvent" message="$(string.PrivatePublisher.FusionErrorCodeEventMessage)"/>

                    <event value="199" version="0" level="win:Verbose" template="PinPlugAtGCTime"
                           keywords="GCPrivateKeyword"
                           opcode="PinPlugAtGCTime"
                           task="GarbageCollectionPrivate"
                           symbol="PinPlugAtGCTime" message="$(string.PrivatePublisher.PinPlugAtGCTimeEventMessage)"/>

                    <event value="200" version="0" level="win:Verbose"  template="CCWRefCountChange"
                           keywords="InteropPrivateKeyword"
                           opcode="CCWRefCountChange"
                           task="GarbageCollectionPrivate"
                           symbol="CCWRefCountChange" message="$(string.PrivatePublisher.CCWRefCountChangeEventMessage)"/>

                    <event value="310" version="0" level="win:Verbose" template="LoaderHeapPrivate"
                           keywords="LoaderHeapPrivateKeyword" opcode="AllocRequest"
                           task="LoaderHeapAllocation" symbol="AllocRequest" message="$(string.PrivatePublisher.AllocRequestEventMessage)" />

                    <!-- CLR Private Multicore JIT events -->
                    <event value="201" version="0" level="win:Informational" template="MulticoreJitPrivate"
                           keywords="MulticoreJitPrivateKeyword" opcode="Common"
                           task="CLRMulticoreJit" symbol="MulticoreJit" message="$(string.PrivatePublisher.MulticoreJitCommonEventMessage)" />
                    <event value="202" version="0" level="win:Informational" template="MulticoreJitMethodCodeReturnedPrivate"
                           keywords="MulticoreJitPrivateKeyword" opcode="MethodCodeReturned"
                           task="CLRMulticoreJit" symbol="MulticoreJitMethodCodeReturned" message="$(string.PrivatePublisher.MulticoreJitMethodCodeReturnedMessage)" />

                    <!-- CLR Private Dynamic Type Usage events NOTE: These are not used anymore. They are kept around for backcompat with traces that might have already contained these -->
                    <event value="400" version="0" level="win:Informational" template="DynamicTypeUsePrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="IInspectableRuntimeClassName"
                           task="DynamicTypeUsage"
                           opcode="IInspectableRuntimeClassName"
                           message="$(string.PrivatePublisher.IInspectableRuntimeClassNameMessage)" />

                    <event value="401" version="0" level="win:Informational" template="DynamicTypeUseTwoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="WinRTUnbox"
                           task="DynamicTypeUsage"
                           opcode="WinRTUnbox"
                           message="$(string.PrivatePublisher.WinRTUnboxMessage)" />

                    <event value="402" version="0" level="win:Informational" template="DynamicTypeUsePrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="CreateRCW"
                           task="DynamicTypeUsage"
                           opcode="CreateRCW"
                           message="$(string.PrivatePublisher.CreateRcwMessage)" />

                    <event value="403" version="0" level="win:Informational" template="DynamicTypeUsePrivateVariance"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="RCWVariance"
                           task="DynamicTypeUsage"
                           opcode="RCWVariance"
                           message="$(string.PrivatePublisher.RcwVarianceMessage)" />

                    <event value="404" version="0" level="win:Informational" template="DynamicTypeUseTwoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="RCWIEnumerableCasting"
                           task="DynamicTypeUsage"
                           opcode="RCWIEnumerableCasting"
                           message="$(string.PrivatePublisher.RCWIEnumerableCastingMessage)" />

                    <event value="405" version="0" level="win:Informational" template="DynamicTypeUsePrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="CreateCCW"
                           task="DynamicTypeUsage"
                           opcode="CreateCCW"
                           message="$(string.PrivatePublisher.CreateCCWMessage)" />

                    <event value="406" version="0" level="win:Informational" template="DynamicTypeUsePrivateVariance"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="CCWVariance"
                           task="DynamicTypeUsage"
                           opcode="CCWVariance"
                           message="$(string.PrivatePublisher.CCWVarianceMessage)" />

                    <event value="407" version="0" level="win:Informational" template="DynamicTypeUseStringAndIntPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="ObjectVariantMarshallingToNative"
                           task="DynamicTypeUsage"
                           opcode="ObjectVariantMarshallingToNative"
                           message="$(string.PrivatePublisher.ObjectVariantMarshallingMessage)" />

                    <event value="408" version="0" level="win:Informational" template="DynamicTypeUseTwoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="GetTypeFromGUID"
                           task="DynamicTypeUsage"
                           opcode="GetTypeFromGUID"
                           message="$(string.PrivatePublisher.GetTypeFromGUIDMessage)" />

                    <event value="409" version="0" level="win:Informational" template="DynamicTypeUseTwoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="GetTypeFromProgID"
                           task="DynamicTypeUsage"
                           opcode="GetTypeFromProgID"
                           message="$(string.PrivatePublisher.GetTypeFromProgIDMessage)" />

                    <event value="410" version="0" level="win:Informational" template="DynamicTypeUseTwoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="ConvertToCallbackEtw"
                           task="DynamicTypeUsage"
                           opcode="ConvertToCallbackEtw"
                           message="$(string.PrivatePublisher.ConvertToCallbackMessage)" />

                    <event value="411" version="0" level="win:Informational" template="DynamicTypeUseNoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="BeginCreateManagedReference"
                           task="DynamicTypeUsage"
                           opcode="BeginCreateManagedReference"
                           message="$(string.PrivatePublisher.BeginCreateManagedReferenceMessage)" />

                    <event value="412" version="0" level="win:Informational" template="DynamicTypeUseNoParametersPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="EndCreateManagedReference"
                           task="DynamicTypeUsage"
                           opcode="EndCreateManagedReference"
                           message="$(string.PrivatePublisher.EndCreateManagedReferenceMessage)" />

                    <event value="413" version="0" level="win:Informational" template="DynamicTypeUseStringAndIntPrivate"
                           keywords="DynamicTypeUsageKeyword"
                           symbol="ObjectVariantMarshallingToManaged"
                           task="DynamicTypeUsage"
                           opcode="ObjectVariantMarshallingToManaged"
                           message="$(string.PrivatePublisher.ObjectVariantMarshallingMessage)" />
                </events>
            </provider>

        </events>
    </instrumentation>

    <localization>
        <resources culture="en-US">
            <stringTable>
                <!--Message Strings-->
                <!-- Event Messages -->
                <string id="RuntimePublisher.GCStartEventMessage" value="Count=%1;%nReason=%2" />
                <string id="RuntimePublisher.GCStart_V1EventMessage" value="Count=%1;%nDepth=%2;%nReason=%3;%nType=%4;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.GCStart_V2EventMessage" value="Count=%1;%nDepth=%2;%nReason=%3;%nType=%4;%nClrInstanceID=%5;%nClientSequenceNumber=%6" />
                <string id="RuntimePublisher.GCEndEventMessage" value="Count=%1;%nDepth=%2" />
                <string id="RuntimePublisher.GCEnd_V1EventMessage" value="Count=%1;%nDepth=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.GCHeapStatsEventMessage" value="GenerationSize0=%1;%nTotalPromotedSize0=%2;%nGenerationSize1=%3;%nTotalPromotedSize1=%4;%nGenerationSize2=%5;%nTotalPromotedSize2=%6;%nGenerationSize3=%7;%nTotalPromotedSize3=%8;%nFinalizationPromotedSize=%9;%nFinalizationPromotedCount=%10;%nPinnedObjectCount=%11;%nSinkBlockCount=%12;%nGCHandleCount=%13" />
                <string id="RuntimePublisher.GCHeapStats_V1EventMessage" value="GenerationSize0=%1;%nTotalPromotedSize0=%2;%nGenerationSize1=%3;%nTotalPromotedSize1=%4;%nGenerationSize2=%5;%nTotalPromotedSize2=%6;%nGenerationSize3=%7;%nTotalPromotedSize3=%8;%nFinalizationPromotedSize=%9;%nFinalizationPromotedCount=%10;%nPinnedObjectCount=%11;%nSinkBlockCount=%12;%nGCHandleCount=%13;%nClrInstanceID=%14" />
                <string id="RuntimePublisher.GCCreateSegmentEventMessage" value="Address=%1;%nSize=%2;%nType=%3" />
                <string id="RuntimePublisher.GCCreateSegment_V1EventMessage" value="Address=%1;%nSize=%2;%nType=%3;%nClrInstanceID=%4" />
                <string id="RuntimePublisher.GCFreeSegmentEventMessage" value="Address=%1" />
                <string id="RuntimePublisher.GCFreeSegment_V1EventMessage" value="Address=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.GCRestartEEBeginEventMessage" value="NONE" />
                <string id="RuntimePublisher.GCRestartEEBegin_V1EventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.GCRestartEEEndEventMessage" value="NONE" />
                <string id="RuntimePublisher.GCRestartEEEnd_V1EventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.GCSuspendEEEventMessage" value="Reason=%1" />
                <string id="RuntimePublisher.GCSuspendEE_V1EventMessage" value="Reason=%1;%nCount=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.GCSuspendEEEndEventMessage" value="NONE" />
                <string id="RuntimePublisher.GCSuspendEEEnd_V1EventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.GCAllocationTickEventMessage" value="Amount=%1;%nKind=%2" />
                <string id="RuntimePublisher.GCAllocationTick_V1EventMessage" value="Amount=%1;%nKind=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.GCAllocationTick_V2EventMessage" value="Amount=%1;%nKind=%2;%nClrInstanceID=%3;Amount64=%4;%nTypeID=%5;%nTypeName=%6;%nHeapIndex=%7" />
                <string id="RuntimePublisher.GCAllocationTick_V3EventMessage" value="Amount=%1;%nKind=%2;%nClrInstanceID=%3;Amount64=%4;%nTypeID=%5;%nTypeName=%6;%nHeapIndex=%7;%nAddress=%8" />
                <string id="RuntimePublisher.GCCreateConcurrentThreadEventMessage" value="NONE" />
                <string id="RuntimePublisher.GCCreateConcurrentThread_V1EventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.GCTerminateConcurrentThreadEventMessage" value="NONE" />
                <string id="RuntimePublisher.GCTerminateConcurrentThread_V1EventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.GCFinalizersEndEventMessage" value="Count=%1" />
                <string id="RuntimePublisher.GCFinalizersEnd_V1EventMessage" value="Count=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.GCFinalizersBeginEventMessage" value="NONE" />
                <string id="RuntimePublisher.GCFinalizersBegin_V1EventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.BulkTypeEventMessage" value="Count=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.GCBulkRootEdgeEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCBulkRootCCWEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCBulkRCWEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCBulkRootStaticVarEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCDynamicEventMessage" value="ClrInstanceID=%1;Data=%2;Size=%3" />
                <string id="RuntimePublisher.GCBulkRootConditionalWeakTableElementEdgeEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCBulkNodeEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCBulkEdgeEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCSampledObjectAllocationHighEventMessage" value="High:ClrInstanceID=%1;%nAddress=%2;%nTypeID=%3;%nObjectCountForTypeSample=%4;%nTotalSizeForTypeSample=%5" />
                <string id="RuntimePublisher.GCSampledObjectAllocationLowEventMessage" value="Low:ClrInstanceID=%1;%nAddress=%2;%nTypeID=%3;%nObjectCountForTypeSample=%4;%nTotalSizeForTypeSample=%5" />
                <string id="RuntimePublisher.GCBulkSurvivingObjectRangesEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCBulkMovedObjectRangesEventMessage" value="ClrInstanceID=%1;%nIndex=%2;%nCount=%3" />
                <string id="RuntimePublisher.GCGenerationRangeEventMessage" value="ClrInstanceID=%1;%nGeneration=%2;%nRangeStart=%3;%nRangeUsedLength=%4;%nRangeReservedLength=%5" />
                <string id="RuntimePublisher.GCMarkStackRootsEventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.GCMarkFinalizeQueueRootsEventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.GCMarkHandlesEventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.GCMarkOlderGenerationRootsEventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.GCMarkWithTypeEventMessage" value="HeapNum=%1;%nClrInstanceID=%2;%nType=%3;%nBytes=%4"/>
                <string id="RuntimePublisher.GCJoin_V2EventMessage" value="Heap=%1;%nJoinTime=%2;%nJoinType=%3;%nClrInstanceID=%4;%nJoinID=%5"/>
                <string id="RuntimePublisher.GCPerHeapHistory_V3EventMessage" value="ClrInstanceID=%1;%nFreeListAllocated=%2;%nFreeListRejected=%3;%nEndOfSegAllocated=%4;%nCondemnedAllocated=%5;%nPinnedAllocated=%6;%nPinnedAllocatedAdvance=%7;%RunningFreeListEfficiency=%8;%nCondemnReasons0=%9;%nCondemnReasons1=%10;%nCompactMechanisms=%11;%nExpandMechanisms=%12;%nHeapIndex=%13;%nExtraGen0Commit=%14;%nCount=%15"/>
                <string id="RuntimePublisher.GCGlobalHeap_V2EventMessage" value="FinalYoungestDesired=%1;%nNumHeaps=%2;%nCondemnedGeneration=%3;%nGen0ReductionCountD=%4;%nReason=%5;%nGlobalMechanisms=%6;%nClrInstanceID=%7;%nPauseMode=%8;%nMemoryPressure=%9"/>
                <string id="RuntimePublisher.FinalizeObjectEventMessage" value="TypeID=%1;%nObjectID=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.GCTriggeredEventMessage" value="Reason=%1" />
                <string id="RuntimePublisher.PinObjectAtGCTimeEventMessage" value="HandleID=%1;%nObjectID=%2;%nObjectSize=%3;%nTypeName=%4;%n;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.IncreaseMemoryPressureEventMessage" value="BytesAllocated=%1;%n;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.DecreaseMemoryPressureEventMessage" value="BytesFreed=%1;%n;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.WorkerThreadCreateEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2" />
                <string id="RuntimePublisher.WorkerThreadTerminateEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2" />
                <string id="RuntimePublisher.WorkerThreadRetirementRetireThreadEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2" />
                <string id="RuntimePublisher.WorkerThreadRetirementUnretireThreadEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreads=%2" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadEventMessage" value="WorkerThreadCount=%1;%nRetiredWorkerThreadCount=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentSampleEventMessage" value="Throughput=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentAdjustmentEventMessage" value="AverageThroughput=%1;%nNewWorkerThreadCount=%2;%nReason=%3;%nClrInstanceID=%4" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentStatsEventMessage" value="Duration=%1;%nThroughput=%2;%nThreadWave=%3;%nThroughputWave=%4;%nThroughputErrorEstimate=%5;%nAverageThroughputErrorEstimate=%6;%nThroughputRatio=%7;%nConfidence=%8;%nNewControlSetting=%9;%nNewThreadWaveMagnitude=%10;%nClrInstanceID=%11" />
                <string id="RuntimePublisher.IOThreadCreateEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2" />
                <string id="RuntimePublisher.IOThreadCreate_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.IOThreadTerminateEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2" />
                <string id="RuntimePublisher.IOThreadTerminate_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.IOThreadRetirementRetireThreadEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2" />
                <string id="RuntimePublisher.IOThreadRetirementRetireThread_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.IOThreadRetirementUnretireThreadEventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2" />
                <string id="RuntimePublisher.IOThreadRetirementUnretireThread_V1EventMessage" value="IOThreadCount=%1;%nRetiredIOThreads=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadPoolSuspendSuspendThreadEventMessage" value="ClrThreadID=%1;%nCPUUtilization=%2" />
                <string id="RuntimePublisher.ThreadPoolSuspendResumeThreadEventMessage" value="ClrThreadID=%1;%nCPUUtilization=%2" />
                <string id="RuntimePublisher.ThreadPoolWorkingThreadCountEventMessage" value="Count=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.ThreadPoolEnqueueEventMessage" value="WorkID=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.ThreadPoolDequeueEventMessage" value="WorkID=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.ThreadPoolIOEnqueueEventMessage" value="WorkID=%1;%nMultiDequeues=%4%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadPoolIOEnqueue_V1EventMessage" value="WorkID=%1;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadPoolIODequeueEventMessage" value="WorkID=%1;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadPoolIOPackEventMessage" value="WorkID=%1;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadCreatingEventMessage" value="ID=%1;%nClrInstanceID=%s" />
                <string id="RuntimePublisher.ThreadRunningEventMessage" value="ID=%1;%nClrInstanceID=%s" />
                <string id="RuntimePublisher.ExceptionExceptionThrownEventMessage" value="NONE" />
                <string id="RuntimePublisher.ExceptionExceptionThrown_V1EventMessage" value="ExceptionType=%1;%nExceptionMessage=%2;%nExceptionEIP=%3;%nExceptionHRESULT=%4;%nExceptionFlags=%5;%nClrInstanceID=%6" />
                <string id="RuntimePublisher.ExceptionExceptionHandlingEventMessage" value="EntryEIP=%1;%nMethodID=%2;%nMethodName=%3;%nClrInstanceID=%4" />
                <string id="RuntimePublisher.ExceptionExceptionHandlingNoneEventMessage" value="NONE" />
                <string id="RuntimePublisher.ContentionStartEventMessage" value="NONE" />
                <string id="RuntimePublisher.ContentionStart_V1EventMessage" value="ContentionFlags=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.ContentionStopEventMessage" value="ContentionFlags=%1;%nClrInstanceID=%2"/>
                <string id="RuntimePublisher.ContentionStop_V1EventMessage" value="ContentionFlags=%1;%nClrInstanceID=%2;DurationNs=%3"/>
                <string id="RuntimePublisher.DCStartCompleteEventMessage" value="NONE" />
                <string id="RuntimePublisher.DCEndCompleteEventMessage" value="NONE" />
                <string id="RuntimePublisher.MethodDCStartEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6" />
                <string id="RuntimePublisher.MethodDCEndEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6" />
                <string id="RuntimePublisher.MethodDCStartVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9" />
                <string id="RuntimePublisher.MethodDCEndVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9" />
                <string id="RuntimePublisher.MethodLoadEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6" />
                <string id="RuntimePublisher.MethodLoad_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7" />
                <string id="RuntimePublisher.MethodLoad_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8" />
                <string id="RuntimePublisher.R2RGetEntryPointEventMessage" value="MethodID=%1;%nMethodName=%2;%nEntryPoint=%3;%nClrInstanceID=%4" />
                <string id="RuntimePublisher.MethodLoadVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9" />
                <string id="RuntimePublisher.MethodLoadVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10" />
                <string id="RuntimePublisher.MethodLoadVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11" />
                <string id="RuntimePublisher.MethodUnloadEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6" />
                <string id="RuntimePublisher.MethodUnload_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7" />
                <string id="RuntimePublisher.MethodUnload_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8" />
                <string id="RuntimePublisher.MethodUnloadVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9" />
                <string id="RuntimePublisher.MethodUnloadVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10" />
                <string id="RuntimePublisher.MethodUnloadVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11" />
                <string id="RuntimePublisher.MethodJittingStartedEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodToken=%3;%nMethodILSize=%4;%nMethodNamespace=%5;%nMethodName=%6;%nMethodSignature=%7" />
                <string id="RuntimePublisher.MethodJittingStarted_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodToken=%3;%nMethodILSize=%4;%nMethodNamespace=%5;%nMethodName=%6;%nMethodSignature=%7;%nClrInstanceID=%8" />
                <string id="RuntimePublisher.MethodILToNativeMapEventMessage" value="MethodID=%1;%nReJITID=%2;%nMethodExtent=%3;%nCountOfMapEntries=%4;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.DomainModuleLoadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6" />
                <string id="RuntimePublisher.DomainModuleLoad_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7" />
                <string id="RuntimePublisher.DomainModuleUnloadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6" />
                <string id="RuntimePublisher.DomainModuleUnload_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;%nModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7" />
                <string id="RuntimePublisher.ModuleDCStartEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5" />
                <string id="RuntimePublisher.ModuleDCEndEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5" />
                <string id="RuntimePublisher.ModuleLoadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5" />
                <string id="RuntimePublisher.ModuleLoad_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6" />
                <string id="RuntimePublisher.ModuleLoad_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12" />
                <string id="RuntimePublisher.ModuleUnloadEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;%nModuleNativePath=%5" />
                <string id="RuntimePublisher.ModuleUnload_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6" />
                <string id="RuntimePublisher.ModuleUnload_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12" />
                <string id="RuntimePublisher.AssemblyLoadEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4" />
                <string id="RuntimePublisher.AssemblyLoad_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.AssemblyUnloadEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4" />
                <string id="RuntimePublisher.AssemblyUnload_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;%nFullyQualifiedAssemblyName=%4;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.AppDomainLoadEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3" />
                <string id="RuntimePublisher.AppDomainLoad_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.AppDomainUnloadEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3" />
                <string id="RuntimePublisher.AppDomainUnload_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5" />
                <string id="RuntimePublisher.StackEventMessage" value="ClrInstanceID=%1;%nReserved1=%2;%nReserved2=%3;%nFrameCount=%4;%nStack=%5" />
                <string id="RuntimePublisher.AppDomainMemAllocatedEventMessage" value="AppDomainID=%1;%nAllocated=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.AppDomainMemSurvivedEventMessage" value="AppDomainID=%1;%nSurvived=%2;%nProcessSurvived=%3;%nClrInstanceID=%4" />
                <string id="RuntimePublisher.ThreadCreatedEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nFlags=%3;%nManagedThreadIndex=%4;%nOSThreadID=%5;%nClrInstanceID=%6" />
                <string id="RuntimePublisher.ThreadTerminatedEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ThreadDomainEnterEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nClrInstanceID=%3" />
                <string id="RuntimePublisher.ILStubGeneratedEventMessage" value="ClrInstanceID=%1;%nModuleID=%2;%nStubMethodID=%3;%nStubFlags=%4;%nManagedInteropMethodToken=%5;%nManagedInteropMethodNamespace=%6;%nManagedInteropMethodName=%7;%nManagedInteropMethodSignature=%8;%nNativeMethodSignature=%9;%nStubMethodSignature=%10;%nStubMethodILCode=%11" />
                <string id="RuntimePublisher.ILStubCacheHitEventMessage" value="ClrInstanceID=%1;%nModuleID=%2;%nStubMethodID=%3;%nManagedInteropMethodToken=%4;%nManagedInteropMethodNamespace=%5;%nManagedInteropMethodName=%6;%nManagedInteropMethodSignature=%7" />
                <string id="RuntimePublisher.StrongNameVerificationStartEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3"/>
                <string id="RuntimePublisher.StrongNameVerificationStart_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.StrongNameVerificationEndEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3"/>
                <string id="RuntimePublisher.StrongNameVerificationEnd_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nFullyQualifiedAssemblyName=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.AuthenticodeVerificationStartEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3"/>
                <string id="RuntimePublisher.AuthenticodeVerificationStart_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.AuthenticodeVerificationEndEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3"/>
                <string id="RuntimePublisher.AuthenticodeVerificationEnd_V1EventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.EEStartupStartEventMessage" value="VerificationFlags=%1;%nErrorCode=%2;%nModulePath=%3;%nClrInstanceID=%4"/>
                <string id="RuntimePublisher.RuntimeInformationEventMessage" value="ClrInstanceID=%1;%nSKU=%2;%nBclMajorVersion=%3;%nBclMinorVersion=%4;%nBclBuildNumber=%5;%nBclQfeNumber=%6;%nVMMajorVersion=%7;%nVMMinorVersion=%8;%nVMBuildNumber=%9;%nVMQfeNumber=%10;%nStartupFlags=%11;%nStartupMode=%12;%nCommandLine=%13;%nComObjectGUID=%14;%nRuntimeDllPath=%15"/>
                <string id="RuntimePublisher.MethodJitInliningFailedEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nInlinerNamespace=%4;%nInlinerName=%5;%nInlinerNameSignature=%6;%nInlineeNamespace=%7;%nInlineeName=%8;%nInlineeNameSignature=%9;%nFailAlways=%10;%nFailReason=%11;%nClrInstanceID=%12" />
                <string id="RuntimePublisher.MethodJitInliningSucceededEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nInlinerNamespace=%4;%nInlinerName=%5;%nInlinerNameSignature=%6;%nInlineeNamespace=%7;%nInlineeName=%8;%nInlineeNameSignature=%9;%nClrInstanceID=%10" />
                <string id="RuntimePublisher.MethodJitTailCallFailedEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nCallerNamespace=%4;%nCallerName=%5;%nCallerNameSignature=%6;%nCalleeNamespace=%7;%nCalleeName=%8;%nCalleeNameSignature=%9;%nTailPrefix=%10;%nFailReason=%11;%nClrInstanceID=%12" />
                <string id="RuntimePublisher.MethodJitTailCallSucceededEventMessage" value="MethodBeingCompiledNamespace=%1;%nMethodBeingCompiledName=%2;%nMethodBeingCompiledNameSignature=%3;%nCallerNamespace=%4;%nCallerName=%5;%nCallerNameSignature=%6;%nCalleeNamespace=%7;%nCalleeName=%8;%nCalleeNameSignature=%9;%nTailPrefix=%10;%nTailCallType=%11;%nClrInstanceID=%12" />
                <string id="RuntimePublisher.SetGCHandleEventMessage" value="HandleID=%1;%nObjectID=%2;%nKind=%3;%nGeneration=%4;%nAppDomainID=%5;%nClrInstanceID=%6" />
                <string id="RuntimePublisher.DestroyGCHandleEventMessage" value="HandleID=%1;%nClrInstanceID=%2" />
                <string id="RuntimePublisher.CodeSymbolsEventMessage" value="%nClrInstanceId=%1;%nModuleId=%2;%nTotalChunks=%3;%nChunkNumber=%4;%nChunkLength=%5;%nChunk=%6" />
                <string id="RuntimePublisher.TieredCompilationSettingsEventMessage" value="ClrInstanceID=%1;%nFlags=%2" />
                <string id="RuntimePublisher.TieredCompilationPauseEventMessage" value="ClrInstanceID=%1" />
                <string id="RuntimePublisher.TieredCompilationResumeEventMessage" value="ClrInstanceID=%1;%nNewMethodCount=%2" />
                <string id="RuntimePublisher.TieredCompilationBackgroundJitStartEventMessage" value="ClrInstanceID=%1;%nPendingMethodCount=%2" />
                <string id="RuntimePublisher.TieredCompilationBackgroundJitStopEventMessage" value="ClrInstanceID=%1;%nPendingMethodCount=%2;%nJittedMethodCount=%3" />
              
                <string id="RundownPublisher.MethodDCStartEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6" />
                <string id="RundownPublisher.MethodDCStart_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7" />
                <string id="RundownPublisher.MethodDCStart_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8" />
                <string id="RuntimePublisher.ModuleRangeLoadEventMessage" value="ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5" />
                <string id="RundownPublisher.MethodDCEndEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6" />
                <string id="RundownPublisher.MethodDCEnd_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7" />
                <string id="RundownPublisher.MethodDCEnd_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nClrInstanceID=%7;%nReJITID=%8" />
                <string id="RundownPublisher.MethodDCStartVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9" />
                <string id="RundownPublisher.MethodDCStartVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10" />
                <string id="RundownPublisher.MethodDCStartVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11" />
                <string id="RundownPublisher.MethodDCEndVerboseEventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9" />
                <string id="RundownPublisher.MethodDCEndVerbose_V1EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10" />
                <string id="RundownPublisher.MethodDCEndVerbose_V2EventMessage" value="MethodID=%1;%nModuleID=%2;%nMethodStartAddress=%3;%nMethodSize=%4;%nMethodToken=%5;%nMethodFlags=%6;%nMethodNamespace=%7;%nMethodName=%8;%nMethodSignature=%9;%nClrInstanceID=%10;%nReJITID=%11" />
                <string id="RundownPublisher.MethodDCStartILToNativeMapEventMessage" value="MethodID=%1;%nReJITID=%2;%nMethodExtent=%3;%nCountOfMapEntries=%4;%nClrInstanceID=%5" />
                <string id="RundownPublisher.MethodDCEndILToNativeMapEventMessage" value="MethodID=%1;%nReJITID=%2;%nMethodExtent=%3;%nCountOfMapEntries=%4;%nClrInstanceID=%5" />
                <string id="RundownPublisher.DomainModuleDCStartEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6" />
                <string id="RundownPublisher.DomainModuleDCStart_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7" />
                <string id="RundownPublisher.DomainModuleDCEndEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6" />
                <string id="RundownPublisher.DomainModuleDCEnd_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nAppDomainID=%3;%nModuleFlags=%4;ModuleILPath=%5;ModuleNativePath=%6;%nClrInstanceID=%7" />
                <string id="RundownPublisher.ModuleDCStartEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5" />
                <string id="RundownPublisher.ModuleDCStart_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5;%nClrInstanceID=%6" />
                <string id="RundownPublisher.ModuleDCStart_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12" />
                <string id="RundownPublisher.ModuleDCEndEventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5" />
                <string id="RundownPublisher.ModuleDCEnd_V1EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;ModuleILPath=%4;ModuleNativePath=%5;%nClrInstanceID=%6" />
                <string id="RundownPublisher.ModuleDCEnd_V2EventMessage" value="ModuleID=%1;%nAssemblyID=%2;%nModuleFlags=%3;%nModuleILPath=%4;%nModuleNativePath=%5;%nClrInstanceID=%6;%nManagedPdbSignature=%7;%nManagedPdbAge=%8;%nManagedPdbBuildPath=%9;%nNativePdbSignature=%10;%nNativePdbAge=%11;%nNativePdbBuildPath=%12" />
                <string id="RundownPublisher.AssemblyDCStartEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4" />
                <string id="RundownPublisher.AssemblyDCStart_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4;%nClrInstanceID=%5" />
                <string id="RundownPublisher.AssemblyDCEndEventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4" />
                <string id="RundownPublisher.AssemblyDCEnd_V1EventMessage" value="AssemblyID=%1;%nAppDomainID=%2;%nAssemblyFlags=%3;FullyQualifiedAssemblyName=%4;%nClrInstanceID=%5" />
                <string id="RundownPublisher.AppDomainDCStartEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3" />
                <string id="RundownPublisher.AppDomainDCStart_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5" />
                <string id="RundownPublisher.AppDomainDCEndEventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3" />
                <string id="RundownPublisher.AppDomainDCEnd_V1EventMessage" value="AppDomainID=%1;%nAppDomainFlags=%2;%nAppDomainName=%3;%nAppDomainIndex=%4;%nClrInstanceID=%5" />
                <string id="RundownPublisher.DCStartCompleteEventMessage" value="ClrInstanceID=%1" />
                <string id="RundownPublisher.DCEndCompleteEventMessage" value="ClrInstanceID=%1" />
                <string id="RundownPublisher.DCStartInitEventMessage" value="ClrInstanceID=%1" />
                <string id="RundownPublisher.DCEndInitEventMessage" value="ClrInstanceID=%1" />
                <string id="RundownPublisher.ThreadCreatedEventMessage" value="ManagedThreadID=%1;%nAppDomainID=%2;%nFlags=%3;%nManagedThreadIndex=%4;%nOSThreadID=%5;%nClrInstanceID=%6" />
                <string id="RundownPublisher.RuntimeInformationEventMessage" value="ClrInstanceID=%1;%nSKU=%2;%nBclMajorVersion=%3;%nBclMinorVersion=%4;%nBclBuildNumber=%5;%nBclQfeNumber=%6;%nVMMajorVersion=%7;%nVMMinorVersion=%8;%nVMBuildNumber=%9;%nVMQfeNumber=%10;%nStartupFlags=%11;%nStartupMode=%12;%nCommandLine=%13;%nComObjectGUID=%14;%nRuntimeDllPath=%15"/>
                <string id="RundownPublisher.StackEventMessage" value="ClrInstanceID=%1;%nReserved1=%2;%nReserved2=%3;%nFrameCount=%4;%nStack=%5" />
                <string id="RundownPublisher.ModuleRangeDCStartEventMessage" value="ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5" />
                <string id="RundownPublisher.ModuleRangeDCEndEventMessage" value= "ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5" />
                <string id="RundownPublisher.TieredCompilationSettingsDCStartEventMessage" value="ClrInstanceID=%1;%nFlags=%2" />
              
                <string id="StressPublisher.StressLogEventMessage" value="Facility=%1;%nLevel=%2;%nMessage=%3" />
                <string id="StressPublisher.StressLog_V1EventMessage" value="Facility=%1;%nLevel=%2;%nMessage=%3;%nClrInstanceID=%4" />
                <string id="StressPublisher.StackEventMessage" value="ClrInstanceID=%1;%nReserved1=%2;%nReserved2=%3;%nFrameCount=%4;%nStack=%5" />
              
                <string id="PrivatePublisher.FailFastEventMessage" value="FailFastUserMessage=%1;%nFailedEIP=%2;%nOSExitCode=%3;%nClrExitCode=%4;%nClrInstanceID=%5" />
                <string id="PrivatePublisher.FinalizeObjectEventMessage" value="TypeName=%1;%nTypeID=%2;%nObjectID=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.SetGCHandleEventMessage" value="HandleID=%1;%nObjectID=%2;%n;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.DestroyGCHandleEventMessage" value="HandleID=%1;%nClrInstanceID=%2" />
                <string id="PrivatePublisher.PinPlugAtGCTimeEventMessage" value="PlugStart=%1;%nPlugEnd=%2;%n;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.CCWRefCountChangeEventMessage" value="HandleID=%1;%nObjectID=%2;%nCOMInterfacePointer=%3;%nNewRefCount=%4;%nTypeName=%5;%nOperation=%6;%nClrInstanceID=%7" />
                <string id="PrivatePublisher.GCDecisionEventMessage" value="DoCompact=%1" />
                <string id="PrivatePublisher.GCDecision_V1EventMessage" value="DoCompact=%1;%nClrInstanceID=%2" />
                <string id="PrivatePublisher.GCSettingsEventMessage" value="SegmentSize=%1;%nLargeObjectSegmentSize=%2;%nServerGC=%3"/>
                <string id="PrivatePublisher.GCSettings_V1EventMessage" value="SegmentSize=%1;%nLargeObjectSegmentSize=%2;%nServerGC=%3;%nClrInstanceID=%4"/>
                <string id="PrivatePublisher.GCOptimizedEventMessage" value="DesiredAllocation=%1;%nNewAllocation=%2;%nGenerationNumber=%3"/>
                <string id="PrivatePublisher.GCOptimized_V1EventMessage" value="DesiredAllocation=%1;%nNewAllocation=%2;%nGenerationNumber=%3;%nClrInstanceID=%4"/>
                <string id="PrivatePublisher.GCPerHeapHistoryEventMessage" value="NONE"/>
                <string id="PrivatePublisher.GCPerHeapHistory_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.GCGlobalHeapEventMessage" value="FinalYoungestDesired=%1;%nNumHeaps=%2;%nCondemnedGeneration=%3;%nGen0ReductionCount=%4;%nReason=%5;%nGlobalMechanisms=%6"/>
                <string id="PrivatePublisher.GCGlobalHeap_V1EventMessage" value="FinalYoungestDesired=%1;%nNumHeaps=%2;%nCondemnedGeneration=%3;%nGen0ReductionCount=%4;%nReason=%5;%nGlobalMechanisms=%6;%nClrInstanceID=%7"/>
                <string id="PrivatePublisher.GCJoinEventMessage" value="Heap=%1;%nJoinTime=%2;%nJoinType=%3"/>
                <string id="PrivatePublisher.GCJoin_V1EventMessage" value="Heap=%1;%nJoinTime=%2;%nJoinType=%3;%nClrInstanceID=%4"/>
                <string id="PrivatePublisher.GCMarkStackRootsEventMessage" value="HeapNum=%1"/>
                <string id="PrivatePublisher.GCMarkStackRoots_V1EventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="PrivatePublisher.GCMarkFinalizeQueueRootsEventMessage" value="HeapNum=%1"/>
                <string id="PrivatePublisher.GCMarkFinalizeQueueRoots_V1EventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="PrivatePublisher.GCMarkHandlesEventMessage" value="HeapNum=%1"/>
                <string id="PrivatePublisher.GCMarkHandles_V1EventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="PrivatePublisher.GCMarkCardsEventMessage" value="HeapNum=%1"/>
                <string id="PrivatePublisher.GCMarkCards_V1EventMessage" value="HeapNum=%1;%nClrInstanceID=%2"/>
                <string id="PrivatePublisher.BGCBeginEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGC1stNonConEndEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGC1stConEndEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGC2ndNonConBeginEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGC2ndNonConEndEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGC2ndConBeginEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGC1stSweepEndEventMessage" value="GenNumber=%1;ClrInstanceID=%2"/>
                <string id="PrivatePublisher.BGC2ndConEndEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGCPlanEndEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGCSweepEndEventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.BGCDrainMarkEventMessage" value="Objects=%1;%nClrInstanceID=%2"/>
                <string id="PrivatePublisher.BGCRevisitEventMessage" value="Pages=%1;%nObjects=%2;%nIsLarge=%3;%nClrInstanceID=%4"/>
                <string id="PrivatePublisher.BGCOverflowEventMessage" value="Min=%1;%nMax=%2;%Objects=%3;%nIsLarge=%4;%nClrInstanceID=%5"/>
                <string id="PrivatePublisher.BGCAllocWaitEventMessage" value="Reason=%1;%nClrInstanceID=%2"/>
                <string id="PrivatePublisher.GCFullNotifyEventMessage" value="GenNumber=%1;%nIsAlloc=%2"/>
                <string id="PrivatePublisher.GCFullNotify_V1EventMessage" value="GenNumber=%1;%nIsAlloc=%2;%nClrInstanceID=%3"/>
                <string id="PrivatePublisher.StartupEventMessage" value="NONE"/>
                <string id="PrivatePublisher.Startup_V1EventMessage" value="ClrInstanceID=%1"/>
                <string id="PrivatePublisher.StackEventMessage" value="ClrInstanceID=%1;%nReserved1=%2;%nReserved2=%3;%nFrameCount=%4;%nStack=%5" />
                <string id="PrivatePublisher.BindingEventMessage" value="%AppDomainID=%1;%nLoadContextID=%2;%nFromLoaderCache=%3;%nDynamicLoad=%4;%nAssemblyCodebase=%5;%nAssemblyName=%6;%nClrInstanceID=%6"/>
                <string id="PrivatePublisher.EvidenceGeneratedEventMessage" value="EvidenceType=%1;%nAppDomainID=%2;%nILImage=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.NgenBinderMessage" value="ClrInstanceID=%1;%nBindingID=%2;%nReason=%3;%nAssembly=%4" />
                <string id="PrivatePublisher.FusionMessageEventMessage" value="ClrInstanceID=%1;%nMessage=%2;" />
                <string id="PrivatePublisher.FusionErrorCodeEventMessage" value="ClrInstanceID=%1;%nCategory=%2%nErrorCode=%3" />
                <string id="PrivatePublisher.ModuleTransparencyComputationStartEventMessage" value="Module=%1;%nAppDomainID=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.ModuleTransparencyComputationEndEventMessage" value="Module=%1;%nAppDomainID=%2;%nIsAllCritical=%3;%nIsAllTransparent=%4;%nIsTreatAsSafe=%5;%nIsOpportunisticallyCritical=%6;%nSecurityRuleSet=%7;%nClrInstanceID=%8" />
                <string id="PrivatePublisher.TypeTransparencyComputationStartEventMessage" value="Type=%1;%nModule=%2;%nAppDomainID=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.TypeTransparencyComputationEndEventMessage" value="Type=%1;%nModule=%2;%nAppDomainID=%3;%nIsAllCritical=%4;%nIsAllTransparent=%5;%nIsCritical=%6;%nIsTreatAsSafe=%7;%nClrInstanceID=%8" />
                <string id="PrivatePublisher.MethodTransparencyComputationStartEventMessage" value="Method=%1;%nModule=%2;%nAppDomainID=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.MethodTransparencyComputationEndEventMessage" value="Method=%1;%nModule=%2;%nAppDomainID=%3;%nIsCritical=%4;%nIsTreatAsSafe=%5;%nClrInstanceID=%6" />
                <string id="PrivatePublisher.FieldTransparencyComputationStartEventMessage" value="Field=%1;%nModule=%2;%nAppDomainID=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.FieldTransparencyComputationEndEventMessage" value="Field=%1;%nModule=%2;%nAppDomainID=%3;%nIsCritical=%4;%nIsTreatAsSafe=%5;%nClrInstanceID=%6" />
                <string id="PrivatePublisher.TokenTransparencyComputationStartEventMessage" value="Token=%1;%nModule=%2;%nAppDomainID=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.TokenTransparencyComputationEndEventMessage" value="Token=%1;%nModule=%2;%nAppDomainID=%3;%nIsCritical=%4;%nIsTreatAsSafe=%5;%nClrInstanceID=%6" />

                <string id="PrivatePublisher.AllocRequestEventMessage" value="LoaderHeapPtr=%1;%nMemoryAddress=%2;%nRequestSize=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.ModuleRangeLoadEventMessage" value="ClrInstanceID=%1;%ModuleID=%2;%nRangeBegin=%3;%nRangeSize=%4;%nRangeType=%5;%nIBCType=%6;%nSectionType=%7" />
                <string id="PrivatePublisher.MulticoreJitCommonEventMessage" value="ClrInstanceID=%1;%String1=%2;%nString2=%3;%nInt1=%4;%nInt2=%5;%nInt3=%6" />
                <string id="PrivatePublisher.MulticoreJitMethodCodeReturnedMessage" value="ClrInstanceID=%1;%nModuleID=%2;%nMethodID=%3" />

                <string id="PrivatePublisher.IInspectableRuntimeClassNameMessage" value="TypeName=%1;%nClrInstanceID=%2" />
                <string id="PrivatePublisher.WinRTUnboxMessage" value="TypeName=%1;%nObject=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.CreateRcwMessage" value="TypeName=%1;%nClrInstanceID=%2" />
                <string id="PrivatePublisher.RcwVarianceMessage" value="RcwTypeName=%1;%nInterface=%2;%nVariantInterface=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.RCWIEnumerableCastingMessage" value="TypeName=%1;%nSecondType=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.CreateCCWMessage" value="TypeName=%1;%nClrInstanceID=%2" />
                <string id="PrivatePublisher.CCWVarianceMessage" value="RcwTypeName=%1;%nInterface=%2;%nVariantInterface=%3;%nClrInstanceID=%4" />
                <string id="PrivatePublisher.ObjectVariantMarshallingMessage" value="TypeName=%1;%nInt1=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.GetTypeFromGUIDMessage" value="TypeName=%1;%nSecondType=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.GetTypeFromProgIDMessage" value="TypeName=%1;%nSecondType=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.ConvertToCallbackMessage" value="TypeName=%1;%nSecondType=%2;%nClrInstanceID=%3" />
                <string id="PrivatePublisher.BeginCreateManagedReferenceMessage" value="ClrInstanceID=%1" />
                <string id="PrivatePublisher.EndCreateManagedReferenceMessage" value="ClrInstanceID=%1" />

                <!-- Task Messages -->
                <string id="RuntimePublisher.GarbageCollectionTaskMessage" value="GC" />
                <string id="RuntimePublisher.WorkerThreadCreationTaskMessage" value="WorkerThreadCreationV2" />
                <string id="RuntimePublisher.WorkerThreadRetirementTaskMessage" value="WorkerThreadRetirementV2" />
                <string id="RuntimePublisher.IOThreadCreationTaskMessage" value="IOThreadCreation" />
                <string id="RuntimePublisher.IOThreadRetirementTaskMessage" value="IOThreadRetirement" />
                <string id="RuntimePublisher.ThreadpoolSuspensionTaskMessage" value="ThreadpoolSuspensionV2" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadTaskMessage" value="ThreadPoolWorkerThread" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadRetirementTaskMessage" value="ThreadPoolWorkerThreadRetirement" />
                <string id="RuntimePublisher.ThreadPoolWorkerThreadAdjustmentTaskMessage" value="ThreadPoolWorkerThreadAdjustment" />
                <string id="RuntimePublisher.ExceptionTaskMessage" value="Exception" />
                <string id="RuntimePublisher.ExceptionCatchTaskMessage" value="ExceptionCatch" />
                <string id="RuntimePublisher.ExceptionFinallyTaskMessage" value="ExceptionFinally" />
                <string id="RuntimePublisher.ExceptionFilterTaskMessage" value="ExceptionFilter" />
                <string id="RuntimePublisher.ContentionTaskMessage" value="Contention" />
                <string id="RuntimePublisher.MethodTaskMessage" value="Method" />
                <string id="RuntimePublisher.LoaderTaskMessage" value="Loader" />
                <string id="RuntimePublisher.StackTaskMessage" value="ClrStack" />
                <string id="RuntimePublisher.StrongNameVerificationTaskMessage" value="StrongNameVerification" />
                <string id="RuntimePublisher.AuthenticodeVerificationTaskMessage" value="AuthenticodeVerification" />
                <string id="RuntimePublisher.AppDomainResourceManagementTaskMessage" value="AppDomainResourceManagement" />
                <string id="RuntimePublisher.ILStubTaskMessage" value="ILStub" />
                <string id="RuntimePublisher.EEStartupTaskMessage" value="Runtime" />
                <string id="RuntimePublisher.PerfTrackTaskMessage" value="ClrPerfTrack" />
                <string id="RuntimePublisher.TypeTaskMessage" value="Type" />
                <string id="RuntimePublisher.ThreadPoolWorkingThreadCountTaskMessage" value="ThreadPoolWorkingThreadCount" />
                <string id="RuntimePublisher.ThreadPoolTaskMessage" value="ThreadPool" />
                <string id="RuntimePublisher.ThreadTaskMessage" value="Thread" />
                <string id="RuntimePublisher.DebugIPCEventTaskMessage" value="DebugIPCEvent" />
                <string id="RuntimePublisher.DebugExceptionProcessingTaskMessage" value="DebugExceptionProcessing" />
                <string id="RuntimePublisher.CodeSymbolsTaskMessage" value="CodeSymbols" />
                <string id="RuntimePublisher.TieredCompilationTaskMessage" value="TieredCompilation" />
              
                <string id="RundownPublisher.EEStartupTaskMessage" value="Runtime" />
                <string id="RundownPublisher.MethodTaskMessage" value="Method" />
                <string id="RundownPublisher.LoaderTaskMessage" value="Loader" />
                <string id="RundownPublisher.StackTaskMessage" value="ClrStack" />
                <string id="RundownPublisher.PerfTrackTaskMessage" value="ClrPerfTrack" />
                <string id="RundownPublisher.TieredCompilationTaskMessage" value="TieredCompilation" />
              
                <string id="PrivatePublisher.GarbageCollectionTaskMessage" value="GC" />
                <string id="PrivatePublisher.StartupTaskMessage" value="Startup"/>
                <string id="PrivatePublisher.StackTaskMessage" value="ClrStack" />
                <string id="PrivatePublisher.BindingTaskMessage" value="Binding"/>
                <string id="PrivatePublisher.EvidenceGeneratedTaskMessage" value="EvidenceGeneration"/>
                <string id="PrivatePublisher.TransparencyComputationMessage" value="Transparency"/>
                <string id="PrivatePublisher.NgenBinderTaskMessage" value="NgenBinder" />
                <string id="PrivatePublisher.FailFastTaskMessage" value="FailFast" />

                <string id="PrivatePublisher.LoaderHeapAllocationPrivateTaskMessage" value="LoaderHeap" />
                <string id="PrivatePublisher.PerfTrackTaskMessage" value="ClrPerfTrack" />
                <string id="PrivatePublisher.MulticoreJitTaskMessage" value="ClrMulticoreJit" />
                <string id="PrivatePublisher.DynamicTypeUsageTaskMessage" value="ClrDynamicTypeUsage" />

                <string id="StressPublisher.StressTaskMessage" value="StressLog" />
                <string id="StressPublisher.StackTaskMessage" value="ClrStack" />

                <!-- Map Messages -->
                <string id="RuntimePublisher.AppDomain.DefaultMapMessage" value="Default" />
                <string id="RuntimePublisher.AppDomain.ExecutableMapMessage" value="Executable" />
                <string id="RuntimePublisher.AppDomain.SharedMapMessage" value="Shared" />
                <string id="RuntimePublisher.Assembly.DomainNeutralMapMessage" value="DomainNeutral" />
                <string id="RuntimePublisher.Assembly.DynamicMapMessage" value="Dynamic" />
                <string id="RuntimePublisher.Assembly.NativeMapMessage" value="Native" />
                <string id="RuntimePublisher.Assembly.CollectibleMapMessage" value="Collectible" />
                <string id="RuntimePublisher.Module.DomainNeutralMapMessage" value="DomainNeutral" />
                <string id="RuntimePublisher.Module.NativeMapMessage" value="Native" />
                <string id="RuntimePublisher.Module.DynamicMapMessage" value="Dynamic" />
                <string id="RuntimePublisher.Module.ManifestMapMessage" value="Manifest" />
                <string id="RuntimePublisher.Module.IbcOptimizedMapMessage" value="IbcOptimized" />
                <string id="RuntimePublisher.Module.ReadyToRunModuleMapMessage" value="ReadyToRunModule" />
                <string id="RuntimePublisher.Module.PartialReadyToRunModuleMapMessage" value="PartialReadyToRunModule" />
                <string id="RuntimePublisher.Method.DynamicMapMessage" value="Dynamic" />
                <string id="RuntimePublisher.Method.GenericMapMessage" value="Generic" />
                <string id="RuntimePublisher.Method.HasSharedGenericCodeMapMessage" value="HasSharedGenericCode" />
                <string id="RuntimePublisher.Method.JittedMapMessage" value="Jitted" />
                <string id="RuntimePublisher.Method.JitHelperMapMessage" value="JitHelper" />
                <string id="RuntimePublisher.Method.ProfilerRejectedPrecompiledCodeMapMessage" value="ProfilerRejectedPrecompiledCode" />
                <string id="RuntimePublisher.Method.ReadyToRunRejectedPrecompiledCodeMapMessage" value="ReadyToRunRejectedPrecompiledCode" />
                <string id="RuntimePublisher.GCSegment.SmallObjectHeapMapMessage" value="SmallObjectHeap" />
                <string id="RuntimePublisher.GCSegment.LargeObjectHeapMapMessage" value="LargeObjectHeap" />
                <string id="RuntimePublisher.GCSegment.ReadOnlyHeapMapMessage" value="ReadOnlyHeap" />
                <string id="RuntimePublisher.GCAllocation.SmallMapMessage" value="Small" />
                <string id="RuntimePublisher.GCAllocation.LargeMapMessage" value="Large" />
                <string id="RuntimePublisher.GCType.NonConcurrentGCMapMessage" value="NonConcurrentGC" />
                <string id="RuntimePublisher.GCType.BackgroundGCMapMessage" value="BackgroundGC" />
                <string id="RuntimePublisher.GCType.ForegroundGCMapMessage" value="ForegroundGC" />
                <string id="RuntimePublisher.GCReason.AllocSmallMapMessage" value="AllocSmall" />
                <string id="RuntimePublisher.GCReason.InducedMapMessage" value="Induced" />
                <string id="RuntimePublisher.GCReason.LowMemoryMapMessage" value="LowMemory" />
                <string id="RuntimePublisher.GCReason.EmptyMapMessage" value="Empty" />
                <string id="RuntimePublisher.GCReason.AllocLargeMapMessage" value="AllocLarge" />
                <string id="RuntimePublisher.GCReason.OutOfSpaceSmallObjectHeapMapMessage" value="OutOfSpaceSmallObjectHeap" />
                <string id="RuntimePublisher.GCReason.OutOfSpaceLargeObjectHeapMapMessage" value="OutOfSpaceLargeObjectHeap" />
                <string id="RuntimePublisher.GCReason.InducedNoForceMapMessage" value="InducedNoForce" />
                <string id="RuntimePublisher.GCReason.StressMapMessage" value="Stress" />
                <string id="RuntimePublisher.GCReason.InducedLowMemoryMapMessage" value="InducedLowMemory" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendOtherMapMessage" value="SuspendOther" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForGCMapMessage" value="SuspendForGC" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForAppDomainShutdownMapMessage" value="SuspendForAppDomainShutdown" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForCodePitchingMapMessage" value="SuspendForCodePitching" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForShutdownMapMessage" value="SuspendForShutdown" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerMapMessage" value="SuspendForDebugger" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForGCPrepMapMessage" value="SuspendForGCPrep" />
                <string id="RuntimePublisher.GCSuspendEEReason.SuspendForDebuggerSweepMapMessage" value="SuspendForDebuggerSweep" />
                <string id="RuntimePublisher.StartupMode.ManagedExeMapMessage" value="ManagedExe" />
                <string id="RuntimePublisher.StartupMode.HostedCLRMapMessage" value="HostedClr" />
                <string id="RuntimePublisher.StartupMode.IjwDllMapMessage" value="IjwDll" />
                <string id="RuntimePublisher.StartupMode.ComActivatedMapMessage" value="ComActivated" />
                <string id="RuntimePublisher.StartupMode.OtherMapMessage" value="Other" />
                <string id="RuntimePublisher.RuntimeSku.DesktopCLRMapMessage" value="DesktopClr" />
                <string id="RuntimePublisher.RuntimeSku.CoreCLRMapMessage" value="CoreClr" />
                <string id="RuntimePublisher.ExceptionThrown.HasInnerExceptionMapMessage" value="HasInnerException" />
                <string id="RuntimePublisher.ExceptionThrown.NestedMapMessage" value="Nested" />
                <string id="RuntimePublisher.ExceptionThrown.ReThrownMapMessage" value="ReThrown" />
                <string id="RuntimePublisher.ExceptionThrown.CorruptedStateMapMessage" value="CorruptedState" />
                <string id="RuntimePublisher.ExceptionThrown.CLSCompliantMapMessage" value="CLSCompliant" />
                <string id="RuntimePublisher.ILStubGenerated.ReverseInteropMapMessage" value="ReverseInterop" />
                <string id="RuntimePublisher.ILStubGenerated.COMInteropMapMessage" value="ComInterop" />
                <string id="RuntimePublisher.ILStubGenerated.NGenedStubMapMessage" value="NGenedStub" />
                <string id="RuntimePublisher.ILStubGenerated.DelegateMapMessage" value="Delegate" />
                <string id="RuntimePublisher.ILStubGenerated.VarArgMapMessage" value="VarArg" />
                <string id="RuntimePublisher.ILStubGenerated.UnmanagedCalleeMapMessage" value="UnmanagedCallee" />
                <string id="RuntimePublisher.Contention.ManagedMapMessage" value="Managed" />
                <string id="RuntimePublisher.Contention.NativeMapMessage" value="Native" />
                <string id="RuntimePublisher.TailCallType.OptimizedMapMessage" value="OptimizedTailCall" />
                <string id="RuntimePublisher.TailCallType.RecursiveMapMessage" value="RecursiveLoop" />
                <string id="RuntimePublisher.TailCallType.HelperMapMessage" value="HelperAssistedTailCall" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.WarmupMapMessage" value="Warmup" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.InitializingMapMessage" value="Initializing" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.RandomMoveMapMessage" value="RandomMove" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.ClimbingMoveMapMessage" value="ClimbingMove" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.ChangePointMapMessage" value="ChangePoint" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.StabilizingMapMessage" value="Stabilizing" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.StarvationMapMessage" value="Starvation" />
                <string id="RuntimePublisher.ThreadAdjustmentReason.ThreadTimedOutMapMessage" value="ThreadTimedOut" />
                <string id="RuntimePublisher.GCRootKind.Stack" value="Stack" />
                <string id="RuntimePublisher.GCRootKind.Finalizer" value="Finalizer" />
                <string id="RuntimePublisher.GCRootKind.Handle" value="Handle" />
                <string id="RuntimePublisher.GCRootKind.Older" value="Older" />
                <string id="RuntimePublisher.GCRootKind.SizedRef" value="SizedRef" />
                <string id="RuntimePublisher.GCRootKind.Overflow" value="Overflow" />
                <string id="RuntimePublisher.Startup.CONCURRENT_GCMapMessage" value="CONCURRENT_GC" />
                <string id="RuntimePublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage" value="LOADER_OPTIMIZATION_SINGLE_DOMAIN" />
                <string id="RuntimePublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage" value="LOADER_OPTIMIZATION_MULTI_DOMAIN" />
                <string id="RuntimePublisher.Startup.LOADER_SAFEMODEMapMessage" value="LOADER_SAFEMODE" />
                <string id="RuntimePublisher.Startup.LOADER_SETPREFERENCEMapMessage" value="LOADER_SETPREFERENCE" />
                <string id="RuntimePublisher.Startup.SERVER_GCMapMessage" value="SERVER_GC" />
                <string id="RuntimePublisher.Startup.HOARD_GC_VMMapMessage" value="HOARD_GC_VM" />
                <string id="RuntimePublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage" value="SINGLE_VERSION_HOSTING_INTERFACE" />
                <string id="RuntimePublisher.Startup.LEGACY_IMPERSONATIONMapMessage" value="LEGACY_IMPERSONATION" />
                <string id="RuntimePublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage" value="DISABLE_COMMITTHREADSTACK" />
                <string id="RuntimePublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage" value="ALWAYSFLOW_IMPERSONATION" />
                <string id="RuntimePublisher.Startup.TRIM_GC_COMMITMapMessage" value="TRIM_GC_COMMIT" />
                <string id="RuntimePublisher.Startup.ETWMapMessage" value="ETW" />
                <string id="RuntimePublisher.Startup.SERVER_BUILDMapMessage" value="SERVER_BUILD" />
                <string id="RuntimePublisher.Startup.ARMMapMessage" value="ARM" />
                <string id="RuntimePublisher.ModuleRangeTypeMap.ColdRangeMessage" value="ColdRange"/>
                <string id="RuntimePublisher.TypeFlags.Delegate" value="Delegate"/>
                <string id="RuntimePublisher.TypeFlags.Finalizable" value="Finalizable"/>
                <string id="RuntimePublisher.TypeFlags.ExternallyImplementedCOMObject" value="ExternallyImplementedCOMObject"/>
                <string id="RuntimePublisher.TypeFlags.Array" value="Array"/>
                <string id="RuntimePublisher.GCRootFlags.Pinning" value="Pinning"/>
                <string id="RuntimePublisher.GCRootFlags.WeakRef" value="WeakRef"/>
                <string id="RuntimePublisher.GCRootFlags.Interior" value="Interior"/>
                <string id="RuntimePublisher.GCRootFlags.RefCounted" value="RefCounted"/>
                <string id="RuntimePublisher.GCRootStaticVarFlags.ThreadLocal" value="ThreadLocal"/>
                <string id="RuntimePublisher.GCRootCCWFlags.Strong" value="Strong"/>
                <string id="RuntimePublisher.GCRootCCWFlags.Pegged" value="Pegged"/>
                <string id="RundownPublisher.AppDomain.DefaultMapMessage" value="Default" />
                <string id="RuntimePublisher.ThreadFlags.GCSpecial" value="GCSpecial"/>
                <string id="RuntimePublisher.ThreadFlags.Finalizer" value="Finalizer"/>
                <string id="RuntimePublisher.ThreadFlags.ThreadPoolWorker" value="ThreadPoolWorker"/>
                <string id="RuntimePublisher.GCHandleKind.WeakShortMessage" value="WeakShort" />
                <string id="RuntimePublisher.GCHandleKind.WeakLongMessage" value="WeakLong" />
                <string id="RuntimePublisher.GCHandleKind.StrongMessage" value="Strong" />
                <string id="RuntimePublisher.GCHandleKind.PinnedMessage" value="Pinned" />
                <string id="RuntimePublisher.GCHandleKind.VariableMessage" value="Variable" />
                <string id="RuntimePublisher.GCHandleKind.RefCountedMessage" value="RefCounted" />
                <string id="RuntimePublisher.GCHandleKind.DependentMessage" value="Dependent" />
                <string id="RuntimePublisher.GCHandleKind.AsyncPinnedMessage" value="AsyncPinned" />
                <string id="RuntimePublisher.GCHandleKind.SizedRefMessage" value="SizedRef" />
                <string id="RuntimePublisher.TieredCompilationSettingsFlags.NoneMapMessage" value="None" />
                <string id="RuntimePublisher.TieredCompilationSettingsFlags.QuickJitMapMessage" value="QuickJit" />
                <string id="RuntimePublisher.TieredCompilationSettingsFlags.QuickJitForLoopsMapMessage" value="QuickJitForLoops" />
              
                <string id="RundownPublisher.AppDomain.ExecutableMapMessage" value="Executable" />
                <string id="RundownPublisher.AppDomain.SharedMapMessage" value="Shared" />
                <string id="RundownPublisher.Assembly.DomainNeutralMapMessage" value="DomainNeutral" />
                <string id="RundownPublisher.Assembly.DynamicMapMessage" value="Dynamic" />
                <string id="RundownPublisher.Assembly.NativeMapMessage" value="Native" />
                <string id="RundownPublisher.Assembly.CollectibleMapMessage" value="Collectible" />
                <string id="RundownPublisher.Module.DomainNeutralMapMessage" value="DomainNeutral" />
                <string id="RundownPublisher.Module.NativeMapMessage" value="Native" />
                <string id="RundownPublisher.Module.DynamicMapMessage" value="Dynamic" />
                <string id="RundownPublisher.Module.ManifestMapMessage" value="Manifest" />
                <string id="RundownPublisher.Module.IbcOptimizedMapMessage" value="IbcOptimized" />
                <string id="RundownPublisher.Module.ReadyToRunModuleMapMessage" value="ReadyToRunModule" />
                <string id="RundownPublisher.Module.PartialReadyToRunModuleMapMessage" value="PartialReadyToRunModule" />
                <string id="RundownPublisher.Method.DynamicMapMessage" value="Dynamic" />
                <string id="RundownPublisher.Method.GenericMapMessage" value="Generic" />
                <string id="RundownPublisher.Method.HasSharedGenericCodeMapMessage" value="HasSharedGenericCode" />
                <string id="RundownPublisher.Method.JittedMapMessage" value="Jitted" />
                <string id="RundownPublisher.Method.JitHelperMapMessage" value="JitHelper" />
                <string id="RundownPublisher.Method.ProfilerRejectedPrecompiledCodeMapMessage" value="ProfilerRejectedPrecompiledCode" />
                <string id="RundownPublisher.Method.ReadyToRunRejectedPrecompiledCodeMapMessage" value="ReadyToRunRejectedPrecompiledCode" />
                <string id="RundownPublisher.StartupMode.ManagedExeMapMessage" value="ManagedExe" />
                <string id="RundownPublisher.StartupMode.HostedCLRMapMessage" value="HostedClr" />
                <string id="RundownPublisher.StartupMode.IjwDllMapMessage" value="IjwDll" />
                <string id="RundownPublisher.StartupMode.ComActivatedMapMessage" value="ComActivated" />
                <string id="RundownPublisher.StartupMode.OtherMapMessage" value="Other" />
                <string id="RundownPublisher.RuntimeSku.DesktopCLRMapMessage" value="DesktopClr" />
                <string id="RundownPublisher.RuntimeSku.CoreCLRMapMessage" value="CoreClr" />
                <string id="RundownPublisher.Startup.CONCURRENT_GCMapMessage" value="CONCURRENT_GC" />
                <string id="RundownPublisher.Startup.LOADER_OPTIMIZATION_SINGLE_DOMAINMapMessage" value="LOADER_OPTIMIZATION_SINGLE_DOMAIN" />
                <string id="RundownPublisher.Startup.LOADER_OPTIMIZATION_MULTI_DOMAINMapMessage" value="LOADER_OPTIMIZATION_MULTI_DOMAIN" />
                <string id="RundownPublisher.Startup.LOADER_SAFEMODEMapMessage" value="LOADER_SAFEMODE" />
                <string id="RundownPublisher.Startup.LOADER_SETPREFERENCEMapMessage" value="LOADER_SETPREFERENCE" />
                <string id="RundownPublisher.Startup.SERVER_GCMapMessage" value="SERVER_GC" />
                <string id="RundownPublisher.Startup.HOARD_GC_VMMapMessage" value="HOARD_GC_VM" />
                <string id="RundownPublisher.Startup.SINGLE_VERSION_HOSTING_INTERFACEMapMessage" value="SINGLE_VERSION_HOSTING_INTERFACE" />
                <string id="RundownPublisher.Startup.LEGACY_IMPERSONATIONMapMessage" value="LEGACY_IMPERSONATION" />
                <string id="RundownPublisher.Startup.DISABLE_COMMITTHREADSTACKMapMessage" value="DISABLE_COMMITTHREADSTACK" />
                <string id="RundownPublisher.Startup.ALWAYSFLOW_IMPERSONATIONMapMessage" value="ALWAYSFLOW_IMPERSONATION" />
                <string id="RundownPublisher.Startup.TRIM_GC_COMMITMapMessage" value="TRIM_GC_COMMIT" />
                <string id="RundownPublisher.Startup.ETWMapMessage" value="ETW" />
                <string id="RundownPublisher.Startup.SERVER_BUILDMapMessage" value="SERVER_BUILD" />
                <string id="RundownPublisher.Startup.ARMMapMessage" value="ARM" />
                <string id="RundownPublisher.ModuleRangeTypeMap.ColdRangeMessage" value="ColdRange"/>
                <string id="RundownPublisher.ThreadFlags.GCSpecial" value="GCSpecial"/>
                <string id="RundownPublisher.ThreadFlags.Finalizer" value="Finalizer"/>
                <string id="RundownPublisher.ThreadFlags.ThreadPoolWorker" value="ThreadPoolWorker"/>
                <string id="RundownPublisher.TieredCompilationSettingsFlags.NoneMapMessage" value="None" />
                <string id="RundownPublisher.TieredCompilationSettingsFlags.QuickJitMapMessage" value="QuickJit" />
                <string id="RundownPublisher.TieredCompilationSettingsFlags.QuickJitForLoopsMapMessage" value="QuickJitForLoops" />
              
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ModuleSection" value="ModuleSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.EETableSection" value="EETableSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.WriteDataSection" value="WriteDataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.WriteableDataSection" value="WriteableDataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.DataSection" value="DataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.RVAStaticsSection" value="RVAStaticsSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.EEDataSection" value="EEDataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoTableEagerSection" value="DelayLoadInfoTableEagerSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoTableSection" value="DelayLoadInfoTableSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.EEReadonlyData" value="EEReadonlyData"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ReadonlyData" value="ReadonlyData"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ClassSection" value="ClassSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.CrossDomainInfoSection" value="CrossDomainInfoSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.MethodDescSection" value="MethodDescSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.MethodDescWriteableSection" value="MethodDescWriteableSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ExceptionSection" value="ExceptionSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.InstrumentSection" value="InstrumentSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.VirtualImportThunkSection" value="VirtualImportThunkSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ExternalMethodThunkSection" value="ExternalMethodThunkSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.HelperTableSection" value="HelperTableSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.MethodPrecodeWriteableSection" value="MethodPrecodeWriteableSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.MethodPrecodeWriteSection" value="MethodPrecodeWriteSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.MethodPrecodeSection" value="MethodPrecodeSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.Win32ResourcesSection" value="Win32ResourcesSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.HeaderSection" value="HeaderSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.MetadataSection" value="MetadataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoSection" value="DelayLoadInfoSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ImportTableSection" value="ImportTableSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.CodeSection" value="CodeSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.CodeHeaderSection" value="CodeHeaderSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.CodeManagerSection" value="CodeManagerSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.UnwindDataSection" value="UnwindDataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.RuntimeFunctionSection" value="RuntimeFunctionSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.StubsSection" value="StubsSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.StubDispatchDataSection" value="StubDispatchDataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ExternalMethodDataSection" value="ExternalMethodDataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.DelayLoadInfoDelayListSection" value="DelayLoadInfoDelayListSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ReadonlySharedSection" value="ReadonlySharedSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ReadonlySection" value="ReadonlySection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ILSection" value="ILSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.GCInfoSection" value="GCInfoSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ILMetadataSection" value="ILMetadataSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.ResourcesSection" value="ResourcesSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.CompressedMapsSection" value="CompressedMapsSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.DebugSection" value="DebugSection"/>
                <string id="PrivatePublisher.ModuleRangeSectionTypeMap.BaseRelocsSection" value="BaseRelocsSection"/>
                <string id="PrivatePublisher.ModuleRangeIBCTypeMap.IBCUnprofiledSectionMessage" value="IBCUnprofiledSection"/>
                <string id="PrivatePublisher.ModuleRangeIBCTypeMap.IBCProfiledSectionMessage" value="IBCProfiledSection"/>
                <string id="PrivatePublisher.ModuleRangeTypeMap.HotRangeMessage" value="HotRange"/>
                <string id="PrivatePublisher.ModuleRangeTypeMap.WarmRangeMessage" value="WarmRange"/>
                <string id="PrivatePublisher.ModuleRangeTypeMap.ColdRangeMessage" value="ColdRange"/>
                <string id="PrivatePublisher.ModuleRangeTypeMap.HotColdRangeMessage" value="HotColdSortedRange"/>
                <string id="PrivatePublisher.GCHandleKind.WeakShortMessage" value="WeakShort" />
                <string id="PrivatePublisher.GCHandleKind.WeakLongMessage" value="WeakLong" />
                <string id="PrivatePublisher.GCHandleKind.StrongMessage" value="Strong" />
                <string id="PrivatePublisher.GCHandleKind.PinnedMessage" value="Pinned" />
                <string id="PrivatePublisher.GCHandleKind.VariableMessage" value="Variable" />
                <string id="PrivatePublisher.GCHandleKind.RefCountedMessage" value="RefCounted" />
                <string id="PrivatePublisher.GCHandleKind.DependentMessage" value="Dependent" />
                <string id="PrivatePublisher.GCHandleKind.AsyncPinnedMessage" value="AsyncPinned" />
                <string id="PrivatePublisher.GCHandleKind.SizedRefMessage" value="SizedRef" />

                <!-- Keyword Messages -->
                <string id="RuntimePublisher.GCKeywordMessage" value="GC" />
                <string id="RuntimePublisher.ThreadingKeywordMessage" value="Threading" />
                <string id="RuntimePublisher.FusionKeywordMessage" value="Binder" />
                <string id="RuntimePublisher.LoaderKeywordMessage" value="Loader" />
                <string id="RuntimePublisher.JitKeywordMessage" value="Jit" />
                <string id="RuntimePublisher.JittedMethodILToNativeMapKeywordMessage" value="JittedMethodILToNativeMap" />
                <string id="RuntimePublisher.NGenKeywordMessage" value="NGen" />
                <string id="RuntimePublisher.StartEnumerationKeywordMessage" value="StartEnumeration" />
                <string id="RuntimePublisher.EndEnumerationKeywordMessage" value="StopEnumeration" />
                <string id="RuntimePublisher.SecurityKeywordMessage" value="Security" />
                <string id="RuntimePublisher.AppDomainResourceManagementKeywordMessage" value="AppDomainResourceManagement" />
                <string id="RuntimePublisher.InteropKeywordMessage" value="Interop" />
                <string id="RuntimePublisher.ContentionKeywordMessage" value="Contention" />
                <string id="RuntimePublisher.ExceptionKeywordMessage" value="Exception" />
                <string id="RuntimePublisher.PerfTrackKeywordMessage" value="PerfTrack" />
                <string id="RuntimePublisher.StackKeywordMessage" value="Stack" />
                <string id="RuntimePublisher.JitTracingKeywordMessage" value="JitTracing" />
                <string id="RuntimePublisher.OverrideAndSuppressNGenEventsKeywordMessage" value="OverrideAndSuppressNGenEvents" />
                <string id="RuntimePublisher.TypeKeywordMessage" value="Type" />
                <string id="RuntimePublisher.GCHeapDumpKeywordMessage" value="GCHeapDump" />
                <string id="RuntimePublisher.GCSampledObjectAllocationHighKeywordMessage" value="GCSampledObjectAllocationHigh" />
                <string id="RuntimePublisher.GCSampledObjectAllocationLowKeywordMessage" value="GCSampledObjectAllocationLow" />
                <string id="RuntimePublisher.GCHeapSurvivalAndMovementKeywordMessage" value="GCHeapSurvivalAndMovement" />
                <string id="RuntimePublisher.GCHeapCollectKeyword" value="GCHeapCollect" />
                <string id="RuntimePublisher.GCHeapAndTypeNamesKeyword" value="GCHeapAndTypeNames" />
                <string id="RuntimePublisher.GCHandleKeywordMessage" value="GCHandle" />
                <string id="RuntimePublisher.ThreadTransferKeywordMessage" value="ThreadTransfer" />
                <string id="RuntimePublisher.DebuggerKeywordMessage" value="Debugger" />
                <string id="RuntimePublisher.MonitoringKeywordMessage" value="Monitoring" />
                <string id="RuntimePublisher.CodeSymbolsKeywordMessage" value="CodeSymbols" />
                <string id="RuntimePublisher.EventSourceKeywordMessage" value="EventSource" />
                <string id="RuntimePublisher.CompilationKeywordMessage" value="Compilation" />
                <string id="RuntimePublisher.CompilationDiagnosticKeywordMessage" value="CompilationDiagnostic" />
              
                <string id="RundownPublisher.LoaderKeywordMessage" value="Loader" />
                <string id="RundownPublisher.JitKeywordMessage" value="Jit" />
                <string id="RundownPublisher.JittedMethodILToNativeMapRundownKeywordMessage" value="JittedMethodILToNativeMapRundown" />
                <string id="RundownPublisher.NGenKeywordMessage" value="NGen" />
                <string id="RundownPublisher.StartRundownKeywordMessage" value="Start" />
                <string id="RundownPublisher.EndRundownKeywordMessage" value="End" />
                <string id="RuntimePublisher.AppDomainResourceManagementRundownKeywordMessage" value="AppDomainResourceManagement" />
                <string id="RundownPublisher.ThreadingKeywordMessage" value="Threading" />
                <string id="RundownPublisher.OverrideAndSuppressNGenEventsRundownKeywordMessage" value="OverrideAndSuppressNGenEvents" />
                <string id="RundownPublisher.PerfTrackRundownKeywordMessage" value="PerfTrack" />
                <string id="RundownPublisher.StackKeywordMessage" value="Stack" />
                <string id="RundownPublisher.CompilationKeywordMessage" value="Compilation" />
              
                <string id="PrivatePublisher.GCPrivateKeywordMessage" value="GC" />
                <string id="PrivatePublisher.StartupKeywordMessage" value="Startup" />
                <string id="PrivatePublisher.StackKeywordMessage" value="Stack" />
                <string id="PrivatePublisher.BindingKeywordMessage" value="Binding" />
                <string id="PrivatePublisher.NGenForceRestoreKeywordMessage" value="NGenForceRestore" />
                <string id="PrivatePublisher.SecurityPrivateKeywordMessage" value="Security" />
                <string id="PrivatePublisher.PrivateFusionKeywordMessage" value="Fusion" />
                <string id="PrivatePublisher.LoaderHeapPrivateKeywordMessage" value="LoaderHeap" />
                <string id="PrivatePublisher.PerfTrackKeywordMessage" value="PerfTrack" />
                <string id="PrivatePublisher.DynamicTypeUsageMessage" value="DynamicTypeUsage" />
                <string id="PrivatePublisher.MulticoreJitPrivateKeywordMessage" value="MulticoreJit" />
                <string id="PrivatePublisher.InteropPrivateKeywordMessage" value="Interop" />
                <string id="PrivatePublisher.GCHandlePrivateKeywordMessage" value="GCHandle" />

                <string id="StressPublisher.StackKeywordMessage" value="Stack" />

                <!-- Opcode messages -->
                <string id="RuntimePublisher.GCRestartEEEndOpcodeMessage" value="RestartEEStop" />
                <string id="RuntimePublisher.GCHeapStatsOpcodeMessage" value="HeapStats" />
                <string id="RuntimePublisher.GCCreateSegmentOpcodeMessage" value="CreateSegment" />
                <string id="RuntimePublisher.GCFreeSegmentOpcodeMessage" value="FreeSegment" />
                <string id="RuntimePublisher.GCRestartEEBeginOpcodeMessage" value="RestartEEStart" />
                <string id="RuntimePublisher.GCSuspendEEEndOpcodeMessage" value="SuspendEEStop" />
                <string id="RuntimePublisher.GCSuspendEEBeginOpcodeMessage" value="SuspendEEStart" />
                <string id="RuntimePublisher.GCAllocationTickOpcodeMessage" value="AllocationTick" />
                <string id="RuntimePublisher.GCCreateConcurrentThreadOpcodeMessage" value="CreateConcurrentThread" />
                <string id="RuntimePublisher.GCTerminateConcurrentThreadOpcodeMessage" value="TerminateConcurrentThread" />
                <string id="RuntimePublisher.GCFinalizersEndOpcodeMessage" value="FinalizersStop" />
                <string id="RuntimePublisher.GCFinalizersBeginOpcodeMessage" value="FinalizersStart" />
                <string id="RuntimePublisher.GCBulkRootEdgeOpcodeMessage" value="GCBulkRootEdge" />
                <string id="RuntimePublisher.GCBulkRootCCWOpcodeMessage" value="GCBulkRootCCW" />
                <string id="RuntimePublisher.GCBulkRCWOpcodeMessage" value="GCBulkRCW" />
                <string id="RuntimePublisher.GCBulkRootStaticVarOpcodeMessage" value="GCBulkRootStaticVar" />
                <string id="RuntimePublisher.GCDynamicEventOpcodeMessage" value="GCDynamicEvent" />
                <string id="RuntimePublisher.GCBulkRootConditionalWeakTableElementEdgeOpcodeMessage" value="GCBulkRootConditionalWeakTableElementEdge" />
                <string id="RuntimePublisher.GCBulkNodeOpcodeMessage" value="GCBulkNode" />
                <string id="RuntimePublisher.GCBulkEdgeOpcodeMessage" value="GCBulkEdge" />
                <string id="RuntimePublisher.GCSampledObjectAllocationOpcodeMessage" value="GCSampledObjectAllocation" />
                <string id="RuntimePublisher.GCBulkSurvivingObjectRangesOpcodeMessage" value="GCBulkSurvivingObjectRanges" />
                <string id="RuntimePublisher.GCBulkMovedObjectRangesOpcodeMessage" value="GCBulkMovedObjectRanges" />
                <string id="RuntimePublisher.GCGenerationRangeOpcodeMessage" value="GCGenerationRange" />
                <string id="RuntimePublisher.GCMarkStackRootsOpcodeMessage" value="MarkStackRoots" />
                <string id="RuntimePublisher.GCMarkHandlesOpcodeMessage" value="MarkHandles" />
                <string id="RuntimePublisher.GCMarkFinalizeQueueRootsOpcodeMessage" value="MarkFinalizeQueueRoots" />
                <string id="RuntimePublisher.GCMarkOlderGenerationRootsOpcodeMessage" value="MarkCards" />
                <string id="RuntimePublisher.GCMarkOpcodeMessage" value="Mark" />
                <string id="RuntimePublisher.GCJoinOpcodeMessage" value="GCJoin" />
                <string id="RuntimePublisher.GCPerHeapHistoryOpcodeMessage" value="PerHeapHistory" />
                <string id="RuntimePublisher.GCGlobalHeapHistoryOpcodeMessage" value="GlobalHeapHistory" />
                <string id="RuntimePublisher.FinalizeObjectOpcodeMessage" value="FinalizeObject" />
                <string id="RuntimePublisher.BulkTypeOpcodeMessage" value="BulkType" />
                <string id="RuntimePublisher.MethodLoadOpcodeMessage" value="Load" />
                <string id="RuntimePublisher.MethodUnloadOpcodeMessage" value="Unload" />
                <string id="RuntimePublisher.MethodLoadVerboseOpcodeMessage" value="LoadVerbose" />
                <string id="RuntimePublisher.MethodUnloadVerboseOpcodeMessage" value="UnloadVerbose" />
                <string id="RuntimePublisher.DCStartCompleteOpcodeMessage" value="DCStartCompleteV2" />
                <string id="RuntimePublisher.DCEndCompleteOpcodeMessage" value="DCEndCompleteV2" />
                <string id="RuntimePublisher.MethodDCStartOpcodeMessage" value="DCStartV2" />
                <string id="RuntimePublisher.MethodDCEndOpcodeMessage" value="DCStopV2" />
                <string id="RuntimePublisher.MethodDCStartVerboseOpcodeMessage" value="DCStartVerboseV2" />
                <string id="RuntimePublisher.MethodDCEndVerboseOpcodeMessage" value="DCStopVerboseV2" />
                <string id="RuntimePublisher.MethodJittingStartedOpcodeMessage" value="JittingStarted" />
                <string id="RuntimePublisher.JitInliningSucceededOpcodeMessage" value="InliningSucceeded" />
                <string id="RuntimePublisher.JitInliningFailedOpcodeMessage" value="InliningFailed" />
                <string id="RuntimePublisher.JitTailCallSucceededOpcodeMessage" value="TailCallSucceeded" />
                <string id="RuntimePublisher.JitTailCallFailedOpcodeMessage" value="TailCallFailed" />
                <string id="RuntimePublisher.MethodILToNativeMapOpcodeMessage" value="MethodILToNativeMap" />
                <string id="RuntimePublisher.DomainModuleLoadOpcodeMessage" value="DomainModuleLoad" />
                <string id="RuntimePublisher.ModuleLoadOpcodeMessage" value="ModuleLoad" />
                <string id="RuntimePublisher.ModuleUnloadOpcodeMessage" value="ModuleUnload" />
                <string id="RuntimePublisher.ModuleDCStartOpcodeMessage" value="ModuleDCStartV2" />
                <string id="RuntimePublisher.ModuleDCEndOpcodeMessage" value="ModuleDCStopV2" />
                <string id="RuntimePublisher.AssemblyLoadOpcodeMessage" value="AssemblyLoad" />
                <string id="RuntimePublisher.AssemblyUnloadOpcodeMessage" value="AssemblyUnload" />
                <string id="RuntimePublisher.AppDomainLoadOpcodeMessage" value="AppDomainLoad" />
                <string id="RuntimePublisher.AppDomainUnloadOpcodeMessage" value="AppDomainUnload" />
                <string id="RuntimePublisher.CLRStackWalkOpcodeMessage" value="Walk" />
                <string id="RuntimePublisher.AppDomainMemAllocatedOpcodeMessage" value="MemAllocated" />
                <string id="RuntimePublisher.AppDomainMemSurvivedOpcodeMessage" value="MemSurvived" />
                <string id="RuntimePublisher.ThreadCreatedOpcodeMessage" value="ThreadCreated" />
                <string id="RuntimePublisher.ThreadTerminatedOpcodeMessage" value="ThreadTerminated" />
                <string id="RuntimePublisher.ThreadDomainEnterOpcodeMessage" value="DomainEnter" />
                <string id="RuntimePublisher.ILStubGeneratedOpcodeMessage" value="StubGenerated" />
                <string id="RuntimePublisher.ILStubCacheHitOpcodeMessage" value="StubCacheHit" />
                <string id="RuntimePublisher.WaitOpcodeMessage" value="Wait" />
                <string id="RuntimePublisher.SampleOpcodeMessage" value="Sample" />
                <string id="RuntimePublisher.AdjustmentOpcodeMessage" value="Adjustment" />
                <string id="RuntimePublisher.StatsOpcodeMessage" value="Stats" />
                <string id="RuntimePublisher.ModuleRangeLoadOpcodeMessage" value="ModuleRangeLoad" />
                <string id="RuntimePublisher.SetGCHandleOpcodeMessage" value="SetGCHandle" />
                <string id="RuntimePublisher.DestroyGCHandleOpcodeMessage" value="DestoryGCHandle" />
                <string id="RuntimePublisher.TriggeredOpcodeMessage" value="Triggered" />
                <string id="RuntimePublisher.PinObjectAtGCTimeOpcodeMessage" value="PinObjectAtGCTime" />
                <string id="RuntimePublisher.IncreaseMemoryPressureOpcodeMessage" value="IncreaseMemoryPressure" />
                <string id="RuntimePublisher.DecreaseMemoryPressureOpcodeMessage" value="DecreaseMemoryPressure" />

                <string id="RuntimePublisher.EnqueueOpcodeMessage" value="Enqueue" />
                <string id="RuntimePublisher.DequeueOpcodeMessage" value="Dequeue" />
                <string id="RuntimePublisher.IOEnqueueOpcodeMessage" value="IOEnqueue" />
                <string id="RuntimePublisher.IODequeueOpcodeMessage" value="IODequeue" />
                <string id="RuntimePublisher.IOPackOpcodeMessage" value="IOPack" />

                <string id="RuntimePublisher.ThreadCreatingOpcodeMessage" value="Creating" />
                <string id="RuntimePublisher.ThreadRunningOpcodeMessage" value="Running" />

                <string id="RuntimePublisher.DebugIPCEventStartOpcodeMessage" value="IPCEventStart" />
                <string id="RuntimePublisher.DebugIPCEventEndOpcodeMessage" value="IPCEventEnd" />
                <string id="RuntimePublisher.DebugExceptionProcessingStartOpcodeMessage" value="ExceptionProcessingStart" />
                <string id="RuntimePublisher.DebugExceptionProcessingEndOpcodeMessage" value="ExceptionProcessingEnd" />
              
                <string id="RuntimePublisher.TieredCompilationSettingsOpcodeMessage" value="Settings" />
                <string id="RuntimePublisher.TieredCompilationPauseOpcodeMessage" value="Pause" />
                <string id="RuntimePublisher.TieredCompilationResumeOpcodeMessage" value="Resume" />

                <string id="RundownPublisher.MethodDCStartOpcodeMessage" value="DCStart" />
                <string id="RundownPublisher.MethodDCEndOpcodeMessage" value="DCStop" />
                <string id="RundownPublisher.MethodDCStartVerboseOpcodeMessage" value="DCStartVerbose" />
                <string id="RundownPublisher.MethodDCEndVerboseOpcodeMessage" value="DCStopVerbose" />
                <string id="RundownPublisher.MethodDCStartILToNativeMapOpcodeMessage" value="MethodDCStartILToNativeMap" />
                <string id="RundownPublisher.MethodDCEndILToNativeMapOpcodeMessage" value="MethodDCEndILToNativeMap" />
                <string id="RundownPublisher.DCStartCompleteOpcodeMessage" value="DCStartComplete" />
                <string id="RundownPublisher.DCEndCompleteOpcodeMessage" value="DCStopComplete" />
                <string id="RundownPublisher.DCStartInitOpcodeMessage" value="DCStartInit" />
                <string id="RundownPublisher.DCEndInitOpcodeMessage" value="DCStopInit" />
                <string id="RundownPublisher.ModuleDCStartOpcodeMessage" value="ModuleDCStart" />
                <string id="RundownPublisher.ModuleDCEndOpcodeMessage" value="ModuleDCStop" />
                <string id="RundownPublisher.AssemblyDCStartOpcodeMessage" value="AssemblyDCStart" />
                <string id="RundownPublisher.AssemblyDCEndOpcodeMessage" value="AssemblyDCStop" />
                <string id="RundownPublisher.AppDomainDCStartOpcodeMessage" value="AppDomainDCStart" />
                <string id="RundownPublisher.AppDomainDCEndOpcodeMessage" value="AppDomainDCStop" />
                <string id="RundownPublisher.DomainModuleDCStartOpcodeMessage" value="DomainModuleDCStart" />
                <string id="RundownPublisher.DomainModuleDCEndOpcodeMessage" value="DomainModuleDCStop" />
                <string id="RundownPublisher.ThreadDCOpcodeMessage" value="ThreadDCStop" />
                <string id="RundownPublisher.CLRStackWalkOpcodeMessage" value="Walk" />
                <string id="RundownPublisher.ModuleRangeDCStartOpcodeMessage" value="ModuleRangeDCStart" />
                <string id="RundownPublisher.ModuleRangeDCEndOpcodeMessage" value="ModuleRangeDCEnd" />
                <string id="RundownPublisher.TieredCompilationSettingsDCStartOpcodeMessage" value="SettingsDCStart" />
              
                <string id="PrivatePublisher.FailFastOpcodeMessage" value="FailFast" />

                <string id="PrivatePublisher.GCDecisionOpcodeMessage" value="Decision" />
                <string id="PrivatePublisher.GCSettingsOpcodeMessage" value="Settings" />
                <string id="PrivatePublisher.GCOptimizedOpcodeMessage" value="Optimized" />
                <string id="PrivatePublisher.GCPerHeapHistoryOpcodeMessage" value="PerHeapHistory" />
                <string id="PrivatePublisher.GCGlobalHeapHistoryOpcodeMessage" value="GlobalHeapHistory" />
                <string id="PrivatePublisher.GCFullNotifyOpcodeMessage" value="FullNotify" />
                <string id="PrivatePublisher.GCJoinOpcodeMessage" value="Join" />
                <string id="PrivatePublisher.GCMarkStackRootsOpcodeMessage" value="MarkStackRoots" />
                <string id="PrivatePublisher.GCMarkHandlesOpcodeMessage" value="MarkHandles" />
                <string id="PrivatePublisher.GCMarkFinalizeQueueRootsOpcodeMessage" value="MarkFinalizeQueueRoots" />
                <string id="PrivatePublisher.GCMarkCardsOpcodeMessage" value="MarkCards" />
                <string id="PrivatePublisher.BGCBeginOpcodeMessage" value="BGCStart" />
                <string id="PrivatePublisher.BGC1stNonCondEndOpcodeMessage" value="BGC1stNonCondStop" />
                <string id="PrivatePublisher.BGC2ndNonConBeginOpcodeMessage" value="BGC2ndNonConStart" />
                <string id="PrivatePublisher.BGC1stConEndOpcodeMessage" value="BGC1stConStop" />
                <string id="PrivatePublisher.BGC2ndNonConEndOpcodeMessage" value="BGC2ndNonConStop" />
                <string id="PrivatePublisher.BGC2ndConBeginOpcodeMessage" value="BGC2ndConStart" />
                <string id="PrivatePublisher.BGC1stSweepEndOpcodeMessage" value="BGC1stSweepEnd" />
                <string id="PrivatePublisher.BGC2ndConEndOpcodeMessage" value="BGC2ndConStop" />
                <string id="PrivatePublisher.BGCPlanEndOpcodeMessage" value="BGCPlanStop" />
                <string id="PrivatePublisher.BGCSweepEndOpcodeMessage" value="BGCSweepStop" />
                <string id="PrivatePublisher.BGCDrainMarkOpcodeMessage" value="BGCDrainMark" />
                <string id="PrivatePublisher.BGCRevisitOpcodeMessage" value="BGCRevisit" />
                <string id="PrivatePublisher.BGCOverflowOpcodeMessage" value="BGCOverflow" />
                <string id="PrivatePublisher.BGCAllocWaitBeginOpcodeMessage" value="BGCAllocWaitStart" />
                <string id="PrivatePublisher.BGCAllocWaitEndOpcodeMessage" value="BGCAllocWaitStop" />
                <string id="PrivatePublisher.FinalizeObjectOpcodeMessage" value="FinalizeObject" />
                <string id="PrivatePublisher.SetGCHandleOpcodeMessage" value="SetGCHandle" />
                <string id="PrivatePublisher.DestroyGCHandleOpcodeMessage" value="DestoryGCHandle" />
                <string id="PrivatePublisher.PinPlugAtGCTimeOpcodeMessage" value="PinPlugAtGCTime" />
                <string id="PrivatePublisher.CCWRefCountChangeOpcodeMessage" value="CCWRefCountChange" />
                <string id="PrivatePublisher.EEStartupStartOpcodeMessage" value="EEStartupStart" />
                <string id="PrivatePublisher.EEStartupEndOpcodeMessage" value="EEStartupStop" />
                <string id="PrivatePublisher.EEConfigSetupOpcodeMessage" value="EEConfigSetupStart" />
                <string id="PrivatePublisher.EEConfigSetupEndOpcodeMessage" value="EEConfigSetupStop" />
                <string id="PrivatePublisher.LoadSystemBasesOpcodeMessage" value="LoadSystemBasesStart" />
                <string id="PrivatePublisher.LoadSystemBasesEndOpcodeMessage" value="LoadSystemBasesStop" />
                <string id="PrivatePublisher.ExecExeOpcodeMessage" value="ExecExeStart" />
                <string id="PrivatePublisher.ExecExeEndOpcodeMessage" value="ExecExeStop" />
                <string id="PrivatePublisher.MainOpcodeMessage" value="MainStart" />
                <string id="PrivatePublisher.MainEndOpcodeMessage" value="MainStop" />
                <string id="PrivatePublisher.ApplyPolicyStartOpcodeMessage" value="ApplyPolicyStart" />
                <string id="PrivatePublisher.ApplyPolicyEndOpcodeMessage" value="ApplyPolicyStop" />
                <string id="PrivatePublisher.LdLibShFolderOpcodeMessage" value="LdLibShFolderStart" />
                <string id="PrivatePublisher.LdLibShFolderEndOpcodeMessage" value="LdLibShFolderStop" />
                <string id="PrivatePublisher.PrestubWorkerOpcodeMessage" value="PrestubWorkerStart" />
                <string id="PrivatePublisher.PrestubWorkerEndOpcodeMessage" value="PrestubWorkerStop" />
                <string id="PrivatePublisher.GetInstallationStartOpcodeMessage" value="GetInstallationStart" />
                <string id="PrivatePublisher.GetInstallationEndOpcodeMessage" value="GetInstallationStop" />
                <string id="PrivatePublisher.OpenHModuleOpcodeMessage" value="OpenHModuleStart" />
                <string id="PrivatePublisher.OpenHModuleEndOpcodeMessage" value="OpenHModuleStop" />
                <string id="PrivatePublisher.ExplicitBindStartOpcodeMessage" value="ExplicitBindStart" />
                <string id="PrivatePublisher.ExplicitBindEndOpcodeMessage" value="ExplicitBindStop" />
                <string id="PrivatePublisher.ParseXmlOpcodeMessage" value="ParseXmlStart" />
                <string id="PrivatePublisher.ParseXmlEndOpcodeMessage" value="ParseXmlStop" />
                <string id="PrivatePublisher.InitDefaultDomainOpcodeMessage" value="InitDefaultDomainStart" />
                <string id="PrivatePublisher.InitDefaultDomainEndOpcodeMessage" value="InitDefaultDomainStop" />
                <string id="PrivatePublisher.InitSecurityOpcodeMessage" value="InitSecurityStart" />
                <string id="PrivatePublisher.InitSecurityEndOpcodeMessage" value="InitSecurityStop" />
                <string id="PrivatePublisher.AllowBindingRedirsOpcodeMessage" value="AllowBindingRedirsStart" />
                <string id="PrivatePublisher.AllowBindingRedirsEndOpcodeMessage" value="AllowBindingRedirsStop" />
                <string id="PrivatePublisher.EEConfigSyncOpcodeMessage" value="EEConfigSyncStart" />
                <string id="PrivatePublisher.EEConfigSyncEndOpcodeMessage" value="EEConfigSyncStop" />
                <string id="PrivatePublisher.FusionBindingOpcodeMessage" value="BindingStart" />
                <string id="PrivatePublisher.FusionBindingEndOpcodeMessage" value="BindingStop" />
                <string id="PrivatePublisher.LoaderCatchCallOpcodeMessage" value="LoaderCatchCallStart" />
                <string id="PrivatePublisher.LoaderCatchCallEndOpcodeMessage" value="LoaderCatchCallStop" />
                <string id="PrivatePublisher.FusionInitOpcodeMessage" value="FusionInitStart" />
                <string id="PrivatePublisher.FusionInitEndOpcodeMessage" value="FusionInitStop" />
                <string id="PrivatePublisher.FusionAppCtxOpcodeMessage" value="FusionAppCtxStart" />
                <string id="PrivatePublisher.FusionAppCtxEndOpcodeMessage" value="FusionAppCtxStop" />
                <string id="PrivatePublisher.Fusion2EEOpcodeMessage" value="Fusion2EEStart" />
                <string id="PrivatePublisher.Fusion2EEEndOpcodeMessage" value="Fusion2EEStop" />
                <string id="PrivatePublisher.SecurityCatchCallOpcodeMessage" value="SecurityCatchCallStart" />
                <string id="PrivatePublisher.SecurityCatchCallEndOpcodeMessage" value="SecurityCatchCallStop" />
                <string id="PrivatePublisher.BindingPolicyPhaseStartOpcodeMessage" value="PolicyPhaseStart" />
                <string id="PrivatePublisher.BindingPolicyPhaseEndOpcodeMessage" value="PolicyPhaseStop" />
                <string id="PrivatePublisher.BindingNgenPhaseStartOpcodeMessage" value="NgenPhaseStart" />
                <string id="PrivatePublisher.BindingNgenPhaseEndOpcodeMessage" value="NgenPhaseStop" />
                <string id="PrivatePublisher.BindingLoopupAndProbingPhaseStartOpcodeMessage" value="LoopupAndProbingPhaseStart" />
                <string id="PrivatePublisher.BindingLookupAndProbingPhaseEndOpcodeMessage" value="LookupAndProbingPhaseStop" />
                <string id="PrivatePublisher.LoaderPhaseStartOpcodeMessage" value="LoaderPhaseStart" />
                <string id="PrivatePublisher.LoaderPhaseEndOpcodeMessage" value="LoaderPhaseStop" />
                <string id="PrivatePublisher.BindingPhaseStartOpcodeMessage" value="PhaseStart" />
                <string id="PrivatePublisher.BindingPhaseEndOpcodeMessage" value="PhaseStop" />
                <string id="PrivatePublisher.BindingDownloadPhaseStartOpcodeMessage" value="DownloadPhaseStart" />
                <string id="PrivatePublisher.BindingDownloadPhaseEndOpcodeMessage" value="DownloadPhaseStop" />
                <string id="PrivatePublisher.LoaderAssemblyInitPhaseStartOpcodeMessage" value="LoaderAssemblyInitPhaseStart" />
                <string id="PrivatePublisher.LoaderAssemblyInitPhaseEndOpcodeMessage" value="LoaderAssemblyInitPhaseStop" />
                <string id="PrivatePublisher.LoaderMappingPhaseStartOpcodeMessage" value="LoaderMappingPhaseStart" />
                <string id="PrivatePublisher.LoaderMappingPhaseEndOpcodeMessage" value="LoaderMappingPhaseStop" />
                <string id="PrivatePublisher.NgenBindOpcodeMessage" value="NgenBind" />
                <string id="PrivatePublisher.LoaderDeliverEventPhaseStartOpcodeMessage" value="LoaderDeliverEventPhaseStart" />
                <string id="PrivatePublisher.LoaderDeliverEventsPhaseEndOpcodeMessage" value="LoaderDeliverEventsPhaseStop" />
                <string id="PrivatePublisher.FusionMessageOpcodeMessage" value="FusionMessage" />
                <string id="PrivatePublisher.FusionErrorCodeOpcodeMessage" value="FusionErrorCode" />

                <string id="PrivatePublisher.IInspectableRuntimeClassNameOpcodeMessage" value="IInspectableRuntimeClassName" />
                <string id="PrivatePublisher.WinRTUnboxOpcodeMessage" value="WinRTUnbox" />
                <string id="PrivatePublisher.CreateRCWOpcodeMessage" value="CreateRCW" />
                <string id="PrivatePublisher.RCWVarianceOpcodeMessage" value="RCWVariance" />
                <string id="PrivatePublisher.RCWIEnumerableCastingOpcodeMessage" value="RCWIEnumerableCasting" />
                <string id="PrivatePublisher.CreateCCWOpcodeMessage" value="CreateCCW" />
                <string id="PrivatePublisher.CCWVarianceOpcodeMessage" value="CCWVariance" />
                <string id="PrivatePublisher.ObjectVariantMarshallingToNativeOpcodeMessage" value="ObjectVariantMarshallingToNative" />
                <string id="PrivatePublisher.GetTypeFromGUIDOpcodeMessage" value="GetTypeFromGUID" />
                <string id="PrivatePublisher.GetTypeFromProgIDOpcodeMessage" value="GetTypeFromProgID" />
                <string id="PrivatePublisher.ConvertToCallbackEtwOpcodeMessage" value="ConvertToCallbackEtw" />
                <string id="PrivatePublisher.BeginCreateManagedReferenceOpcodeMessage" value="BeginCreateManagedReference" />
                <string id="PrivatePublisher.EndCreateManagedReferenceOpcodeMessage" value="EndCreateManagedReference" />
                <string id="PrivatePublisher.ObjectVariantMarshallingToManagedOpcodeMessage" value="ObjectVariantMarshallingToManaged" />


                <string id="PrivatePublisher.CLRStackWalkOpcodeMessage" value="Walk" />
                <string id="PrivatePublisher.MulticoreJitOpcodeMessage" value="Common" />
                <string id="PrivatePublisher.MulticoreJitOpcodeMethodCodeReturnedMessage" value="MethodCodeReturned" />
                <string id="StressPublisher.CLRStackWalkOpcodeMessage" value="Walk" />

                <string id="PrivatePublisher.EvidenceGeneratedMessage" value="EvidenceGenerated" />
                <string id="PrivatePublisher.ModuleTransparencyComputationStartMessage" value="ModuleTransparencyComputationStart" />
                <string id="PrivatePublisher.ModuleTransparencyComputationEndMessage" value="ModuleTransparencyComputationStop" />
                <string id="PrivatePublisher.TypeTransparencyComputationStartMessage" value="TypeTransparencyComputationStart" />
                <string id="PrivatePublisher.TypeTransparencyComputationEndMessage" value="TypeTransparencyComputationStop" />
                <string id="PrivatePublisher.MethodTransparencyComputationStartMessage" value="MethodTransparencyComputationStart" />
                <string id="PrivatePublisher.MethodTransparencyComputationEndMessage" value="MethodTransparencyComputationStop" />
                <string id="PrivatePublisher.FieldTransparencyComputationStartMessage" value="FieldTransparencyComputationStart" />
                <string id="PrivatePublisher.FieldTransparencyComputationEndMessage" value="FieldTransparencyComputationStop" />
                <string id="PrivatePublisher.TokenTransparencyComputationStartMessage" value="TokenTransparencyComputationStart" />
                <string id="PrivatePublisher.TokenTransparencyComputationEndMessage" value="TokenTransparencyComputationStop" />

                <string id="PrivatePublisher.LoaderHeapPrivateAllocRequestMessage" value="LoaderHeapAllocRequest" />
                <string id="PrivatePublisher.ModuleRangeLoadOpcodeMessage" value="ModuleRangeLoad" />
            </stringTable>
        </resources>
    </localization>
</instrumentationManifest>
