﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;
using System.Collections.Immutable;
using System.Text;
using Roslyn.Test.Utilities;

namespace Microsoft.CodeAnalysis.UnitTests
{
    public abstract class AssemblyIdentityTestBase : TestBase
    {
        internal static readonly byte[] PublicKey1 = new byte[]
        {
            0x00, 0x24, 0x00, 0x00, 0x04, 0x80, 0x00, 0x00, 0x94,
            0x00, 0x00, 0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x24,
            0x00, 0x00, 0x52, 0x53, 0x41, 0x31, 0x00, 0x04, 0x00,
            0x00, 0x01, 0x00, 0x01, 0x00, 0xb5, 0xfc, 0x90, 0xe7,
            0x02, 0x7f, 0x67, 0x87, 0x1e, 0x77, 0x3a, 0x8f, 0xde,
            0x89, 0x38, 0xc8, 0x1d, 0xd4, 0x02, 0xba, 0x65, 0xb9,
            0x20, 0x1d, 0x60, 0x59, 0x3e, 0x96, 0xc4, 0x92, 0x65,
            0x1e, 0x88, 0x9c, 0xc1, 0x3f, 0x14, 0x15, 0xeb, 0xb5,
            0x3f, 0xac, 0x11, 0x31, 0xae, 0x0b, 0xd3, 0x33, 0xc5,
            0xee, 0x60, 0x21, 0x67, 0x2d, 0x97, 0x18, 0xea, 0x31,
            0xa8, 0xae, 0xbd, 0x0d, 0xa0, 0x07, 0x2f, 0x25, 0xd8,
            0x7d, 0xba, 0x6f, 0xc9, 0x0f, 0xfd, 0x59, 0x8e, 0xd4,
            0xda, 0x35, 0xe4, 0x4c, 0x39, 0x8c, 0x45, 0x43, 0x07,
            0xe8, 0xe3, 0x3b, 0x84, 0x26, 0x14, 0x3d, 0xae, 0xc9,
            0xf5, 0x96, 0x83, 0x6f, 0x97, 0xc8, 0xf7, 0x47, 0x50,
            0xe5, 0x97, 0x5c, 0x64, 0xe2, 0x18, 0x9f, 0x45, 0xde,
            0xf4, 0x6b, 0x2a, 0x2b, 0x12, 0x47, 0xad, 0xc3, 0x65,
            0x2b, 0xf5, 0xc3, 0x08, 0x05, 0x5d, 0xa9
        };

        internal static readonly byte[] PublicKeyToken1 = new byte[]
        {
            0x31, 0xbf, 0x38, 0x56, 0xad, 0x36, 0x4e, 0x35
        };

        internal static readonly string StrPublicKeyToken1 = ToDisplayString(PublicKeyToken1);
        internal static readonly string StrPublicKey1 = ToDisplayString(PublicKey1);

        internal static ImmutableArray<byte> RoPublicKey1 = PublicKey1.AsImmutableOrNull();
        internal static ImmutableArray<byte> RoPublicKeyToken1 = PublicKeyToken1.AsImmutableOrNull();

        internal static readonly HashSet<char> ClrInvalidCharacters = new HashSet<char>
        {
            '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\u0008',
            '\u000b', '\u000c',

            '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016',
            '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f',
        };

        internal static readonly HashSet<char> ClrBackslashEscapedCharacters = new HashSet<char>
        {
            ',', '/', '=', '\\'
        };

        internal static string ToDisplayString(byte[] key)
        {
            StringBuilder sb = new StringBuilder();

            foreach (byte b in key)
            {
                sb.Append(b.ToString("x2"));
            }

            return sb.ToString();
        }
    }
}
