# Contributor Guidance for Arcade
Over and above the [.NET Core contributor guidelines](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/contributing.md) (which are important), there are some principles and guidelines that are specific to Arcade as well.

For the most part, contributions to Arcade are straight forward and relatively smooth.  However, from time to time, getting changes we want in can definitely be more challenging, and even frustrating.  This document attempts to clarify some of the expectations as well as provide some 'advice' for success when contributing to Arcade.

## Principles
* Should benefit multiple repos across .NET Core.
* Every contributor is "heard" and taken seriously every time
* Keep it simple. (don't over engineer or be "clever")
* Focus on value over conviction.  (of course conviction should help drive the value discussion)
* Opinions and beliefs must be substantiated with data and a strong business rationale.
* All discussions (arguments) must be civil, respectful, productive, and above all - kind. The focus must always be on the topic, not individuals.
* Work in 'partnership' (shoulder to shoulder) as opposed to 'us' vs. 'them'.

## Conflict Resolution / Arbitration
What happens when there's just no discernable path forward?  Who is the final arbitrator?  What to do in those rare occasions where everyone is stuck...

The short answer is that the final arbitrator is the Arcade owner, which currently is @markwilkie.  However...before jumping in and asking for a 'judgement', there are a few things that need to happen first:

* Let **time** go by, while continuing to poke, discuss, re-think and so on.  Most things don't need resolution urgently (even though we often feel urgent about them) and usually the right path forward gets more clear over time.  In cases where it is urgent, finding a short term 'hack' is perfectly acceptable.
* Keep channels of communication open, and stay in there with tenacity.  In disagreements which are tough, if the dev pushing for a change loses heart, then likely nothing will happen.  Stay at it and keep up the pressure.  This is often tough to do...
* Have at least three (3) face-to-face conversations (or voice when remote) over a week or two at a minimum with the devs where there is the most disagreement.  It is amazing how much these higher bandwidth conversations help.  (Community contributors get a pass here...)
* Be able to articulate all other points of view.  Know the rationale behind the differences.

Time and again differences get worked out when these items occur.  To be sure, it's not easy and we're often tempted to think "it shouldn't be this hard".  While perhaps that's true - the reality is that sometimes it IS this hard, and there's really no easy path through.  The good news is that in Arcade, this is relatively rare.

## Helpful Tactics/Advice when it's challenging
* Where there are differences that are challenging, see the '[Defaults Guidance](./DefaultsGuidance.md)' doc for help on framing and definitions.
* Always feel free to reach out to the Arcade owner (currently @markwilkie) for advice and next steps and another perspective.
* Search for common ground, then work out from there.
* Remember that there's no such thing as "winning" an argument.  There's only working to find the best path forward for .NET Core.
* Be flexible and willing to think about something completely differently.  After all, that's what learning is all about.
* Refrain (where possible) from relying solely on GH comments to find resolution to a particular tricky disagreement.  Face-to-face when possible, or at the very least, voice conversations are much higher bandwidth and thus, dramatically more effective.
* Initially, leave your own personal 'principles' at the door.  Instead work with others to find the right pragmatic next step, but then circle back around and use your principles to help you push for the right longer term solution/approach over time.
* Take the opportunity to learn from others.  We're all learning together, and the skills required to reconcile differences are very valuable in every venue.