
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using Microsoft.AspNetCore.Http;

namespace Microsoft.AspNetCore.Routing.Matching
{
    // This code was generated by the Swaggatherer
    public abstract partial class MatcherAzureBenchmarkBase : EndpointRoutingBenchmarkBase
    {
        private protected const int EndpointCount = 5160;

        private protected void SetupEndpoints()
        {
            Endpoints = new RouteEndpoint[5160];
            Endpoints[0] = CreateEndpoint("/account", "GET");
            Endpoints[1] = CreateEndpoint("/analyze", "POST");
            Endpoints[2] = CreateEndpoint("/apis", "GET");
            Endpoints[3] = CreateEndpoint("/Applications", "GET");
            Endpoints[4] = CreateEndpoint("/ApplicationTypes", "GET");
            Endpoints[5] = CreateEndpoint("/apps/", "GET");
            Endpoints[6] = CreateEndpoint("/apps/", "POST");
            Endpoints[7] = CreateEndpoint("/authorizationServers", "GET");
            Endpoints[8] = CreateEndpoint("/backends", "GET");
            Endpoints[9] = CreateEndpoint("/BuildJob", "POST");
            Endpoints[10] = CreateEndpoint("/certificates", "POST");
            Endpoints[11] = CreateEndpoint("/certificates", "GET");
            Endpoints[12] = CreateEndpoint("/ComposeDeployments", "GET");
            Endpoints[13] = CreateEndpoint("/datasources", "POST");
            Endpoints[14] = CreateEndpoint("/datasources", "GET");
            Endpoints[15] = CreateEndpoint("/deletedcertificates", "GET");
            Endpoints[16] = CreateEndpoint("/deletedkeys", "GET");
            Endpoints[17] = CreateEndpoint("/deletedsecrets", "GET");
            Endpoints[18] = CreateEndpoint("/deletedstorage", "GET");
            Endpoints[19] = CreateEndpoint("/describe", "POST");
            Endpoints[20] = CreateEndpoint("/detect", "POST");
            Endpoints[21] = CreateEndpoint("/domains", "GET");
            Endpoints[22] = CreateEndpoint("/entities", "GET");
            Endpoints[23] = CreateEndpoint("/facelists", "GET");
            Endpoints[24] = CreateEndpoint("/Faults/", "GET");
            Endpoints[25] = CreateEndpoint("/findsimilars", "POST");
            Endpoints[26] = CreateEndpoint("/generateThumbnail", "POST");
            Endpoints[27] = CreateEndpoint("/group", "POST");
            Endpoints[28] = CreateEndpoint("/groups", "GET");
            Endpoints[29] = CreateEndpoint("/identify", "POST");
            Endpoints[30] = CreateEndpoint("/identityProviders", "GET");
            Endpoints[31] = CreateEndpoint("/ImageStore", "GET");
            Endpoints[32] = CreateEndpoint("/indexers", "POST");
            Endpoints[33] = CreateEndpoint("/indexers", "GET");
            Endpoints[34] = CreateEndpoint("/indexes", "GET");
            Endpoints[35] = CreateEndpoint("/indexes", "POST");
            Endpoints[36] = CreateEndpoint("/jobs", "POST");
            Endpoints[37] = CreateEndpoint("/Jobs", "GET");
            Endpoints[38] = CreateEndpoint("/jobschedules", "POST");
            Endpoints[39] = CreateEndpoint("/jobschedules", "GET");
            Endpoints[40] = CreateEndpoint("/keys", "GET");
            Endpoints[41] = CreateEndpoint("/lifetimejobstats", "GET");
            Endpoints[42] = CreateEndpoint("/lifetimepoolstats", "GET");
            Endpoints[43] = CreateEndpoint("/loggers", "GET");
            Endpoints[44] = CreateEndpoint("/models", "GET");
            Endpoints[45] = CreateEndpoint("/news", "GET");
            Endpoints[46] = CreateEndpoint("/nodeagentskus", "GET");
            Endpoints[47] = CreateEndpoint("/nodecounts", "GET");
            Endpoints[48] = CreateEndpoint("/Nodes", "GET");
            Endpoints[49] = CreateEndpoint("/ocr", "POST");
            Endpoints[50] = CreateEndpoint("/offers", "GET");
            Endpoints[51] = CreateEndpoint("/openidConnectProviders", "GET");
            Endpoints[52] = CreateEndpoint("/persongroups", "GET");
            Endpoints[53] = CreateEndpoint("/pipelines", "GET");
            Endpoints[54] = CreateEndpoint("/policies", "GET");
            Endpoints[55] = CreateEndpoint("/policySnippets", "GET");
            Endpoints[56] = CreateEndpoint("/pools", "GET");
            Endpoints[57] = CreateEndpoint("/pools", "POST");
            Endpoints[58] = CreateEndpoint("/poolusagemetrics", "GET");
            Endpoints[59] = CreateEndpoint("/products", "GET");
            Endpoints[60] = CreateEndpoint("/projects", "POST");
            Endpoints[61] = CreateEndpoint("/projects", "GET");
            Endpoints[62] = CreateEndpoint("/properties", "GET");
            Endpoints[63] = CreateEndpoint("/recognizeText", "POST");
            Endpoints[64] = CreateEndpoint("/recurrences", "GET");
            Endpoints[65] = CreateEndpoint("/regions", "GET");
            Endpoints[66] = CreateEndpoint("/search", "GET");
            Endpoints[67] = CreateEndpoint("/secrets", "GET");
            Endpoints[68] = CreateEndpoint("/servicestats", "GET");
            Endpoints[69] = CreateEndpoint("/spellcheck", "POST");
            Endpoints[70] = CreateEndpoint("/storage", "GET");
            Endpoints[71] = CreateEndpoint("/subscriptions", "GET");
            Endpoints[72] = CreateEndpoint("/synonymmaps", "POST");
            Endpoints[73] = CreateEndpoint("/synonymmaps", "GET");
            Endpoints[74] = CreateEndpoint("/tag", "POST");
            Endpoints[75] = CreateEndpoint("/templates", "GET");
            Endpoints[76] = CreateEndpoint("/tenants", "GET");
            Endpoints[77] = CreateEndpoint("/users", "GET");
            Endpoints[78] = CreateEndpoint("/verify", "POST");
            Endpoints[79] = CreateEndpoint("/$/CancelRepairTask", "POST");
            Endpoints[80] = CreateEndpoint("/$/CreateRepairTask", "POST");
            Endpoints[81] = CreateEndpoint("/$/DeleteRepairTask", "POST");
            Endpoints[82] = CreateEndpoint("/$/ForceApproveRepairTask", "POST");
            Endpoints[83] = CreateEndpoint("/$/GetAadMetadata", "GET");
            Endpoints[84] = CreateEndpoint("/$/GetClusterConfiguration", "GET");
            Endpoints[85] = CreateEndpoint("/$/GetClusterConfigurationUpgradeStatus", "GET");
            Endpoints[86] = CreateEndpoint("/$/GetClusterHealth", "GET");
            Endpoints[87] = CreateEndpoint("/$/GetClusterHealth", "POST");
            Endpoints[88] = CreateEndpoint("/$/GetClusterHealthChunk", "POST");
            Endpoints[89] = CreateEndpoint("/$/GetClusterHealthChunk", "GET");
            Endpoints[90] = CreateEndpoint("/$/GetClusterManifest", "GET");
            Endpoints[91] = CreateEndpoint("/$/GetLoadInformation", "GET");
            Endpoints[92] = CreateEndpoint("/$/GetProvisionedCodeVersions", "GET");
            Endpoints[93] = CreateEndpoint("/$/GetProvisionedConfigVersions", "GET");
            Endpoints[94] = CreateEndpoint("/$/GetRepairTaskList", "GET");
            Endpoints[95] = CreateEndpoint("/$/GetUpgradeOrchestrationServiceState", "GET");
            Endpoints[96] = CreateEndpoint("/$/GetUpgradeProgress", "GET");
            Endpoints[97] = CreateEndpoint("/$/InvokeInfrastructureCommand", "POST");
            Endpoints[98] = CreateEndpoint("/$/InvokeInfrastructureQuery", "GET");
            Endpoints[99] = CreateEndpoint("/$/MoveToNextUpgradeDomain", "POST");
            Endpoints[100] = CreateEndpoint("/$/Provision", "POST");
            Endpoints[101] = CreateEndpoint("/$/RecoverAllPartitions", "POST");
            Endpoints[102] = CreateEndpoint("/$/RecoverSystemPartitions", "POST");
            Endpoints[103] = CreateEndpoint("/$/ReportClusterHealth", "POST");
            Endpoints[104] = CreateEndpoint("/$/RollbackUpgrade", "POST");
            Endpoints[105] = CreateEndpoint("/$/SetUpgradeOrchestrationServiceState", "POST");
            Endpoints[106] = CreateEndpoint("/$/StartClusterConfigurationUpgrade", "POST");
            Endpoints[107] = CreateEndpoint("/$/Unprovision", "POST");
            Endpoints[108] = CreateEndpoint("/$/UpdateRepairExecutionState", "POST");
            Endpoints[109] = CreateEndpoint("/$/UpdateRepairTaskHealthPolicy", "POST");
            Endpoints[110] = CreateEndpoint("/$/UpdateUpgrade", "POST");
            Endpoints[111] = CreateEndpoint("/$/Upgrade", "POST");
            Endpoints[112] = CreateEndpoint("/api/events", "POST");
            Endpoints[113] = CreateEndpoint("/apps/assistants", "GET");
            Endpoints[114] = CreateEndpoint("/apps/cultures", "GET");
            Endpoints[115] = CreateEndpoint("/apps/customprebuiltdomains", "POST");
            Endpoints[116] = CreateEndpoint("/apps/customprebuiltdomains", "GET");
            Endpoints[117] = CreateEndpoint("/apps/domains", "GET");
            Endpoints[118] = CreateEndpoint("/apps/import", "POST");
            Endpoints[119] = CreateEndpoint("/apps/usagescenarios", "GET");
            Endpoints[120] = CreateEndpoint("/BackupRestore/BackupPolicies", "GET");
            Endpoints[121] = CreateEndpoint("/certificates/contacts", "GET");
            Endpoints[122] = CreateEndpoint("/certificates/contacts", "DELETE");
            Endpoints[123] = CreateEndpoint("/certificates/contacts", "PUT");
            Endpoints[124] = CreateEndpoint("/certificates/issuers", "GET");
            Endpoints[125] = CreateEndpoint("/docs/$count", "GET");
            Endpoints[126] = CreateEndpoint("/docs/autocomplete", "POST");
            Endpoints[127] = CreateEndpoint("/docs/autocomplete", "GET");
            Endpoints[128] = CreateEndpoint("/images/details", "GET");
            Endpoints[129] = CreateEndpoint("/images/search", "GET");
            Endpoints[130] = CreateEndpoint("/images/trending", "GET");
            Endpoints[131] = CreateEndpoint("/images/visualsearch", "POST");
            Endpoints[132] = CreateEndpoint("/keys/restore", "POST");
            Endpoints[133] = CreateEndpoint("/news/search", "GET");
            Endpoints[134] = CreateEndpoint("/news/trendingtopics", "GET");
            Endpoints[135] = CreateEndpoint("/portalsettings/delegation", "PUT");
            Endpoints[136] = CreateEndpoint("/portalsettings/delegation", "PATCH");
            Endpoints[137] = CreateEndpoint("/portalsettings/delegation", "GET");
            Endpoints[138] = CreateEndpoint("/portalsettings/signin", "PUT");
            Endpoints[139] = CreateEndpoint("/portalsettings/signin", "PATCH");
            Endpoints[140] = CreateEndpoint("/portalsettings/signin", "GET");
            Endpoints[141] = CreateEndpoint("/portalsettings/signup", "PATCH");
            Endpoints[142] = CreateEndpoint("/portalsettings/signup", "GET");
            Endpoints[143] = CreateEndpoint("/portalsettings/signup", "PUT");
            Endpoints[144] = CreateEndpoint("/reports/byApi", "GET");
            Endpoints[145] = CreateEndpoint("/reports/byGeo", "GET");
            Endpoints[146] = CreateEndpoint("/reports/byOperation", "GET");
            Endpoints[147] = CreateEndpoint("/reports/byProduct", "GET");
            Endpoints[148] = CreateEndpoint("/reports/byRequest", "GET");
            Endpoints[149] = CreateEndpoint("/reports/bySubscription", "GET");
            Endpoints[150] = CreateEndpoint("/reports/byTime", "GET");
            Endpoints[151] = CreateEndpoint("/reports/byUser", "GET");
            Endpoints[152] = CreateEndpoint("/secrets/restore", "POST");
            Endpoints[153] = CreateEndpoint("/storage/restore", "POST");
            Endpoints[154] = CreateEndpoint("/Tools/Chaos", "GET");
            Endpoints[155] = CreateEndpoint("/v2.0/entities", "POST");
            Endpoints[156] = CreateEndpoint("/v2.0/keyPhrases", "POST");
            Endpoints[157] = CreateEndpoint("/v2.0/languages", "POST");
            Endpoints[158] = CreateEndpoint("/v2.0/sentiment", "POST");
            Endpoints[159] = CreateEndpoint("/videos/details", "GET");
            Endpoints[160] = CreateEndpoint("/videos/search", "GET");
            Endpoints[161] = CreateEndpoint("/videos/trending", "GET");
            Endpoints[162] = CreateEndpoint("/Applications/$/Create", "POST");
            Endpoints[163] = CreateEndpoint("/ApplicationTypes/$/Provision", "POST");
            Endpoints[164] = CreateEndpoint("/BackupRestore/$/GetBackups", "POST");
            Endpoints[165] = CreateEndpoint("/catalog/usql/acl", "GET");
            Endpoints[166] = CreateEndpoint("/catalog/usql/databases", "GET");
            Endpoints[167] = CreateEndpoint("/ComposeDeployments/$/Create", "PUT");
            Endpoints[168] = CreateEndpoint("/EventsStore/Applications/Events", "GET");
            Endpoints[169] = CreateEndpoint("/EventsStore/Cluster/Events", "GET");
            Endpoints[170] = CreateEndpoint("/EventsStore/Containers/Events", "GET");
            Endpoints[171] = CreateEndpoint("/EventsStore/Nodes/Events", "GET");
            Endpoints[172] = CreateEndpoint("/EventsStore/Partitions/Events", "GET");
            Endpoints[173] = CreateEndpoint("/EventsStore/Services/Events", "GET");
            Endpoints[174] = CreateEndpoint("/Faults/$/Cancel", "POST");
            Endpoints[175] = CreateEndpoint("/ImageStore/$/CommitUploadSession", "POST");
            Endpoints[176] = CreateEndpoint("/ImageStore/$/Copy", "POST");
            Endpoints[177] = CreateEndpoint("/ImageStore/$/DeleteUploadSession", "DELETE");
            Endpoints[178] = CreateEndpoint("/ImageStore/$/GetUploadSession", "GET");
            Endpoints[179] = CreateEndpoint("/Names/$/Create", "POST");
            Endpoints[180] = CreateEndpoint("/providers/Microsoft.AAD/operations", "GET");
            Endpoints[181] = CreateEndpoint("/providers/Microsoft.Addons/operations", "GET");
            Endpoints[182] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices", "POST");
            Endpoints[183] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices", "GET");
            Endpoints[184] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/configuration", "PATCH");
            Endpoints[185] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/configuration", "GET");
            Endpoints[186] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/configuration", "POST");
            Endpoints[187] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/operations", "GET");
            Endpoints[188] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services", "POST");
            Endpoints[189] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services", "GET");
            Endpoints[190] = CreateEndpoint("/providers/Microsoft.Advisor/operations", "GET");
            Endpoints[191] = CreateEndpoint("/providers/Microsoft.AnalysisServices/operations", "GET");
            Endpoints[192] = CreateEndpoint("/providers/Microsoft.ApiManagement/operations", "GET");
            Endpoints[193] = CreateEndpoint("/providers/Microsoft.Authorization/policyDefinitions", "GET");
            Endpoints[194] = CreateEndpoint("/providers/Microsoft.Authorization/policySetDefinitions", "GET");
            Endpoints[195] = CreateEndpoint("/providers/Microsoft.Authorization/providerOperations", "GET");
            Endpoints[196] = CreateEndpoint("/providers/Microsoft.Automation/operations", "GET");
            Endpoints[197] = CreateEndpoint("/providers/Microsoft.AzureStack/operations", "GET");
            Endpoints[198] = CreateEndpoint("/providers/Microsoft.Backup.Admin/operations", "GET");
            Endpoints[199] = CreateEndpoint("/providers/Microsoft.Batch/operations", "GET");
            Endpoints[200] = CreateEndpoint("/providers/Microsoft.BatchAI/operations", "GET");
            Endpoints[201] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts", "GET");
            Endpoints[202] = CreateEndpoint("/providers/Microsoft.Billing/operations", "GET");
            Endpoints[203] = CreateEndpoint("/providers/Microsoft.BotService/operations", "GET");
            Endpoints[204] = CreateEndpoint("/providers/Microsoft.Cache/operations", "GET");
            Endpoints[205] = CreateEndpoint("/providers/Microsoft.Capacity/operations", "GET");
            Endpoints[206] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders", "GET");
            Endpoints[207] = CreateEndpoint("/providers/Microsoft.Cdn/checkNameAvailability", "POST");
            Endpoints[208] = CreateEndpoint("/providers/Microsoft.Cdn/edgenodes", "GET");
            Endpoints[209] = CreateEndpoint("/providers/Microsoft.Cdn/operations", "GET");
            Endpoints[210] = CreateEndpoint("/providers/Microsoft.CertificateRegistration/operations", "GET");
            Endpoints[211] = CreateEndpoint("/providers/Microsoft.CognitiveServices/operations", "GET");
            Endpoints[212] = CreateEndpoint("/providers/Microsoft.Commerce.Admin/operations", "GET");
            Endpoints[213] = CreateEndpoint("/providers/Microsoft.Compute.Admin/operations", "GET");
            Endpoints[214] = CreateEndpoint("/providers/Microsoft.Compute/operations", "GET");
            Endpoints[215] = CreateEndpoint("/providers/Microsoft.Consumption/operations", "GET");
            Endpoints[216] = CreateEndpoint("/providers/Microsoft.ContainerInstance/operations", "GET");
            Endpoints[217] = CreateEndpoint("/providers/Microsoft.ContainerRegistry/operations", "GET");
            Endpoints[218] = CreateEndpoint("/providers/Microsoft.ContainerService/operations", "GET");
            Endpoints[219] = CreateEndpoint("/providers/Microsoft.CustomerInsights/operations", "GET");
            Endpoints[220] = CreateEndpoint("/providers/Microsoft.DataBox/operations", "GET");
            Endpoints[221] = CreateEndpoint("/providers/Microsoft.Databricks/operations", "GET");
            Endpoints[222] = CreateEndpoint("/providers/Microsoft.DataCatalog/operations", "GET");
            Endpoints[223] = CreateEndpoint("/providers/Microsoft.DataFactory/operations", "GET");
            Endpoints[224] = CreateEndpoint("/providers/Microsoft.DataLakeAnalytics/operations", "GET");
            Endpoints[225] = CreateEndpoint("/providers/Microsoft.DataLakeStore/operations", "GET");
            Endpoints[226] = CreateEndpoint("/providers/Microsoft.DataMigration/operations", "GET");
            Endpoints[227] = CreateEndpoint("/providers/Microsoft.DBforMySQL/operations", "GET");
            Endpoints[228] = CreateEndpoint("/providers/Microsoft.DBforPostgreSQL/operations", "GET");
            Endpoints[229] = CreateEndpoint("/providers/Microsoft.Devices/operations", "GET");
            Endpoints[230] = CreateEndpoint("/providers/Microsoft.DevTestLab/operations", "GET");
            Endpoints[231] = CreateEndpoint("/providers/Microsoft.DocumentDB/operations", "GET");
            Endpoints[232] = CreateEndpoint("/providers/Microsoft.DomainRegistration/operations", "GET");
            Endpoints[233] = CreateEndpoint("/providers/Microsoft.EventGrid/operations", "GET");
            Endpoints[234] = CreateEndpoint("/providers/Microsoft.EventGrid/topicTypes", "GET");
            Endpoints[235] = CreateEndpoint("/providers/Microsoft.EventHub/operations", "GET");
            Endpoints[236] = CreateEndpoint("/providers/Microsoft.Fabric.Admin/operations", "GET");
            Endpoints[237] = CreateEndpoint("/providers/Microsoft.Gallery.Admin/operations", "GET");
            Endpoints[238] = CreateEndpoint("/providers/Microsoft.HanaOnAzure/operations", "GET");
            Endpoints[239] = CreateEndpoint("/providers/Microsoft.HDInsight/operations", "GET");
            Endpoints[240] = CreateEndpoint("/providers/Microsoft.ImportExport/locations", "GET");
            Endpoints[241] = CreateEndpoint("/providers/Microsoft.ImportExport/operations", "GET");
            Endpoints[242] = CreateEndpoint("/providers/Microsoft.InfrastructureInsights.Admin/operations", "GET");
            Endpoints[243] = CreateEndpoint("/providers/microsoft.insights/eventcategories", "GET");
            Endpoints[244] = CreateEndpoint("/providers/microsoft.insights/operations", "GET");
            Endpoints[245] = CreateEndpoint("/providers/Microsoft.Intune/locations", "GET");
            Endpoints[246] = CreateEndpoint("/providers/Microsoft.IoTCentral/operations", "GET");
            Endpoints[247] = CreateEndpoint("/providers/Microsoft.IoTSpaces/operations", "GET");
            Endpoints[248] = CreateEndpoint("/providers/Microsoft.KeyVault.Admin/operations", "GET");
            Endpoints[249] = CreateEndpoint("/providers/Microsoft.KeyVault/operations", "GET");
            Endpoints[250] = CreateEndpoint("/providers/Microsoft.Logic/operations", "GET");
            Endpoints[251] = CreateEndpoint("/providers/Microsoft.MachineLearning/operations", "GET");
            Endpoints[252] = CreateEndpoint("/providers/Microsoft.MachineLearningCompute/operations", "GET");
            Endpoints[253] = CreateEndpoint("/providers/Microsoft.MachineLearningExperimentation/operations", "GET");
            Endpoints[254] = CreateEndpoint("/providers/Microsoft.MachineLearningServices/operations", "GET");
            Endpoints[255] = CreateEndpoint("/providers/Microsoft.ManagedIdentity/operations", "GET");
            Endpoints[256] = CreateEndpoint("/providers/Microsoft.Management/checkNameAvailability", "POST");
            Endpoints[257] = CreateEndpoint("/providers/Microsoft.Management/getEntities", "POST");
            Endpoints[258] = CreateEndpoint("/providers/Microsoft.Management/managementGroups", "GET");
            Endpoints[259] = CreateEndpoint("/providers/Microsoft.Management/operations", "GET");
            Endpoints[260] = CreateEndpoint("/providers/Microsoft.Management/startTenantBackfill", "POST");
            Endpoints[261] = CreateEndpoint("/providers/Microsoft.Management/tenantBackfillStatus", "POST");
            Endpoints[262] = CreateEndpoint("/providers/Microsoft.ManagementPartner/operations", "GET");
            Endpoints[263] = CreateEndpoint("/providers/Microsoft.Maps/operations", "GET");
            Endpoints[264] = CreateEndpoint("/providers/Microsoft.MarketplaceOrdering/operations", "GET");
            Endpoints[265] = CreateEndpoint("/providers/Microsoft.Media/operations", "GET");
            Endpoints[266] = CreateEndpoint("/providers/Microsoft.Migrate/operations", "GET");
            Endpoints[267] = CreateEndpoint("/providers/Microsoft.Network/checkTrafficManagerNameAvailability", "POST");
            Endpoints[268] = CreateEndpoint("/providers/Microsoft.Network/operations", "GET");
            Endpoints[269] = CreateEndpoint("/providers/Microsoft.NotificationHubs/operations", "GET");
            Endpoints[270] = CreateEndpoint("/providers/Microsoft.OperationalInsights/operations", "GET");
            Endpoints[271] = CreateEndpoint("/providers/Microsoft.OperationsManagement/operations", "GET");
            Endpoints[272] = CreateEndpoint("/providers/Microsoft.PolicyInsights/operations", "GET");
            Endpoints[273] = CreateEndpoint("/providers/Microsoft.PowerBI/operations", "GET");
            Endpoints[274] = CreateEndpoint("/providers/Microsoft.PowerBIDedicated/operations", "GET");
            Endpoints[275] = CreateEndpoint("/providers/Microsoft.RecoveryServices/operations", "GET");
            Endpoints[276] = CreateEndpoint("/providers/Microsoft.Relay/operations", "GET");
            Endpoints[277] = CreateEndpoint("/providers/Microsoft.ResourceHealth/operations", "GET");
            Endpoints[278] = CreateEndpoint("/providers/Microsoft.Search/operations", "GET");
            Endpoints[279] = CreateEndpoint("/providers/Microsoft.Security/operations", "GET");
            Endpoints[280] = CreateEndpoint("/providers/Microsoft.ServiceBus/operations", "GET");
            Endpoints[281] = CreateEndpoint("/providers/Microsoft.ServiceFabric/operations", "GET");
            Endpoints[282] = CreateEndpoint("/providers/Microsoft.SignalRService/operations", "GET");
            Endpoints[283] = CreateEndpoint("/providers/Microsoft.Sql/operations", "GET");
            Endpoints[284] = CreateEndpoint("/providers/Microsoft.Storage.Admin/operations", "GET");
            Endpoints[285] = CreateEndpoint("/providers/Microsoft.Storage/operations", "GET");
            Endpoints[286] = CreateEndpoint("/providers/Microsoft.StorSimple/operations", "GET");
            Endpoints[287] = CreateEndpoint("/providers/Microsoft.StreamAnalytics/operations", "GET");
            Endpoints[288] = CreateEndpoint("/providers/Microsoft.Subscription/operations", "GET");
            Endpoints[289] = CreateEndpoint("/providers/Microsoft.Subscription/subscriptionDefinitions", "GET");
            Endpoints[290] = CreateEndpoint("/providers/Microsoft.Subscription/subscriptionOperations", "GET");
            Endpoints[291] = CreateEndpoint("/providers/Microsoft.Subscriptions.Admin/operations", "GET");
            Endpoints[292] = CreateEndpoint("/providers/Microsoft.Subscriptions/operations", "GET");
            Endpoints[293] = CreateEndpoint("/providers/Microsoft.TimeSeriesInsights/operations", "GET");
            Endpoints[294] = CreateEndpoint("/providers/Microsoft.Update.Admin/operations", "GET");
            Endpoints[295] = CreateEndpoint("/providers/microsoft.visualstudio/operations", "GET");
            Endpoints[296] = CreateEndpoint("/providers/Microsoft.Web/availableStacks", "GET");
            Endpoints[297] = CreateEndpoint("/providers/Microsoft.Web/operations", "GET");
            Endpoints[298] = CreateEndpoint("/providers/Microsoft.Web/sourcecontrols", "GET");
            Endpoints[299] = CreateEndpoint("/Tools/Chaos/Events", "GET");
            Endpoints[300] = CreateEndpoint("/Tools/Chaos/Schedule", "GET");
            Endpoints[301] = CreateEndpoint("/Tools/Chaos/Schedule", "POST");
            Endpoints[302] = CreateEndpoint("/BackupRestore/BackupPolicies/$/Create", "POST");
            Endpoints[303] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists", "POST");
            Endpoints[304] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists", "GET");
            Endpoints[305] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists", "GET");
            Endpoints[306] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists", "POST");
            Endpoints[307] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/premiumCheck", "GET");
            Endpoints[308] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/premiumCheck", "GET");
            Endpoints[309] = CreateEndpoint("/providers/Microsoft.BotService/botServices/checkNameAvailability", "GET");
            Endpoints[310] = CreateEndpoint("/providers/Microsoft.Intune/locations/hostName", "GET");
            Endpoints[311] = CreateEndpoint("/providers/Microsoft.Network/trafficManagerGeographicHierarchies/default", "GET");
            Endpoints[312] = CreateEndpoint("/providers/Microsoft.Web/publishingUsers/web", "PUT");
            Endpoints[313] = CreateEndpoint("/providers/Microsoft.Web/publishingUsers/web", "GET");
            Endpoints[314] = CreateEndpoint("/Tools/Chaos/$/Report", "GET");
            Endpoints[315] = CreateEndpoint("/Tools/Chaos/$/Start", "POST");
            Endpoints[316] = CreateEndpoint("/Tools/Chaos/$/Stop", "POST");
            Endpoints[317] = CreateEndpoint("/contentmoderator/moderate/v1.0/ProcessImage/Evaluate", "POST");
            Endpoints[318] = CreateEndpoint("/contentmoderator/moderate/v1.0/ProcessImage/FindFaces", "POST");
            Endpoints[319] = CreateEndpoint("/contentmoderator/moderate/v1.0/ProcessImage/Match", "POST");
            Endpoints[320] = CreateEndpoint("/contentmoderator/moderate/v1.0/ProcessImage/OCR", "POST");
            Endpoints[321] = CreateEndpoint("/contentmoderator/moderate/v1.0/ProcessText/DetectLanguage", "POST");
            Endpoints[322] = CreateEndpoint("/contentmoderator/moderate/v1.0/ProcessText/Screen/", "POST");
            Endpoints[323] = CreateEndpoint("/providers/microsoft.insights/eventtypes/management/values", "GET");
            Endpoints[324] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}", "GET");
            Endpoints[325] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}", "PUT");
            Endpoints[326] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}", "DELETE");
            Endpoints[327] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}", "GET");
            Endpoints[328] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}", "DELETE");
            Endpoints[329] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}", "PUT");
            Endpoints[330] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}/images", "POST");
            Endpoints[331] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}/images", "GET");
            Endpoints[332] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}/images", "DELETE");
            Endpoints[333] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}/RefreshIndex", "POST");
            Endpoints[334] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}/RefreshIndex", "POST");
            Endpoints[335] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}/terms", "GET");
            Endpoints[336] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}/terms", "DELETE");
            Endpoints[337] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/jobs", "POST");
            Endpoints[338] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews", "POST");
            Endpoints[339] = CreateEndpoint("/contentmoderator/lists/v1.0/imagelists/{listId}/images/{ImageId}", "DELETE");
            Endpoints[340] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}/terms/{term}", "POST");
            Endpoints[341] = CreateEndpoint("/contentmoderator/lists/v1.0/termlists/{listId}/terms/{term}", "DELETE");
            Endpoints[342] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/jobs/{JobId}", "GET");
            Endpoints[343] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}", "GET");
            Endpoints[344] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames", "POST");
            Endpoints[345] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames", "GET");
            Endpoints[346] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/publish", "POST");
            Endpoints[347] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/transcript", "PUT");
            Endpoints[348] = CreateEndpoint("/contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/transcriptmoderationresult", "PUT");
            Endpoints[349] = CreateEndpoint("/catalog/usql/databases/{databaseName}", "GET");
            Endpoints[350] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}", "GET");
            Endpoints[351] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}", "PATCH");
            Endpoints[352] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}", "DELETE");
            Endpoints[353] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}", "PATCH");
            Endpoints[354] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}", "DELETE");
            Endpoints[355] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}", "GET");
            Endpoints[356] = CreateEndpoint("/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}", "GET");
            Endpoints[357] = CreateEndpoint("/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "GET");
            Endpoints[358] = CreateEndpoint("/providers/Microsoft.Authorization/providerOperations/{resourceProviderNamespace}", "GET");
            Endpoints[359] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts/{name}", "GET");
            Endpoints[360] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}", "GET");
            Endpoints[361] = CreateEndpoint("/providers/Microsoft.DocumentDB/databaseAccountNames/{accountName}", "HEAD");
            Endpoints[362] = CreateEndpoint("/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}", "GET");
            Endpoints[363] = CreateEndpoint("/providers/Microsoft.ImportExport/locations/{locationName}", "GET");
            Endpoints[364] = CreateEndpoint("/providers/Microsoft.Management/managementGroups/{groupId}", "GET");
            Endpoints[365] = CreateEndpoint("/providers/Microsoft.Management/managementGroups/{groupId}", "PUT");
            Endpoints[366] = CreateEndpoint("/providers/Microsoft.Management/managementGroups/{groupId}", "PATCH");
            Endpoints[367] = CreateEndpoint("/providers/Microsoft.Management/managementGroups/{groupId}", "DELETE");
            Endpoints[368] = CreateEndpoint("/providers/Microsoft.ManagementPartner/partners/{partnerId}", "GET");
            Endpoints[369] = CreateEndpoint("/providers/Microsoft.ManagementPartner/partners/{partnerId}", "DELETE");
            Endpoints[370] = CreateEndpoint("/providers/Microsoft.ManagementPartner/partners/{partnerId}", "PUT");
            Endpoints[371] = CreateEndpoint("/providers/Microsoft.ManagementPartner/partners/{partnerId}", "PATCH");
            Endpoints[372] = CreateEndpoint("/providers/Microsoft.Subscription/subscriptionDefinitions/{subscriptionDefinitionName}", "GET");
            Endpoints[373] = CreateEndpoint("/providers/Microsoft.Subscription/subscriptionDefinitions/{subscriptionDefinitionName}", "PUT");
            Endpoints[374] = CreateEndpoint("/providers/Microsoft.Subscription/subscriptionOperations/{operationId}", "GET");
            Endpoints[375] = CreateEndpoint("/providers/Microsoft.Web/sourcecontrols/{sourceControlType}", "PUT");
            Endpoints[376] = CreateEndpoint("/providers/Microsoft.Web/sourcecontrols/{sourceControlType}", "GET");
            Endpoints[377] = CreateEndpoint("/catalog/usql/databases/{databaseName}/acl", "GET");
            Endpoints[378] = CreateEndpoint("/catalog/usql/databases/{databaseName}/assemblies", "GET");
            Endpoints[379] = CreateEndpoint("/catalog/usql/databases/{databaseName}/credentials", "GET");
            Endpoints[380] = CreateEndpoint("/catalog/usql/databases/{databaseName}/externaldatasources", "GET");
            Endpoints[381] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas", "GET");
            Endpoints[382] = CreateEndpoint("/catalog/usql/databases/{databaseName}/secrets", "DELETE");
            Endpoints[383] = CreateEndpoint("/catalog/usql/databases/{databaseName}/statistics", "GET");
            Endpoints[384] = CreateEndpoint("/catalog/usql/databases/{databaseName}/tables", "GET");
            Endpoints[385] = CreateEndpoint("/catalog/usql/databases/{databaseName}/tablevaluedfunctions", "GET");
            Endpoints[386] = CreateEndpoint("/catalog/usql/databases/{databaseName}/views", "GET");
            Endpoints[387] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/addomainservicemembers", "GET");
            Endpoints[388] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/addsservicemembers", "GET");
            Endpoints[389] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/alerts", "GET");
            Endpoints[390] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/configuration", "GET");
            Endpoints[391] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/forestsummary", "GET");
            Endpoints[392] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metricmetadata", "GET");
            Endpoints[393] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/replicationstatus", "GET");
            Endpoints[394] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/replicationsummary", "GET");
            Endpoints[395] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/alerts", "GET");
            Endpoints[396] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/exportstatus", "GET");
            Endpoints[397] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metricmetadata", "GET");
            Endpoints[398] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/monitoringconfiguration", "PATCH");
            Endpoints[399] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/monitoringconfigurations", "GET");
            Endpoints[400] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers", "GET");
            Endpoints[401] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers", "POST");
            Endpoints[402] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/merge", "POST");
            Endpoints[403] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations", "GET");
            Endpoints[404] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/split", "POST");
            Endpoints[405] = CreateEndpoint("/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventTypes", "GET");
            Endpoints[406] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies", "GET");
            Endpoints[407] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/apps", "GET");
            Endpoints[408] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/flaggedUsers", "GET");
            Endpoints[409] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies", "GET");
            Endpoints[410] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/operationResults", "GET");
            Endpoints[411] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/exporterrors/counts", "GET");
            Endpoints[412] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/exporterrors/listV2", "GET");
            Endpoints[413] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/statuses/default", "GET");
            Endpoints[414] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/feedbacktype/alerts/feedback", "POST");
            Endpoints[415] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/balances", "GET");
            Endpoints[416] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/costTags", "PUT");
            Endpoints[417] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/costTags", "GET");
            Endpoints[418] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[419] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[420] = CreateEndpoint("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[421] = CreateEndpoint("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[422] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[423] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[424] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts/{enrollmentAccountName}/providers/Microsoft.Subscription/createSubscription", "POST");
            Endpoints[425] = CreateEndpoint("/providers/Microsoft.Capacity/reservationorders/{reservationOrderId}/providers/Microsoft.Consumption/reservationDetails", "GET");
            Endpoints[426] = CreateEndpoint("/providers/Microsoft.Capacity/reservationorders/{reservationOrderId}/providers/Microsoft.Consumption/reservationSummaries", "GET");
            Endpoints[427] = CreateEndpoint("/providers/Microsoft.CostManagement/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/tags", "GET");
            Endpoints[428] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions", "GET");
            Endpoints[429] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions", "GET");
            Endpoints[430] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/reports/badpassword/details/user", "GET");
            Endpoints[431] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}", "DELETE");
            Endpoints[432] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}", "PUT");
            Endpoints[433] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}", "GET");
            Endpoints[434] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "PUT");
            Endpoints[435] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "GET");
            Endpoints[436] = CreateEndpoint("/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "DELETE");
            Endpoints[437] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/balances", "GET");
            Endpoints[438] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[439] = CreateEndpoint("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[440] = CreateEndpoint("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[441] = CreateEndpoint("/providers/Microsoft.Billing/departments/{departmentId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[442] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[443] = CreateEndpoint("/providers/Microsoft.Billing/enrollmentAccounts/{enrollmentAccountId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[444] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/feedbacktype/alerts/{shortName}/alertfeedback", "GET");
            Endpoints[445] = CreateEndpoint("/catalog/usql/databases/{databaseName}/assemblies/{assemblyName}", "GET");
            Endpoints[446] = CreateEndpoint("/catalog/usql/databases/{databaseName}/credentials/{credentialName}", "PATCH");
            Endpoints[447] = CreateEndpoint("/catalog/usql/databases/{databaseName}/credentials/{credentialName}", "GET");
            Endpoints[448] = CreateEndpoint("/catalog/usql/databases/{databaseName}/credentials/{credentialName}", "PUT");
            Endpoints[449] = CreateEndpoint("/catalog/usql/databases/{databaseName}/credentials/{credentialName}", "POST");
            Endpoints[450] = CreateEndpoint("/catalog/usql/databases/{databaseName}/externaldatasources/{externalDataSourceName}", "GET");
            Endpoints[451] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}", "GET");
            Endpoints[452] = CreateEndpoint("/catalog/usql/databases/{databaseName}/secrets/{secretName}", "PUT");
            Endpoints[453] = CreateEndpoint("/catalog/usql/databases/{databaseName}/secrets/{secretName}", "GET");
            Endpoints[454] = CreateEndpoint("/catalog/usql/databases/{databaseName}/secrets/{secretName}", "PATCH");
            Endpoints[455] = CreateEndpoint("/catalog/usql/databases/{databaseName}/secrets/{secretName}", "DELETE");
            Endpoints[456] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/dimensions/{dimension}", "GET");
            Endpoints[457] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metricmetadata/{metricName}", "GET");
            Endpoints[458] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/checkServiceFeatureAvailibility/{featureName}", "GET");
            Endpoints[459] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metricmetadata/{metricName}", "GET");
            Endpoints[460] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}", "DELETE");
            Endpoints[461] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}", "GET");
            Endpoints[462] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/TenantWhitelisting/{featureName}", "GET");
            Endpoints[463] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}", "GET");
            Endpoints[464] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}", "PATCH");
            Endpoints[465] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}", "GET");
            Endpoints[466] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}", "PUT");
            Endpoints[467] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}", "PATCH");
            Endpoints[468] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}", "DELETE");
            Endpoints[469] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/flaggedUsers/{userName}", "GET");
            Endpoints[470] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}", "GET");
            Endpoints[471] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}", "PUT");
            Endpoints[472] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}", "PATCH");
            Endpoints[473] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}", "DELETE");
            Endpoints[474] = CreateEndpoint("/providers/Microsoft.Management/managementGroups/{groupId}/subscriptions/{subscriptionId}", "DELETE");
            Endpoints[475] = CreateEndpoint("/providers/Microsoft.Management/managementGroups/{groupId}/subscriptions/{subscriptionId}", "PUT");
            Endpoints[476] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/packages", "GET");
            Endpoints[477] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures", "GET");
            Endpoints[478] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/statistics", "GET");
            Endpoints[479] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables", "GET");
            Endpoints[480] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes", "GET");
            Endpoints[481] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions", "GET");
            Endpoints[482] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/types", "GET");
            Endpoints[483] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/views", "GET");
            Endpoints[484] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/servicemembers/{serviceMemberId}/alerts", "GET");
            Endpoints[485] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/service/{serviceName}/servicemembers/{serviceMemberId}/connectors", "GET");
            Endpoints[486] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/alerts", "GET");
            Endpoints[487] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/credentials", "GET");
            Endpoints[488] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/data", "DELETE");
            Endpoints[489] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/datafreshness", "GET");
            Endpoints[490] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/exportstatus", "GET");
            Endpoints[491] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/globalconfiguration", "GET");
            Endpoints[492] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/serviceconfiguration", "GET");
            Endpoints[493] = CreateEndpoint("/providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}/revisions", "GET");
            Endpoints[494] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/AndroidPolicies/{policyName}/apps", "GET");
            Endpoints[495] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}/groups", "GET");
            Endpoints[496] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/flaggedUsers/{userName}/flaggedEnrolledApps", "GET");
            Endpoints[497] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}/apps", "GET");
            Endpoints[498] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}/groups", "GET");
            Endpoints[499] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/users/{userName}/devices", "GET");
            Endpoints[500] = CreateEndpoint("/providers/Microsoft.Capacity/reservationorders/{reservationOrderId}/reservations/{reservationId}/providers/Microsoft.Consumption/reservationDetails", "GET");
            Endpoints[501] = CreateEndpoint("/providers/Microsoft.Capacity/reservationorders/{reservationOrderId}/reservations/{reservationId}/providers/Microsoft.Consumption/reservationSummaries", "GET");
            Endpoints[502] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/packages/{packageName}", "GET");
            Endpoints[503] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/procedures/{procedureName}", "GET");
            Endpoints[504] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}", "GET");
            Endpoints[505] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tabletypes/{tableTypeName}", "GET");
            Endpoints[506] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tablevaluedfunctions/{tableValuedFunctionName}", "GET");
            Endpoints[507] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/views/{viewName}", "GET");
            Endpoints[508] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metricmetadata/{metricName}/groups/{groupName}", "GET");
            Endpoints[509] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metricmetadata/{metricName}/groups/{groupName}", "GET");
            Endpoints[510] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}/apps/{appName}", "PUT");
            Endpoints[511] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}/apps/{appName}", "DELETE");
            Endpoints[512] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}/groups/{groupId}", "PUT");
            Endpoints[513] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/androidPolicies/{policyName}/groups/{groupId}", "DELETE");
            Endpoints[514] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}/apps/{appName}", "DELETE");
            Endpoints[515] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}/apps/{appName}", "PUT");
            Endpoints[516] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}/groups/{groupId}", "DELETE");
            Endpoints[517] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}/groups/{groupId}", "PUT");
            Endpoints[518] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/users/{userName}/devices/{deviceName}", "GET");
            Endpoints[519] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions", "GET");
            Endpoints[520] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/previewrows", "GET");
            Endpoints[521] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics", "GET");
            Endpoints[522] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/tablefragments", "GET");
            Endpoints[523] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metrics/{metricName}/groups/{groupName}/average", "GET");
            Endpoints[524] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metrics/{metricName}/groups/{groupName}/sum", "GET");
            Endpoints[525] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metrics/{metricName}/groups/{groupName}/average", "GET");
            Endpoints[526] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metrics/{metricName}/groups/{groupName}/sum", "GET");
            Endpoints[527] = CreateEndpoint("/providers/Microsoft.Intune/locations/{hostName}/users/{userName}/devices/{deviceName}/wipe", "POST");
            Endpoints[528] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}", "GET");
            Endpoints[529] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/statistics/{statisticsName}", "GET");
            Endpoints[530] = CreateEndpoint("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/metrics/{metricName}/groups/{groupName}", "GET");
            Endpoints[531] = CreateEndpoint("/catalog/usql/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/partitions/{partitionName}/previewrows", "GET");
            Endpoints[532] = CreateEndpoint("/apps/customprebuiltdomains/{culture}", "GET");
            Endpoints[533] = CreateEndpoint("/BackupRestore/BackupPolicies/{backupPolicyName}", "GET");
            Endpoints[534] = CreateEndpoint("/certificates/issuers/{issuer-name}", "DELETE");
            Endpoints[535] = CreateEndpoint("/certificates/issuers/{issuer-name}", "PUT");
            Endpoints[536] = CreateEndpoint("/certificates/issuers/{issuer-name}", "GET");
            Endpoints[537] = CreateEndpoint("/certificates/issuers/{issuer-name}", "PATCH");
            Endpoints[538] = CreateEndpoint("/webhdfs/v1/{directFilePath}", "POST");
            Endpoints[539] = CreateEndpoint("/webhdfs/v1/{filePath}", "DELETE");
            Endpoints[540] = CreateEndpoint("/webhdfs/v1/{path}", "GET");
            Endpoints[541] = CreateEndpoint("/webhdfs/v1/{setPermissionFilePath}", "PUT");
            Endpoints[542] = CreateEndpoint("/webhdfs/va/{getContentSummaryFilePath}", "GET");
            Endpoints[543] = CreateEndpoint("/BackupRestore/BackupPolicies/{backupPolicyName}/$/Delete", "POST");
            Endpoints[544] = CreateEndpoint("/BackupRestore/BackupPolicies/{backupPolicyName}/$/GetBackupEnabledEntities", "GET");
            Endpoints[545] = CreateEndpoint("/BackupRestore/BackupPolicies/{backupPolicyName}/$/Update", "POST");
            Endpoints[546] = CreateEndpoint("/EventsStore/Applications/{applicationId}/$/Events", "GET");
            Endpoints[547] = CreateEndpoint("/EventsStore/CorrelatedEvents/{eventInstanceId}/$/Events", "GET");
            Endpoints[548] = CreateEndpoint("/EventsStore/Nodes/{nodeName}/$/Events", "GET");
            Endpoints[549] = CreateEndpoint("/EventsStore/Partitions/{partitionId}/$/Events", "GET");
            Endpoints[550] = CreateEndpoint("/EventsStore/Services/{serviceId}/$/Events", "GET");
            Endpoints[551] = CreateEndpoint("/Faults/Nodes/{nodeName}/$/GetTransitionProgress", "GET");
            Endpoints[552] = CreateEndpoint("/Faults/Nodes/{nodeName}/$/StartTransition/", "POST");
            Endpoints[553] = CreateEndpoint("/EventsStore/Partitions/{partitionId}/$/Replicas/Events", "GET");
            Endpoints[554] = CreateEndpoint("/Services/$/{serviceId}/$/GetPartitions/$/Recover", "POST");
            Endpoints[555] = CreateEndpoint("/EventsStore/Partitions/{partitionId}/$/Replicas/{replicaId}/$/Events", "GET");
            Endpoints[556] = CreateEndpoint("/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/GetDataLossProgress", "GET");
            Endpoints[557] = CreateEndpoint("/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/GetQuorumLossProgress", "GET");
            Endpoints[558] = CreateEndpoint("/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/GetRestartProgress", "GET");
            Endpoints[559] = CreateEndpoint("/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/StartDataLoss", "POST");
            Endpoints[560] = CreateEndpoint("/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/StartQuorumLoss", "POST");
            Endpoints[561] = CreateEndpoint("/Faults/Services/{serviceId}/$/GetPartitions/{partitionId}/$/StartRestart", "POST");
            Endpoints[562] = CreateEndpoint("/apis/{apiId}", "GET");
            Endpoints[563] = CreateEndpoint("/apis/{apiId}", "PUT");
            Endpoints[564] = CreateEndpoint("/apis/{apiId}", "PATCH");
            Endpoints[565] = CreateEndpoint("/apis/{apiId}", "DELETE");
            Endpoints[566] = CreateEndpoint("/Applications/{applicationId}", "GET");
            Endpoints[567] = CreateEndpoint("/ApplicationTypes/{applicationTypeName}", "GET");
            Endpoints[568] = CreateEndpoint("/apps/{appId}", "PUT");
            Endpoints[569] = CreateEndpoint("/apps/{appId}", "GET");
            Endpoints[570] = CreateEndpoint("/apps/{appId}", "DELETE");
            Endpoints[571] = CreateEndpoint("/authorizationServers/{authsid}", "PUT");
            Endpoints[572] = CreateEndpoint("/authorizationServers/{authsid}", "PATCH");
            Endpoints[573] = CreateEndpoint("/authorizationServers/{authsid}", "DELETE");
            Endpoints[574] = CreateEndpoint("/authorizationServers/{authsid}", "GET");
            Endpoints[575] = CreateEndpoint("/backends/{backendid}", "PUT");
            Endpoints[576] = CreateEndpoint("/backends/{backendid}", "PATCH");
            Endpoints[577] = CreateEndpoint("/backends/{backendid}", "DELETE");
            Endpoints[578] = CreateEndpoint("/backends/{backendid}", "GET");
            Endpoints[579] = CreateEndpoint("/certificates/{certificateId}", "GET");
            Endpoints[580] = CreateEndpoint("/certificates/{certificateId}", "PUT");
            Endpoints[581] = CreateEndpoint("/certificates/{certificate-name}", "DELETE");
            Endpoints[582] = CreateEndpoint("/ComposeDeployments/{deploymentName}", "GET");
            Endpoints[583] = CreateEndpoint("/deletedcertificates/{certificate-name}", "GET");
            Endpoints[584] = CreateEndpoint("/deletedcertificates/{certificate-name}", "DELETE");
            Endpoints[585] = CreateEndpoint("/deletedkeys/{key-name}", "DELETE");
            Endpoints[586] = CreateEndpoint("/deletedkeys/{key-name}", "GET");
            Endpoints[587] = CreateEndpoint("/deletedsecrets/{secret-name}", "DELETE");
            Endpoints[588] = CreateEndpoint("/deletedsecrets/{secret-name}", "GET");
            Endpoints[589] = CreateEndpoint("/deletedstorage/{storage-account-name}", "DELETE");
            Endpoints[590] = CreateEndpoint("/deletedstorage/{storage-account-name}", "GET");
            Endpoints[591] = CreateEndpoint("/domains/{domainId}", "GET");
            Endpoints[592] = CreateEndpoint("/facelists/{faceListId}", "PATCH");
            Endpoints[593] = CreateEndpoint("/facelists/{faceListId}", "DELETE");
            Endpoints[594] = CreateEndpoint("/facelists/{faceListId}", "PUT");
            Endpoints[595] = CreateEndpoint("/facelists/{faceListId}", "GET");
            Endpoints[596] = CreateEndpoint("/groups/{groupId}", "PATCH");
            Endpoints[597] = CreateEndpoint("/groups/{groupId}", "PUT");
            Endpoints[598] = CreateEndpoint("/groups/{groupId}", "GET");
            Endpoints[599] = CreateEndpoint("/groups/{groupId}", "DELETE");
            Endpoints[600] = CreateEndpoint("/identityProviders/{identityProviderName}", "DELETE");
            Endpoints[601] = CreateEndpoint("/identityProviders/{identityProviderName}", "GET");
            Endpoints[602] = CreateEndpoint("/identityProviders/{identityProviderName}", "PUT");
            Endpoints[603] = CreateEndpoint("/identityProviders/{identityProviderName}", "PATCH");
            Endpoints[604] = CreateEndpoint("/ImageStore/{contentPath}", "PUT");
            Endpoints[605] = CreateEndpoint("/ImageStore/{contentPath}", "DELETE");
            Endpoints[606] = CreateEndpoint("/ImageStore/{contentPath}", "GET");
            Endpoints[607] = CreateEndpoint("/jobs/{jobId}", "DELETE");
            Endpoints[608] = CreateEndpoint("/jobs/{jobIdentity}", "PATCH");
            Endpoints[609] = CreateEndpoint("/Jobs/{jobIdentity}", "PUT");
            Endpoints[610] = CreateEndpoint("/Jobs/{jobIdentity}", "GET");
            Endpoints[611] = CreateEndpoint("/jobschedules/{jobScheduleId}", "HEAD");
            Endpoints[612] = CreateEndpoint("/jobschedules/{jobScheduleId}", "PATCH");
            Endpoints[613] = CreateEndpoint("/jobschedules/{jobScheduleId}", "DELETE");
            Endpoints[614] = CreateEndpoint("/jobschedules/{jobScheduleId}", "GET");
            Endpoints[615] = CreateEndpoint("/jobschedules/{jobScheduleId}", "PUT");
            Endpoints[616] = CreateEndpoint("/keys/{key-name}", "PUT");
            Endpoints[617] = CreateEndpoint("/keys/{key-name}", "DELETE");
            Endpoints[618] = CreateEndpoint("/loggers/{loggerid}", "DELETE");
            Endpoints[619] = CreateEndpoint("/loggers/{loggerid}", "PATCH");
            Endpoints[620] = CreateEndpoint("/loggers/{loggerid}", "PUT");
            Endpoints[621] = CreateEndpoint("/loggers/{loggerid}", "GET");
            Endpoints[622] = CreateEndpoint("/Names/{nameId}", "GET");
            Endpoints[623] = CreateEndpoint("/Names/{nameId}", "DELETE");
            Endpoints[624] = CreateEndpoint("/Nodes/{nodeName}", "GET");
            Endpoints[625] = CreateEndpoint("/openidConnectProviders/{opid}", "PATCH");
            Endpoints[626] = CreateEndpoint("/openidConnectProviders/{opid}", "PUT");
            Endpoints[627] = CreateEndpoint("/openidConnectProviders/{opid}", "GET");
            Endpoints[628] = CreateEndpoint("/openidConnectProviders/{opid}", "DELETE");
            Endpoints[629] = CreateEndpoint("/Partitions/{partitionId}", "GET");
            Endpoints[630] = CreateEndpoint("/persongroups/{personGroupId}", "PUT");
            Endpoints[631] = CreateEndpoint("/persongroups/{personGroupId}", "GET");
            Endpoints[632] = CreateEndpoint("/persongroups/{personGroupId}", "PATCH");
            Endpoints[633] = CreateEndpoint("/persongroups/{personGroupId}", "DELETE");
            Endpoints[634] = CreateEndpoint("/pipelines/{pipelineIdentity}", "GET");
            Endpoints[635] = CreateEndpoint("/policies/{policyId}", "GET");
            Endpoints[636] = CreateEndpoint("/policies/{policyId}", "PUT");
            Endpoints[637] = CreateEndpoint("/policies/{policyId}", "DELETE");
            Endpoints[638] = CreateEndpoint("/pools/{poolId}", "PATCH");
            Endpoints[639] = CreateEndpoint("/pools/{poolId}", "DELETE");
            Endpoints[640] = CreateEndpoint("/pools/{poolId}", "HEAD");
            Endpoints[641] = CreateEndpoint("/pools/{poolId}", "GET");
            Endpoints[642] = CreateEndpoint("/products/{productId}", "PATCH");
            Endpoints[643] = CreateEndpoint("/products/{productId}", "PUT");
            Endpoints[644] = CreateEndpoint("/products/{productId}", "DELETE");
            Endpoints[645] = CreateEndpoint("/products/{productId}", "GET");
            Endpoints[646] = CreateEndpoint("/projects/{projectId}", "PATCH");
            Endpoints[647] = CreateEndpoint("/projects/{projectId}", "DELETE");
            Endpoints[648] = CreateEndpoint("/projects/{projectId}", "GET");
            Endpoints[649] = CreateEndpoint("/properties/{propId}", "DELETE");
            Endpoints[650] = CreateEndpoint("/properties/{propId}", "PATCH");
            Endpoints[651] = CreateEndpoint("/properties/{propId}", "PUT");
            Endpoints[652] = CreateEndpoint("/properties/{propId}", "GET");
            Endpoints[653] = CreateEndpoint("/quotas/{quotaCounterKey}", "GET");
            Endpoints[654] = CreateEndpoint("/quotas/{quotaCounterKey}", "PATCH");
            Endpoints[655] = CreateEndpoint("/recurrences/{recurrenceIdentity}", "GET");
            Endpoints[656] = CreateEndpoint("/secrets/{secret-name}", "PUT");
            Endpoints[657] = CreateEndpoint("/secrets/{secret-name}", "DELETE");
            Endpoints[658] = CreateEndpoint("/storage/{storage-account-name}", "PATCH");
            Endpoints[659] = CreateEndpoint("/storage/{storage-account-name}", "PUT");
            Endpoints[660] = CreateEndpoint("/storage/{storage-account-name}", "GET");
            Endpoints[661] = CreateEndpoint("/storage/{storage-account-name}", "DELETE");
            Endpoints[662] = CreateEndpoint("/subscriptions/{sid}", "PATCH");
            Endpoints[663] = CreateEndpoint("/subscriptions/{subscriptionId}", "GET");
            Endpoints[664] = CreateEndpoint("/subscriptions/{subscriptionId}", "DELETE");
            Endpoints[665] = CreateEndpoint("/subscriptions/{subscriptionId}", "PUT");
            Endpoints[666] = CreateEndpoint("/templates/{templateName}", "PATCH");
            Endpoints[667] = CreateEndpoint("/templates/{templateName}", "PUT");
            Endpoints[668] = CreateEndpoint("/templates/{templateName}", "GET");
            Endpoints[669] = CreateEndpoint("/templates/{templateName}", "DELETE");
            Endpoints[670] = CreateEndpoint("/tenant/{accessName}", "GET");
            Endpoints[671] = CreateEndpoint("/tenant/{accessName}", "PATCH");
            Endpoints[672] = CreateEndpoint("/textOperations/{operationId}", "GET");
            Endpoints[673] = CreateEndpoint("/users/{uid}", "GET");
            Endpoints[674] = CreateEndpoint("/users/{uid}", "PUT");
            Endpoints[675] = CreateEndpoint("/users/{uid}", "PATCH");
            Endpoints[676] = CreateEndpoint("/users/{uid}", "DELETE");
            Endpoints[677] = CreateEndpoint("/WebHdfsExt/{path}", "PUT");
            Endpoints[678] = CreateEndpoint("/WebHdfsExt/{path}", "POST");
            Endpoints[679] = CreateEndpoint("/apis/{apiId}/operations", "GET");
            Endpoints[680] = CreateEndpoint("/apis/{apiId}/policies", "GET");
            Endpoints[681] = CreateEndpoint("/apis/{apiId}/products", "GET");
            Endpoints[682] = CreateEndpoint("/apis/{apiId}/schemas", "GET");
            Endpoints[683] = CreateEndpoint("/apps/{appId}/endpoints", "GET");
            Endpoints[684] = CreateEndpoint("/apps/{appId}/metrics", "POST");
            Endpoints[685] = CreateEndpoint("/apps/{appId}/permissions", "DELETE");
            Endpoints[686] = CreateEndpoint("/apps/{appId}/permissions", "GET");
            Endpoints[687] = CreateEndpoint("/apps/{appId}/permissions", "POST");
            Endpoints[688] = CreateEndpoint("/apps/{appId}/permissions", "PUT");
            Endpoints[689] = CreateEndpoint("/apps/{appId}/publish", "POST");
            Endpoints[690] = CreateEndpoint("/apps/{appId}/publishsettings", "GET");
            Endpoints[691] = CreateEndpoint("/apps/{appId}/publishsettings", "PUT");
            Endpoints[692] = CreateEndpoint("/apps/{appId}/query", "GET");
            Endpoints[693] = CreateEndpoint("/apps/{appId}/query", "POST");
            Endpoints[694] = CreateEndpoint("/apps/{appId}/querylogs", "GET");
            Endpoints[695] = CreateEndpoint("/apps/{appId}/settings", "GET");
            Endpoints[696] = CreateEndpoint("/apps/{appId}/settings", "PUT");
            Endpoints[697] = CreateEndpoint("/apps/{appId}/versions", "GET");
            Endpoints[698] = CreateEndpoint("/certificates/{certificate-name}/create", "POST");
            Endpoints[699] = CreateEndpoint("/certificates/{certificate-name}/import", "POST");
            Endpoints[700] = CreateEndpoint("/certificates/{certificate-name}/pending", "PATCH");
            Endpoints[701] = CreateEndpoint("/certificates/{certificate-name}/pending", "GET");
            Endpoints[702] = CreateEndpoint("/certificates/{certificate-name}/pending", "DELETE");
            Endpoints[703] = CreateEndpoint("/certificates/{certificate-name}/policy", "GET");
            Endpoints[704] = CreateEndpoint("/certificates/{certificate-name}/policy", "PATCH");
            Endpoints[705] = CreateEndpoint("/certificates/{certificate-name}/versions", "GET");
            Endpoints[706] = CreateEndpoint("/delegatedProviders/{delegatedProviderId}/offers", "GET");
            Endpoints[707] = CreateEndpoint("/deletedcertificates/{certificate-name}/recover", "POST");
            Endpoints[708] = CreateEndpoint("/deletedkeys/{key-name}/recover", "POST");
            Endpoints[709] = CreateEndpoint("/deletedsecrets/{secret-name}/recover", "POST");
            Endpoints[710] = CreateEndpoint("/deletedstorage/{storage-account-name}/recover", "POST");
            Endpoints[711] = CreateEndpoint("/deletedstorage/{storage-account-name}/sas", "GET");
            Endpoints[712] = CreateEndpoint("/facelists/{faceListId}/persistedFaces", "POST");
            Endpoints[713] = CreateEndpoint("/groups/{groupId}/users", "GET");
            Endpoints[714] = CreateEndpoint("/jobs/{jobId}/addtaskcollection", "POST");
            Endpoints[715] = CreateEndpoint("/jobs/{jobId}/disable", "POST");
            Endpoints[716] = CreateEndpoint("/jobs/{jobId}/enable", "POST");
            Endpoints[717] = CreateEndpoint("/jobs/{jobId}/jobpreparationandreleasetaskstatus", "GET");
            Endpoints[718] = CreateEndpoint("/jobs/{jobId}/taskcounts", "GET");
            Endpoints[719] = CreateEndpoint("/jobs/{jobId}/tasks", "GET");
            Endpoints[720] = CreateEndpoint("/jobs/{jobId}/tasks", "POST");
            Endpoints[721] = CreateEndpoint("/jobs/{jobId}/terminate", "POST");
            Endpoints[722] = CreateEndpoint("/Jobs/{jobIdentity}/CancelJob", "POST");
            Endpoints[723] = CreateEndpoint("/Jobs/{jobIdentity}/GetDebugDataPath", "POST");
            Endpoints[724] = CreateEndpoint("/Jobs/{jobIdentity}/GetDebugDataPath", "GET");
            Endpoints[725] = CreateEndpoint("/Jobs/{jobIdentity}/GetStatistics", "GET");
            Endpoints[726] = CreateEndpoint("/Jobs/{jobIdentity}/GetStatistics", "POST");
            Endpoints[727] = CreateEndpoint("/jobs/{jobIdentity}/YieldJob", "POST");
            Endpoints[728] = CreateEndpoint("/jobschedules/{jobScheduleId}/disable", "POST");
            Endpoints[729] = CreateEndpoint("/jobschedules/{jobScheduleId}/enable", "POST");
            Endpoints[730] = CreateEndpoint("/jobschedules/{jobScheduleId}/jobs", "GET");
            Endpoints[731] = CreateEndpoint("/jobschedules/{jobScheduleId}/terminate", "POST");
            Endpoints[732] = CreateEndpoint("/keys/{key-name}/backup", "POST");
            Endpoints[733] = CreateEndpoint("/keys/{key-name}/create", "POST");
            Endpoints[734] = CreateEndpoint("/keys/{key-name}/versions", "GET");
            Endpoints[735] = CreateEndpoint("/models/{model}/analyze", "POST");
            Endpoints[736] = CreateEndpoint("/persongroups/{personGroupId}/persons", "POST");
            Endpoints[737] = CreateEndpoint("/persongroups/{personGroupId}/persons", "GET");
            Endpoints[738] = CreateEndpoint("/persongroups/{personGroupId}/train", "POST");
            Endpoints[739] = CreateEndpoint("/persongroups/{personGroupId}/training", "GET");
            Endpoints[740] = CreateEndpoint("/pools/{poolId}/disableautoscale", "POST");
            Endpoints[741] = CreateEndpoint("/pools/{poolId}/enableautoscale", "POST");
            Endpoints[742] = CreateEndpoint("/pools/{poolId}/evaluateautoscale", "POST");
            Endpoints[743] = CreateEndpoint("/pools/{poolId}/nodes", "GET");
            Endpoints[744] = CreateEndpoint("/pools/{poolId}/removenodes", "POST");
            Endpoints[745] = CreateEndpoint("/pools/{poolId}/resize", "POST");
            Endpoints[746] = CreateEndpoint("/pools/{poolId}/stopresize", "POST");
            Endpoints[747] = CreateEndpoint("/pools/{poolId}/updateproperties", "POST");
            Endpoints[748] = CreateEndpoint("/pools/{poolId}/upgradeos", "POST");
            Endpoints[749] = CreateEndpoint("/products/{productId}/apis", "GET");
            Endpoints[750] = CreateEndpoint("/products/{productId}/groups", "GET");
            Endpoints[751] = CreateEndpoint("/products/{productId}/policies", "GET");
            Endpoints[752] = CreateEndpoint("/products/{productId}/subscriptions", "GET");
            Endpoints[753] = CreateEndpoint("/projects/{projectId}/images", "DELETE");
            Endpoints[754] = CreateEndpoint("/projects/{projectId}/images", "POST");
            Endpoints[755] = CreateEndpoint("/projects/{projectId}/iterations", "GET");
            Endpoints[756] = CreateEndpoint("/projects/{projectId}/predictions", "DELETE");
            Endpoints[757] = CreateEndpoint("/projects/{projectId}/tags", "POST");
            Endpoints[758] = CreateEndpoint("/projects/{projectId}/tags", "GET");
            Endpoints[759] = CreateEndpoint("/projects/{projectId}/train", "POST");
            Endpoints[760] = CreateEndpoint("/providers/{resourceProviderNamespace}/operations", "GET");
            Endpoints[761] = CreateEndpoint("/secrets/{secret-name}/backup", "POST");
            Endpoints[762] = CreateEndpoint("/secrets/{secret-name}/versions", "GET");
            Endpoints[763] = CreateEndpoint("/storage/{storage-account-name}/backup", "POST");
            Endpoints[764] = CreateEndpoint("/storage/{storage-account-name}/regeneratekey", "POST");
            Endpoints[765] = CreateEndpoint("/storage/{storage-account-name}/sas", "GET");
            Endpoints[766] = CreateEndpoint("/subscriptions/{sid}/regeneratePrimaryKey", "POST");
            Endpoints[767] = CreateEndpoint("/subscriptions/{sid}/regenerateSecondaryKey", "POST");
            Endpoints[768] = CreateEndpoint("/subscriptions/{subscriptionId}/locations", "GET");
            Endpoints[769] = CreateEndpoint("/subscriptions/{subscriptionId}/providers", "GET");
            Endpoints[770] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups", "GET");
            Endpoints[771] = CreateEndpoint("/subscriptions/{subscriptionId}/resources", "GET");
            Endpoints[772] = CreateEndpoint("/subscriptions/{subscriptionId}/tagNames", "GET");
            Endpoints[773] = CreateEndpoint("/tenant/{accessName}/git", "GET");
            Endpoints[774] = CreateEndpoint("/tenant/{accessName}/regeneratePrimaryKey", "POST");
            Endpoints[775] = CreateEndpoint("/tenant/{accessName}/regenerateSecondaryKey", "POST");
            Endpoints[776] = CreateEndpoint("/tenant/{configurationName}/deploy", "POST");
            Endpoints[777] = CreateEndpoint("/tenant/{configurationName}/save", "POST");
            Endpoints[778] = CreateEndpoint("/tenant/{configurationName}/syncState", "GET");
            Endpoints[779] = CreateEndpoint("/tenant/{configurationName}/validate", "POST");
            Endpoints[780] = CreateEndpoint("/users/{uid}/generateSsoUrl", "POST");
            Endpoints[781] = CreateEndpoint("/users/{uid}/groups", "GET");
            Endpoints[782] = CreateEndpoint("/users/{uid}/identities", "GET");
            Endpoints[783] = CreateEndpoint("/users/{uid}/subscriptions", "GET");
            Endpoints[784] = CreateEndpoint("/users/{uid}/token", "POST");
            Endpoints[785] = CreateEndpoint("/workspaces/{workspaceId}/query", "GET");
            Endpoints[786] = CreateEndpoint("/workspaces/{workspaceId}/query", "POST");
            Endpoints[787] = CreateEndpoint("/Applications/{applicationId}/$/Delete", "POST");
            Endpoints[788] = CreateEndpoint("/Applications/{applicationId}/$/DisableBackup", "POST");
            Endpoints[789] = CreateEndpoint("/Applications/{applicationId}/$/EnableBackup", "POST");
            Endpoints[790] = CreateEndpoint("/Applications/{applicationId}/$/GetBackupConfigurationInfo", "GET");
            Endpoints[791] = CreateEndpoint("/Applications/{applicationId}/$/GetBackups", "GET");
            Endpoints[792] = CreateEndpoint("/Applications/{applicationId}/$/GetHealth", "POST");
            Endpoints[793] = CreateEndpoint("/Applications/{applicationId}/$/GetHealth", "GET");
            Endpoints[794] = CreateEndpoint("/Applications/{applicationId}/$/GetLoadInformation", "GET");
            Endpoints[795] = CreateEndpoint("/Applications/{applicationId}/$/GetServices", "GET");
            Endpoints[796] = CreateEndpoint("/Applications/{applicationId}/$/GetUpgradeProgress", "GET");
            Endpoints[797] = CreateEndpoint("/Applications/{applicationId}/$/MoveToNextUpgradeDomain", "POST");
            Endpoints[798] = CreateEndpoint("/Applications/{applicationId}/$/ReportHealth", "POST");
            Endpoints[799] = CreateEndpoint("/Applications/{applicationId}/$/ResumeBackup", "POST");
            Endpoints[800] = CreateEndpoint("/Applications/{applicationId}/$/RollbackUpgrade", "POST");
            Endpoints[801] = CreateEndpoint("/Applications/{applicationId}/$/SuspendBackup", "POST");
            Endpoints[802] = CreateEndpoint("/Applications/{applicationId}/$/UpdateUpgrade", "POST");
            Endpoints[803] = CreateEndpoint("/Applications/{applicationId}/$/Upgrade", "POST");
            Endpoints[804] = CreateEndpoint("/Applications/{applicationName}/$/MoveNextUpgradeDomain", "POST");
            Endpoints[805] = CreateEndpoint("/ApplicationTypes/{applicationTypeName}/$/GetApplicationManifest", "GET");
            Endpoints[806] = CreateEndpoint("/ApplicationTypes/{applicationTypeName}/$/GetServiceManifest", "GET");
            Endpoints[807] = CreateEndpoint("/ApplicationTypes/{applicationTypeName}/$/GetServiceTypes", "GET");
            Endpoints[808] = CreateEndpoint("/ApplicationTypes/{applicationTypeName}/$/Unprovision", "POST");
            Endpoints[809] = CreateEndpoint("/apps/{appId}/events/$metadata", "GET");
            Endpoints[810] = CreateEndpoint("/apps/{appId}/metrics/metadata", "GET");
            Endpoints[811] = CreateEndpoint("/apps/{appId}/query/schema", "GET");
            Endpoints[812] = CreateEndpoint("/apps/{appId}/versions/import", "POST");
            Endpoints[813] = CreateEndpoint("/certificates/{certificate-name}/pending/merge", "POST");
            Endpoints[814] = CreateEndpoint("/ComposeDeployments/{deploymentName}/$/Delete", "POST");
            Endpoints[815] = CreateEndpoint("/ComposeDeployments/{deploymentName}/$/GetUpgradeProgress", "GET");
            Endpoints[816] = CreateEndpoint("/ComposeDeployments/{deploymentName}/$/Upgrade", "POST");
            Endpoints[817] = CreateEndpoint("/ImageStore/{contentPath}/$/GetUploadSession", "GET");
            Endpoints[818] = CreateEndpoint("/ImageStore/{contentPath}/$/UploadChunk", "PUT");
            Endpoints[819] = CreateEndpoint("/Names/{nameId}/$/GetProperties", "GET");
            Endpoints[820] = CreateEndpoint("/Names/{nameId}/$/GetProperty", "DELETE");
            Endpoints[821] = CreateEndpoint("/Names/{nameId}/$/GetProperty", "PUT");
            Endpoints[822] = CreateEndpoint("/Names/{nameId}/$/GetProperty", "GET");
            Endpoints[823] = CreateEndpoint("/Names/{nameId}/$/GetSubNames", "GET");
            Endpoints[824] = CreateEndpoint("/Nodes/{nodeName}/$/Activate", "POST");
            Endpoints[825] = CreateEndpoint("/Nodes/{nodeName}/$/Deactivate", "POST");
            Endpoints[826] = CreateEndpoint("/Nodes/{nodeName}/$/DeployServicePackage", "POST");
            Endpoints[827] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications", "GET");
            Endpoints[828] = CreateEndpoint("/Nodes/{nodeName}/$/GetHealth", "GET");
            Endpoints[829] = CreateEndpoint("/Nodes/{nodeName}/$/GetHealth", "POST");
            Endpoints[830] = CreateEndpoint("/Nodes/{nodeName}/$/GetLoadInformation", "GET");
            Endpoints[831] = CreateEndpoint("/Nodes/{nodeName}/$/RemoveNodeState", "POST");
            Endpoints[832] = CreateEndpoint("/Nodes/{nodeName}/$/ReportHealth", "POST");
            Endpoints[833] = CreateEndpoint("/Nodes/{nodeName}/$/Restart", "POST");
            Endpoints[834] = CreateEndpoint("/Nodes/{nodeName}/$/Start", "POST");
            Endpoints[835] = CreateEndpoint("/Nodes/{nodeName}/$/Stop", "POST");
            Endpoints[836] = CreateEndpoint("/Partitions/{partitionId}/$/Backup", "POST");
            Endpoints[837] = CreateEndpoint("/Partitions/{partitionId}/$/DisableBackup", "POST");
            Endpoints[838] = CreateEndpoint("/Partitions/{partitionId}/$/EnableBackup", "POST");
            Endpoints[839] = CreateEndpoint("/Partitions/{partitionId}/$/GetBackupConfigurationInfo", "GET");
            Endpoints[840] = CreateEndpoint("/Partitions/{partitionId}/$/GetBackupProgress", "GET");
            Endpoints[841] = CreateEndpoint("/Partitions/{partitionId}/$/GetBackups", "GET");
            Endpoints[842] = CreateEndpoint("/Partitions/{partitionId}/$/GetHealth", "POST");
            Endpoints[843] = CreateEndpoint("/Partitions/{partitionId}/$/GetHealth", "GET");
            Endpoints[844] = CreateEndpoint("/Partitions/{partitionId}/$/GetLoadInformation", "GET");
            Endpoints[845] = CreateEndpoint("/Partitions/{partitionId}/$/GetReplicas", "GET");
            Endpoints[846] = CreateEndpoint("/Partitions/{partitionId}/$/GetRestoreProgress", "GET");
            Endpoints[847] = CreateEndpoint("/Partitions/{partitionId}/$/GetServiceName", "GET");
            Endpoints[848] = CreateEndpoint("/Partitions/{partitionId}/$/Recover", "POST");
            Endpoints[849] = CreateEndpoint("/Partitions/{partitionId}/$/ReportHealth", "POST");
            Endpoints[850] = CreateEndpoint("/Partitions/{partitionId}/$/ResetLoad", "POST");
            Endpoints[851] = CreateEndpoint("/Partitions/{partitionId}/$/Restore", "POST");
            Endpoints[852] = CreateEndpoint("/Partitions/{partitionId}/$/ResumeBackup", "POST");
            Endpoints[853] = CreateEndpoint("/Partitions/{partitionId}/$/SuspendBackup", "POST");
            Endpoints[854] = CreateEndpoint("/projects/{projectId}/images/files", "POST");
            Endpoints[855] = CreateEndpoint("/projects/{projectId}/images/id", "GET");
            Endpoints[856] = CreateEndpoint("/projects/{projectId}/images/predictions", "POST");
            Endpoints[857] = CreateEndpoint("/projects/{projectId}/images/regions", "DELETE");
            Endpoints[858] = CreateEndpoint("/projects/{projectId}/images/regions", "POST");
            Endpoints[859] = CreateEndpoint("/projects/{projectId}/images/tagged", "GET");
            Endpoints[860] = CreateEndpoint("/projects/{projectId}/images/tags", "DELETE");
            Endpoints[861] = CreateEndpoint("/projects/{projectId}/images/tags", "POST");
            Endpoints[862] = CreateEndpoint("/projects/{projectId}/images/untagged", "GET");
            Endpoints[863] = CreateEndpoint("/projects/{projectId}/images/urls", "POST");
            Endpoints[864] = CreateEndpoint("/projects/{projectId}/predictions/query", "POST");
            Endpoints[865] = CreateEndpoint("/projects/{projectId}/quicktest/image", "POST");
            Endpoints[866] = CreateEndpoint("/projects/{projectId}/quicktest/url", "POST");
            Endpoints[867] = CreateEndpoint("/Services/{serviceId}/$/Delete", "POST");
            Endpoints[868] = CreateEndpoint("/Services/{serviceId}/$/DisableBackup", "POST");
            Endpoints[869] = CreateEndpoint("/Services/{serviceId}/$/EnableBackup", "POST");
            Endpoints[870] = CreateEndpoint("/Services/{serviceId}/$/GetApplicationName", "GET");
            Endpoints[871] = CreateEndpoint("/Services/{serviceId}/$/GetBackupConfigurationInfo", "GET");
            Endpoints[872] = CreateEndpoint("/Services/{serviceId}/$/GetBackups", "GET");
            Endpoints[873] = CreateEndpoint("/Services/{serviceId}/$/GetDescription", "GET");
            Endpoints[874] = CreateEndpoint("/Services/{serviceId}/$/GetHealth", "POST");
            Endpoints[875] = CreateEndpoint("/Services/{serviceId}/$/GetHealth", "GET");
            Endpoints[876] = CreateEndpoint("/Services/{serviceId}/$/GetPartitions", "GET");
            Endpoints[877] = CreateEndpoint("/Services/{serviceId}/$/ReportHealth", "POST");
            Endpoints[878] = CreateEndpoint("/Services/{serviceId}/$/ResolvePartition", "GET");
            Endpoints[879] = CreateEndpoint("/Services/{serviceId}/$/ResumeBackup", "POST");
            Endpoints[880] = CreateEndpoint("/Services/{serviceId}/$/SuspendBackup", "POST");
            Endpoints[881] = CreateEndpoint("/Services/{serviceId}/$/Update", "POST");
            Endpoints[882] = CreateEndpoint("/tenant/{accessName}/git/regeneratePrimaryKey", "POST");
            Endpoints[883] = CreateEndpoint("/tenant/{accessName}/git/regenerateSecondaryKey", "POST");
            Endpoints[884] = CreateEndpoint("/projects/{projectId}/images/tagged/count", "GET");
            Endpoints[885] = CreateEndpoint("/projects/{projectId}/images/untagged/count", "GET");
            Endpoints[886] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.AAD/domainServices", "GET");
            Endpoints[887] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/configurations", "GET");
            Endpoints[888] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/configurations", "PUT");
            Endpoints[889] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/generateRecommendations", "POST");
            Endpoints[890] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/recommendations", "GET");
            Endpoints[891] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/suppressions", "GET");
            Endpoints[892] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/servers", "GET");
            Endpoints[893] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/skus", "GET");
            Endpoints[894] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ApiManagement/checkNameAvailability", "POST");
            Endpoints[895] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ApiManagement/service", "GET");
            Endpoints[896] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/classicAdministrators", "GET");
            Endpoints[897] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks", "GET");
            Endpoints[898] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyAssignments", "GET");
            Endpoints[899] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions", "GET");
            Endpoints[900] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions", "GET");
            Endpoints[901] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments", "GET");
            Endpoints[902] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Automation/automationAccounts", "GET");
            Endpoints[903] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/batchAccounts", "GET");
            Endpoints[904] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/clusters", "GET");
            Endpoints[905] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/fileServers", "GET");
            Endpoints[906] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/jobs", "GET");
            Endpoints[907] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/workspaces", "GET");
            Endpoints[908] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/billingPeriods", "GET");
            Endpoints[909] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/invoices", "GET");
            Endpoints[910] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.BotService/botServices", "GET");
            Endpoints[911] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Cache/CheckNameAvailability", "POST");
            Endpoints[912] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Cache/Redis", "GET");
            Endpoints[913] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations", "GET");
            Endpoints[914] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs", "GET");
            Endpoints[915] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkNameAvailability", "POST");
            Endpoints[916] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkResourceUsage", "POST");
            Endpoints[917] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/profiles", "GET");
            Endpoints[918] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateProbe", "POST");
            Endpoints[919] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders", "GET");
            Endpoints[920] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation", "POST");
            Endpoints[921] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.CognitiveServices/accounts", "GET");
            Endpoints[922] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.CognitiveServices/skus", "GET");
            Endpoints[923] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Commerce.Admin/subscriberUsageAggregates", "GET");
            Endpoints[924] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Commerce.Admin/updateEncryption", "POST");
            Endpoints[925] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Commerce/RateCard", "GET");
            Endpoints[926] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Commerce/UsageAggregates", "GET");
            Endpoints[927] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/disks", "GET");
            Endpoints[928] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/galleries", "GET");
            Endpoints[929] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/images", "GET");
            Endpoints[930] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/skus", "GET");
            Endpoints[931] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/snapshots", "GET");
            Endpoints[932] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachines", "GET");
            Endpoints[933] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachineScaleSets", "GET");
            Endpoints[934] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/budgets", "GET");
            Endpoints[935] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/forecasts", "GET");
            Endpoints[936] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[937] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/reservationRecommendations", "GET");
            Endpoints[938] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[939] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/containerGroups", "GET");
            Endpoints[940] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/checkNameAvailability", "POST");
            Endpoints[941] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/registries", "GET");
            Endpoints[942] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/containerServices", "GET");
            Endpoints[943] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/managedClusters", "GET");
            Endpoints[944] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.CustomerInsights/hubs", "GET");
            Endpoints[945] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/jobs", "GET");
            Endpoints[946] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Databricks/workspaces", "GET");
            Endpoints[947] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataFactory/factories", "GET");
            Endpoints[948] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/accounts", "GET");
            Endpoints[949] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeStore/accounts", "GET");
            Endpoints[950] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/services", "GET");
            Endpoints[951] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/skus", "GET");
            Endpoints[952] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/checkNameAvailability", "POST");
            Endpoints[953] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/performanceTiers", "GET");
            Endpoints[954] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/servers", "GET");
            Endpoints[955] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/checkNameAvailability", "POST");
            Endpoints[956] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/performanceTiers", "GET");
            Endpoints[957] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/servers", "GET");
            Endpoints[958] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability", "POST");
            Endpoints[959] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkProvisioningServiceNameAvailability", "POST");
            Endpoints[960] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs", "GET");
            Endpoints[961] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/provisioningServices", "GET");
            Endpoints[962] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/usages", "GET");
            Endpoints[963] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DevTestLab/labs", "GET");
            Endpoints[964] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DevTestLab/schedules", "GET");
            Endpoints[965] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/databaseAccounts", "GET");
            Endpoints[966] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability", "POST");
            Endpoints[967] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains", "GET");
            Endpoints[968] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest", "POST");
            Endpoints[969] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations", "POST");
            Endpoints[970] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/topLevelDomains", "GET");
            Endpoints[971] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/validateDomainRegistrationInformation", "POST");
            Endpoints[972] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/eventSubscriptions", "GET");
            Endpoints[973] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/topics", "GET");
            Endpoints[974] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventHub/CheckNameAvailability", "POST");
            Endpoints[975] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventHub/CheckNamespaceAvailability", "POST");
            Endpoints[976] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventHub/namespaces", "GET");
            Endpoints[977] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Features/features", "GET");
            Endpoints[978] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.gallery.admin/galleryItems", "POST");
            Endpoints[979] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.gallery.admin/galleryItems", "GET");
            Endpoints[980] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.HanaOnAzure/hanaInstances", "GET");
            Endpoints[981] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/clusters", "GET");
            Endpoints[982] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ImportExport/jobs", "GET");
            Endpoints[983] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/actionGroups", "GET");
            Endpoints[984] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/activityLogAlerts", "GET");
            Endpoints[985] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/components", "GET");
            Endpoints[986] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/listMigrationdate", "POST");
            Endpoints[987] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles", "GET");
            Endpoints[988] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metricAlerts", "GET");
            Endpoints[989] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/migrateToNewPricingModel", "POST");
            Endpoints[990] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/rollbackToLegacyPricingModel", "POST");
            Endpoints[991] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/scheduledQueryRules", "GET");
            Endpoints[992] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/webtests", "GET");
            Endpoints[993] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.IoTCentral/checkNameAvailability", "POST");
            Endpoints[994] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.IoTCentral/IoTApps", "GET");
            Endpoints[995] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.IoTSpaces/checkNameAvailability", "POST");
            Endpoints[996] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.IoTSpaces/Graph", "GET");
            Endpoints[997] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/checkNameAvailability", "POST");
            Endpoints[998] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/deletedVaults", "GET");
            Endpoints[999] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/vaults", "GET");
            Endpoints[1000] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Logic/integrationAccounts", "GET");
            Endpoints[1001] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Logic/workflows", "GET");
            Endpoints[1002] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearning/commitmentPlans", "GET");
            Endpoints[1003] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearning/skus", "GET");
            Endpoints[1004] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearning/webServices", "GET");
            Endpoints[1005] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearning/workspaces", "GET");
            Endpoints[1006] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearningCompute/operationalizationClusters", "GET");
            Endpoints[1007] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearningExperimentation/accounts", "GET");
            Endpoints[1008] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearningServices/workspaces", "GET");
            Endpoints[1009] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ManagedIdentity/userAssignedIdentities", "GET");
            Endpoints[1010] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Maps/accounts", "GET");
            Endpoints[1011] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Media/CheckNameAvailability", "POST");
            Endpoints[1012] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Media/mediaservices", "GET");
            Endpoints[1013] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/adminLoadBalancers", "GET");
            Endpoints[1014] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/adminOverview", "GET");
            Endpoints[1015] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/adminPublicIpAddresses", "GET");
            Endpoints[1016] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/adminVirtualNetworks", "GET");
            Endpoints[1017] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableWafRuleSets", "GET");
            Endpoints[1018] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGateways", "GET");
            Endpoints[1019] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationSecurityGroups", "GET");
            Endpoints[1020] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/bgpServiceCommunities", "GET");
            Endpoints[1021] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/ddosProtectionPlans", "GET");
            Endpoints[1022] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/dnszones", "GET");
            Endpoints[1023] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteCircuits", "GET");
            Endpoints[1024] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteCrossConnections", "GET");
            Endpoints[1025] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteServiceProviders", "GET");
            Endpoints[1026] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/loadBalancers", "GET");
            Endpoints[1027] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkInterfaces", "GET");
            Endpoints[1028] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkSecurityGroups", "GET");
            Endpoints[1029] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkWatchers", "GET");
            Endpoints[1030] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/publicIPAddresses", "GET");
            Endpoints[1031] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/routeFilters", "GET");
            Endpoints[1032] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/routeTables", "GET");
            Endpoints[1033] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficmanagerprofiles", "GET");
            Endpoints[1034] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys", "DELETE");
            Endpoints[1035] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys", "PUT");
            Endpoints[1036] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys", "GET");
            Endpoints[1037] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualNetworks", "GET");
            Endpoints[1038] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.NotificationHubs/checkNamespaceAvailability", "POST");
            Endpoints[1039] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.NotificationHubs/namespaces", "GET");
            Endpoints[1040] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.OperationalInsights/linkTargets", "GET");
            Endpoints[1041] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.OperationalInsights/workspaces", "GET");
            Endpoints[1042] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.OperationsManagement/ManagementAssociations", "GET");
            Endpoints[1043] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.OperationsManagement/ManagementConfigurations", "GET");
            Endpoints[1044] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.OperationsManagement/solutions", "GET");
            Endpoints[1045] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PowerBI/workspaceCollections", "GET");
            Endpoints[1046] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PowerBIDedicated/capacities", "GET");
            Endpoints[1047] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PowerBIDedicated/skus", "GET");
            Endpoints[1048] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.RecoveryServices/vaults", "GET");
            Endpoints[1049] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Relay/checkNameAvailability", "POST");
            Endpoints[1050] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Relay/namespaces", "GET");
            Endpoints[1051] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ResourceHealth/availabilityStatuses", "GET");
            Endpoints[1052] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/links", "GET");
            Endpoints[1053] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Scheduler/jobCollections", "GET");
            Endpoints[1054] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Search/checkNameAvailability", "POST");
            Endpoints[1055] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/alerts", "GET");
            Endpoints[1056] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/autoProvisioningSettings", "GET");
            Endpoints[1057] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/discoveredSecuritySolutions", "GET");
            Endpoints[1058] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/externalSecuritySolutions", "GET");
            Endpoints[1059] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/jitNetworkAccessPolicies", "GET");
            Endpoints[1060] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations", "GET");
            Endpoints[1061] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings", "GET");
            Endpoints[1062] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/securityContacts", "GET");
            Endpoints[1063] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/tasks", "GET");
            Endpoints[1064] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/workspaceSettings", "GET");
            Endpoints[1065] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServerManagement/gateways", "GET");
            Endpoints[1066] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServerManagement/nodes", "GET");
            Endpoints[1067] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/CheckNameAvailability", "POST");
            Endpoints[1068] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/CheckNameSpaceAvailability", "POST");
            Endpoints[1069] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/namespaces", "GET");
            Endpoints[1070] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/premiumMessagingRegions", "GET");
            Endpoints[1071] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/clusters", "GET");
            Endpoints[1072] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.SignalRService/SignalR", "GET");
            Endpoints[1073] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Solutions/appliances", "GET");
            Endpoints[1074] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Solutions/applications", "GET");
            Endpoints[1075] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/checkNameAvailability", "POST");
            Endpoints[1076] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/managedInstances", "GET");
            Endpoints[1077] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/servers", "GET");
            Endpoints[1078] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage/checkNameAvailability", "POST");
            Endpoints[1079] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage/skus", "GET");
            Endpoints[1080] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage/storageAccounts", "GET");
            Endpoints[1081] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage/usages", "GET");
            Endpoints[1082] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.StorSimple/managers", "GET");
            Endpoints[1083] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.StreamAnalytics/streamingjobs", "GET");
            Endpoints[1084] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/checkNameAvailability", "POST");
            Endpoints[1085] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/delegatedProviders", "GET");
            Endpoints[1086] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/locations", "GET");
            Endpoints[1087] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/moveSubscriptions", "POST");
            Endpoints[1088] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/offers", "GET");
            Endpoints[1089] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/plans", "GET");
            Endpoints[1090] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/restoreData", "POST");
            Endpoints[1091] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions", "GET");
            Endpoints[1092] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/updateEncryption", "POST");
            Endpoints[1093] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/validateMoveSubscriptions", "POST");
            Endpoints[1094] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.TimeSeriesInsights/environments", "GET");
            Endpoints[1095] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.visualstudio/checkNameAvailability", "POST");
            Endpoints[1096] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks", "GET");
            Endpoints[1097] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/billingMeters", "GET");
            Endpoints[1098] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/certificates", "GET");
            Endpoints[1099] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability", "POST");
            Endpoints[1100] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/classicMobileServices", "GET");
            Endpoints[1101] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/connectionGateways", "GET");
            Endpoints[1102] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/customApis", "GET");
            Endpoints[1103] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites", "GET");
            Endpoints[1104] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/deploymentLocations", "GET");
            Endpoints[1105] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions", "GET");
            Endpoints[1106] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments", "GET");
            Endpoints[1107] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/ishostingenvironmentnameavailable", "GET");
            Endpoints[1108] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/listSitesAssignedToHostName", "POST");
            Endpoints[1109] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/managedHostingEnvironments", "GET");
            Endpoints[1110] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers", "GET");
            Endpoints[1111] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/publishingCredentials", "GET");
            Endpoints[1112] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/publishingCredentials", "PUT");
            Endpoints[1113] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations", "GET");
            Endpoints[1114] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/resourceHealthMetadata", "GET");
            Endpoints[1115] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms", "GET");
            Endpoints[1116] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites", "GET");
            Endpoints[1117] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/skus", "GET");
            Endpoints[1118] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/verifyHostingEnvironmentVnet", "POST");
            Endpoints[1119] = CreateEndpoint("/Applications/{applicationId}/$/GetServices/$/Create", "POST");
            Endpoints[1120] = CreateEndpoint("/Applications/{applicationId}/$/GetServices/$/CreateFromTemplate", "POST");
            Endpoints[1121] = CreateEndpoint("/Applications/{applicationName}/$/GetServiceGroups/$/CreateServiceGroupFromTemplate", "POST");
            Endpoints[1122] = CreateEndpoint("/Applications/{applicationName}/$/GetServices/$/CreateServiceGroup", "POST");
            Endpoints[1123] = CreateEndpoint("/Names/{nameId}/$/GetProperties/$/SubmitBatch", "POST");
            Endpoints[1124] = CreateEndpoint("/Services/{serviceName}/$/GetPartitions/$/Recover", "POST");
            Endpoints[1125] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/invoices/latest", "GET");
            Endpoints[1126] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/pricesheets/default", "GET");
            Endpoints[1127] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableSslOptions/default", "GET");
            Endpoints[1128] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset", "POST");
            Endpoints[1129] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/canonical/listSupportPlanInfo", "POST");
            Endpoints[1130] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/eventtypes/management/values", "GET");
            Endpoints[1131] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableSslOptions/default/predefinedPolicies", "GET");
            Endpoints[1132] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/applicationGatewayAvailableSslOptions/default/predefinedPolicies/{predefinedPolicyName}", "GET");
            Endpoints[1133] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Advisor/generateRecommendations/{operationId}", "GET");
            Endpoints[1134] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", "PUT");
            Endpoints[1135] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", "GET");
            Endpoints[1136] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", "DELETE");
            Endpoints[1137] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policydefinitions/{policyDefinitionName}", "DELETE");
            Endpoints[1138] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policydefinitions/{policyDefinitionName}", "GET");
            Endpoints[1139] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policydefinitions/{policyDefinitionName}", "PUT");
            Endpoints[1140] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "GET");
            Endpoints[1141] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "DELETE");
            Endpoints[1142] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}", "PUT");
            Endpoints[1143] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}", "GET");
            Endpoints[1144] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/invoices/{invoiceName}", "GET");
            Endpoints[1145] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/budgets/{budgetName}", "GET");
            Endpoints[1146] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/budgets/{budgetName}", "PUT");
            Endpoints[1147] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/budgets/{budgetName}", "DELETE");
            Endpoints[1148] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/topLevelDomains/{name}", "GET");
            Endpoints[1149] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.gallery.admin/galleryItems/{galleryItemName}", "DELETE");
            Endpoints[1150] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.gallery.admin/galleryItems/{galleryItemName}", "GET");
            Endpoints[1151] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}", "PUT");
            Endpoints[1152] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}", "GET");
            Endpoints[1153] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}", "DELETE");
            Endpoints[1154] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}", "PATCH");
            Endpoints[1155] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Media/mediaservices/{accountName}", "GET");
            Endpoints[1156] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/autoProvisioningSettings/{settingName}", "PUT");
            Endpoints[1157] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/autoProvisioningSettings/{settingName}", "GET");
            Endpoints[1158] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}", "GET");
            Endpoints[1159] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}", "PUT");
            Endpoints[1160] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}", "GET");
            Endpoints[1161] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "PATCH");
            Endpoints[1162] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "PUT");
            Endpoints[1163] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "GET");
            Endpoints[1164] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/delegatedProviders/{delegatedProvider}", "GET");
            Endpoints[1165] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/locations/{location}", "DELETE");
            Endpoints[1166] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/locations/{location}", "PUT");
            Endpoints[1167] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/locations/{location}", "GET");
            Endpoints[1168] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{subscription}", "GET");
            Endpoints[1169] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{subscription}", "PUT");
            Endpoints[1170] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{subscription}", "DELETE");
            Endpoints[1171] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/ishostingenvironmentnameavailable/{name}", "GET");
            Endpoints[1172] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/{providerName}/supportPlanTypes", "GET");
            Endpoints[1173] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/locations/{location}/checkNameAvailability", "POST");
            Endpoints[1174] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/checkNameAvailability", "POST");
            Endpoints[1175] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas", "GET");
            Endpoints[1176] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/locations/{location}/usages", "GET");
            Endpoints[1177] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.CognitiveServices/locations/{location}/checkSkuAvailability", "POST");
            Endpoints[1178] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/quotas", "GET");
            Endpoints[1179] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers", "GET");
            Endpoints[1180] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands", "GET");
            Endpoints[1181] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/usages", "GET");
            Endpoints[1182] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/vmSizes", "GET");
            Endpoints[1183] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/usages", "GET");
            Endpoints[1184] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/locations/{location}/orchestrators", "GET");
            Endpoints[1185] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/availableSkus", "POST");
            Endpoints[1186] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateAddress", "POST");
            Endpoints[1187] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataFactory/locations/{locationId}/configureFactoryRepo", "POST");
            Endpoints[1188] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/locations/{location}/capability", "GET");
            Endpoints[1189] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/locations/{location}/checkNameAvailability", "POST");
            Endpoints[1190] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeStore/locations/{location}/capability", "GET");
            Endpoints[1191] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeStore/locations/{location}/checkNameAvailability", "POST");
            Endpoints[1192] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/locations/{location}/checkNameAvailability", "POST");
            Endpoints[1193] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/locations/{location}/usages", "GET");
            Endpoints[1194] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/locations/{locationName}/performanceTiers", "GET");
            Endpoints[1195] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/locations/{locationName}/performanceTiers", "GET");
            Endpoints[1196] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/topLevelDomains/{name}/listAgreements", "POST");
            Endpoints[1197] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions", "GET");
            Endpoints[1198] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions", "GET");
            Endpoints[1199] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventHub/sku/{sku}/regions", "GET");
            Endpoints[1200] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features", "GET");
            Endpoints[1201] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.HDInsight/locations/{location}/capabilities", "GET");
            Endpoints[1202] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault.Admin/locations/{location}/quotas", "GET");
            Endpoints[1203] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Media/locations/{locationName}/checkNameAvailability", "POST");
            Endpoints[1204] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/locations/{location}/quotas", "GET");
            Endpoints[1205] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/CheckDnsNameAvailability", "GET");
            Endpoints[1206] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/usages", "GET");
            Endpoints[1207] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/virtualNetworkAvailableEndpointServices", "GET");
            Endpoints[1208] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[1209] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[1210] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[1211] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.PowerBI/locations/{location}/checkNameAvailability", "POST");
            Endpoints[1212] = CreateEndpoint("/Subscriptions/{subscriptionId}/providers/Microsoft.RecoveryServices/locations/{azureRegion}/backupPreValidateProtection", "POST");
            Endpoints[1213] = CreateEndpoint("/Subscriptions/{subscriptionId}/providers/Microsoft.RecoveryServices/locations/{azureRegion}/backupStatus", "POST");
            Endpoints[1214] = CreateEndpoint("/Subscriptions/{subscriptionId}/providers/Microsoft.RecoveryServices/locations/{azureRegion}/backupValidateFeatures", "POST");
            Endpoints[1215] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts", "GET");
            Endpoints[1216] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/discoveredSecuritySolutions", "GET");
            Endpoints[1217] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/ExternalSecuritySolutions", "GET");
            Endpoints[1218] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies", "GET");
            Endpoints[1219] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/tasks", "GET");
            Endpoints[1220] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/sku/{sku}/regions", "GET");
            Endpoints[1221] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/clusterVersions", "GET");
            Endpoints[1222] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.SignalRService/locations/{location}/checkNameAvailability", "POST");
            Endpoints[1223] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/capabilities", "GET");
            Endpoints[1224] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups", "GET");
            Endpoints[1225] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/syncDatabaseIds", "GET");
            Endpoints[1226] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/usages", "GET");
            Endpoints[1227] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage.Admin/locations/{location}/quotas", "GET");
            Endpoints[1228] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage/locations/{location}/usages", "GET");
            Endpoints[1229] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.StreamAnalytics/locations/{location}/quotas", "GET");
            Endpoints[1230] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/delegatedProviders/{delegatedProviderSubscriptionId}/offers", "GET");
            Endpoints[1231] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/locations/{location}/quotas", "GET");
            Endpoints[1232] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{targetSubscriptionId}/acquiredPlans", "GET");
            Endpoints[1233] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/connectionGatewayInstallations", "GET");
            Endpoints[1234] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/extractApiDefinitionFromWsdl", "POST");
            Endpoints[1235] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/listWsdlInterfaces", "POST");
            Endpoints[1236] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/managedApis", "GET");
            Endpoints[1237] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/{name}/disable", "POST");
            Endpoints[1238] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/platformImage", "GET");
            Endpoints[1239] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/VMExtension", "GET");
            Endpoints[1240] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/marketplaces", "GET");
            Endpoints[1241] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[1242] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/logAnalytics/apiAccess/getRequestRateByInterval", "POST");
            Endpoints[1243] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/logAnalytics/apiAccess/getThrottledRequests", "POST");
            Endpoints[1244] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Billing/billingPeriods/{billingPeriodName}/providers/Microsoft.Consumption/pricesheets/default", "GET");
            Endpoints[1245] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/VMExtension/publishers/{publisher}/types/{type}/versions/{version}", "PUT");
            Endpoints[1246] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/VMExtension/publishers/{publisher}/types/{type}/versions/{version}", "DELETE");
            Endpoints[1247] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/VMExtension/publishers/{publisher}/types/{type}/versions/{version}", "GET");
            Endpoints[1248] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/platformImage/publishers/{publisher}/offers/{offer}/skus/{sku}/versions/{version}", "DELETE");
            Endpoints[1249] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/platformImage/publishers/{publisher}/offers/{offer}/skus/{sku}/versions/{version}", "GET");
            Endpoints[1250] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/artifactTypes/platformImage/publishers/{publisher}/offers/{offer}/skus/{sku}/versions/{version}", "PUT");
            Endpoints[1251] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/{providerName}/supportPlanTypes/{planTypeName}", "PUT");
            Endpoints[1252] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/{providerName}/supportPlanTypes/{planTypeName}", "DELETE");
            Endpoints[1253] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Addons/supportProviders/{providerName}/supportPlanTypes/{planTypeName}", "GET");
            Endpoints[1254] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/locations/{location}/operationresults/{operationId}", "GET");
            Endpoints[1255] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/locations/{location}/operationstatuses/{operationId}", "GET");
            Endpoints[1256] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/quotas/{quotaName}", "PUT");
            Endpoints[1257] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/quotas/{quotaName}", "GET");
            Endpoints[1258] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute.Admin/locations/{location}/quotas/{quotaName}", "DELETE");
            Endpoints[1259] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands/{commandId}", "GET");
            Endpoints[1260] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.DevTestLab/locations/{locationName}/operations/{name}", "GET");
            Endpoints[1261] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}", "GET");
            Endpoints[1262] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}", "GET");
            Endpoints[1263] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/locations/{location}/quotas/{resourceName}", "GET");
            Endpoints[1264] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/locations/{location}/quotas/{resourceName}", "DELETE");
            Endpoints[1265] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Network.Admin/locations/{location}/quotas/{resourceName}", "PUT");
            Endpoints[1266] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}", "GET");
            Endpoints[1267] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}", "GET");
            Endpoints[1268] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/clusterVersions/{clusterVersion}", "GET");
            Endpoints[1269] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/usages/{usageName}", "GET");
            Endpoints[1270] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage.Admin/locations/{location}/quotas/{quotaName}", "DELETE");
            Endpoints[1271] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage.Admin/locations/{location}/quotas/{quotaName}", "GET");
            Endpoints[1272] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Storage.Admin/locations/{location}/quotas/{quotaName}", "PUT");
            Endpoints[1273] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/delegatedProviders/{delegatedProviderSubscriptionId}/offers/{offer}", "GET");
            Endpoints[1274] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/locations/{location}/quotas/{quota}", "GET");
            Endpoints[1275] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{targetSubscriptionId}/acquiredPlans/{planAcquisitionId}", "DELETE");
            Endpoints[1276] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{targetSubscriptionId}/acquiredPlans/{planAcquisitionId}", "PUT");
            Endpoints[1277] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Subscriptions.Admin/subscriptions/{targetSubscriptionId}/acquiredPlans/{planAcquisitionId}", "GET");
            Endpoints[1278] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/connectionGatewayInstallations/{gatewayId}", "GET");
            Endpoints[1279] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/managedApis/{apiName}", "GET");
            Endpoints[1280] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions", "GET");
            Endpoints[1281] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}/register", "POST");
            Endpoints[1282] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge", "POST");
            Endpoints[1283] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/environments/{environment}/clusterVersions", "GET");
            Endpoints[1284] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups", "GET");
            Endpoints[1285] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/managedDatabaseRestoreAzureAsyncOperation/{operationId}/completeRestore", "POST");
            Endpoints[1286] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types", "GET");
            Endpoints[1287] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers", "GET");
            Endpoints[1288] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types/{type}/versions", "GET");
            Endpoints[1289] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus", "GET");
            Endpoints[1290] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types/{type}/versions/{version}", "GET");
            Endpoints[1291] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions", "GET");
            Endpoints[1292] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}", "GET");
            Endpoints[1293] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/environments/{environment}/clusterVersions/{clusterVersion}", "GET");
            Endpoints[1294] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups", "GET");
            Endpoints[1295] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}", "GET");
            Endpoints[1296] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}", "DELETE");
            Endpoints[1297] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MarketplaceOrdering/offerTypes/{offerType}/publishers/{publisherId}/offers/{offerId}/plans/{planId}/agreements/current", "GET");
            Endpoints[1298] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.MarketplaceOrdering/offerTypes/{offerType}/publishers/{publisherId}/offers/{offerId}/plans/{planId}/agreements/current", "PUT");
            Endpoints[1299] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/{alertUpdateActionType}", "POST");
            Endpoints[1300] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}/{taskUpdateActionType}", "POST");
            Endpoints[1301] = CreateEndpoint("/Applications/{applicationId}/$/GetServices/{serviceId}", "GET");
            Endpoints[1302] = CreateEndpoint("/ApplicationTypes/{applicationTypeName}/$/GetServiceTypes/{serviceTypeName}", "GET");
            Endpoints[1303] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}", "GET");
            Endpoints[1304] = CreateEndpoint("/Partitions/{partitionId}/$/GetReplicas/{replicaId}", "GET");
            Endpoints[1305] = CreateEndpoint("/Services/{serviceName}/$/GetPartitions/{partitionId}", "GET");
            Endpoints[1306] = CreateEndpoint("/Applications/{applicationName}/$/GetServiceGroups/{serviceName}/$/Delete", "POST");
            Endpoints[1307] = CreateEndpoint("/Applications/{applicationName}/$/GetServices/{serviceName}/$/GetServiceGroupDescription", "GET");
            Endpoints[1308] = CreateEndpoint("/Applications/{applicationName}/$/GetServices/{serviceName}/$/GetServiceGroupMembers", "GET");
            Endpoints[1309] = CreateEndpoint("/Applications/{applicationName}/$/GetServices/{serviceName}/$/UpdateServiceGroup", "POST");
            Endpoints[1310] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetCodePackages", "GET");
            Endpoints[1311] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetHealth", "GET");
            Endpoints[1312] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetHealth", "POST");
            Endpoints[1313] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetReplicas", "GET");
            Endpoints[1314] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages", "GET");
            Endpoints[1315] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServiceTypes", "GET");
            Endpoints[1316] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/ReportHealth", "POST");
            Endpoints[1317] = CreateEndpoint("/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas", "GET");
            Endpoints[1318] = CreateEndpoint("/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetHealth", "POST");
            Endpoints[1319] = CreateEndpoint("/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetHealth", "GET");
            Endpoints[1320] = CreateEndpoint("/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetLoadInformation", "GET");
            Endpoints[1321] = CreateEndpoint("/Partitions/{partitionId}/$/GetReplicas/{replicaId}/$/ReportHealth", "POST");
            Endpoints[1322] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetCodePackages/$/ContainerApi", "POST");
            Endpoints[1323] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetCodePackages/$/ContainerLogs", "GET");
            Endpoints[1324] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetCodePackages/$/Restart", "POST");
            Endpoints[1325] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}", "GET");
            Endpoints[1326] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServiceTypes/{serviceTypeName}", "GET");
            Endpoints[1327] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}/$/GetHealth", "GET");
            Endpoints[1328] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}/$/GetHealth", "POST");
            Endpoints[1329] = CreateEndpoint("/Nodes/{nodeName}/$/GetApplications/{applicationId}/$/GetServicePackages/{servicePackageName}/$/ReportHealth", "POST");
            Endpoints[1330] = CreateEndpoint("/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas/{replicaId}/$/Delete", "POST");
            Endpoints[1331] = CreateEndpoint("/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas/{replicaId}/$/GetDetail", "GET");
            Endpoints[1332] = CreateEndpoint("/Nodes/{nodeName}/$/GetPartitions/{partitionId}/$/GetReplicas/{replicaId}/$/Restart", "POST");
            Endpoints[1333] = CreateEndpoint("/apis/{apiId}/operations/{operationId}", "DELETE");
            Endpoints[1334] = CreateEndpoint("/apis/{apiId}/operations/{operationId}", "GET");
            Endpoints[1335] = CreateEndpoint("/apis/{apiId}/operations/{operationId}", "PATCH");
            Endpoints[1336] = CreateEndpoint("/apis/{apiId}/operations/{operationId}", "PUT");
            Endpoints[1337] = CreateEndpoint("/apis/{apiId}/policies/{policyId}", "GET");
            Endpoints[1338] = CreateEndpoint("/apis/{apiId}/policies/{policyId}", "PUT");
            Endpoints[1339] = CreateEndpoint("/apis/{apiId}/policies/{policyId}", "DELETE");
            Endpoints[1340] = CreateEndpoint("/apis/{apiId}/schemas/{schemaId}", "DELETE");
            Endpoints[1341] = CreateEndpoint("/apis/{apiId}/schemas/{schemaId}", "PUT");
            Endpoints[1342] = CreateEndpoint("/apis/{apiId}/schemas/{schemaId}", "GET");
            Endpoints[1343] = CreateEndpoint("/apps/{appId}/events/{eventType}", "GET");
            Endpoints[1344] = CreateEndpoint("/apps/{appId}/metrics/{metricId}", "GET");
            Endpoints[1345] = CreateEndpoint("/apps/{appId}/versions/{versionId}/", "DELETE");
            Endpoints[1346] = CreateEndpoint("/apps/{appId}/versions/{versionId}/", "PUT");
            Endpoints[1347] = CreateEndpoint("/apps/{appId}/versions/{versionId}/", "GET");
            Endpoints[1348] = CreateEndpoint("/delegatedProviders/{delegatedProviderId}/offers/{offerName}", "GET");
            Endpoints[1349] = CreateEndpoint("/deletedstorage/{storage-account-name}/sas/{sas-definition-name}", "GET");
            Endpoints[1350] = CreateEndpoint("/facelists/{faceListId}/persistedFaces/{persistedFaceId}", "DELETE");
            Endpoints[1351] = CreateEndpoint("/groups/{groupId}/users/{uid}", "PUT");
            Endpoints[1352] = CreateEndpoint("/groups/{groupId}/users/{uid}", "DELETE");
            Endpoints[1353] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}", "GET");
            Endpoints[1354] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}", "DELETE");
            Endpoints[1355] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}", "PUT");
            Endpoints[1356] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}", "GET");
            Endpoints[1357] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}", "PATCH");
            Endpoints[1358] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}", "DELETE");
            Endpoints[1359] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}", "GET");
            Endpoints[1360] = CreateEndpoint("/products/{productId}/apis/{apiId}", "DELETE");
            Endpoints[1361] = CreateEndpoint("/products/{productId}/apis/{apiId}", "PUT");
            Endpoints[1362] = CreateEndpoint("/products/{productId}/groups/{groupId}", "PUT");
            Endpoints[1363] = CreateEndpoint("/products/{productId}/groups/{groupId}", "DELETE");
            Endpoints[1364] = CreateEndpoint("/products/{productId}/policies/{policyId}", "PUT");
            Endpoints[1365] = CreateEndpoint("/products/{productId}/policies/{policyId}", "GET");
            Endpoints[1366] = CreateEndpoint("/products/{productId}/policies/{policyId}", "DELETE");
            Endpoints[1367] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}", "DELETE");
            Endpoints[1368] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}", "PATCH");
            Endpoints[1369] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}", "GET");
            Endpoints[1370] = CreateEndpoint("/projects/{projectId}/tags/{tagId}", "DELETE");
            Endpoints[1371] = CreateEndpoint("/projects/{projectId}/tags/{tagId}", "PATCH");
            Endpoints[1372] = CreateEndpoint("/projects/{projectId}/tags/{tagId}", "GET");
            Endpoints[1373] = CreateEndpoint("/storage/{storage-account-name}/sas/{sas-definition-name}", "PATCH");
            Endpoints[1374] = CreateEndpoint("/storage/{storage-account-name}/sas/{sas-definition-name}", "PUT");
            Endpoints[1375] = CreateEndpoint("/storage/{storage-account-name}/sas/{sas-definition-name}", "DELETE");
            Endpoints[1376] = CreateEndpoint("/storage/{storage-account-name}/sas/{sas-definition-name}", "GET");
            Endpoints[1377] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}", "GET");
            Endpoints[1378] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", "HEAD");
            Endpoints[1379] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", "PATCH");
            Endpoints[1380] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", "GET");
            Endpoints[1381] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", "PUT");
            Endpoints[1382] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", "DELETE");
            Endpoints[1383] = CreateEndpoint("/subscriptions/{subscriptionId}/tagNames/{tagName}", "DELETE");
            Endpoints[1384] = CreateEndpoint("/subscriptions/{subscriptionId}/tagNames/{tagName}", "PUT");
            Endpoints[1385] = CreateEndpoint("/apis/{apiId}/operations/{operationId}/policies", "GET");
            Endpoints[1386] = CreateEndpoint("/apps/{appId}/versions/{versionId}/clone", "POST");
            Endpoints[1387] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists", "GET");
            Endpoints[1388] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists", "POST");
            Endpoints[1389] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities", "POST");
            Endpoints[1390] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities", "GET");
            Endpoints[1391] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltdomains", "POST");
            Endpoints[1392] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities", "POST");
            Endpoints[1393] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities", "GET");
            Endpoints[1394] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltintents", "POST");
            Endpoints[1395] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltintents", "GET");
            Endpoints[1396] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltmodels", "GET");
            Endpoints[1397] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities", "GET");
            Endpoints[1398] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities", "POST");
            Endpoints[1399] = CreateEndpoint("/apps/{appId}/versions/{versionId}/example", "POST");
            Endpoints[1400] = CreateEndpoint("/apps/{appId}/versions/{versionId}/examples", "POST");
            Endpoints[1401] = CreateEndpoint("/apps/{appId}/versions/{versionId}/examples", "GET");
            Endpoints[1402] = CreateEndpoint("/apps/{appId}/versions/{versionId}/export", "GET");
            Endpoints[1403] = CreateEndpoint("/apps/{appId}/versions/{versionId}/features", "GET");
            Endpoints[1404] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities", "GET");
            Endpoints[1405] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities", "POST");
            Endpoints[1406] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents", "POST");
            Endpoints[1407] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents", "GET");
            Endpoints[1408] = CreateEndpoint("/apps/{appId}/versions/{versionId}/listprebuilts", "GET");
            Endpoints[1409] = CreateEndpoint("/apps/{appId}/versions/{versionId}/models", "GET");
            Endpoints[1410] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities", "POST");
            Endpoints[1411] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities", "GET");
            Endpoints[1412] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrule", "POST");
            Endpoints[1413] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrules", "GET");
            Endpoints[1414] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrules", "DELETE");
            Endpoints[1415] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrules", "PUT");
            Endpoints[1416] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrules", "POST");
            Endpoints[1417] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patterns", "GET");
            Endpoints[1418] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patterns", "POST");
            Endpoints[1419] = CreateEndpoint("/apps/{appId}/versions/{versionId}/phraselists", "POST");
            Endpoints[1420] = CreateEndpoint("/apps/{appId}/versions/{versionId}/phraselists", "GET");
            Endpoints[1421] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts", "POST");
            Endpoints[1422] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts", "GET");
            Endpoints[1423] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities", "GET");
            Endpoints[1424] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities", "POST");
            Endpoints[1425] = CreateEndpoint("/apps/{appId}/versions/{versionId}/suggest", "DELETE");
            Endpoints[1426] = CreateEndpoint("/apps/{appId}/versions/{versionId}/train", "POST");
            Endpoints[1427] = CreateEndpoint("/apps/{appId}/versions/{versionId}/train", "GET");
            Endpoints[1428] = CreateEndpoint("/deletedstorage/{storage-account-name}/sas/{sas-definition-name}/recover", "POST");
            Endpoints[1429] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/files", "GET");
            Endpoints[1430] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/reactivate", "POST");
            Endpoints[1431] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/subtasksinfo", "GET");
            Endpoints[1432] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/terminate", "POST");
            Endpoints[1433] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}/persistedFaces", "POST");
            Endpoints[1434] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/disablescheduling", "POST");
            Endpoints[1435] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/enablescheduling", "POST");
            Endpoints[1436] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/files", "GET");
            Endpoints[1437] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/rdp", "GET");
            Endpoints[1438] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/reboot", "POST");
            Endpoints[1439] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/reimage", "POST");
            Endpoints[1440] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/remoteloginsettings", "GET");
            Endpoints[1441] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/uploadbatchservicelogs", "POST");
            Endpoints[1442] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/users", "POST");
            Endpoints[1443] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}/export", "POST");
            Endpoints[1444] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}/export", "GET");
            Endpoints[1445] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}/performance", "GET");
            Endpoints[1446] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/register", "POST");
            Endpoints[1447] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/unregister", "POST");
            Endpoints[1448] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate", "POST");
            Endpoints[1449] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/moveResources", "POST");
            Endpoints[1450] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources", "GET");
            Endpoints[1451] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/validateMoveResources", "POST");
            Endpoints[1452] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}/performance/images", "GET");
            Endpoints[1453] = CreateEndpoint("/projects/{projectId}/iterations/{iterationId}/performance/images/count", "GET");
            Endpoints[1454] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks", "GET");
            Endpoints[1455] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services", "GET");
            Endpoints[1456] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Advisor/configurations", "GET");
            Endpoints[1457] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Advisor/configurations", "PUT");
            Endpoints[1458] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations", "GET");
            Endpoints[1459] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations", "GET");
            Endpoints[1460] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices", "GET");
            Endpoints[1461] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers", "GET");
            Endpoints[1462] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service", "GET");
            Endpoints[1463] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks", "GET");
            Endpoints[1464] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Authorization/permissions", "GET");
            Endpoints[1465] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/policyAssignments", "GET");
            Endpoints[1466] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/roleAssignments", "GET");
            Endpoints[1467] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts", "GET");
            Endpoints[1468] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations", "GET");
            Endpoints[1469] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts", "GET");
            Endpoints[1470] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters", "GET");
            Endpoints[1471] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers", "GET");
            Endpoints[1472] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs", "GET");
            Endpoints[1473] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces", "GET");
            Endpoints[1474] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices", "GET");
            Endpoints[1475] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis", "GET");
            Endpoints[1476] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles", "GET");
            Endpoints[1477] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders", "GET");
            Endpoints[1478] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts", "GET");
            Endpoints[1479] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets", "GET");
            Endpoints[1480] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks", "GET");
            Endpoints[1481] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries", "GET");
            Endpoints[1482] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images", "GET");
            Endpoints[1483] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots", "GET");
            Endpoints[1484] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines", "GET");
            Endpoints[1485] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets", "GET");
            Endpoints[1486] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Consumption/budgets", "GET");
            Endpoints[1487] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups", "GET");
            Endpoints[1488] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries", "GET");
            Endpoints[1489] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices", "GET");
            Endpoints[1490] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters", "GET");
            Endpoints[1491] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs", "GET");
            Endpoints[1492] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs", "GET");
            Endpoints[1493] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces", "GET");
            Endpoints[1494] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs", "GET");
            Endpoints[1495] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories", "GET");
            Endpoints[1496] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts", "GET");
            Endpoints[1497] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts", "GET");
            Endpoints[1498] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers", "GET");
            Endpoints[1499] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers", "GET");
            Endpoints[1500] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs", "GET");
            Endpoints[1501] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices", "GET");
            Endpoints[1502] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs", "GET");
            Endpoints[1503] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules", "GET");
            Endpoints[1504] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts", "GET");
            Endpoints[1505] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains", "GET");
            Endpoints[1506] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/eventSubscriptions", "GET");
            Endpoints[1507] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics", "GET");
            Endpoints[1508] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/clusters", "GET");
            Endpoints[1509] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces", "GET");
            Endpoints[1510] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations", "PUT");
            Endpoints[1511] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations", "GET");
            Endpoints[1512] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/hanaInstances", "GET");
            Endpoints[1513] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters", "GET");
            Endpoints[1514] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs", "GET");
            Endpoints[1515] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths", "GET");
            Endpoints[1516] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups", "GET");
            Endpoints[1517] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts", "GET");
            Endpoints[1518] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules", "GET");
            Endpoints[1519] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings", "GET");
            Endpoints[1520] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components", "GET");
            Endpoints[1521] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts", "GET");
            Endpoints[1522] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules", "GET");
            Endpoints[1523] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests", "GET");
            Endpoints[1524] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/IoTApps", "GET");
            Endpoints[1525] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTSpaces/Graph", "GET");
            Endpoints[1526] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults", "GET");
            Endpoints[1527] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts", "GET");
            Endpoints[1528] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows", "GET");
            Endpoints[1529] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans", "GET");
            Endpoints[1530] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices", "GET");
            Endpoints[1531] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces", "GET");
            Endpoints[1532] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters", "GET");
            Endpoints[1533] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts", "GET");
            Endpoints[1534] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces", "GET");
            Endpoints[1535] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities", "GET");
            Endpoints[1536] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts", "GET");
            Endpoints[1537] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices", "GET");
            Endpoints[1538] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/projects", "GET");
            Endpoints[1539] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways", "GET");
            Endpoints[1540] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups", "GET");
            Endpoints[1541] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections", "GET");
            Endpoints[1542] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans", "GET");
            Endpoints[1543] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones", "GET");
            Endpoints[1544] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits", "GET");
            Endpoints[1545] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections", "GET");
            Endpoints[1546] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers", "GET");
            Endpoints[1547] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways", "GET");
            Endpoints[1548] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces", "GET");
            Endpoints[1549] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups", "GET");
            Endpoints[1550] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers", "GET");
            Endpoints[1551] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses", "GET");
            Endpoints[1552] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters", "GET");
            Endpoints[1553] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables", "GET");
            Endpoints[1554] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles", "GET");
            Endpoints[1555] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways", "GET");
            Endpoints[1556] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks", "GET");
            Endpoints[1557] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces", "GET");
            Endpoints[1558] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces", "GET");
            Endpoints[1559] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/solutions", "GET");
            Endpoints[1560] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections", "GET");
            Endpoints[1561] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities", "GET");
            Endpoints[1562] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/operations", "GET");
            Endpoints[1563] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults", "GET");
            Endpoints[1564] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces", "GET");
            Endpoints[1565] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ResourceHealth/availabilityStatuses", "GET");
            Endpoints[1566] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/", "GET");
            Endpoints[1567] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections", "GET");
            Endpoints[1568] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices", "GET");
            Endpoints[1569] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/alerts", "GET");
            Endpoints[1570] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/jitNetworkAccessPolicies", "GET");
            Endpoints[1571] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/pricings", "GET");
            Endpoints[1572] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityContacts", "GET");
            Endpoints[1573] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/workspaceSettings", "GET");
            Endpoints[1574] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways", "GET");
            Endpoints[1575] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes", "GET");
            Endpoints[1576] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces", "GET");
            Endpoints[1577] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters", "GET");
            Endpoints[1578] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR", "GET");
            Endpoints[1579] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applianceDefinitions", "GET");
            Endpoints[1580] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/appliances", "GET");
            Endpoints[1581] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applicationDefinitions", "GET");
            Endpoints[1582] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications", "GET");
            Endpoints[1583] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances", "GET");
            Endpoints[1584] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers", "GET");
            Endpoints[1585] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms", "GET");
            Endpoints[1586] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts", "GET");
            Endpoints[1587] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers", "GET");
            Endpoints[1588] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs", "GET");
            Endpoints[1589] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/directoryTenants", "GET");
            Endpoints[1590] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers", "GET");
            Endpoints[1591] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/plans", "GET");
            Endpoints[1592] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments", "GET");
            Endpoints[1593] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/", "GET");
            Endpoints[1594] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account", "GET");
            Endpoints[1595] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates", "GET");
            Endpoints[1596] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/classicMobileServices", "GET");
            Endpoints[1597] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways", "GET");
            Endpoints[1598] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections", "GET");
            Endpoints[1599] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/csrs", "GET");
            Endpoints[1600] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis", "GET");
            Endpoints[1601] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/deletedSites", "GET");
            Endpoints[1602] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments", "GET");
            Endpoints[1603] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments", "GET");
            Endpoints[1604] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/resourceHealthMetadata", "GET");
            Endpoints[1605] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms", "GET");
            Endpoints[1606] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites", "GET");
            Endpoints[1607] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validate", "POST");
            Endpoints[1608] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/BotServices/listServiceProviders", "POST");
            Endpoints[1609] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}", "DELETE");
            Endpoints[1610] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}", "PATCH");
            Endpoints[1611] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}", "PUT");
            Endpoints[1612] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/microsoft.insights/workbooks/{resourceName}", "GET");
            Endpoints[1613] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}", "GET");
            Endpoints[1614] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}", "PATCH");
            Endpoints[1615] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}", "PARAMETERS");
            Endpoints[1616] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}", "PUT");
            Endpoints[1617] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}", "DELETE");
            Endpoints[1618] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}", "DELETE");
            Endpoints[1619] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}", "PUT");
            Endpoints[1620] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}", "GET");
            Endpoints[1621] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}", "DELETE");
            Endpoints[1622] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}", "PUT");
            Endpoints[1623] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}", "GET");
            Endpoints[1624] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices/{domainServiceName}", "GET");
            Endpoints[1625] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices/{domainServiceName}", "DELETE");
            Endpoints[1626] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices/{domainServiceName}", "PUT");
            Endpoints[1627] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices/{domainServiceName}", "PATCH");
            Endpoints[1628] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}", "PATCH");
            Endpoints[1629] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}", "GET");
            Endpoints[1630] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}", "PUT");
            Endpoints[1631] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}", "DELETE");
            Endpoints[1632] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", "DELETE");
            Endpoints[1633] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", "PUT");
            Endpoints[1634] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", "GET");
            Endpoints[1635] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}", "PATCH");
            Endpoints[1636] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", "DELETE");
            Endpoints[1637] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", "PUT");
            Endpoints[1638] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", "GET");
            Endpoints[1639] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}", "PATCH");
            Endpoints[1640] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}", "DELETE");
            Endpoints[1641] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}", "PUT");
            Endpoints[1642] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}", "GET");
            Endpoints[1643] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations/{location}", "GET");
            Endpoints[1644] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations/{location}", "PUT");
            Endpoints[1645] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}", "GET");
            Endpoints[1646] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}", "DELETE");
            Endpoints[1647] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}", "PATCH");
            Endpoints[1648] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}", "PUT");
            Endpoints[1649] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}", "GET");
            Endpoints[1650] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}", "DELETE");
            Endpoints[1651] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}", "PATCH");
            Endpoints[1652] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}", "PUT");
            Endpoints[1653] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}", "DELETE");
            Endpoints[1654] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}", "PUT");
            Endpoints[1655] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}", "GET");
            Endpoints[1656] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", "GET");
            Endpoints[1657] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", "PUT");
            Endpoints[1658] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", "DELETE");
            Endpoints[1659] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}", "PUT");
            Endpoints[1660] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}", "DELETE");
            Endpoints[1661] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}", "GET");
            Endpoints[1662] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}", "GET");
            Endpoints[1663] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}", "PATCH");
            Endpoints[1664] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}", "PUT");
            Endpoints[1665] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}", "DELETE");
            Endpoints[1666] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}", "DELETE");
            Endpoints[1667] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}", "PUT");
            Endpoints[1668] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}", "GET");
            Endpoints[1669] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}", "PATCH");
            Endpoints[1670] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}", "DELETE");
            Endpoints[1671] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}", "GET");
            Endpoints[1672] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}", "PUT");
            Endpoints[1673] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}", "PATCH");
            Endpoints[1674] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", "PATCH");
            Endpoints[1675] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", "DELETE");
            Endpoints[1676] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", "PUT");
            Endpoints[1677] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}", "GET");
            Endpoints[1678] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}", "PATCH");
            Endpoints[1679] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}", "GET");
            Endpoints[1680] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}", "DELETE");
            Endpoints[1681] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}", "PUT");
            Endpoints[1682] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}", "GET");
            Endpoints[1683] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}", "DELETE");
            Endpoints[1684] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}", "PATCH");
            Endpoints[1685] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}", "PUT");
            Endpoints[1686] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", "PATCH");
            Endpoints[1687] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", "PUT");
            Endpoints[1688] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", "GET");
            Endpoints[1689] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}", "DELETE");
            Endpoints[1690] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}", "PUT");
            Endpoints[1691] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}", "GET");
            Endpoints[1692] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}", "DELETE");
            Endpoints[1693] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}", "GET");
            Endpoints[1694] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}", "DELETE");
            Endpoints[1695] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}", "PATCH");
            Endpoints[1696] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}", "PUT");
            Endpoints[1697] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}", "DELETE");
            Endpoints[1698] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}", "GET");
            Endpoints[1699] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}", "PUT");
            Endpoints[1700] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}", "PATCH");
            Endpoints[1701] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}", "PATCH");
            Endpoints[1702] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}", "GET");
            Endpoints[1703] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}", "DELETE");
            Endpoints[1704] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}", "PUT");
            Endpoints[1705] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}", "GET");
            Endpoints[1706] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}", "DELETE");
            Endpoints[1707] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}", "PATCH");
            Endpoints[1708] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}", "PUT");
            Endpoints[1709] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Consumption/budgets/{budgetName}", "GET");
            Endpoints[1710] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Consumption/budgets/{budgetName}", "PUT");
            Endpoints[1711] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Consumption/budgets/{budgetName}", "DELETE");
            Endpoints[1712] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}", "GET");
            Endpoints[1713] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}", "PATCH");
            Endpoints[1714] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}", "PUT");
            Endpoints[1715] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}", "DELETE");
            Endpoints[1716] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", "GET");
            Endpoints[1717] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", "PUT");
            Endpoints[1718] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", "DELETE");
            Endpoints[1719] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", "PATCH");
            Endpoints[1720] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}", "GET");
            Endpoints[1721] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}", "DELETE");
            Endpoints[1722] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/containerServices/{containerServiceName}", "PUT");
            Endpoints[1723] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}", "PUT");
            Endpoints[1724] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}", "GET");
            Endpoints[1725] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}", "DELETE");
            Endpoints[1726] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}", "PUT");
            Endpoints[1727] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}", "PATCH");
            Endpoints[1728] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}", "DELETE");
            Endpoints[1729] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}", "GET");
            Endpoints[1730] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}", "GET");
            Endpoints[1731] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}", "PUT");
            Endpoints[1732] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}", "DELETE");
            Endpoints[1733] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}", "PATCH");
            Endpoints[1734] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}", "PUT");
            Endpoints[1735] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}", "DELETE");
            Endpoints[1736] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}", "GET");
            Endpoints[1737] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}", "PATCH");
            Endpoints[1738] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}", "PATCH");
            Endpoints[1739] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}", "GET");
            Endpoints[1740] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}", "DELETE");
            Endpoints[1741] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}", "PUT");
            Endpoints[1742] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}", "PUT");
            Endpoints[1743] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}", "PATCH");
            Endpoints[1744] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}", "GET");
            Endpoints[1745] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}", "DELETE");
            Endpoints[1746] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", "PATCH");
            Endpoints[1747] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", "GET");
            Endpoints[1748] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", "DELETE");
            Endpoints[1749] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}", "PUT");
            Endpoints[1750] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}", "PUT");
            Endpoints[1751] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}", "DELETE");
            Endpoints[1752] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}", "PATCH");
            Endpoints[1753] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}", "GET");
            Endpoints[1754] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}", "DELETE");
            Endpoints[1755] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}", "PATCH");
            Endpoints[1756] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}", "GET");
            Endpoints[1757] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}", "PUT");
            Endpoints[1758] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}", "GET");
            Endpoints[1759] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}", "PUT");
            Endpoints[1760] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}", "DELETE");
            Endpoints[1761] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}", "PATCH");
            Endpoints[1762] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", "PUT");
            Endpoints[1763] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", "DELETE");
            Endpoints[1764] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", "PATCH");
            Endpoints[1765] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", "GET");
            Endpoints[1766] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", "PATCH");
            Endpoints[1767] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", "GET");
            Endpoints[1768] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", "DELETE");
            Endpoints[1769] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}", "PUT");
            Endpoints[1770] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}", "PUT");
            Endpoints[1771] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}", "GET");
            Endpoints[1772] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}", "PATCH");
            Endpoints[1773] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}", "DELETE");
            Endpoints[1774] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules/{name}", "GET");
            Endpoints[1775] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules/{name}", "PUT");
            Endpoints[1776] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules/{name}", "DELETE");
            Endpoints[1777] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules/{name}", "PATCH");
            Endpoints[1778] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", "DELETE");
            Endpoints[1779] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", "PUT");
            Endpoints[1780] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", "GET");
            Endpoints[1781] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}", "PATCH");
            Endpoints[1782] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", "GET");
            Endpoints[1783] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", "DELETE");
            Endpoints[1784] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", "PATCH");
            Endpoints[1785] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", "PUT");
            Endpoints[1786] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}", "PATCH");
            Endpoints[1787] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}", "DELETE");
            Endpoints[1788] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}", "PUT");
            Endpoints[1789] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}", "GET");
            Endpoints[1790] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/clusters/{clusterName}", "GET");
            Endpoints[1791] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/clusters/{clusterName}", "PATCH");
            Endpoints[1792] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}", "GET");
            Endpoints[1793] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}", "DELETE");
            Endpoints[1794] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}", "PUT");
            Endpoints[1795] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}", "PATCH");
            Endpoints[1796] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{fabricLocation}", "GET");
            Endpoints[1797] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/hanaInstances/{hanaInstanceName}", "GET");
            Endpoints[1798] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}", "PUT");
            Endpoints[1799] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}", "PATCH");
            Endpoints[1800] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}", "DELETE");
            Endpoints[1801] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}", "GET");
            Endpoints[1802] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}", "PATCH");
            Endpoints[1803] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}", "PUT");
            Endpoints[1804] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}", "DELETE");
            Endpoints[1805] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}", "GET");
            Endpoints[1806] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}", "GET");
            Endpoints[1807] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}", "PUT");
            Endpoints[1808] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}", "GET");
            Endpoints[1809] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}", "DELETE");
            Endpoints[1810] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}", "PATCH");
            Endpoints[1811] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}", "DELETE");
            Endpoints[1812] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}", "PATCH");
            Endpoints[1813] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}", "GET");
            Endpoints[1814] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/activityLogAlerts/{activityLogAlertName}", "PUT");
            Endpoints[1815] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}", "PUT");
            Endpoints[1816] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}", "DELETE");
            Endpoints[1817] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}", "PATCH");
            Endpoints[1818] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}", "GET");
            Endpoints[1819] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}", "PATCH");
            Endpoints[1820] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}", "DELETE");
            Endpoints[1821] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}", "PUT");
            Endpoints[1822] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}", "GET");
            Endpoints[1823] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}", "GET");
            Endpoints[1824] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}", "PATCH");
            Endpoints[1825] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}", "PUT");
            Endpoints[1826] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}", "DELETE");
            Endpoints[1827] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}", "DELETE");
            Endpoints[1828] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}", "PATCH");
            Endpoints[1829] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}", "PUT");
            Endpoints[1830] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}", "GET");
            Endpoints[1831] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}", "GET");
            Endpoints[1832] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}", "DELETE");
            Endpoints[1833] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/scheduledQueryRules/{ruleName}", "PUT");
            Endpoints[1834] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}", "GET");
            Endpoints[1835] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}", "DELETE");
            Endpoints[1836] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}", "PATCH");
            Endpoints[1837] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}", "PUT");
            Endpoints[1838] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/IoTApps/{resourceName}", "GET");
            Endpoints[1839] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/IoTApps/{resourceName}", "PUT");
            Endpoints[1840] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/IoTApps/{resourceName}", "PATCH");
            Endpoints[1841] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/IoTApps/{resourceName}", "DELETE");
            Endpoints[1842] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTSpaces/Graph/{resourceName}", "DELETE");
            Endpoints[1843] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTSpaces/Graph/{resourceName}", "GET");
            Endpoints[1844] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTSpaces/Graph/{resourceName}", "PUT");
            Endpoints[1845] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTSpaces/Graph/{resourceName}", "PATCH");
            Endpoints[1846] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", "GET");
            Endpoints[1847] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", "DELETE");
            Endpoints[1848] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", "PATCH");
            Endpoints[1849] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}", "PUT");
            Endpoints[1850] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}", "PATCH");
            Endpoints[1851] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}", "DELETE");
            Endpoints[1852] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}", "PUT");
            Endpoints[1853] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}", "GET");
            Endpoints[1854] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}", "PUT");
            Endpoints[1855] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}", "GET");
            Endpoints[1856] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}", "DELETE");
            Endpoints[1857] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}", "PATCH");
            Endpoints[1858] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}", "PATCH");
            Endpoints[1859] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}", "GET");
            Endpoints[1860] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}", "DELETE");
            Endpoints[1861] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}", "PARAMETERS");
            Endpoints[1862] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}", "PUT");
            Endpoints[1863] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", "PUT");
            Endpoints[1864] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", "GET");
            Endpoints[1865] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", "PATCH");
            Endpoints[1866] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", "DELETE");
            Endpoints[1867] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}", "DELETE");
            Endpoints[1868] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}", "PUT");
            Endpoints[1869] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}", "GET");
            Endpoints[1870] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}", "PATCH");
            Endpoints[1871] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", "PUT");
            Endpoints[1872] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", "GET");
            Endpoints[1873] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", "PATCH");
            Endpoints[1874] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}", "DELETE");
            Endpoints[1875] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}", "DELETE");
            Endpoints[1876] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}", "GET");
            Endpoints[1877] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}", "PUT");
            Endpoints[1878] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}", "PATCH");
            Endpoints[1879] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}", "GET");
            Endpoints[1880] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}", "PUT");
            Endpoints[1881] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}", "DELETE");
            Endpoints[1882] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}", "PATCH");
            Endpoints[1883] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}", "PUT");
            Endpoints[1884] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}", "PATCH");
            Endpoints[1885] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}", "GET");
            Endpoints[1886] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}", "DELETE");
            Endpoints[1887] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}", "DELETE");
            Endpoints[1888] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}", "GET");
            Endpoints[1889] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}", "PUT");
            Endpoints[1890] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}", "PATCH");
            Endpoints[1891] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", "GET");
            Endpoints[1892] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", "PUT");
            Endpoints[1893] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", "DELETE");
            Endpoints[1894] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}", "PATCH");
            Endpoints[1895] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}", "GET");
            Endpoints[1896] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}", "PUT");
            Endpoints[1897] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}", "PATCH");
            Endpoints[1898] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}", "DELETE");
            Endpoints[1899] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", "DELETE");
            Endpoints[1900] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", "GET");
            Endpoints[1901] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", "PUT");
            Endpoints[1902] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}", "PATCH");
            Endpoints[1903] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}", "GET");
            Endpoints[1904] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}", "PUT");
            Endpoints[1905] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}", "DELETE");
            Endpoints[1906] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}", "PATCH");
            Endpoints[1907] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}", "DELETE");
            Endpoints[1908] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}", "PUT");
            Endpoints[1909] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}", "GET");
            Endpoints[1910] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}", "PUT");
            Endpoints[1911] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}", "GET");
            Endpoints[1912] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}", "DELETE");
            Endpoints[1913] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", "PATCH");
            Endpoints[1914] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", "GET");
            Endpoints[1915] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", "DELETE");
            Endpoints[1916] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", "PUT");
            Endpoints[1917] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}", "PATCH");
            Endpoints[1918] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}", "PUT");
            Endpoints[1919] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}", "GET");
            Endpoints[1920] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}", "DELETE");
            Endpoints[1921] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}", "GET");
            Endpoints[1922] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}", "PATCH");
            Endpoints[1923] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}", "PUT");
            Endpoints[1924] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", "DELETE");
            Endpoints[1925] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", "PUT");
            Endpoints[1926] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", "PATCH");
            Endpoints[1927] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}", "GET");
            Endpoints[1928] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}", "PATCH");
            Endpoints[1929] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}", "GET");
            Endpoints[1930] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}", "PUT");
            Endpoints[1931] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}", "DELETE");
            Endpoints[1932] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}", "PATCH");
            Endpoints[1933] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}", "PUT");
            Endpoints[1934] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}", "GET");
            Endpoints[1935] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}", "DELETE");
            Endpoints[1936] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}", "DELETE");
            Endpoints[1937] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}", "PATCH");
            Endpoints[1938] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}", "PUT");
            Endpoints[1939] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}", "GET");
            Endpoints[1940] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", "GET");
            Endpoints[1941] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", "PATCH");
            Endpoints[1942] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", "PUT");
            Endpoints[1943] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}", "DELETE");
            Endpoints[1944] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", "GET");
            Endpoints[1945] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", "PATCH");
            Endpoints[1946] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", "PUT");
            Endpoints[1947] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}", "DELETE");
            Endpoints[1948] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}", "DELETE");
            Endpoints[1949] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}", "PATCH");
            Endpoints[1950] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}", "GET");
            Endpoints[1951] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}", "PUT");
            Endpoints[1952] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}", "PATCH");
            Endpoints[1953] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}", "PUT");
            Endpoints[1954] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}", "DELETE");
            Endpoints[1955] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}", "GET");
            Endpoints[1956] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}", "PATCH");
            Endpoints[1957] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}", "DELETE");
            Endpoints[1958] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}", "PUT");
            Endpoints[1959] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}", "GET");
            Endpoints[1960] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}", "PUT");
            Endpoints[1961] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}", "DELETE");
            Endpoints[1962] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}", "PATCH");
            Endpoints[1963] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}", "GET");
            Endpoints[1964] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}", "GET");
            Endpoints[1965] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}", "DELETE");
            Endpoints[1966] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}", "PUT");
            Endpoints[1967] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}", "PATCH");
            Endpoints[1968] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}", "DELETE");
            Endpoints[1969] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}", "PATCH");
            Endpoints[1970] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}", "PUT");
            Endpoints[1971] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}", "GET");
            Endpoints[1972] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}", "GET");
            Endpoints[1973] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}", "PATCH");
            Endpoints[1974] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}", "PUT");
            Endpoints[1975] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}", "DELETE");
            Endpoints[1976] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/ManagementConfigurations/{managementConfigurationName}", "GET");
            Endpoints[1977] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/ManagementConfigurations/{managementConfigurationName}", "DELETE");
            Endpoints[1978] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/ManagementConfigurations/{managementConfigurationName}", "PUT");
            Endpoints[1979] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/solutions/{solutionName}", "PUT");
            Endpoints[1980] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/solutions/{solutionName}", "DELETE");
            Endpoints[1981] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/solutions/{solutionName}", "GET");
            Endpoints[1982] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}", "PUT");
            Endpoints[1983] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}", "PATCH");
            Endpoints[1984] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}", "DELETE");
            Endpoints[1985] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}", "GET");
            Endpoints[1986] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}", "PATCH");
            Endpoints[1987] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}", "DELETE");
            Endpoints[1988] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}", "GET");
            Endpoints[1989] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}", "PUT");
            Endpoints[1990] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}", "GET");
            Endpoints[1991] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}", "PUT");
            Endpoints[1992] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}", "DELETE");
            Endpoints[1993] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}", "PATCH");
            Endpoints[1994] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}", "PUT");
            Endpoints[1995] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}", "DELETE");
            Endpoints[1996] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}", "GET");
            Endpoints[1997] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}", "PATCH");
            Endpoints[1998] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", "GET");
            Endpoints[1999] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", "DELETE");
            Endpoints[2000] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", "HEAD");
            Endpoints[2001] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}", "PUT");
            Endpoints[2002] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}", "PATCH");
            Endpoints[2003] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}", "PUT");
            Endpoints[2004] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}", "DELETE");
            Endpoints[2005] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}", "GET");
            Endpoints[2006] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}", "DELETE");
            Endpoints[2007] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}", "PATCH");
            Endpoints[2008] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}", "PUT");
            Endpoints[2009] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}", "GET");
            Endpoints[2010] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/pricings/{pricingName}", "PUT");
            Endpoints[2011] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/pricings/{pricingName}", "GET");
            Endpoints[2012] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityContacts/{securityContactName}", "PUT");
            Endpoints[2013] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityContacts/{securityContactName}", "GET");
            Endpoints[2014] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityContacts/{securityContactName}", "PATCH");
            Endpoints[2015] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityContacts/{securityContactName}", "DELETE");
            Endpoints[2016] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "GET");
            Endpoints[2017] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "PUT");
            Endpoints[2018] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "DELETE");
            Endpoints[2019] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}", "PATCH");
            Endpoints[2020] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}", "PUT");
            Endpoints[2021] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}", "DELETE");
            Endpoints[2022] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}", "PATCH");
            Endpoints[2023] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}", "GET");
            Endpoints[2024] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}", "DELETE");
            Endpoints[2025] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}", "GET");
            Endpoints[2026] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}", "PATCH");
            Endpoints[2027] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}", "PUT");
            Endpoints[2028] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}", "GET");
            Endpoints[2029] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}", "PUT");
            Endpoints[2030] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}", "PATCH");
            Endpoints[2031] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}", "DELETE");
            Endpoints[2032] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}", "GET");
            Endpoints[2033] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}", "DELETE");
            Endpoints[2034] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}", "PUT");
            Endpoints[2035] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}", "PATCH");
            Endpoints[2036] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR/{resourceName}", "GET");
            Endpoints[2037] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR/{resourceName}", "DELETE");
            Endpoints[2038] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR/{resourceName}", "PATCH");
            Endpoints[2039] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR/{resourceName}", "PUT");
            Endpoints[2040] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applianceDefinitions/{applianceDefinitionName}", "DELETE");
            Endpoints[2041] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applianceDefinitions/{applianceDefinitionName}", "GET");
            Endpoints[2042] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applianceDefinitions/{applianceDefinitionName}", "PUT");
            Endpoints[2043] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/appliances/{applianceName}", "GET");
            Endpoints[2044] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/appliances/{applianceName}", "DELETE");
            Endpoints[2045] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/appliances/{applianceName}", "PUT");
            Endpoints[2046] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/appliances/{applianceName}", "PATCH");
            Endpoints[2047] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applicationDefinitions/{applicationDefinitionName}", "GET");
            Endpoints[2048] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applicationDefinitions/{applicationDefinitionName}", "PUT");
            Endpoints[2049] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applicationDefinitions/{applicationDefinitionName}", "DELETE");
            Endpoints[2050] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications/{applicationName}", "PUT");
            Endpoints[2051] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications/{applicationName}", "GET");
            Endpoints[2052] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications/{applicationName}", "PATCH");
            Endpoints[2053] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Solutions/applications/{applicationName}", "DELETE");
            Endpoints[2054] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}", "GET");
            Endpoints[2055] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}", "PUT");
            Endpoints[2056] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}", "DELETE");
            Endpoints[2057] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}", "PATCH");
            Endpoints[2058] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}", "PUT");
            Endpoints[2059] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}", "PATCH");
            Endpoints[2060] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}", "DELETE");
            Endpoints[2061] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}", "GET");
            Endpoints[2062] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}", "PUT");
            Endpoints[2063] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}", "GET");
            Endpoints[2064] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}", "PATCH");
            Endpoints[2065] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}", "PUT");
            Endpoints[2066] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}", "DELETE");
            Endpoints[2067] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}", "GET");
            Endpoints[2068] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}", "PATCH");
            Endpoints[2069] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", "GET");
            Endpoints[2070] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", "PUT");
            Endpoints[2071] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", "DELETE");
            Endpoints[2072] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}", "PATCH");
            Endpoints[2073] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}", "PUT");
            Endpoints[2074] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}", "PATCH");
            Endpoints[2075] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}", "GET");
            Endpoints[2076] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}", "DELETE");
            Endpoints[2077] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/directoryTenants/{tenant}", "GET");
            Endpoints[2078] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/directoryTenants/{tenant}", "PUT");
            Endpoints[2079] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/directoryTenants/{tenant}", "DELETE");
            Endpoints[2080] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}", "GET");
            Endpoints[2081] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}", "PUT");
            Endpoints[2082] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}", "DELETE");
            Endpoints[2083] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/plans/{plan}", "DELETE");
            Endpoints[2084] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/plans/{plan}", "PUT");
            Endpoints[2085] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/plans/{plan}", "GET");
            Endpoints[2086] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}", "PUT");
            Endpoints[2087] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}", "GET");
            Endpoints[2088] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}", "PATCH");
            Endpoints[2089] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}", "DELETE");
            Endpoints[2090] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}", "GET");
            Endpoints[2091] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{resourceName}", "PUT");
            Endpoints[2092] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{resourceName}", "DELETE");
            Endpoints[2093] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{resourceName}", "GET");
            Endpoints[2094] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates/{name}", "DELETE");
            Endpoints[2095] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates/{name}", "PUT");
            Endpoints[2096] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates/{name}", "GET");
            Endpoints[2097] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates/{name}", "PATCH");
            Endpoints[2098] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/classicMobileServices/{name}", "DELETE");
            Endpoints[2099] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/classicMobileServices/{name}", "GET");
            Endpoints[2100] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways/{connectionGatewayName}", "GET");
            Endpoints[2101] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways/{connectionGatewayName}", "PATCH");
            Endpoints[2102] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways/{connectionGatewayName}", "PUT");
            Endpoints[2103] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways/{connectionGatewayName}", "DELETE");
            Endpoints[2104] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}", "PUT");
            Endpoints[2105] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}", "GET");
            Endpoints[2106] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}", "PATCH");
            Endpoints[2107] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}", "DELETE");
            Endpoints[2108] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/csrs/{name}", "PATCH");
            Endpoints[2109] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/csrs/{name}", "PUT");
            Endpoints[2110] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/csrs/{name}", "GET");
            Endpoints[2111] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/csrs/{name}", "DELETE");
            Endpoints[2112] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}", "PATCH");
            Endpoints[2113] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}", "GET");
            Endpoints[2114] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}", "PUT");
            Endpoints[2115] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}", "DELETE");
            Endpoints[2116] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", "GET");
            Endpoints[2117] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", "PATCH");
            Endpoints[2118] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", "DELETE");
            Endpoints[2119] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", "PUT");
            Endpoints[2120] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}", "PUT");
            Endpoints[2121] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}", "GET");
            Endpoints[2122] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}", "DELETE");
            Endpoints[2123] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", "GET");
            Endpoints[2124] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", "PUT");
            Endpoints[2125] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", "DELETE");
            Endpoints[2126] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", "PATCH");
            Endpoints[2127] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", "DELETE");
            Endpoints[2128] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", "GET");
            Endpoints[2129] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", "PUT");
            Endpoints[2130] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", "PATCH");
            Endpoints[2131] = CreateEndpoint("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[2132] = CreateEndpoint("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[2133] = CreateEndpoint("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[2134] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes", "GET");
            Endpoints[2135] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/checkNameAvailability", "POST");
            Endpoints[2136] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/checkStatus", "POST");
            Endpoints[2137] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects", "GET");
            Endpoints[2138] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/skus", "GET");
            Endpoints[2139] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/start", "POST");
            Endpoints[2140] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/stop", "POST");
            Endpoints[2141] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}/downloadedProducts", "GET");
            Endpoints[2142] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}/products", "GET");
            Endpoints[2143] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/customerSubscriptions", "GET");
            Endpoints[2144] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/getactivationkey", "POST");
            Endpoints[2145] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/products", "GET");
            Endpoints[2146] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/dissociateGateway", "POST");
            Endpoints[2147] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/listGatewayStatus", "POST");
            Endpoints[2148] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/resume", "POST");
            Endpoints[2149] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/skus", "GET");
            Endpoints[2150] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/suspend", "POST");
            Endpoints[2151] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis", "GET");
            Endpoints[2152] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apisByTags", "GET");
            Endpoints[2153] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets", "GET");
            Endpoints[2154] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets", "PARAMETERS");
            Endpoints[2155] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/applynetworkconfigurationupdates", "POST");
            Endpoints[2156] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers", "GET");
            Endpoints[2157] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends", "GET");
            Endpoints[2158] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backup", "POST");
            Endpoints[2159] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/certificates", "GET");
            Endpoints[2160] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics", "GET");
            Endpoints[2161] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/getssotoken", "GET");
            Endpoints[2162] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/getssotoken", "POST");
            Endpoints[2163] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups", "GET");
            Endpoints[2164] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders", "GET");
            Endpoints[2165] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/issues", "GET");
            Endpoints[2166] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers", "GET");
            Endpoints[2167] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/managedeployments", "POST");
            Endpoints[2168] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/networkstatus", "GET");
            Endpoints[2169] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications", "GET");
            Endpoints[2170] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders", "GET");
            Endpoints[2171] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policies", "GET");
            Endpoints[2172] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policySnippets", "GET");
            Endpoints[2173] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products", "GET");
            Endpoints[2174] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/properties", "GET");
            Endpoints[2175] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/regions", "GET");
            Endpoints[2176] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/restore", "POST");
            Endpoints[2177] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions", "GET");
            Endpoints[2178] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tagResources", "GET");
            Endpoints[2179] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags", "GET");
            Endpoints[2180] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates", "GET");
            Endpoints[2181] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/updatecertificate", "POST");
            Endpoints[2182] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/updatehostname", "POST");
            Endpoints[2183] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/uploadcertificate", "POST");
            Endpoints[2184] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users", "GET");
            Endpoints[2185] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/agentRegistrationInformation", "GET");
            Endpoints[2186] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/certificates", "GET");
            Endpoints[2187] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs", "GET");
            Endpoints[2188] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations", "GET");
            Endpoints[2189] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections", "GET");
            Endpoints[2190] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connectionTypes", "GET");
            Endpoints[2191] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials", "GET");
            Endpoints[2192] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups", "GET");
            Endpoints[2193] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs", "GET");
            Endpoints[2194] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobSchedules", "GET");
            Endpoints[2195] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/linkedWorkspace", "GET");
            Endpoints[2196] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/listKeys", "POST");
            Endpoints[2197] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules", "GET");
            Endpoints[2198] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodeConfigurations", "GET");
            Endpoints[2199] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes", "GET");
            Endpoints[2200] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks", "GET");
            Endpoints[2201] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules", "GET");
            Endpoints[2202] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurationMachineRuns", "GET");
            Endpoints[2203] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurationRuns", "GET");
            Endpoints[2204] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations", "GET");
            Endpoints[2205] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls", "GET");
            Endpoints[2206] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/statistics", "GET");
            Endpoints[2207] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/usages", "GET");
            Endpoints[2208] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables", "GET");
            Endpoints[2209] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers", "GET");
            Endpoints[2210] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks", "GET");
            Endpoints[2211] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations/{location}/backups", "GET");
            Endpoints[2212] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations/{location}/createBackup", "POST");
            Endpoints[2213] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications", "GET");
            Endpoints[2214] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates", "GET");
            Endpoints[2215] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/listKeys", "POST");
            Endpoints[2216] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools", "GET");
            Endpoints[2217] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/regenerateKeys", "POST");
            Endpoints[2218] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/syncAutoStorageKeys", "POST");
            Endpoints[2219] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}/listRemoteLoginInformation", "POST");
            Endpoints[2220] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/listOutputFiles", "POST");
            Endpoints[2221] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/listRemoteLoginInformation", "POST");
            Endpoints[2222] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/terminate", "POST");
            Endpoints[2223] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters", "GET");
            Endpoints[2224] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments", "GET");
            Endpoints[2225] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers", "GET");
            Endpoints[2226] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels", "GET");
            Endpoints[2227] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/connections", "GET");
            Endpoints[2228] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules", "GET");
            Endpoints[2229] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/patchSchedules", "GET");
            Endpoints[2230] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/export", "POST");
            Endpoints[2231] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/forceReboot", "POST");
            Endpoints[2232] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/import", "POST");
            Endpoints[2233] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers", "GET");
            Endpoints[2234] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/listKeys", "POST");
            Endpoints[2235] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/listUpgradeNotifications", "GET");
            Endpoints[2236] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/regenerateKey", "POST");
            Endpoints[2237] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/checkResourceUsage", "POST");
            Endpoints[2238] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints", "GET");
            Endpoints[2239] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/generateSsoUri", "POST");
            Endpoints[2240] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getSupportedOptimizationTypes", "POST");
            Endpoints[2241] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates", "GET");
            Endpoints[2242] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails", "POST");
            Endpoints[2243] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal", "POST");
            Endpoints[2244] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/reissue", "POST");
            Endpoints[2245] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/renew", "POST");
            Endpoints[2246] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/resendEmail", "POST");
            Endpoints[2247] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions", "POST");
            Endpoints[2248] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory", "POST");
            Endpoints[2249] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/verifyDomainOwnership", "POST");
            Endpoints[2250] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/listKeys", "POST");
            Endpoints[2251] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/regenerateKey", "POST");
            Endpoints[2252] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/skus", "GET");
            Endpoints[2253] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/usages", "GET");
            Endpoints[2254] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}/vmSizes", "GET");
            Endpoints[2255] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/beginGetAccess", "POST");
            Endpoints[2256] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}/endGetAccess", "POST");
            Endpoints[2257] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images", "GET");
            Endpoints[2258] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}/beginGetAccess", "POST");
            Endpoints[2259] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}/endGetAccess", "POST");
            Endpoints[2260] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/capture", "POST");
            Endpoints[2261] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/convertToManagedDisks", "POST");
            Endpoints[2262] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/deallocate", "POST");
            Endpoints[2263] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions", "GET");
            Endpoints[2264] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/generalize", "POST");
            Endpoints[2265] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/instanceView", "GET");
            Endpoints[2266] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/performMaintenance", "POST");
            Endpoints[2267] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/powerOff", "POST");
            Endpoints[2268] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/redeploy", "POST");
            Endpoints[2269] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/restart", "POST");
            Endpoints[2270] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommand", "POST");
            Endpoints[2271] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/start", "POST");
            Endpoints[2272] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/vmSizes", "GET");
            Endpoints[2273] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/networkInterfaces", "GET");
            Endpoints[2274] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/publicipaddresses", "GET");
            Endpoints[2275] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines", "GET");
            Endpoints[2276] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/deallocate", "POST");
            Endpoints[2277] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/delete", "POST");
            Endpoints[2278] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensions", "GET");
            Endpoints[2279] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/forceRecoveryServiceFabricPlatformUpdateDomainWalk", "POST");
            Endpoints[2280] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/instanceView", "GET");
            Endpoints[2281] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/manualupgrade", "POST");
            Endpoints[2282] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/osRollingUpgrade", "POST");
            Endpoints[2283] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/osUpgradeHistory", "GET");
            Endpoints[2284] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/performMaintenance", "POST");
            Endpoints[2285] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/poweroff", "POST");
            Endpoints[2286] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/redeploy", "POST");
            Endpoints[2287] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/reimage", "POST");
            Endpoints[2288] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/reimageall", "POST");
            Endpoints[2289] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/restart", "POST");
            Endpoints[2290] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/skus", "GET");
            Endpoints[2291] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/start", "POST");
            Endpoints[2292] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds", "GET");
            Endpoints[2293] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks", "GET");
            Endpoints[2294] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/getBuildSourceUploadUrl", "POST");
            Endpoints[2295] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/getCredentials", "POST");
            Endpoints[2296] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importImage", "POST");
            Endpoints[2297] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listCredentials", "POST");
            Endpoints[2298] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listUsages", "GET");
            Endpoints[2299] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/queueBuild", "POST");
            Endpoints[2300] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/regenerateCredential", "POST");
            Endpoints[2301] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/regenerateCredentials", "POST");
            Endpoints[2302] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications", "GET");
            Endpoints[2303] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks", "GET");
            Endpoints[2304] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies", "GET");
            Endpoints[2305] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors", "GET");
            Endpoints[2306] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions", "GET");
            Endpoints[2307] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi", "GET");
            Endpoints[2308] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links", "GET");
            Endpoints[2309] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions", "GET");
            Endpoints[2310] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles", "GET");
            Endpoints[2311] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks", "GET");
            Endpoints[2312] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships", "GET");
            Endpoints[2313] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments", "GET");
            Endpoints[2314] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roles", "GET");
            Endpoints[2315] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views", "GET");
            Endpoints[2316] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/widgetTypes", "GET");
            Endpoints[2317] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/bookShipmentPickUp", "POST");
            Endpoints[2318] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/cancel", "POST");
            Endpoints[2319] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/copyLogsUri", "POST");
            Endpoints[2320] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/downloadShippingLabel", "POST");
            Endpoints[2321] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/listSecrets", "POST");
            Endpoints[2322] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/jobs/{jobName}/reportIssue", "POST");
            Endpoints[2323] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/datasets", "GET");
            Endpoints[2324] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes", "GET");
            Endpoints[2325] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/linkedservices", "GET");
            Endpoints[2326] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelineruns", "POST");
            Endpoints[2327] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines", "GET");
            Endpoints[2328] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers", "GET");
            Endpoints[2329] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies", "GET");
            Endpoints[2330] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts", "GET");
            Endpoints[2331] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/firewallRules", "GET");
            Endpoints[2332] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts", "GET");
            Endpoints[2333] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/enableKeyVault", "POST");
            Endpoints[2334] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules", "GET");
            Endpoints[2335] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders", "GET");
            Endpoints[2336] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules", "GET");
            Endpoints[2337] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/configurations", "GET");
            Endpoints[2338] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/databases", "GET");
            Endpoints[2339] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/firewallRules", "GET");
            Endpoints[2340] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/logFiles", "GET");
            Endpoints[2341] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/virtualNetworkRules", "GET");
            Endpoints[2342] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/configurations", "GET");
            Endpoints[2343] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/databases", "GET");
            Endpoints[2344] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/firewallRules", "GET");
            Endpoints[2345] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/logFiles", "GET");
            Endpoints[2346] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/virtualNetworkRules", "GET");
            Endpoints[2347] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routingEndpointsHealth", "GET");
            Endpoints[2348] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates", "GET");
            Endpoints[2349] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices", "POST");
            Endpoints[2350] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices", "POST");
            Endpoints[2351] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats", "GET");
            Endpoints[2352] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs", "GET");
            Endpoints[2353] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys", "POST");
            Endpoints[2354] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics", "GET");
            Endpoints[2355] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus", "GET");
            Endpoints[2356] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates", "GET");
            Endpoints[2357] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/listkeys", "POST");
            Endpoints[2358] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/skus", "GET");
            Endpoints[2359] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources", "GET");
            Endpoints[2360] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costinsights", "GET");
            Endpoints[2361] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costs", "GET");
            Endpoints[2362] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages", "GET");
            Endpoints[2363] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/formulas", "GET");
            Endpoints[2364] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/galleryimages", "GET");
            Endpoints[2365] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels", "GET");
            Endpoints[2366] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules", "GET");
            Endpoints[2367] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/servicerunners", "GET");
            Endpoints[2368] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users", "GET");
            Endpoints[2369] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines", "GET");
            Endpoints[2370] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks", "GET");
            Endpoints[2371] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/claimAnyVm", "POST");
            Endpoints[2372] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/createEnvironment", "POST");
            Endpoints[2373] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/exportResourceUsage", "POST");
            Endpoints[2374] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/generateUploadUri", "POST");
            Endpoints[2375] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/listVhds", "POST");
            Endpoints[2376] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules/{name}/execute", "POST");
            Endpoints[2377] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/schedules/{name}/retarget", "POST");
            Endpoints[2378] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/failoverPriorityChange", "POST");
            Endpoints[2379] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listConnectionStrings", "POST");
            Endpoints[2380] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/listKeys", "POST");
            Endpoints[2381] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metricDefinitions", "GET");
            Endpoints[2382] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/metrics", "GET");
            Endpoints[2383] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/offlineRegion", "POST");
            Endpoints[2384] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/onlineRegion", "POST");
            Endpoints[2385] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/readonlykeys", "GET");
            Endpoints[2386] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/regenerateKey", "POST");
            Endpoints[2387] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/usages", "GET");
            Endpoints[2388] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers", "GET");
            Endpoints[2389] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/renew", "POST");
            Endpoints[2390] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/eventSubscriptions", "GET");
            Endpoints[2391] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/listKeys", "POST");
            Endpoints[2392] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}/regenerateKey", "POST");
            Endpoints[2393] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topicTypes/{topicTypeName}/eventSubscriptions", "GET");
            Endpoints[2394] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules", "POST");
            Endpoints[2395] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules", "GET");
            Endpoints[2396] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs", "GET");
            Endpoints[2397] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs", "GET");
            Endpoints[2398] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/messagingplan", "GET");
            Endpoints[2399] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/edgeGatewayPools", "GET");
            Endpoints[2400] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/edgeGateways", "GET");
            Endpoints[2401] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/fileShares", "GET");
            Endpoints[2402] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoleInstances", "GET");
            Endpoints[2403] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoles", "GET");
            Endpoints[2404] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/ipPools", "GET");
            Endpoints[2405] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/logicalNetworks", "GET");
            Endpoints[2406] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/macAddressPools", "GET");
            Endpoints[2407] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes", "GET");
            Endpoints[2408] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnits", "GET");
            Endpoints[2409] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/slbMuxInstances", "GET");
            Endpoints[2410] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/storageSubSystems", "GET");
            Endpoints[2411] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/applications", "GET");
            Endpoints[2412] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/executeScriptActions", "POST");
            Endpoints[2413] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptActions", "GET");
            Endpoints[2414] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory", "GET");
            Endpoints[2415] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}/listBitLockerKeys", "POST");
            Endpoints[2416] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/alerts", "GET");
            Endpoints[2417] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/serviceHealths", "GET");
            Endpoints[2418] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}/subscribe", "POST");
            Endpoints[2419] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents", "GET");
            Endpoints[2420] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{componentName}/webtests", "GET");
            Endpoints[2421] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations", "PUT");
            Endpoints[2422] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations", "GET");
            Endpoints[2423] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys", "GET");
            Endpoints[2424] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys", "POST");
            Endpoints[2425] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures", "PUT");
            Endpoints[2426] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures", "GET");
            Endpoints[2427] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/DefaultWorkItemConfig", "GET");
            Endpoints[2428] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration", "POST");
            Endpoints[2429] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration", "GET");
            Endpoints[2430] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites", "GET");
            Endpoints[2431] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/featurecapabilities", "GET");
            Endpoints[2432] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/getavailablebillingfeatures", "GET");
            Endpoints[2433] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs", "GET");
            Endpoints[2434] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/purge", "POST");
            Endpoints[2435] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/quotastatus", "GET");
            Endpoints[2436] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/syntheticmonitorlocations", "GET");
            Endpoints[2437] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs", "GET");
            Endpoints[2438] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs", "POST");
            Endpoints[2439] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}/status", "GET");
            Endpoints[2440] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets", "GET");
            Endpoints[2441] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements", "GET");
            Endpoints[2442] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies", "GET");
            Endpoints[2443] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/batchConfigurations", "GET");
            Endpoints[2444] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/certificates", "GET");
            Endpoints[2445] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/listCallbackUrl", "POST");
            Endpoints[2446] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/listKeyVaultKeys", "POST");
            Endpoints[2447] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/logTrackingEvents", "POST");
            Endpoints[2448] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps", "GET");
            Endpoints[2449] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners", "GET");
            Endpoints[2450] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/regenerateAccessKey", "POST");
            Endpoints[2451] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas", "GET");
            Endpoints[2452] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/sessions", "GET");
            Endpoints[2453] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys", "GET");
            Endpoints[2454] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/disable", "POST");
            Endpoints[2455] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/enable", "POST");
            Endpoints[2456] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/generateUpgradedDefinition", "POST");
            Endpoints[2457] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/listCallbackUrl", "POST");
            Endpoints[2458] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/listSwagger", "POST");
            Endpoints[2459] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/move", "POST");
            Endpoints[2460] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/regenerateAccessKey", "POST");
            Endpoints[2461] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/run", "POST");
            Endpoints[2462] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs", "GET");
            Endpoints[2463] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/", "GET");
            Endpoints[2464] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/validate", "POST");
            Endpoints[2465] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/versions", "GET");
            Endpoints[2466] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}/commitmentAssociations", "GET");
            Endpoints[2467] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}/usageHistory", "GET");
            Endpoints[2468] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}/CreateRegionalBlob", "POST");
            Endpoints[2469] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}/listKeys", "GET");
            Endpoints[2470] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}/listWorkspaceKeys", "POST");
            Endpoints[2471] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}/resyncStorageKeys", "POST");
            Endpoints[2472] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/checkSystemServicesUpdatesAvailable", "POST");
            Endpoints[2473] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/checkUpdate", "POST");
            Endpoints[2474] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/listKeys", "POST");
            Endpoints[2475] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/updateSystem", "POST");
            Endpoints[2476] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}/updateSystemServices", "POST");
            Endpoints[2477] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces", "GET");
            Endpoints[2478] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/listKeys", "POST");
            Endpoints[2479] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/resyncKeys", "POST");
            Endpoints[2480] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}/listKeys", "POST");
            Endpoints[2481] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Maps/accounts/{accountName}/regenerateKey", "POST");
            Endpoints[2482] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets", "GET");
            Endpoints[2483] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies", "GET");
            Endpoints[2484] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents", "GET");
            Endpoints[2485] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints", "GET");
            Endpoints[2486] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators", "GET");
            Endpoints[2487] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingPolicies", "GET");
            Endpoints[2488] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms", "GET");
            Endpoints[2489] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/listKeys", "POST");
            Endpoints[2490] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/regenerateKey", "POST");
            Endpoints[2491] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{mediaServiceName}/syncStorageKeys", "POST");
            Endpoints[2492] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/assessments", "GET");
            Endpoints[2493] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups", "GET");
            Endpoints[2494] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/keys", "POST");
            Endpoints[2495] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/machines", "GET");
            Endpoints[2496] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendhealth", "POST");
            Endpoints[2497] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/start", "POST");
            Endpoints[2498] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/stop", "POST");
            Endpoints[2499] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}/sharedkey", "GET");
            Endpoints[2500] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}/sharedkey", "PUT");
            Endpoints[2501] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}/vpndeviceconfigurationscript", "POST");
            Endpoints[2502] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/all", "GET");
            Endpoints[2503] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets", "GET");
            Endpoints[2504] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/arpTable", "GET");
            Endpoints[2505] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/authorizations", "GET");
            Endpoints[2506] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings", "GET");
            Endpoints[2507] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/routesTable", "GET");
            Endpoints[2508] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/stats", "GET");
            Endpoints[2509] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings", "GET");
            Endpoints[2510] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools", "GET");
            Endpoints[2511] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/frontendIPConfigurations", "GET");
            Endpoints[2512] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules", "GET");
            Endpoints[2513] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules", "GET");
            Endpoints[2514] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/networkInterfaces", "GET");
            Endpoints[2515] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes", "GET");
            Endpoints[2516] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/effectiveNetworkSecurityGroups", "POST");
            Endpoints[2517] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/effectiveRouteTable", "POST");
            Endpoints[2518] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/ipConfigurations", "GET");
            Endpoints[2519] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/loadBalancers", "GET");
            Endpoints[2520] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/defaultSecurityRules", "GET");
            Endpoints[2521] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/securityRules", "GET");
            Endpoints[2522] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/availableProvidersList", "POST");
            Endpoints[2523] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/azureReachabilityReport", "POST");
            Endpoints[2524] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/configureFlowLog", "POST");
            Endpoints[2525] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors", "GET");
            Endpoints[2526] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectivityCheck", "POST");
            Endpoints[2527] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/ipFlowVerify", "POST");
            Endpoints[2528] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/nextHop", "POST");
            Endpoints[2529] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures", "GET");
            Endpoints[2530] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryFlowLogStatus", "POST");
            Endpoints[2531] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/queryTroubleshootResult", "POST");
            Endpoints[2532] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/securityGroupView", "POST");
            Endpoints[2533] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/topology", "POST");
            Endpoints[2534] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/troubleshoot", "POST");
            Endpoints[2535] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules", "GET");
            Endpoints[2536] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}/routes", "GET");
            Endpoints[2537] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/connections", "GET");
            Endpoints[2538] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnclientpackage", "POST");
            Endpoints[2539] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnprofile", "POST");
            Endpoints[2540] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getAdvertisedRoutes", "POST");
            Endpoints[2541] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getBgpPeerStatus", "POST");
            Endpoints[2542] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getLearnedRoutes", "POST");
            Endpoints[2543] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnclientipsecparameters", "POST");
            Endpoints[2544] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnprofilepackageurl", "POST");
            Endpoints[2545] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/reset", "POST");
            Endpoints[2546] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/setvpnclientipsecparameters", "POST");
            Endpoints[2547] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/supportedvpndevices", "POST");
            Endpoints[2548] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/CheckIPAddressAvailability", "GET");
            Endpoints[2549] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets", "GET");
            Endpoints[2550] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/usages", "GET");
            Endpoints[2551] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/virtualNetworkPeerings", "GET");
            Endpoints[2552] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules", "POST");
            Endpoints[2553] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules", "GET");
            Endpoints[2554] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/checkNotificationHubAvailability", "POST");
            Endpoints[2555] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs", "GET");
            Endpoints[2556] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources", "GET");
            Endpoints[2557] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks", "GET");
            Endpoints[2558] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices", "GET");
            Endpoints[2559] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/managementGroups", "GET");
            Endpoints[2560] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/purge", "POST");
            Endpoints[2561] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches", "GET");
            Endpoints[2562] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/schema", "POST");
            Endpoints[2563] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/search", "POST");
            Endpoints[2564] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/sharedKeys", "POST");
            Endpoints[2565] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs", "GET");
            Endpoints[2566] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/usages", "GET");
            Endpoints[2567] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[2568] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[2569] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[2570] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}/listKeys", "POST");
            Endpoints[2571] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}/regenerateKey", "POST");
            Endpoints[2572] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}/workspaces", "GET");
            Endpoints[2573] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}/resume", "POST");
            Endpoints[2574] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}/skus", "GET");
            Endpoints[2575] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/capacities/{dedicatedCapacityName}/suspend", "POST");
            Endpoints[2576] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationAlertSettings", "GET");
            Endpoints[2577] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationEvents", "GET");
            Endpoints[2578] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics", "GET");
            Endpoints[2579] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs", "GET");
            Endpoints[2580] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationNetworkMappings", "GET");
            Endpoints[2581] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationNetworks", "GET");
            Endpoints[2582] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies", "GET");
            Endpoints[2583] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationProtectedItems", "GET");
            Endpoints[2584] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationProtectionContainerMappings", "GET");
            Endpoints[2585] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationProtectionContainers", "GET");
            Endpoints[2586] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans", "GET");
            Endpoints[2587] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryServicesProviders", "GET");
            Endpoints[2588] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationStorageClassificationMappings", "GET");
            Endpoints[2589] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationStorageClassifications", "GET");
            Endpoints[2590] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationVaultHealth", "GET");
            Endpoints[2591] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationvCenters", "GET");
            Endpoints[2592] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines", "GET");
            Endpoints[2593] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupJobs", "GET");
            Endpoints[2594] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupJobsExport", "POST");
            Endpoints[2595] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies", "GET");
            Endpoints[2596] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupProtectableItems", "GET");
            Endpoints[2597] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupProtectedItems", "GET");
            Endpoints[2598] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupProtectionContainers", "GET");
            Endpoints[2599] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupSecurityPIN", "POST");
            Endpoints[2600] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupUsageSummaries", "GET");
            Endpoints[2601] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/replicationUsages", "GET");
            Endpoints[2602] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/usages", "GET");
            Endpoints[2603] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules", "GET");
            Endpoints[2604] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/AuthorizationRules", "POST");
            Endpoints[2605] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections", "GET");
            Endpoints[2606] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays", "GET");
            Endpoints[2607] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel", "POST");
            Endpoints[2608] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate", "POST");
            Endpoints[2609] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate", "POST");
            Endpoints[2610] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/disable", "POST");
            Endpoints[2611] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/enable", "POST");
            Endpoints[2612] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs", "GET");
            Endpoints[2613] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listAdminKeys", "POST");
            Endpoints[2614] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listQueryKeys", "GET");
            Endpoints[2615] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts", "GET");
            Endpoints[2616] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies", "GET");
            Endpoints[2617] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/tasks", "GET");
            Endpoints[2618] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}/profile", "POST");
            Endpoints[2619] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}/regenerateprofile", "POST");
            Endpoints[2620] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}/upgradetolatest", "POST");
            Endpoints[2621] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules", "POST");
            Endpoints[2622] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules", "GET");
            Endpoints[2623] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs", "GET");
            Endpoints[2624] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/eventhubs", "GET");
            Endpoints[2625] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/messagingplan", "GET");
            Endpoints[2626] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/messagingplan", "PUT");
            Endpoints[2627] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations", "GET");
            Endpoints[2628] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues", "GET");
            Endpoints[2629] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics", "GET");
            Endpoints[2630] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications", "GET");
            Endpoints[2631] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes", "GET");
            Endpoints[2632] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR/{resourceName}/listKeys", "POST");
            Endpoints[2633] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/SignalR/{resourceName}/regenerateKey", "POST");
            Endpoints[2634] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups", "GET");
            Endpoints[2635] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases", "GET");
            Endpoints[2636] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators", "GET");
            Endpoints[2637] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/advisors", "GET");
            Endpoints[2638] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/auditingPolicies", "GET");
            Endpoints[2639] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults", "GET");
            Endpoints[2640] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks", "GET");
            Endpoints[2641] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases", "GET");
            Endpoints[2642] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration", "GET");
            Endpoints[2643] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases", "GET");
            Endpoints[2644] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools", "GET");
            Endpoints[2645] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector", "GET");
            Endpoints[2646] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups", "GET");
            Endpoints[2647] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules", "PUT");
            Endpoints[2648] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules", "GET");
            Endpoints[2649] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/import", "POST");
            Endpoints[2650] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents", "GET");
            Endpoints[2651] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys", "GET");
            Endpoints[2652] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools", "GET");
            Endpoints[2653] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recoverableDatabases", "GET");
            Endpoints[2654] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/restorableDroppedDatabases", "GET");
            Endpoints[2655] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/serviceObjectives", "GET");
            Endpoints[2656] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents", "GET");
            Endpoints[2657] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/usages", "GET");
            Endpoints[2658] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules", "GET");
            Endpoints[2659] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/acquisitions", "GET");
            Endpoints[2660] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/metricdefinitions", "GET");
            Endpoints[2661] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/metrics", "GET");
            Endpoints[2662] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/ondemandgc", "POST");
            Endpoints[2663] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares", "GET");
            Endpoints[2664] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/storageaccounts", "GET");
            Endpoints[2665] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/ListAccountSas", "POST");
            Endpoints[2666] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/listKeys", "POST");
            Endpoints[2667] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/ListServiceSas", "POST");
            Endpoints[2668] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/regenerateKey", "POST");
            Endpoints[2669] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/accessControlRecords", "GET");
            Endpoints[2670] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/alerts", "GET");
            Endpoints[2671] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/bandwidthSettings", "GET");
            Endpoints[2672] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/clearAlerts", "POST");
            Endpoints[2673] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/cloudApplianceConfigurations", "GET");
            Endpoints[2674] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/configureDevice", "POST");
            Endpoints[2675] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices", "GET");
            Endpoints[2676] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/features", "GET");
            Endpoints[2677] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/jobs", "GET");
            Endpoints[2678] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/listActivationKey", "POST");
            Endpoints[2679] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/listPublicEncryptionKey", "POST");
            Endpoints[2680] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metrics", "GET");
            Endpoints[2681] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metricsDefinitions", "GET");
            Endpoints[2682] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/provisionCloudAppliance", "POST");
            Endpoints[2683] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/regenerateActivationKey", "POST");
            Endpoints[2684] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/storageAccountCredentials", "GET");
            Endpoints[2685] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions", "GET");
            Endpoints[2686] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs", "GET");
            Endpoints[2687] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs", "GET");
            Endpoints[2688] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/start", "POST");
            Endpoints[2689] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/stop", "POST");
            Endpoints[2690] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/link", "POST");
            Endpoints[2691] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/MetricDefinitions", "GET");
            Endpoints[2692] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/Metrics", "GET");
            Endpoints[2693] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/offerDelegations", "GET");
            Endpoints[2694] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/unlink", "POST");
            Endpoints[2695] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/plans/{plan}/MetricDefinitions", "GET");
            Endpoints[2696] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/plans/{plan}/Metrics", "GET");
            Endpoints[2697] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies", "GET");
            Endpoints[2698] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources", "GET");
            Endpoints[2699] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets", "GET");
            Endpoints[2700] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}/updates", "GET");
            Endpoints[2701] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension", "GET");
            Endpoints[2702] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project", "GET");
            Endpoints[2703] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web.Admin/environments/{environmentName}/usage", "GET");
            Endpoints[2704] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}/confirmConsentCode", "POST");
            Endpoints[2705] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}/listConnectionKeys", "POST");
            Endpoints[2706] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connections/{connectionName}/listConsentLinks", "POST");
            Endpoints[2707] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}/move", "POST");
            Endpoints[2708] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/changeVirtualNetwork", "POST");
            Endpoints[2709] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors", "GET");
            Endpoints[2710] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics", "GET");
            Endpoints[2711] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions", "GET");
            Endpoints[2712] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics", "GET");
            Endpoints[2713] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools", "GET");
            Endpoints[2714] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations", "GET");
            Endpoints[2715] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot", "POST");
            Endpoints[2716] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume", "POST");
            Endpoints[2717] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms", "GET");
            Endpoints[2718] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites", "GET");
            Endpoints[2719] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend", "POST");
            Endpoints[2720] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/syncVirtualNetwork", "POST");
            Endpoints[2721] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages", "GET");
            Endpoints[2722] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/webhostingplans", "GET");
            Endpoints[2723] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools", "GET");
            Endpoints[2724] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/serverfarms", "GET");
            Endpoints[2725] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/sites", "GET");
            Endpoints[2726] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/webhostingplans", "GET");
            Endpoints[2727] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/capabilities", "GET");
            Endpoints[2728] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionRelays", "GET");
            Endpoints[2729] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions", "GET");
            Endpoints[2730] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics", "GET");
            Endpoints[2731] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites", "POST");
            Endpoints[2732] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites", "GET");
            Endpoints[2733] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/skus", "GET");
            Endpoints[2734] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/usages", "GET");
            Endpoints[2735] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections", "GET");
            Endpoints[2736] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname", "GET");
            Endpoints[2737] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig", "POST");
            Endpoints[2738] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup", "POST");
            Endpoints[2739] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups", "GET");
            Endpoints[2740] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config", "GET");
            Endpoints[2741] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs", "POST");
            Endpoints[2742] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs", "GET");
            Endpoints[2743] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments", "GET");
            Endpoints[2744] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers", "GET");
            Endpoints[2745] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions", "GET");
            Endpoints[2746] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings", "GET");
            Endpoints[2747] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection", "GET");
            Endpoints[2748] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays", "GET");
            Endpoints[2749] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances", "GET");
            Endpoints[2750] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable", "POST");
            Endpoints[2751] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listsyncfunctiontriggerstatus", "POST");
            Endpoints[2752] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions", "GET");
            Endpoints[2753] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics", "GET");
            Endpoints[2754] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate", "PUT");
            Endpoints[2755] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql", "POST");
            Endpoints[2756] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword", "POST");
            Endpoints[2757] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters", "GET");
            Endpoints[2758] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging", "GET");
            Endpoints[2759] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons", "GET");
            Endpoints[2760] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes", "GET");
            Endpoints[2761] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates", "GET");
            Endpoints[2762] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml", "POST");
            Endpoints[2763] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/recover", "POST");
            Endpoints[2764] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig", "POST");
            Endpoints[2765] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata", "GET");
            Endpoints[2766] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart", "POST");
            Endpoints[2767] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromBackupBlob", "POST");
            Endpoints[2768] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromDeletedApp", "POST");
            Endpoints[2769] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreSnapshot", "POST");
            Endpoints[2770] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions", "GET");
            Endpoints[2771] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots", "GET");
            Endpoints[2772] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs", "POST");
            Endpoints[2773] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap", "POST");
            Endpoints[2774] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots", "GET");
            Endpoints[2775] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots", "PUT");
            Endpoints[2776] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start", "POST");
            Endpoints[2777] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop", "POST");
            Endpoints[2778] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync", "POST");
            Endpoints[2779] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/syncfunctiontriggers", "POST");
            Endpoints[2780] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs", "GET");
            Endpoints[2781] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages", "GET");
            Endpoints[2782] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections", "GET");
            Endpoints[2783] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs", "GET");
            Endpoints[2784] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors", "GET");
            Endpoints[2785] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics", "GET");
            Endpoints[2786] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory", "GET");
            Endpoints[2787] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations", "GET");
            Endpoints[2788] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/delegation", "PUT");
            Endpoints[2789] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/delegation", "PATCH");
            Endpoints[2790] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/delegation", "HEAD");
            Endpoints[2791] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/delegation", "GET");
            Endpoints[2792] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signin", "PATCH");
            Endpoints[2793] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signin", "PUT");
            Endpoints[2794] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signin", "GET");
            Endpoints[2795] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signin", "HEAD");
            Endpoints[2796] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signup", "PUT");
            Endpoints[2797] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signup", "GET");
            Endpoints[2798] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signup", "HEAD");
            Endpoints[2799] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/portalsettings/signup", "PATCH");
            Endpoints[2800] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byApi", "GET");
            Endpoints[2801] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byGeo", "GET");
            Endpoints[2802] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byOperation", "GET");
            Endpoints[2803] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byProduct", "GET");
            Endpoints[2804] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byRequest", "GET");
            Endpoints[2805] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/bySubscription", "GET");
            Endpoints[2806] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byTime", "GET");
            Endpoints[2807] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/byUser", "GET");
            Endpoints[2808] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access", "GET");
            Endpoints[2809] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access", "PATCH");
            Endpoints[2810] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/policy", "GET");
            Endpoints[2811] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/policy", "DELETE");
            Endpoints[2812] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/policy", "PUT");
            Endpoints[2813] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/agentRegistrationInformation/regenerateKey", "POST");
            Endpoints[2814] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/generateUri", "POST");
            Endpoints[2815] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/default", "PUT");
            Endpoints[2816] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/default", "DELETE");
            Endpoints[2817] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/default", "GET");
            Endpoints[2818] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/rollingUpgrades/cancel", "POST");
            Endpoints[2819] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/rollingUpgrades/latest", "GET");
            Endpoints[2820] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/upgradeProfiles/default", "GET");
            Endpoints[2821] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/images/getDataImageUploadUrl", "POST");
            Endpoints[2822] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/images/getEntityTypeImageUploadUrl", "POST");
            Endpoints[2823] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/percentile/metrics", "GET");
            Endpoints[2824] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/clusters/{clusterName}/quotaConfiguration/default", "PATCH");
            Endpoints[2825] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/clusters/{clusterName}/quotaConfiguration/default", "GET");
            Endpoints[2826] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/CheckNameAvailability", "POST");
            Endpoints[2827] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/extensions/clustermonitoring", "GET");
            Endpoints[2828] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/extensions/clustermonitoring", "PUT");
            Endpoints[2829] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/extensions/clustermonitoring", "DELETE");
            Endpoints[2830] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/pricingPlans/current", "PATCH");
            Endpoints[2831] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/pricingPlans/current", "PUT");
            Endpoints[2832] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/pricingPlans/current", "GET");
            Endpoints[2833] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}/sharedkey/reset", "POST");
            Endpoints[2834] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/export", "POST");
            Endpoints[2835] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupconfig/vaultconfig", "GET");
            Endpoints[2836] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupconfig/vaultconfig", "PATCH");
            Endpoints[2837] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupstorageconfig/vaultstorageconfig", "PATCH");
            Endpoints[2838] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupstorageconfig/vaultstorageconfig", "GET");
            Endpoints[2839] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/extendedInformation/vaultExtendedInfo", "PATCH");
            Endpoints[2840] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/extendedInformation/vaultExtendedInfo", "PUT");
            Endpoints[2841] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/extendedInformation/vaultExtendedInfo", "GET");
            Endpoints[2842] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/CheckNameAvailability", "POST");
            Endpoints[2843] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/automaticTuning/current", "GET");
            Endpoints[2844] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/automaticTuning/current", "PATCH");
            Endpoints[2845] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/encryptionSettings/default", "GET");
            Endpoints[2846] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", "DELETE");
            Endpoints[2847] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", "PATCH");
            Endpoints[2848] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", "PUT");
            Endpoints[2849] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo", "GET");
            Endpoints[2850] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute", "GET");
            Endpoints[2851] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip", "GET");
            Endpoints[2852] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", "PUT");
            Endpoints[2853] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", "PATCH");
            Endpoints[2854] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", "GET");
            Endpoints[2855] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/capacities/virtualip", "GET");
            Endpoints[2856] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionPlanLimits/limit", "GET");
            Endpoints[2857] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover", "PUT");
            Endpoints[2858] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings", "PUT");
            Endpoints[2859] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings", "PUT");
            Endpoints[2860] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", "DELETE");
            Endpoints[2861] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", "PUT");
            Endpoints[2862] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings", "PUT");
            Endpoints[2863] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", "PUT");
            Endpoints[2864] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", "GET");
            Endpoints[2865] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata", "PUT");
            Endpoints[2866] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings", "PUT");
            Endpoints[2867] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", "PUT");
            Endpoints[2868] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", "GET");
            Endpoints[2869] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", "PUT");
            Endpoints[2870] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", "GET");
            Endpoints[2871] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", "PATCH");
            Endpoints[2872] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy", "PUT");
            Endpoints[2873] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy", "GET");
            Endpoints[2874] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status", "GET");
            Endpoints[2875] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start", "POST");
            Endpoints[2876] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop", "POST");
            Endpoints[2877] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks", "PUT");
            Endpoints[2878] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks", "GET");
            Endpoints[2879] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata/default", "GET");
            Endpoints[2880] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", "PATCH");
            Endpoints[2881] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", "DELETE");
            Endpoints[2882] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", "GET");
            Endpoints[2883] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", "PUT");
            Endpoints[2884] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable", "POST");
            Endpoints[2885] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset", "POST");
            Endpoints[2886] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access/git", "GET");
            Endpoints[2887] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access/regeneratePrimaryKey", "POST");
            Endpoints[2888] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access/regenerateSecondaryKey", "POST");
            Endpoints[2889] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/configuration/deploy", "POST");
            Endpoints[2890] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/configuration/save", "POST");
            Endpoints[2891] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/configuration/syncState", "GET");
            Endpoints[2892] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/configuration/validate", "POST");
            Endpoints[2893] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testall", "POST");
            Endpoints[2894] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testnew", "POST");
            Endpoints[2895] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/generateMap", "POST");
            Endpoints[2896] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups", "GET");
            Endpoints[2897] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups", "POST");
            Endpoints[2898] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines", "GET");
            Endpoints[2899] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationVaultHealth/default/refresh", "POST");
            Endpoints[2900] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers", "GET");
            Endpoints[2901] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions", "GET");
            Endpoints[2902] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics", "GET");
            Endpoints[2903] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus", "GET");
            Endpoints[2904] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages", "GET");
            Endpoints[2905] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list", "POST");
            Endpoints[2906] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list", "POST");
            Endpoints[2907] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list", "POST");
            Endpoints[2908] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list", "POST");
            Endpoints[2909] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list", "POST");
            Endpoints[2910] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list", "POST");
            Endpoints[2911] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list", "POST");
            Endpoints[2912] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots", "GET");
            Endpoints[2913] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs/zip/download", "POST");
            Endpoints[2914] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log", "GET");
            Endpoints[2915] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token", "GET");
            Endpoints[2916] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access/git/regeneratePrimaryKey", "POST");
            Endpoints[2917] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/access/git/regenerateSecondaryKey", "POST");
            Endpoints[2918] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/summaries/machines", "GET");
            Endpoints[2919] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/clientGroups/{clientGroupName}", "GET");
            Endpoints[2920] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups/{machineGroupName}", "GET");
            Endpoints[2921] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups/{machineGroupName}", "DELETE");
            Endpoints[2922] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups/{machineGroupName}", "PUT");
            Endpoints[2923] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}", "GET");
            Endpoints[2924] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}", "PATCH");
            Endpoints[2925] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}", "GET");
            Endpoints[2926] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}", "DELETE");
            Endpoints[2927] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}", "PUT");
            Endpoints[2928] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}", "GET");
            Endpoints[2929] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/clientGroups/{clientGroupName}/members", "GET");
            Endpoints[2930] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/clientGroups/{clientGroupName}/membersCount", "GET");
            Endpoints[2931] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/connections", "GET");
            Endpoints[2932] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/liveness", "GET");
            Endpoints[2933] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/machineGroups", "GET");
            Endpoints[2934] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/ports", "GET");
            Endpoints[2935] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/processes", "GET");
            Endpoints[2936] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold", "POST");
            Endpoints[2937] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold", "POST");
            Endpoints[2938] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions", "GET");
            Endpoints[2939] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metrics", "GET");
            Endpoints[2940] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}/recover", "POST");
            Endpoints[2941] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend", "POST");
            Endpoints[2942] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock", "POST");
            Endpoints[2943] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/ports/{portName}", "GET");
            Endpoints[2944] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/processes/{processName}", "GET");
            Endpoints[2945] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}", "GET");
            Endpoints[2946] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}", "PUT");
            Endpoints[2947] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}", "DELETE");
            Endpoints[2948] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/ports/{portName}/acceptingProcesses", "GET");
            Endpoints[2949] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/ports/{portName}/connections", "GET");
            Endpoints[2950] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/ports/{portName}/liveness", "GET");
            Endpoints[2951] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/processes/{processName}/acceptingPorts", "GET");
            Endpoints[2952] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/processes/{processName}/connections", "GET");
            Endpoints[2953] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machines/{machineName}/processes/{processName}/liveness", "GET");
            Endpoints[2954] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupJobs/operationResults/{operationId}", "GET");
            Endpoints[2955] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/operationresults/{operationId}", "POST");
            Endpoints[2956] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/operationresults/{operationId}", "GET");
            Endpoints[2957] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes/{computeName}", "PUT");
            Endpoints[2958] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes/{computeName}", "DELETE");
            Endpoints[2959] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes/{computeName}", "GET");
            Endpoints[2960] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}", "PATCH");
            Endpoints[2961] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}", "DELETE");
            Endpoints[2962] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}", "GET");
            Endpoints[2963] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}", "PUT");
            Endpoints[2964] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}", "PARAMETERS");
            Endpoints[2965] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}/downloadedProducts/{productName}", "GET");
            Endpoints[2966] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}/downloadedProducts/{productName}", "DELETE");
            Endpoints[2967] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}/products/{productName}", "GET");
            Endpoints[2968] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/customerSubscriptions/{customerSubscriptionName}", "PUT");
            Endpoints[2969] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/customerSubscriptions/{customerSubscriptionName}", "GET");
            Endpoints[2970] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/customerSubscriptions/{customerSubscriptionName}", "DELETE");
            Endpoints[2971] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/products/{productName}", "GET");
            Endpoints[2972] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}", "PATCH");
            Endpoints[2973] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}", "DELETE");
            Endpoints[2974] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}", "HEAD");
            Endpoints[2975] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}", "GET");
            Endpoints[2976] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}", "PUT");
            Endpoints[2977] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets/{versionSetId}", "HEAD");
            Endpoints[2978] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets/{versionSetId}", "DELETE");
            Endpoints[2979] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets/{versionSetId}", "GET");
            Endpoints[2980] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets/{versionSetId}", "PUT");
            Endpoints[2981] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets/{versionSetId}", "PATCH");
            Endpoints[2982] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/api-version-sets/{versionSetId}", "PARAMETERS");
            Endpoints[2983] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers/{authsid}", "HEAD");
            Endpoints[2984] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers/{authsid}", "GET");
            Endpoints[2985] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers/{authsid}", "DELETE");
            Endpoints[2986] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers/{authsid}", "PATCH");
            Endpoints[2987] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationServers/{authsid}", "PUT");
            Endpoints[2988] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendid}", "PUT");
            Endpoints[2989] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendid}", "GET");
            Endpoints[2990] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendid}", "PATCH");
            Endpoints[2991] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendid}", "DELETE");
            Endpoints[2992] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendid}", "HEAD");
            Endpoints[2993] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/certificates/{certificateId}", "HEAD");
            Endpoints[2994] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/certificates/{certificateId}", "GET");
            Endpoints[2995] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/certificates/{certificateId}", "PUT");
            Endpoints[2996] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/certificates/{certificateId}", "DELETE");
            Endpoints[2997] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}", "HEAD");
            Endpoints[2998] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}", "GET");
            Endpoints[2999] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}", "PUT");
            Endpoints[3000] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}", "PATCH");
            Endpoints[3001] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}", "DELETE");
            Endpoints[3002] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}", "DELETE");
            Endpoints[3003] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}", "PATCH");
            Endpoints[3004] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}", "HEAD");
            Endpoints[3005] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}", "GET");
            Endpoints[3006] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}", "PUT");
            Endpoints[3007] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders/{identityProviderName}", "HEAD");
            Endpoints[3008] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders/{identityProviderName}", "GET");
            Endpoints[3009] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders/{identityProviderName}", "DELETE");
            Endpoints[3010] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders/{identityProviderName}", "PUT");
            Endpoints[3011] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders/{identityProviderName}", "PATCH");
            Endpoints[3012] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerid}", "PUT");
            Endpoints[3013] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerid}", "GET");
            Endpoints[3014] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerid}", "HEAD");
            Endpoints[3015] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerid}", "PATCH");
            Endpoints[3016] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerid}", "DELETE");
            Endpoints[3017] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}", "PUT");
            Endpoints[3018] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}", "GET");
            Endpoints[3019] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}", "GET");
            Endpoints[3020] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}", "HEAD");
            Endpoints[3021] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}", "PUT");
            Endpoints[3022] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}", "PATCH");
            Endpoints[3023] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}", "DELETE");
            Endpoints[3024] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policies/{policyId}", "DELETE");
            Endpoints[3025] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policies/{policyId}", "GET");
            Endpoints[3026] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policies/{policyId}", "HEAD");
            Endpoints[3027] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policies/{policyId}", "PUT");
            Endpoints[3028] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}", "DELETE");
            Endpoints[3029] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}", "PUT");
            Endpoints[3030] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}", "PATCH");
            Endpoints[3031] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}", "GET");
            Endpoints[3032] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}", "HEAD");
            Endpoints[3033] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/properties/{propId}", "GET");
            Endpoints[3034] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/properties/{propId}", "PUT");
            Endpoints[3035] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/properties/{propId}", "PATCH");
            Endpoints[3036] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/properties/{propId}", "DELETE");
            Endpoints[3037] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/properties/{propId}", "HEAD");
            Endpoints[3038] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}", "GET");
            Endpoints[3039] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}", "PATCH");
            Endpoints[3040] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/reports/{aggregation}", "GET");
            Endpoints[3041] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}", "DELETE");
            Endpoints[3042] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}", "HEAD");
            Endpoints[3043] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}", "GET");
            Endpoints[3044] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}", "PUT");
            Endpoints[3045] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}", "PATCH");
            Endpoints[3046] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}", "HEAD");
            Endpoints[3047] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}", "GET");
            Endpoints[3048] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}", "DELETE");
            Endpoints[3049] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}", "PATCH");
            Endpoints[3050] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}", "PUT");
            Endpoints[3051] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}", "PATCH");
            Endpoints[3052] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}", "GET");
            Endpoints[3053] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}", "HEAD");
            Endpoints[3054] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}", "DELETE");
            Endpoints[3055] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}", "PUT");
            Endpoints[3056] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}", "GET");
            Endpoints[3057] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}", "PATCH");
            Endpoints[3058] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}", "DELETE");
            Endpoints[3059] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}", "PATCH");
            Endpoints[3060] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}", "HEAD");
            Endpoints[3061] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}", "GET");
            Endpoints[3062] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}", "PUT");
            Endpoints[3063] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/certificates/{certificateName}", "DELETE");
            Endpoints[3064] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/certificates/{certificateName}", "GET");
            Endpoints[3065] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/certificates/{certificateName}", "PUT");
            Endpoints[3066] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/certificates/{certificateName}", "PATCH");
            Endpoints[3067] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{compilationJobName}", "PUT");
            Endpoints[3068] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{compilationJobName}", "GET");
            Endpoints[3069] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}", "DELETE");
            Endpoints[3070] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}", "GET");
            Endpoints[3071] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}", "PUT");
            Endpoints[3072] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}", "PATCH");
            Endpoints[3073] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections/{connectionName}", "GET");
            Endpoints[3074] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections/{connectionName}", "PATCH");
            Endpoints[3075] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections/{connectionName}", "PUT");
            Endpoints[3076] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections/{connectionName}", "DELETE");
            Endpoints[3077] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connectionTypes/{connectionTypeName}", "PUT");
            Endpoints[3078] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connectionTypes/{connectionTypeName}", "DELETE");
            Endpoints[3079] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connectionTypes/{connectionTypeName}", "GET");
            Endpoints[3080] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials/{credentialName}", "PATCH");
            Endpoints[3081] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials/{credentialName}", "GET");
            Endpoints[3082] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials/{credentialName}", "DELETE");
            Endpoints[3083] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials/{credentialName}", "PUT");
            Endpoints[3084] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}", "PATCH");
            Endpoints[3085] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}", "GET");
            Endpoints[3086] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/hybridRunbookWorkerGroups/{hybridRunbookWorkerGroupName}", "DELETE");
            Endpoints[3087] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}", "PUT");
            Endpoints[3088] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}", "GET");
            Endpoints[3089] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobSchedules/{jobScheduleId}", "GET");
            Endpoints[3090] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobSchedules/{jobScheduleId}", "PUT");
            Endpoints[3091] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobSchedules/{jobScheduleId}", "DELETE");
            Endpoints[3092] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}", "GET");
            Endpoints[3093] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}", "PUT");
            Endpoints[3094] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}", "DELETE");
            Endpoints[3095] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}", "PATCH");
            Endpoints[3096] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodeConfigurations/{nodeConfigurationName}", "GET");
            Endpoints[3097] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodeConfigurations/{nodeConfigurationName}", "DELETE");
            Endpoints[3098] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodeConfigurations/{nodeConfigurationName}", "PUT");
            Endpoints[3099] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodecounts/{countType}", "GET");
            Endpoints[3100] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes/{nodeId}", "GET");
            Endpoints[3101] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes/{nodeId}", "DELETE");
            Endpoints[3102] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes/{nodeId}", "PATCH");
            Endpoints[3103] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}", "GET");
            Endpoints[3104] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}", "PUT");
            Endpoints[3105] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}", "DELETE");
            Endpoints[3106] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}", "PATCH");
            Endpoints[3107] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules/{scheduleName}", "DELETE");
            Endpoints[3108] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules/{scheduleName}", "GET");
            Endpoints[3109] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules/{scheduleName}", "PATCH");
            Endpoints[3110] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/schedules/{scheduleName}", "PUT");
            Endpoints[3111] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurationMachineRuns/{softwareUpdateConfigurationMachineRunId}", "GET");
            Endpoints[3112] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurationRuns/{softwareUpdateConfigurationRunId}", "GET");
            Endpoints[3113] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}", "PUT");
            Endpoints[3114] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}", "GET");
            Endpoints[3115] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}", "DELETE");
            Endpoints[3116] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}", "GET");
            Endpoints[3117] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}", "PUT");
            Endpoints[3118] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}", "DELETE");
            Endpoints[3119] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}", "PATCH");
            Endpoints[3120] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables/{variableName}", "PATCH");
            Endpoints[3121] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables/{variableName}", "GET");
            Endpoints[3122] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables/{variableName}", "PUT");
            Endpoints[3123] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/variables/{variableName}", "DELETE");
            Endpoints[3124] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}", "DELETE");
            Endpoints[3125] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}", "PATCH");
            Endpoints[3126] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}", "GET");
            Endpoints[3127] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}", "PUT");
            Endpoints[3128] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/{webhookName}", "PUT");
            Endpoints[3129] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/{webhookName}", "GET");
            Endpoints[3130] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/{webhookName}", "PATCH");
            Endpoints[3131] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/webhooks/{webhookName}", "DELETE");
            Endpoints[3132] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations/{location}/backups/{backup}", "GET");
            Endpoints[3133] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}", "PATCH");
            Endpoints[3134] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}", "GET");
            Endpoints[3135] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}", "DELETE");
            Endpoints[3136] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}", "PUT");
            Endpoints[3137] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", "PATCH");
            Endpoints[3138] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", "GET");
            Endpoints[3139] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", "DELETE");
            Endpoints[3140] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", "PUT");
            Endpoints[3141] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", "GET");
            Endpoints[3142] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", "PATCH");
            Endpoints[3143] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", "PUT");
            Endpoints[3144] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", "DELETE");
            Endpoints[3145] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}", "PUT");
            Endpoints[3146] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}", "PATCH");
            Endpoints[3147] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}", "GET");
            Endpoints[3148] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}", "DELETE");
            Endpoints[3149] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}", "GET");
            Endpoints[3150] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}", "DELETE");
            Endpoints[3151] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}", "PUT");
            Endpoints[3152] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}", "PUT");
            Endpoints[3153] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}", "GET");
            Endpoints[3154] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/fileServers/{fileServerName}", "DELETE");
            Endpoints[3155] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}", "GET");
            Endpoints[3156] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}", "DELETE");
            Endpoints[3157] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}", "PUT");
            Endpoints[3158] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}", "PATCH");
            Endpoints[3159] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/Connections/{connectionName}", "PUT");
            Endpoints[3160] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/Connections/{connectionName}", "GET");
            Endpoints[3161] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/Connections/{connectionName}", "PATCH");
            Endpoints[3162] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/Connections/{connectionName}", "DELETE");
            Endpoints[3163] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules/{ruleName}", "GET");
            Endpoints[3164] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules/{ruleName}", "PUT");
            Endpoints[3165] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{cacheName}/firewallRules/{ruleName}", "DELETE");
            Endpoints[3166] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}", "PUT");
            Endpoints[3167] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}", "GET");
            Endpoints[3168] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}", "DELETE");
            Endpoints[3169] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}", "GET");
            Endpoints[3170] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}", "DELETE");
            Endpoints[3171] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/patchSchedules/{default}", "PUT");
            Endpoints[3172] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", "GET");
            Endpoints[3173] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", "PUT");
            Endpoints[3174] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", "DELETE");
            Endpoints[3175] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", "PATCH");
            Endpoints[3176] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", "GET");
            Endpoints[3177] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", "PUT");
            Endpoints[3178] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", "DELETE");
            Endpoints[3179] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", "PATCH");
            Endpoints[3180] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}", "GET");
            Endpoints[3181] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}", "DELETE");
            Endpoints[3182] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}", "PUT");
            Endpoints[3183] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions/{vmExtensionName}", "PUT");
            Endpoints[3184] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions/{vmExtensionName}", "PATCH");
            Endpoints[3185] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions/{vmExtensionName}", "DELETE");
            Endpoints[3186] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions/{vmExtensionName}", "GET");
            Endpoints[3187] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensions/{vmssExtensionName}", "PUT");
            Endpoints[3188] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensions/{vmssExtensionName}", "DELETE");
            Endpoints[3189] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/extensions/{vmssExtensionName}", "GET");
            Endpoints[3190] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}", "PUT");
            Endpoints[3191] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}", "DELETE");
            Endpoints[3192] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}", "GET");
            Endpoints[3193] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}", "PATCH");
            Endpoints[3194] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}", "GET");
            Endpoints[3195] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", "PATCH");
            Endpoints[3196] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", "DELETE");
            Endpoints[3197] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", "PUT");
            Endpoints[3198] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}", "GET");
            Endpoints[3199] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", "PATCH");
            Endpoints[3200] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", "PUT");
            Endpoints[3201] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", "GET");
            Endpoints[3202] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}", "DELETE");
            Endpoints[3203] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", "DELETE");
            Endpoints[3204] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", "GET");
            Endpoints[3205] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", "PUT");
            Endpoints[3206] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}", "PATCH");
            Endpoints[3207] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/accessProfiles/{roleName}", "GET");
            Endpoints[3208] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}", "PUT");
            Endpoints[3209] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}", "GET");
            Endpoints[3210] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}", "DELETE");
            Endpoints[3211] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}", "PUT");
            Endpoints[3212] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}", "GET");
            Endpoints[3213] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}", "PUT");
            Endpoints[3214] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}", "GET");
            Endpoints[3215] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}", "DELETE");
            Endpoints[3216] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}", "PUT");
            Endpoints[3217] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}", "GET");
            Endpoints[3218] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}", "PUT");
            Endpoints[3219] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}", "GET");
            Endpoints[3220] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/links/{linkName}", "DELETE");
            Endpoints[3221] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}", "DELETE");
            Endpoints[3222] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}", "PUT");
            Endpoints[3223] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}", "GET");
            Endpoints[3224] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}", "GET");
            Endpoints[3225] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}", "DELETE");
            Endpoints[3226] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}", "PUT");
            Endpoints[3227] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}", "GET");
            Endpoints[3228] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}", "DELETE");
            Endpoints[3229] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}", "PUT");
            Endpoints[3230] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}", "GET");
            Endpoints[3231] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}", "DELETE");
            Endpoints[3232] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}", "PUT");
            Endpoints[3233] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}", "DELETE");
            Endpoints[3234] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}", "PUT");
            Endpoints[3235] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/roleAssignments/{assignmentName}", "GET");
            Endpoints[3236] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}", "GET");
            Endpoints[3237] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}", "DELETE");
            Endpoints[3238] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}", "PUT");
            Endpoints[3239] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/widgetTypes/{widgetTypeName}", "GET");
            Endpoints[3240] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/cancelpipelinerun/{runId}", "POST");
            Endpoints[3241] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/datasets/{datasetName}", "DELETE");
            Endpoints[3242] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/datasets/{datasetName}", "PUT");
            Endpoints[3243] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/datasets/{datasetName}", "GET");
            Endpoints[3244] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}", "GET");
            Endpoints[3245] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}", "PATCH");
            Endpoints[3246] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}", "DELETE");
            Endpoints[3247] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}", "PUT");
            Endpoints[3248] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/linkedservices/{linkedServiceName}", "GET");
            Endpoints[3249] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/linkedservices/{linkedServiceName}", "DELETE");
            Endpoints[3250] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/linkedservices/{linkedServiceName}", "PUT");
            Endpoints[3251] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelineruns/{runId}", "GET");
            Endpoints[3252] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}", "GET");
            Endpoints[3253] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}", "PUT");
            Endpoints[3254] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}", "DELETE");
            Endpoints[3255] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}", "GET");
            Endpoints[3256] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}", "DELETE");
            Endpoints[3257] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}", "PUT");
            Endpoints[3258] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}", "PUT");
            Endpoints[3259] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}", "GET");
            Endpoints[3260] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}", "PATCH");
            Endpoints[3261] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}", "DELETE");
            Endpoints[3262] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts/{dataLakeStoreAccountName}", "GET");
            Endpoints[3263] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts/{dataLakeStoreAccountName}", "PUT");
            Endpoints[3264] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/dataLakeStoreAccounts/{dataLakeStoreAccountName}", "DELETE");
            Endpoints[3265] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/firewallRules/{firewallRuleName}", "PUT");
            Endpoints[3266] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/firewallRules/{firewallRuleName}", "GET");
            Endpoints[3267] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/firewallRules/{firewallRuleName}", "PATCH");
            Endpoints[3268] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/firewallRules/{firewallRuleName}", "DELETE");
            Endpoints[3269] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}", "PUT");
            Endpoints[3270] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}", "PATCH");
            Endpoints[3271] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}", "GET");
            Endpoints[3272] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}", "DELETE");
            Endpoints[3273] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", "GET");
            Endpoints[3274] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", "PUT");
            Endpoints[3275] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", "DELETE");
            Endpoints[3276] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", "PATCH");
            Endpoints[3277] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}", "PATCH");
            Endpoints[3278] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}", "GET");
            Endpoints[3279] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}", "PUT");
            Endpoints[3280] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/trustedIdProviders/{trustedIdProviderName}", "DELETE");
            Endpoints[3281] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules/{virtualNetworkRuleName}", "PUT");
            Endpoints[3282] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules/{virtualNetworkRuleName}", "GET");
            Endpoints[3283] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules/{virtualNetworkRuleName}", "DELETE");
            Endpoints[3284] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/virtualNetworkRules/{virtualNetworkRuleName}", "PATCH");
            Endpoints[3285] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/configurations/{configurationName}", "PUT");
            Endpoints[3286] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/configurations/{configurationName}", "GET");
            Endpoints[3287] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/databases/{databaseName}", "DELETE");
            Endpoints[3288] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/databases/{databaseName}", "GET");
            Endpoints[3289] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/databases/{databaseName}", "PUT");
            Endpoints[3290] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/firewallRules/{firewallRuleName}", "DELETE");
            Endpoints[3291] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/firewallRules/{firewallRuleName}", "GET");
            Endpoints[3292] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/firewallRules/{firewallRuleName}", "PUT");
            Endpoints[3293] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "DELETE");
            Endpoints[3294] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "PUT");
            Endpoints[3295] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "GET");
            Endpoints[3296] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/configurations/{configurationName}", "PUT");
            Endpoints[3297] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/configurations/{configurationName}", "GET");
            Endpoints[3298] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/databases/{databaseName}", "GET");
            Endpoints[3299] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/databases/{databaseName}", "DELETE");
            Endpoints[3300] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/databases/{databaseName}", "PUT");
            Endpoints[3301] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/firewallRules/{firewallRuleName}", "PUT");
            Endpoints[3302] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/firewallRules/{firewallRuleName}", "GET");
            Endpoints[3303] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/firewallRules/{firewallRuleName}", "DELETE");
            Endpoints[3304] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/securityAlertPolicies/{securityAlertPolicyName}", "PUT");
            Endpoints[3305] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/securityAlertPolicies/{securityAlertPolicyName}", "GET");
            Endpoints[3306] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "GET");
            Endpoints[3307] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "DELETE");
            Endpoints[3308] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "PUT");
            Endpoints[3309] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}", "GET");
            Endpoints[3310] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}", "PUT");
            Endpoints[3311] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}", "DELETE");
            Endpoints[3312] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}", "GET");
            Endpoints[3313] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates/{certificateName}", "GET");
            Endpoints[3314] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates/{certificateName}", "PUT");
            Endpoints[3315] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates/{certificateName}", "DELETE");
            Endpoints[3316] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/operationresults/{operationId}", "GET");
            Endpoints[3317] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{name}", "PATCH");
            Endpoints[3318] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{name}", "DELETE");
            Endpoints[3319] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{name}", "PUT");
            Endpoints[3320] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{name}", "GET");
            Endpoints[3321] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costinsights/{name}", "GET");
            Endpoints[3322] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costs/{name}", "GET");
            Endpoints[3323] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costs/{name}", "PUT");
            Endpoints[3324] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages/{name}", "GET");
            Endpoints[3325] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages/{name}", "DELETE");
            Endpoints[3326] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages/{name}", "PUT");
            Endpoints[3327] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/formulas/{name}", "GET");
            Endpoints[3328] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/formulas/{name}", "PUT");
            Endpoints[3329] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/formulas/{name}", "DELETE");
            Endpoints[3330] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}", "DELETE");
            Endpoints[3331] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}", "PUT");
            Endpoints[3332] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}", "GET");
            Endpoints[3333] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}", "PATCH");
            Endpoints[3334] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}", "GET");
            Endpoints[3335] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}", "PUT");
            Endpoints[3336] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}", "DELETE");
            Endpoints[3337] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}", "PATCH");
            Endpoints[3338] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/servicerunners/{name}", "PUT");
            Endpoints[3339] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/servicerunners/{name}", "GET");
            Endpoints[3340] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/servicerunners/{name}", "DELETE");
            Endpoints[3341] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{name}", "GET");
            Endpoints[3342] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{name}", "PUT");
            Endpoints[3343] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{name}", "DELETE");
            Endpoints[3344] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{name}", "PATCH");
            Endpoints[3345] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}", "DELETE");
            Endpoints[3346] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}", "PATCH");
            Endpoints[3347] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}", "GET");
            Endpoints[3348] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}", "PUT");
            Endpoints[3349] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks/{name}", "DELETE");
            Endpoints[3350] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks/{name}", "GET");
            Endpoints[3351] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks/{name}", "PUT");
            Endpoints[3352] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualnetworks/{name}", "PATCH");
            Endpoints[3353] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", "PUT");
            Endpoints[3354] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", "GET");
            Endpoints[3355] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", "PATCH");
            Endpoints[3356] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", "DELETE");
            Endpoints[3357] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/operationresults/{operationId}", "GET");
            Endpoints[3358] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "GET");
            Endpoints[3359] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[3360] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "POST");
            Endpoints[3361] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[3362] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", "DELETE");
            Endpoints[3363] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", "GET");
            Endpoints[3364] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", "PUT");
            Endpoints[3365] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}", "GET");
            Endpoints[3366] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}", "DELETE");
            Endpoints[3367] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}", "PUT");
            Endpoints[3368] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/edgeGatewayPools/{edgeGatewayPool}", "GET");
            Endpoints[3369] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/edgeGateways/{edgeGateway}", "GET");
            Endpoints[3370] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/fileShares/{fileShare}", "GET");
            Endpoints[3371] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoleInstances/{infraRoleInstance}", "GET");
            Endpoints[3372] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoles/{infraRole}", "GET");
            Endpoints[3373] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/ipPools/{ipPool}", "PUT");
            Endpoints[3374] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/ipPools/{ipPool}", "GET");
            Endpoints[3375] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/logicalNetworks/{logicalNetwork}", "GET");
            Endpoints[3376] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/macAddressPools/{macAddressPool}", "GET");
            Endpoints[3377] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}", "GET");
            Endpoints[3378] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnits/{scaleUnit}", "GET");
            Endpoints[3379] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/slbMuxInstances/{slbMuxInstance}", "GET");
            Endpoints[3380] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/storageSubSystems/{storageSubSystem}", "GET");
            Endpoints[3381] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/applications/{applicationName}", "DELETE");
            Endpoints[3382] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/applications/{applicationName}", "PUT");
            Endpoints[3383] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/applications/{applicationName}", "GET");
            Endpoints[3384] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/configurations/{configurationName}", "POST");
            Endpoints[3385] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/configurations/{configurationName}", "GET");
            Endpoints[3386] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/extensions/{extensionName}", "PUT");
            Endpoints[3387] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/extensions/{extensionName}", "GET");
            Endpoints[3388] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/extensions/{extensionName}", "DELETE");
            Endpoints[3389] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptActions/{scriptName}", "DELETE");
            Endpoints[3390] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory/{scriptExecutionId}", "GET");
            Endpoints[3391] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/alerts/{alertName}", "GET");
            Endpoints[3392] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/alerts/{alertName}", "PUT");
            Endpoints[3393] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/serviceHealths/{serviceHealth}", "GET");
            Endpoints[3394] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents/{incidentName}", "GET");
            Endpoints[3395] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}", "DELETE");
            Endpoints[3396] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}", "GET");
            Endpoints[3397] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}", "GET");
            Endpoints[3398] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}", "DELETE");
            Endpoints[3399] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}", "GET");
            Endpoints[3400] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}", "DELETE");
            Endpoints[3401] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}", "PUT");
            Endpoints[3402] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}", "PATCH");
            Endpoints[3403] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}", "GET");
            Endpoints[3404] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}", "PUT");
            Endpoints[3405] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}", "DELETE");
            Endpoints[3406] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}", "GET");
            Endpoints[3407] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}", "PUT");
            Endpoints[3408] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/WorkItemConfigs/{workItemConfigId}", "DELETE");
            Endpoints[3409] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}/status/{statusName}", "GET");
            Endpoints[3410] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/accessPolicies/{operationKind}", "PUT");
            Endpoints[3411] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}", "PUT");
            Endpoints[3412] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}", "GET");
            Endpoints[3413] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}", "PATCH");
            Endpoints[3414] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}", "DELETE");
            Endpoints[3415] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}", "PUT");
            Endpoints[3416] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}", "GET");
            Endpoints[3417] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}", "GET");
            Endpoints[3418] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}", "PUT");
            Endpoints[3419] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}", "DELETE");
            Endpoints[3420] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/batchConfigurations/{batchConfigurationName}", "GET");
            Endpoints[3421] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/batchConfigurations/{batchConfigurationName}", "PUT");
            Endpoints[3422] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/batchConfigurations/{batchConfigurationName}", "DELETE");
            Endpoints[3423] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/certificates/{certificateName}", "PUT");
            Endpoints[3424] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/certificates/{certificateName}", "GET");
            Endpoints[3425] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/certificates/{certificateName}", "DELETE");
            Endpoints[3426] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps/{mapName}", "PUT");
            Endpoints[3427] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps/{mapName}", "DELETE");
            Endpoints[3428] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps/{mapName}", "GET");
            Endpoints[3429] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners/{partnerName}", "PUT");
            Endpoints[3430] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners/{partnerName}", "DELETE");
            Endpoints[3431] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners/{partnerName}", "GET");
            Endpoints[3432] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas/{schemaName}", "GET");
            Endpoints[3433] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas/{schemaName}", "PUT");
            Endpoints[3434] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas/{schemaName}", "DELETE");
            Endpoints[3435] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/sessions/{sessionName}", "GET");
            Endpoints[3436] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/sessions/{sessionName}", "PUT");
            Endpoints[3437] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/sessions/{sessionName}", "DELETE");
            Endpoints[3438] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}", "GET");
            Endpoints[3439] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}", "PUT");
            Endpoints[3440] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}", "DELETE");
            Endpoints[3441] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}", "GET");
            Endpoints[3442] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}", "GET");
            Endpoints[3443] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/versions/{versionId}", "GET");
            Endpoints[3444] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}/commitmentAssociations/{commitmentAssociationName}", "GET");
            Endpoints[3445] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}", "DELETE");
            Endpoints[3446] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}", "PATCH");
            Endpoints[3447] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}", "PUT");
            Endpoints[3448] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}", "GET");
            Endpoints[3449] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}", "DELETE");
            Endpoints[3450] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}", "GET");
            Endpoints[3451] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}", "PUT");
            Endpoints[3452] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}", "PATCH");
            Endpoints[3453] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}", "PUT");
            Endpoints[3454] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}", "PATCH");
            Endpoints[3455] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}", "DELETE");
            Endpoints[3456] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}", "GET");
            Endpoints[3457] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}", "PUT");
            Endpoints[3458] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}", "DELETE");
            Endpoints[3459] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}", "PATCH");
            Endpoints[3460] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}", "GET");
            Endpoints[3461] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}", "GET");
            Endpoints[3462] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}", "PUT");
            Endpoints[3463] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}", "DELETE");
            Endpoints[3464] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}", "PATCH");
            Endpoints[3465] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}", "DELETE");
            Endpoints[3466] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}", "GET");
            Endpoints[3467] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}", "PUT");
            Endpoints[3468] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingPolicies/{streamingPolicyName}", "DELETE");
            Endpoints[3469] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingPolicies/{streamingPolicyName}", "GET");
            Endpoints[3470] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingPolicies/{streamingPolicyName}", "PUT");
            Endpoints[3471] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}", "PUT");
            Endpoints[3472] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}", "GET");
            Endpoints[3473] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}", "DELETE");
            Endpoints[3474] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}", "PATCH");
            Endpoints[3475] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}", "GET");
            Endpoints[3476] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}", "DELETE");
            Endpoints[3477] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}", "PUT");
            Endpoints[3478] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/machines/{machineName}", "GET");
            Endpoints[3479] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/authorizations/{authorizationName}", "PUT");
            Endpoints[3480] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/authorizations/{authorizationName}", "DELETE");
            Endpoints[3481] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/authorizations/{authorizationName}", "GET");
            Endpoints[3482] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}", "GET");
            Endpoints[3483] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}", "PUT");
            Endpoints[3484] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}", "DELETE");
            Endpoints[3485] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}", "PUT");
            Endpoints[3486] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}", "GET");
            Endpoints[3487] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}", "DELETE");
            Endpoints[3488] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}", "GET");
            Endpoints[3489] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/frontendIPConfigurations/{frontendIPConfigurationName}", "GET");
            Endpoints[3490] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", "DELETE");
            Endpoints[3491] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", "PUT");
            Endpoints[3492] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatRules/{inboundNatRuleName}", "GET");
            Endpoints[3493] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules/{loadBalancingRuleName}", "GET");
            Endpoints[3494] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}", "GET");
            Endpoints[3495] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/ipConfigurations/{ipConfigurationName}", "GET");
            Endpoints[3496] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/defaultSecurityRules/{defaultSecurityRuleName}", "GET");
            Endpoints[3497] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/securityRules/{securityRuleName}", "PUT");
            Endpoints[3498] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/securityRules/{securityRuleName}", "GET");
            Endpoints[3499] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/securityRules/{securityRuleName}", "DELETE");
            Endpoints[3500] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}", "GET");
            Endpoints[3501] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}", "PUT");
            Endpoints[3502] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}", "DELETE");
            Endpoints[3503] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", "DELETE");
            Endpoints[3504] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", "PUT");
            Endpoints[3505] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}", "GET");
            Endpoints[3506] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}", "PATCH");
            Endpoints[3507] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}", "PUT");
            Endpoints[3508] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}", "GET");
            Endpoints[3509] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}", "DELETE");
            Endpoints[3510] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}/routes/{routeName}", "DELETE");
            Endpoints[3511] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}/routes/{routeName}", "GET");
            Endpoints[3512] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeTables/{routeTableName}/routes/{routeName}", "PUT");
            Endpoints[3513] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/heatMaps/{heatMapType}", "GET");
            Endpoints[3514] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}", "PUT");
            Endpoints[3515] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}", "DELETE");
            Endpoints[3516] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}", "GET");
            Endpoints[3517] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/virtualNetworkPeerings/{virtualNetworkPeeringName}", "PUT");
            Endpoints[3518] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/virtualNetworkPeerings/{virtualNetworkPeeringName}", "GET");
            Endpoints[3519] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/virtualNetworkPeerings/{virtualNetworkPeeringName}", "DELETE");
            Endpoints[3520] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "GET");
            Endpoints[3521] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "POST");
            Endpoints[3522] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[3523] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[3524] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}", "GET");
            Endpoints[3525] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}", "PUT");
            Endpoints[3526] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}", "DELETE");
            Endpoints[3527] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}", "PUT");
            Endpoints[3528] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}", "DELETE");
            Endpoints[3529] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}", "GET");
            Endpoints[3530] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}", "GET");
            Endpoints[3531] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}", "DELETE");
            Endpoints[3532] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}", "PUT");
            Endpoints[3533] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchName}", "PUT");
            Endpoints[3534] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchName}", "GET");
            Endpoints[3535] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchName}", "DELETE");
            Endpoints[3536] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/search/{id}", "POST");
            Endpoints[3537] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}", "GET");
            Endpoints[3538] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}", "PUT");
            Endpoints[3539] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}", "DELETE");
            Endpoints[3540] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationAlertSettings/{alertSettingName}", "GET");
            Endpoints[3541] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationAlertSettings/{alertSettingName}", "PUT");
            Endpoints[3542] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationEvents/{eventName}", "GET");
            Endpoints[3543] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}", "DELETE");
            Endpoints[3544] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}", "PUT");
            Endpoints[3545] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}", "GET");
            Endpoints[3546] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/{jobName}", "GET");
            Endpoints[3547] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies/{policyName}", "GET");
            Endpoints[3548] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies/{policyName}", "DELETE");
            Endpoints[3549] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies/{policyName}", "PUT");
            Endpoints[3550] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationPolicies/{policyName}", "PATCH");
            Endpoints[3551] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", "GET");
            Endpoints[3552] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", "PUT");
            Endpoints[3553] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", "DELETE");
            Endpoints[3554] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}", "PATCH");
            Endpoints[3555] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines/{backupEngineName}", "GET");
            Endpoints[3556] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupJobs/{jobName}", "GET");
            Endpoints[3557] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupOperationResults/{operationId}", "GET");
            Endpoints[3558] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupOperations/{operationId}", "GET");
            Endpoints[3559] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}", "DELETE");
            Endpoints[3560] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}", "PUT");
            Endpoints[3561] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}", "GET");
            Endpoints[3562] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/certificates/{certificateName}", "PUT");
            Endpoints[3563] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/registeredIdentities/{identityName}", "DELETE");
            Endpoints[3564] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[3565] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[3566] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[3567] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "POST");
            Endpoints[3568] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}", "PUT");
            Endpoints[3569] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}", "DELETE");
            Endpoints[3570] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}", "GET");
            Endpoints[3571] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}", "GET");
            Endpoints[3572] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}", "DELETE");
            Endpoints[3573] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}", "PUT");
            Endpoints[3574] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}", "PATCH");
            Endpoints[3575] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}", "GET");
            Endpoints[3576] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}", "DELETE");
            Endpoints[3577] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}", "PUT");
            Endpoints[3578] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/createQueryKey/{name}", "POST");
            Endpoints[3579] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/deleteQueryKey/{key}", "DELETE");
            Endpoints[3580] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/regenerateAdminKey/{keyKind}", "POST");
            Endpoints[3581] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}", "GET");
            Endpoints[3582] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/discoveredSecuritySolutions/{discoveredSecuritySolutionName}", "GET");
            Endpoints[3583] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/ExternalSecuritySolutions/{externalSecuritySolutionsName}", "GET");
            Endpoints[3584] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}", "PUT");
            Endpoints[3585] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}", "GET");
            Endpoints[3586] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}", "DELETE");
            Endpoints[3587] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}", "GET");
            Endpoints[3588] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}", "GET");
            Endpoints[3589] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}", "DELETE");
            Endpoints[3590] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}", "PUT");
            Endpoints[3591] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[3592] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[3593] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "GET");
            Endpoints[3594] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}", "POST");
            Endpoints[3595] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", "GET");
            Endpoints[3596] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", "DELETE");
            Endpoints[3597] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}", "PUT");
            Endpoints[3598] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}", "DELETE");
            Endpoints[3599] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}", "GET");
            Endpoints[3600] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}", "PUT");
            Endpoints[3601] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}", "GET");
            Endpoints[3602] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}", "DELETE");
            Endpoints[3603] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}", "PUT");
            Endpoints[3604] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}", "DELETE");
            Endpoints[3605] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}", "PUT");
            Endpoints[3606] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}", "GET");
            Endpoints[3607] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}", "DELETE");
            Endpoints[3608] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}", "PATCH");
            Endpoints[3609] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}", "PUT");
            Endpoints[3610] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}", "GET");
            Endpoints[3611] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}", "GET");
            Endpoints[3612] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}", "PUT");
            Endpoints[3613] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}", "DELETE");
            Endpoints[3614] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", "PUT");
            Endpoints[3615] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", "GET");
            Endpoints[3616] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", "DELETE");
            Endpoints[3617] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}", "PUT");
            Endpoints[3618] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}", "PATCH");
            Endpoints[3619] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}", "DELETE");
            Endpoints[3620] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}", "GET");
            Endpoints[3621] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}", "GET");
            Endpoints[3622] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}", "DELETE");
            Endpoints[3623] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}", "PUT");
            Endpoints[3624] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/advisors/{advisorName}", "GET");
            Endpoints[3625] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/advisors/{advisorName}", "PATCH");
            Endpoints[3626] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/advisors/{advisorName}", "PUT");
            Endpoints[3627] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/auditingPolicies/{tableAuditingPolicyName}", "PUT");
            Endpoints[3628] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/auditingPolicies/{tableAuditingPolicyName}", "GET");
            Endpoints[3629] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults/{backupLongTermRetentionVaultName}", "PUT");
            Endpoints[3630] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/backupLongTermRetentionVaults/{backupLongTermRetentionVaultName}", "GET");
            Endpoints[3631] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}", "DELETE");
            Endpoints[3632] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}", "PUT");
            Endpoints[3633] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}", "GET");
            Endpoints[3634] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/connectionPolicies/{connectionPolicyName}", "GET");
            Endpoints[3635] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/connectionPolicies/{connectionPolicyName}", "PUT");
            Endpoints[3636] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", "PATCH");
            Endpoints[3637] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", "GET");
            Endpoints[3638] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", "DELETE");
            Endpoints[3639] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}", "PUT");
            Endpoints[3640] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}", "PUT");
            Endpoints[3641] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}", "GET");
            Endpoints[3642] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}", "DELETE");
            Endpoints[3643] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", "GET");
            Endpoints[3644] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", "PUT");
            Endpoints[3645] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}", "DELETE");
            Endpoints[3646] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}", "GET");
            Endpoints[3647] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}", "DELETE");
            Endpoints[3648] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}", "PUT");
            Endpoints[3649] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}", "PATCH");
            Endpoints[3650] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}", "GET");
            Endpoints[3651] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/encryptionProtector/{encryptionProtectorName}", "PUT");
            Endpoints[3652] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", "PATCH");
            Endpoints[3653] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", "DELETE");
            Endpoints[3654] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", "PUT");
            Endpoints[3655] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", "GET");
            Endpoints[3656] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}", "DELETE");
            Endpoints[3657] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}", "GET");
            Endpoints[3658] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}", "PUT");
            Endpoints[3659] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}", "GET");
            Endpoints[3660] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}", "PATCH");
            Endpoints[3661] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}", "DELETE");
            Endpoints[3662] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}", "PUT");
            Endpoints[3663] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}", "DELETE");
            Endpoints[3664] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}", "PUT");
            Endpoints[3665] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}", "GET");
            Endpoints[3666] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}", "GET");
            Endpoints[3667] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recoverableDatabases/{databaseName}", "GET");
            Endpoints[3668] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/restorableDroppedDatabases/{restorableDroppededDatabaseId}", "GET");
            Endpoints[3669] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/serviceObjectives/{serviceObjectiveName}", "GET");
            Endpoints[3670] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}", "DELETE");
            Endpoints[3671] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}", "GET");
            Endpoints[3672] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}", "PUT");
            Endpoints[3673] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "DELETE");
            Endpoints[3674] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "PUT");
            Endpoints[3675] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}", "GET");
            Endpoints[3676] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/blobservices/{serviceType}", "GET");
            Endpoints[3677] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/operationresults/{operationId}", "GET");
            Endpoints[3678] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/queueservices/{serviceType}", "GET");
            Endpoints[3679] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/{shareName}", "GET");
            Endpoints[3680] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/storageaccounts/{accountId}", "POST");
            Endpoints[3681] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/storageaccounts/{accountId}", "GET");
            Endpoints[3682] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/tableservices/{serviceType}", "GET");
            Endpoints[3683] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}", "DELETE");
            Endpoints[3684] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}", "GET");
            Endpoints[3685] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}", "PUT");
            Endpoints[3686] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/accessControlRecords/{accessControlRecordName}", "DELETE");
            Endpoints[3687] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/accessControlRecords/{accessControlRecordName}", "PUT");
            Endpoints[3688] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/accessControlRecords/{accessControlRecordName}", "GET");
            Endpoints[3689] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/bandwidthSettings/{bandwidthSettingName}", "DELETE");
            Endpoints[3690] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/bandwidthSettings/{bandwidthSettingName}", "GET");
            Endpoints[3691] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/bandwidthSettings/{bandwidthSettingName}", "PUT");
            Endpoints[3692] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}", "DELETE");
            Endpoints[3693] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}", "GET");
            Endpoints[3694] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}", "PATCH");
            Endpoints[3695] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/storageAccountCredentials/{storageAccountCredentialName}", "GET");
            Endpoints[3696] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/storageAccountCredentials/{storageAccountCredentialName}", "PUT");
            Endpoints[3697] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/storageAccountCredentials/{storageAccountCredentialName}", "DELETE");
            Endpoints[3698] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}", "PATCH");
            Endpoints[3699] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}", "GET");
            Endpoints[3700] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}", "DELETE");
            Endpoints[3701] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}", "PUT");
            Endpoints[3702] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}", "GET");
            Endpoints[3703] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}", "DELETE");
            Endpoints[3704] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}", "PATCH");
            Endpoints[3705] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}", "PUT");
            Endpoints[3706] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs/{outputName}", "GET");
            Endpoints[3707] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs/{outputName}", "PUT");
            Endpoints[3708] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs/{outputName}", "DELETE");
            Endpoints[3709] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs/{outputName}", "PATCH");
            Endpoints[3710] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}", "GET");
            Endpoints[3711] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}", "PATCH");
            Endpoints[3712] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/transformations/{transformationName}", "PUT");
            Endpoints[3713] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/offerDelegations/{offerDelegationName}", "DELETE");
            Endpoints[3714] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/offerDelegations/{offerDelegationName}", "PUT");
            Endpoints[3715] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Subscriptions.Admin/offers/{offer}/offerDelegations/{offerDelegationName}", "GET");
            Endpoints[3716] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies/{accessPolicyName}", "DELETE");
            Endpoints[3717] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies/{accessPolicyName}", "PATCH");
            Endpoints[3718] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies/{accessPolicyName}", "GET");
            Endpoints[3719] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies/{accessPolicyName}", "PUT");
            Endpoints[3720] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}", "PUT");
            Endpoints[3721] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}", "GET");
            Endpoints[3722] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}", "PATCH");
            Endpoints[3723] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}", "DELETE");
            Endpoints[3724] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets/{referenceDataSetName}", "PUT");
            Endpoints[3725] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets/{referenceDataSetName}", "GET");
            Endpoints[3726] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets/{referenceDataSetName}", "DELETE");
            Endpoints[3727] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets/{referenceDataSetName}", "PATCH");
            Endpoints[3728] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}/updates/{updateName}", "GET");
            Endpoints[3729] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension/{extensionResourceName}", "DELETE");
            Endpoints[3730] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension/{extensionResourceName}", "GET");
            Endpoints[3731] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension/{extensionResourceName}", "PATCH");
            Endpoints[3732] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{accountResourceName}/extension/{extensionResourceName}", "PUT");
            Endpoints[3733] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}", "PATCH");
            Endpoints[3734] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}", "GET");
            Endpoints[3735] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}", "PUT");
            Endpoints[3736] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors/{detectorName}", "GET");
            Endpoints[3737] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}", "GET");
            Endpoints[3738] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations/{operationId}", "GET");
            Endpoints[3739] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", "PATCH");
            Endpoints[3740] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", "GET");
            Endpoints[3741] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", "PUT");
            Endpoints[3742] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/managedHostingEnvironments/{name}/operations/{operationId}", "GET");
            Endpoints[3743] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/operationresults/{operationId}", "GET");
            Endpoints[3744] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}", "GET");
            Endpoints[3745] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", "GET");
            Endpoints[3746] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", "DELETE");
            Endpoints[3747] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", "GET");
            Endpoints[3748] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", "DELETE");
            Endpoints[3749] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", "GET");
            Endpoints[3750] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", "DELETE");
            Endpoints[3751] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", "PUT");
            Endpoints[3752] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "PATCH");
            Endpoints[3753] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "GET");
            Endpoints[3754] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "PUT");
            Endpoints[3755] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "DELETE");
            Endpoints[3756] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", "DELETE");
            Endpoints[3757] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", "GET");
            Endpoints[3758] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", "PUT");
            Endpoints[3759] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", "DELETE");
            Endpoints[3760] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", "PUT");
            Endpoints[3761] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", "GET");
            Endpoints[3762] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", "PATCH");
            Endpoints[3763] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", "DELETE");
            Endpoints[3764] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", "PUT");
            Endpoints[3765] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", "GET");
            Endpoints[3766] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}", "GET");
            Endpoints[3767] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/operationresults/{operationId}", "GET");
            Endpoints[3768] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", "PUT");
            Endpoints[3769] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", "DELETE");
            Endpoints[3770] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", "GET");
            Endpoints[3771] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", "DELETE");
            Endpoints[3772] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", "GET");
            Endpoints[3773] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", "DELETE");
            Endpoints[3774] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", "PUT");
            Endpoints[3775] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", "GET");
            Endpoints[3776] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", "PUT");
            Endpoints[3777] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", "GET");
            Endpoints[3778] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", "DELETE");
            Endpoints[3779] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", "GET");
            Endpoints[3780] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", "PUT");
            Endpoints[3781] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", "DELETE");
            Endpoints[3782] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", "PATCH");
            Endpoints[3783] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", "GET");
            Endpoints[3784] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", "DELETE");
            Endpoints[3785] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", "PATCH");
            Endpoints[3786] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", "DELETE");
            Endpoints[3787] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", "PUT");
            Endpoints[3788] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", "GET");
            Endpoints[3789] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs/{webJobName}", "GET");
            Endpoints[3790] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors/{detectorName}", "GET");
            Endpoints[3791] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}", "GET");
            Endpoints[3792] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}", "GET");
            Endpoints[3793] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroup/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes/{computeName}/listKeys", "POST");
            Endpoints[3794] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks", "GET");
            Endpoints[3795] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroup}/providers/Microsoft.AzureBridge.Admin/activations/{activationName}/products/{productName}/download", "POST");
            Endpoints[3796] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/products/{productName}/listDetails", "POST");
            Endpoints[3797] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics", "GET");
            Endpoints[3798] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues", "GET");
            Endpoints[3799] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations", "GET");
            Endpoints[3800] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operationsByTags", "GET");
            Endpoints[3801] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policies", "GET");
            Endpoints[3802] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policy", "PUT");
            Endpoints[3803] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policy", "DELETE");
            Endpoints[3804] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policy", "GET");
            Endpoints[3805] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/products", "GET");
            Endpoints[3806] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases", "PARAMETERS");
            Endpoints[3807] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases", "GET");
            Endpoints[3808] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/revisions", "PARAMETERS");
            Endpoints[3809] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/revisions", "GET");
            Endpoints[3810] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/schemas", "GET");
            Endpoints[3811] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions", "GET");
            Endpoints[3812] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tags", "GET");
            Endpoints[3813] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendid}/reconnect", "POST");
            Endpoints[3814] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}/loggers", "GET");
            Endpoints[3815] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}/users", "GET");
            Endpoints[3816] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/locations/{locationName}/networkstatus", "GET");
            Endpoints[3817] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails", "GET");
            Endpoints[3818] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientUsers", "GET");
            Endpoints[3819] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/apis", "GET");
            Endpoints[3820] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/groups", "GET");
            Endpoints[3821] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policies", "GET");
            Endpoints[3822] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policy", "PUT");
            Endpoints[3823] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policy", "GET");
            Endpoints[3824] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policy", "DELETE");
            Endpoints[3825] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/subscriptions", "GET");
            Endpoints[3826] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/tags", "GET");
            Endpoints[3827] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}/regeneratePrimaryKey", "POST");
            Endpoints[3828] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/subscriptions/{sid}/regenerateSecondaryKey", "POST");
            Endpoints[3829] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/git", "GET");
            Endpoints[3830] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/regeneratePrimaryKey", "POST");
            Endpoints[3831] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/regenerateSecondaryKey", "POST");
            Endpoints[3832] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/deploy", "POST");
            Endpoints[3833] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/save", "POST");
            Endpoints[3834] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/syncState", "GET");
            Endpoints[3835] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{configurationName}/validate", "POST");
            Endpoints[3836] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}/generateSsoUrl", "POST");
            Endpoints[3837] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}/groups", "GET");
            Endpoints[3838] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}/identities", "GET");
            Endpoints[3839] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}/subscriptions", "GET");
            Endpoints[3840] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/users/{uid}/token", "POST");
            Endpoints[3841] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{jobId}/streams", "GET");
            Endpoints[3842] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/configurations/{configurationName}/content", "GET");
            Endpoints[3843] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/output", "GET");
            Endpoints[3844] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/resume", "POST");
            Endpoints[3845] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/runbookContent", "GET");
            Endpoints[3846] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/stop", "POST");
            Endpoints[3847] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/streams", "GET");
            Endpoints[3848] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/suspend", "POST");
            Endpoints[3849] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/activities", "GET");
            Endpoints[3850] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes/{nodeId}/reports", "GET");
            Endpoints[3851] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/objectDataTypes/{typeName}/fields", "GET");
            Endpoints[3852] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/content", "GET");
            Endpoints[3853] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft", "GET");
            Endpoints[3854] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs", "GET");
            Endpoints[3855] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}/start", "POST");
            Endpoints[3856] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}/stop", "POST");
            Endpoints[3857] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Backup.Admin/backupLocations/{location}/backups/{backup}/restore", "POST");
            Endpoints[3858] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}/cancelDelete", "POST");
            Endpoints[3859] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}/disableAutoScale", "POST");
            Endpoints[3860] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}/stopResize", "POST");
            Endpoints[3861] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}/listRemoteLoginInformation", "POST");
            Endpoints[3862] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs", "GET");
            Endpoints[3863] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/channels/{channelName}/listChannelWithKeys", "POST");
            Endpoints[3864] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}/Connections/{connectionName}/listWithSecrets", "POST");
            Endpoints[3865] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/checkResourceUsage", "POST");
            Endpoints[3866] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains", "GET");
            Endpoints[3867] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load", "POST");
            Endpoints[3868] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins", "GET");
            Endpoints[3869] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge", "POST");
            Endpoints[3870] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start", "POST");
            Endpoints[3871] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop", "POST");
            Endpoints[3872] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/validateCustomDomain", "POST");
            Endpoints[3873] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions", "GET");
            Endpoints[3874] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces", "GET");
            Endpoints[3875] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/deallocate", "POST");
            Endpoints[3876] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/instanceView", "GET");
            Endpoints[3877] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/performMaintenance", "POST");
            Endpoints[3878] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/poweroff", "POST");
            Endpoints[3879] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/redeploy", "POST");
            Endpoints[3880] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/reimage", "POST");
            Endpoints[3881] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/reimageall", "POST");
            Endpoints[3882] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/restart", "POST");
            Endpoints[3883] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/start", "POST");
            Endpoints[3884] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec", "POST");
            Endpoints[3885] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/logs", "GET");
            Endpoints[3886] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/cancel", "POST");
            Endpoints[3887] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/builds/{buildId}/getLogLink", "POST");
            Endpoints[3888] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/listSourceRepositoryProperties", "POST");
            Endpoints[3889] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps", "GET");
            Endpoints[3890] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/getCallbackConfig", "POST");
            Endpoints[3891] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/listEvents", "POST");
            Endpoints[3892] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/ping", "POST");
            Endpoints[3893] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/accessProfiles/{roleName}/listCredential", "POST");
            Endpoints[3894] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}/regeneratePrimaryKey", "POST");
            Endpoints[3895] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}/regenerateSecondaryKey", "POST");
            Endpoints[3896] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}/mappings", "GET");
            Endpoints[3897] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}/suggestRelationshipLinks", "POST");
            Endpoints[3898] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}/reprocess", "POST");
            Endpoints[3899] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/getModelStatus", "POST");
            Endpoints[3900] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/getTrainingResults", "POST");
            Endpoints[3901] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/modelStatus", "POST");
            Endpoints[3902] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/profiles/{profileName}/getEnrichingKpis", "POST");
            Endpoints[3903] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/getConnectionInfo", "POST");
            Endpoints[3904] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/getStatus", "POST");
            Endpoints[3905] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/listAuthKeys", "POST");
            Endpoints[3906] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/monitoringData", "POST");
            Endpoints[3907] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/regenerateAuthKey", "POST");
            Endpoints[3908] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/removeNode", "POST");
            Endpoints[3909] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/start", "POST");
            Endpoints[3910] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/stop", "POST");
            Endpoints[3911] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/syncCredentials", "POST");
            Endpoints[3912] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/upgrade", "POST");
            Endpoints[3913] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelineruns/{runId}/activityruns", "GET");
            Endpoints[3914] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/pipelines/{pipelineName}/createRun", "POST");
            Endpoints[3915] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/start", "POST");
            Endpoints[3916] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/stop", "POST");
            Endpoints[3917] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/triggerruns", "GET");
            Endpoints[3918] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}/containers", "GET");
            Endpoints[3919] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}/generateVerificationCode", "POST");
            Endpoints[3920] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}/verify", "POST");
            Endpoints[3921] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups", "GET");
            Endpoints[3922] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys", "POST");
            Endpoints[3923] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates/{certificateName}/generateVerificationCode", "POST");
            Endpoints[3924] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates/{certificateName}/verify", "POST");
            Endpoints[3925] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/keys/{keyName}/listkeys", "POST");
            Endpoints[3926] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{artifactSourceName}/armtemplates", "GET");
            Endpoints[3927] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{artifactSourceName}/artifacts", "GET");
            Endpoints[3928] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costinsights/{name}/refreshData", "POST");
            Endpoints[3929] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/costs/{name}/refreshData", "POST");
            Endpoints[3930] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/notificationchannels/{name}/notify", "POST");
            Endpoints[3931] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{name}/evaluatePolicies", "POST");
            Endpoints[3932] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies", "GET");
            Endpoints[3933] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}/execute", "POST");
            Endpoints[3934] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/schedules/{name}/listApplicable", "POST");
            Endpoints[3935] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks", "GET");
            Endpoints[3936] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/environments", "GET");
            Endpoints[3937] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/secrets", "GET");
            Endpoints[3938] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/addDataDisk", "POST");
            Endpoints[3939] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/applyArtifacts", "POST");
            Endpoints[3940] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/claim", "POST");
            Endpoints[3941] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/detachDataDisk", "POST");
            Endpoints[3942] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/listApplicableSchedules", "POST");
            Endpoints[3943] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/start", "POST");
            Endpoints[3944] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}/stop", "POST");
            Endpoints[3945] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules", "GET");
            Endpoints[3946] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/metricDefinitions", "GET");
            Endpoints[3947] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/metrics", "GET");
            Endpoints[3948] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/usages", "GET");
            Endpoints[3949] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/region/{region}/metrics", "GET");
            Endpoints[3950] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/locations/{location}/topicTypes/{topicTypeName}/eventSubscriptions", "GET");
            Endpoints[3951] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[3952] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[3953] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules", "GET");
            Endpoints[3954] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/breakPairing", "POST");
            Endpoints[3955] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/failover", "POST");
            Endpoints[3956] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules", "GET");
            Endpoints[3957] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups", "GET");
            Endpoints[3958] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoleInstances/{infraRoleInstance}/PowerOff", "POST");
            Endpoints[3959] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoleInstances/{infraRoleInstance}/PowerOn", "POST");
            Endpoints[3960] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoleInstances/{infraRoleInstance}/Reboot", "POST");
            Endpoints[3961] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoleInstances/{infraRoleInstance}/Shutdown", "POST");
            Endpoints[3962] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/infraRoles/{infraRole}/Restart", "POST");
            Endpoints[3963] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/logicalNetworks/{logicalNetwork}/logicalSubnets", "GET");
            Endpoints[3964] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/PowerOff", "POST");
            Endpoints[3965] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/PowerOn", "POST");
            Endpoints[3966] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/Repair", "POST");
            Endpoints[3967] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/Shutdown", "POST");
            Endpoints[3968] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/StartMaintenanceMode", "POST");
            Endpoints[3969] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/StopMaintenanceMode", "POST");
            Endpoints[3970] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnits/{scaleUnit}/ScaleOut", "POST");
            Endpoints[3971] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/storageSubSystems/{storageSubSystem}/storagePools", "GET");
            Endpoints[3972] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/roles/{roleName}/resize", "POST");
            Endpoints[3973] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory/{scriptExecutionId}/promote", "POST");
            Endpoints[3974] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/serviceHealths/{serviceRegistrationId}/resourceHealths", "GET");
            Endpoints[3975] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}/listContentCallbackUrl", "POST");
            Endpoints[3976] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}/listContentCallbackUrl", "POST");
            Endpoints[3977] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps/{mapName}/listContentCallbackUrl", "POST");
            Endpoints[3978] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners/{partnerName}/listContentCallbackUrl", "POST");
            Endpoints[3979] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/schemas/{schemaName}/listContentCallbackUrl", "POST");
            Endpoints[3980] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/locations/{location}/workflows/{workflowName}/validate", "POST");
            Endpoints[3981] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}/list", "POST");
            Endpoints[3982] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}/regenerate", "POST");
            Endpoints[3983] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions", "GET");
            Endpoints[3984] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/cancel", "POST");
            Endpoints[3985] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/histories", "GET");
            Endpoints[3986] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/listCallbackUrl", "POST");
            Endpoints[3987] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/reset", "POST");
            Endpoints[3988] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/run", "POST");
            Endpoints[3989] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/setState", "POST");
            Endpoints[3990] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}/commitmentAssociations/{commitmentAssociationName}/move", "POST");
            Endpoints[3991] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}/getEncryptionKey", "POST");
            Endpoints[3992] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}/listContainerSas", "POST");
            Endpoints[3993] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/contentKeyPolicies/{contentKeyPolicyName}/getPolicyPropertiesWithSecrets", "POST");
            Endpoints[3994] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs", "GET");
            Endpoints[3995] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/reset", "POST");
            Endpoints[3996] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/start", "POST");
            Endpoints[3997] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/stop", "POST");
            Endpoints[3998] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}/scale", "POST");
            Endpoints[3999] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}/start", "POST");
            Endpoints[4000] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}/stop", "POST");
            Endpoints[4001] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}/listContentKeys", "POST");
            Endpoints[4002] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingLocators/{streamingLocatorName}/listPaths", "POST");
            Endpoints[4003] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs", "GET");
            Endpoints[4004] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments", "GET");
            Endpoints[4005] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/stats", "GET");
            Endpoints[4006] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/query", "POST");
            Endpoints[4007] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/start", "POST");
            Endpoints[4008] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/stop", "POST");
            Endpoints[4009] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/queryStatus", "POST");
            Endpoints[4010] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}/stop", "POST");
            Endpoints[4011] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4012] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4013] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules", "POST");
            Endpoints[4014] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules", "GET");
            Endpoints[4015] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/pnsCredentials", "POST");
            Endpoints[4016] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks/{intelligencePackName}/Disable", "POST");
            Endpoints[4017] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks/{intelligencePackName}/Enable", "POST");
            Endpoints[4018] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchName}/results", "GET");
            Endpoints[4019] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/checkConsistency", "POST");
            Endpoints[4020] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/migratetoaad", "POST");
            Endpoints[4021] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/reassociateGateway", "POST");
            Endpoints[4022] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/remove", "POST");
            Endpoints[4023] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/renewCertificate", "POST");
            Endpoints[4024] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationLogicalNetworks", "GET");
            Endpoints[4025] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks", "GET");
            Endpoints[4026] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers", "GET");
            Endpoints[4027] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders", "GET");
            Endpoints[4028] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications", "GET");
            Endpoints[4029] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters", "GET");
            Endpoints[4030] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/{jobName}/cancel", "POST");
            Endpoints[4031] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/{jobName}/restart", "POST");
            Endpoints[4032] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationJobs/{jobName}/resume", "POST");
            Endpoints[4033] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/failoverCommit", "POST");
            Endpoints[4034] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/plannedFailover", "POST");
            Endpoints[4035] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/reProtect", "POST");
            Endpoints[4036] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/testFailover", "POST");
            Endpoints[4037] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/testFailoverCleanup", "POST");
            Endpoints[4038] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationRecoveryPlans/{recoveryPlanName}/unplannedFailover", "POST");
            Endpoints[4039] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectableContainers", "GET");
            Endpoints[4040] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/refreshContainers", "POST");
            Endpoints[4041] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupJobs/{jobName}/cancel", "POST");
            Endpoints[4042] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4043] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4044] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules", "GET");
            Endpoints[4045] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/HybridConnections/{hybridConnectionName}/authorizationRules", "POST");
            Endpoints[4046] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules", "GET");
            Endpoints[4047] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/WcfRelays/{relayName}/authorizationRules", "POST");
            Endpoints[4048] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}/history", "GET");
            Endpoints[4049] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}/run", "POST");
            Endpoints[4050] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4051] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4052] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules", "GET");
            Endpoints[4053] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/breakPairing", "POST");
            Endpoints[4054] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/failover", "POST");
            Endpoints[4055] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/eventhubs/{eventhubName}/authorizationRules", "GET");
            Endpoints[4056] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}/revert", "POST");
            Endpoints[4057] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}/upgrade", "POST");
            Endpoints[4058] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules", "GET");
            Endpoints[4059] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules", "GET");
            Endpoints[4060] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions", "GET");
            Endpoints[4061] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}/services", "GET");
            Endpoints[4062] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}/versions", "GET");
            Endpoints[4063] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/failover", "POST");
            Endpoints[4064] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss", "POST");
            Endpoints[4065] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors", "GET");
            Endpoints[4066] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingPolicies", "GET");
            Endpoints[4067] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupLongTermRetentionPolicies", "GET");
            Endpoints[4068] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/export", "POST");
            Endpoints[4069] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/extensions", "GET");
            Endpoints[4070] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies", "GET");
            Endpoints[4071] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/metricDefinitions", "GET");
            Endpoints[4072] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/metrics", "GET");
            Endpoints[4073] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/move", "POST");
            Endpoints[4074] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/operations", "GET");
            Endpoints[4075] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/pause", "POST");
            Endpoints[4076] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks", "GET");
            Endpoints[4077] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints", "POST");
            Endpoints[4078] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints", "GET");
            Endpoints[4079] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/resume", "POST");
            Endpoints[4080] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/serviceTierAdvisors", "GET");
            Endpoints[4081] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups", "GET");
            Endpoints[4082] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/topQueries", "GET");
            Endpoints[4083] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption", "GET");
            Endpoints[4084] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/upgradeDataWarehouse", "POST");
            Endpoints[4085] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/usages", "GET");
            Endpoints[4086] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}/failover", "POST");
            Endpoints[4087] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}/forceFailoverAllowDataLoss", "POST");
            Endpoints[4088] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}/acquire", "POST");
            Endpoints[4089] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/databases", "GET");
            Endpoints[4090] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/elasticPoolActivity", "GET");
            Endpoints[4091] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/elasticPoolDatabaseActivity", "GET");
            Endpoints[4092] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/metricDefinitions", "GET");
            Endpoints[4093] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/metrics", "GET");
            Endpoints[4094] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/operations", "GET");
            Endpoints[4095] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/failover", "POST");
            Endpoints[4096] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss", "POST");
            Endpoints[4097] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials", "GET");
            Endpoints[4098] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/executions", "GET");
            Endpoints[4099] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs", "GET");
            Endpoints[4100] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups", "GET");
            Endpoints[4101] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/databases", "GET");
            Endpoints[4102] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/metrics", "GET");
            Endpoints[4103] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}/generateKey", "POST");
            Endpoints[4104] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}/linkedDatabases", "GET");
            Endpoints[4105] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/blobservices/{serviceType}/metricdefinitions", "GET");
            Endpoints[4106] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/blobservices/{serviceType}/metrics", "GET");
            Endpoints[4107] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/queueservices/{serviceType}/metricdefinitions", "GET");
            Endpoints[4108] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/queueservices/{serviceType}/metrics", "GET");
            Endpoints[4109] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/{shareName}/containers", "GET");
            Endpoints[4110] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/{shareName}/destinationshares", "GET");
            Endpoints[4111] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/{shareName}/metricdefinitions", "GET");
            Endpoints[4112] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/{shareName}/metrics", "GET");
            Endpoints[4113] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/shares/{shareName}/migrate", "POST");
            Endpoints[4114] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/tableservices/{serviceType}/metricdefinitions", "GET");
            Endpoints[4115] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Storage.Admin/farms/{farmId}/tableservices/{serviceType}/metrics", "GET");
            Endpoints[4116] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/authorizeForServiceEncryptionKeyRollover", "POST");
            Endpoints[4117] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies", "GET");
            Endpoints[4118] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups", "GET");
            Endpoints[4119] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/deactivate", "POST");
            Endpoints[4120] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/hardwareComponentGroups", "GET");
            Endpoints[4121] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/installUpdates", "POST");
            Endpoints[4122] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/jobs", "GET");
            Endpoints[4123] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/listFailoverSets", "POST");
            Endpoints[4124] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/metrics", "GET");
            Endpoints[4125] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/metricsDefinitions", "GET");
            Endpoints[4126] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/publicEncryptionKey", "POST");
            Endpoints[4127] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/scanForUpdates", "POST");
            Endpoints[4128] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/sendTestAlertEmail", "POST");
            Endpoints[4129] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers", "GET");
            Endpoints[4130] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumes", "GET");
            Endpoints[4131] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{sourceDeviceName}/failover", "POST");
            Endpoints[4132] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{sourceDeviceName}/listFailoverTargets", "POST");
            Endpoints[4133] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}/RetrieveDefaultDefinition", "POST");
            Endpoints[4134] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}/test", "POST");
            Endpoints[4135] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/inputs/{inputName}/test", "POST");
            Endpoints[4136] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/outputs/{outputName}/test", "POST");
            Endpoints[4137] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}/updates/{updateName}/Apply", "POST");
            Endpoints[4138] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}/updates/{updateName}/updateRuns", "GET");
            Endpoints[4139] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions", "GET");
            Endpoints[4140] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics", "GET");
            Endpoints[4141] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus", "GET");
            Endpoints[4142] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages", "GET");
            Endpoints[4143] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes", "GET");
            Endpoints[4144] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot", "POST");
            Endpoints[4145] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list", "POST");
            Endpoints[4146] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore", "POST");
            Endpoints[4147] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/start", "POST");
            Endpoints[4148] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/stop", "POST");
            Endpoints[4149] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log", "GET");
            Endpoints[4150] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets", "POST");
            Endpoints[4151] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments", "GET");
            Endpoints[4152] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes", "GET");
            Endpoints[4153] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump", "GET");
            Endpoints[4154] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules", "GET");
            Endpoints[4155] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads", "GET");
            Endpoints[4156] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname", "GET");
            Endpoints[4157] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig", "POST");
            Endpoints[4158] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup", "POST");
            Endpoints[4159] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups", "GET");
            Endpoints[4160] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config", "GET");
            Endpoints[4161] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs", "POST");
            Endpoints[4162] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs", "GET");
            Endpoints[4163] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments", "GET");
            Endpoints[4164] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers", "GET");
            Endpoints[4165] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions", "GET");
            Endpoints[4166] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings", "GET");
            Endpoints[4167] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection", "GET");
            Endpoints[4168] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays", "GET");
            Endpoints[4169] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances", "GET");
            Endpoints[4170] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable", "POST");
            Endpoints[4171] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listsyncfunctiontriggerstatus", "POST");
            Endpoints[4172] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions", "GET");
            Endpoints[4173] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics", "GET");
            Endpoints[4174] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword", "POST");
            Endpoints[4175] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters", "GET");
            Endpoints[4176] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging", "GET");
            Endpoints[4177] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons", "GET");
            Endpoints[4178] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes", "GET");
            Endpoints[4179] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates", "GET");
            Endpoints[4180] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml", "POST");
            Endpoints[4181] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/recover", "POST");
            Endpoints[4182] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig", "POST");
            Endpoints[4183] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata", "GET");
            Endpoints[4184] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart", "POST");
            Endpoints[4185] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromBackupBlob", "POST");
            Endpoints[4186] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromDeletedApp", "POST");
            Endpoints[4187] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreSnapshot", "POST");
            Endpoints[4188] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions", "GET");
            Endpoints[4189] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs", "POST");
            Endpoints[4190] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap", "POST");
            Endpoints[4191] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots", "GET");
            Endpoints[4192] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots", "PUT");
            Endpoints[4193] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start", "POST");
            Endpoints[4194] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop", "POST");
            Endpoints[4195] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync", "POST");
            Endpoints[4196] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/syncfunctiontriggers", "POST");
            Endpoints[4197] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs", "GET");
            Endpoints[4198] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages", "GET");
            Endpoints[4199] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections", "GET");
            Endpoints[4200] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs", "GET");
            Endpoints[4201] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history", "GET");
            Endpoints[4202] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/run", "POST");
            Endpoints[4203] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses", "GET");
            Endpoints[4204] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors", "GET");
            Endpoints[4205] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}/disable", "POST");
            Endpoints[4206] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors", "GET");
            Endpoints[4207] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics", "GET");
            Endpoints[4208] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/git/regeneratePrimaryKey", "POST");
            Endpoints[4209] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tenant/{accessName}/git/regenerateSecondaryKey", "POST");
            Endpoints[4210] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/content", "PUT");
            Endpoints[4211] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/content", "GET");
            Endpoints[4212] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/publish", "POST");
            Endpoints[4213] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob", "GET");
            Endpoints[4214] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob", "PUT");
            Endpoints[4215] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/undoEdit", "POST");
            Endpoints[4216] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/targetRegion/{targetRegion}/percentile/metrics", "GET");
            Endpoints[4217] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/schemas/json", "GET");
            Endpoints[4218] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/automaticTuning/current", "GET");
            Endpoints[4219] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/automaticTuning/current", "PATCH");
            Endpoints[4220] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default", "GET");
            Endpoints[4221] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default", "PUT");
            Endpoints[4222] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default", "GET");
            Endpoints[4223] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default", "PATCH");
            Endpoints[4224] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default", "GET");
            Endpoints[4225] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default", "PATCH");
            Endpoints[4226] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default", "GET");
            Endpoints[4227] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default", "PUT");
            Endpoints[4228] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/updateSummary/default", "GET");
            Endpoints[4229] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy", "PUT");
            Endpoints[4230] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy", "GET");
            Endpoints[4231] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover", "PUT");
            Endpoints[4232] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings", "PUT");
            Endpoints[4233] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings", "PUT");
            Endpoints[4234] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", "DELETE");
            Endpoints[4235] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", "PUT");
            Endpoints[4236] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings", "PUT");
            Endpoints[4237] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", "GET");
            Endpoints[4238] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", "PUT");
            Endpoints[4239] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata", "PUT");
            Endpoints[4240] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings", "PUT");
            Endpoints[4241] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", "GET");
            Endpoints[4242] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", "PUT");
            Endpoints[4243] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", "PATCH");
            Endpoints[4244] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy", "GET");
            Endpoints[4245] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy", "PUT");
            Endpoints[4246] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status", "GET");
            Endpoints[4247] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/start", "POST");
            Endpoints[4248] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/stop", "POST");
            Endpoints[4249] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks", "GET");
            Endpoints[4250] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks", "PUT");
            Endpoints[4251] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata/default", "GET");
            Endpoints[4252] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", "PUT");
            Endpoints[4253] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", "GET");
            Endpoints[4254] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", "DELETE");
            Endpoints[4255] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", "PATCH");
            Endpoints[4256] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/resume", "POST");
            Endpoints[4257] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/stop", "POST");
            Endpoints[4258] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/streams", "GET");
            Endpoints[4259] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/suspend", "POST");
            Endpoints[4260] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions", "GET");
            Endpoints[4261] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default/syncRemoteManagementCertificate", "POST");
            Endpoints[4262] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log", "GET");
            Endpoints[4263] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list", "POST");
            Endpoints[4264] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list", "POST");
            Endpoints[4265] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list", "POST");
            Endpoints[4266] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list", "POST");
            Endpoints[4267] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list", "POST");
            Endpoints[4268] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list", "POST");
            Endpoints[4269] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list", "POST");
            Endpoints[4270] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots", "GET");
            Endpoints[4271] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs/zip/download", "POST");
            Endpoints[4272] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy/log", "GET");
            Endpoints[4273] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/admin/token", "GET");
            Endpoints[4274] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/streams/{jobStreamId}", "GET");
            Endpoints[4275] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}", "PUT");
            Endpoints[4276] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}", "GET");
            Endpoints[4277] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}", "PATCH");
            Endpoints[4278] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}", "GET");
            Endpoints[4279] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}/cancel", "POST");
            Endpoints[4280] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}/invokeCommand", "POST");
            Endpoints[4281] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}/tab", "POST");
            Endpoints[4282] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}/recover", "POST");
            Endpoints[4283] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}", "DELETE");
            Endpoints[4284] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}", "PATCH");
            Endpoints[4285] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}", "GET");
            Endpoints[4286] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}", "PUT");
            Endpoints[4287] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}", "PARAMETERS");
            Endpoints[4288] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}", "HEAD");
            Endpoints[4289] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}", "PUT");
            Endpoints[4290] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}", "PATCH");
            Endpoints[4291] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}", "DELETE");
            Endpoints[4292] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}", "GET");
            Endpoints[4293] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}", "PUT");
            Endpoints[4294] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}", "GET");
            Endpoints[4295] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}", "HEAD");
            Endpoints[4296] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}", "DELETE");
            Endpoints[4297] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}", "PUT");
            Endpoints[4298] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}", "GET");
            Endpoints[4299] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}", "HEAD");
            Endpoints[4300] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}", "DELETE");
            Endpoints[4301] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}", "PATCH");
            Endpoints[4302] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policies/{policyId}", "DELETE");
            Endpoints[4303] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policies/{policyId}", "GET");
            Endpoints[4304] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policies/{policyId}", "HEAD");
            Endpoints[4305] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/policies/{policyId}", "PUT");
            Endpoints[4306] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}", "PATCH");
            Endpoints[4307] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}", "PUT");
            Endpoints[4308] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}", "GET");
            Endpoints[4309] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}", "DELETE");
            Endpoints[4310] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}", "PARAMETERS");
            Endpoints[4311] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/releases/{releaseId}", "HEAD");
            Endpoints[4312] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/schemas/{schemaId}", "HEAD");
            Endpoints[4313] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/schemas/{schemaId}", "GET");
            Endpoints[4314] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/schemas/{schemaId}", "PUT");
            Endpoints[4315] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/schemas/{schemaId}", "DELETE");
            Endpoints[4316] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions/{tagId}", "PUT");
            Endpoints[4317] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions/{tagId}", "GET");
            Endpoints[4318] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions/{tagId}", "HEAD");
            Endpoints[4319] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions/{tagId}", "DELETE");
            Endpoints[4320] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tags/{tagId}", "DELETE");
            Endpoints[4321] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tags/{tagId}", "PUT");
            Endpoints[4322] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tags/{tagId}", "GET");
            Endpoints[4323] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tags/{tagId}", "HEAD");
            Endpoints[4324] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}/loggers/{loggerid}", "DELETE");
            Endpoints[4325] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}/loggers/{loggerid}", "HEAD");
            Endpoints[4326] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}/loggers/{loggerid}", "PUT");
            Endpoints[4327] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}/users/{uid}", "PUT");
            Endpoints[4328] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}/users/{uid}", "HEAD");
            Endpoints[4329] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}/users/{uid}", "DELETE");
            Endpoints[4330] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}", "HEAD");
            Endpoints[4331] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}", "PUT");
            Endpoints[4332] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientEmails/{email}", "DELETE");
            Endpoints[4333] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientUsers/{uid}", "HEAD");
            Endpoints[4334] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientUsers/{uid}", "DELETE");
            Endpoints[4335] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/notifications/{notificationName}/recipientUsers/{uid}", "PUT");
            Endpoints[4336] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/apis/{apiId}", "DELETE");
            Endpoints[4337] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/apis/{apiId}", "HEAD");
            Endpoints[4338] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/apis/{apiId}", "PUT");
            Endpoints[4339] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/groups/{groupId}", "PUT");
            Endpoints[4340] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/groups/{groupId}", "HEAD");
            Endpoints[4341] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/groups/{groupId}", "DELETE");
            Endpoints[4342] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policies/{policyId}", "GET");
            Endpoints[4343] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policies/{policyId}", "HEAD");
            Endpoints[4344] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policies/{policyId}", "DELETE");
            Endpoints[4345] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/policies/{policyId}", "PUT");
            Endpoints[4346] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/tags/{tagId}", "DELETE");
            Endpoints[4347] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/tags/{tagId}", "HEAD");
            Endpoints[4348] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/tags/{tagId}", "PUT");
            Endpoints[4349] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/tags/{tagId}", "GET");
            Endpoints[4350] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/periods/{quotaPeriodKey}", "PATCH");
            Endpoints[4351] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/periods/{quotaPeriodKey}", "GET");
            Endpoints[4352] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/compilationjobs/{jobId}/streams/{jobStreamId}", "GET");
            Endpoints[4353] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobs/{jobId}/streams/{jobStreamId}", "GET");
            Endpoints[4354] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/activities/{activityName}", "GET");
            Endpoints[4355] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes/{nodeId}/reports/{reportId}", "GET");
            Endpoints[4356] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}", "GET");
            Endpoints[4357] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}", "PUT");
            Endpoints[4358] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}/versions/{version}", "GET");
            Endpoints[4359] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}/versions/{version}", "PUT");
            Endpoints[4360] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}/versions/{version}", "DELETE");
            Endpoints[4361] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", "GET");
            Endpoints[4362] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", "PUT");
            Endpoints[4363] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", "DELETE");
            Endpoints[4364] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", "GET");
            Endpoints[4365] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", "PUT");
            Endpoints[4366] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", "DELETE");
            Endpoints[4367] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", "PATCH");
            Endpoints[4368] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}", "DELETE");
            Endpoints[4369] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}", "PATCH");
            Endpoints[4370] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}", "GET");
            Endpoints[4371] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/origins/{originName}", "PUT");
            Endpoints[4372] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", "PUT");
            Endpoints[4373] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", "GET");
            Endpoints[4374] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", "DELETE");
            Endpoints[4375] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}", "GET");
            Endpoints[4376] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", "PATCH");
            Endpoints[4377] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", "GET");
            Endpoints[4378] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", "PUT");
            Endpoints[4379] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}", "DELETE");
            Endpoints[4380] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}/mappings/{mappingName}", "PUT");
            Endpoints[4381] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}/mappings/{mappingName}", "GET");
            Endpoints[4382] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}/mappings/{mappingName}", "DELETE");
            Endpoints[4383] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}", "PATCH");
            Endpoints[4384] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}", "DELETE");
            Endpoints[4385] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}/containers/{containerName}", "GET");
            Endpoints[4386] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", "GET");
            Endpoints[4387] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", "PUT");
            Endpoints[4388] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", "DELETE");
            Endpoints[4389] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{artifactSourceName}/armtemplates/{name}", "GET");
            Endpoints[4390] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{artifactSourceName}/artifacts/{name}", "GET");
            Endpoints[4391] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies/{name}", "GET");
            Endpoints[4392] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies/{name}", "PUT");
            Endpoints[4393] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies/{name}", "DELETE");
            Endpoints[4394] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/policysets/{policySetName}/policies/{name}", "PATCH");
            Endpoints[4395] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}", "PUT");
            Endpoints[4396] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}", "DELETE");
            Endpoints[4397] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}", "GET");
            Endpoints[4398] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/environments/{name}", "DELETE");
            Endpoints[4399] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/environments/{name}", "GET");
            Endpoints[4400] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/environments/{name}", "PUT");
            Endpoints[4401] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/secrets/{name}", "GET");
            Endpoints[4402] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/secrets/{name}", "PUT");
            Endpoints[4403] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/secrets/{name}", "DELETE");
            Endpoints[4404] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules/{name}", "GET");
            Endpoints[4405] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules/{name}", "PUT");
            Endpoints[4406] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules/{name}", "DELETE");
            Endpoints[4407] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules/{name}", "PATCH");
            Endpoints[4408] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4409] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[4410] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4411] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[4412] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}", "POST");
            Endpoints[4413] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}", "PUT");
            Endpoints[4414] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}", "DELETE");
            Endpoints[4415] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}", "GET");
            Endpoints[4416] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/logicalNetworks/{logicalNetwork}/logicalSubnets/{logicalSubnet}", "GET");
            Endpoints[4417] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/storageSubSystems/{storageSubSystem}/storagePools/{storagePool}", "GET");
            Endpoints[4418] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/serviceHealths/{serviceRegistrationId}/resourceHealths/{resourceRegistrationId}", "GET");
            Endpoints[4419] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}", "GET");
            Endpoints[4420] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/operations/{operationId}", "GET");
            Endpoints[4421] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/histories/{historyName}", "GET");
            Endpoints[4422] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}/projects/{projectName}", "PATCH");
            Endpoints[4423] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}/projects/{projectName}", "DELETE");
            Endpoints[4424] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}/projects/{projectName}", "GET");
            Endpoints[4425] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}/projects/{projectName}", "PUT");
            Endpoints[4426] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}", "PUT");
            Endpoints[4427] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}", "DELETE");
            Endpoints[4428] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}/liveOutputs/{liveOutputName}", "GET");
            Endpoints[4429] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs/{jobName}", "DELETE");
            Endpoints[4430] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs/{jobName}", "GET");
            Endpoints[4431] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs/{jobName}", "PUT");
            Endpoints[4432] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}", "GET");
            Endpoints[4433] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}", "PUT");
            Endpoints[4434] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}", "DELETE");
            Endpoints[4435] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/arpTables/{devicePath}", "POST");
            Endpoints[4436] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/connections/{connectionName}", "DELETE");
            Endpoints[4437] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/connections/{connectionName}", "PUT");
            Endpoints[4438] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/connections/{connectionName}", "GET");
            Endpoints[4439] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/routeTables/{devicePath}", "POST");
            Endpoints[4440] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}/routeTablesSummary/{devicePath}", "POST");
            Endpoints[4441] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/arpTables/{devicePath}", "POST");
            Endpoints[4442] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTables/{devicePath}", "POST");
            Endpoints[4443] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCrossConnections/{crossConnectionName}/peerings/{peeringName}/routeTablesSummary/{devicePath}", "POST");
            Endpoints[4444] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[4445] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules/{authorizationRuleName}", "POST");
            Endpoints[4446] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[4447] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4448] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationLogicalNetworks/{logicalNetworkName}", "GET");
            Endpoints[4449] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}", "GET");
            Endpoints[4450] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}", "GET");
            Endpoints[4451] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}", "PUT");
            Endpoints[4452] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders/{providerName}", "GET");
            Endpoints[4453] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders/{providerName}", "DELETE");
            Endpoints[4454] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}", "GET");
            Endpoints[4455] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters/{vCenterName}", "PUT");
            Endpoints[4456] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters/{vCenterName}", "PATCH");
            Endpoints[4457] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters/{vCenterName}", "DELETE");
            Endpoints[4458] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationvCenters/{vCenterName}", "GET");
            Endpoints[4459] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/backupProtectionIntent/{intentObjectName}", "PUT");
            Endpoints[4460] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/operationResults/{operationId}", "GET");
            Endpoints[4461] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}", "DELETE");
            Endpoints[4462] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}", "PUT");
            Endpoints[4463] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}", "GET");
            Endpoints[4464] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupJobs/{jobName}/operationResults/{operationId}", "GET");
            Endpoints[4465] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}/operationResults/{operationId}", "GET");
            Endpoints[4466] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}/operations/{operationId}", "GET");
            Endpoints[4467] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4468] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[4469] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[4470] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/HybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}", "POST");
            Endpoints[4471] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4472] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[4473] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[4474] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/WcfRelays/{relayName}/authorizationRules/{authorizationRuleName}", "POST");
            Endpoints[4475] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4476] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/eventhubs/{eventhubName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4477] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4478] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}", "POST");
            Endpoints[4479] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[4480] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[4481] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}", "PUT");
            Endpoints[4482] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}", "GET");
            Endpoints[4483] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}", "DELETE");
            Endpoints[4484] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}", "POST");
            Endpoints[4485] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}", "PUT");
            Endpoints[4486] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}", "GET");
            Endpoints[4487] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}", "DELETE");
            Endpoints[4488] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}/services/{serviceName}", "PATCH");
            Endpoints[4489] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}/services/{serviceName}", "DELETE");
            Endpoints[4490] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}/services/{serviceName}", "PUT");
            Endpoints[4491] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applications/{applicationName}/services/{serviceName}", "GET");
            Endpoints[4492] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}/versions/{version}", "GET");
            Endpoints[4493] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}/versions/{version}", "PUT");
            Endpoints[4494] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/clusters/{clusterName}/applicationTypes/{applicationTypeName}/versions/{version}", "DELETE");
            Endpoints[4495] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}", "GET");
            Endpoints[4496] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}", "PATCH");
            Endpoints[4497] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}", "PUT");
            Endpoints[4498] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingPolicies/{tableAuditingPolicyName}", "GET");
            Endpoints[4499] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingPolicies/{tableAuditingPolicyName}", "PUT");
            Endpoints[4500] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingSettings/{blobAuditingPolicyName}", "GET");
            Endpoints[4501] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/auditingSettings/{blobAuditingPolicyName}", "PUT");
            Endpoints[4502] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupLongTermRetentionPolicies/{backupLongTermRetentionPolicyName}", "GET");
            Endpoints[4503] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupLongTermRetentionPolicies/{backupLongTermRetentionPolicyName}", "PUT");
            Endpoints[4504] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}", "PATCH");
            Endpoints[4505] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}", "PUT");
            Endpoints[4506] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}", "GET");
            Endpoints[4507] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/connectionPolicies/{connectionPolicyName}", "GET");
            Endpoints[4508] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/connectionPolicies/{connectionPolicyName}", "PUT");
            Endpoints[4509] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}", "GET");
            Endpoints[4510] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}", "PUT");
            Endpoints[4511] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataWarehouseUserActivities/{dataWarehouseUserActivityName}", "GET");
            Endpoints[4512] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/extensions/{extensionName}", "PUT");
            Endpoints[4513] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies/{geoBackupPolicyName}", "GET");
            Endpoints[4514] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/geoBackupPolicies/{geoBackupPolicyName}", "PUT");
            Endpoints[4515] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}", "GET");
            Endpoints[4516] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}", "DELETE");
            Endpoints[4517] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints/{restorePointName}", "DELETE");
            Endpoints[4518] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints/{restorePointName}", "GET");
            Endpoints[4519] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}", "PUT");
            Endpoints[4520] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}", "GET");
            Endpoints[4521] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/serviceTierAdvisors/{serviceTierAdvisorName}", "GET");
            Endpoints[4522] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}", "GET");
            Endpoints[4523] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}", "PATCH");
            Endpoints[4524] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}", "DELETE");
            Endpoints[4525] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}", "PUT");
            Endpoints[4526] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}", "PUT");
            Endpoints[4527] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}", "GET");
            Endpoints[4528] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", "PUT");
            Endpoints[4529] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", "DELETE");
            Endpoints[4530] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", "GET");
            Endpoints[4531] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/databases/{databaseName}", "GET");
            Endpoints[4532] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}", "DELETE");
            Endpoints[4533] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}", "PUT");
            Endpoints[4534] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}", "GET");
            Endpoints[4535] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}", "GET");
            Endpoints[4536] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}", "PUT");
            Endpoints[4537] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}", "DELETE");
            Endpoints[4538] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}", "PUT");
            Endpoints[4539] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}", "DELETE");
            Endpoints[4540] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}", "GET");
            Endpoints[4541] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/recommendedElasticPools/{recommendedElasticPoolName}/databases/{databaseName}", "GET");
            Endpoints[4542] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}", "GET");
            Endpoints[4543] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}", "PUT");
            Endpoints[4544] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}", "DELETE");
            Endpoints[4545] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups/{backupName}", "DELETE");
            Endpoints[4546] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/jobs/{jobName}", "GET");
            Endpoints[4547] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}", "DELETE");
            Endpoints[4548] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}", "PUT");
            Endpoints[4549] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}", "GET");
            Endpoints[4550] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}/updates/{updateName}/updateRuns/{runName}", "GET");
            Endpoints[4551] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "GET");
            Endpoints[4552] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "DELETE");
            Endpoints[4553] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "GET");
            Endpoints[4554] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "PUT");
            Endpoints[4555] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", "PATCH");
            Endpoints[4556] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", "GET");
            Endpoints[4557] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", "DELETE");
            Endpoints[4558] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", "PUT");
            Endpoints[4559] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "GET");
            Endpoints[4560] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "DELETE");
            Endpoints[4561] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "PUT");
            Endpoints[4562] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "PATCH");
            Endpoints[4563] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", "DELETE");
            Endpoints[4564] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", "GET");
            Endpoints[4565] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", "PUT");
            Endpoints[4566] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", "GET");
            Endpoints[4567] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", "DELETE");
            Endpoints[4568] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{baseAddress}", "GET");
            Endpoints[4569] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads/{threadId}", "GET");
            Endpoints[4570] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", "DELETE");
            Endpoints[4571] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", "GET");
            Endpoints[4572] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", "GET");
            Endpoints[4573] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", "DELETE");
            Endpoints[4574] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", "GET");
            Endpoints[4575] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", "PUT");
            Endpoints[4576] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", "DELETE");
            Endpoints[4577] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "PUT");
            Endpoints[4578] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "PATCH");
            Endpoints[4579] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "DELETE");
            Endpoints[4580] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", "GET");
            Endpoints[4581] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", "PUT");
            Endpoints[4582] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", "GET");
            Endpoints[4583] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", "DELETE");
            Endpoints[4584] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", "GET");
            Endpoints[4585] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", "PUT");
            Endpoints[4586] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", "DELETE");
            Endpoints[4587] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", "GET");
            Endpoints[4588] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", "PUT");
            Endpoints[4589] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", "DELETE");
            Endpoints[4590] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", "PATCH");
            Endpoints[4591] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}", "GET");
            Endpoints[4592] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/operationresults/{operationId}", "GET");
            Endpoints[4593] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", "DELETE");
            Endpoints[4594] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", "PUT");
            Endpoints[4595] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", "GET");
            Endpoints[4596] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", "DELETE");
            Endpoints[4597] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", "GET");
            Endpoints[4598] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", "DELETE");
            Endpoints[4599] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", "PUT");
            Endpoints[4600] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", "GET");
            Endpoints[4601] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", "PUT");
            Endpoints[4602] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", "GET");
            Endpoints[4603] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", "DELETE");
            Endpoints[4604] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", "GET");
            Endpoints[4605] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", "DELETE");
            Endpoints[4606] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", "PATCH");
            Endpoints[4607] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", "DELETE");
            Endpoints[4608] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", "PUT");
            Endpoints[4609] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", "GET");
            Endpoints[4610] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs/{webJobName}", "GET");
            Endpoints[4611] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history/{id}", "GET");
            Endpoints[4612] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "GET");
            Endpoints[4613] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "PUT");
            Endpoints[4614] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "PATCH");
            Endpoints[4615] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}", "GET");
            Endpoints[4616] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}", "GET");
            Endpoints[4617] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors/{detectorName}", "GET");
            Endpoints[4618] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}", "GET");
            Endpoints[4619] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/tasks/{taskName}/cancel", "POST");
            Endpoints[4620] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}/loggers", "GET");
            Endpoints[4621] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments", "GET");
            Endpoints[4622] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments", "GET");
            Endpoints[4623] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policies", "GET");
            Endpoints[4624] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policy", "PUT");
            Endpoints[4625] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policy", "GET");
            Endpoints[4626] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policy", "DELETE");
            Endpoints[4627] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/tags", "GET");
            Endpoints[4628] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/objectDataTypes/{typeName}/fields", "GET");
            Endpoints[4629] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/modules/{moduleName}/types/{typeName}/fields", "GET");
            Endpoints[4630] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/nodes/{nodeId}/reports/{reportId}/content", "GET");
            Endpoints[4631] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}/streams", "GET");
            Endpoints[4632] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}/versions/{version}/activate", "POST");
            Endpoints[4633] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listOutputFiles", "POST");
            Endpoints[4634] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listRemoteLoginInformation", "POST");
            Endpoints[4635] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/terminate", "POST");
            Endpoints[4636] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/disableCustomHttps", "POST");
            Endpoints[4637] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/enableCustomHttps", "POST");
            Endpoints[4638] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}/ipConfigurations", "GET");
            Endpoints[4639] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/buildTasks/{buildTaskName}/steps/{stepName}/listBuildArguments", "POST");
            Endpoints[4640] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/integrationRuntimes/{integrationRuntimeName}/nodes/{nodeName}/ipAddress", "POST");
            Endpoints[4641] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/storageAccounts/{storageAccountName}/containers/{containerName}/listSasTokens", "POST");
            Endpoints[4642] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/artifactsources/{artifactSourceName}/artifacts/{name}/generateArmTemplate", "POST");
            Endpoints[4643] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}/attach", "POST");
            Endpoints[4644] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}/detach", "POST");
            Endpoints[4645] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{virtualMachineName}/schedules/{name}/execute", "POST");
            Endpoints[4646] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/metricDefinitions", "GET");
            Endpoints[4647] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/metrics", "GET");
            Endpoints[4648] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/usages", "GET");
            Endpoints[4649] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4650] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}/ListKeys", "POST");
            Endpoints[4651] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4652] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/storageSubSystems/{storageSubSystem}/storagePools/{storagePool}/volumes", "GET");
            Endpoints[4653] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}/listExpressionTraces", "POST");
            Endpoints[4654] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}/repetitions", "GET");
            Endpoints[4655] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}/scopeRepetitions", "GET");
            Endpoints[4656] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/triggers/{triggerName}/histories/{historyName}/resubmit", "POST");
            Endpoints[4657] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/versions/{versionId}/triggers/{triggerName}/listCallbackUrl", "POST");
            Endpoints[4658] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs/{jobName}/cancelJob", "POST");
            Endpoints[4659] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines", "GET");
            Endpoints[4660] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}/downloadUrl", "POST");
            Endpoints[4661] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4662] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4663] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings", "GET");
            Endpoints[4664] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/discoverProtectableItem", "POST");
            Endpoints[4665] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/remove", "POST");
            Endpoints[4666] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectableItems", "GET");
            Endpoints[4667] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems", "GET");
            Endpoints[4668] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings", "GET");
            Endpoints[4669] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/switchprotection", "POST");
            Endpoints[4670] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders/{providerName}/refreshProvider", "POST");
            Endpoints[4671] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationRecoveryServicesProviders/{providerName}/remove", "POST");
            Endpoints[4672] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}/replicationStorageClassificationMappings", "GET");
            Endpoints[4673] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/inquire", "POST");
            Endpoints[4674] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/items", "GET");
            Endpoints[4675] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4676] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/hybridConnections/{hybridConnectionName}/authorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4677] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4678] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/wcfRelays/{relayName}/authorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4679] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}/AuthorizationRules/{authorizationRuleName}/listKeys", "POST");
            Endpoints[4680] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}/ListKeys", "POST");
            Endpoints[4681] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4682] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/ListKeys", "POST");
            Endpoints[4683] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/authorizationRules/{authorizationRuleName}/regenerateKeys", "POST");
            Endpoints[4684] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules", "GET");
            Endpoints[4685] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}/recommendedActions", "GET");
            Endpoints[4686] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}/rules", "GET");
            Endpoints[4687] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/operations/{operationId}/cancel", "POST");
            Endpoints[4688] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/failover", "POST");
            Endpoints[4689] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}/forceFailoverAllowDataLoss", "POST");
            Endpoints[4690] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/cancelSync", "POST");
            Endpoints[4691] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/hubSchemas", "GET");
            Endpoints[4692] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/logs", "GET");
            Endpoints[4693] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/refreshHubSchema", "POST");
            Endpoints[4694] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers", "GET");
            Endpoints[4695] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/triggerSync", "POST");
            Endpoints[4696] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/topQueries/{queryId}/queryText", "GET");
            Endpoints[4697] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/topQueries/{queryId}/statistics", "GET");
            Endpoints[4698] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}/operationResults", "GET");
            Endpoints[4699] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans", "GET");
            Endpoints[4700] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/operations/{operationId}/cancel", "POST");
            Endpoints[4701] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions", "GET");
            Endpoints[4702] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start", "POST");
            Endpoints[4703] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps", "GET");
            Endpoints[4704] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions", "GET");
            Endpoints[4705] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/backup", "POST");
            Endpoints[4706] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/schedules", "GET");
            Endpoints[4707] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups/{backupName}/restore", "POST");
            Endpoints[4708] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/hardwareComponentGroups/{hardwareComponentGroupName}/changeControllerPowerState", "POST");
            Endpoints[4709] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/jobs/{jobName}/cancel", "POST");
            Endpoints[4710] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/metrics", "GET");
            Endpoints[4711] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/metricsDefinitions", "GET");
            Endpoints[4712] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes", "GET");
            Endpoints[4713] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Update.Admin/updateLocations/{updateLocation}/updates/{updateName}/updateRuns/{runName}/rerun", "POST");
            Endpoints[4714] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{rootResourceName}/project/{resourceName}/subContainers/{subContainerName}/status", "GET");
            Endpoints[4715] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions", "GET");
            Endpoints[4716] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metrics", "GET");
            Endpoints[4717] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", "POST");
            Endpoints[4718] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/sites", "GET");
            Endpoints[4719] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", "POST");
            Endpoints[4720] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump", "GET");
            Endpoints[4721] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules", "GET");
            Endpoints[4722] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads", "GET");
            Endpoints[4723] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list", "POST");
            Endpoints[4724] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore", "POST");
            Endpoints[4725] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}/start", "POST");
            Endpoints[4726] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}/stop", "POST");
            Endpoints[4727] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}/log", "GET");
            Endpoints[4728] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listsecrets", "POST");
            Endpoints[4729] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments", "GET");
            Endpoints[4730] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes", "GET");
            Endpoints[4731] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/dump", "GET");
            Endpoints[4732] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules", "GET");
            Endpoints[4733] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads", "GET");
            Endpoints[4734] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history", "GET");
            Endpoints[4735] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/run", "POST");
            Endpoints[4736] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute", "POST");
            Endpoints[4737] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute", "POST");
            Endpoints[4738] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses", "GET");
            Endpoints[4739] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors", "GET");
            Endpoints[4740] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitions/metrics", "GET");
            Endpoints[4741] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitions/usages", "GET");
            Endpoints[4742] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sourceRegion/{sourceRegion}/targetRegion/{targetRegion}/percentile/metrics", "GET");
            Endpoints[4743] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy", "PUT");
            Endpoints[4744] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy", "GET");
            Endpoints[4745] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy/log", "GET");
            Endpoints[4746] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}/loggers/{loggerid}", "DELETE");
            Endpoints[4747] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}/loggers/{loggerid}", "PUT");
            Endpoints[4748] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/diagnostics/{diagnosticId}/loggers/{loggerid}", "HEAD");
            Endpoints[4749] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments/{attachmentId}", "DELETE");
            Endpoints[4750] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments/{attachmentId}", "PUT");
            Endpoints[4751] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments/{attachmentId}", "GET");
            Endpoints[4752] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments/{attachmentId}", "HEAD");
            Endpoints[4753] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments/{commentId}", "HEAD");
            Endpoints[4754] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments/{commentId}", "DELETE");
            Endpoints[4755] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments/{commentId}", "GET");
            Endpoints[4756] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments/{commentId}", "PUT");
            Endpoints[4757] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policies/{policyId}", "GET");
            Endpoints[4758] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policies/{policyId}", "DELETE");
            Endpoints[4759] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policies/{policyId}", "PUT");
            Endpoints[4760] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/policies/{policyId}", "HEAD");
            Endpoints[4761] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/tags/{tagId}", "DELETE");
            Endpoints[4762] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/tags/{tagId}", "HEAD");
            Endpoints[4763] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/tags/{tagId}", "GET");
            Endpoints[4764] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}/tags/{tagId}", "PUT");
            Endpoints[4765] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}/streams/{streamId}", "GET");
            Endpoints[4766] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}/ipConfigurations/{ipConfigurationName}", "GET");
            Endpoints[4767] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/storageSubSystems/{storageSubSystem}/storagePools/{storagePool}/volumes/{volume}", "GET");
            Endpoints[4768] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}/repetitions/{repetitionName}", "GET");
            Endpoints[4769] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}/scopeRepetitions/{repetitionName}", "GET");
            Endpoints[4770] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines/{assessedMachineName}", "GET");
            Endpoints[4771] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings/{networkMappingName}", "GET");
            Endpoints[4772] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings/{networkMappingName}", "DELETE");
            Endpoints[4773] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings/{networkMappingName}", "PUT");
            Endpoints[4774] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings/{networkMappingName}", "PATCH");
            Endpoints[4775] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectableItems/{protectableItemName}", "GET");
            Endpoints[4776] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", "PATCH");
            Endpoints[4777] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", "DELETE");
            Endpoints[4778] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", "PUT");
            Endpoints[4779] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", "GET");
            Endpoints[4780] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}", "DELETE");
            Endpoints[4781] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}", "PUT");
            Endpoints[4782] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}", "PATCH");
            Endpoints[4783] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}", "GET");
            Endpoints[4784] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}/replicationStorageClassificationMappings/{storageClassificationMappingName}", "PUT");
            Endpoints[4785] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}/replicationStorageClassificationMappings/{storageClassificationMappingName}", "GET");
            Endpoints[4786] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationStorageClassifications/{storageClassificationName}/replicationStorageClassificationMappings/{storageClassificationMappingName}", "DELETE");
            Endpoints[4787] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/operationResults/{operationId}", "GET");
            Endpoints[4788] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}", "PUT");
            Endpoints[4789] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}", "GET");
            Endpoints[4790] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}", "DELETE");
            Endpoints[4791] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}", "GET");
            Endpoints[4792] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}", "DELETE");
            Endpoints[4793] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}", "PUT");
            Endpoints[4794] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}/recommendedActions/{recommendedActionName}", "GET");
            Endpoints[4795] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}/recommendedActions/{recommendedActionName}", "PATCH");
            Endpoints[4796] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}/rules/{dataMaskingRuleName}", "PUT");
            Endpoints[4797] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", "PUT");
            Endpoints[4798] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", "PATCH");
            Endpoints[4799] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", "GET");
            Endpoints[4800] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}", "DELETE");
            Endpoints[4801] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}", "GET");
            Endpoints[4802] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}", "PUT");
            Endpoints[4803] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}", "GET");
            Endpoints[4804] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}", "DELETE");
            Endpoints[4805] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}", "PUT");
            Endpoints[4806] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}", "GET");
            Endpoints[4807] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}", "GET");
            Endpoints[4808] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/schedules/{backupScheduleName}", "PUT");
            Endpoints[4809] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/schedules/{backupScheduleName}", "GET");
            Endpoints[4810] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/schedules/{backupScheduleName}", "DELETE");
            Endpoints[4811] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}", "GET");
            Endpoints[4812] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}", "DELETE");
            Endpoints[4813] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}", "PUT");
            Endpoints[4814] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}", "GET");
            Endpoints[4815] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads/{threadId}", "GET");
            Endpoints[4816] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "GET");
            Endpoints[4817] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "DELETE");
            Endpoints[4818] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "PUT");
            Endpoints[4819] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", "PATCH");
            Endpoints[4820] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", "DELETE");
            Endpoints[4821] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", "GET");
            Endpoints[4822] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", "PUT");
            Endpoints[4823] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", "DELETE");
            Endpoints[4824] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", "GET");
            Endpoints[4825] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules/{baseAddress}", "GET");
            Endpoints[4826] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads/{threadId}", "GET");
            Endpoints[4827] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history/{id}", "GET");
            Endpoints[4828] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "GET");
            Endpoints[4829] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "PUT");
            Endpoints[4830] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", "PATCH");
            Endpoints[4831] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}", "GET");
            Endpoints[4832] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}", "GET");
            Endpoints[4833] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}/ipconfigurations/{ipConfigurationName}/publicipaddresses", "GET");
            Endpoints[4834] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitionKeyRangeId/{partitionKeyRangeId}/metrics", "GET");
            Endpoints[4835] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/region/{region}/databases/{databaseRid}/collections/{collectionRid}/metrics", "GET");
            Endpoints[4836] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/runs/{runName}/actions/{actionName}/repetitions/{repetitionName}/listExpressionTraces", "POST");
            Endpoints[4837] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/applyRecoveryPoint", "POST");
            Endpoints[4838] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCommit", "POST");
            Endpoints[4839] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/plannedFailover", "POST");
            Endpoints[4840] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/recoveryPoints", "GET");
            Endpoints[4841] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/remove", "POST");
            Endpoints[4842] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/repairReplication", "POST");
            Endpoints[4843] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/reProtect", "POST");
            Endpoints[4844] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/targetComputeSizes", "GET");
            Endpoints[4845] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailover", "POST");
            Endpoints[4846] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailoverCleanup", "POST");
            Endpoints[4847] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/unplannedFailover", "POST");
            Endpoints[4848] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicationProtectedItemName}/updateMobilityService", "POST");
            Endpoints[4849] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionContainerMappings/{mappingName}/remove", "POST");
            Endpoints[4850] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/backup", "POST");
            Endpoints[4851] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/recoveryPoints", "GET");
            Endpoints[4852] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/refreshSchema", "POST");
            Endpoints[4853] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/schemas", "GET");
            Endpoints[4854] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export", "POST");
            Endpoints[4855] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan", "POST");
            Endpoints[4856] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/cancel", "POST");
            Endpoints[4857] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps", "GET");
            Endpoints[4858] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/targets", "GET");
            Endpoints[4859] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}/steps", "GET");
            Endpoints[4860] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backups/{backupName}/elements/{backupElementName}/clone", "POST");
            Endpoints[4861] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}/metrics", "GET");
            Endpoints[4862] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}/volumes/{volumeName}/metricsDefinitions", "GET");
            Endpoints[4863] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", "POST");
            Endpoints[4864] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/dump", "GET");
            Endpoints[4865] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules", "GET");
            Endpoints[4866] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads", "GET");
            Endpoints[4867] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute", "POST");
            Endpoints[4868] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute", "POST");
            Endpoints[4869] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/region/{region}/databases/{databaseRid}/collections/{collectionRid}/partitions/metrics", "GET");
            Endpoints[4870] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}/ipconfigurations/{ipConfigurationName}/publicipaddresses/{publicIpAddressName}", "GET");
            Endpoints[4871] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/recoveryPoints/{recoveryPointName}", "GET");
            Endpoints[4872] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/operationResults/{operationId}", "GET");
            Endpoints[4873] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/operationsStatus/{operationId}", "GET");
            Endpoints[4874] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/recoveryPoints/{recoveryPointId}", "GET");
            Endpoints[4875] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", "GET");
            Endpoints[4876] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", "PUT");
            Endpoints[4877] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", "DELETE");
            Endpoints[4878] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}", "GET");
            Endpoints[4879] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}/steps/{stepName}", "GET");
            Endpoints[4880] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}", "GET");
            Endpoints[4881] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads/{threadId}", "GET");
            Endpoints[4882] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/region/{region}/databases/{databaseRid}/collections/{collectionRid}/partitionKeyRangeId/{partitionKeyRangeId}/metrics", "GET");
            Endpoints[4883] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/recoveryPoints/{recoveryPointId}/provisionInstantItemRecovery", "POST");
            Endpoints[4884] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/recoveryPoints/{recoveryPointId}/restore", "POST");
            Endpoints[4885] = CreateEndpoint("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}/protectedItems/{protectedItemName}/recoveryPoints/{recoveryPointId}/revokeInstantItemRecovery", "POST");
            Endpoints[4886] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}/targets", "GET");
            Endpoints[4887] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}/targets/{targetId}", "GET");
            Endpoints[4888] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/{quotaPeriodKey}", "GET");
            Endpoints[4889] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/quotas/{quotaCounterKey}/{quotaPeriodKey}", "PATCH");
            Endpoints[4890] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/alerts/{alertName}/{alertUpdateActionType}", "POST");
            Endpoints[4891] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}/{jitNetworkAccessPolicyActionType}", "POST");
            Endpoints[4892] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/tasks/{taskName}/{taskUpdateActionType}", "POST");
            Endpoints[4893] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}", "GET");
            Endpoints[4894] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}", "GET");
            Endpoints[4895] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item", "PUT");
            Endpoints[4896] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item", "DELETE");
            Endpoints[4897] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item", "GET");
            Endpoints[4898] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}", "DELETE");
            Endpoints[4899] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}", "PUT");
            Endpoints[4900] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}", "GET");
            Endpoints[4901] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}", "PATCH");
            Endpoints[4902] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}", "DELETE");
            Endpoints[4903] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}", "PUT");
            Endpoints[4904] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}", "GET");
            Endpoints[4905] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}", "PATCH");
            Endpoints[4906] = CreateEndpoint("/apis/{apiId}/operations/{operationId}/policies/{policyId}", "PUT");
            Endpoints[4907] = CreateEndpoint("/apis/{apiId}/operations/{operationId}/policies/{policyId}", "GET");
            Endpoints[4908] = CreateEndpoint("/apis/{apiId}/operations/{operationId}/policies/{policyId}", "DELETE");
            Endpoints[4909] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", "PUT");
            Endpoints[4910] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", "GET");
            Endpoints[4911] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", "DELETE");
            Endpoints[4912] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", "PATCH");
            Endpoints[4913] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", "PUT");
            Endpoints[4914] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", "GET");
            Endpoints[4915] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", "DELETE");
            Endpoints[4916] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltdomains/{domainName}", "DELETE");
            Endpoints[4917] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}", "PUT");
            Endpoints[4918] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}", "GET");
            Endpoints[4919] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}", "DELETE");
            Endpoints[4920] = CreateEndpoint("/apps/{appId}/versions/{versionId}/examples/{exampleId}", "DELETE");
            Endpoints[4921] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", "GET");
            Endpoints[4922] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", "PUT");
            Endpoints[4923] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", "DELETE");
            Endpoints[4924] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents/{intentId}", "PUT");
            Endpoints[4925] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents/{intentId}", "DELETE");
            Endpoints[4926] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents/{intentId}", "GET");
            Endpoints[4927] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", "GET");
            Endpoints[4928] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", "PUT");
            Endpoints[4929] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", "DELETE");
            Endpoints[4930] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrules/{patternId}", "PUT");
            Endpoints[4931] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternrules/{patternId}", "DELETE");
            Endpoints[4932] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patterns/{patternId}", "DELETE");
            Endpoints[4933] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patterns/{patternId}", "GET");
            Endpoints[4934] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patterns/{patternId}", "PUT");
            Endpoints[4935] = CreateEndpoint("/apps/{appId}/versions/{versionId}/phraselists/{phraselistId}", "GET");
            Endpoints[4936] = CreateEndpoint("/apps/{appId}/versions/{versionId}/phraselists/{phraselistId}", "DELETE");
            Endpoints[4937] = CreateEndpoint("/apps/{appId}/versions/{versionId}/phraselists/{phraselistId}", "PUT");
            Endpoints[4938] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", "DELETE");
            Endpoints[4939] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", "GET");
            Endpoints[4940] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", "GET");
            Endpoints[4941] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", "DELETE");
            Endpoints[4942] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", "PUT");
            Endpoints[4943] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/files/{filePath}", "GET");
            Endpoints[4944] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/files/{filePath}", "HEAD");
            Endpoints[4945] = CreateEndpoint("/jobs/{jobId}/tasks/{taskId}/files/{filePath}", "DELETE");
            Endpoints[4946] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}/persistedFaces/{persistedFaceId}", "GET");
            Endpoints[4947] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}/persistedFaces/{persistedFaceId}", "DELETE");
            Endpoints[4948] = CreateEndpoint("/persongroups/{personGroupId}/persons/{personId}/persistedFaces/{persistedFaceId}", "PATCH");
            Endpoints[4949] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/files/{filePath}", "HEAD");
            Endpoints[4950] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/files/{filePath}", "DELETE");
            Endpoints[4951] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/files/{filePath}", "GET");
            Endpoints[4952] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/users/{userName}", "PUT");
            Endpoints[4953] = CreateEndpoint("/pools/{poolId}/nodes/{nodeId}/users/{userName}", "DELETE");
            Endpoints[4954] = CreateEndpoint("/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}", "DELETE");
            Endpoints[4955] = CreateEndpoint("/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}", "PUT");
            Endpoints[4956] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists", "POST");
            Endpoints[4957] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles", "POST");
            Endpoints[4958] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles", "GET");
            Endpoints[4959] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children", "POST");
            Endpoints[4960] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles", "POST");
            Endpoints[4961] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles", "GET");
            Endpoints[4962] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles", "GET");
            Endpoints[4963] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles", "POST");
            Endpoints[4964] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles", "GET");
            Endpoints[4965] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles", "POST");
            Endpoints[4966] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}/suggest", "GET");
            Endpoints[4967] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children", "POST");
            Endpoints[4968] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles", "POST");
            Endpoints[4969] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles", "GET");
            Endpoints[4970] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents/{intentId}/patternrules", "GET");
            Endpoints[4971] = CreateEndpoint("/apps/{appId}/versions/{versionId}/intents/{intentId}/suggest", "GET");
            Endpoints[4972] = CreateEndpoint("/apps/{appId}/versions/{versionId}/models/{modelId}/examples", "GET");
            Endpoints[4973] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist", "GET");
            Endpoints[4974] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist", "POST");
            Endpoints[4975] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles", "POST");
            Endpoints[4976] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles", "GET");
            Endpoints[4977] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles", "GET");
            Endpoints[4978] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles", "POST");
            Endpoints[4979] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles", "GET");
            Endpoints[4980] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles", "POST");
            Endpoints[4981] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations", "GET");
            Endpoints[4982] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[4983] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[4984] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[4985] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[4986] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[4987] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[4988] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[4989] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[4990] = CreateEndpoint("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[4991] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", "DELETE");
            Endpoints[4992] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", "PUT");
            Endpoints[4993] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", "GET");
            Endpoints[4994] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", "PUT");
            Endpoints[4995] = CreateEndpoint("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", "DELETE");
            Endpoints[4996] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children/{cChildId}", "DELETE");
            Endpoints[4997] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", "DELETE");
            Endpoints[4998] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", "PUT");
            Endpoints[4999] = CreateEndpoint("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", "GET");
            Endpoints[5000] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", "GET");
            Endpoints[5001] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", "PUT");
            Endpoints[5002] = CreateEndpoint("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", "DELETE");
            Endpoints[5003] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", "DELETE");
            Endpoints[5004] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", "GET");
            Endpoints[5005] = CreateEndpoint("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", "PUT");
            Endpoints[5006] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", "DELETE");
            Endpoints[5007] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", "PUT");
            Endpoints[5008] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", "GET");
            Endpoints[5009] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", "DELETE");
            Endpoints[5010] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", "PUT");
            Endpoints[5011] = CreateEndpoint("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", "GET");
            Endpoints[5012] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", "PUT");
            Endpoints[5013] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", "GET");
            Endpoints[5014] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", "DELETE");
            Endpoints[5015] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", "GET");
            Endpoints[5016] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", "DELETE");
            Endpoints[5017] = CreateEndpoint("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", "PUT");
            Endpoints[5018] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", "DELETE");
            Endpoints[5019] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", "PUT");
            Endpoints[5020] = CreateEndpoint("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", "GET");
            Endpoints[5021] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", "GET");
            Endpoints[5022] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", "DELETE");
            Endpoints[5023] = CreateEndpoint("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", "PUT");
            Endpoints[5024] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations/{operationId}", "GET");
            Endpoints[5025] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[5026] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[5027] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[5028] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{providerNamespace}/{resourceTypeName}/{resourceName}/providers/Microsoft.EventGrid/eventSubscriptions", "GET");
            Endpoints[5029] = CreateEndpoint("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{providerNamespace}/{resourceTypeName}/{resourceName}/providers/Microsoft.EventGrid/eventTypes", "GET");
            Endpoints[5030] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.OperationsManagement/ManagementAssociations/{managementAssociationName}", "GET");
            Endpoints[5031] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.OperationsManagement/ManagementAssociations/{managementAssociationName}", "PUT");
            Endpoints[5032] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.OperationsManagement/ManagementAssociations/{managementAssociationName}", "DELETE");
            Endpoints[5033] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", "PUT");
            Endpoints[5034] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", "GET");
            Endpoints[5035] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", "PATCH");
            Endpoints[5036] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", "DELETE");
            Endpoints[5037] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}", "HEAD");
            Endpoints[5038] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks", "GET");
            Endpoints[5039] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/permissions", "GET");
            Endpoints[5040] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/policyAssignments", "GET");
            Endpoints[5041] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/roleAssignments", "GET");
            Endpoints[5042] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", "DELETE");
            Endpoints[5043] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", "GET");
            Endpoints[5044] = CreateEndpoint("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", "PUT");
            Endpoints[5045] = CreateEndpoint("/apps/{appId}/events/{eventType}/{eventId}", "GET");
            Endpoints[5046] = CreateEndpoint("/certificates/{certificate-name}/{certificate-version}", "PATCH");
            Endpoints[5047] = CreateEndpoint("/certificates/{certificate-name}/{certificate-version}", "GET");
            Endpoints[5048] = CreateEndpoint("/keys/{key-name}/{key-version}", "GET");
            Endpoints[5049] = CreateEndpoint("/keys/{key-name}/{key-version}", "PATCH");
            Endpoints[5050] = CreateEndpoint("/quotas/{quotaCounterKey}/{quotaPeriodKey}", "GET");
            Endpoints[5051] = CreateEndpoint("/quotas/{quotaCounterKey}/{quotaPeriodKey}", "PATCH");
            Endpoints[5052] = CreateEndpoint("/secrets/{secret-name}/{secret-version}", "PATCH");
            Endpoints[5053] = CreateEndpoint("/secrets/{secret-name}/{secret-version}", "GET");
            Endpoints[5054] = CreateEndpoint("/keys/{key-name}/{key-version}/decrypt", "POST");
            Endpoints[5055] = CreateEndpoint("/keys/{key-name}/{key-version}/encrypt", "POST");
            Endpoints[5056] = CreateEndpoint("/keys/{key-name}/{key-version}/sign", "POST");
            Endpoints[5057] = CreateEndpoint("/keys/{key-name}/{key-version}/unwrapkey", "POST");
            Endpoints[5058] = CreateEndpoint("/keys/{key-name}/{key-version}/verify", "POST");
            Endpoints[5059] = CreateEndpoint("/keys/{key-name}/{key-version}/wrapkey", "POST");
            Endpoints[5060] = CreateEndpoint("/{appId}", "POST");
            Endpoints[5061] = CreateEndpoint("/{applicationDefinitionId}", "DELETE");
            Endpoints[5062] = CreateEndpoint("/{applicationDefinitionId}", "PUT");
            Endpoints[5063] = CreateEndpoint("/{applicationDefinitionId}", "GET");
            Endpoints[5064] = CreateEndpoint("/{applicationId}", "PATCH");
            Endpoints[5065] = CreateEndpoint("/{resourceId}", "HEAD");
            Endpoints[5066] = CreateEndpoint("/{projectId}/image", "POST");
            Endpoints[5067] = CreateEndpoint("/{projectId}/url", "POST");
            Endpoints[5068] = CreateEndpoint("/{tenantID}/applications", "GET");
            Endpoints[5069] = CreateEndpoint("/{tenantID}/applications", "POST");
            Endpoints[5070] = CreateEndpoint("/{tenantID}/domains", "GET");
            Endpoints[5071] = CreateEndpoint("/{tenantID}/getObjectsByObjectIds", "POST");
            Endpoints[5072] = CreateEndpoint("/{tenantID}/groups", "GET");
            Endpoints[5073] = CreateEndpoint("/{tenantID}/groups", "POST");
            Endpoints[5074] = CreateEndpoint("/{tenantID}/isMemberOf", "POST");
            Endpoints[5075] = CreateEndpoint("/{tenantID}/me", "GET");
            Endpoints[5076] = CreateEndpoint("/{tenantID}/servicePrincipals", "POST");
            Endpoints[5077] = CreateEndpoint("/{tenantID}/servicePrincipals", "GET");
            Endpoints[5078] = CreateEndpoint("/{tenantID}/users", "POST");
            Endpoints[5079] = CreateEndpoint("/{tenantID}/users", "GET");
            Endpoints[5080] = CreateEndpoint("/{projectId}/image/nostore", "POST");
            Endpoints[5081] = CreateEndpoint("/{projectId}/url/nostore", "POST");
            Endpoints[5082] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/calculatebaseline", "POST");
            Endpoints[5083] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings", "GET");
            Endpoints[5084] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettingsCategories", "GET");
            Endpoints[5085] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/metricDefinitions", "GET");
            Endpoints[5086] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/metrics", "GET");
            Endpoints[5087] = CreateEndpoint("/{resourceUri}/providers/Microsoft.ResourceHealth/availabilityStatuses", "GET");
            Endpoints[5088] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/policyAssignments", "GET");
            Endpoints[5089] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleAssignments", "GET");
            Endpoints[5090] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleDefinitions", "GET");
            Endpoints[5091] = CreateEndpoint("/{scope}/providers/Microsoft.Consumption/reservationDetails", "GET");
            Endpoints[5092] = CreateEndpoint("/{scope}/providers/Microsoft.Consumption/reservationSummaries", "GET");
            Endpoints[5093] = CreateEndpoint("/{scope}/providers/Microsoft.Consumption/usageDetails", "GET");
            Endpoints[5094] = CreateEndpoint("/{scope}/providers/Microsoft.Resources/links", "GET");
            Endpoints[5095] = CreateEndpoint("/{scope}/providers/Microsoft.Security/compliances", "GET");
            Endpoints[5096] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings/service", "PATCH");
            Endpoints[5097] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings/service", "PUT");
            Endpoints[5098] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings/service", "GET");
            Endpoints[5099] = CreateEndpoint("/{resourceUri}/providers/Microsoft.ResourceHealth/availabilityStatuses/current", "GET");
            Endpoints[5100] = CreateEndpoint("/{scope}/providers/Microsoft.PolicyInsights/policyEvents/$metadata", "GET");
            Endpoints[5101] = CreateEndpoint("/{scope}/providers/Microsoft.PolicyInsights/policyStates/$metadata", "GET");
            Endpoints[5102] = CreateEndpoint("/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}", "GET");
            Endpoints[5103] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/baseline/{metricName}", "GET");
            Endpoints[5104] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings/{name}", "PUT");
            Endpoints[5105] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings/{name}", "GET");
            Endpoints[5106] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettings/{name}", "DELETE");
            Endpoints[5107] = CreateEndpoint("/{resourceUri}/providers/microsoft.insights/diagnosticSettingsCategories/{name}", "GET");
            Endpoints[5108] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/locks/{lockName}", "GET");
            Endpoints[5109] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/locks/{lockName}", "PUT");
            Endpoints[5110] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/locks/{lockName}", "DELETE");
            Endpoints[5111] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}", "GET");
            Endpoints[5112] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}", "PUT");
            Endpoints[5113] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}", "DELETE");
            Endpoints[5114] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}", "PUT");
            Endpoints[5115] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}", "GET");
            Endpoints[5116] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}", "DELETE");
            Endpoints[5117] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}", "PUT");
            Endpoints[5118] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}", "GET");
            Endpoints[5119] = CreateEndpoint("/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}", "DELETE");
            Endpoints[5120] = CreateEndpoint("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", "PUT");
            Endpoints[5121] = CreateEndpoint("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", "GET");
            Endpoints[5122] = CreateEndpoint("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", "DELETE");
            Endpoints[5123] = CreateEndpoint("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}", "PATCH");
            Endpoints[5124] = CreateEndpoint("/{scope}/providers/Microsoft.Security/compliances/{complianceName}", "GET");
            Endpoints[5125] = CreateEndpoint("/{resourceId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults", "POST");
            Endpoints[5126] = CreateEndpoint("/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", "POST");
            Endpoints[5127] = CreateEndpoint("/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", "POST");
            Endpoints[5128] = CreateEndpoint("/{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}/getFullUrl", "POST");
            Endpoints[5129] = CreateEndpoint("/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "DELETE");
            Endpoints[5130] = CreateEndpoint("/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "PUT");
            Endpoints[5131] = CreateEndpoint("/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "GET");
            Endpoints[5132] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}", "PATCH");
            Endpoints[5133] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}", "DELETE");
            Endpoints[5134] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}", "GET");
            Endpoints[5135] = CreateEndpoint("/{tenantID}/domains/{domainName}", "GET");
            Endpoints[5136] = CreateEndpoint("/{tenantID}/groups/{objectId}", "GET");
            Endpoints[5137] = CreateEndpoint("/{tenantID}/groups/{objectId}", "DELETE");
            Endpoints[5138] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}", "DELETE");
            Endpoints[5139] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}", "GET");
            Endpoints[5140] = CreateEndpoint("/{tenantID}/users/{upnOrObjectId}", "DELETE");
            Endpoints[5141] = CreateEndpoint("/{tenantID}/users/{upnOrObjectId}", "GET");
            Endpoints[5142] = CreateEndpoint("/{tenantID}/users/{upnOrObjectId}", "PATCH");
            Endpoints[5143] = CreateEndpoint("/{projectId}/images/{imageId}/regionproposals", "POST");
            Endpoints[5144] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}/keyCredentials", "GET");
            Endpoints[5145] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}/keyCredentials", "PATCH");
            Endpoints[5146] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}/owners", "GET");
            Endpoints[5147] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}/passwordCredentials", "GET");
            Endpoints[5148] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}/passwordCredentials", "PATCH");
            Endpoints[5149] = CreateEndpoint("/{tenantID}/groups/{objectId}/getMemberGroups", "POST");
            Endpoints[5150] = CreateEndpoint("/{tenantID}/groups/{objectId}/members", "GET");
            Endpoints[5151] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}/keyCredentials", "PATCH");
            Endpoints[5152] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}/keyCredentials", "GET");
            Endpoints[5153] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}/owners", "GET");
            Endpoints[5154] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}/passwordCredentials", "GET");
            Endpoints[5155] = CreateEndpoint("/{tenantID}/servicePrincipals/{objectId}/passwordCredentials", "PATCH");
            Endpoints[5156] = CreateEndpoint("/{tenantID}/users/{objectId}/getMemberGroups", "POST");
            Endpoints[5157] = CreateEndpoint("/{tenantID}/applications/{applicationObjectId}/$links/owners", "POST");
            Endpoints[5158] = CreateEndpoint("/{tenantID}/groups/{groupObjectId}/$links/members", "POST");
            Endpoints[5159] = CreateEndpoint("/{tenantID}/groups/{groupObjectId}/$links/members/{memberObjectId}", "DELETE");
        }

        private protected void SetupRequests()
        {
            Requests = new HttpContext[5160];
            Requests[0] = new DefaultHttpContext();
            Requests[0].RequestServices = CreateServices();
            Requests[0].Request.Method = "GET";
            Requests[0].Request.Path = "/account";
            Requests[1] = new DefaultHttpContext();
            Requests[1].RequestServices = CreateServices();
            Requests[1].Request.Method = "POST";
            Requests[1].Request.Path = "/analyze";
            Requests[2] = new DefaultHttpContext();
            Requests[2].RequestServices = CreateServices();
            Requests[2].Request.Method = "GET";
            Requests[2].Request.Path = "/apis";
            Requests[3] = new DefaultHttpContext();
            Requests[3].RequestServices = CreateServices();
            Requests[3].Request.Method = "GET";
            Requests[3].Request.Path = "/Applications";
            Requests[4] = new DefaultHttpContext();
            Requests[4].RequestServices = CreateServices();
            Requests[4].Request.Method = "GET";
            Requests[4].Request.Path = "/ApplicationTypes";
            Requests[5] = new DefaultHttpContext();
            Requests[5].RequestServices = CreateServices();
            Requests[5].Request.Method = "GET";
            Requests[5].Request.Path = "/apps";
            Requests[6] = new DefaultHttpContext();
            Requests[6].RequestServices = CreateServices();
            Requests[6].Request.Method = "POST";
            Requests[6].Request.Path = "/apps";
            Requests[7] = new DefaultHttpContext();
            Requests[7].RequestServices = CreateServices();
            Requests[7].Request.Method = "GET";
            Requests[7].Request.Path = "/authorizationServers";
            Requests[8] = new DefaultHttpContext();
            Requests[8].RequestServices = CreateServices();
            Requests[8].Request.Method = "GET";
            Requests[8].Request.Path = "/backends";
            Requests[9] = new DefaultHttpContext();
            Requests[9].RequestServices = CreateServices();
            Requests[9].Request.Method = "POST";
            Requests[9].Request.Path = "/BuildJob";
            Requests[10] = new DefaultHttpContext();
            Requests[10].RequestServices = CreateServices();
            Requests[10].Request.Method = "POST";
            Requests[10].Request.Path = "/certificates";
            Requests[11] = new DefaultHttpContext();
            Requests[11].RequestServices = CreateServices();
            Requests[11].Request.Method = "GET";
            Requests[11].Request.Path = "/certificates";
            Requests[12] = new DefaultHttpContext();
            Requests[12].RequestServices = CreateServices();
            Requests[12].Request.Method = "GET";
            Requests[12].Request.Path = "/ComposeDeployments";
            Requests[13] = new DefaultHttpContext();
            Requests[13].RequestServices = CreateServices();
            Requests[13].Request.Method = "POST";
            Requests[13].Request.Path = "/datasources";
            Requests[14] = new DefaultHttpContext();
            Requests[14].RequestServices = CreateServices();
            Requests[14].Request.Method = "GET";
            Requests[14].Request.Path = "/datasources";
            Requests[15] = new DefaultHttpContext();
            Requests[15].RequestServices = CreateServices();
            Requests[15].Request.Method = "GET";
            Requests[15].Request.Path = "/deletedcertificates";
            Requests[16] = new DefaultHttpContext();
            Requests[16].RequestServices = CreateServices();
            Requests[16].Request.Method = "GET";
            Requests[16].Request.Path = "/deletedkeys";
            Requests[17] = new DefaultHttpContext();
            Requests[17].RequestServices = CreateServices();
            Requests[17].Request.Method = "GET";
            Requests[17].Request.Path = "/deletedsecrets";
            Requests[18] = new DefaultHttpContext();
            Requests[18].RequestServices = CreateServices();
            Requests[18].Request.Method = "GET";
            Requests[18].Request.Path = "/deletedstorage";
            Requests[19] = new DefaultHttpContext();
            Requests[19].RequestServices = CreateServices();
            Requests[19].Request.Method = "POST";
            Requests[19].Request.Path = "/describe";
            Requests[20] = new DefaultHttpContext();
            Requests[20].RequestServices = CreateServices();
            Requests[20].Request.Method = "POST";
            Requests[20].Request.Path = "/detect";
            Requests[21] = new DefaultHttpContext();
            Requests[21].RequestServices = CreateServices();
            Requests[21].Request.Method = "GET";
            Requests[21].Request.Path = "/domains";
            Requests[22] = new DefaultHttpContext();
            Requests[22].RequestServices = CreateServices();
            Requests[22].Request.Method = "GET";
            Requests[22].Request.Path = "/entities";
            Requests[23] = new DefaultHttpContext();
            Requests[23].RequestServices = CreateServices();
            Requests[23].Request.Method = "GET";
            Requests[23].Request.Path = "/facelists";
            Requests[24] = new DefaultHttpContext();
            Requests[24].RequestServices = CreateServices();
            Requests[24].Request.Method = "GET";
            Requests[24].Request.Path = "/Faults";
            Requests[25] = new DefaultHttpContext();
            Requests[25].RequestServices = CreateServices();
            Requests[25].Request.Method = "POST";
            Requests[25].Request.Path = "/findsimilars";
            Requests[26] = new DefaultHttpContext();
            Requests[26].RequestServices = CreateServices();
            Requests[26].Request.Method = "POST";
            Requests[26].Request.Path = "/generateThumbnail";
            Requests[27] = new DefaultHttpContext();
            Requests[27].RequestServices = CreateServices();
            Requests[27].Request.Method = "POST";
            Requests[27].Request.Path = "/group";
            Requests[28] = new DefaultHttpContext();
            Requests[28].RequestServices = CreateServices();
            Requests[28].Request.Method = "GET";
            Requests[28].Request.Path = "/groups";
            Requests[29] = new DefaultHttpContext();
            Requests[29].RequestServices = CreateServices();
            Requests[29].Request.Method = "POST";
            Requests[29].Request.Path = "/identify";
            Requests[30] = new DefaultHttpContext();
            Requests[30].RequestServices = CreateServices();
            Requests[30].Request.Method = "GET";
            Requests[30].Request.Path = "/identityProviders";
            Requests[31] = new DefaultHttpContext();
            Requests[31].RequestServices = CreateServices();
            Requests[31].Request.Method = "GET";
            Requests[31].Request.Path = "/ImageStore";
            Requests[32] = new DefaultHttpContext();
            Requests[32].RequestServices = CreateServices();
            Requests[32].Request.Method = "POST";
            Requests[32].Request.Path = "/indexers";
            Requests[33] = new DefaultHttpContext();
            Requests[33].RequestServices = CreateServices();
            Requests[33].Request.Method = "GET";
            Requests[33].Request.Path = "/indexers";
            Requests[34] = new DefaultHttpContext();
            Requests[34].RequestServices = CreateServices();
            Requests[34].Request.Method = "GET";
            Requests[34].Request.Path = "/indexes";
            Requests[35] = new DefaultHttpContext();
            Requests[35].RequestServices = CreateServices();
            Requests[35].Request.Method = "POST";
            Requests[35].Request.Path = "/indexes";
            Requests[36] = new DefaultHttpContext();
            Requests[36].RequestServices = CreateServices();
            Requests[36].Request.Method = "POST";
            Requests[36].Request.Path = "/jobs";
            Requests[37] = new DefaultHttpContext();
            Requests[37].RequestServices = CreateServices();
            Requests[37].Request.Method = "GET";
            Requests[37].Request.Path = "/Jobs";
            Requests[38] = new DefaultHttpContext();
            Requests[38].RequestServices = CreateServices();
            Requests[38].Request.Method = "POST";
            Requests[38].Request.Path = "/jobschedules";
            Requests[39] = new DefaultHttpContext();
            Requests[39].RequestServices = CreateServices();
            Requests[39].Request.Method = "GET";
            Requests[39].Request.Path = "/jobschedules";
            Requests[40] = new DefaultHttpContext();
            Requests[40].RequestServices = CreateServices();
            Requests[40].Request.Method = "GET";
            Requests[40].Request.Path = "/keys";
            Requests[41] = new DefaultHttpContext();
            Requests[41].RequestServices = CreateServices();
            Requests[41].Request.Method = "GET";
            Requests[41].Request.Path = "/lifetimejobstats";
            Requests[42] = new DefaultHttpContext();
            Requests[42].RequestServices = CreateServices();
            Requests[42].Request.Method = "GET";
            Requests[42].Request.Path = "/lifetimepoolstats";
            Requests[43] = new DefaultHttpContext();
            Requests[43].RequestServices = CreateServices();
            Requests[43].Request.Method = "GET";
            Requests[43].Request.Path = "/loggers";
            Requests[44] = new DefaultHttpContext();
            Requests[44].RequestServices = CreateServices();
            Requests[44].Request.Method = "GET";
            Requests[44].Request.Path = "/models";
            Requests[45] = new DefaultHttpContext();
            Requests[45].RequestServices = CreateServices();
            Requests[45].Request.Method = "GET";
            Requests[45].Request.Path = "/news";
            Requests[46] = new DefaultHttpContext();
            Requests[46].RequestServices = CreateServices();
            Requests[46].Request.Method = "GET";
            Requests[46].Request.Path = "/nodeagentskus";
            Requests[47] = new DefaultHttpContext();
            Requests[47].RequestServices = CreateServices();
            Requests[47].Request.Method = "GET";
            Requests[47].Request.Path = "/nodecounts";
            Requests[48] = new DefaultHttpContext();
            Requests[48].RequestServices = CreateServices();
            Requests[48].Request.Method = "GET";
            Requests[48].Request.Path = "/Nodes";
            Requests[49] = new DefaultHttpContext();
            Requests[49].RequestServices = CreateServices();
            Requests[49].Request.Method = "POST";
            Requests[49].Request.Path = "/ocr";
            Requests[50] = new DefaultHttpContext();
            Requests[50].RequestServices = CreateServices();
            Requests[50].Request.Method = "GET";
            Requests[50].Request.Path = "/offers";
            Requests[51] = new DefaultHttpContext();
            Requests[51].RequestServices = CreateServices();
            Requests[51].Request.Method = "GET";
            Requests[51].Request.Path = "/openidConnectProviders";
            Requests[52] = new DefaultHttpContext();
            Requests[52].RequestServices = CreateServices();
            Requests[52].Request.Method = "GET";
            Requests[52].Request.Path = "/persongroups";
            Requests[53] = new DefaultHttpContext();
            Requests[53].RequestServices = CreateServices();
            Requests[53].Request.Method = "GET";
            Requests[53].Request.Path = "/pipelines";
            Requests[54] = new DefaultHttpContext();
            Requests[54].RequestServices = CreateServices();
            Requests[54].Request.Method = "GET";
            Requests[54].Request.Path = "/policies";
            Requests[55] = new DefaultHttpContext();
            Requests[55].RequestServices = CreateServices();
            Requests[55].Request.Method = "GET";
            Requests[55].Request.Path = "/policySnippets";
            Requests[56] = new DefaultHttpContext();
            Requests[56].RequestServices = CreateServices();
            Requests[56].Request.Method = "GET";
            Requests[56].Request.Path = "/pools";
            Requests[57] = new DefaultHttpContext();
            Requests[57].RequestServices = CreateServices();
            Requests[57].Request.Method = "POST";
            Requests[57].Request.Path = "/pools";
            Requests[58] = new DefaultHttpContext();
            Requests[58].RequestServices = CreateServices();
            Requests[58].Request.Method = "GET";
            Requests[58].Request.Path = "/poolusagemetrics";
            Requests[59] = new DefaultHttpContext();
            Requests[59].RequestServices = CreateServices();
            Requests[59].Request.Method = "GET";
            Requests[59].Request.Path = "/products";
            Requests[60] = new DefaultHttpContext();
            Requests[60].RequestServices = CreateServices();
            Requests[60].Request.Method = "POST";
            Requests[60].Request.Path = "/projects";
            Requests[61] = new DefaultHttpContext();
            Requests[61].RequestServices = CreateServices();
            Requests[61].Request.Method = "GET";
            Requests[61].Request.Path = "/projects";
            Requests[62] = new DefaultHttpContext();
            Requests[62].RequestServices = CreateServices();
            Requests[62].Request.Method = "GET";
            Requests[62].Request.Path = "/properties";
            Requests[63] = new DefaultHttpContext();
            Requests[63].RequestServices = CreateServices();
            Requests[63].Request.Method = "POST";
            Requests[63].Request.Path = "/recognizeText";
            Requests[64] = new DefaultHttpContext();
            Requests[64].RequestServices = CreateServices();
            Requests[64].Request.Method = "GET";
            Requests[64].Request.Path = "/recurrences";
            Requests[65] = new DefaultHttpContext();
            Requests[65].RequestServices = CreateServices();
            Requests[65].Request.Method = "GET";
            Requests[65].Request.Path = "/regions";
            Requests[66] = new DefaultHttpContext();
            Requests[66].RequestServices = CreateServices();
            Requests[66].Request.Method = "GET";
            Requests[66].Request.Path = "/search";
            Requests[67] = new DefaultHttpContext();
            Requests[67].RequestServices = CreateServices();
            Requests[67].Request.Method = "GET";
            Requests[67].Request.Path = "/secrets";
            Requests[68] = new DefaultHttpContext();
            Requests[68].RequestServices = CreateServices();
            Requests[68].Request.Method = "GET";
            Requests[68].Request.Path = "/servicestats";
            Requests[69] = new DefaultHttpContext();
            Requests[69].RequestServices = CreateServices();
            Requests[69].Request.Method = "POST";
            Requests[69].Request.Path = "/spellcheck";
            Requests[70] = new DefaultHttpContext();
            Requests[70].RequestServices = CreateServices();
            Requests[70].Request.Method = "GET";
            Requests[70].Request.Path = "/storage";
            Requests[71] = new DefaultHttpContext();
            Requests[71].RequestServices = CreateServices();
            Requests[71].Request.Method = "GET";
            Requests[71].Request.Path = "/subscriptions";
            Requests[72] = new DefaultHttpContext();
            Requests[72].RequestServices = CreateServices();
            Requests[72].Request.Method = "POST";
            Requests[72].Request.Path = "/synonymmaps";
            Requests[73] = new DefaultHttpContext();
            Requests[73].RequestServices = CreateServices();
            Requests[73].Request.Method = "GET";
            Requests[73].Request.Path = "/synonymmaps";
            Requests[74] = new DefaultHttpContext();
            Requests[74].RequestServices = CreateServices();
            Requests[74].Request.Method = "POST";
            Requests[74].Request.Path = "/tag";
            Requests[75] = new DefaultHttpContext();
            Requests[75].RequestServices = CreateServices();
            Requests[75].Request.Method = "GET";
            Requests[75].Request.Path = "/templates";
            Requests[76] = new DefaultHttpContext();
            Requests[76].RequestServices = CreateServices();
            Requests[76].Request.Method = "GET";
            Requests[76].Request.Path = "/tenants";
            Requests[77] = new DefaultHttpContext();
            Requests[77].RequestServices = CreateServices();
            Requests[77].Request.Method = "GET";
            Requests[77].Request.Path = "/users";
            Requests[78] = new DefaultHttpContext();
            Requests[78].RequestServices = CreateServices();
            Requests[78].Request.Method = "POST";
            Requests[78].Request.Path = "/verify";
            Requests[79] = new DefaultHttpContext();
            Requests[79].RequestServices = CreateServices();
            Requests[79].Request.Method = "POST";
            Requests[79].Request.Path = "/$/CancelRepairTask";
            Requests[80] = new DefaultHttpContext();
            Requests[80].RequestServices = CreateServices();
            Requests[80].Request.Method = "POST";
            Requests[80].Request.Path = "/$/CreateRepairTask";
            Requests[81] = new DefaultHttpContext();
            Requests[81].RequestServices = CreateServices();
            Requests[81].Request.Method = "POST";
            Requests[81].Request.Path = "/$/DeleteRepairTask";
            Requests[82] = new DefaultHttpContext();
            Requests[82].RequestServices = CreateServices();
            Requests[82].Request.Method = "POST";
            Requests[82].Request.Path = "/$/ForceApproveRepairTask";
            Requests[83] = new DefaultHttpContext();
            Requests[83].RequestServices = CreateServices();
            Requests[83].Request.Method = "GET";
            Requests[83].Request.Path = "/$/GetAadMetadata";
            Requests[84] = new DefaultHttpContext();
            Requests[84].RequestServices = CreateServices();
            Requests[84].Request.Method = "GET";
            Requests[84].Request.Path = "/$/GetClusterConfiguration";
            Requests[85] = new DefaultHttpContext();
            Requests[85].RequestServices = CreateServices();
            Requests[85].Request.Method = "GET";
            Requests[85].Request.Path = "/$/GetClusterConfigurationUpgradeStatus";
            Requests[86] = new DefaultHttpContext();
            Requests[86].RequestServices = CreateServices();
            Requests[86].Request.Method = "GET";
            Requests[86].Request.Path = "/$/GetClusterHealth";
            Requests[87] = new DefaultHttpContext();
            Requests[87].RequestServices = CreateServices();
            Requests[87].Request.Method = "POST";
            Requests[87].Request.Path = "/$/GetClusterHealth";
            Requests[88] = new DefaultHttpContext();
            Requests[88].RequestServices = CreateServices();
            Requests[88].Request.Method = "POST";
            Requests[88].Request.Path = "/$/GetClusterHealthChunk";
            Requests[89] = new DefaultHttpContext();
            Requests[89].RequestServices = CreateServices();
            Requests[89].Request.Method = "GET";
            Requests[89].Request.Path = "/$/GetClusterHealthChunk";
            Requests[90] = new DefaultHttpContext();
            Requests[90].RequestServices = CreateServices();
            Requests[90].Request.Method = "GET";
            Requests[90].Request.Path = "/$/GetClusterManifest";
            Requests[91] = new DefaultHttpContext();
            Requests[91].RequestServices = CreateServices();
            Requests[91].Request.Method = "GET";
            Requests[91].Request.Path = "/$/GetLoadInformation";
            Requests[92] = new DefaultHttpContext();
            Requests[92].RequestServices = CreateServices();
            Requests[92].Request.Method = "GET";
            Requests[92].Request.Path = "/$/GetProvisionedCodeVersions";
            Requests[93] = new DefaultHttpContext();
            Requests[93].RequestServices = CreateServices();
            Requests[93].Request.Method = "GET";
            Requests[93].Request.Path = "/$/GetProvisionedConfigVersions";
            Requests[94] = new DefaultHttpContext();
            Requests[94].RequestServices = CreateServices();
            Requests[94].Request.Method = "GET";
            Requests[94].Request.Path = "/$/GetRepairTaskList";
            Requests[95] = new DefaultHttpContext();
            Requests[95].RequestServices = CreateServices();
            Requests[95].Request.Method = "GET";
            Requests[95].Request.Path = "/$/GetUpgradeOrchestrationServiceState";
            Requests[96] = new DefaultHttpContext();
            Requests[96].RequestServices = CreateServices();
            Requests[96].Request.Method = "GET";
            Requests[96].Request.Path = "/$/GetUpgradeProgress";
            Requests[97] = new DefaultHttpContext();
            Requests[97].RequestServices = CreateServices();
            Requests[97].Request.Method = "POST";
            Requests[97].Request.Path = "/$/InvokeInfrastructureCommand";
            Requests[98] = new DefaultHttpContext();
            Requests[98].RequestServices = CreateServices();
            Requests[98].Request.Method = "GET";
            Requests[98].Request.Path = "/$/InvokeInfrastructureQuery";
            Requests[99] = new DefaultHttpContext();
            Requests[99].RequestServices = CreateServices();
            Requests[99].Request.Method = "POST";
            Requests[99].Request.Path = "/$/MoveToNextUpgradeDomain";
            Requests[100] = new DefaultHttpContext();
            Requests[100].RequestServices = CreateServices();
            Requests[100].Request.Method = "POST";
            Requests[100].Request.Path = "/$/Provision";
            Requests[101] = new DefaultHttpContext();
            Requests[101].RequestServices = CreateServices();
            Requests[101].Request.Method = "POST";
            Requests[101].Request.Path = "/$/RecoverAllPartitions";
            Requests[102] = new DefaultHttpContext();
            Requests[102].RequestServices = CreateServices();
            Requests[102].Request.Method = "POST";
            Requests[102].Request.Path = "/$/RecoverSystemPartitions";
            Requests[103] = new DefaultHttpContext();
            Requests[103].RequestServices = CreateServices();
            Requests[103].Request.Method = "POST";
            Requests[103].Request.Path = "/$/ReportClusterHealth";
            Requests[104] = new DefaultHttpContext();
            Requests[104].RequestServices = CreateServices();
            Requests[104].Request.Method = "POST";
            Requests[104].Request.Path = "/$/RollbackUpgrade";
            Requests[105] = new DefaultHttpContext();
            Requests[105].RequestServices = CreateServices();
            Requests[105].Request.Method = "POST";
            Requests[105].Request.Path = "/$/SetUpgradeOrchestrationServiceState";
            Requests[106] = new DefaultHttpContext();
            Requests[106].RequestServices = CreateServices();
            Requests[106].Request.Method = "POST";
            Requests[106].Request.Path = "/$/StartClusterConfigurationUpgrade";
            Requests[107] = new DefaultHttpContext();
            Requests[107].RequestServices = CreateServices();
            Requests[107].Request.Method = "POST";
            Requests[107].Request.Path = "/$/Unprovision";
            Requests[108] = new DefaultHttpContext();
            Requests[108].RequestServices = CreateServices();
            Requests[108].Request.Method = "POST";
            Requests[108].Request.Path = "/$/UpdateRepairExecutionState";
            Requests[109] = new DefaultHttpContext();
            Requests[109].RequestServices = CreateServices();
            Requests[109].Request.Method = "POST";
            Requests[109].Request.Path = "/$/UpdateRepairTaskHealthPolicy";
            Requests[110] = new DefaultHttpContext();
            Requests[110].RequestServices = CreateServices();
            Requests[110].Request.Method = "POST";
            Requests[110].Request.Path = "/$/UpdateUpgrade";
            Requests[111] = new DefaultHttpContext();
            Requests[111].RequestServices = CreateServices();
            Requests[111].Request.Method = "POST";
            Requests[111].Request.Path = "/$/Upgrade";
            Requests[112] = new DefaultHttpContext();
            Requests[112].RequestServices = CreateServices();
            Requests[112].Request.Method = "POST";
            Requests[112].Request.Path = "/api/events";
            Requests[113] = new DefaultHttpContext();
            Requests[113].RequestServices = CreateServices();
            Requests[113].Request.Method = "GET";
            Requests[113].Request.Path = "/apps/assistants";
            Requests[114] = new DefaultHttpContext();
            Requests[114].RequestServices = CreateServices();
            Requests[114].Request.Method = "GET";
            Requests[114].Request.Path = "/apps/cultures";
            Requests[115] = new DefaultHttpContext();
            Requests[115].RequestServices = CreateServices();
            Requests[115].Request.Method = "POST";
            Requests[115].Request.Path = "/apps/customprebuiltdomains";
            Requests[116] = new DefaultHttpContext();
            Requests[116].RequestServices = CreateServices();
            Requests[116].Request.Method = "GET";
            Requests[116].Request.Path = "/apps/customprebuiltdomains";
            Requests[117] = new DefaultHttpContext();
            Requests[117].RequestServices = CreateServices();
            Requests[117].Request.Method = "GET";
            Requests[117].Request.Path = "/apps/domains";
            Requests[118] = new DefaultHttpContext();
            Requests[118].RequestServices = CreateServices();
            Requests[118].Request.Method = "POST";
            Requests[118].Request.Path = "/apps/import";
            Requests[119] = new DefaultHttpContext();
            Requests[119].RequestServices = CreateServices();
            Requests[119].Request.Method = "GET";
            Requests[119].Request.Path = "/apps/usagescenarios";
            Requests[120] = new DefaultHttpContext();
            Requests[120].RequestServices = CreateServices();
            Requests[120].Request.Method = "GET";
            Requests[120].Request.Path = "/BackupRestore/BackupPolicies";
            Requests[121] = new DefaultHttpContext();
            Requests[121].RequestServices = CreateServices();
            Requests[121].Request.Method = "GET";
            Requests[121].Request.Path = "/certificates/contacts";
            Requests[122] = new DefaultHttpContext();
            Requests[122].RequestServices = CreateServices();
            Requests[122].Request.Method = "DELETE";
            Requests[122].Request.Path = "/certificates/contacts";
            Requests[123] = new DefaultHttpContext();
            Requests[123].RequestServices = CreateServices();
            Requests[123].Request.Method = "PUT";
            Requests[123].Request.Path = "/certificates/contacts";
            Requests[124] = new DefaultHttpContext();
            Requests[124].RequestServices = CreateServices();
            Requests[124].Request.Method = "GET";
            Requests[124].Request.Path = "/certificates/issuers";
            Requests[125] = new DefaultHttpContext();
            Requests[125].RequestServices = CreateServices();
            Requests[125].Request.Method = "GET";
            Requests[125].Request.Path = "/docs/$count";
            Requests[126] = new DefaultHttpContext();
            Requests[126].RequestServices = CreateServices();
            Requests[126].Request.Method = "POST";
            Requests[126].Request.Path = "/docs/autocomplete";
            Requests[127] = new DefaultHttpContext();
            Requests[127].RequestServices = CreateServices();
            Requests[127].Request.Method = "GET";
            Requests[127].Request.Path = "/docs/autocomplete";
            Requests[128] = new DefaultHttpContext();
            Requests[128].RequestServices = CreateServices();
            Requests[128].Request.Method = "GET";
            Requests[128].Request.Path = "/images/details";
            Requests[129] = new DefaultHttpContext();
            Requests[129].RequestServices = CreateServices();
            Requests[129].Request.Method = "GET";
            Requests[129].Request.Path = "/images/search";
            Requests[130] = new DefaultHttpContext();
            Requests[130].RequestServices = CreateServices();
            Requests[130].Request.Method = "GET";
            Requests[130].Request.Path = "/images/trending";
            Requests[131] = new DefaultHttpContext();
            Requests[131].RequestServices = CreateServices();
            Requests[131].Request.Method = "POST";
            Requests[131].Request.Path = "/images/visualsearch";
            Requests[132] = new DefaultHttpContext();
            Requests[132].RequestServices = CreateServices();
            Requests[132].Request.Method = "POST";
            Requests[132].Request.Path = "/keys/restore";
            Requests[133] = new DefaultHttpContext();
            Requests[133].RequestServices = CreateServices();
            Requests[133].Request.Method = "GET";
            Requests[133].Request.Path = "/news/search";
            Requests[134] = new DefaultHttpContext();
            Requests[134].RequestServices = CreateServices();
            Requests[134].Request.Method = "GET";
            Requests[134].Request.Path = "/news/trendingtopics";
            Requests[135] = new DefaultHttpContext();
            Requests[135].RequestServices = CreateServices();
            Requests[135].Request.Method = "PUT";
            Requests[135].Request.Path = "/portalsettings/delegation";
            Requests[136] = new DefaultHttpContext();
            Requests[136].RequestServices = CreateServices();
            Requests[136].Request.Method = "PATCH";
            Requests[136].Request.Path = "/portalsettings/delegation";
            Requests[137] = new DefaultHttpContext();
            Requests[137].RequestServices = CreateServices();
            Requests[137].Request.Method = "GET";
            Requests[137].Request.Path = "/portalsettings/delegation";
            Requests[138] = new DefaultHttpContext();
            Requests[138].RequestServices = CreateServices();
            Requests[138].Request.Method = "PUT";
            Requests[138].Request.Path = "/portalsettings/signin";
            Requests[139] = new DefaultHttpContext();
            Requests[139].RequestServices = CreateServices();
            Requests[139].Request.Method = "PATCH";
            Requests[139].Request.Path = "/portalsettings/signin";
            Requests[140] = new DefaultHttpContext();
            Requests[140].RequestServices = CreateServices();
            Requests[140].Request.Method = "GET";
            Requests[140].Request.Path = "/portalsettings/signin";
            Requests[141] = new DefaultHttpContext();
            Requests[141].RequestServices = CreateServices();
            Requests[141].Request.Method = "PATCH";
            Requests[141].Request.Path = "/portalsettings/signup";
            Requests[142] = new DefaultHttpContext();
            Requests[142].RequestServices = CreateServices();
            Requests[142].Request.Method = "GET";
            Requests[142].Request.Path = "/portalsettings/signup";
            Requests[143] = new DefaultHttpContext();
            Requests[143].RequestServices = CreateServices();
            Requests[143].Request.Method = "PUT";
            Requests[143].Request.Path = "/portalsettings/signup";
            Requests[144] = new DefaultHttpContext();
            Requests[144].RequestServices = CreateServices();
            Requests[144].Request.Method = "GET";
            Requests[144].Request.Path = "/reports/byApi";
            Requests[145] = new DefaultHttpContext();
            Requests[145].RequestServices = CreateServices();
            Requests[145].Request.Method = "GET";
            Requests[145].Request.Path = "/reports/byGeo";
            Requests[146] = new DefaultHttpContext();
            Requests[146].RequestServices = CreateServices();
            Requests[146].Request.Method = "GET";
            Requests[146].Request.Path = "/reports/byOperation";
            Requests[147] = new DefaultHttpContext();
            Requests[147].RequestServices = CreateServices();
            Requests[147].Request.Method = "GET";
            Requests[147].Request.Path = "/reports/byProduct";
            Requests[148] = new DefaultHttpContext();
            Requests[148].RequestServices = CreateServices();
            Requests[148].Request.Method = "GET";
            Requests[148].Request.Path = "/reports/byRequest";
            Requests[149] = new DefaultHttpContext();
            Requests[149].RequestServices = CreateServices();
            Requests[149].Request.Method = "GET";
            Requests[149].Request.Path = "/reports/bySubscription";
            Requests[150] = new DefaultHttpContext();
            Requests[150].RequestServices = CreateServices();
            Requests[150].Request.Method = "GET";
            Requests[150].Request.Path = "/reports/byTime";
            Requests[151] = new DefaultHttpContext();
            Requests[151].RequestServices = CreateServices();
            Requests[151].Request.Method = "GET";
            Requests[151].Request.Path = "/reports/byUser";
            Requests[152] = new DefaultHttpContext();
            Requests[152].RequestServices = CreateServices();
            Requests[152].Request.Method = "POST";
            Requests[152].Request.Path = "/secrets/restore";
            Requests[153] = new DefaultHttpContext();
            Requests[153].RequestServices = CreateServices();
            Requests[153].Request.Method = "POST";
            Requests[153].Request.Path = "/storage/restore";
            Requests[154] = new DefaultHttpContext();
            Requests[154].RequestServices = CreateServices();
            Requests[154].Request.Method = "GET";
            Requests[154].Request.Path = "/Tools/Chaos";
            Requests[155] = new DefaultHttpContext();
            Requests[155].RequestServices = CreateServices();
            Requests[155].Request.Method = "POST";
            Requests[155].Request.Path = "/v2.0/entities";
            Requests[156] = new DefaultHttpContext();
            Requests[156].RequestServices = CreateServices();
            Requests[156].Request.Method = "POST";
            Requests[156].Request.Path = "/v2.0/keyPhrases";
            Requests[157] = new DefaultHttpContext();
            Requests[157].RequestServices = CreateServices();
            Requests[157].Request.Method = "POST";
            Requests[157].Request.Path = "/v2.0/languages";
            Requests[158] = new DefaultHttpContext();
            Requests[158].RequestServices = CreateServices();
            Requests[158].Request.Method = "POST";
            Requests[158].Request.Path = "/v2.0/sentiment";
            Requests[159] = new DefaultHttpContext();
            Requests[159].RequestServices = CreateServices();
            Requests[159].Request.Method = "GET";
            Requests[159].Request.Path = "/videos/details";
            Requests[160] = new DefaultHttpContext();
            Requests[160].RequestServices = CreateServices();
            Requests[160].Request.Method = "GET";
            Requests[160].Request.Path = "/videos/search";
            Requests[161] = new DefaultHttpContext();
            Requests[161].RequestServices = CreateServices();
            Requests[161].Request.Method = "GET";
            Requests[161].Request.Path = "/videos/trending";
            Requests[162] = new DefaultHttpContext();
            Requests[162].RequestServices = CreateServices();
            Requests[162].Request.Method = "POST";
            Requests[162].Request.Path = "/Applications/$/Create";
            Requests[163] = new DefaultHttpContext();
            Requests[163].RequestServices = CreateServices();
            Requests[163].Request.Method = "POST";
            Requests[163].Request.Path = "/ApplicationTypes/$/Provision";
            Requests[164] = new DefaultHttpContext();
            Requests[164].RequestServices = CreateServices();
            Requests[164].Request.Method = "POST";
            Requests[164].Request.Path = "/BackupRestore/$/GetBackups";
            Requests[165] = new DefaultHttpContext();
            Requests[165].RequestServices = CreateServices();
            Requests[165].Request.Method = "GET";
            Requests[165].Request.Path = "/catalog/usql/acl";
            Requests[166] = new DefaultHttpContext();
            Requests[166].RequestServices = CreateServices();
            Requests[166].Request.Method = "GET";
            Requests[166].Request.Path = "/catalog/usql/databases";
            Requests[167] = new DefaultHttpContext();
            Requests[167].RequestServices = CreateServices();
            Requests[167].Request.Method = "PUT";
            Requests[167].Request.Path = "/ComposeDeployments/$/Create";
            Requests[168] = new DefaultHttpContext();
            Requests[168].RequestServices = CreateServices();
            Requests[168].Request.Method = "GET";
            Requests[168].Request.Path = "/EventsStore/Applications/Events";
            Requests[169] = new DefaultHttpContext();
            Requests[169].RequestServices = CreateServices();
            Requests[169].Request.Method = "GET";
            Requests[169].Request.Path = "/EventsStore/Cluster/Events";
            Requests[170] = new DefaultHttpContext();
            Requests[170].RequestServices = CreateServices();
            Requests[170].Request.Method = "GET";
            Requests[170].Request.Path = "/EventsStore/Containers/Events";
            Requests[171] = new DefaultHttpContext();
            Requests[171].RequestServices = CreateServices();
            Requests[171].Request.Method = "GET";
            Requests[171].Request.Path = "/EventsStore/Nodes/Events";
            Requests[172] = new DefaultHttpContext();
            Requests[172].RequestServices = CreateServices();
            Requests[172].Request.Method = "GET";
            Requests[172].Request.Path = "/EventsStore/Partitions/Events";
            Requests[173] = new DefaultHttpContext();
            Requests[173].RequestServices = CreateServices();
            Requests[173].Request.Method = "GET";
            Requests[173].Request.Path = "/EventsStore/Services/Events";
            Requests[174] = new DefaultHttpContext();
            Requests[174].RequestServices = CreateServices();
            Requests[174].Request.Method = "POST";
            Requests[174].Request.Path = "/Faults/$/Cancel";
            Requests[175] = new DefaultHttpContext();
            Requests[175].RequestServices = CreateServices();
            Requests[175].Request.Method = "POST";
            Requests[175].Request.Path = "/ImageStore/$/CommitUploadSession";
            Requests[176] = new DefaultHttpContext();
            Requests[176].RequestServices = CreateServices();
            Requests[176].Request.Method = "POST";
            Requests[176].Request.Path = "/ImageStore/$/Copy";
            Requests[177] = new DefaultHttpContext();
            Requests[177].RequestServices = CreateServices();
            Requests[177].Request.Method = "DELETE";
            Requests[177].Request.Path = "/ImageStore/$/DeleteUploadSession";
            Requests[178] = new DefaultHttpContext();
            Requests[178].RequestServices = CreateServices();
            Requests[178].Request.Method = "GET";
            Requests[178].Request.Path = "/ImageStore/$/GetUploadSession";
            Requests[179] = new DefaultHttpContext();
            Requests[179].RequestServices = CreateServices();
            Requests[179].Request.Method = "POST";
            Requests[179].Request.Path = "/Names/$/Create";
            Requests[180] = new DefaultHttpContext();
            Requests[180].RequestServices = CreateServices();
            Requests[180].Request.Method = "GET";
            Requests[180].Request.Path = "/providers/Microsoft.AAD/operations";
            Requests[181] = new DefaultHttpContext();
            Requests[181].RequestServices = CreateServices();
            Requests[181].Request.Method = "GET";
            Requests[181].Request.Path = "/providers/Microsoft.Addons/operations";
            Requests[182] = new DefaultHttpContext();
            Requests[182].RequestServices = CreateServices();
            Requests[182].Request.Method = "POST";
            Requests[182].Request.Path = "/providers/Microsoft.ADHybridHealthService/addsservices";
            Requests[183] = new DefaultHttpContext();
            Requests[183].RequestServices = CreateServices();
            Requests[183].Request.Method = "GET";
            Requests[183].Request.Path = "/providers/Microsoft.ADHybridHealthService/addsservices";
            Requests[184] = new DefaultHttpContext();
            Requests[184].RequestServices = CreateServices();
            Requests[184].Request.Method = "PATCH";
            Requests[184].Request.Path = "/providers/Microsoft.ADHybridHealthService/configuration";
            Requests[185] = new DefaultHttpContext();
            Requests[185].RequestServices = CreateServices();
            Requests[185].Request.Method = "GET";
            Requests[185].Request.Path = "/providers/Microsoft.ADHybridHealthService/configuration";
            Requests[186] = new DefaultHttpContext();
            Requests[186].RequestServices = CreateServices();
            Requests[186].Request.Method = "POST";
            Requests[186].Request.Path = "/providers/Microsoft.ADHybridHealthService/configuration";
            Requests[187] = new DefaultHttpContext();
            Requests[187].RequestServices = CreateServices();
            Requests[187].Request.Method = "GET";
            Requests[187].Request.Path = "/providers/Microsoft.ADHybridHealthService/operations";
            Requests[188] = new DefaultHttpContext();
            Requests[188].RequestServices = CreateServices();
            Requests[188].Request.Method = "POST";
            Requests[188].Request.Path = "/providers/Microsoft.ADHybridHealthService/services";
            Requests[189] = new DefaultHttpContext();
            Requests[189].RequestServices = CreateServices();
            Requests[189].Request.Method = "GET";
            Requests[189].Request.Path = "/providers/Microsoft.ADHybridHealthService/services";
            Requests[190] = new DefaultHttpContext();
            Requests[190].RequestServices = CreateServices();
            Requests[190].Request.Method = "GET";
            Requests[190].Request.Path = "/providers/Microsoft.Advisor/operations";
            Requests[191] = new DefaultHttpContext();
            Requests[191].RequestServices = CreateServices();
            Requests[191].Request.Method = "GET";
            Requests[191].Request.Path = "/providers/Microsoft.AnalysisServices/operations";
            Requests[192] = new DefaultHttpContext();
            Requests[192].RequestServices = CreateServices();
            Requests[192].Request.Method = "GET";
            Requests[192].Request.Path = "/providers/Microsoft.ApiManagement/operations";
            Requests[193] = new DefaultHttpContext();
            Requests[193].RequestServices = CreateServices();
            Requests[193].Request.Method = "GET";
            Requests[193].Request.Path = "/providers/Microsoft.Authorization/policyDefinitions";
            Requests[194] = new DefaultHttpContext();
            Requests[194].RequestServices = CreateServices();
            Requests[194].Request.Method = "GET";
            Requests[194].Request.Path = "/providers/Microsoft.Authorization/policySetDefinitions";
            Requests[195] = new DefaultHttpContext();
            Requests[195].RequestServices = CreateServices();
            Requests[195].Request.Method = "GET";
            Requests[195].Request.Path = "/providers/Microsoft.Authorization/providerOperations";
            Requests[196] = new DefaultHttpContext();
            Requests[196].RequestServices = CreateServices();
            Requests[196].Request.Method = "GET";
            Requests[196].Request.Path = "/providers/Microsoft.Automation/operations";
            Requests[197] = new DefaultHttpContext();
            Requests[197].RequestServices = CreateServices();
            Requests[197].Request.Method = "GET";
            Requests[197].Request.Path = "/providers/Microsoft.AzureStack/operations";
            Requests[198] = new DefaultHttpContext();
            Requests[198].RequestServices = CreateServices();
            Requests[198].Request.Method = "GET";
            Requests[198].Request.Path = "/providers/Microsoft.Backup.Admin/operations";
            Requests[199] = new DefaultHttpContext();
            Requests[199].RequestServices = CreateServices();
            Requests[199].Request.Method = "GET";
            Requests[199].Request.Path = "/providers/Microsoft.Batch/operations";
            Requests[200] = new DefaultHttpContext();
            Requests[200].RequestServices = CreateServices();
            Requests[200].Request.Method = "GET";
            Requests[200].Request.Path = "/providers/Microsoft.BatchAI/operations";
            Requests[201] = new DefaultHttpContext();
            Requests[201].RequestServices = CreateServices();
            Requests[201].Request.Method = "GET";
            Requests[201].Request.Path = "/providers/Microsoft.Billing/enrollmentAccounts";
            Requests[202] = new DefaultHttpContext();
            Requests[202].RequestServices = CreateServices();
            Requests[202].Request.Method = "GET";
            Requests[202].Request.Path = "/providers/Microsoft.Billing/operations";
            Requests[203] = new DefaultHttpContext();
            Requests[203].RequestServices = CreateServices();
            Requests[203].Request.Method = "GET";
            Requests[203].Request.Path = "/providers/Microsoft.BotService/operations";
            Requests[204] = new DefaultHttpContext();
            Requests[204].RequestServices = CreateServices();
            Requests[204].Request.Method = "GET";
            Requests[204].Request.Path = "/providers/Microsoft.Cache/operations";
            Requests[205] = new DefaultHttpContext();
            Requests[205].RequestServices = CreateServices();
            Requests[205].Request.Method = "GET";
            Requests[205].Request.Path = "/providers/Microsoft.Capacity/operations";
            Requests[206] = new DefaultHttpContext();
            Requests[206].RequestServices = CreateServices();
            Requests[206].Request.Method = "GET";
            Requests[206].Request.Path = "/providers/Microsoft.Capacity/reservationOrders";
            Requests[207] = new DefaultHttpContext();
            Requests[207].RequestServices = CreateServices();
            Requests[207].Request.Method = "POST";
            Requests[207].Request.Path = "/providers/Microsoft.Cdn/checkNameAvailability";
            Requests[208] = new DefaultHttpContext();
            Requests[208].RequestServices = CreateServices();
            Requests[208].Request.Method = "GET";
            Requests[208].Request.Path = "/providers/Microsoft.Cdn/edgenodes";
            Requests[209] = new DefaultHttpContext();
            Requests[209].RequestServices = CreateServices();
            Requests[209].Request.Method = "GET";
            Requests[209].Request.Path = "/providers/Microsoft.Cdn/operations";
            Requests[210] = new DefaultHttpContext();
            Requests[210].RequestServices = CreateServices();
            Requests[210].Request.Method = "GET";
            Requests[210].Request.Path = "/providers/Microsoft.CertificateRegistration/operations";
            Requests[211] = new DefaultHttpContext();
            Requests[211].RequestServices = CreateServices();
            Requests[211].Request.Method = "GET";
            Requests[211].Request.Path = "/providers/Microsoft.CognitiveServices/operations";
            Requests[212] = new DefaultHttpContext();
            Requests[212].RequestServices = CreateServices();
            Requests[212].Request.Method = "GET";
            Requests[212].Request.Path = "/providers/Microsoft.Commerce.Admin/operations";
            Requests[213] = new DefaultHttpContext();
            Requests[213].RequestServices = CreateServices();
            Requests[213].Request.Method = "GET";
            Requests[213].Request.Path = "/providers/Microsoft.Compute.Admin/operations";
            Requests[214] = new DefaultHttpContext();
            Requests[214].RequestServices = CreateServices();
            Requests[214].Request.Method = "GET";
            Requests[214].Request.Path = "/providers/Microsoft.Compute/operations";
            Requests[215] = new DefaultHttpContext();
            Requests[215].RequestServices = CreateServices();
            Requests[215].Request.Method = "GET";
            Requests[215].Request.Path = "/providers/Microsoft.Consumption/operations";
            Requests[216] = new DefaultHttpContext();
            Requests[216].RequestServices = CreateServices();
            Requests[216].Request.Method = "GET";
            Requests[216].Request.Path = "/providers/Microsoft.ContainerInstance/operations";
            Requests[217] = new DefaultHttpContext();
            Requests[217].RequestServices = CreateServices();
            Requests[217].Request.Method = "GET";
            Requests[217].Request.Path = "/providers/Microsoft.ContainerRegistry/operations";
            Requests[218] = new DefaultHttpContext();
            Requests[218].RequestServices = CreateServices();
            Requests[218].Request.Method = "GET";
            Requests[218].Request.Path = "/providers/Microsoft.ContainerService/operations";
            Requests[219] = new DefaultHttpContext();
            Requests[219].RequestServices = CreateServices();
            Requests[219].Request.Method = "GET";
            Requests[219].Request.Path = "/providers/Microsoft.CustomerInsights/operations";
            Requests[220] = new DefaultHttpContext();
            Requests[220].RequestServices = CreateServices();
            Requests[220].Request.Method = "GET";
            Requests[220].Request.Path = "/providers/Microsoft.DataBox/operations";
            Requests[221] = new DefaultHttpContext();
            Requests[221].RequestServices = CreateServices();
            Requests[221].Request.Method = "GET";
            Requests[221].Request.Path = "/providers/Microsoft.Databricks/operations";
            Requests[222] = new DefaultHttpContext();
            Requests[222].RequestServices = CreateServices();
            Requests[222].Request.Method = "GET";
            Requests[222].Request.Path = "/providers/Microsoft.DataCatalog/operations";
            Requests[223] = new DefaultHttpContext();
            Requests[223].RequestServices = CreateServices();
            Requests[223].Request.Method = "GET";
            Requests[223].Request.Path = "/providers/Microsoft.DataFactory/operations";
            Requests[224] = new DefaultHttpContext();
            Requests[224].RequestServices = CreateServices();
            Requests[224].Request.Method = "GET";
            Requests[224].Request.Path = "/providers/Microsoft.DataLakeAnalytics/operations";
            Requests[225] = new DefaultHttpContext();
            Requests[225].RequestServices = CreateServices();
            Requests[225].Request.Method = "GET";
            Requests[225].Request.Path = "/providers/Microsoft.DataLakeStore/operations";
            Requests[226] = new DefaultHttpContext();
            Requests[226].RequestServices = CreateServices();
            Requests[226].Request.Method = "GET";
            Requests[226].Request.Path = "/providers/Microsoft.DataMigration/operations";
            Requests[227] = new DefaultHttpContext();
            Requests[227].RequestServices = CreateServices();
            Requests[227].Request.Method = "GET";
            Requests[227].Request.Path = "/providers/Microsoft.DBforMySQL/operations";
            Requests[228] = new DefaultHttpContext();
            Requests[228].RequestServices = CreateServices();
            Requests[228].Request.Method = "GET";
            Requests[228].Request.Path = "/providers/Microsoft.DBforPostgreSQL/operations";
            Requests[229] = new DefaultHttpContext();
            Requests[229].RequestServices = CreateServices();
            Requests[229].Request.Method = "GET";
            Requests[229].Request.Path = "/providers/Microsoft.Devices/operations";
            Requests[230] = new DefaultHttpContext();
            Requests[230].RequestServices = CreateServices();
            Requests[230].Request.Method = "GET";
            Requests[230].Request.Path = "/providers/Microsoft.DevTestLab/operations";
            Requests[231] = new DefaultHttpContext();
            Requests[231].RequestServices = CreateServices();
            Requests[231].Request.Method = "GET";
            Requests[231].Request.Path = "/providers/Microsoft.DocumentDB/operations";
            Requests[232] = new DefaultHttpContext();
            Requests[232].RequestServices = CreateServices();
            Requests[232].Request.Method = "GET";
            Requests[232].Request.Path = "/providers/Microsoft.DomainRegistration/operations";
            Requests[233] = new DefaultHttpContext();
            Requests[233].RequestServices = CreateServices();
            Requests[233].Request.Method = "GET";
            Requests[233].Request.Path = "/providers/Microsoft.EventGrid/operations";
            Requests[234] = new DefaultHttpContext();
            Requests[234].RequestServices = CreateServices();
            Requests[234].Request.Method = "GET";
            Requests[234].Request.Path = "/providers/Microsoft.EventGrid/topicTypes";
            Requests[235] = new DefaultHttpContext();
            Requests[235].RequestServices = CreateServices();
            Requests[235].Request.Method = "GET";
            Requests[235].Request.Path = "/providers/Microsoft.EventHub/operations";
            Requests[236] = new DefaultHttpContext();
            Requests[236].RequestServices = CreateServices();
            Requests[236].Request.Method = "GET";
            Requests[236].Request.Path = "/providers/Microsoft.Fabric.Admin/operations";
            Requests[237] = new DefaultHttpContext();
            Requests[237].RequestServices = CreateServices();
            Requests[237].Request.Method = "GET";
            Requests[237].Request.Path = "/providers/Microsoft.Gallery.Admin/operations";
            Requests[238] = new DefaultHttpContext();
            Requests[238].RequestServices = CreateServices();
            Requests[238].Request.Method = "GET";
            Requests[238].Request.Path = "/providers/Microsoft.HanaOnAzure/operations";
            Requests[239] = new DefaultHttpContext();
            Requests[239].RequestServices = CreateServices();
            Requests[239].Request.Method = "GET";
            Requests[239].Request.Path = "/providers/Microsoft.HDInsight/operations";
            Requests[240] = new DefaultHttpContext();
            Requests[240].RequestServices = CreateServices();
            Requests[240].Request.Method = "GET";
            Requests[240].Request.Path = "/providers/Microsoft.ImportExport/locations";
            Requests[241] = new DefaultHttpContext();
            Requests[241].RequestServices = CreateServices();
            Requests[241].Request.Method = "GET";
            Requests[241].Request.Path = "/providers/Microsoft.ImportExport/operations";
            Requests[242] = new DefaultHttpContext();
            Requests[242].RequestServices = CreateServices();
            Requests[242].Request.Method = "GET";
            Requests[242].Request.Path = "/providers/Microsoft.InfrastructureInsights.Admin/operations";
            Requests[243] = new DefaultHttpContext();
            Requests[243].RequestServices = CreateServices();
            Requests[243].Request.Method = "GET";
            Requests[243].Request.Path = "/providers/microsoft.insights/eventcategories";
            Requests[244] = new DefaultHttpContext();
            Requests[244].RequestServices = CreateServices();
            Requests[244].Request.Method = "GET";
            Requests[244].Request.Path = "/providers/microsoft.insights/operations";
            Requests[245] = new DefaultHttpContext();
            Requests[245].RequestServices = CreateServices();
            Requests[245].Request.Method = "GET";
            Requests[245].Request.Path = "/providers/Microsoft.Intune/locations";
            Requests[246] = new DefaultHttpContext();
            Requests[246].RequestServices = CreateServices();
            Requests[246].Request.Method = "GET";
            Requests[246].Request.Path = "/providers/Microsoft.IoTCentral/operations";
            Requests[247] = new DefaultHttpContext();
            Requests[247].RequestServices = CreateServices();
            Requests[247].Request.Method = "GET";
            Requests[247].Request.Path = "/providers/Microsoft.IoTSpaces/operations";
            Requests[248] = new DefaultHttpContext();
            Requests[248].RequestServices = CreateServices();
            Requests[248].Request.Method = "GET";
            Requests[248].Request.Path = "/providers/Microsoft.KeyVault.Admin/operations";
            Requests[249] = new DefaultHttpContext();
            Requests[249].RequestServices = CreateServices();
            Requests[249].Request.Method = "GET";
            Requests[249].Request.Path = "/providers/Microsoft.KeyVault/operations";
            Requests[250] = new DefaultHttpContext();
            Requests[250].RequestServices = CreateServices();
            Requests[250].Request.Method = "GET";
            Requests[250].Request.Path = "/providers/Microsoft.Logic/operations";
            Requests[251] = new DefaultHttpContext();
            Requests[251].RequestServices = CreateServices();
            Requests[251].Request.Method = "GET";
            Requests[251].Request.Path = "/providers/Microsoft.MachineLearning/operations";
            Requests[252] = new DefaultHttpContext();
            Requests[252].RequestServices = CreateServices();
            Requests[252].Request.Method = "GET";
            Requests[252].Request.Path = "/providers/Microsoft.MachineLearningCompute/operations";
            Requests[253] = new DefaultHttpContext();
            Requests[253].RequestServices = CreateServices();
            Requests[253].Request.Method = "GET";
            Requests[253].Request.Path = "/providers/Microsoft.MachineLearningExperimentation/operations";
            Requests[254] = new DefaultHttpContext();
            Requests[254].RequestServices = CreateServices();
            Requests[254].Request.Method = "GET";
            Requests[254].Request.Path = "/providers/Microsoft.MachineLearningServices/operations";
            Requests[255] = new DefaultHttpContext();
            Requests[255].RequestServices = CreateServices();
            Requests[255].Request.Method = "GET";
            Requests[255].Request.Path = "/providers/Microsoft.ManagedIdentity/operations";
            Requests[256] = new DefaultHttpContext();
            Requests[256].RequestServices = CreateServices();
            Requests[256].Request.Method = "POST";
            Requests[256].Request.Path = "/providers/Microsoft.Management/checkNameAvailability";
            Requests[257] = new DefaultHttpContext();
            Requests[257].RequestServices = CreateServices();
            Requests[257].Request.Method = "POST";
            Requests[257].Request.Path = "/providers/Microsoft.Management/getEntities";
            Requests[258] = new DefaultHttpContext();
            Requests[258].RequestServices = CreateServices();
            Requests[258].Request.Method = "GET";
            Requests[258].Request.Path = "/providers/Microsoft.Management/managementGroups";
            Requests[259] = new DefaultHttpContext();
            Requests[259].RequestServices = CreateServices();
            Requests[259].Request.Method = "GET";
            Requests[259].Request.Path = "/providers/Microsoft.Management/operations";
            Requests[260] = new DefaultHttpContext();
            Requests[260].RequestServices = CreateServices();
            Requests[260].Request.Method = "POST";
            Requests[260].Request.Path = "/providers/Microsoft.Management/startTenantBackfill";
            Requests[261] = new DefaultHttpContext();
            Requests[261].RequestServices = CreateServices();
            Requests[261].Request.Method = "POST";
            Requests[261].Request.Path = "/providers/Microsoft.Management/tenantBackfillStatus";
            Requests[262] = new DefaultHttpContext();
            Requests[262].RequestServices = CreateServices();
            Requests[262].Request.Method = "GET";
            Requests[262].Request.Path = "/providers/Microsoft.ManagementPartner/operations";
            Requests[263] = new DefaultHttpContext();
            Requests[263].RequestServices = CreateServices();
            Requests[263].Request.Method = "GET";
            Requests[263].Request.Path = "/providers/Microsoft.Maps/operations";
            Requests[264] = new DefaultHttpContext();
            Requests[264].RequestServices = CreateServices();
            Requests[264].Request.Method = "GET";
            Requests[264].Request.Path = "/providers/Microsoft.MarketplaceOrdering/operations";
            Requests[265] = new DefaultHttpContext();
            Requests[265].RequestServices = CreateServices();
            Requests[265].Request.Method = "GET";
            Requests[265].Request.Path = "/providers/Microsoft.Media/operations";
            Requests[266] = new DefaultHttpContext();
            Requests[266].RequestServices = CreateServices();
            Requests[266].Request.Method = "GET";
            Requests[266].Request.Path = "/providers/Microsoft.Migrate/operations";
            Requests[267] = new DefaultHttpContext();
            Requests[267].RequestServices = CreateServices();
            Requests[267].Request.Method = "POST";
            Requests[267].Request.Path = "/providers/Microsoft.Network/checkTrafficManagerNameAvailability";
            Requests[268] = new DefaultHttpContext();
            Requests[268].RequestServices = CreateServices();
            Requests[268].Request.Method = "GET";
            Requests[268].Request.Path = "/providers/Microsoft.Network/operations";
            Requests[269] = new DefaultHttpContext();
            Requests[269].RequestServices = CreateServices();
            Requests[269].Request.Method = "GET";
            Requests[269].Request.Path = "/providers/Microsoft.NotificationHubs/operations";
            Requests[270] = new DefaultHttpContext();
            Requests[270].RequestServices = CreateServices();
            Requests[270].Request.Method = "GET";
            Requests[270].Request.Path = "/providers/Microsoft.OperationalInsights/operations";
            Requests[271] = new DefaultHttpContext();
            Requests[271].RequestServices = CreateServices();
            Requests[271].Request.Method = "GET";
            Requests[271].Request.Path = "/providers/Microsoft.OperationsManagement/operations";
            Requests[272] = new DefaultHttpContext();
            Requests[272].RequestServices = CreateServices();
            Requests[272].Request.Method = "GET";
            Requests[272].Request.Path = "/providers/Microsoft.PolicyInsights/operations";
            Requests[273] = new DefaultHttpContext();
            Requests[273].RequestServices = CreateServices();
            Requests[273].Request.Method = "GET";
            Requests[273].Request.Path = "/providers/Microsoft.PowerBI/operations";
            Requests[274] = new DefaultHttpContext();
            Requests[274].RequestServices = CreateServices();
            Requests[274].Request.Method = "GET";
            Requests[274].Request.Path = "/providers/Microsoft.PowerBIDedicated/operations";
            Requests[275] = new DefaultHttpContext();
            Requests[275].RequestServices = CreateServices();
            Requests[275].Request.Method = "GET";
            Requests[275].Request.Path = "/providers/Microsoft.RecoveryServices/operations";
            Requests[276] = new DefaultHttpContext();
            Requests[276].RequestServices = CreateServices();
            Requests[276].Request.Method = "GET";
            Requests[276].Request.Path = "/providers/Microsoft.Relay/operations";
            Requests[277] = new DefaultHttpContext();
            Requests[277].RequestServices = CreateServices();
            Requests[277].Request.Method = "GET";
            Requests[277].Request.Path = "/providers/Microsoft.ResourceHealth/operations";
            Requests[278] = new DefaultHttpContext();
            Requests[278].RequestServices = CreateServices();
            Requests[278].Request.Method = "GET";
            Requests[278].Request.Path = "/providers/Microsoft.Search/operations";
            Requests[279] = new DefaultHttpContext();
            Requests[279].RequestServices = CreateServices();
            Requests[279].Request.Method = "GET";
            Requests[279].Request.Path = "/providers/Microsoft.Security/operations";
            Requests[280] = new DefaultHttpContext();
            Requests[280].RequestServices = CreateServices();
            Requests[280].Request.Method = "GET";
            Requests[280].Request.Path = "/providers/Microsoft.ServiceBus/operations";
            Requests[281] = new DefaultHttpContext();
            Requests[281].RequestServices = CreateServices();
            Requests[281].Request.Method = "GET";
            Requests[281].Request.Path = "/providers/Microsoft.ServiceFabric/operations";
            Requests[282] = new DefaultHttpContext();
            Requests[282].RequestServices = CreateServices();
            Requests[282].Request.Method = "GET";
            Requests[282].Request.Path = "/providers/Microsoft.SignalRService/operations";
            Requests[283] = new DefaultHttpContext();
            Requests[283].RequestServices = CreateServices();
            Requests[283].Request.Method = "GET";
            Requests[283].Request.Path = "/providers/Microsoft.Sql/operations";
            Requests[284] = new DefaultHttpContext();
            Requests[284].RequestServices = CreateServices();
            Requests[284].Request.Method = "GET";
            Requests[284].Request.Path = "/providers/Microsoft.Storage.Admin/operations";
            Requests[285] = new DefaultHttpContext();
            Requests[285].RequestServices = CreateServices();
            Requests[285].Request.Method = "GET";
            Requests[285].Request.Path = "/providers/Microsoft.Storage/operations";
            Requests[286] = new DefaultHttpContext();
            Requests[286].RequestServices = CreateServices();
            Requests[286].Request.Method = "GET";
            Requests[286].Request.Path = "/providers/Microsoft.StorSimple/operations";
            Requests[287] = new DefaultHttpContext();
            Requests[287].RequestServices = CreateServices();
            Requests[287].Request.Method = "GET";
            Requests[287].Request.Path = "/providers/Microsoft.StreamAnalytics/operations";
            Requests[288] = new DefaultHttpContext();
            Requests[288].RequestServices = CreateServices();
            Requests[288].Request.Method = "GET";
            Requests[288].Request.Path = "/providers/Microsoft.Subscription/operations";
            Requests[289] = new DefaultHttpContext();
            Requests[289].RequestServices = CreateServices();
            Requests[289].Request.Method = "GET";
            Requests[289].Request.Path = "/providers/Microsoft.Subscription/subscriptionDefinitions";
            Requests[290] = new DefaultHttpContext();
            Requests[290].RequestServices = CreateServices();
            Requests[290].Request.Method = "GET";
            Requests[290].Request.Path = "/providers/Microsoft.Subscription/subscriptionOperations";
            Requests[291] = new DefaultHttpContext();
            Requests[291].RequestServices = CreateServices();
            Requests[291].Request.Method = "GET";
            Requests[291].Request.Path = "/providers/Microsoft.Subscriptions.Admin/operations";
            Requests[292] = new DefaultHttpContext();
            Requests[292].RequestServices = CreateServices();
            Requests[292].Request.Method = "GET";
            Requests[292].Request.Path = "/providers/Microsoft.Subscriptions/operations";
            Requests[293] = new DefaultHttpContext();
            Requests[293].RequestServices = CreateServices();
            Requests[293].Request.Method = "GET";
            Requests[293].Request.Path = "/providers/Microsoft.TimeSeriesInsights/operations";
            Requests[294] = new DefaultHttpContext();
            Requests[294].RequestServices = CreateServices();
            Requests[294].Request.Method = "GET";
            Requests[294].Request.Path = "/providers/Microsoft.Update.Admin/operations";
            Requests[295] = new DefaultHttpContext();
            Requests[295].RequestServices = CreateServices();
            Requests[295].Request.Method = "GET";
            Requests[295].Request.Path = "/providers/microsoft.visualstudio/operations";
            Requests[296] = new DefaultHttpContext();
            Requests[296].RequestServices = CreateServices();
            Requests[296].Request.Method = "GET";
            Requests[296].Request.Path = "/providers/Microsoft.Web/availableStacks";
            Requests[297] = new DefaultHttpContext();
            Requests[297].RequestServices = CreateServices();
            Requests[297].Request.Method = "GET";
            Requests[297].Request.Path = "/providers/Microsoft.Web/operations";
            Requests[298] = new DefaultHttpContext();
            Requests[298].RequestServices = CreateServices();
            Requests[298].Request.Method = "GET";
            Requests[298].Request.Path = "/providers/Microsoft.Web/sourcecontrols";
            Requests[299] = new DefaultHttpContext();
            Requests[299].RequestServices = CreateServices();
            Requests[299].Request.Method = "GET";
            Requests[299].Request.Path = "/Tools/Chaos/Events";
            Requests[300] = new DefaultHttpContext();
            Requests[300].RequestServices = CreateServices();
            Requests[300].Request.Method = "GET";
            Requests[300].Request.Path = "/Tools/Chaos/Schedule";
            Requests[301] = new DefaultHttpContext();
            Requests[301].RequestServices = CreateServices();
            Requests[301].Request.Method = "POST";
            Requests[301].Request.Path = "/Tools/Chaos/Schedule";
            Requests[302] = new DefaultHttpContext();
            Requests[302].RequestServices = CreateServices();
            Requests[302].Request.Method = "POST";
            Requests[302].Request.Path = "/BackupRestore/BackupPolicies/$/Create";
            Requests[303] = new DefaultHttpContext();
            Requests[303].RequestServices = CreateServices();
            Requests[303].Request.Method = "POST";
            Requests[303].Request.Path = "/contentmoderator/lists/v1.0/imagelists";
            Requests[304] = new DefaultHttpContext();
            Requests[304].RequestServices = CreateServices();
            Requests[304].Request.Method = "GET";
            Requests[304].Request.Path = "/contentmoderator/lists/v1.0/imagelists";
            Requests[305] = new DefaultHttpContext();
            Requests[305].RequestServices = CreateServices();
            Requests[305].Request.Method = "GET";
            Requests[305].Request.Path = "/contentmoderator/lists/v1.0/termlists";
            Requests[306] = new DefaultHttpContext();
            Requests[306].RequestServices = CreateServices();
            Requests[306].Request.Method = "POST";
            Requests[306].Request.Path = "/contentmoderator/lists/v1.0/termlists";
            Requests[307] = new DefaultHttpContext();
            Requests[307].RequestServices = CreateServices();
            Requests[307].Request.Method = "GET";
            Requests[307].Request.Path = "/providers/Microsoft.ADHybridHealthService/addsservices/premiumCheck";
            Requests[308] = new DefaultHttpContext();
            Requests[308].RequestServices = CreateServices();
            Requests[308].Request.Method = "GET";
            Requests[308].Request.Path = "/providers/Microsoft.ADHybridHealthService/services/premiumCheck";
            Requests[309] = new DefaultHttpContext();
            Requests[309].RequestServices = CreateServices();
            Requests[309].Request.Method = "GET";
            Requests[309].Request.Path = "/providers/Microsoft.BotService/botServices/checkNameAvailability";
            Requests[310] = new DefaultHttpContext();
            Requests[310].RequestServices = CreateServices();
            Requests[310].Request.Method = "GET";
            Requests[310].Request.Path = "/providers/Microsoft.Intune/locations/hostName";
            Requests[311] = new DefaultHttpContext();
            Requests[311].RequestServices = CreateServices();
            Requests[311].Request.Method = "GET";
            Requests[311].Request.Path = "/providers/Microsoft.Network/trafficManagerGeographicHierarchies/default";
            Requests[312] = new DefaultHttpContext();
            Requests[312].RequestServices = CreateServices();
            Requests[312].Request.Method = "PUT";
            Requests[312].Request.Path = "/providers/Microsoft.Web/publishingUsers/web";
            Requests[313] = new DefaultHttpContext();
            Requests[313].RequestServices = CreateServices();
            Requests[313].Request.Method = "GET";
            Requests[313].Request.Path = "/providers/Microsoft.Web/publishingUsers/web";
            Requests[314] = new DefaultHttpContext();
            Requests[314].RequestServices = CreateServices();
            Requests[314].Request.Method = "GET";
            Requests[314].Request.Path = "/Tools/Chaos/$/Report";
            Requests[315] = new DefaultHttpContext();
            Requests[315].RequestServices = CreateServices();
            Requests[315].Request.Method = "POST";
            Requests[315].Request.Path = "/Tools/Chaos/$/Start";
            Requests[316] = new DefaultHttpContext();
            Requests[316].RequestServices = CreateServices();
            Requests[316].Request.Method = "POST";
            Requests[316].Request.Path = "/Tools/Chaos/$/Stop";
            Requests[317] = new DefaultHttpContext();
            Requests[317].RequestServices = CreateServices();
            Requests[317].Request.Method = "POST";
            Requests[317].Request.Path = "/contentmoderator/moderate/v1.0/ProcessImage/Evaluate";
            Requests[318] = new DefaultHttpContext();
            Requests[318].RequestServices = CreateServices();
            Requests[318].Request.Method = "POST";
            Requests[318].Request.Path = "/contentmoderator/moderate/v1.0/ProcessImage/FindFaces";
            Requests[319] = new DefaultHttpContext();
            Requests[319].RequestServices = CreateServices();
            Requests[319].Request.Method = "POST";
            Requests[319].Request.Path = "/contentmoderator/moderate/v1.0/ProcessImage/Match";
            Requests[320] = new DefaultHttpContext();
            Requests[320].RequestServices = CreateServices();
            Requests[320].Request.Method = "POST";
            Requests[320].Request.Path = "/contentmoderator/moderate/v1.0/ProcessImage/OCR";
            Requests[321] = new DefaultHttpContext();
            Requests[321].RequestServices = CreateServices();
            Requests[321].Request.Method = "POST";
            Requests[321].Request.Path = "/contentmoderator/moderate/v1.0/ProcessText/DetectLanguage";
            Requests[322] = new DefaultHttpContext();
            Requests[322].RequestServices = CreateServices();
            Requests[322].Request.Method = "POST";
            Requests[322].Request.Path = "/contentmoderator/moderate/v1.0/ProcessText/Screen";
            Requests[323] = new DefaultHttpContext();
            Requests[323].RequestServices = CreateServices();
            Requests[323].Request.Method = "GET";
            Requests[323].Request.Path = "/providers/microsoft.insights/eventtypes/management/values";
            Requests[324] = new DefaultHttpContext();
            Requests[324].RequestServices = CreateServices();
            Requests[324].Request.Method = "GET";
            Requests[324].Request.Path = "/contentmoderator/lists/v1.0/imagelists/25aa61";
            Requests[325] = new DefaultHttpContext();
            Requests[325].RequestServices = CreateServices();
            Requests[325].Request.Method = "PUT";
            Requests[325].Request.Path = "/contentmoderator/lists/v1.0/imagelists/0dcf18";
            Requests[326] = new DefaultHttpContext();
            Requests[326].RequestServices = CreateServices();
            Requests[326].Request.Method = "DELETE";
            Requests[326].Request.Path = "/contentmoderator/lists/v1.0/imagelists/4e479e";
            Requests[327] = new DefaultHttpContext();
            Requests[327].RequestServices = CreateServices();
            Requests[327].Request.Method = "GET";
            Requests[327].Request.Path = "/contentmoderator/lists/v1.0/termlists/2fba04";
            Requests[328] = new DefaultHttpContext();
            Requests[328].RequestServices = CreateServices();
            Requests[328].Request.Method = "DELETE";
            Requests[328].Request.Path = "/contentmoderator/lists/v1.0/termlists/6f112d";
            Requests[329] = new DefaultHttpContext();
            Requests[329].RequestServices = CreateServices();
            Requests[329].Request.Method = "PUT";
            Requests[329].Request.Path = "/contentmoderator/lists/v1.0/termlists/2704d5";
            Requests[330] = new DefaultHttpContext();
            Requests[330].RequestServices = CreateServices();
            Requests[330].Request.Method = "POST";
            Requests[330].Request.Path = "/contentmoderator/lists/v1.0/imagelists/413be3/images";
            Requests[331] = new DefaultHttpContext();
            Requests[331].RequestServices = CreateServices();
            Requests[331].Request.Method = "GET";
            Requests[331].Request.Path = "/contentmoderator/lists/v1.0/imagelists/46b449/images";
            Requests[332] = new DefaultHttpContext();
            Requests[332].RequestServices = CreateServices();
            Requests[332].Request.Method = "DELETE";
            Requests[332].Request.Path = "/contentmoderator/lists/v1.0/imagelists/9e2d1f/images";
            Requests[333] = new DefaultHttpContext();
            Requests[333].RequestServices = CreateServices();
            Requests[333].Request.Method = "POST";
            Requests[333].Request.Path = "/contentmoderator/lists/v1.0/imagelists/32b297/RefreshIndex";
            Requests[334] = new DefaultHttpContext();
            Requests[334].RequestServices = CreateServices();
            Requests[334].Request.Method = "POST";
            Requests[334].Request.Path = "/contentmoderator/lists/v1.0/termlists/4768ab/RefreshIndex";
            Requests[335] = new DefaultHttpContext();
            Requests[335].RequestServices = CreateServices();
            Requests[335].Request.Method = "GET";
            Requests[335].Request.Path = "/contentmoderator/lists/v1.0/termlists/3e9c6e/terms";
            Requests[336] = new DefaultHttpContext();
            Requests[336].RequestServices = CreateServices();
            Requests[336].Request.Method = "DELETE";
            Requests[336].Request.Path = "/contentmoderator/lists/v1.0/termlists/efd19d/terms";
            Requests[337] = new DefaultHttpContext();
            Requests[337].RequestServices = CreateServices();
            Requests[337].Request.Method = "POST";
            Requests[337].Request.Path = "/contentmoderator/review/v1.0/teams/d31cc2d7/jobs";
            Requests[338] = new DefaultHttpContext();
            Requests[338].RequestServices = CreateServices();
            Requests[338].Request.Method = "POST";
            Requests[338].Request.Path = "/contentmoderator/review/v1.0/teams/751e507c/reviews";
            Requests[339] = new DefaultHttpContext();
            Requests[339].RequestServices = CreateServices();
            Requests[339].Request.Method = "DELETE";
            Requests[339].Request.Path = "/contentmoderator/lists/v1.0/imagelists/f7b4a3/images/f12b023";
            Requests[340] = new DefaultHttpContext();
            Requests[340].RequestServices = CreateServices();
            Requests[340].Request.Method = "POST";
            Requests[340].Request.Path = "/contentmoderator/lists/v1.0/termlists/aa1aa0/terms/a9b7c";
            Requests[341] = new DefaultHttpContext();
            Requests[341].RequestServices = CreateServices();
            Requests[341].Request.Method = "DELETE";
            Requests[341].Request.Path = "/contentmoderator/lists/v1.0/termlists/f3f417/terms/35bb6";
            Requests[342] = new DefaultHttpContext();
            Requests[342].RequestServi