# System.Data.Common.CommandTrees.ExpressionBuilder

``` diff
+namespace System.Data.Common.CommandTrees.ExpressionBuilder {
+    public static class DbExpressionBuilder {
+        public static DbConstantExpression False { get; }
+        public static DbConstantExpression True { get; }
+        public static DbFunctionAggregate Aggregate(this EdmFunction function, DbExpression argument);
+        public static DbFunctionAggregate AggregateDistinct(this EdmFunction function, DbExpression argument);
+        public static DbQuantifierExpression All(this DbExpression source, Func<DbExpression, DbExpression> predicate);
+        public static DbQuantifierExpression All(this DbExpressionBinding input, DbExpression predicate);
+        public static DbAndExpression And(this DbExpression left, DbExpression right);
+        public static DbExpression Any(this DbExpression source);
+        public static DbQuantifierExpression Any(this DbExpression source, Func<DbExpression, DbExpression> predicate);
+        public static DbQuantifierExpression Any(this DbExpressionBinding input, DbExpression predicate);
+        public static KeyValuePair<string, DbAggregate> As(this DbAggregate value, string alias);
+        public static KeyValuePair<string, DbExpression> As(this DbExpression value, string alias);
+        public static DbExpressionBinding Bind(this DbExpression input);
+        public static DbExpressionBinding BindAs(this DbExpression input, string varName);
+        public static DbCaseExpression Case(IEnumerable<DbExpression> whenExpressions, IEnumerable<DbExpression> thenExpressions, DbExpression elseExpression);
+        public static DbCastExpression CastTo(this DbExpression argument, TypeUsage toType);
+        public static DbConstantExpression Constant(this TypeUsage constantType, object value);
+        public static DbConstantExpression Constant(object value);
+        public static DbRefExpression CreateRef(this EntitySet entitySet, IEnumerable<DbExpression> keyValues);
+        public static DbRefExpression CreateRef(this EntitySet entitySet, params DbExpression[] keyValues);
+        public static DbRefExpression CreateRef(this EntitySet entitySet, EntityType entityType, IEnumerable<DbExpression> keyValues);
+        public static DbRefExpression CreateRef(this EntitySet entitySet, EntityType entityType, params DbExpression[] keyValues);
+        public static DbApplyExpression CrossApply(this DbExpression source, Func<DbExpression, KeyValuePair<string, DbExpression>> apply);
+        public static DbApplyExpression CrossApply(this DbExpressionBinding input, DbExpressionBinding apply);
+        public static DbCrossJoinExpression CrossJoin(IEnumerable<DbExpressionBinding> inputs);
+        public static DbDerefExpression Deref(this DbExpression argument);
+        public static DbDistinctExpression Distinct(this DbExpression argument);
+        public static DbArithmeticExpression Divide(this DbExpression left, DbExpression right);
+        public static DbElementExpression Element(this DbExpression argument);
+        public static DbComparisonExpression Equal(this DbExpression left, DbExpression right);
+        public static DbExceptExpression Except(this DbExpression left, DbExpression right);
+        public static DbExpression Exists(this DbExpression argument);
+        public static DbFilterExpression Filter(this DbExpressionBinding input, DbExpression predicate);
+        public static DbJoinExpression FullOuterJoin(this DbExpression left, DbExpression right, Func<DbExpression, DbExpression, DbExpression> joinCondition);
+        public static DbJoinExpression FullOuterJoin(this DbExpressionBinding left, DbExpressionBinding right, DbExpression joinCondition);
+        public static DbEntityRefExpression GetEntityRef(this DbExpression argument);
+        public static DbRefKeyExpression GetRefKey(this DbExpression argument);
+        public static DbComparisonExpression GreaterThan(this DbExpression left, DbExpression right);
+        public static DbComparisonExpression GreaterThanOrEqual(this DbExpression left, DbExpression right);
+        public static DbGroupExpressionBinding GroupBind(this DbExpression input);
+        public static DbGroupExpressionBinding GroupBindAs(this DbExpression input, string varName, string groupVarName);
+        public static DbGroupByExpression GroupBy(this DbGroupExpressionBinding input, IEnumerable<KeyValuePair<string, DbExpression>> keys, IEnumerable<KeyValuePair<string, DbAggregate>> aggregates);
+        public static DbJoinExpression InnerJoin(this DbExpression left, DbExpression right, Func<DbExpression, DbExpression, DbExpression> joinCondition);
+        public static DbJoinExpression InnerJoin(this DbExpressionBinding left, DbExpressionBinding right, DbExpression joinCondition);
+        public static DbIntersectExpression Intersect(this DbExpression left, DbExpression right);
+        public static DbLambdaExpression Invoke(this DbLambda lambda, IEnumerable<DbExpression> arguments);
+        public static DbLambdaExpression Invoke(this DbLambda lambda, params DbExpression[] arguments);
+        public static DbFunctionExpression Invoke(this EdmFunction function, IEnumerable<DbExpression> arguments);
+        public static DbFunctionExpression Invoke(this EdmFunction function, params DbExpression[] arguments);
+        public static DbIsEmptyExpression IsEmpty(this DbExpression argument);
+        public static DbIsNullExpression IsNull(this DbExpression argument);
+        public static DbIsOfExpression IsOf(this DbExpression argument, TypeUsage type);
+        public static DbIsOfExpression IsOfOnly(this DbExpression argument, TypeUsage type);
+        public static DbJoinExpression Join(this DbExpression outer, DbExpression inner, Func<DbExpression, DbExpression> outerKey, Func<DbExpression, DbExpression> innerKey);
+        public static DbProjectExpression Join<TSelector>(this DbExpression outer, DbExpression inner, Func<DbExpression, DbExpression> outerKey, Func<DbExpression, DbExpression> innerKey, Func<DbExpression, DbExpression, TSelector> selector);
+        public static DbLambda Lambda(DbExpression body, IEnumerable<DbVariableReferenceExpression> variables);
+        public static DbLambda Lambda(DbExpression body, params DbVariableReferenceExpression[] variables);
+        public static DbJoinExpression LeftOuterJoin(this DbExpression left, DbExpression right, Func<DbExpression, DbExpression, DbExpression> joinCondition);
+        public static DbJoinExpression LeftOuterJoin(this DbExpressionBinding left, DbExpressionBinding right, DbExpression joinCondition);
+        public static DbComparisonExpression LessThan(this DbExpression left, DbExpression right);
+        public static DbComparisonExpression LessThanOrEqual(this DbExpression left, DbExpression right);
+        public static DbLikeExpression Like(this DbExpression argument, DbExpression pattern);
+        public static DbLikeExpression Like(this DbExpression argument, DbExpression pattern, DbExpression escape);
+        public static DbLimitExpression Limit(this DbExpression argument, DbExpression count);
+        public static DbArithmeticExpression Minus(this DbExpression left, DbExpression right);
+        public static DbArithmeticExpression Modulo(this DbExpression left, DbExpression right);
+        public static DbArithmeticExpression Multiply(this DbExpression left, DbExpression right);
+        public static DbRelationshipNavigationExpression Navigate(this DbExpression navigateFrom, RelationshipEndMember fromEnd, RelationshipEndMember toEnd);
+        public static DbRelationshipNavigationExpression Navigate(this RelationshipType type, string fromEndName, string toEndName, DbExpression navigateFrom);
+        public static DbArithmeticExpression Negate(this DbExpression argument);
+        public static DbNewInstanceExpression New(this TypeUsage instanceType, IEnumerable<DbExpression> arguments);
+        public static DbNewInstanceExpression New(this TypeUsage instanceType, params DbExpression[] arguments);
+        public static DbNewInstanceExpression NewCollection(IEnumerable<DbExpression> elements);
+        public static DbNewInstanceExpression NewCollection(params DbExpression[] elements);
+        public static DbNewInstanceExpression NewEmptyCollection(this TypeUsage collectionType);
+        public static DbNewInstanceExpression NewRow(IEnumerable<KeyValuePair<string, DbExpression>> columnValues);
+        public static DbNotExpression Not(this DbExpression argument);
+        public static DbComparisonExpression NotEqual(this DbExpression left, DbExpression right);
+        public static DbNullExpression Null(this TypeUsage nullType);
+        public static DbOfTypeExpression OfType(this DbExpression argument, TypeUsage type);
+        public static DbOfTypeExpression OfTypeOnly(this DbExpression argument, TypeUsage type);
+        public static DbOrExpression Or(this DbExpression left, DbExpression right);
+        public static DbSortExpression OrderBy(this DbExpression source, Func<DbExpression, DbExpression> sortKey);
+        public static DbSortExpression OrderBy(this DbExpression source, Func<DbExpression, DbExpression> sortKey, string collation);
+        public static DbSortExpression OrderByDescending(this DbExpression source, Func<DbExpression, DbExpression> sortKey);
+        public static DbSortExpression OrderByDescending(this DbExpression source, Func<DbExpression, DbExpression> sortKey, string collation);
+        public static DbApplyExpression OuterApply(this DbExpression source, Func<DbExpression, KeyValuePair<string, DbExpression>> apply);
+        public static DbApplyExpression OuterApply(this DbExpressionBinding input, DbExpressionBinding apply);
+        public static DbParameterReferenceExpression Parameter(this TypeUsage type, string name);
+        public static DbArithmeticExpression Plus(this DbExpression left, DbExpression right);
+        public static DbProjectExpression Project(this DbExpressionBinding input, DbExpression projection);
+        public static DbPropertyExpression Property(this DbExpression instance, EdmProperty propertyMetadata);
+        public static DbPropertyExpression Property(this DbExpression instance, NavigationProperty navigationProperty);
+        public static DbPropertyExpression Property(this DbExpression instance, RelationshipEndMember relationshipEnd);
+        public static DbPropertyExpression Property(this DbExpression instance, string propertyName);
+        public static DbRefExpression RefFromKey(this EntitySet entitySet, DbExpression keyRow);
+        public static DbRefExpression RefFromKey(this EntitySet entitySet, DbExpression keyRow, EntityType entityType);
+        public static DbScanExpression Scan(this EntitySetBase targetSet);
+        public static DbProjectExpression Select<TProjection>(this DbExpression source, Func<DbExpression, TProjection> projection);
+        public static DbProjectExpression SelectMany(this DbExpression source, Func<DbExpression, DbExpression> apply);
+        public static DbProjectExpression SelectMany<TSelector>(this DbExpression source, Func<DbExpression, DbExpression> apply, Func<DbExpression, DbExpression, TSelector> selector);
+        public static DbSkipExpression Skip(this DbExpressionBinding input, IEnumerable<DbSortClause> sortOrder, DbExpression count);
+        public static DbSkipExpression Skip(this DbSortExpression argument, DbExpression count);
+        public static DbSortExpression Sort(this DbExpressionBinding input, IEnumerable<DbSortClause> sortOrder);
+        public static DbLimitExpression Take(this DbExpression argument, DbExpression count);
+        public static DbSortExpression ThenBy(this DbSortExpression source, Func<DbExpression, DbExpression> sortKey);
+        public static DbSortExpression ThenBy(this DbSortExpression source, Func<DbExpression, DbExpression> sortKey, string collation);
+        public static DbSortExpression ThenByDescending(this DbSortExpression source, Func<DbExpression, DbExpression> sortKey);
+        public static DbSortExpression ThenByDescending(this DbSortExpression source, Func<DbExpression, DbExpression> sortKey, string collation);
+        public static DbSortClause ToSortClause(this DbExpression key);
+        public static DbSortClause ToSortClause(this DbExpression key, string collation);
+        public static DbSortClause ToSortClauseDescending(this DbExpression key);
+        public static DbSortClause ToSortClauseDescending(this DbExpression key, string collation);
+        public static DbTreatExpression TreatAs(this DbExpression argument, TypeUsage treatType);
+        public static DbArithmeticExpression UnaryMinus(this DbExpression argument);
+        public static DbExpression Union(this DbExpression left, DbExpression right);
+        public static DbUnionAllExpression UnionAll(this DbExpression left, DbExpression right);
+        public static DbVariableReferenceExpression Variable(this TypeUsage type, string name);
+        public static DbFilterExpression Where(this DbExpression source, Func<DbExpression, DbExpression> predicate);
+    }
+    public static class EdmFunctions {
+        public static DbFunctionExpression Abs(this DbExpression value);
+        public static DbFunctionExpression AddDays(this DbExpression dateValue, DbExpression addValue);
+        public static DbFunctionExpression AddHours(this DbExpression timeValue, DbExpression addValue);
+        public static DbFunctionExpression AddMicroseconds(this DbExpression timeValue, DbExpression addValue);
+        public static DbFunctionExpression AddMilliseconds(this DbExpression timeValue, DbExpression addValue);
+        public static DbFunctionExpression AddMinutes(this DbExpression timeValue, DbExpression addValue);
+        public static DbFunctionExpression AddMonths(this DbExpression dateValue, DbExpression addValue);
+        public static DbFunctionExpression AddNanoseconds(this DbExpression timeValue, DbExpression addValue);
+        public static DbFunctionExpression AddSeconds(this DbExpression timeValue, DbExpression addValue);
+        public static DbFunctionExpression AddYears(this DbExpression dateValue, DbExpression addValue);
+        public static DbFunctionExpression Average(this DbExpression collection);
+        public static DbFunctionExpression BitwiseAnd(this DbExpression value1, DbExpression value2);
+        public static DbFunctionExpression BitwiseNot(this DbExpression value);
+        public static DbFunctionExpression BitwiseOr(this DbExpression value1, DbExpression value2);
+        public static DbFunctionExpression BitwiseXor(this DbExpression value1, DbExpression value2);
+        public static DbFunctionExpression Ceiling(this DbExpression value);
+        public static DbFunctionExpression Concat(this DbExpression string1, DbExpression string2);
+        public static DbExpression Contains(this DbExpression searchedString, DbExpression searchedForString);
+        public static DbFunctionExpression Count(this DbExpression collection);
+        public static DbFunctionExpression CreateDateTime(DbExpression year, DbExpression month, DbExpression day, DbExpression hour, DbExpression minute, DbExpression second);
+        public static DbFunctionExpression CreateDateTimeOffset(DbExpression year, DbExpression month, DbExpression day, DbExpression hour, DbExpression minute, DbExpression second, DbExpression timeZoneOffset);
+        public static DbFunctionExpression CreateTime(DbExpression hour, DbExpression minute, DbExpression second);
+        public static DbFunctionExpression CurrentDateTime();
+        public static DbFunctionExpression CurrentDateTimeOffset();
+        public static DbFunctionExpression CurrentUtcDateTime();
+        public static DbFunctionExpression Day(this DbExpression dateValue);
+        public static DbFunctionExpression DayOfYear(this DbExpression dateValue);
+        public static DbFunctionExpression DiffDays(this DbExpression dateValue1, DbExpression dateValue2);
+        public static DbFunctionExpression DiffHours(this DbExpression timeValue1, DbExpression timeValue2);
+        public static DbFunctionExpression DiffMicroseconds(this DbExpression timeValue1, DbExpression timeValue2);
+        public static DbFunctionExpression DiffMilliseconds(this DbExpression timeValue1, DbExpression timeValue2);
+        public static DbFunctionExpression DiffMinutes(this DbExpression timeValue1, DbExpression timeValue2);
+        public static DbFunctionExpression DiffMonths(this DbExpression dateValue1, DbExpression dateValue2);
+        public static DbFunctionExpression DiffNanoseconds(this DbExpression timeValue1, DbExpression timeValue2);
+        public static DbFunctionExpression DiffSeconds(this DbExpression timeValue1, DbExpression timeValue2);
+        public static DbFunctionExpression DiffYears(this DbExpression dateValue1, DbExpression dateValue2);
+        public static DbFunctionExpression EndsWith(this DbExpression stringArgument, DbExpression suffix);
+        public static DbFunctionExpression Floor(this DbExpression value);
+        public static DbFunctionExpression GetTotalOffsetMinutes(this DbExpression dateTimeOffsetArgument);
+        public static DbFunctionExpression Hour(this DbExpression timeValue);
+        public static DbFunctionExpression IndexOf(this DbExpression searchString, DbExpression stringToFind);
+        public static DbFunctionExpression Left(this DbExpression stringArgument, DbExpression length);
+        public static DbFunctionExpression Length(this DbExpression stringArgument);
+        public static DbFunctionExpression LongCount(this DbExpression collection);
+        public static DbFunctionExpression Max(this DbExpression collection);
+        public static DbFunctionExpression Millisecond(this DbExpression timeValue);
+        public static DbFunctionExpression Min(this DbExpression collection);
+        public static DbFunctionExpression Minute(this DbExpression timeValue);
+        public static DbFunctionExpression Month(this DbExpression dateValue);
+        public static DbFunctionExpression NewGuid();
+        public static DbFunctionExpression Power(this DbExpression baseArgument, DbExpression exponent);
+        public static DbFunctionExpression Replace(this DbExpression stringArgument, DbExpression toReplace, DbExpression replacement);
+        public static DbFunctionExpression Reverse(this DbExpression stringArgument);
+        public static DbFunctionExpression Right(this DbExpression stringArgument, DbExpression length);
+        public static DbFunctionExpression Round(this DbExpression value);
+        public static DbFunctionExpression Round(this DbExpression value, DbExpression digits);
+        public static DbFunctionExpression Second(this DbExpression timeValue);
+        public static DbFunctionExpression StartsWith(this DbExpression stringArgument, DbExpression prefix);
+        public static DbFunctionExpression StDev(this DbExpression collection);
+        public static DbFunctionExpression StDevP(this DbExpression collection);
+        public static DbFunctionExpression Substring(this DbExpression stringArgument, DbExpression start, DbExpression length);
+        public static DbFunctionExpression Sum(this DbExpression collection);
+        public static DbFunctionExpression ToLower(this DbExpression stringArgument);
+        public static DbFunctionExpression ToUpper(this DbExpression stringArgument);
+        public static DbFunctionExpression Trim(this DbExpression stringArgument);
+        public static DbFunctionExpression TrimEnd(this DbExpression stringArgument);
+        public static DbFunctionExpression TrimStart(this DbExpression stringArgument);
+        public static DbFunctionExpression Truncate(this DbExpression value, DbExpression digits);
+        public static DbFunctionExpression TruncateTime(this DbExpression dateValue);
+        public static DbFunctionExpression Var(this DbExpression collection);
+        public static DbFunctionExpression VarP(this DbExpression collection);
+        public static DbFunctionExpression Year(this DbExpression dateValue);
+    }
+    public sealed class Row {
+        public Row(KeyValuePair<string, DbExpression> columnValue, params KeyValuePair<string, DbExpression>[] columnValues);
+        public static implicit operator DbExpression (Row row);
+        public DbNewInstanceExpression ToExpression();
+    }
+}
```

