# System.Data.Common

``` diff
+namespace System.Data.Common {
+    public abstract class DbColumn {
+        protected DbColumn();
+        public Nullable<bool> AllowDBNull { get; protected set; }
+        public string BaseCatalogName { get; protected set; }
+        public string BaseColumnName { get; protected set; }
+        public string BaseSchemaName { get; protected set; }
+        public string BaseServerName { get; protected set; }
+        public string BaseTableName { get; protected set; }
+        public string ColumnName { get; protected set; }
+        public Nullable<int> ColumnOrdinal { get; protected set; }
+        public Nullable<int> ColumnSize { get; protected set; }
+        public Type DataType { get; protected set; }
+        public string DataTypeName { get; protected set; }
+        public Nullable<bool> IsAliased { get; protected set; }
+        public Nullable<bool> IsAutoIncrement { get; protected set; }
+        public Nullable<bool> IsExpression { get; protected set; }
+        public Nullable<bool> IsHidden { get; protected set; }
+        public Nullable<bool> IsIdentity { get; protected set; }
+        public Nullable<bool> IsKey { get; protected set; }
+        public Nullable<bool> IsLong { get; protected set; }
+        public Nullable<bool> IsReadOnly { get; protected set; }
+        public Nullable<bool> IsUnique { get; protected set; }
+        public Nullable<int> NumericPrecision { get; protected set; }
+        public Nullable<int> NumericScale { get; protected set; }
+        public virtual object this[string property] { get; }
+        public string UdtAssemblyQualifiedName { get; protected set; }
+    }
+    public abstract class DbCommand : IDbCommand, IDisposable {
+        protected DbCommand();
+        public abstract string CommandText { get; set; }
+        public abstract int CommandTimeout { get; set; }
+        public abstract CommandType CommandType { get; set; }
+        public DbConnection Connection { get; set; }
+        protected abstract DbConnection DbConnection { get; set; }
+        protected abstract DbParameterCollection DbParameterCollection { get; }
+        protected abstract DbTransaction DbTransaction { get; set; }
+        public abstract bool DesignTimeVisible { get; set; }
+        public DbParameterCollection Parameters { get; }
+        IDbConnection System.Data.IDbCommand.Connection { get; set; }
+        IDataParameterCollection System.Data.IDbCommand.Parameters { get; }
+        IDbTransaction System.Data.IDbCommand.Transaction { get; set; }
+        public DbTransaction Transaction { get; set; }
+        public abstract UpdateRowSource UpdatedRowSource { get; set; }
+        public abstract void Cancel();
+        protected abstract DbParameter CreateDbParameter();
+        public DbParameter CreateParameter();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected abstract DbDataReader ExecuteDbDataReader(CommandBehavior behavior);
+        protected virtual Task<DbDataReader> ExecuteDbDataReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public abstract int ExecuteNonQuery();
+        public Task<int> ExecuteNonQueryAsync();
+        public virtual Task<int> ExecuteNonQueryAsync(CancellationToken cancellationToken);
+        public DbDataReader ExecuteReader();
+        public DbDataReader ExecuteReader(CommandBehavior behavior);
+        public Task<DbDataReader> ExecuteReaderAsync();
+        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior);
+        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public Task<DbDataReader> ExecuteReaderAsync(CancellationToken cancellationToken);
+        public abstract object ExecuteScalar();
+        public Task<object> ExecuteScalarAsync();
+        public virtual Task<object> ExecuteScalarAsync(CancellationToken cancellationToken);
+        public abstract void Prepare();
+        IDbDataParameter System.Data.IDbCommand.CreateParameter();
+        IDataReader System.Data.IDbCommand.ExecuteReader();
+        IDataReader System.Data.IDbCommand.ExecuteReader(CommandBehavior behavior);
+    }
+    public abstract class DbConnection : IDbConnection, IDisposable {
+        protected DbConnection();
+        public abstract string ConnectionString { get; set; }
+        public virtual int ConnectionTimeout { get; }
+        public abstract string Database { get; }
+        public abstract string DataSource { get; }
+        public abstract string ServerVersion { get; }
+        public abstract ConnectionState State { get; }
+        public virtual event StateChangeEventHandler StateChange;
+        protected abstract DbTransaction BeginDbTransaction(IsolationLevel isolationLevel);
+        public DbTransaction BeginTransaction();
+        public DbTransaction BeginTransaction(IsolationLevel isolationLevel);
+        public abstract void ChangeDatabase(string databaseName);
+        public abstract void Close();
+        public DbCommand CreateCommand();
+        protected abstract DbCommand CreateDbCommand();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        protected virtual void OnStateChange(StateChangeEventArgs stateChange);
+        public abstract void Open();
+        public Task OpenAsync();
+        public virtual Task OpenAsync(CancellationToken cancellationToken);
+        IDbTransaction System.Data.IDbConnection.BeginTransaction();
+        IDbTransaction System.Data.IDbConnection.BeginTransaction(IsolationLevel isolationLevel);
+        IDbCommand System.Data.IDbConnection.CreateCommand();
+    }
+    public class DbConnectionStringBuilder : ICollection, IDictionary, IEnumerable {
+        public DbConnectionStringBuilder();
+        public string ConnectionString { get; set; }
+        public virtual int Count { get; }
+        public virtual ICollection Keys { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        object System.Collections.ICollection.SyncRoot { get; }
+        bool System.Collections.IDictionary.IsFixedSize { get; }
+        bool System.Collections.IDictionary.IsReadOnly { get; }
+        object System.Collections.IDictionary.this[object keyword] { get; set; }
+        public virtual object this[string keyword] { get; set; }
+        public virtual ICollection Values { get; }
+        public void Add(string keyword, object value);
+        public static void AppendKeyValuePair(StringBuilder builder, string keyword, string value);
+        public virtual void Clear();
+        public virtual bool ContainsKey(string keyword);
+        public virtual bool EquivalentTo(DbConnectionStringBuilder connectionStringBuilder);
+        public virtual bool Remove(string keyword);
+        public virtual bool ShouldSerialize(string keyword);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
+        void System.Collections.IDictionary.Add(object keyword, object value);
+        bool System.Collections.IDictionary.Contains(object keyword);
+        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
+        void System.Collections.IDictionary.Remove(object keyword);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public override string ToString();
+        public virtual bool TryGetValue(string keyword, out object value);
+    }
+    public abstract class DbDataReader : IDataReader, IDataRecord, IDisposable, IEnumerable {
+        protected DbDataReader();
+        public abstract int Depth { get; }
+        public abstract int FieldCount { get; }
+        public abstract bool HasRows { get; }
+        public abstract bool IsClosed { get; }
+        public abstract int RecordsAffected { get; }
+        public abstract object this[int ordinal] { get; }
+        public abstract object this[string name] { get; }
+        public virtual int VisibleFieldCount { get; }
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract bool GetBoolean(int ordinal);
+        public abstract byte GetByte(int ordinal);
+        public abstract long GetBytes(int ordinal, long dataOffset, byte[] buffer, int bufferOffset, int length);
+        public abstract char GetChar(int ordinal);
+        public abstract long GetChars(int ordinal, long dataOffset, char[] buffer, int bufferOffset, int length);
+        public DbDataReader GetData(int ordinal);
+        public abstract string GetDataTypeName(int ordinal);
+        public abstract DateTime GetDateTime(int ordinal);
+        protected virtual DbDataReader GetDbDataReader(int ordinal);
+        public abstract decimal GetDecimal(int ordinal);
+        public abstract double GetDouble(int ordinal);
+        public abstract IEnumerator GetEnumerator();
+        public abstract Type GetFieldType(int ordinal);
+        public virtual T GetFieldValue<T>(int ordinal);
+        public Task<T> GetFieldValueAsync<T>(int ordinal);
+        public virtual Task<T> GetFieldValueAsync<T>(int ordinal, CancellationToken cancellationToken);
+        public abstract float GetFloat(int ordinal);
+        public abstract Guid GetGuid(int ordinal);
+        public abstract short GetInt16(int ordinal);
+        public abstract int GetInt32(int ordinal);
+        public abstract long GetInt64(int ordinal);
+        public abstract string GetName(int ordinal);
+        public abstract int GetOrdinal(string name);
+        public virtual Type GetProviderSpecificFieldType(int ordinal);
+        public virtual object GetProviderSpecificValue(int ordinal);
+        public virtual int GetProviderSpecificValues(object[] values);
+        public virtual Stream GetStream(int ordinal);
+        public abstract string GetString(int ordinal);
+        public virtual TextReader GetTextReader(int ordinal);
+        public abstract object GetValue(int ordinal);
+        public abstract int GetValues(object[] values);
+        public abstract bool IsDBNull(int ordinal);
+        public Task<bool> IsDBNullAsync(int ordinal);
+        public virtual Task<bool> IsDBNullAsync(int ordinal, CancellationToken cancellationToken);
+        public abstract bool NextResult();
+        public Task<bool> NextResultAsync();
+        public virtual Task<bool> NextResultAsync(CancellationToken cancellationToken);
+        public abstract bool Read();
+        public Task<bool> ReadAsync();
+        public virtual Task<bool> ReadAsync(CancellationToken cancellationToken);
+        void System.Data.IDataReader.Close();
+        DataTable System.Data.IDataReader.GetSchemaTable();
+        IDataReader System.Data.IDataRecord.GetData(int ordinal);
+    }
+    public static class DbDataReaderExtensions {
+        public static bool CanGetColumnSchema(this DbDataReader reader);
+        public static ReadOnlyCollection<DbColumn> GetColumnSchema(this DbDataReader reader);
+    }
+    public abstract class DbDataRecord : IDataRecord {
+        protected DbDataRecord();
+        public abstract int FieldCount { get; }
+        public abstract object this[int i] { get; }
+        public abstract object this[string name] { get; }
+        public abstract bool GetBoolean(int i);
+        public abstract byte GetByte(int i);
+        public abstract long GetBytes(int i, long dataIndex, byte[] buffer, int bufferIndex, int length);
+        public abstract char GetChar(int i);
+        public abstract long GetChars(int i, long dataIndex, char[] buffer, int bufferIndex, int length);
+        public IDataReader GetData(int i);
+        public abstract string GetDataTypeName(int i);
+        public abstract DateTime GetDateTime(int i);
+        protected virtual DbDataReader GetDbDataReader(int i);
+        public abstract decimal GetDecimal(int i);
+        public abstract double GetDouble(int i);
+        public abstract Type GetFieldType(int i);
+        public abstract float GetFloat(int i);
+        public abstract Guid GetGuid(int i);
+        public abstract short GetInt16(int i);
+        public abstract int GetInt32(int i);
+        public abstract long GetInt64(int i);
+        public abstract string GetName(int i);
+        public abstract int GetOrdinal(string name);
+        public abstract string GetString(int i);
+        public abstract object GetValue(int i);
+        public abstract int GetValues(object[] values);
+        public abstract bool IsDBNull(int i);
+    }
+    public class DbEnumerator : IEnumerator {
+        public DbEnumerator(IDataReader reader, bool closeReader);
+        public object Current { get; }
+        public bool MoveNext();
+        public void Reset();
+    }
+    public abstract class DbException : Exception {
+        protected DbException();
+        protected DbException(string message);
+        protected DbException(string message, Exception innerException);
+    }
+    public abstract class DbParameter : IDataParameter, IDbDataParameter {
+        protected DbParameter();
+        public abstract DbType DbType { get; set; }
+        public abstract ParameterDirection Direction { get; set; }
+        public abstract bool IsNullable { get; set; }
+        public abstract string ParameterName { get; set; }
+        public virtual byte Precision { get; set; }
+        public virtual byte Scale { get; set; }
+        public abstract int Size { get; set; }
+        public abstract string SourceColumn { get; set; }
+        public abstract bool SourceColumnNullMapping { get; set; }
+        DataRowVersion System.Data.IDataParameter.SourceVersion { get; set; }
+        byte System.Data.IDbDataParameter.Precision { get; set; }
+        byte System.Data.IDbDataParameter.Scale { get; set; }
+        public abstract object Value { get; set; }
+        public abstract void ResetDbType();
+    }
+    public abstract class DbParameterCollection : ICollection, IDataParameterCollection, IEnumerable, IList {
+        protected DbParameterCollection();
+        public abstract int Count { get; }
+        public abstract object SyncRoot { get; }
+        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool System.Collections.IList.IsFixedSize { get; }
+        bool System.Collections.IList.IsReadOnly { get; }
+        object System.Collections.IList.this[int index] { get; set; }
+        object System.Data.IDataParameterCollection.this[string parameterName] { get; set; }
+        public DbParameter this[int index] { get; set; }
+        public DbParameter this[string parameterName] { get; set; }
+        public abstract int Add(object value);
+        public abstract void AddRange(Array values);
+        public abstract void Clear();
+        public abstract bool Contains(object value);
+        public abstract bool Contains(string value);
+        public abstract void CopyTo(Array array, int index);
+        public abstract IEnumerator GetEnumerator();
+        protected abstract DbParameter GetParameter(int index);
+        protected abstract DbParameter GetParameter(string parameterName);
+        public abstract int IndexOf(object value);
+        public abstract int IndexOf(string parameterName);
+        public abstract void Insert(int index, object value);
+        public abstract void Remove(object value);
+        public abstract void RemoveAt(int index);
+        public abstract void RemoveAt(string parameterName);
+        protected abstract void SetParameter(int index, DbParameter value);
+        protected abstract void SetParameter(string parameterName, DbParameter value);
+    }
+    public abstract class DbProviderFactory {
+        protected DbProviderFactory();
+        public virtual DbCommand CreateCommand();
+        public virtual DbConnection CreateConnection();
+        public virtual DbConnectionStringBuilder CreateConnectionStringBuilder();
+        public virtual DbParameter CreateParameter();
+    }
+    public abstract class DbTransaction : IDbTransaction, IDisposable {
+        protected DbTransaction();
+        public DbConnection Connection { get; }
+        protected abstract DbConnection DbConnection { get; }
+        public abstract IsolationLevel IsolationLevel { get; }
+        IDbConnection System.Data.IDbTransaction.Connection { get; }
+        public abstract void Commit();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public abstract void Rollback();
+    }
+    public interface IDbColumnSchemaGenerator {
+        ReadOnlyCollection<DbColumn> GetColumnSchema();
+    }
+}
```

